"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Defines listener for a VirtualNode.
 *
 * @experimental
 */
class VirtualNodeListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     *
     * @experimental
     */
    static http(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     *
     * @experimental
     */
    static http2(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     *
     * @experimental
     */
    static grpc(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     *
     * @experimental
     */
    static tcp(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.105.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tlsCertificate, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tlsCertificate = tlsCertificate;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        var _b, _c;
        const tlsConfig = (_b = this.tlsCertificate) === null || _b === void 0 ? void 0 : _b.bind(scope);
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_c = this.healthCheck) === null || _c === void 0 ? void 0 : _c.bind(scope, { defaultPort: this.port }).virtualNodeHealthCheck,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: tlsConfig ? this.renderTls(tlsConfig) : undefined,
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    /**
     * Renders the TLS config for a listener
     */
    renderTls(tlsCertificateConfig) {
        return {
            certificate: tlsCertificateConfig.tlsCertificate,
            mode: tlsCertificateConfig.tlsMode.toString(),
        };
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                } : undefined,
                perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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