"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tlsCertificate, options.connectionPool);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tlsCertificate, options.connectionPool);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpc(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tlsCertificate, options.connectionPool);
    }
}
exports.VirtualGatewayListener = VirtualGatewayListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualGatewayListener", version: "1.105.0" };
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, tlsCertificate, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.tlsCertificate = tlsCertificate;
        this.connectionPool = connectionPool;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        var _b, _c;
        const tlsConfig = (_b = this.tlsCertificate) === null || _b === void 0 ? void 0 : _b.bind(scope);
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_c = this.healthCheck) === null || _c === void 0 ? void 0 : _c.bind(scope, { defaultPort: this.port }).virtualGatewayHealthCheck,
                tls: tlsConfig ? renderTls(tlsConfig) : undefined,
                connectionPool: this.connectionPool ? renderConnectionPool(this.connectionPool, this.protocol) : undefined,
            },
        };
    }
}
/**
 * Renders the TLS config for a listener
 */
function renderTls(tlsCertificateConfig) {
    return {
        certificate: tlsCertificateConfig.tlsCertificate,
        mode: tlsCertificateConfig.tlsMode.toString(),
    };
}
function renderConnectionPool(connectionPool, listenerProtocol) {
    return ({
        [listenerProtocol]: {
            maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
            maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
            maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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