"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Backend = exports.AccessLog = exports.Protocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (deprecated) Enum of supported AppMesh protocols.
 *
 * @deprecated not for use outside package
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "http";
    Protocol["TCP"] = "tcp";
    Protocol["HTTP2"] = "http2";
    Protocol["GRPC"] = "grpc";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * (experimental) Configuration for Envoy Access logs for mesh endpoints.
 *
 * @experimental
 */
class AccessLog {
    /**
     * (experimental) Path to a file to write access logs to.
     *
     * @default - no file based access logging
     * @experimental
     */
    static fromFilePath(filePath) {
        return new FileAccessLog(filePath);
    }
}
exports.AccessLog = AccessLog;
_a = JSII_RTTI_SYMBOL_1;
AccessLog[_a] = { fqn: "@aws-cdk/aws-appmesh.AccessLog", version: "1.105.0" };
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class FileAccessLog extends AccessLog {
    constructor(filePath) {
        super();
        this.filePath = filePath;
    }
    bind(_scope) {
        return {
            virtualNodeAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
            virtualGatewayAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
        };
    }
}
/**
 * (experimental) Contains static factory methods to create backends.
 *
 * @experimental
 */
class Backend {
    /**
     * (experimental) Construct a Virtual Service backend.
     *
     * @experimental
     */
    static virtualService(virtualService, props = {}) {
        return new VirtualServiceBackend(virtualService, props.clientPolicy);
    }
}
exports.Backend = Backend;
_b = JSII_RTTI_SYMBOL_1;
Backend[_b] = { fqn: "@aws-cdk/aws-appmesh.Backend", version: "1.105.0" };
/**
 * Represents the properties needed to define a Virtual Service backend
 */
class VirtualServiceBackend extends Backend {
    constructor(virtualService, clientPolicy) {
        super();
        this.virtualService = virtualService;
        this.clientPolicy = clientPolicy;
    }
    /**
     * Return config for a Virtual Service backend
     */
    bind(_scope) {
        var _c;
        return {
            virtualServiceBackend: {
                virtualService: {
                    virtualServiceName: this.virtualService.virtualServiceName,
                    clientPolicy: (_c = this.clientPolicy) === null || _c === void 0 ? void 0 : _c.bind(_scope).clientPolicy,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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