import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as s3 from '@aws-cdk/aws-s3';
import { Duration } from '@aws-cdk/core';
import { Action } from '../action';
import { Construct } from '@aws-cdk/core';
/**
 * Used for HTTP cache-control header, which influences downstream caches.
 *
 * Use the provided static factory methods to construct instances of this class.
 * Used in the {@link S3DeployActionProps.cacheControl} property.
 *
 * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9
 * @stability stable
 */
export declare class CacheControl {
    value: string;
    /**
     * The 'must-revalidate' cache control directive.
     *
     * @stability stable
     */
    static mustRevalidate(): CacheControl;
    /**
     * The 'no-cache' cache control directive.
     *
     * @stability stable
     */
    static noCache(): CacheControl;
    /**
     * The 'no-transform' cache control directive.
     *
     * @stability stable
     */
    static noTransform(): CacheControl;
    /**
     * The 'public' cache control directive.
     *
     * @stability stable
     */
    static setPublic(): CacheControl;
    /**
     * The 'private' cache control directive.
     *
     * @stability stable
     */
    static setPrivate(): CacheControl;
    /**
     * The 'proxy-revalidate' cache control directive.
     *
     * @stability stable
     */
    static proxyRevalidate(): CacheControl;
    /**
     * The 'max-age' cache control directive.
     *
     * @stability stable
     */
    static maxAge(t: Duration): CacheControl;
    /**
     * The 's-max-age' cache control directive.
     *
     * @stability stable
     */
    static sMaxAge(t: Duration): CacheControl;
    /**
     * Allows you to create an arbitrary cache control directive, in case our support is missing a method for a particular directive.
     *
     * @stability stable
     */
    static fromString(s: string): CacheControl;
    /** @param value the actual text value of the created directive */
    private constructor();
}
/**
 * Construction properties of the {@link S3DeployAction S3 deploy Action}.
 *
 * @stability stable
 */
export interface S3DeployActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * Should the deploy action extract the artifact before deploying to Amazon S3.
     *
     * @default true
     * @stability stable
     */
    readonly extract?: boolean;
    /**
     * The key of the target object.
     *
     * This is required if extract is false.
     *
     * @stability stable
     */
    readonly objectKey?: string;
    /**
     * The input Artifact to deploy to Amazon S3.
     *
     * @stability stable
     */
    readonly input: codepipeline.Artifact;
    /**
     * The Amazon S3 bucket that is the deploy target.
     *
     * @stability stable
     */
    readonly bucket: s3.IBucket;
    /**
     * The specified canned ACL to objects deployed to Amazon S3.
     *
     * This overwrites any existing ACL that was applied to the object.
     *
     * @default - the original object ACL
     * @stability stable
     */
    readonly accessControl?: s3.BucketAccessControl;
    /**
     * The caching behavior for requests/responses for objects in the bucket.
     *
     * The final cache control property will be the result of joining all of the provided array elements with a comma
     * (plus a space after the comma).
     *
     * @default - none, decided by the HTTP client
     * @stability stable
     */
    readonly cacheControl?: CacheControl[];
}
/**
 * Deploys the sourceArtifact to Amazon S3.
 *
 * @stability stable
 */
export declare class S3DeployAction extends Action {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: S3DeployActionProps);
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
