# Generated by Django 3.1.7 on 2021-03-21 15:23

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AggVisits',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.IntegerField(verbose_name='uid')),
                ('visits', models.IntegerField(default=0)),
                ('date', models.DateTimeField(blank=True, null=True, verbose_name='date')),
            ],
        ),
        migrations.CreateModel(
            name='Clients',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=True, verbose_name='Aktiv')),
                ('name', models.CharField(blank=True, default='', max_length=200, verbose_name='Namn')),
                ('company', models.CharField(blank=True, default='', max_length=200, verbose_name='Företag')),
                ('phone', models.CharField(blank=True, default='', max_length=20, verbose_name='Telefon')),
                ('email', models.CharField(blank=True, default='', max_length=100, verbose_name='E-postadress')),
                ('org_number', models.CharField(blank=True, default='', max_length=10, verbose_name='Org nummer')),
                ('position', models.CharField(blank=True, default='', max_length=100, verbose_name='Title')),
                ('selected_client', models.BooleanField(blank=True, default=False, verbose_name='Utvald kund')),
                ('last_7_days_visits', models.IntegerField(default=0, verbose_name='Besök - sista 7 dagar')),
                ('last_30_days_visits', models.IntegerField(default=0, verbose_name='Besök - sista 30 dagar')),
                ('all_visits', models.IntegerField(default=0, verbose_name='Alla besök')),
                ('last_visit', models.DateTimeField(blank=True, null=True, verbose_name='Sista besök')),
                ('uid', models.IntegerField(unique=True, verbose_name='UID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Kund',
                'verbose_name_plural': 'Kunder',
            },
        ),
        migrations.CreateModel(
            name='Visits',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.IntegerField(verbose_name='uid')),
                ('url', models.CharField(max_length=255, verbose_name='URL')),
                ('created_at', models.DateTimeField(verbose_name='Skapat')),
            ],
            options={
                'verbose_name': 'Besökta sidan',
                'verbose_name_plural': 'Besökta sidor',
            },
        ),
        migrations.CreateModel(
            name='ClientHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(choices=[('RG', 'Telefonsamtal'), ('EM', 'Skickat email'), ('RE', 'Svar'), ('AV', 'Avregistera'), ('AN', 'Annat')], default='RG', max_length=15, verbose_name='Aktion')),
                ('note', models.TextField(blank=True, default='', verbose_name='Anteckingar')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('client', models.ForeignKey(default='', on_delete=django.db.models.deletion.CASCADE, related_name='get_history_for_client', to='django_reaktion_crm.clients')),
            ],
            options={
                'verbose_name': 'Historik',
                'verbose_name_plural': 'Historik',
            },
        ),
    ]
