![Build and update wrappers](https://github.com/INTO-CPS-Association/unifmu/workflows/Build%20and%20update%20wrappers/badge.svg)

Universal Functional Mock-Up Unit (UniFMU)

To successfully integrate FMI based co-simulation into a development process a model should be easy to create and modify.
In some cases a modelling tool may be available that provide the exact modelling capabilities needed.
However, there may be cases where existing tools are not suitable, or their cost prohibitive, in case of commercial tools.

UniFMU makes it possible to implement FMUs in any language, by writing a small a adapter for the particular language.
UniFMU also provides a GUI and CLI tool for generating new FMUs from a selection of languages.

Currently, the following languages are supported out of the box:

- Python
- C#
- Matlab

# Installing the tool

The command line interface is written in python and can be installed using pip, as follows:

```bash
python -m pip install unifmu
```

Additional dependencies are needed for the GUI components and for development purposes.
All additional dependencies can be installed using, the _dev_ switch

```bash
python -m pip install "unifmu[dev]"
```

Alternatively, more fine grained control of what dependencies are installed are provided by the flags below:

| Flag name                  | What features it enables                                        |
| -------------------------- | --------------------------------------------------------------- |
| python-backend             | runtime dependencies of FMUs implemented in python using UniFMU |
| gui                        | WxPython components necessary to run GUI                        |
| protobuf-schema-generation | schema generation for grpc                                      |
| docs                       | building sphinx docs                                            |
| setuptools                 | building and distributing UniFMU using pip                      |
| dev                        | installs all the above                                          |

For example, to install runtime dependencies used by an python FMU generated by UniFMU:

```bash
python -m pip install "unifmu[python-backend]"
```

## Linux GUI dependencies

You may need to install the following dependencies:

```
libgtk-3-dev
libsdl2-dev
```

For unix based platforms it is recommended to use the [prebuilt binaries](https://wxpython.org/pages/downloads/) to install wxpython. If the prebuilt binaries for wxpython are not used the installation of unifmu will take much longer.

Install wxpython for your distribution by invoking the following command, where the 'ubuntu-20.04'-part is replaced with your distro:

```bash
python -m pip install -f https://extras.wxpython.org/wxPython4/extras/linux/gtk3/ubuntu-20.04 wxPython
```

# How to use the command line interface?

After the tool has been installed it can be accessed by typing `unifmu` in a shell.
To display the synopsis use the `--help` flag.

```bash
> unifmu --help
usage: unifmu [-h] {gui,generate} ...

Utility tool for creating and editing FMUs for FMI based co-simulation

positional arguments:
  {gui,generate}
    gui           open graphical user interface
    generate      create a new FMU using a specified language-backend

optional arguments:
  -h, --help      show this help message and exit
```

The command uses _git-style_ subcommands such as `generate` and `gui`.
Help for the individual commands can be inquired by appending the `--help` after the name of the subcommand.

```
unifmu generate --help
usage: unifmu generate [-h] [--dockerize] {empty,matlab,python,csharp,java} outdir

positional arguments:
  {empty,matlab,python,csharp,java}
                        the language adapter copied into the FMU
  outdir                directory into which the FMU's resources are written (new directories will be created if needed)

optional arguments:
  -h, --help            show this help message and exit
  --dockerize           enable docker support for FMU
```

The generate command can be used to create a new FMU:

```bash
unifmu generate python model
```

The command generates a fully functional FMU implemented in the specific language.
The generated file structure depends on the specific language.
For example the tree below shows the default FMU generated when implementing an FMU in python using UniFMU:

```python
📦model
 ┣ 📂binaries # pre-built binaries for different OSs
 ┃ ┣ 📂darwin64
 ┃ ┃ ┗ 📜unifmu.dylib
 ┃ ┣ 📂linux64
 ┃ ┃ ┗ 📜unifmu.so
 ┃ ┗ 📂win64
 ┃ ┃ ┗ 📜unifmu.dll
 ┣ 📂resources
 ┃ ┣ 📂schemas # schemas for grpc communication backend
 ┃ ┃ ┣ 📜unifmu_fmi2_pb2.py
 ┃ ┃ ┗ 📜unifmu_fmi2_pb2_grpc.py
 ┃ ┣ 📜backend_grpc.py # implementation of grpc backend
 ┃ ┣ 📜backend_schemaless_rpc.py # implementation of zmq backend
 ┃ ┣ 📜fmi2.py # FMI related class definitions
 ┃ ┣ 📜launch.toml "OS specific commands to bootstrap backend"
 ┃ ┗ 📜model.py "implementation of FMU"
 ┣ 📜modelDescription.xml "definition of inputs and outputs"
 ┗ 📜README.md # implementation guide for specific language, here python
```

\* denotes files that should be modified by the user.

Like the file structure, the workflow for modifying FMUs varies depending on the implementation language.
Depending on the language a `README.md` is placed in the root of the generated FMU, which serves as documentation for the particular language.
For reference the `README.md` copied into Python FMUs looks like [README.md](tool/unifmu/resources/backends/python/README.md).

# How to use the GUI?

**WIP: warning. The gui currently offers limited functionality compared to the CLI. Additionally, the documentation may not be up to date!**

```bash
unifmu gui
```

<centering>
<img src="docs/_static/gui_windows_file_menu.png">
</centering>

And then using the `File->Create FMU` command:

<centering>
<img src="docs/_static/gui_windows_create_fmu.png">
</centering>

### Modifying an existing FMU

The GUI makes it possible to edit an existing FMU.
Depending on whether the FMU is compressed or a directory use the `File->Open FMU archive` or `File->Open FMU directory` command.

<centering>
<img src="docs/_static/gui_windows_open_fmu.png">
</centering>

# Building and Testing

Building the project requires the following programs:

- Python (3.7+)
- Rust compiler toolchain

Additionally, UniFMU must be installed with all development dependencies:

```python
python -m pip install -e ".[dev]"
```

The `-e` installs the package in editable mode.
This is useful since it ensures that modifications of assets are also reflected in the assets of the the generated FMU.

The source code of the project can be divided into 3 parts:

| Directory             | Designation    | Functionality                                                                                                     | Language                                |
| --------------------- | -------------- | ----------------------------------------------------------------------------------------------------------------- | --------------------------------------- |
| tool/unifmu           | user interface | CLI and GUI used to generate FMUs                                                                                 | Python                                  |
| wrapper               | binaries       | FMU binaries, i.e. the implementation of the FMI API                                                              | Rust                                    |
| tool/unifmu/resources | assets         | Assets in the form of source files, build scripts and configuration files used by user interface to generate FMUs | Specific to FMU implementation language |

A key feature of the tool is that FMUs is that the binaries and assets are bundled and shipped with the `unifmu` package distributed through PyPI.
A nuance to this is that the binaries themselves must be made part of the assets, i.e. they must be copied into the assets folder.

A utility script, `build.py`, is located in the root of the repository.
This script facilitates common tasks such as building the binaries, doing integration test of FMUs and publishing the tool using pip.

For example, if changes has been made to source code of the binaries, the code can be rebuilt and tested using:

```bash
python build.py --update-wrapper --test-integration --update-schemas
```

The command runs integration tests of reference FMUs generated by UniFMU implemented in different languages.
If everything succeeds the output should look like:

```bash
...
test result: ok. 1 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out
```

**Note the line above may be emitted multiple times**

# Citing the tool

When citing the tool, please cite the following paper:

- Legaard, Christian M., Daniella Tola, Thomas Schranz, Hugo Daniel Macedo, and Peter Gorm Larsen. “A Universal Mechanism for Implementing Functional Mock-up Units,” to appear. SIMULTECH 2021. Virtual Event, 2021.

Bibtex:

```
@inproceedings{Legaard2021,
  title = {A Universal Mechanism for Implementing Functional Mock-up Units},
  booktitle = {11th {{International}} Conference on Simulation and Modeling Methodologies, Technologies and Applications},
  author = {Legaard, Christian M. and Tola, Daniella and Schranz, Thomas and Macedo, Hugo Daniel and Larsen, Peter Gorm},
  year = {2021},
  pages = {to appear},
  address = {{Virtual Event}},
  series = {{{SIMULTECH}} 2021}
}
```
