#!/bin/sh/env python

import pandera as pa

type_map = {
    'tinyint':      pa.Int8,
    'smallint':     pa.Int16,
    'mediumint':    pa.Int32,
    'int':          pa.Int32,
    'integer':      pa.Int32,
    'bigint':       pa.Int64,
    'decimal':      pa.Float64,
    'dec':          pa.Float64,
    'numeric':      pa.Float64,
    'fixed':        pa.Float64,
    'number':       pa.Float64,
    'float':        pa.Float32,
    'double':       pa.Float64,
    'bool':         pa.Bool,
    'boolean':      pa.Bool,
    'bit':          None,
    'int1':         int,
    'int2':         int,
    'int3':         int,
    'int4':         int,
    'int8':         pa.Int,
    'char':         pa.String,
    'varchar':      pa.String,
    'tinytext':     pa.String,
    'text':         pa.String,
    'mediumtext':   pa.String,
    'longtext':     None,
    'binary':       pa.String,
    'tinyblob':     None,
    'blob':         None,
    'mediumblob':   None,
    'longblob':     None,
    'inet':         pa.String,
    'varbinary':    pa.String,
    'date':         pa.String,
    'datetime':     pa.String,
    'timestamp':    pa.String,
    'time':         pa.String,
}