"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
SPDX-License-Identifier: Apache-2.0"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
from ... import substrait
import sys
if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class PlanRel(google.protobuf.message.Message):
    """Either a relation or root relation"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REL_FIELD_NUMBER: builtins.int
    ROOT_FIELD_NUMBER: builtins.int

    @property
    def rel(self) -> substrait.ibis.algebra_pb2.Rel:
        """Any relation (used for references and CTEs)"""

    @property
    def root(self) -> substrait.ibis.algebra_pb2.RelRoot:
        """The root of a relation tree"""

    def __init__(self, *, rel: substrait.ibis.algebra_pb2.Rel | None=..., root: substrait.ibis.algebra_pb2.RelRoot | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['rel', b'rel', 'rel_type', b'rel_type', 'root', b'root']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['rel', b'rel', 'rel_type', b'rel_type', 'root', b'root']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['rel_type', b'rel_type']) -> typing_extensions.Literal['rel', 'root'] | None:
        ...
global___PlanRel = PlanRel

class Plan(google.protobuf.message.Message):
    """Describe a set of operations to complete.
    For compactness sake, identifiers are normalized at the plan level.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VERSION_FIELD_NUMBER: builtins.int
    EXTENSION_URIS_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    RELATIONS_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSIONS_FIELD_NUMBER: builtins.int
    EXPECTED_TYPE_URLS_FIELD_NUMBER: builtins.int

    @property
    def version(self) -> global___Version:
        """Substrait version of the plan. Optional up to 0.17.0, required for later
        versions.
        """

    @property
    def extension_uris(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[substrait.ibis.extensions.extensions_pb2.SimpleExtensionURI]:
        """a list of yaml specifications this plan may depend on"""

    @property
    def extensions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[substrait.ibis.extensions.extensions_pb2.SimpleExtensionDeclaration]:
        """a list of extensions this plan may depend on"""

    @property
    def relations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PlanRel]:
        """one or more relation trees that are associated with this plan."""

    @property
    def advanced_extensions(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        """additional extensions associated with this plan."""

    @property
    def expected_type_urls(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of com.google.Any entities that this plan may use. Can be used to
        warn if some embedded message types are unknown. Note that this list may
        include message types that are ignorable (optimizations) or that are
        unused. In many cases, a consumer may be able to work with a plan even if
        one or more message types defined here are unknown.
        """

    def __init__(self, *, version: global___Version | None=..., extension_uris: collections.abc.Iterable[substrait.ibis.extensions.extensions_pb2.SimpleExtensionURI] | None=..., extensions: collections.abc.Iterable[substrait.ibis.extensions.extensions_pb2.SimpleExtensionDeclaration] | None=..., relations: collections.abc.Iterable[global___PlanRel] | None=..., advanced_extensions: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=..., expected_type_urls: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extensions', b'advanced_extensions', 'version', b'version']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extensions', b'advanced_extensions', 'expected_type_urls', b'expected_type_urls', 'extension_uris', b'extension_uris', 'extensions', b'extensions', 'relations', b'relations', 'version', b'version']) -> None:
        ...
global___Plan = Plan

class PlanVersion(google.protobuf.message.Message):
    """This message type can be used to deserialize only the version of a Substrait
    Plan message. This prevents deserialization errors when there were breaking
    changes between the Substrait version of the tool that produced the plan and
    the Substrait version used to deserialize it, such that a consumer can emit
    a more helpful error message in this case.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VERSION_FIELD_NUMBER: builtins.int

    @property
    def version(self) -> global___Version:
        ...

    def __init__(self, *, version: global___Version | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['version', b'version']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['version', b'version']) -> None:
        ...
global___PlanVersion = PlanVersion

class Version(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MAJOR_NUMBER_FIELD_NUMBER: builtins.int
    MINOR_NUMBER_FIELD_NUMBER: builtins.int
    PATCH_NUMBER_FIELD_NUMBER: builtins.int
    GIT_HASH_FIELD_NUMBER: builtins.int
    PRODUCER_FIELD_NUMBER: builtins.int
    major_number: builtins.int
    'Substrait version number.'
    minor_number: builtins.int
    patch_number: builtins.int
    git_hash: builtins.str
    'If a particular version of Substrait is used that does not correspond to\n    a version number exactly (for example when using an unofficial fork or\n    using a version that is not yet released or is between versions), set this\n    to the full git hash of the utilized commit of\n    https://github.com/substrait-io/substrait (or fork thereof), represented\n    using a lowercase hex ASCII string 40 characters in length. The version\n    number above should be set to the most recent version tag in the history\n    of that commit.\n    '
    producer: builtins.str
    'Identifying information for the producer that created this plan. Under\n    ideal circumstances, consumers should not need this information. However,\n    it is foreseen that consumers may need to work around bugs in particular\n    producers in practice, and therefore may need to know which producer\n    created the plan.\n    '

    def __init__(self, *, major_number: builtins.int=..., minor_number: builtins.int=..., patch_number: builtins.int=..., git_hash: builtins.str=..., producer: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['git_hash', b'git_hash', 'major_number', b'major_number', 'minor_number', b'minor_number', 'patch_number', b'patch_number', 'producer', b'producer']) -> None:
        ...
global___Version = Version