#######################################################
# 
# ReceiveConnections.py
# Python implementation of the Class ReceiveConnections
# Generated by Enterprise Architect
# Created on:      19-May-2020 6:21:05 PM
# Original author: Natha Paquette
# 
#######################################################
import socket
from logging.handlers import RotatingFileHandler
import logging
from FreeTAKServer.controllers.configuration.LoggingConstants import LoggingConstants
import sys
from FreeTAKServer.controllers.CreateLoggerController import CreateLoggerController
loggingConstants = LoggingConstants()
logger = CreateLoggerController("ReceiveConnections").getLogger()


class ReceiveConnections:
    def __init__(self):
        pass

    def listen(self, sock, pipe):
        #logger = CreateLoggerController("ReceiveConnections").getLogger()
        #listen for client connections
        sock.listen(1000)
        while True:
            try:
                #establish the socket variables
                client, address = sock.accept()
                #wait to receive client
                data = client.recv(1024)
                logger.info(loggingConstants.RECEIVECONNECTIONSLISTENINFO)
                #establish the socket array containing important information about the client
                socket = [client, address, data.decode('utf-8')]
                self.retrieveNecessaryInformation(socket, pipe)
                
            except Exception as e:
                logger.error(loggingConstants.RECEIVECONNECTIONSLISTENERROR+str(e))
                break
        self.listen(sock, pipe)
    def retrieveNecessaryInformation(self, rawConnectionInformation, pipe):
        #this adds the important client data to the data pipe allowing it to be received by the orchestrator
        pipe.send(rawConnectionInformation)