# generated by datamodel-codegen:
#   filename:  schemas.json
#   timestamp: 2021-11-29T17:32:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class Status(BaseModel):
    details: Optional[List[Dict[str, Dict[str, Any]]]] = Field(
        None,
        description="A list of messages that carry the error details. There is a common set of message types for APIs to use.",
    )
    code: Optional[int] = Field(
        None,
        description="The status code, which should be an enum value of google.rpc.Code.",
    )
    message: Optional[str] = Field(
        None,
        description="A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.",
    )


class SourceInfo(BaseModel):
    source_files: Optional[List[Dict[str, Dict[str, Any]]]] = Field(
        None,
        alias="sourceFiles",
        description="All files used during config generation.",
    )


class ValueType(Enum):
    value_type_unspecified = "VALUE_TYPE_UNSPECIFIED"
    bool = "BOOL"
    int64 = "INT64"
    double = "DOUBLE"
    string = "STRING"
    distribution = "DISTRIBUTION"
    money = "MONEY"


class MetricKind(Enum):
    metric_kind_unspecified = "METRIC_KIND_UNSPECIFIED"
    gauge = "GAUGE"
    delta = "DELTA"
    cumulative = "CUMULATIVE"


class LaunchStage(Enum):
    launch_stage_unspecified = "LAUNCH_STAGE_UNSPECIFIED"
    unimplemented = "UNIMPLEMENTED"
    prelaunch = "PRELAUNCH"
    early_access = "EARLY_ACCESS"
    alpha = "ALPHA"
    beta = "BETA"
    ga = "GA"
    deprecated = "DEPRECATED"


class MetricDescriptorMetadata(BaseModel):
    ingest_delay: Optional[str] = Field(
        None,
        alias="ingestDelay",
        description="The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.",
    )
    launch_stage: Optional[LaunchStage] = Field(
        None,
        alias="launchStage",
        description="Deprecated. Must use the MetricDescriptor.launch_stage instead.",
    )
    sample_period: Optional[str] = Field(
        None,
        alias="samplePeriod",
        description="The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.",
    )


class ValueType1(Enum):
    string = "STRING"
    bool = "BOOL"
    int64 = "INT64"


class LabelDescriptor(BaseModel):
    value_type: Optional[ValueType1] = Field(
        None,
        alias="valueType",
        description="The type of data that can be assigned to the label.",
    )
    description: Optional[str] = Field(
        None, description="A human-readable description for the label."
    )
    key: Optional[str] = Field(None, description="The label key.")


class DeleteAdminQuotaPolicyMetadata(BaseModel):
    pass


class CheckIfServiceHasUsage(Enum):
    check_if_service_has_usage_unspecified = "CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED"
    skip = "SKIP"
    check = "CHECK"


class DisableServiceRequest(BaseModel):
    disable_dependent_services: Optional[bool] = Field(
        None,
        alias="disableDependentServices",
        description="Indicates if services that are enabled and which depend on this service should also be disabled. If not set, an error will be generated if any enabled services depend on the service to be disabled. When set, the service, and any enabled services that depend on it, will be disabled together.",
    )
    check_if_service_has_usage: Optional[CheckIfServiceHasUsage] = Field(
        None,
        alias="checkIfServiceHasUsage",
        description="Defines the behavior for checking service usage when disabling a service.",
    )


class Option(BaseModel):
    value: Optional[Dict[str, Dict[str, Any]]] = Field(
        None,
        description="The option's value packed in an Any message. If the value is a primitive, the corresponding wrapper type defined in google/protobuf/wrappers.proto should be used. If the value is an enum, it should be stored as an int32 value using the google.protobuf.Int32Value type.",
    )
    name: Optional[str] = Field(
        None,
        description='The option\'s name. For protobuf built-in options (options defined in descriptor.proto), this is the short name. For example, `"map_entry"`. For custom options, it should be the fully-qualified name. For example, `"google.api.http"`.',
    )


class State(Enum):
    state_unspecified = "STATE_UNSPECIFIED"
    disabled = "DISABLED"
    enabled = "ENABLED"


class Endpoint(BaseModel):
    allow_cors: Optional[bool] = Field(
        None,
        alias="allowCors",
        description="Allowing [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka cross-domain traffic, would allow the backends served from this endpoint to receive and respond to HTTP OPTIONS requests. The response will be used by the browser to determine whether the subsequent cross-origin request is allowed to proceed.",
    )
    target: Optional[str] = Field(
        None,
        description='The specification of an Internet routable address of API frontend that will handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary). It should be either a valid IPv4 address or a fully-qualified domain name. For example, "8.8.8.8" or "myservice.appspot.com".',
    )
    name: Optional[str] = Field(None, description="The canonical name of this endpoint.")


class JwtLocation(BaseModel):
    value_prefix: Optional[str] = Field(
        None,
        alias="valuePrefix",
        description='The value prefix. The value format is "value_prefix{token}" Only applies to "in" header type. Must be empty for "in" query type. If not empty, the header value has to match (case sensitive) this prefix. If not matched, JWT will not be extracted. If matched, JWT will be extracted after the prefix is removed. For example, for "Authorization: Bearer {JWT}", value_prefix="Bearer " with a space at the end.',
    )
    header: Optional[str] = Field(
        None, description="Specifies HTTP header name to extract JWT token."
    )
    query: Optional[str] = Field(
        None, description="Specifies URL query parameter name to extract JWT token."
    )


class OAuthRequirements(BaseModel):
    canonical_scopes: Optional[str] = Field(
        None,
        alias="canonicalScopes",
        description="The list of publicly documented OAuth scopes that are allowed access. An OAuth token containing any of these scopes will be accepted. Example: canonical_scopes: https://www.googleapis.com/auth/calendar, https://www.googleapis.com/auth/calendar.read",
    )


class AuthRequirement(BaseModel):
    provider_id: Optional[str] = Field(
        None,
        alias="providerId",
        description="id from authentication provider. Example: provider_id: bookstore_auth",
    )
    audiences: Optional[str] = Field(
        None,
        description='NOTE: This will be deprecated soon, once AuthProvider.audiences is implemented and accepted in all the runtime components. The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, only JWTs with audience "https://Service_name/API_name" will be accepted. For example, if no audiences are in the setting, LibraryService API will only accept JWTs with the following audience "https://library-example.googleapis.com/google.example.library.v1.LibraryService". Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com',
    )


class MonitoredResourceDescriptor(BaseModel):
    type: Optional[str] = Field(
        None,
        description='Required. The monitored resource type. For example, the type `"cloudsql_database"` represents databases in Google Cloud SQL. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).',
    )
    labels: Optional[List[LabelDescriptor]] = Field(
        None,
        description='Required. A set of labels used to describe instances of this monitored resource type. For example, an individual Google Cloud SQL database is identified by values for the labels `"database_id"` and `"zone"`.',
    )
    name: Optional[str] = Field(
        None,
        description='Optional. The resource name of the monitored resource descriptor: `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where {type} is the value of the `type` field in this object and {project_id} is a project ID that provides API-specific context for accessing the type. APIs that do not use project information can use the resource name format `"monitoredResourceDescriptors/{type}"`.',
    )
    description: Optional[str] = Field(
        None,
        description="Optional. A detailed description of the monitored resource type that might be used in documentation.",
    )
    launch_stage: Optional[LaunchStage] = Field(
        None,
        alias="launchStage",
        description="Optional. The launch stage of the monitored resource definition.",
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description='Optional. A concise name for the monitored resource type that might be displayed in user interfaces. It should be a Title Cased Noun Phrase, without any article or other determiners. For example, `"Google Cloud SQL Database"`.',
    )


class Page(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name of the page. It will be used as an identity of the page to generate URI of the page, text of the link to this page in navigation, etc. The full page name (start from the root page name to this page concatenated with `.`) can be used as reference to the page in your documentation. For example: pages: - name: Tutorial content: (== include tutorial.md ==) subpages: - name: Java content: (== include tutorial_java.md ==) You can reference `Java` page using Markdown reference link syntax: `Java`.",
    )
    subpages: Optional[List[Page]] = Field(
        None,
        description="Subpages of this page. The order of subpages specified here will be honored in the generated docset.",
    )
    content: Optional[str] = Field(
        None,
        description="The Markdown content of the page. You can use (== include {path} ==) to include content from a Markdown file. The content can be used to produce the documentation page such as HTML format page.",
    )


class DocumentationRule(BaseModel):
    description: Optional[str] = Field(
        None,
        description="Description of the selected proto element (e.g. a message, a method, a 'service' definition, or a field). Defaults to leading & trailing comments taken from the proto source definition of the proto element.",
    )
    deprecation_description: Optional[str] = Field(
        None,
        alias="deprecationDescription",
        description="Deprecation description of the selected element(s). It can be provided if an element is marked as `deprecated`.",
    )
    selector: Optional[str] = Field(
        None,
        description='The selector is a comma-separated list of patterns for any element such as a method, a field, an enum value. Each pattern is a qualified name of the element which may end in "*", indicating a wildcard. Wildcards are only allowed at the end and for a whole component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or "foo.*.bar". A wildcard will match one or more components. To specify a default for all applicable elements, the whole pattern "*" is used.',
    )


class UsageRule(BaseModel):
    allow_unregistered_calls: Optional[bool] = Field(
        None,
        alias="allowUnregisteredCalls",
        description="If true, the selected method allows unregistered calls, e.g. calls that don't identify any user or application.",
    )
    selector: Optional[str] = Field(
        None,
        description="Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.",
    )
    skip_service_control: Optional[bool] = Field(
        None,
        alias="skipServiceControl",
        description="If true, the selected method should skip service control and the control plane features, such as quota and billing, will not be available. This flag is used by Google Cloud Endpoints to bypass checks for internal methods, such as service health check methods.",
    )


class MonitoringDestination(BaseModel):
    metrics: Optional[List[str]] = Field(
        None,
        description="Types of the metrics to report to this monitoring destination. Each type must be defined in Service.metrics section.",
    )
    monitored_resource: Optional[str] = Field(
        None,
        alias="monitoredResource",
        description="The monitored resource type. The type must be defined in Service.monitored_resources section.",
    )


class QuotaLimit(BaseModel):
    duration: Optional[str] = Field(
        None,
        description='Duration of this limit in textual notation. Must be "100s" or "1d". Used by group-based quotas only.',
    )
    metric: Optional[str] = Field(
        None,
        description="The name of the metric this quota limit applies to. The quota limits with the same metric will be checked together during runtime. The metric must be defined within the service config.",
    )
    unit: Optional[str] = Field(
        None,
        description='Specify the unit of the quota limit. It uses the same syntax as Metric.unit. The supported unit kinds are determined by the quota backend system. Here are some examples: * "1/min/{project}" for quota per minute per project. Note: the order of unit components is insignificant. The "1" at the beginning is required to follow the metric unit syntax.',
    )
    values: Optional[Dict[str, str]] = Field(
        None,
        description="Tiered limit values. You must specify this as a key:value pair, with an integer value that is the maximum number of requests allowed for the specified unit. Currently only STANDARD is supported.",
    )
    default_limit: Optional[str] = Field(
        None,
        alias="defaultLimit",
        description="Default number of tokens that can be consumed during the specified duration. This is the number of tokens assigned when a client application developer activates the service for his/her project. Specifying a value of 0 will block all requests. This can be used if you are provisioning quota to selected consumers and blocking others. Similarly, a value of -1 will indicate an unlimited quota. No other negative values are allowed. Used by group-based quotas only.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the quota limit. The name must be provided, and it must be unique within the service. The name can only include alphanumeric characters as well as '-'. The maximum length of the limit name is 64 characters.",
    )
    max_limit: Optional[str] = Field(
        None,
        alias="maxLimit",
        description="Maximum number of tokens that can be consumed during the specified duration. Client application developers can override the default limit up to this maximum. If specified, this value cannot be set to a value less than the default limit. If not specified, it is set to the default limit. To allow clients to apply overrides with no upper bound, set this to -1, indicating unlimited maximum quota. Used by group-based quotas only.",
    )
    description: Optional[str] = Field(
        None,
        description="Optional. User-visible, extended description for this quota limit. Should be used only when more context is needed to understand this limit than provided by the limit's display name (see: `display_name`).",
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="User-visible display name for this limit. Optional. If not set, the UI will provide a default display name based on the quota configuration. This field can be used to override the default display name generated from the configuration.",
    )
    free_tier: Optional[str] = Field(
        None,
        alias="freeTier",
        description='Free tier value displayed in the Developers Console for this limit. The free tier is the number of tokens that will be subtracted from the billed amount when billing is enabled. This field can only be set on a limit with duration "1d", in a billable group; it is invalid on any other limit. If this field is not set, it defaults to 0, indicating that there is no free tier for this service. Used by group-based quotas only.',
    )


class MetricRule(BaseModel):
    selector: Optional[str] = Field(
        None,
        description="Selects the methods to which this rule applies. Refer to selector for syntax details.",
    )
    metric_costs: Optional[Dict[str, str]] = Field(
        None,
        alias="metricCosts",
        description="Metrics to update when the selected methods are called, and the associated cost applied to each metric. The key of the map is the metric name, and the values are the amount increased for the metric against which the quota limits are defined. The value must not be negative.",
    )


class Syntax(Enum):
    syntax_proto2 = "SYNTAX_PROTO2"
    syntax_proto3 = "SYNTAX_PROTO3"


class SourceContext(BaseModel):
    file_name: Optional[str] = Field(
        None,
        alias="fileName",
        description='The path-qualified name of the .proto file that contained the associated protobuf element. For example: `"google/protobuf/source_context.proto"`.',
    )


class Mixin(BaseModel):
    root: Optional[str] = Field(
        None,
        description="If non-empty specifies a path under which inherited HTTP paths are rooted.",
    )
    name: Optional[str] = Field(
        None, description="The fully qualified name of the interface which is included."
    )


class Method(BaseModel):
    name: Optional[str] = Field(None, description="The simple name of this method.")
    response_streaming: Optional[bool] = Field(
        None,
        alias="responseStreaming",
        description="If true, the response is streamed.",
    )
    response_type_url: Optional[str] = Field(
        None, alias="responseTypeUrl", description="The URL of the output message type."
    )
    request_streaming: Optional[bool] = Field(
        None, alias="requestStreaming", description="If true, the request is streamed."
    )
    syntax: Optional[Syntax] = Field(None, description="The source syntax of this method.")
    options: Optional[List[Option]] = Field(
        None, description="Any metadata attached to the method."
    )
    request_type_url: Optional[str] = Field(
        None, alias="requestTypeUrl", description="A URL of the input message type."
    )


class GoogleApiServiceusageV1OperationMetadata(BaseModel):
    resource_names: Optional[List[str]] = Field(
        None,
        alias="resourceNames",
        description="The full name of the resources that this operation is directly associated with.",
    )


class Control(BaseModel):
    environment: Optional[str] = Field(
        None,
        description="The service control environment to use. If empty, no control plane feature (like quota and billing) will be enabled.",
    )


class QuotaOverride(BaseModel):
    admin_override_ancestor: Optional[str] = Field(
        None,
        alias="adminOverrideAncestor",
        description="The resource name of the ancestor that requested the override. For example: `organizations/12345` or `folders/67890`. Used by admin overrides only.",
    )
    dimensions: Optional[Dict[str, str]] = Field(
        None,
        description="If this map is nonempty, then this override applies only to specific values for dimensions defined in the limit unit. For example, an override on a limit with the unit `1/{project}/{region}` could contain an entry with the key `region` and the value `us-east-1`; the override is only applied to quota consumed in that region. This map has the following restrictions: * Keys that are not defined in the limit's unit are not valid keys. Any string appearing in `{brackets}` in the unit (besides `{project}` or `{user}`) is a defined key. * `project` is not a valid key; the project is already specified in the parent resource name. * `user` is not a valid key; the API does not support quota overrides that apply only to a specific user. * If `region` appears as a key, its value must be a valid Cloud region. * If `zone` appears as a key, its value must be a valid Cloud zone. * If any valid key other than `region` or `zone` appears in the map, then all valid keys other than `region` or `zone` must also appear in the map.",
    )
    name: Optional[str] = Field(
        None,
        description="The resource name of the override. This name is generated by the server when the override is created. Example names would be: `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d` `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d` The resource name is intended to be opaque and should not be parsed for its component strings, since its representation could change in the future.",
    )
    override_value: Optional[str] = Field(
        None,
        alias="overrideValue",
        description="The overriding quota limit value. Can be any nonnegative integer, or -1 (unlimited quota).",
    )
    metric: Optional[str] = Field(
        None,
        description="The name of the metric to which this override applies. An example name would be: `compute.googleapis.com/cpus`",
    )
    unit: Optional[str] = Field(
        None,
        description="The limit unit of the limit to which this override applies. An example unit would be: `1/{project}/{region}` Note that `{project}` and `{region}` are not placeholders in this example; the literal characters `{` and `}` occur in the string.",
    )


class CustomHttpPattern(BaseModel):
    path: Optional[str] = Field(None, description="The path matched by this custom verb.")
    kind: Optional[str] = Field(None, description="The name of this custom HTTP verb.")


class State1(Enum):
    identity_state_unspecified = "IDENTITY_STATE_UNSPECIFIED"
    active = "ACTIVE"


class GoogleApiServiceusageV1beta1ServiceIdentity(BaseModel):
    unique_id: Optional[str] = Field(
        None,
        alias="uniqueId",
        description="The unique and stable id of the service account. https://cloud.google.com/iam/reference/rest/v1/projects.serviceAccounts#ServiceAccount",
    )
    email: Optional[str] = Field(
        None,
        description="The email address of the service account that a service producer would use to access consumer resources.",
    )


class EnableFailure(BaseModel):
    error_message: Optional[str] = Field(
        None,
        alias="errorMessage",
        description="An error message describing why the service could not be enabled.",
    )
    service_id: Optional[str] = Field(
        None,
        alias="serviceId",
        description="The service id of a service that could not be enabled.",
    )


class CustomErrorRule(BaseModel):
    is_error_type: Optional[bool] = Field(
        None,
        alias="isErrorType",
        description="Mark this message as possible payload in error response. Otherwise, objects of this type will be filtered when they appear in error payload.",
    )
    selector: Optional[str] = Field(
        None,
        description="Selects messages to which this rule applies. Refer to selector for syntax details.",
    )


class EnableServiceRequest(BaseModel):
    pass


class UpdateAdminQuotaPolicyMetadata(BaseModel):
    pass


class BillingDestination(BaseModel):
    monitored_resource: Optional[str] = Field(
        None,
        alias="monitoredResource",
        description="The monitored resource type. The type must be defined in Service.monitored_resources section.",
    )
    metrics: Optional[List[str]] = Field(
        None,
        description="Names of the metrics to report to this billing destination. Each name must be defined in Service.metrics section.",
    )


class LoggingDestination(BaseModel):
    monitored_resource: Optional[str] = Field(
        None,
        alias="monitoredResource",
        description="The monitored resource type. The type must be defined in the Service.monitored_resources section.",
    )
    logs: Optional[List[str]] = Field(
        None,
        description='Names of the logs to be sent to this destination. Each name must be defined in the Service.logs section. If the log name is not a domain scoped name, it will be automatically prefixed with the service name followed by "/".',
    )


class Billing(BaseModel):
    consumer_destinations: Optional[List[BillingDestination]] = Field(
        None,
        alias="consumerDestinations",
        description="Billing configurations for sending metrics to the consumer project. There can be multiple consumer destinations per service, each one must have a different monitored resource type. A metric can be used in at most one consumer destination.",
    )


class Kind(Enum):
    type_unknown = "TYPE_UNKNOWN"
    type_double = "TYPE_DOUBLE"
    type_float = "TYPE_FLOAT"
    type_int64 = "TYPE_INT64"
    type_uint64 = "TYPE_UINT64"
    type_int32 = "TYPE_INT32"
    type_fixed64 = "TYPE_FIXED64"
    type_fixed32 = "TYPE_FIXED32"
    type_bool = "TYPE_BOOL"
    type_string = "TYPE_STRING"
    type_group = "TYPE_GROUP"
    type_message = "TYPE_MESSAGE"
    type_bytes = "TYPE_BYTES"
    type_uint32 = "TYPE_UINT32"
    type_enum = "TYPE_ENUM"
    type_sfixed32 = "TYPE_SFIXED32"
    type_sfixed64 = "TYPE_SFIXED64"
    type_sint32 = "TYPE_SINT32"
    type_sint64 = "TYPE_SINT64"


class Cardinality(Enum):
    cardinality_unknown = "CARDINALITY_UNKNOWN"
    cardinality_optional = "CARDINALITY_OPTIONAL"
    cardinality_required = "CARDINALITY_REQUIRED"
    cardinality_repeated = "CARDINALITY_REPEATED"


class FieldModel(BaseModel):
    oneof_index: Optional[int] = Field(
        None,
        alias="oneofIndex",
        description="The index of the field type in `Type.oneofs`, for message or enumeration types. The first type has index 1; zero means the type is not in the list.",
    )
    default_value: Optional[str] = Field(
        None,
        alias="defaultValue",
        description="The string value of the default value of this field. Proto2 syntax only.",
    )
    kind: Optional[Kind] = Field(None, description="The field type.")
    packed: Optional[bool] = Field(
        None, description="Whether to use alternative packed wire representation."
    )
    type_url: Optional[str] = Field(
        None,
        alias="typeUrl",
        description='The field type URL, without the scheme, for message or enumeration types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.',
    )
    cardinality: Optional[Cardinality] = Field(None, description="The field cardinality.")
    number: Optional[int] = Field(None, description="The field number.")
    name: Optional[str] = Field(None, description="The field name.")
    options: Optional[List[Option]] = Field(None, description="The protocol buffer options.")
    json_name: Optional[str] = Field(None, alias="jsonName", description="The field JSON name.")


class SystemParameter(BaseModel):
    http_header: Optional[str] = Field(
        None,
        alias="httpHeader",
        description="Define the HTTP header name to use for the parameter. It is case insensitive.",
    )
    url_query_parameter: Optional[str] = Field(
        None,
        alias="urlQueryParameter",
        description="Define the URL query parameter name to use for the parameter. It is case sensitive.",
    )
    name: Optional[str] = Field(
        None,
        description='Define the name of the parameter, such as "api_key" . It is case sensitive.',
    )


class ContextRule(BaseModel):
    allowed_request_extensions: Optional[List[str]] = Field(
        None,
        alias="allowedRequestExtensions",
        description="A list of full type names or extension IDs of extensions allowed in grpc side channel from client to backend.",
    )
    selector: Optional[str] = Field(
        None,
        description="Selects the methods to which this rule applies. Refer to selector for syntax details.",
    )
    allowed_response_extensions: Optional[List[str]] = Field(
        None,
        alias="allowedResponseExtensions",
        description="A list of full type names or extension IDs of extensions allowed in grpc side channel from backend to client.",
    )
    provided: Optional[List[str]] = Field(
        None, description="A list of full type names of provided contexts."
    )
    requested: Optional[List[str]] = Field(
        None, description="A list of full type names of requested contexts."
    )


class EnumValue(BaseModel):
    options: Optional[List[Option]] = Field(None, description="Protocol buffer options.")
    number: Optional[int] = Field(None, description="Enum value number.")
    name: Optional[str] = Field(None, description="Enum value name.")


class LogDescriptor(BaseModel):
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="The human-readable name for this log. This information appears on the user interface and should be concise.",
    )
    labels: Optional[List[LabelDescriptor]] = Field(
        None,
        description="The set of labels that are available to describe a specific log entry. Runtime requests that contain labels not specified here are considered invalid.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of the log. It must be less than 512 characters long and can include the following characters: upper- and lower-case alphanumeric characters [A-Za-z0-9], and punctuation characters including slash, underscore, hyphen, period [/_-.].",
    )
    description: Optional[str] = Field(
        None,
        description="A human-readable description of this log. This information appears in the documentation and can contain details.",
    )


class PathTranslation(Enum):
    path_translation_unspecified = "PATH_TRANSLATION_UNSPECIFIED"
    constant_address = "CONSTANT_ADDRESS"
    append_path_to_address = "APPEND_PATH_TO_ADDRESS"


class BackendRule(BaseModel):
    jwt_audience: Optional[str] = Field(
        None,
        alias="jwtAudience",
        description='The JWT audience is used when generating a JWT ID token for the backend. This ID token will be added in the HTTP "authorization" header, and sent to the backend.',
    )
    disable_auth: Optional[bool] = Field(
        None,
        alias="disableAuth",
        description='When disable_auth is true, a JWT ID token won\'t be generated and the original "Authorization" HTTP header will be preserved. If the header is used to carry the original token and is expected by the backend, this field must be set to true to preserve the header.',
    )
    selector: Optional[str] = Field(
        None,
        description="Selects the methods to which this rule applies. Refer to selector for syntax details.",
    )
    deadline: Optional[float] = Field(
        None,
        description="The number of seconds to wait for a response from a request. The default varies based on the request protocol and deployment environment.",
    )
    address: Optional[str] = Field(
        None,
        description="The address of the API backend. The scheme is used to determine the backend protocol and security. The following schemes are accepted: SCHEME PROTOCOL SECURITY http:// HTTP None https:// HTTP TLS grpc:// gRPC None grpcs:// gRPC TLS It is recommended to explicitly include a scheme. Leaving out the scheme may cause constrasting behaviors across platforms. If the port is unspecified, the default is: - 80 for schemes without TLS - 443 for schemes with TLS For HTTP backends, use protocol to specify the protocol version.",
    )
    protocol: Optional[str] = Field(
        None,
        description='The protocol used for sending a request to the backend. The supported values are "http/1.1" and "h2". The default value is inferred from the scheme in the address field: SCHEME PROTOCOL http:// http/1.1 https:// http/1.1 grpc:// h2 grpcs:// h2 For secure HTTP backends (https://) that support HTTP/2, set this field to "h2" for improved performance. Configuring this field to non-default values is only supported for secure HTTP backends. This field will be ignored for all other backends. See https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids for more details on the supported values.',
    )
    path_translation: Optional[PathTranslation] = Field(None, alias="pathTranslation")
    operation_deadline: Optional[float] = Field(
        None,
        alias="operationDeadline",
        description="The number of seconds to wait for the completion of a long running operation. The default is no deadline.",
    )


class GetServiceIdentityMetadata(BaseModel):
    pass


class ImportConsumerOverridesResponse(BaseModel):
    overrides: Optional[List[QuotaOverride]] = Field(
        None, description="The overrides that were created from the imported data."
    )


class AdminQuotaPolicy(BaseModel):
    container: Optional[str] = Field(
        None,
        description="The cloud resource container at which the quota policy is created. The format is `{container_type}/{container_number}`",
    )
    metric: Optional[str] = Field(
        None,
        description="The name of the metric to which this policy applies. An example name would be: `compute.googleapis.com/cpus`",
    )
    policy_value: Optional[str] = Field(
        None,
        alias="policyValue",
        description="The quota policy value. Can be any nonnegative integer, or -1 (unlimited quota).",
    )
    dimensions: Optional[Dict[str, str]] = Field(
        None,
        description=" If this map is nonempty, then this policy applies only to specific values for dimensions defined in the limit unit. For example, an policy on a limit with the unit `1/{project}/{region}` could contain an entry with the key `region` and the value `us-east-1`; the policy is only applied to quota consumed in that region. This map has the following restrictions: * If `region` appears as a key, its value must be a valid Cloud region. * If `zone` appears as a key, its value must be a valid Cloud zone. * Keys other than `region` or `zone` are not valid.",
    )
    unit: Optional[str] = Field(
        None,
        description="The limit unit of the limit to which this policy applies. An example unit would be: `1/{project}/{region}` Note that `{project}` and `{region}` are not placeholders in this example; the literal characters `{` and `}` occur in the string.",
    )
    name: Optional[str] = Field(
        None,
        description="The resource name of the policy. This name is generated by the server when the policy is created. Example names would be: `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`",
    )


class Empty(BaseModel):
    pass


class ImportConsumerOverridesMetadata(BaseModel):
    pass


class OperationMetadata(BaseModel):
    resource_names: Optional[List[str]] = Field(
        None,
        alias="resourceNames",
        description="The full name of the resources that this operation is directly associated with.",
    )


class ImportAdminQuotaPoliciesMetadata(BaseModel):
    pass


class ServiceIdentity(BaseModel):
    email: Optional[str] = Field(
        None,
        description="The email address of the service account that a service producer would use to access consumer resources.",
    )
    unique_id: Optional[str] = Field(
        None,
        alias="uniqueId",
        description="The unique and stable id of the service account. https://cloud.google.com/iam/reference/rest/v1/projects.serviceAccounts#ServiceAccount",
    )


class CancelOperationRequest(BaseModel):
    pass


class BatchCreateConsumerOverridesResponse(BaseModel):
    overrides: Optional[List[QuotaOverride]] = Field(
        None, description="The overrides that were created."
    )


class ImportAdminOverridesMetadata(BaseModel):
    pass


class ImportAdminQuotaPoliciesResponse(BaseModel):
    policies: Optional[List[AdminQuotaPolicy]] = Field(
        None, description="The policies that were created from the imported data."
    )


class CreateAdminQuotaPolicyMetadata(BaseModel):
    pass


class BatchEnableServicesRequest(BaseModel):
    service_ids: Optional[List[str]] = Field(
        None,
        alias="serviceIds",
        description="The identifiers of the services to enable on the project. A valid identifier would be: serviceusage.googleapis.com Enabling services requires that each service is public or is shared with the user enabling the service. A single request can enable a maximum of 20 services at a time. If more than 20 services are specified, the request will fail, and no state changes will occur.",
    )


class BatchCreateAdminOverridesResponse(BaseModel):
    overrides: Optional[List[QuotaOverride]] = Field(
        None, description="The overrides that were created."
    )


class Operation(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.",
    )
    response: Optional[Dict[str, Dict[str, Any]]] = Field(
        None,
        description="The normal response of the operation in case of success. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.",
    )
    done: Optional[bool] = Field(
        None,
        description="If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.",
    )
    metadata: Optional[Dict[str, Dict[str, Any]]] = Field(
        None,
        description="Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.",
    )
    error: Optional[Status] = Field(
        None,
        description="The error result of the operation in case of failure or cancellation.",
    )


class MetricDescriptor(BaseModel):
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description='A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count". This field is optional but it is recommended to be set for any metrics associated with user-visible concepts, such as Quota.',
    )
    name: Optional[str] = Field(None, description="The resource name of the metric descriptor.")
    unit: Optional[str] = Field(
        None,
        description='The units in which the metric value is reported. It is only applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit` defines the representation of the stored metric values. Different systems might scale the values to be more easily displayed (so a value of `0.02kBy` _might_ be displayed as `20By`, and a value of `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is `kBy`, then the value of the metric is always in thousands of bytes, no matter how it might be displayed. If you want a custom metric to record the exact number of CPU-seconds used by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005 CPU-seconds, then the value is written as `12005`. Alternatively, if you want a custom metric to record data in a more granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is `12005/1024`). The supported units are a subset of [The Unified Code for Units of Measure](https://unitsofmeasure.org/ucum.html) standard: **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min` minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)** * `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera (10^12) * `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) * `Y` yotta (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano (10^-9) * `p` pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18) * `z` zepto (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi` mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50) **Grammar** The grammar also includes these connectors: * `/` division or ratio (as an infix operator). For examples, `kBy/{email}` or `MiBy/10ms` (although you should almost never have `/s` in a metric `unit`; rates should always be computed at query time from the underlying cumulative or delta value). * `.` multiplication or composition (as an infix operator). For examples, `GBy.d` or `k{watt}.h`. The grammar for a unit is as follows: Expression = Component { "." Component } { "/" Component } ; Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it follows a `UNIT`. If the annotation is used alone, then the unit is equivalent to `1`. For examples, `{request}/s == 1/s`, `By{transmitted}/s == By/s`. * `NAME` is a sequence of non-blank printable ASCII characters not containing `{` or `}`. * `1` represents a unitary [dimensionless unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as in `1/s`. It is typically used when none of the basic units are appropriate. For example, "new users per day" can be represented as `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new users). Alternatively, "thousands of page views per day" would be represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric value of `5.3` would mean "5300 page views per day"). * `%` represents dimensionless value of 1/100, and annotates values giving a percentage (so the metric values are typically in the range of 0..100, and a metric value `3` means "3 percent"). * `10^2.%` indicates a metric contains a ratio, typically in the range 0..1, that will be multiplied by 100 and displayed as a percentage (so a metric value `0.03` means "3 percent").',
    )
    type: Optional[str] = Field(
        None,
        description='The metric type, including its DNS name prefix. The type is not URL-encoded. All user-defined metric types have the DNS name `custom.googleapis.com` or `external.googleapis.com`. Metric types should use a natural hierarchical grouping. For example: "custom.googleapis.com/invoice/paid/amount" "external.googleapis.com/prometheus/up" "appengine.googleapis.com/http/server/response_latencies"',
    )
    value_type: Optional[ValueType] = Field(
        None,
        alias="valueType",
        description="Whether the measurement is an integer, a floating-point number, etc. Some combinations of `metric_kind` and `value_type` might not be supported.",
    )
    metadata: Optional[MetricDescriptorMetadata] = Field(
        None,
        description="Optional. Metadata which can be used to guide usage of the metric.",
    )
    description: Optional[str] = Field(
        None,
        description="A detailed description of the metric, which can be used in documentation.",
    )
    monitored_resource_types: Optional[List[str]] = Field(
        None,
        alias="monitoredResourceTypes",
        description="Read-only. If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here.",
    )
    metric_kind: Optional[MetricKind] = Field(
        None,
        alias="metricKind",
        description="Whether the metric records instantaneous values, changes to a value, etc. Some combinations of `metric_kind` and `value_type` might not be supported.",
    )
    labels: Optional[List[LabelDescriptor]] = Field(
        None,
        description="The set of labels that can be used to describe a specific instance of this metric type. For example, the `appengine.googleapis.com/http/server/response_latencies` metric type has a label for the HTTP response code, `response_code`, so you can look at latencies for successful responses or just for responses that failed.",
    )
    launch_stage: Optional[LaunchStage] = Field(
        None,
        alias="launchStage",
        description="Optional. The launch stage of the metric definition.",
    )


class AuthProvider(BaseModel):
    jwks_uri: Optional[str] = Field(
        None,
        alias="jwksUri",
        description="URL of the provider's public key set to validate signature of the JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata). Optional if the key set document: - can be retrieved from [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of the issuer. - can be inferred from the email domain of the issuer (e.g. a Google service account). Example: https://www.googleapis.com/oauth2/v1/certs",
    )
    issuer: Optional[str] = Field(
        None,
        description="Identifies the principal that issued the JWT. See https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1 Usually a URL or an email address. Example: https://securetoken.google.com Example: 1234567-compute@developer.gserviceaccount.com",
    )
    id: Optional[str] = Field(
        None,
        description='The unique identifier of the auth provider. It will be referred to by `AuthRequirement.provider_id`. Example: "bookstore_auth".',
    )
    authorization_url: Optional[str] = Field(
        None,
        alias="authorizationUrl",
        description="Redirect URL if JWT token is required but not present or is expired. Implement authorizationUrl of securityDefinitions in OpenAPI spec.",
    )
    jwt_locations: Optional[List[JwtLocation]] = Field(
        None,
        alias="jwtLocations",
        description='Defines the locations to extract the JWT. JWT locations can be either from HTTP headers or URL query parameters. The rule is that the first match wins. The checking order is: checking all headers first, then URL query parameters. If not specified, default to use following 3 locations: 1) Authorization: Bearer 2) x-goog-iap-jwt-assertion 3) access_token query parameter Default locations can be specified as followings: jwt_locations: - header: Authorization value_prefix: "Bearer " - header: x-goog-iap-jwt-assertion - query: access_token',
    )
    audiences: Optional[str] = Field(
        None,
        description='The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, JWTs with audiences: - "https://[service.name]/[google.protobuf.Api.name]" - "https://[service.name]/" will be accepted. For example, if no audiences are in the setting, LibraryService API will accept JWTs with the following audiences: - https://library-example.googleapis.com/google.example.library.v1.LibraryService - https://library-example.googleapis.com/ Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com',
    )


class AuthenticationRule(BaseModel):
    oauth: Optional[OAuthRequirements] = Field(
        None, description="The requirements for OAuth credentials."
    )
    selector: Optional[str] = Field(
        None,
        description="Selects the methods to which this rule applies. Refer to selector for syntax details.",
    )
    allow_without_credential: Optional[bool] = Field(
        None,
        alias="allowWithoutCredential",
        description="If true, the service accepts API keys without any other credential. This flag only applies to HTTP and gRPC requests.",
    )
    requirements: Optional[List[AuthRequirement]] = Field(
        None, description="Requirements for additional authentication providers."
    )


class Documentation(BaseModel):
    overview: Optional[str] = Field(
        None,
        description="Declares a single overview page. For example: documentation: summary: ... overview: (== include overview.md ==) This is a shortcut for the following declaration (using pages style): documentation: summary: ... pages: - name: Overview content: (== include overview.md ==) Note: you cannot specify both `overview` field and `pages` field.",
    )
    pages: Optional[List[Page]] = Field(
        None, description="The top level pages for the documentation set."
    )
    rules: Optional[List[DocumentationRule]] = Field(
        None,
        description='A list of documentation rules that apply to individual API elements. **NOTE:** All service configuration rules follow "last one wins" order.',
    )
    documentation_root_url: Optional[str] = Field(
        None,
        alias="documentationRootUrl",
        description="The URL to the root of documentation.",
    )
    summary: Optional[str] = Field(
        None,
        description="A short description of what the service does. The summary must be plain text. It becomes the overview of the service displayed in Google Cloud Console. NOTE: This field is equivalent to the standard field `description`.",
    )
    service_root_url: Optional[str] = Field(
        None,
        alias="serviceRootUrl",
        description="Specifies the service root url if the default one (the service name from the yaml file) is not suitable. This can be seen in any fully specified service urls as well as sections that show a base that other urls are relative to.",
    )


class Usage(BaseModel):
    producer_notification_channel: Optional[str] = Field(
        None,
        alias="producerNotificationChannel",
        description="The full resource name of a channel used for sending notifications to the service producer. Google Service Management currently only supports [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To use Google Cloud Pub/Sub as the channel, this must be the name of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format documented in https://cloud.google.com/pubsub/docs/overview.",
    )
    rules: Optional[List[UsageRule]] = Field(
        None,
        description='A list of usage rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.',
    )
    requirements: Optional[List[str]] = Field(
        None,
        description='Requirements that must be satisfied before a consumer project can use the service. Each requirement is of the form /; for example \'serviceusage.googleapis.com/billing-enabled\'. For Google APIs, a Terms of Service requirement must be included here. Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud". Other Google APIs should include "serviceusage.googleapis.com/tos/universal". Additional ToS can be included based on the business needs.',
    )


class Monitoring(BaseModel):
    consumer_destinations: Optional[List[MonitoringDestination]] = Field(
        None,
        alias="consumerDestinations",
        description="Monitoring configurations for sending metrics to the consumer project. There can be multiple consumer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.",
    )
    producer_destinations: Optional[List[MonitoringDestination]] = Field(
        None,
        alias="producerDestinations",
        description="Monitoring configurations for sending metrics to the producer project. There can be multiple producer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.",
    )


class Quota(BaseModel):
    limits: Optional[List[QuotaLimit]] = Field(
        None, description="List of `QuotaLimit` definitions for the service."
    )
    metric_rules: Optional[List[MetricRule]] = Field(
        None,
        alias="metricRules",
        description="List of `MetricRule` definitions, each one mapping a selected method to one or more metrics.",
    )


class Api(BaseModel):
    source_context: Optional[SourceContext] = Field(
        None,
        alias="sourceContext",
        description="Source context for the protocol buffer service represented by this message.",
    )
    version: Optional[str] = Field(
        None,
        description="A version string for this interface. If specified, must have the form `major-version.minor-version`, as in `1.10`. If the minor version is omitted, it defaults to zero. If the entire version field is empty, the major version is derived from the package name, as outlined below. If the field is not empty, the version in the package name will be verified to be consistent with what is provided here. The versioning schema uses [semantic versioning](http://semver.org) where the major version number indicates a breaking change and the minor version an additive, non-breaking change. Both version numbers are signals to users what to expect from different versions, and should be carefully chosen based on the product plan. The major version is also reflected in the package name of the interface, which must end in `v`, as in `google.feature.v1`. For major versions 0 and 1, the suffix can be omitted. Zero major versions must only be used for experimental, non-GA interfaces. ",
    )
    mixins: Optional[List[Mixin]] = Field(None, description="Included interfaces. See Mixin.")
    syntax: Optional[Syntax] = Field(None, description="The source syntax of the service.")
    name: Optional[str] = Field(
        None,
        description="The fully qualified name of this interface, including package name followed by the interface's simple name.",
    )
    methods: Optional[List[Method]] = Field(
        None, description="The methods of this interface, in unspecified order."
    )
    options: Optional[List[Option]] = Field(
        None, description="Any metadata attached to the interface."
    )


class ImportAdminOverridesResponse(BaseModel):
    overrides: Optional[List[QuotaOverride]] = Field(
        None, description="The overrides that were created from the imported data."
    )


class HttpRule(BaseModel):
    delete: Optional[str] = Field(
        None, description="Maps to HTTP DELETE. Used for deleting a resource."
    )
    response_body: Optional[str] = Field(
        None,
        alias="responseBody",
        description="Optional. The name of the response field whose value is mapped to the HTTP response body. When omitted, the entire response message will be used as the HTTP response body. NOTE: The referred field must be present at the top-level of the response message type.",
    )
    selector: Optional[str] = Field(
        None,
        description="Selects a method to which this rule applies. Refer to selector for syntax details.",
    )
    get: Optional[str] = Field(
        None,
        description="Maps to HTTP GET. Used for listing and getting information about resources.",
    )
    post: Optional[str] = Field(
        None,
        description="Maps to HTTP POST. Used for creating a resource or performing an action.",
    )
    patch: Optional[str] = Field(
        None, description="Maps to HTTP PATCH. Used for updating a resource."
    )
    put: Optional[str] = Field(None, description="Maps to HTTP PUT. Used for replacing a resource.")
    additional_bindings: Optional[List[HttpRule]] = Field(
        None,
        alias="additionalBindings",
        description="Additional HTTP bindings for the selector. Nested bindings must not contain an `additional_bindings` field themselves (that is, the nesting may only be one level deep).",
    )
    body: Optional[str] = Field(
        None,
        description="The name of the request field whose value is mapped to the HTTP request body, or `*` for mapping all request fields not captured by the path pattern to the HTTP body, or omitted for not having any HTTP request body. NOTE: the referred field must be present at the top-level of the request message type.",
    )
    custom: Optional[CustomHttpPattern] = Field(
        None,
        description='The custom pattern is used for specifying an HTTP method that is not included in the `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for this rule. The wild-card rule is useful for services that provide content to Web (HTML) clients.',
    )


class GoogleApiServiceusageV1beta1GetServiceIdentityResponse(BaseModel):
    state: Optional[State1] = Field(None, description="Service identity state.")
    identity: Optional[GoogleApiServiceusageV1beta1ServiceIdentity] = Field(
        None,
        description="Service identity that service producer can use to access consumer resources. If exists is true, it contains email and unique_id. If exists is false, it contains pre-constructed email and empty unique_id.",
    )


class CustomError(BaseModel):
    types: Optional[List[str]] = Field(
        None,
        description="The list of custom error detail types, e.g. 'google.foo.v1.CustomError'.",
    )
    rules: Optional[List[CustomErrorRule]] = Field(
        None,
        description='The list of custom error rules that apply to individual API messages. **NOTE:** All service configuration rules follow "last one wins" order.',
    )


class Logging(BaseModel):
    producer_destinations: Optional[List[LoggingDestination]] = Field(
        None,
        alias="producerDestinations",
        description="Logging configurations for sending logs to the producer project. There can be multiple producer destinations, each one must have a different monitored resource type. A log can be used in at most one producer destination.",
    )
    consumer_destinations: Optional[List[LoggingDestination]] = Field(
        None,
        alias="consumerDestinations",
        description="Logging configurations for sending logs to the consumer project. There can be multiple consumer destinations, each one must have a different monitored resource type. A log can be used in at most one consumer destination.",
    )


class Type(BaseModel):
    fields: Optional[List[FieldModel]] = Field(None, description="The list of fields.")
    oneofs: Optional[List[str]] = Field(
        None,
        description="The list of types appearing in `oneof` definitions in this type.",
    )
    name: Optional[str] = Field(None, description="The fully qualified message name.")
    options: Optional[List[Option]] = Field(None, description="The protocol buffer options.")
    source_context: Optional[SourceContext] = Field(
        None, alias="sourceContext", description="The source context."
    )
    syntax: Optional[Syntax] = Field(None, description="The source syntax.")


class SystemParameterRule(BaseModel):
    parameters: Optional[List[SystemParameter]] = Field(
        None,
        description="Define parameters. Multiple names may be defined for a parameter. For a given method call, only one of them should be used. If multiple names are used the behavior is implementation-dependent. If none of the specified names are present the behavior is parameter-dependent.",
    )
    selector: Optional[str] = Field(
        None,
        description="Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.",
    )


class Context(BaseModel):
    rules: Optional[List[ContextRule]] = Field(
        None,
        description='A list of RPC context rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.',
    )


class EnumModel(BaseModel):
    name: Optional[str] = Field(None, description="Enum type name.")
    options: Optional[List[Option]] = Field(None, description="Protocol buffer options.")
    enumvalue: Optional[List[EnumValue]] = Field(None, description="Enum value definitions.")
    syntax: Optional[Syntax] = Field(None, description="The source syntax.")
    source_context: Optional[SourceContext] = Field(
        None, alias="sourceContext", description="The source context."
    )


class Backend(BaseModel):
    rules: Optional[List[BackendRule]] = Field(
        None,
        description='A list of API backend rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.',
    )


class GetServiceIdentityResponse(BaseModel):
    state: Optional[State1] = Field(None, description="Service identity state.")
    identity: Optional[ServiceIdentity] = Field(
        None,
        description="Service identity that service producer can use to access consumer resources. If exists is true, it contains email and unique_id. If exists is false, it contains pre-constructed email and empty unique_id.",
    )


class ListOperationsResponse(BaseModel):
    operations: Optional[List[Operation]] = Field(
        None,
        description="A list of operations that matches the specified filter in the request.",
    )
    next_page_token: Optional[str] = Field(
        None, alias="nextPageToken", description="The standard List next-page token."
    )


class Authentication(BaseModel):
    providers: Optional[List[AuthProvider]] = Field(
        None,
        description="Defines a set of authentication providers that a service supports.",
    )
    rules: Optional[List[AuthenticationRule]] = Field(
        None,
        description='A list of authentication rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.',
    )


class Http(BaseModel):
    rules: Optional[List[HttpRule]] = Field(
        None,
        description='A list of HTTP configuration rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.',
    )
    fully_decode_reserved_expansion: Optional[bool] = Field(
        None,
        alias="fullyDecodeReservedExpansion",
        description='When set to true, URL path parameters will be fully URI-decoded except in cases of single segment matches in reserved expansion, where "%2F" will be left encoded. The default behavior is to not decode RFC 6570 reserved characters in multi segment matches.',
    )


class SystemParameters(BaseModel):
    rules: Optional[List[SystemParameterRule]] = Field(
        None,
        description='Define system parameters. The parameters defined here will override the default parameters implemented by the system. If this field is missing from the service config, default system parameters will be used. Default system parameters and names is implementation-dependent. Example: define api key for all methods system_parameters rules: - selector: "*" parameters: - name: api_key url_query_parameter: api_key Example: define 2 api key names for a specific method. system_parameters rules: - selector: "/ListShelves" parameters: - name: api_key http_header: Api-Key1 - name: api_key http_header: Api-Key2 **NOTE:** All service configuration rules follow "last one wins" order.',
    )


class GoogleApiServiceusageV1ServiceConfig(BaseModel):
    endpoints: Optional[List[Endpoint]] = Field(
        None,
        description="Configuration for network endpoints. Contains only the names and aliases of the endpoints.",
    )
    authentication: Optional[Authentication] = Field(
        None, description="Auth configuration. Contains only the OAuth rules."
    )
    monitored_resources: Optional[List[MonitoredResourceDescriptor]] = Field(
        None,
        alias="monitoredResources",
        description="Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.",
    )
    documentation: Optional[Documentation] = Field(
        None,
        description="Additional API documentation. Contains only the summary and the documentation URL.",
    )
    title: Optional[str] = Field(None, description="The product title for this service.")
    usage: Optional[Usage] = Field(
        None, description="Configuration controlling usage of this service."
    )
    monitoring: Optional[Monitoring] = Field(
        None,
        description="Monitoring configuration. This should not include the 'producer_destinations' field.",
    )
    quota: Optional[Quota] = Field(None, description="Quota configuration.")
    name: Optional[str] = Field(
        None,
        description="The DNS address at which this service is available. An example DNS address would be: `calendar.googleapis.com`.",
    )
    apis: Optional[List[Api]] = Field(
        None,
        description="A list of API interfaces exported by this service. Contains only the names, versions, and method names of the interfaces.",
    )


class GoogleApiService(BaseModel):
    billing: Optional[Billing] = Field(None, description="Billing configuration.")
    source_info: Optional[SourceInfo] = Field(
        None,
        alias="sourceInfo",
        description="Output only. The source information for this configuration if available.",
    )
    system_types: Optional[List[Type]] = Field(
        None,
        alias="systemTypes",
        description="A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.",
    )
    apis: Optional[List[Api]] = Field(
        None,
        description="A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.",
    )
    title: Optional[str] = Field(
        None,
        description="The product title for this service, it is the name displayed in Google Cloud Console.",
    )
    system_parameters: Optional[SystemParameters] = Field(
        None, alias="systemParameters", description="System parameter configuration."
    )
    usage: Optional[Usage] = Field(
        None, description="Configuration controlling usage of this service."
    )
    monitored_resources: Optional[List[MonitoredResourceDescriptor]] = Field(
        None,
        alias="monitoredResources",
        description="Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.",
    )
    producer_project_id: Optional[str] = Field(
        None,
        alias="producerProjectId",
        description="The Google project that owns this service.",
    )
    authentication: Optional[Authentication] = Field(None, description="Auth configuration.")
    metrics: Optional[List[MetricDescriptor]] = Field(
        None, description="Defines the metrics used by this service."
    )
    context: Optional[Context] = Field(None, description="Context configuration.")
    custom_error: Optional[CustomError] = Field(
        None, alias="customError", description="Custom error configuration."
    )
    monitoring: Optional[Monitoring] = Field(None, description="Monitoring configuration.")
    config_version: Optional[int] = Field(
        None,
        alias="configVersion",
        description="Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.",
    )
    logging: Optional[Logging] = Field(None, description="Logging configuration.")
    enums: Optional[List[EnumModel]] = Field(
        None,
        description="A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name by the configuration author. Example: enums: - name: google.someapi.v1.SomeEnum",
    )
    quota: Optional[Quota] = Field(None, description="Quota configuration.")
    name: Optional[str] = Field(
        None,
        description="The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.",
    )
    logs: Optional[List[LogDescriptor]] = Field(
        None, description="Defines the logs used by this service."
    )
    documentation: Optional[Documentation] = Field(
        None, description="Additional API documentation."
    )
    id: Optional[str] = Field(
        None,
        description="A unique ID for a specific instance of this message, typically assigned by the client for tracking purpose. Must be no longer than 63 characters and only lower case letters, digits, '.', '_' and '-' are allowed. If empty, the server may choose to generate one instead.",
    )
    control: Optional[Control] = Field(
        None, description="Configuration for the service control plane."
    )
    types: Optional[List[Type]] = Field(
        None,
        description="A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name by the configuration author. Example: types: - name: google.protobuf.Int32",
    )
    http: Optional[Http] = Field(None, description="HTTP configuration.")
    endpoints: Optional[List[Endpoint]] = Field(
        None,
        description="Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.",
    )
    backend: Optional[Backend] = Field(None, description="API backend configuration.")


class GoogleApiServiceusageV1Service(BaseModel):
    parent: Optional[str] = Field(
        None,
        description="The resource name of the consumer. A valid name would be: - projects/123",
    )
    name: Optional[str] = Field(
        None,
        description="The resource name of the consumer and service. A valid name would be: - projects/123/services/serviceusage.googleapis.com",
    )
    state: Optional[State] = Field(
        None,
        description="Whether or not the service has been enabled for use by the consumer.",
    )
    config: Optional[GoogleApiServiceusageV1ServiceConfig] = Field(
        None,
        description="The service configuration of the available service. Some fields may be filtered out of the configuration in responses to the `ListServices` method. These fields are present only in responses to the `GetService` method.",
    )


class BatchEnableServicesResponse(BaseModel):
    services: Optional[List[GoogleApiServiceusageV1Service]] = Field(
        None, description="The new state of the services after enabling."
    )
    failures: Optional[List[EnableFailure]] = Field(
        None,
        description="If allow_partial_success is true, and one or more services could not be enabled, this field contains the details about each failure.",
    )


class EnableServiceResponse(BaseModel):
    service: Optional[GoogleApiServiceusageV1Service] = Field(
        None, description="The new state of the service after enabling."
    )


class DisableServiceResponse(BaseModel):
    service: Optional[GoogleApiServiceusageV1Service] = Field(
        None, description="The new state of the service after disabling."
    )


class ListServicesResponse(BaseModel):
    services: Optional[List[GoogleApiServiceusageV1Service]] = Field(
        None, description="The available services for the requested project."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="Token that can be passed to `ListServices` to resume a paginated query.",
    )


class BatchGetServicesResponse(BaseModel):
    services: Optional[List[GoogleApiServiceusageV1Service]] = Field(
        None, description="The requested Service states."
    )


class Model(BaseModel):
    list_operations_response: Optional[ListOperationsResponse] = Field(
        None, alias="ListOperationsResponse"
    )
    source_info: Optional[SourceInfo] = Field(None, alias="SourceInfo")
    metric_descriptor: Optional[MetricDescriptor] = Field(None, alias="MetricDescriptor")
    delete_admin_quota_policy_metadata: Optional[DeleteAdminQuotaPolicyMetadata] = Field(
        None, alias="DeleteAdminQuotaPolicyMetadata"
    )
    disable_service_request: Optional[DisableServiceRequest] = Field(
        None, alias="DisableServiceRequest"
    )
    option: Optional[Option] = Field(None, alias="Option")
    batch_get_services_response: Optional[BatchGetServicesResponse] = Field(
        None, alias="BatchGetServicesResponse"
    )
    google_api_serviceusage_v1_operation_metadata: Optional[
        GoogleApiServiceusageV1OperationMetadata
    ] = Field(None, alias="GoogleApiServiceusageV1OperationMetadata")
    control: Optional[Control] = Field(None, alias="Control")
    monitoring_destination: Optional[MonitoringDestination] = Field(
        None, alias="MonitoringDestination"
    )
    import_admin_overrides_response: Optional[ImportAdminOverridesResponse] = Field(
        None, alias="ImportAdminOverridesResponse"
    )
    usage: Optional[Usage] = Field(None, alias="Usage")
    http: Optional[Http] = Field(None, alias="Http")
    google_api_serviceusage_v1beta1_get_service_identity_response: Optional[
        GoogleApiServiceusageV1beta1GetServiceIdentityResponse
    ] = Field(None, alias="GoogleApiServiceusageV1beta1GetServiceIdentityResponse")
    quota_limit: Optional[QuotaLimit] = Field(None, alias="QuotaLimit")
    endpoint: Optional[Endpoint] = Field(None, alias="Endpoint")
    quota: Optional[Quota] = Field(None, alias="Quota")
    api: Optional[Api] = Field(None, alias="Api")
    batch_enable_services_response: Optional[BatchEnableServicesResponse] = Field(
        None, alias="BatchEnableServicesResponse"
    )
    custom_error: Optional[CustomError] = Field(None, alias="CustomError")
    enable_service_request: Optional[EnableServiceRequest] = Field(
        None, alias="EnableServiceRequest"
    )
    mixin: Optional[Mixin] = Field(None, alias="Mixin")
    source_context: Optional[SourceContext] = Field(None, alias="SourceContext")
    update_admin_quota_policy_metadata: Optional[UpdateAdminQuotaPolicyMetadata] = Field(
        None, alias="UpdateAdminQuotaPolicyMetadata"
    )
    billing_destination: Optional[BillingDestination] = Field(None, alias="BillingDestination")
    logging: Optional[Logging] = Field(None, alias="Logging")
    google_api_service: Optional[GoogleApiService] = Field(None, alias="GoogleApiService")
    metric_descriptor_metadata: Optional[MetricDescriptorMetadata] = Field(
        None, alias="MetricDescriptorMetadata"
    )
    documentation_rule: Optional[DocumentationRule] = Field(None, alias="DocumentationRule")
    monitored_resource_descriptor: Optional[MonitoredResourceDescriptor] = Field(
        None, alias="MonitoredResourceDescriptor"
    )
    get_service_identity_metadata: Optional[GetServiceIdentityMetadata] = Field(
        None, alias="GetServiceIdentityMetadata"
    )
    import_consumer_overrides_response: Optional[ImportConsumerOverridesResponse] = Field(
        None, alias="ImportConsumerOverridesResponse"
    )
    enable_service_response: Optional[EnableServiceResponse] = Field(
        None, alias="EnableServiceResponse"
    )
    admin_quota_policy: Optional[AdminQuotaPolicy] = Field(None, alias="AdminQuotaPolicy")
    custom_http_pattern: Optional[CustomHttpPattern] = Field(None, alias="CustomHttpPattern")
    backend: Optional[Backend] = Field(None, alias="Backend")
    operation: Optional[Operation] = Field(None, alias="Operation")
    google_api_serviceusage_v1_service: Optional[GoogleApiServiceusageV1Service] = Field(
        None, alias="GoogleApiServiceusageV1Service"
    )
    http_rule: Optional[HttpRule] = Field(None, alias="HttpRule")
    jwt_location: Optional[JwtLocation] = Field(None, alias="JwtLocation")
    empty: Optional[Empty] = Field(None, alias="Empty")
    metric_rule: Optional[MetricRule] = Field(None, alias="MetricRule")
    enum_value: Optional[EnumValue] = Field(None, alias="EnumValue")
    import_consumer_overrides_metadata: Optional[ImportConsumerOverridesMetadata] = Field(
        None, alias="ImportConsumerOverridesMetadata"
    )
    field: Optional[FieldModel] = Field(None, alias="Field")
    google_api_serviceusage_v1_service_config: Optional[
        GoogleApiServiceusageV1ServiceConfig
    ] = Field(None, alias="GoogleApiServiceusageV1ServiceConfig")
    usage_rule: Optional[UsageRule] = Field(None, alias="UsageRule")
    enum: Optional[EnumModel] = Field(None, alias="Enum")
    operation_metadata: Optional[OperationMetadata] = Field(None, alias="OperationMetadata")
    context_rule: Optional[ContextRule] = Field(None, alias="ContextRule")
    system_parameter_rule: Optional[SystemParameterRule] = Field(None, alias="SystemParameterRule")
    import_admin_quota_policies_metadata: Optional[ImportAdminQuotaPoliciesMetadata] = Field(
        None, alias="ImportAdminQuotaPoliciesMetadata"
    )
    authentication: Optional[Authentication] = Field(None, alias="Authentication")
    backend_rule: Optional[BackendRule] = Field(None, alias="BackendRule")
    disable_service_response: Optional[DisableServiceResponse] = Field(
        None, alias="DisableServiceResponse"
    )
    o_auth_requirements: Optional[OAuthRequirements] = Field(None, alias="OAuthRequirements")
    get_service_identity_response: Optional[GetServiceIdentityResponse] = Field(
        None, alias="GetServiceIdentityResponse"
    )
    context: Optional[Context] = Field(None, alias="Context")
    enable_failure: Optional[EnableFailure] = Field(None, alias="EnableFailure")
    system_parameters: Optional[SystemParameters] = Field(None, alias="SystemParameters")
    cancel_operation_request: Optional[CancelOperationRequest] = Field(
        None, alias="CancelOperationRequest"
    )
    label_descriptor: Optional[LabelDescriptor] = Field(None, alias="LabelDescriptor")
    batch_create_consumer_overrides_response: Optional[
        BatchCreateConsumerOverridesResponse
    ] = Field(None, alias="BatchCreateConsumerOverridesResponse")
    service_identity: Optional[ServiceIdentity] = Field(None, alias="ServiceIdentity")
    monitoring: Optional[Monitoring] = Field(None, alias="Monitoring")
    custom_error_rule: Optional[CustomErrorRule] = Field(None, alias="CustomErrorRule")
    list_services_response: Optional[ListServicesResponse] = Field(
        None, alias="ListServicesResponse"
    )
    logging_destination: Optional[LoggingDestination] = Field(None, alias="LoggingDestination")
    import_admin_overrides_metadata: Optional[ImportAdminOverridesMetadata] = Field(
        None, alias="ImportAdminOverridesMetadata"
    )
    import_admin_quota_policies_response: Optional[ImportAdminQuotaPoliciesResponse] = Field(
        None, alias="ImportAdminQuotaPoliciesResponse"
    )
    type: Optional[Type] = Field(None, alias="Type")
    create_admin_quota_policy_metadata: Optional[CreateAdminQuotaPolicyMetadata] = Field(
        None, alias="CreateAdminQuotaPolicyMetadata"
    )
    method: Optional[Method] = Field(None, alias="Method")
    authentication_rule: Optional[AuthenticationRule] = Field(None, alias="AuthenticationRule")
    batch_enable_services_request: Optional[BatchEnableServicesRequest] = Field(
        None, alias="BatchEnableServicesRequest"
    )
    auth_requirement: Optional[AuthRequirement] = Field(None, alias="AuthRequirement")
    billing: Optional[Billing] = Field(None, alias="Billing")
    status: Optional[Status] = Field(None, alias="Status")
    system_parameter: Optional[SystemParameter] = Field(None, alias="SystemParameter")
    log_descriptor: Optional[LogDescriptor] = Field(None, alias="LogDescriptor")
    quota_override: Optional[QuotaOverride] = Field(None, alias="QuotaOverride")
    batch_create_admin_overrides_response: Optional[BatchCreateAdminOverridesResponse] = Field(
        None, alias="BatchCreateAdminOverridesResponse"
    )
    documentation: Optional[Documentation] = Field(None, alias="Documentation")
    google_api_serviceusage_v1beta1_service_identity: Optional[
        GoogleApiServiceusageV1beta1ServiceIdentity
    ] = Field(None, alias="GoogleApiServiceusageV1beta1ServiceIdentity")
    auth_provider: Optional[AuthProvider] = Field(None, alias="AuthProvider")
    page: Optional[Page] = Field(None, alias="Page")


Page.update_forward_refs()
HttpRule.update_forward_refs()
