# generated by datamodel-codegen:
#   filename:  schemas.json
#   timestamp: 2021-11-29T17:26:33+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class ListConstraint(BaseModel):
    suggested_value: Optional[str] = Field(
        None,
        alias="suggestedValue",
        description="Optional. The Google Cloud Console will try to default to a configuration that matches the value specified in this `Constraint`.",
    )
    supports_under: Optional[bool] = Field(
        None,
        alias="supportsUnder",
        description="Indicates whether subtrees of Cloud Resource Manager resource hierarchy can be used in `Policy.allowed_values` and `Policy.denied_values`. For example, `\"under:folders/123\"` would match any resource under the 'folders/123' folder.",
    )


class UpdateFolderMetadata(BaseModel):
    pass


class GetPolicyOptions(BaseModel):
    requested_policy_version: Optional[int] = Field(
        None,
        alias="requestedPolicyVersion",
        description="Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
    )


class UpdateTagKeyMetadata(BaseModel):
    pass


class AllValues(Enum):
    all_values_unspecified = "ALL_VALUES_UNSPECIFIED"
    allow = "ALLOW"
    deny = "DENY"


class ListPolicy(BaseModel):
    denied_values: Optional[List[str]] = Field(
        None,
        alias="deniedValues",
        description="List of values denied at this resource. Can only be set if `all_values` is set to `ALL_VALUES_UNSPECIFIED`.",
    )
    allowed_values: Optional[List[str]] = Field(
        None,
        alias="allowedValues",
        description="List of values allowed at this resource. Can only be set if `all_values` is set to `ALL_VALUES_UNSPECIFIED`.",
    )
    all_values: Optional[AllValues] = Field(
        None, alias="allValues", description="The policy all_values state."
    )
    suggested_value: Optional[str] = Field(
        None,
        alias="suggestedValue",
        description="Optional. The Google Cloud Console will try to default to a configuration that matches the value specified in this `Policy`. If `suggested_value` is not set, it will inherit the value specified higher in the hierarchy, unless `inherit_from_parent` is `false`.",
    )
    inherit_from_parent: Optional[bool] = Field(
        None,
        alias="inheritFromParent",
        description='Determines the inheritance behavior for this `Policy`. By default, a `ListPolicy` set at a resource supersedes any `Policy` set anywhere up the resource hierarchy. However, if `inherit_from_parent` is set to `true`, then the values from the effective `Policy` of the parent resource are inherited, meaning the values set in this `Policy` are added to the values inherited up the hierarchy. Setting `Policy` hierarchies that inherit both allowed values and denied values isn\'t recommended in most circumstances to keep the configuration simple and understandable. However, it is possible to set a `Policy` with `allowed_values` set that inherits a `Policy` with `denied_values` set. In this case, the values that are allowed must be in `allowed_values` and not present in `denied_values`. For example, suppose you have a `Constraint` `constraints/serviceuser.services`, which has a `constraint_type` of `list_constraint`, and with `constraint_default` set to `ALLOW`. Suppose that at the Organization level, a `Policy` is applied that restricts the allowed API activations to {`E1`, `E2`}. Then, if a `Policy` is applied to a project below the Organization that has `inherit_from_parent` set to `false` and field all_values set to DENY, then an attempt to activate any API will be denied. The following examples demonstrate different possible layerings for `projects/bar` parented by `organizations/foo`: Example 1 (no inherited values): `organizations/foo` has a `Policy` with values: {allowed_values: "E1" allowed_values:"E2"} `projects/bar` has `inherit_from_parent` `false` and values: {allowed_values: "E3" allowed_values: "E4"} The accepted values at `organizations/foo` are `E1`, `E2`. The accepted values at `projects/bar` are `E3`, and `E4`. Example 2 (inherited values): `organizations/foo` has a `Policy` with values: {allowed_values: "E1" allowed_values:"E2"} `projects/bar` has a `Policy` with values: {value: "E3" value: "E4" inherit_from_parent: true} The accepted values at `organizations/foo` are `E1`, `E2`. The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`. Example 3 (inheriting both allowed and denied values): `organizations/foo` has a `Policy` with values: {allowed_values: "E1" allowed_values: "E2"} `projects/bar` has a `Policy` with: {denied_values: "E1"} The accepted values at `organizations/foo` are `E1`, `E2`. The value accepted at `projects/bar` is `E2`. Example 4 (RestoreDefault): `organizations/foo` has a `Policy` with values: {allowed_values: "E1" allowed_values:"E2"} `projects/bar` has a `Policy` with values: {RestoreDefault: {}} The accepted values at `organizations/foo` are `E1`, `E2`. The accepted values at `projects/bar` are either all or none depending on the value of `constraint_default` (if `ALLOW`, all; if `DENY`, none). Example 5 (no policy inherits parent policy): `organizations/foo` has no `Policy` set. `projects/bar` has no `Policy` set. The accepted values at both levels are either all or none depending on the value of `constraint_default` (if `ALLOW`, all; if `DENY`, none). Example 6 (ListConstraint allowing all): `organizations/foo` has a `Policy` with values: {allowed_values: "E1" allowed_values: "E2"} `projects/bar` has a `Policy` with: {all: ALLOW} The accepted values at `organizations/foo` are `E1`, E2`. Any value is accepted at `projects/bar`. Example 7 (ListConstraint allowing none): `organizations/foo` has a `Policy` with values: {allowed_values: "E1" allowed_values: "E2"} `projects/bar` has a `Policy` with: {all: DENY} The accepted values at `organizations/foo` are `E1`, E2`. No value is accepted at `projects/bar`. Example 10 (allowed and denied subtrees of Resource Manager hierarchy): Given the following resource hierarchy O1->{F1, F2}; F1->{P1}; F2->{P2, P3}, `organizations/foo` has a `Policy` with values: {allowed_values: "under:organizations/O1"} `projects/bar` has a `Policy` with: {allowed_values: "under:projects/P3"} {denied_values: "under:folders/F2"} The accepted values at `organizations/foo` are `organizations/O1`, `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`, `projects/P3`. The accepted values at `projects/bar` are `organizations/O1`, `folders/F1`, `projects/P1`.',
    )


class CreateTagBindingMetadata(BaseModel):
    pass


class Expr(BaseModel):
    expression: Optional[str] = Field(
        None,
        description="Textual representation of an expression in Common Expression Language syntax.",
    )
    title: Optional[str] = Field(
        None,
        description="Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.",
    )
    description: Optional[str] = Field(
        None,
        description="Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.",
    )
    location: Optional[str] = Field(
        None,
        description="Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.",
    )


class LogType(Enum):
    log_type_unspecified = "LOG_TYPE_UNSPECIFIED"
    admin_read = "ADMIN_READ"
    data_write = "DATA_WRITE"
    data_read = "DATA_READ"


class AuditLogConfig(BaseModel):
    log_type: Optional[LogType] = Field(
        None, alias="logType", description="The log type that this config enables."
    )
    exempted_members: Optional[List[str]] = Field(
        None,
        alias="exemptedMembers",
        description="Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.",
    )


class DeleteFolderMetadata(BaseModel):
    pass


class DeleteTagKeyMetadata(BaseModel):
    pass


class UndeleteProjectMetadata(BaseModel):
    pass


class Lien(BaseModel):
    name: Optional[str] = Field(
        None,
        description="A system-generated unique identifier for this Lien. Example: `liens/1234abcd`",
    )
    restrictions: Optional[List[str]] = Field(
        None,
        description="The types of operations which should be blocked as a result of this Lien. Each value should correspond to an IAM permission. The server will validate the permissions against those for which Liens are supported. An empty list is meaningless and will be rejected. Example: ['resourcemanager.projects.delete']",
    )
    parent: Optional[str] = Field(
        None,
        description="A reference to the resource this Lien is attached to. The server will validate the parent against those for which Liens are supported. Example: `projects/1234`",
    )
    create_time: Optional[str] = Field(
        None, alias="createTime", description="The creation time of this Lien."
    )
    reason: Optional[str] = Field(
        None,
        description="Concise user-visible strings indicating why an action cannot be performed on a resource. Maximum length of 200 characters. Example: 'Holds production API key'",
    )
    origin: Optional[str] = Field(
        None,
        description="A stable, user-visible/meaningful string identifying the origin of the Lien, intended to be inspected programmatically. Maximum length of 200 characters. Example: 'compute.googleapis.com'",
    )


class UpdateTagValueMetadata(BaseModel):
    pass


class LifecycleState(Enum):
    lifecycle_state_unspecified = "LIFECYCLE_STATE_UNSPECIFIED"
    active = "ACTIVE"
    delete_requested = "DELETE_REQUESTED"


class OrganizationOwner(BaseModel):
    directory_customer_id: Optional[str] = Field(
        None,
        alias="directoryCustomerId",
        description="The G Suite customer id used in the Directory API.",
    )


class SearchOrganizationsRequest(BaseModel):
    filter: Optional[str] = Field(
        None,
        description="An optional query string used to filter the Organizations to return in the response. Filter rules are case-insensitive. Organizations may be filtered by `owner.directoryCustomerId` or by `domain`, where the domain is a G Suite domain, for example: * Filter `owner.directorycustomerid:123456789` returns Organization resources with `owner.directory_customer_id` equal to `123456789`. * Filter `domain:google.com` returns Organization resources corresponding to the domain `google.com`. This field is optional.",
    )
    page_size: Optional[int] = Field(
        None,
        alias="pageSize",
        description="The maximum number of Organizations to return in the response. The server can return fewer organizations than requested. If unspecified, server picks an appropriate default.",
    )
    page_token: Optional[str] = Field(
        None,
        alias="pageToken",
        description="A pagination token returned from a previous call to `SearchOrganizations` that indicates from where listing should continue. This field is optional.",
    )


class RestoreDefault(BaseModel):
    pass


class BooleanPolicy(BaseModel):
    enforced: Optional[bool] = Field(
        None,
        description="If `true`, then the `Policy` is enforced. If `false`, then any configuration is acceptable. Suppose you have a `Constraint` `constraints/compute.disableSerialPortAccess` with `constraint_default` set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following behavior: - If the `Policy` at this resource has enforced set to `false`, serial port connection attempts will be allowed. - If the `Policy` at this resource has enforced set to `true`, serial port connection attempts will be refused. - If the `Policy` at this resource is `RestoreDefault`, serial port connection attempts will be allowed. - If no `Policy` is set at this resource or anywhere higher in the resource hierarchy, serial port connection attempts will be allowed. - If no `Policy` is set at this resource, but one exists higher in the resource hierarchy, the behavior is as if the`Policy` were set at this resource. The following examples demonstrate the different possible layerings: Example 1 (nearest `Constraint` wins): `organizations/foo` has a `Policy` with: {enforced: false} `projects/bar` has no `Policy` set. The constraint at `projects/bar` and `organizations/foo` will not be enforced. Example 2 (enforcement gets replaced): `organizations/foo` has a `Policy` with: {enforced: false} `projects/bar` has a `Policy` with: {enforced: true} The constraint at `organizations/foo` is not enforced. The constraint at `projects/bar` is enforced. Example 3 (RestoreDefault): `organizations/foo` has a `Policy` with: {enforced: true} `projects/bar` has a `Policy` with: {RestoreDefault: {}} The constraint at `organizations/foo` is enforced. The constraint at `projects/bar` is not enforced, because `constraint_default` for the `Constraint` is `ALLOW`.",
    )


class ResourceId(BaseModel):
    id: Optional[str] = Field(
        None,
        description="The type-specific id. This should correspond to the id used in the type-specific API's.",
    )
    type: Optional[str] = Field(
        None,
        description='The resource type this id is for. At present, the valid types are: "organization", "folder", and "project".',
    )


class Status(BaseModel):
    details: Optional[List[Dict[str, Dict[str, Any]]]] = Field(
        None,
        description="A list of messages that carry the error details. There is a common set of message types for APIs to use.",
    )
    code: Optional[int] = Field(
        None,
        description="The status code, which should be an enum value of google.rpc.Code.",
    )
    message: Optional[str] = Field(
        None,
        description="A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.",
    )


class UndeleteProjectRequest(BaseModel):
    pass


class OperationType(Enum):
    operation_type_unspecified = "OPERATION_TYPE_UNSPECIFIED"
    create = "CREATE"
    move = "MOVE"


class CloudresourcemanagerGoogleCloudResourcemanagerV2beta1FolderOperation(BaseModel):
    display_name: Optional[str] = Field(
        None, alias="displayName", description="The display name of the folder."
    )
    destination_parent: Optional[str] = Field(
        None,
        alias="destinationParent",
        description="The resource name of the folder or organization we are either creating the folder under or moving the folder to.",
    )
    operation_type: Optional[OperationType] = Field(
        None, alias="operationType", description="The type of this operation."
    )
    source_parent: Optional[str] = Field(
        None,
        alias="sourceParent",
        description="The resource name of the folder's parent. Only applicable when the operation_type is MOVE.",
    )


class CreateFolderMetadata(BaseModel):
    parent: Optional[str] = Field(
        None,
        description="The resource name of the folder or organization we are creating the folder under.",
    )
    display_name: Optional[str] = Field(
        None, alias="displayName", description="The display name of the folder."
    )


class DeleteTagValueMetadata(BaseModel):
    pass


class MoveProjectMetadata(BaseModel):
    pass


class UndeleteOrganizationMetadata(BaseModel):
    pass


class MoveFolderMetadata(BaseModel):
    display_name: Optional[str] = Field(
        None, alias="displayName", description="The display name of the folder."
    )
    source_parent: Optional[str] = Field(
        None,
        alias="sourceParent",
        description="The resource name of the folder's parent.",
    )
    destination_parent: Optional[str] = Field(
        None,
        alias="destinationParent",
        description="The resource name of the folder or organization to move the folder to.",
    )


class TestIamPermissionsRequest(BaseModel):
    permissions: Optional[List[str]] = Field(
        None,
        description="The set of permissions to check for the `resource`. Permissions with wildcards (such as '*' or 'storage.*') are not allowed. For more information see [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).",
    )


class ConstraintDefault(Enum):
    constraint_default_unspecified = "CONSTRAINT_DEFAULT_UNSPECIFIED"
    allow = "ALLOW"
    deny = "DENY"


class BooleanConstraint(BaseModel):
    pass


class GetOrgPolicyRequest(BaseModel):
    constraint: Optional[str] = Field(
        None, description="Name of the `Constraint` to get the `Policy`."
    )


class CloudresourcemanagerGoogleCloudResourcemanagerV2alpha1FolderOperation(BaseModel):
    destination_parent: Optional[str] = Field(
        None,
        alias="destinationParent",
        description="The resource name of the folder or organization we are either creating the folder under or moving the folder to.",
    )
    source_parent: Optional[str] = Field(
        None,
        alias="sourceParent",
        description="The resource name of the folder's parent. Only applicable when the operation_type is MOVE.",
    )
    operation_type: Optional[OperationType] = Field(
        None, alias="operationType", description="The type of this operation."
    )
    display_name: Optional[str] = Field(
        None, alias="displayName", description="The display name of the folder."
    )


class Empty(BaseModel):
    pass


class ListAvailableOrgPolicyConstraintsRequest(BaseModel):
    page_token: Optional[str] = Field(
        None,
        alias="pageToken",
        description="Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.",
    )
    page_size: Optional[int] = Field(
        None,
        alias="pageSize",
        description="Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.",
    )


class FolderOperation(BaseModel):
    display_name: Optional[str] = Field(
        None, alias="displayName", description="The display name of the folder."
    )
    operation_type: Optional[OperationType] = Field(
        None, alias="operationType", description="The type of this operation."
    )
    source_parent: Optional[str] = Field(
        None,
        alias="sourceParent",
        description="The resource name of the folder's parent. Only applicable when the operation_type is MOVE.",
    )
    destination_parent: Optional[str] = Field(
        None,
        alias="destinationParent",
        description="The resource name of the folder or organization we are either creating the folder under or moving the folder to.",
    )


class LifecycleState1(Enum):
    lifecycle_state_unspecified = "LIFECYCLE_STATE_UNSPECIFIED"
    active = "ACTIVE"
    delete_requested = "DELETE_REQUESTED"
    delete_in_progress = "DELETE_IN_PROGRESS"


class Project(BaseModel):
    project_number: Optional[str] = Field(
        None,
        alias="projectNumber",
        description="The number uniquely identifying the project. Example: `415104041262` Read-only.",
    )
    parent: Optional[ResourceId] = Field(
        None,
        description='An optional reference to a parent Resource. Supported parent types include "organization" and "folder". Once set, the parent cannot be cleared. The `parent` can be set on creation or using the `UpdateProject` method; the end user must have the `resourcemanager.projects.create` permission on the parent.',
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="The unique, user-assigned ID of the Project. It must be 6 to 30 lowercase letters, digits, or hyphens. It must start with a letter. Trailing hyphens are prohibited. Example: `tokyo-rain-123` Read-only after creation.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='The labels associated with this Project. Label keys must be between 1 and 63 characters long and must conform to the following regular expression: a-z{0,62}. Label values must be between 0 and 63 characters long and must conform to the regular expression [a-z0-9_-]{0,63}. A label value can be empty. No more than 256 labels can be associated with a given resource. Clients should store labels in a representation such as JSON that does not depend on specific characters being disallowed. Example: "environment" : "dev" Read-write.',
    )
    lifecycle_state: Optional[LifecycleState1] = Field(
        None,
        alias="lifecycleState",
        description="The Project lifecycle state. Read-only.",
    )
    name: Optional[str] = Field(
        None,
        description="The optional user-assigned display name of the Project. When present it must be between 4 to 30 characters. Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point. Example: `My Project` Read-write.",
    )
    create_time: Optional[str] = Field(
        None, alias="createTime", description="Creation time. Read-only."
    )


class CreateTagKeyMetadata(BaseModel):
    pass


class ClearOrgPolicyRequest(BaseModel):
    etag: Optional[str] = Field(
        None,
        description="The current version, for concurrency control. Not sending an `etag` will cause the `Policy` to be cleared blindly.",
    )
    constraint: Optional[str] = Field(
        None, description="Name of the `Constraint` of the `Policy` to clear."
    )


class DeleteProjectMetadata(BaseModel):
    pass


class ListProjectsResponse(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="Pagination token. If the result set is too large to fit in a single response, this token is returned. It encodes the position of the current result cursor. Feeding this value into a new list request with the `page_token` parameter gives the next page of the results. When `next_page_token` is not filled in, there is no next page and the list returned is the last page in the result set. Pagination tokens have a limited lifetime.",
    )
    projects: Optional[List[Project]] = Field(
        None,
        description="The list of Projects that matched the list filter. This list can be paginated.",
    )


class ProjectCreationStatus(BaseModel):
    create_time: Optional[str] = Field(
        None,
        alias="createTime",
        description="Creation time of the project creation workflow.",
    )
    ready: Optional[bool] = Field(
        None, description="True if the project creation process is complete."
    )
    gettable: Optional[bool] = Field(
        None,
        description="True if the project can be retrieved using GetProject. No other operations on the project are guaranteed to work until the project creation is complete.",
    )


class DeleteOrganizationMetadata(BaseModel):
    pass


class ListLiensResponse(BaseModel):
    liens: Optional[List[Lien]] = Field(None, description="A list of Liens.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="Token to retrieve the next page of results, or empty if there are no more results in the list.",
    )


class DeleteTagBindingMetadata(BaseModel):
    pass


class GetEffectiveOrgPolicyRequest(BaseModel):
    constraint: Optional[str] = Field(
        None,
        description="The name of the `Constraint` to compute the effective `Policy`.",
    )


class CreateTagValueMetadata(BaseModel):
    pass


class UpdateProjectMetadata(BaseModel):
    pass


class UndeleteFolderMetadata(BaseModel):
    pass


class TestIamPermissionsResponse(BaseModel):
    permissions: Optional[List[str]] = Field(
        None,
        description="A subset of `TestPermissionsRequest.permissions` that the caller is allowed.",
    )


class GetAncestryRequest(BaseModel):
    pass


class ErrorMessageId(Enum):
    error_type_unspecified = "ERROR_TYPE_UNSPECIFIED"
    active_folder_height_violation = "ACTIVE_FOLDER_HEIGHT_VIOLATION"
    max_child_folders_violation = "MAX_CHILD_FOLDERS_VIOLATION"
    folder_name_uniqueness_violation = "FOLDER_NAME_UNIQUENESS_VIOLATION"
    resource_deleted_violation = "RESOURCE_DELETED_VIOLATION"
    parent_deleted_violation = "PARENT_DELETED_VIOLATION"
    cycle_introduced_violation = "CYCLE_INTRODUCED_VIOLATION"
    folder_being_moved_violation = "FOLDER_BEING_MOVED_VIOLATION"
    folder_to_delete_non_empty_violation = "FOLDER_TO_DELETE_NON_EMPTY_VIOLATION"
    deleted_folder_height_violation = "DELETED_FOLDER_HEIGHT_VIOLATION"


class FolderOperationError(BaseModel):
    error_message_id: Optional[ErrorMessageId] = Field(
        None,
        alias="errorMessageId",
        description="The type of operation error experienced.",
    )


class CreateProjectMetadata(BaseModel):
    ready: Optional[bool] = Field(
        None, description="True if the project creation process is complete."
    )
    create_time: Optional[str] = Field(
        None,
        alias="createTime",
        description="Creation time of the project creation workflow.",
    )
    gettable: Optional[bool] = Field(
        None,
        description="True if the project can be retrieved using `GetProject`. No other operations on the project are guaranteed to work until the project creation is complete.",
    )


class ListOrgPoliciesRequest(BaseModel):
    page_token: Optional[str] = Field(
        None,
        alias="pageToken",
        description="Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.",
    )
    page_size: Optional[int] = Field(
        None,
        alias="pageSize",
        description="Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.",
    )


class GetIamPolicyRequest(BaseModel):
    options: Optional[GetPolicyOptions] = Field(
        None,
        description="OPTIONAL: A `GetPolicyOptions` object for specifying options to `GetIamPolicy`.",
    )


class Binding(BaseModel):
    role: Optional[str] = Field(
        None,
        description="Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.",
    )
    condition: Optional[Expr] = Field(
        None,
        description="The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
    )
    members: Optional[List[str]] = Field(
        None,
        description="Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. ",
    )


class AuditConfig(BaseModel):
    audit_log_configs: Optional[List[AuditLogConfig]] = Field(
        None,
        alias="auditLogConfigs",
        description="The configuration for logging of each type of permission.",
    )
    service: Optional[str] = Field(
        None,
        description="Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.",
    )


class Organization(BaseModel):
    lifecycle_state: Optional[LifecycleState] = Field(
        None,
        alias="lifecycleState",
        description="The organization's current lifecycle state. Assigned by the server.",
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description='A human-readable string that refers to the Organization in the GCP Console UI. This string is set by the server and cannot be changed. The string will be set to the primary domain (for example, "google.com") of the G Suite customer that owns the organization.',
    )
    creation_time: Optional[str] = Field(
        None,
        alias="creationTime",
        description="Timestamp when the Organization was created. Assigned by the server.",
    )
    name: Optional[str] = Field(
        None,
        description='Output only. The resource name of the organization. This is the organization\'s relative path in the API. Its format is "organizations/[organization_id]". For example, "organizations/1234".',
    )
    owner: Optional[OrganizationOwner] = Field(
        None,
        description="The owner of this Organization. The owner should be specified on creation. Once set, it cannot be changed. This field is required.",
    )


class OrgPolicy(BaseModel):
    constraint: Optional[str] = Field(
        None,
        description="The name of the `Constraint` the `Policy` is configuring, for example, `constraints/serviceuser.services`. A [list of available constraints](/resource-manager/docs/organization-policy/org-policy-constraints) is available. Immutable after creation.",
    )
    update_time: Optional[str] = Field(
        None,
        alias="updateTime",
        description="The time stamp the `Policy` was previously updated. This is set by the server, not specified by the caller, and represents the last time a call to `SetOrgPolicy` was made for that `Policy`. Any value set by the client will be ignored.",
    )
    restore_default: Optional[RestoreDefault] = Field(
        None,
        alias="restoreDefault",
        description="Restores the default behavior of the constraint; independent of `Constraint` type.",
    )
    version: Optional[int] = Field(
        None, description="Version of the `Policy`. Default version is 0;"
    )
    list_policy: Optional[ListPolicy] = Field(
        None,
        alias="listPolicy",
        description="List of values either allowed or disallowed.",
    )
    boolean_policy: Optional[BooleanPolicy] = Field(
        None,
        alias="booleanPolicy",
        description="For boolean `Constraints`, whether to enforce the `Constraint` or not.",
    )
    etag: Optional[str] = Field(
        None,
        description="An opaque tag indicating the current version of the `Policy`, used for concurrency control. When the `Policy` is returned from either a `GetPolicy` or a `ListOrgPolicy` request, this `etag` indicates the version of the current `Policy` to use when executing a read-modify-write loop. When the `Policy` is returned from a `GetEffectivePolicy` request, the `etag` will be unset. When the `Policy` is used in a `SetOrgPolicy` method, use the `etag` value that was returned from a `GetOrgPolicy` request as part of a read-modify-write loop for concurrency control. Not setting the `etag`in a `SetOrgPolicy` request will result in an unconditional write of the `Policy`.",
    )


class Ancestor(BaseModel):
    resource_id: Optional[ResourceId] = Field(
        None, alias="resourceId", description="Resource id of the ancestor."
    )


class Operation(BaseModel):
    metadata: Optional[Dict[str, Dict[str, Any]]] = Field(
        None,
        description="Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.",
    )
    error: Optional[Status] = Field(
        None,
        description="The error result of the operation in case of failure or cancellation.",
    )
    name: Optional[str] = Field(
        None,
        description="The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.",
    )
    done: Optional[bool] = Field(
        None,
        description="If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.",
    )
    response: Optional[Dict[str, Dict[str, Any]]] = Field(
        None,
        description="The normal response of the operation in case of success. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.",
    )


class Constraint(BaseModel):
    display_name: Optional[str] = Field(
        None, alias="displayName", description="The human readable name. Mutable."
    )
    list_constraint: Optional[ListConstraint] = Field(
        None,
        alias="listConstraint",
        description="Defines this constraint as being a ListConstraint.",
    )
    version: Optional[int] = Field(
        None, description="Version of the `Constraint`. Default version is 0;"
    )
    name: Optional[str] = Field(
        None,
        description="Immutable value, required to globally be unique. For example, `constraints/serviceuser.services`",
    )
    constraint_default: Optional[ConstraintDefault] = Field(
        None,
        alias="constraintDefault",
        description="The evaluation behavior of this constraint in the absence of 'Policy'.",
    )
    boolean_constraint: Optional[BooleanConstraint] = Field(
        None,
        alias="booleanConstraint",
        description="Defines this constraint as being a BooleanConstraint.",
    )
    description: Optional[str] = Field(
        None,
        description="Detailed description of what this `Constraint` controls as well as how and where it is enforced. Mutable.",
    )


class ListOrgPoliciesResponse(BaseModel):
    policies: Optional[List[OrgPolicy]] = Field(
        None,
        description="The `Policies` that are set on the resource. It will be empty if no `Policies` are set.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="Page token used to retrieve the next page. This is currently not used, but the server may at any point start supplying a valid token.",
    )


class ListAvailableOrgPolicyConstraintsResponse(BaseModel):
    constraints: Optional[List[Constraint]] = Field(
        None,
        description="The collection of constraints that are settable on the request resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="Page token used to retrieve the next page. This is currently not used.",
    )


class SetOrgPolicyRequest(BaseModel):
    policy: Optional[OrgPolicy] = Field(None, description="`Policy` to set on the resource.")


class Policy(BaseModel):
    bindings: Optional[List[Binding]] = Field(
        None,
        description="Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.",
    )
    etag: Optional[str] = Field(
        None,
        description="`etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.",
    )
    audit_configs: Optional[List[AuditConfig]] = Field(
        None,
        alias="auditConfigs",
        description="Specifies cloud audit logging configuration for this policy.",
    )
    version: Optional[int] = Field(
        None,
        description="Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
    )


class SearchOrganizationsResponse(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="A pagination token to be used to retrieve the next page of results. If the result is too large to fit within the page size specified in the request, this field will be set with a token that can be used to fetch the next page of results. If this field is empty, it indicates that this response contains the last page of results.",
    )
    organizations: Optional[List[Organization]] = Field(
        None,
        description="The list of Organizations that matched the search query, possibly paginated.",
    )


class GetAncestryResponse(BaseModel):
    ancestor: Optional[List[Ancestor]] = Field(
        None,
        description="Ancestors are ordered from bottom to top of the resource hierarchy. The first ancestor is the project itself, followed by the project's parent, etc..",
    )


class SetIamPolicyRequest(BaseModel):
    policy: Optional[Policy] = Field(
        None,
        description="REQUIRED: The complete policy to be applied to the `resource`. The size of the policy is limited to a few 10s of KB. An empty policy is a valid policy but certain Cloud Platform services (such as Projects) might reject them.",
    )
    update_mask: Optional[str] = Field(
        None,
        alias="updateMask",
        description='OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only the fields in the mask will be modified. If no mask is provided, the following default mask is used: `paths: "bindings, etag"`',
    )


class Model(BaseModel):
    list_constraint: Optional[ListConstraint] = Field(None, alias="ListConstraint")
    update_folder_metadata: Optional[UpdateFolderMetadata] = Field(
        None, alias="UpdateFolderMetadata"
    )
    get_iam_policy_request: Optional[GetIamPolicyRequest] = Field(None, alias="GetIamPolicyRequest")
    update_tag_key_metadata: Optional[UpdateTagKeyMetadata] = Field(
        None, alias="UpdateTagKeyMetadata"
    )
    list_policy: Optional[ListPolicy] = Field(None, alias="ListPolicy")
    create_tag_binding_metadata: Optional[CreateTagBindingMetadata] = Field(
        None, alias="CreateTagBindingMetadata"
    )
    policy: Optional[Policy] = Field(None, alias="Policy")
    delete_folder_metadata: Optional[DeleteFolderMetadata] = Field(
        None, alias="DeleteFolderMetadata"
    )
    delete_tag_key_metadata: Optional[DeleteTagKeyMetadata] = Field(
        None, alias="DeleteTagKeyMetadata"
    )
    undelete_project_metadata: Optional[UndeleteProjectMetadata] = Field(
        None, alias="UndeleteProjectMetadata"
    )
    lien: Optional[Lien] = Field(None, alias="Lien")
    update_tag_value_metadata: Optional[UpdateTagValueMetadata] = Field(
        None, alias="UpdateTagValueMetadata"
    )
    search_organizations_response: Optional[SearchOrganizationsResponse] = Field(
        None, alias="SearchOrganizationsResponse"
    )
    search_organizations_request: Optional[SearchOrganizationsRequest] = Field(
        None, alias="SearchOrganizationsRequest"
    )
    org_policy: Optional[OrgPolicy] = Field(None, alias="OrgPolicy")
    get_policy_options: Optional[GetPolicyOptions] = Field(None, alias="GetPolicyOptions")
    get_ancestry_response: Optional[GetAncestryResponse] = Field(None, alias="GetAncestryResponse")
    organization_owner: Optional[OrganizationOwner] = Field(None, alias="OrganizationOwner")
    expr: Optional[Expr] = Field(None, alias="Expr")
    set_iam_policy_request: Optional[SetIamPolicyRequest] = Field(None, alias="SetIamPolicyRequest")
    operation: Optional[Operation] = Field(None, alias="Operation")
    undelete_project_request: Optional[UndeleteProjectRequest] = Field(
        None, alias="UndeleteProjectRequest"
    )
    cloudresourcemanager_google_cloud_resourcemanager_v2beta1_folder_operation: Optional[
        CloudresourcemanagerGoogleCloudResourcemanagerV2beta1FolderOperation
    ] = Field(
        None,
        alias="CloudresourcemanagerGoogleCloudResourcemanagerV2beta1FolderOperation",
    )
    create_folder_metadata: Optional[CreateFolderMetadata] = Field(
        None, alias="CreateFolderMetadata"
    )
    delete_tag_value_metadata: Optional[DeleteTagValueMetadata] = Field(
        None, alias="DeleteTagValueMetadata"
    )
    move_project_metadata: Optional[MoveProjectMetadata] = Field(None, alias="MoveProjectMetadata")
    undelete_organization_metadata: Optional[UndeleteOrganizationMetadata] = Field(
        None, alias="UndeleteOrganizationMetadata"
    )
    move_folder_metadata: Optional[MoveFolderMetadata] = Field(None, alias="MoveFolderMetadata")
    test_iam_permissions_request: Optional[TestIamPermissionsRequest] = Field(
        None, alias="TestIamPermissionsRequest"
    )
    constraint: Optional[Constraint] = Field(None, alias="Constraint")
    list_org_policies_response: Optional[ListOrgPoliciesResponse] = Field(
        None, alias="ListOrgPoliciesResponse"
    )
    get_org_policy_request: Optional[GetOrgPolicyRequest] = Field(None, alias="GetOrgPolicyRequest")
    cloudresourcemanager_google_cloud_resourcemanager_v2alpha1_folder_operation: Optional[
        CloudresourcemanagerGoogleCloudResourcemanagerV2alpha1FolderOperation
    ] = Field(
        None,
        alias="CloudresourcemanagerGoogleCloudResourcemanagerV2alpha1FolderOperation",
    )
    empty: Optional[Empty] = Field(None, alias="Empty")
    list_available_org_policy_constraints_request: Optional[
        ListAvailableOrgPolicyConstraintsRequest
    ] = Field(None, alias="ListAvailableOrgPolicyConstraintsRequest")
    folder_operation: Optional[FolderOperation] = Field(None, alias="FolderOperation")
    list_available_org_policy_constraints_response: Optional[
        ListAvailableOrgPolicyConstraintsResponse
    ] = Field(None, alias="ListAvailableOrgPolicyConstraintsResponse")
    resource_id: Optional[ResourceId] = Field(None, alias="ResourceId")
    project: Optional[Project] = Field(None, alias="Project")
    create_tag_key_metadata: Optional[CreateTagKeyMetadata] = Field(
        None, alias="CreateTagKeyMetadata"
    )
    clear_org_policy_request: Optional[ClearOrgPolicyRequest] = Field(
        None, alias="ClearOrgPolicyRequest"
    )
    organization: Optional[Organization] = Field(None, alias="Organization")
    delete_project_metadata: Optional[DeleteProjectMetadata] = Field(
        None, alias="DeleteProjectMetadata"
    )
    audit_config: Optional[AuditConfig] = Field(None, alias="AuditConfig")
    list_projects_response: Optional[ListProjectsResponse] = Field(
        None, alias="ListProjectsResponse"
    )
    project_creation_status: Optional[ProjectCreationStatus] = Field(
        None, alias="ProjectCreationStatus"
    )
    boolean_constraint: Optional[BooleanConstraint] = Field(None, alias="BooleanConstraint")
    delete_organization_metadata: Optional[DeleteOrganizationMetadata] = Field(
        None, alias="DeleteOrganizationMetadata"
    )
    list_liens_response: Optional[ListLiensResponse] = Field(None, alias="ListLiensResponse")
    audit_log_config: Optional[AuditLogConfig] = Field(None, alias="AuditLogConfig")
    ancestor: Optional[Ancestor] = Field(None, alias="Ancestor")
    set_org_policy_request: Optional[SetOrgPolicyRequest] = Field(None, alias="SetOrgPolicyRequest")
    delete_tag_binding_metadata: Optional[DeleteTagBindingMetadata] = Field(
        None, alias="DeleteTagBindingMetadata"
    )
    get_effective_org_policy_request: Optional[GetEffectiveOrgPolicyRequest] = Field(
        None, alias="GetEffectiveOrgPolicyRequest"
    )
    binding: Optional[Binding] = Field(None, alias="Binding")
    create_tag_value_metadata: Optional[CreateTagValueMetadata] = Field(
        None, alias="CreateTagValueMetadata"
    )
    update_project_metadata: Optional[UpdateProjectMetadata] = Field(
        None, alias="UpdateProjectMetadata"
    )
    undelete_folder_metadata: Optional[UndeleteFolderMetadata] = Field(
        None, alias="UndeleteFolderMetadata"
    )
    restore_default: Optional[RestoreDefault] = Field(None, alias="RestoreDefault")
    boolean_policy: Optional[BooleanPolicy] = Field(None, alias="BooleanPolicy")
    test_iam_permissions_response: Optional[TestIamPermissionsResponse] = Field(
        None, alias="TestIamPermissionsResponse"
    )
    get_ancestry_request: Optional[GetAncestryRequest] = Field(None, alias="GetAncestryRequest")
    folder_operation_error: Optional[FolderOperationError] = Field(
        None, alias="FolderOperationError"
    )
    status: Optional[Status] = Field(None, alias="Status")
    create_project_metadata: Optional[CreateProjectMetadata] = Field(
        None, alias="CreateProjectMetadata"
    )
    list_org_policies_request: Optional[ListOrgPoliciesRequest] = Field(
        None, alias="ListOrgPoliciesRequest"
    )
