# generated by datamodel-codegen:
#   filename:  schemas.json
#   timestamp: 2021-11-29T17:07:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class AutoUpgradeOptions(BaseModel):
    auto_upgrade_start_time: Optional[str] = Field(
        None,
        alias="autoUpgradeStartTime",
        description="[Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.",
    )
    description: Optional[str] = Field(
        None,
        description="[Output only] This field is set when upgrades are about to commence with the description of the upgrade.",
    )


class ShieldedInstanceConfig(BaseModel):
    enable_secure_boot: Optional[bool] = Field(
        None,
        alias="enableSecureBoot",
        description="Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.",
    )
    enable_integrity_monitoring: Optional[bool] = Field(
        None,
        alias="enableIntegrityMonitoring",
        description="Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.",
    )


class UpgradeSettings(BaseModel):
    max_surge: Optional[int] = Field(
        None,
        alias="maxSurge",
        description="The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.",
    )
    max_unavailable: Optional[int] = Field(
        None,
        alias="maxUnavailable",
        description="The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.",
    )


class LinuxNodeConfig(BaseModel):
    sysctls: Optional[Dict[str, str]] = Field(
        None,
        description="The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse",
    )


class BigQueryDestination(BaseModel):
    dataset_id: Optional[str] = Field(
        None, alias="datasetId", description="The ID of a BigQuery Dataset."
    )


class Type(Enum):
    unspecified = "UNSPECIFIED"
    disabled = "DISABLED"
    enabled = "ENABLED"
    system_only = "SYSTEM_ONLY"


class ClusterTelemetry(BaseModel):
    type: Optional[Type] = Field(None, description="Type of the integration.")


class LegacyAbac(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.",
    )


class AuthenticatorGroupsConfig(BaseModel):
    security_group: Optional[str] = Field(
        None,
        alias="securityGroup",
        description="The name of the security group-of-groups to be used. Only relevant if enabled = true.",
    )
    enabled: Optional[bool] = Field(
        None,
        description="Whether this cluster should return group membership lookups during authentication using a group of security groups.",
    )


class Status(Enum):
    status_unspecified = "STATUS_UNSPECIFIED"
    provisioning = "PROVISIONING"
    running = "RUNNING"
    reconciling = "RECONCILING"
    stopping = "STOPPING"
    error = "ERROR"
    degraded = "DEGRADED"


class IpAllocationPolicy(BaseModel):
    allow_route_overlap: Optional[bool] = Field(
        None,
        alias="allowRouteOverlap",
        description="If true, allow allocation of cluster CIDR ranges that overlap with certain kinds of network routes. By default we do not allow cluster CIDR ranges to intersect with any user declared routes. With allow_route_overlap == true, we allow overlapping with CIDR ranges that are larger than the cluster CIDR range. If this field is set to true, then cluster and services CIDRs must be fully-specified (e.g. `10.96.0.0/14`, but not `/14`), which means: 1) When `use_ip_aliases` is true, `cluster_ipv4_cidr_block` and `services_ipv4_cidr_block` must be fully-specified. 2) When `use_ip_aliases` is false, `cluster.cluster_ipv4_cidr` muse be fully-specified.",
    )
    subnetwork_name: Optional[str] = Field(
        None,
        alias="subnetworkName",
        description="A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.",
    )
    tpu_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="tpuIpv4CidrBlock",
        description="The IP address range of the Cloud TPUs in this cluster. If unspecified, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. If unspecified, the range will use the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. This field is deprecated, use cluster.tpu_config.ipv4_cidr_block instead.",
    )
    cluster_ipv4_cidr: Optional[str] = Field(
        None,
        alias="clusterIpv4Cidr",
        description="This field is deprecated, use cluster_ipv4_cidr_block.",
    )
    create_subnetwork: Optional[bool] = Field(
        None,
        alias="createSubnetwork",
        description="Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.",
    )
    cluster_secondary_range_name: Optional[str] = Field(
        None,
        alias="clusterSecondaryRangeName",
        description="The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases and create_subnetwork is false.",
    )
    services_secondary_range_name: Optional[str] = Field(
        None,
        alias="servicesSecondaryRangeName",
        description="The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases and create_subnetwork is false.",
    )
    use_routes: Optional[bool] = Field(
        None,
        alias="useRoutes",
        description="Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode",
    )
    node_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="nodeIpv4CidrBlock",
        description="The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.",
    )
    services_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="servicesIpv4CidrBlock",
        description="The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.",
    )
    cluster_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="clusterIpv4CidrBlock",
        description="The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.",
    )
    services_ipv4_cidr: Optional[str] = Field(
        None,
        alias="servicesIpv4Cidr",
        description="This field is deprecated, use services_ipv4_cidr_block.",
    )
    node_ipv4_cidr: Optional[str] = Field(
        None,
        alias="nodeIpv4Cidr",
        description="This field is deprecated, use node_ipv4_cidr_block.",
    )
    use_ip_aliases: Optional[bool] = Field(
        None,
        alias="useIpAliases",
        description="Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode",
    )


class Master(BaseModel):
    pass


class Code(Enum):
    unknown = "UNKNOWN"
    gce_stockout = "GCE_STOCKOUT"
    gke_service_account_deleted = "GKE_SERVICE_ACCOUNT_DELETED"
    gce_quota_exceeded = "GCE_QUOTA_EXCEEDED"
    set_by_operator = "SET_BY_OPERATOR"
    cloud_kms_key_error = "CLOUD_KMS_KEY_ERROR"
    ca_expiring = "CA_EXPIRING"


class CanonicalCode(Enum):
    ok = "OK"
    cancelled = "CANCELLED"
    unknown = "UNKNOWN"
    invalid_argument = "INVALID_ARGUMENT"
    deadline_exceeded = "DEADLINE_EXCEEDED"
    not_found = "NOT_FOUND"
    already_exists = "ALREADY_EXISTS"
    permission_denied = "PERMISSION_DENIED"
    unauthenticated = "UNAUTHENTICATED"
    resource_exhausted = "RESOURCE_EXHAUSTED"
    failed_precondition = "FAILED_PRECONDITION"
    aborted = "ABORTED"
    out_of_range = "OUT_OF_RANGE"
    unimplemented = "UNIMPLEMENTED"
    internal = "INTERNAL"
    unavailable = "UNAVAILABLE"
    data_loss = "DATA_LOSS"


class StatusCondition(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="Machine-friendly representation of the condition Deprecated. Use canonical_code instead.",
    )
    canonical_code: Optional[CanonicalCode] = Field(
        None, alias="canonicalCode", description="Canonical code of the condition."
    )
    message: Optional[str] = Field(
        None, description="Human-friendly representation of the condition"
    )


class State(Enum):
    unknown = "UNKNOWN"
    encrypted = "ENCRYPTED"
    decrypted = "DECRYPTED"


class DatabaseEncryption(BaseModel):
    state: Optional[State] = Field(None, description="Denotes the state of etcd encryption.")
    key_name: Optional[str] = Field(
        None,
        alias="keyName",
        description="Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key",
    )


class Autopilot(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable Autopilot")


class VerticalPodAutoscaling(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enables vertical pod autoscaling.")


class EnableComponent(Enum):
    component_unspecified = "COMPONENT_UNSPECIFIED"
    system_components = "SYSTEM_COMPONENTS"
    workloads = "WORKLOADS"


class LoggingComponentConfig(BaseModel):
    enable_components: Optional[List[EnableComponent]] = Field(
        None,
        alias="enableComponents",
        description="Select components to collect logs. An empty set would disable all logging.",
    )


class PubSub(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable notifications for Pub/Sub.")
    topic: Optional[str] = Field(
        None,
        description="The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.",
    )


class Status1(Enum):
    status_unspecified = "STATUS_UNSPECIFIED"
    provisioning = "PROVISIONING"
    running = "RUNNING"
    running_with_error = "RUNNING_WITH_ERROR"
    reconciling = "RECONCILING"
    stopping = "STOPPING"
    error = "ERROR"


class Type1(Enum):
    unspecified = "UNSPECIFIED"
    gvisor = "GVISOR"


class SandboxConfig(BaseModel):
    type: Optional[Type1] = Field(None, description="Type of the sandbox to use for the node.")
    sandbox_type: Optional[str] = Field(
        None,
        alias="sandboxType",
        description="Type of the sandbox to use for the node (e.g. 'gvisor')",
    )


class ConsumeReservationType(Enum):
    unspecified = "UNSPECIFIED"
    no_reservation = "NO_RESERVATION"
    any_reservation = "ANY_RESERVATION"
    specific_reservation = "SPECIFIC_RESERVATION"


class ReservationAffinity(BaseModel):
    key: Optional[str] = Field(
        None,
        description='Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.',
    )
    consume_reservation_type: Optional[ConsumeReservationType] = Field(
        None,
        alias="consumeReservationType",
        description="Corresponds to the type of reservation consumption.",
    )
    values: Optional[List[str]] = Field(
        None,
        description="Corresponds to the label value(s) of reservation resource(s).",
    )


class VirtualNic(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether gVNIC features are enabled in the node pool."
    )


class AdvancedMachineFeatures(BaseModel):
    threads_per_core: Optional[str] = Field(
        None,
        alias="threadsPerCore",
        description="The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.",
    )


class Mode(Enum):
    mode_unspecified = "MODE_UNSPECIFIED"
    gce_metadata = "GCE_METADATA"
    gke_metadata = "GKE_METADATA"


class NodeMetadata(Enum):
    unspecified = "UNSPECIFIED"
    secure = "SECURE"
    expose = "EXPOSE"
    gke_metadata_server = "GKE_METADATA_SERVER"


class WorkloadMetadataConfig(BaseModel):
    mode: Optional[Mode] = Field(
        None,
        description="Mode is the configuration for how to expose metadata to workloads running on the node pool.",
    )
    node_metadata: Optional[NodeMetadata] = Field(
        None,
        alias="nodeMetadata",
        description="NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.",
    )


class GcfsConfig(BaseModel):
    enabled: Optional[bool] = Field(None, description="Whether to use GCFS.")


class AcceleratorConfig(BaseModel):
    accelerator_count: Optional[str] = Field(
        None,
        alias="acceleratorCount",
        description="The number of the accelerator cards exposed to an instance.",
    )
    gpu_partition_size: Optional[str] = Field(
        None,
        alias="gpuPartitionSize",
        description="Size of partitions to create on the GPU. Valid values are described in the NVIDIA [mig user guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).",
    )
    accelerator_type: Optional[str] = Field(
        None,
        alias="acceleratorType",
        description="The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)",
    )


class EphemeralStorageConfig(BaseModel):
    local_ssd_count: Optional[int] = Field(
        None,
        alias="localSsdCount",
        description="Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size. If zero, it means to disable using local SSDs as ephemeral storage.",
    )


class NodeKubeletConfig(BaseModel):
    cpu_manager_policy: Optional[str] = Field(
        None,
        alias="cpuManagerPolicy",
        description='Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. - "none": the default, which represents the existing scheduling behavior. - "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is \'none\' if unspecified.',
    )
    cpu_cfs_quota: Optional[bool] = Field(
        None,
        alias="cpuCfsQuota",
        description="Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.",
    )
    cpu_cfs_quota_period: Optional[str] = Field(
        None,
        alias="cpuCfsQuotaPeriod",
        description='Set the CPU CFS quota period value \'cpu.cfs_period_us\'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.',
    )


class Effect(Enum):
    effect_unspecified = "EFFECT_UNSPECIFIED"
    no_schedule = "NO_SCHEDULE"
    prefer_no_schedule = "PREFER_NO_SCHEDULE"
    no_execute = "NO_EXECUTE"


class NodeTaint1(BaseModel):
    key: Optional[str] = Field(None, description="Key for taint.")
    effect: Optional[Effect] = Field(None, description="Effect for taint.")
    value: Optional[str] = Field(None, description="Value for taint.")


class NodeNetworkConfig(BaseModel):
    pod_range: Optional[str] = Field(
        None,
        alias="podRange",
        description="The ID of the secondary range for pod IPs. If `create_pod_range` is true, this ID is used for the new range. If `create_pod_range` is false, uses an existing secondary range with this ID. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.",
    )
    create_pod_range: Optional[bool] = Field(
        None,
        alias="createPodRange",
        description="Input only. Whether to create a new range for pod IPs in this node pool. Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they are not specified. If neither `create_pod_range` or `pod_range` are specified, the cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.",
    )
    pod_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="podIpv4CidrBlock",
        description="The IP address range for pod IPs in this node pool. Only applicable if `create_pod_range` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) to pick a specific range to use. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.",
    )


class NodePoolAutoscaling(BaseModel):
    autoprovisioned: Optional[bool] = Field(
        None, description="Can this node pool be deleted automatically."
    )
    enabled: Optional[bool] = Field(None, description="Is autoscaling enabled for this node pool.")
    max_node_count: Optional[int] = Field(
        None,
        alias="maxNodeCount",
        description="Maximum number of nodes for one location in the NodePool. Must be >= min_node_count. There has to be enough quota to scale up the cluster.",
    )
    min_node_count: Optional[int] = Field(
        None,
        alias="minNodeCount",
        description="Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= max_node_count.",
    )


class MaxPodsConstraint(BaseModel):
    max_pods_per_node: Optional[str] = Field(
        None,
        alias="maxPodsPerNode",
        description="Constraint enforced on the max num of pods per node.",
    )


class DailyMaintenanceWindow(BaseModel):
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description='Time within the maintenance window to start the maintenance operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.',
    )
    duration: Optional[str] = Field(
        None,
        description="[Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.",
    )


class TimeWindow(BaseModel):
    end_time: Optional[str] = Field(
        None,
        alias="endTime",
        description="The time that the window ends. The end time should take place after the start time.",
    )
    start_time: Optional[str] = Field(
        None, alias="startTime", description="The time that the window first starts."
    )


class Provider(Enum):
    provider_unspecified = "PROVIDER_UNSPECIFIED"
    calico = "CALICO"


class NetworkPolicy(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether network policy is enabled on the cluster."
    )
    provider: Optional[Provider] = Field(None, description="The selected network policy provider.")


class PodSecurityPolicyConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.",
    )


class IdentityServiceConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether to enable the Identity Service component"
    )


class DatapathProvider(Enum):
    datapath_provider_unspecified = "DATAPATH_PROVIDER_UNSPECIFIED"
    legacy_datapath = "LEGACY_DATAPATH"
    advanced_datapath = "ADVANCED_DATAPATH"


class PrivateIpv6GoogleAccess(Enum):
    private_ipv6_google_access_unspecified = "PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED"
    private_ipv6_google_access_disabled = "PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED"
    private_ipv6_google_access_to_google = "PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE"
    private_ipv6_google_access_bidirectional = "PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL"


class DefaultSnatStatus(BaseModel):
    disabled: Optional[bool] = Field(None, description="Disables cluster default sNAT rules.")


class ClusterDnsScope(Enum):
    dns_scope_unspecified = "DNS_SCOPE_UNSPECIFIED"
    cluster_scope = "CLUSTER_SCOPE"
    vpc_scope = "VPC_SCOPE"


class ClusterDns(Enum):
    provider_unspecified = "PROVIDER_UNSPECIFIED"
    platform_default = "PLATFORM_DEFAULT"
    cloud_dns = "CLOUD_DNS"


class DnsConfig(BaseModel):
    cluster_dns_scope: Optional[ClusterDnsScope] = Field(
        None,
        alias="clusterDnsScope",
        description="cluster_dns_scope indicates the scope of access to cluster DNS records.",
    )
    cluster_dns: Optional[ClusterDns] = Field(
        None,
        alias="clusterDns",
        description="cluster_dns indicates which in-cluster DNS provider should be used.",
    )
    cluster_dns_domain: Optional[str] = Field(
        None,
        alias="clusterDnsDomain",
        description="cluster_dns_domain is the suffix used for all cluster service records.",
    )


class ServiceExternalIPsConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether Services with ExternalIPs field are allowed or not."
    )


class MeshCertificates(BaseModel):
    enable_certificates: Optional[bool] = Field(
        None,
        alias="enableCertificates",
        description="enable_certificates controls issuance of workload mTLS certificates. If set, the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster, which can then be configured by creating a WorkloadCertificateConfig Custom Resource. Requires Workload Identity (workload_pool must be non-empty).",
    )


class TpuConfig(BaseModel):
    use_service_networking: Optional[bool] = Field(
        None,
        alias="useServiceNetworking",
        description="Whether to use service networking for Cloud TPU or not.",
    )
    enabled: Optional[bool] = Field(
        None, description="Whether Cloud TPU integration is enabled or not."
    )
    ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="ipv4CidrBlock",
        description="IPv4 CIDR block reserved for Cloud TPU in the VPC.",
    )


class CidrBlock(BaseModel):
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="display_name is an optional field for users to identify CIDR blocks.",
    )
    cidr_block: Optional[str] = Field(
        None,
        alias="cidrBlock",
        description="cidr_block must be specified in CIDR notation.",
    )


class ConsumptionMeteringConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.",
    )


class BinaryAuthorization(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binauthz.",
    )


class PrivateClusterMasterGlobalAccessConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whenever master is accessible globally or not."
    )


class ManagedPrometheusConfig(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable Managed Collection.")


class MonitoringComponentConfig(BaseModel):
    enable_components: Optional[List[EnableComponent]] = Field(
        None,
        alias="enableComponents",
        description="Select components to collect metrics. An empty set would disable all monitoring.",
    )


class ClientCertificateConfig(BaseModel):
    issue_client_certificate: Optional[bool] = Field(
        None, alias="issueClientCertificate", description="Issue a client certificate."
    )


class ShieldedNodes(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Whether Shielded Nodes features are enabled on all nodes in this cluster.",
    )


class Channel(Enum):
    unspecified = "UNSPECIFIED"
    rapid = "RAPID"
    regular = "REGULAR"
    stable = "STABLE"


class ReleaseChannel(BaseModel):
    channel: Optional[Channel] = Field(
        None,
        description="channel specifies which release channel the cluster is subscribed to.",
    )


class AutoscalingProfile(Enum):
    profile_unspecified = "PROFILE_UNSPECIFIED"
    optimize_utilization = "OPTIMIZE_UTILIZATION"
    balanced = "BALANCED"


class ResourceLimit(BaseModel):
    maximum: Optional[str] = Field(
        None, description="Maximum amount of the resource in the cluster."
    )
    minimum: Optional[str] = Field(
        None, description="Minimum amount of the resource in the cluster."
    )
    resource_type: Optional[str] = Field(
        None,
        alias="resourceType",
        description='Resource name "cpu", "memory" or gpu-specific string.',
    )


class WorkloadCertificates(BaseModel):
    enable_certificates: Optional[bool] = Field(
        None,
        alias="enableCertificates",
        description="enable_certificates controls issuance of workload mTLS certificates. If set, the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster, which can then be configured by creating a WorkloadCertificateConfig Custom Resource. Requires Workload Identity (workload_pool must be non-empty).",
    )


class WorkloadIdentityConfig(BaseModel):
    identity_namespace: Optional[str] = Field(
        None,
        alias="identityNamespace",
        description="IAM Identity Namespace to attach all Kubernetes Service Accounts to.",
    )
    workload_pool: Optional[str] = Field(
        None,
        alias="workloadPool",
        description="The workload pool to attach all Kubernetes service accounts to.",
    )
    identity_provider: Optional[str] = Field(
        None,
        alias="identityProvider",
        description="identity provider is the third party identity provider.",
    )


class ConfidentialNodes(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Whether Confidential Nodes feature is enabled for all nodes in this cluster.",
    )


class NodeConfigDefaults(BaseModel):
    gcfs_config: Optional[GcfsConfig] = Field(
        None,
        alias="gcfsConfig",
        description="GCFS (Google Container File System, a.k.a Riptide) options.",
    )


class ConfigConnectorConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether Cloud Connector is enabled for this cluster."
    )


class HttpLoadBalancing(BaseModel):
    disabled: Optional[bool] = Field(
        None,
        description="Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.",
    )


class LoadBalancerType(Enum):
    load_balancer_type_unspecified = "LOAD_BALANCER_TYPE_UNSPECIFIED"
    load_balancer_type_external = "LOAD_BALANCER_TYPE_EXTERNAL"
    load_balancer_type_internal = "LOAD_BALANCER_TYPE_INTERNAL"


class CloudRunConfig(BaseModel):
    disabled: Optional[bool] = Field(
        None, description="Whether Cloud Run addon is enabled for this cluster."
    )
    load_balancer_type: Optional[LoadBalancerType] = Field(
        None,
        alias="loadBalancerType",
        description="Which load balancer type is installed for Cloud Run.",
    )


class KalmConfig(BaseModel):
    enabled: Optional[bool] = Field(None, description="Whether KALM is enabled for this cluster.")


class HorizontalPodAutoscaling(BaseModel):
    disabled: Optional[bool] = Field(
        None,
        description="Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.",
    )


class NetworkPolicyConfig(BaseModel):
    disabled: Optional[bool] = Field(
        None, description="Whether NetworkPolicy is enabled for this cluster."
    )


class KubernetesDashboard(BaseModel):
    disabled: Optional[bool] = Field(
        None,
        description="Whether the Kubernetes Dashboard is enabled for this cluster.",
    )


class GcpFilestoreCsiDriverConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Whether the GCP Filestore CSI driver is enabled for this cluster.",
    )


class GcePersistentDiskCsiDriverConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Whether the Compute Engine PD CSI driver is enabled for this cluster.",
    )


class DnsCacheConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether NodeLocal DNSCache is enabled for this cluster."
    )


class Auth(Enum):
    auth_none = "AUTH_NONE"
    auth_mutual_tls = "AUTH_MUTUAL_TLS"


class IstioConfig(BaseModel):
    disabled: Optional[bool] = Field(None, description="Whether Istio is enabled for this cluster.")
    auth: Optional[Auth] = Field(
        None, description="The specified Istio auth mode, either none, or mutual TLS."
    )


class HttpCacheControlResponseHeader(BaseModel):
    expires: Optional[str] = Field(
        None, description="14.21 response cache expires, in RFC 1123 date format"
    )
    age: Optional[str] = Field(
        None,
        description="14.6 response cache age, in seconds since the response is generated",
    )
    directive: Optional[str] = Field(None, description="14.9 request and response directives")


class Jwk(BaseModel):
    kty: Optional[str] = Field(None, description="Key Type.")
    crv: Optional[str] = Field(None, description="Used for ECDSA keys.")
    use: Optional[str] = Field(None, description="Permitted uses for the public keys.")
    n: Optional[str] = Field(None, description="Used for RSA keys.")
    y: Optional[str] = Field(None, description="Used for ECDSA keys.")
    x: Optional[str] = Field(None, description="Used for ECDSA keys.")
    kid: Optional[str] = Field(None, description="Key ID.")
    e: Optional[str] = Field(None, description="Used for RSA keys.")
    alg: Optional[str] = Field(None, description="Algorithm.")


class SetNetworkPolicyRequest(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster id) of the cluster to set networking policy. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://developers.google.com/console/help/new/#projectnumber). This field has been deprecated and replaced by the name field.",
    )
    network_policy: Optional[NetworkPolicy] = Field(
        None,
        alias="networkPolicy",
        description="Required. Configuration options for the NetworkPolicy feature.",
    )


class OperationType(Enum):
    type_unspecified = "TYPE_UNSPECIFIED"
    create_cluster = "CREATE_CLUSTER"
    delete_cluster = "DELETE_CLUSTER"
    upgrade_master = "UPGRADE_MASTER"
    upgrade_nodes = "UPGRADE_NODES"
    repair_cluster = "REPAIR_CLUSTER"
    update_cluster = "UPDATE_CLUSTER"
    create_node_pool = "CREATE_NODE_POOL"
    delete_node_pool = "DELETE_NODE_POOL"
    set_node_pool_management = "SET_NODE_POOL_MANAGEMENT"
    auto_repair_nodes = "AUTO_REPAIR_NODES"
    auto_upgrade_nodes = "AUTO_UPGRADE_NODES"
    set_labels = "SET_LABELS"
    set_master_auth = "SET_MASTER_AUTH"
    set_node_pool_size = "SET_NODE_POOL_SIZE"
    set_network_policy = "SET_NETWORK_POLICY"
    set_maintenance_policy = "SET_MAINTENANCE_POLICY"


class Status2(Enum):
    status_unspecified = "STATUS_UNSPECIFIED"
    pending = "PENDING"
    running = "RUNNING"
    done = "DONE"
    aborting = "ABORTING"


class Metric(BaseModel):
    int_value: Optional[str] = Field(
        None, alias="intValue", description="For metrics with integer value."
    )
    string_value: Optional[str] = Field(
        None,
        alias="stringValue",
        description="For metrics with custom values (ratios, visual progress, etc.).",
    )
    double_value: Optional[float] = Field(
        None, alias="doubleValue", description="For metrics with floating point value."
    )
    name: Optional[str] = Field(
        None, description='Required. Metric name, e.g., "nodes total", "percent done".'
    )


class Status4(BaseModel):
    code: Optional[int] = Field(
        None,
        description="The status code, which should be an enum value of google.rpc.Code.",
    )
    message: Optional[str] = Field(
        None,
        description="A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.",
    )
    details: Optional[List[Dict[str, Dict[str, Any]]]] = Field(
        None,
        description="A list of messages that carry the error details. There is a common set of message types for APIs to use.",
    )


class SetLocationsRequest(BaseModel):
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    locations: Optional[List[str]] = Field(
        None,
        description="Required. The desired list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the cluster's nodes should be located. Changing the locations a cluster is in will result in nodes being either created or removed from the cluster, depending on whether locations are being added or removed. This list must always include the cluster's primary zone.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to set locations. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )


class UpdateMasterRequest(BaseModel):
    master_version: Optional[str] = Field(
        None,
        alias="masterVersion",
        description='Required. The Kubernetes version to change the master to. Users may specify either explicit versions offered by Kubernetes Engine or version aliases, which have the following behavior: - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-": picks the default Kubernetes version',
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to update. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )


class CompleteIpRotationRequest(BaseModel):
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://developers.google.com/console/help/new/#projectnumber). This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster id) of the cluster to complete IP rotation. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.",
    )


class Status5(Enum):
    unknown = "UNKNOWN"
    unused = "UNUSED"
    in_use_service = "IN_USE_SERVICE"
    in_use_shareable_pod = "IN_USE_SHAREABLE_POD"
    in_use_managed_pod = "IN_USE_MANAGED_POD"


class UsableSubnetworkSecondaryRange(BaseModel):
    range_name: Optional[str] = Field(
        None,
        alias="rangeName",
        description="The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance.",
    )
    status: Optional[Status5] = Field(
        None,
        description="This field is to determine the status of the secondary range programmably.",
    )
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The range of IP addresses belonging to this subnetwork secondary range.",
    )


class SetNodePoolAutoscalingRequest(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster, node pool) of the node pool to set autoscaler settings. Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    node_pool_id: Optional[str] = Field(
        None,
        alias="nodePoolId",
        description="Required. Deprecated. The name of the node pool to upgrade. This field has been deprecated and replaced by the name field.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    autoscaling: Optional[NodePoolAutoscaling] = Field(
        None, description="Required. Autoscaling configuration for the node pool."
    )


class SetLoggingServiceRequest(BaseModel):
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    logging_service: Optional[str] = Field(
        None,
        alias="loggingService",
        description="Required. The logging service the cluster should use to write logs. Currently available options: * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer available as of GKE 1.15). * `none` - no logs will be exported from the cluster. If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to set logging. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )


class NetworkTags(BaseModel):
    tags: Optional[List[str]] = Field(None, description="List of network tags.")


class CancelOperationRequest(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name (project, location, operation id) of the operation to cancel. Specified in the format `projects/*/locations/*/operations/*`.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    operation_id: Optional[str] = Field(
        None,
        alias="operationId",
        description="Required. Deprecated. The server-assigned `name` of the operation. This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the operation resides. This field has been deprecated and replaced by the name field.",
    )


class ResourceType(Enum):
    upgrade_resource_type_unspecified = "UPGRADE_RESOURCE_TYPE_UNSPECIFIED"
    master = "MASTER"
    node_pool = "NODE_POOL"


class UpgradeEvent(BaseModel):
    target_version: Optional[str] = Field(
        None, alias="targetVersion", description="The target version for the upgrade."
    )
    resource_type: Optional[ResourceType] = Field(
        None, alias="resourceType", description="The resource type that is upgrading."
    )
    operation: Optional[str] = Field(
        None, description="The operation associated with this upgrade."
    )
    current_version: Optional[str] = Field(
        None,
        alias="currentVersion",
        description="The current version before the upgrade.",
    )
    resource: Optional[str] = Field(
        None,
        description="Optional relative path to the resource. For example in node pool upgrades, the relative path of the node pool.",
    )
    operation_start_time: Optional[str] = Field(
        None,
        alias="operationStartTime",
        description="The time when the operation was started.",
    )


class Date(BaseModel):
    day: Optional[int] = Field(
        None,
        description="Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.",
    )
    year: Optional[int] = Field(
        None,
        description="Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.",
    )
    month: Optional[int] = Field(
        None,
        description="Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.",
    )


class IntraNodeVisibilityConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Enables intra node visibility for this cluster."
    )


class IlbSubsettingConfig(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enables l4 ILB subsetting for this cluster")


class NodeTaints(BaseModel):
    taints: Optional[List[NodeTaint1]] = Field(None, description="List of node taints.")


class AvailableVersion(BaseModel):
    reason: Optional[str] = Field(None, description="Reason for availability.")
    version: Optional[str] = Field(None, description="Kubernetes version.")


class GetOpenIdConfigResponse(BaseModel):
    jwks_uri: Optional[str] = Field(None, description="JSON Web Key uri.")
    issuer: Optional[str] = Field(None, description="OIDC Issuer.")
    cache_header: Optional[HttpCacheControlResponseHeader] = Field(
        None,
        alias="cacheHeader",
        description="OnePlatform automatically extracts this field and uses it to set the HTTP Cache-Control header.",
    )
    claims_supported: Optional[List[str]] = Field(None, description="Supported claims.")
    subject_types_supported: Optional[List[str]] = Field(
        None, description="Supported subject types."
    )
    grant_types: Optional[List[str]] = Field(None, description="Supported grant types.")
    response_types_supported: Optional[List[str]] = Field(
        None, description="Supported response types."
    )
    id_token_signing_alg_values_supported: Optional[List[str]] = Field(
        None, description="supported ID Token signing Algorithms."
    )


class NodeLabels(BaseModel):
    labels: Optional[Dict[str, str]] = Field(
        None, description="Map of node label keys and node label values."
    )


class Type2(Enum):
    location_type_unspecified = "LOCATION_TYPE_UNSPECIFIED"
    zone = "ZONE"
    region = "REGION"


class Location(BaseModel):
    recommended: Optional[bool] = Field(
        None,
        description="Whether the location is recomended for GKE cluster scheduling.",
    )
    name: Optional[str] = Field(
        None,
        description="Contains the name of the resource requested. Specified in the format `projects/*/locations/*`.",
    )
    type: Optional[Type2] = Field(
        None,
        description="Contains the type of location this Location is for. Regional or Zonal.",
    )


class WindowsVersion1(BaseModel):
    image_type: Optional[str] = Field(
        None, alias="imageType", description="Windows server image type"
    )
    support_end_date: Optional[Date] = Field(
        None, alias="supportEndDate", description="Mainstream support end date"
    )
    os_version: Optional[str] = Field(
        None, alias="osVersion", description="Windows server build number"
    )


class Empty(BaseModel):
    pass


class SetNodePoolSizeRequest(BaseModel):
    node_count: Optional[int] = Field(
        None,
        alias="nodeCount",
        description="Required. The desired node count for the pool.",
    )
    node_pool_id: Optional[str] = Field(
        None,
        alias="nodePoolId",
        description="Required. Deprecated. The name of the node pool to update. This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster, node pool id) of the node pool to set size. Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to update. This field has been deprecated and replaced by the name field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )


class SetMonitoringServiceRequest(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to set monitoring. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    monitoring_service: Optional[str] = Field(
        None,
        alias="monitoringService",
        description='Required. The monitoring service the cluster should use to write metrics. Currently available options: * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster. If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.',
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )


class SetLegacyAbacRequest(BaseModel):
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster id) of the cluster to set legacy abac. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to update. This field has been deprecated and replaced by the name field.",
    )
    enabled: Optional[bool] = Field(
        None,
        description="Required. Whether ABAC authorization will be enabled in the cluster.",
    )


class SetLabelsRequest(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster id) of the cluster to set labels. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    resource_labels: Optional[Dict[str, str]] = Field(
        None,
        alias="resourceLabels",
        description="Required. The labels to set for that cluster.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="Required. The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Kubernetes Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels. Make a `get()` request to the resource to get the latest fingerprint.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://developers.google.com/console/help/new/#projectnumber). This field has been deprecated and replaced by the name field.",
    )


class StartIpRotationRequest(BaseModel):
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    rotate_credentials: Optional[bool] = Field(
        None,
        alias="rotateCredentials",
        description="Whether to rotate credentials during IP rotation.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://developers.google.com/console/help/new/#projectnumber). This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster id) of the cluster to start IP rotation. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.",
    )


class ListLocationsResponse(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="Only return ListLocationsResponse that occur after the page_token. This value should be populated from the ListLocationsResponse.next_page_token if that response token was set (which happens when listing more Locations than fit in a single ListLocationsResponse).",
    )
    locations: Optional[List[Location]] = Field(None, description="A full list of GKE locations.")


class ReleaseChannelConfig(BaseModel):
    valid_versions: Optional[List[str]] = Field(
        None,
        alias="validVersions",
        description="List of valid versions for the channel.",
    )
    available_versions: Optional[List[AvailableVersion]] = Field(
        None,
        alias="availableVersions",
        description="Deprecated. This field has been deprecated and replaced with the valid_versions field.",
    )
    channel: Optional[Channel] = Field(
        None, description="The release channel this configuration applies to."
    )
    default_version: Optional[str] = Field(
        None,
        alias="defaultVersion",
        description="The default version for newly created clusters on the channel.",
    )


class WindowsVersions(BaseModel):
    windows_versions: Optional[List[WindowsVersion1]] = Field(
        None, alias="windowsVersions", description="List of Windows server versions."
    )


class UpdateNodePoolRequest(BaseModel):
    gcfs_config: Optional[GcfsConfig] = Field(None, alias="gcfsConfig", description="GCFS config.")
    upgrade_settings: Optional[UpgradeSettings] = Field(
        None,
        alias="upgradeSettings",
        description="Upgrade settings control disruption and speed of the upgrade.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster, node pool) of the node pool to update. Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    linux_node_config: Optional[LinuxNodeConfig] = Field(
        None,
        alias="linuxNodeConfig",
        description="Parameters that can be configured on Linux nodes.",
    )
    locations: Optional[List[str]] = Field(
        None,
        description="The desired list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the node pool's nodes should be located. Changing the locations for a node pool will result in nodes being either created or removed from the node pool, depending on whether locations are being added or removed.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    labels: Optional[NodeLabels] = Field(
        None,
        description="The desired node labels to be applied to all nodes in the node pool. If this field is not present, the labels will not be changed. Otherwise, the existing node labels will be *replaced* with the provided labels.",
    )
    node_pool_id: Optional[str] = Field(
        None,
        alias="nodePoolId",
        description="Required. Deprecated. The name of the node pool to upgrade. This field has been deprecated and replaced by the name field.",
    )
    image_type: Optional[str] = Field(
        None,
        alias="imageType",
        description="Required. The desired image type for the node pool.",
    )
    kubelet_config: Optional[NodeKubeletConfig] = Field(
        None, alias="kubeletConfig", description="Node kubelet configs."
    )
    gvnic: Optional[VirtualNic] = Field(
        None, description="Enable or disable gvnic on the node pool."
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    workload_metadata_config: Optional[WorkloadMetadataConfig] = Field(
        None,
        alias="workloadMetadataConfig",
        description="The desired workload metadata config for the node pool.",
    )
    taints: Optional[NodeTaints] = Field(
        None,
        description="The desired node taints to be applied to all nodes in the node pool. If this field is not present, the taints will not be changed. Otherwise, the existing node taints will be *replaced* with the provided taints.",
    )
    node_version: Optional[str] = Field(
        None,
        alias="nodeVersion",
        description='Required. The Kubernetes version to change the nodes to (typically an upgrade). Users may specify either explicit versions offered by Kubernetes Engine or version aliases, which have the following behavior: - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-": picks the Kubernetes master version',
    )
    tags: Optional[NetworkTags] = Field(
        None,
        description="The desired network tags to be applied to all nodes in the node pool. If this field is not present, the tags will not be changed. Otherwise, the existing network tags will be *replaced* with the provided tags.",
    )


class Action(Enum):
    unknown = "UNKNOWN"
    set_password = "SET_PASSWORD"
    generate_password = "GENERATE_PASSWORD"
    set_username = "SET_USERNAME"


class UpgradeAvailableEvent(BaseModel):
    windows_versions: Optional[WindowsVersions] = Field(
        None, alias="windowsVersions", description="Windows node versions info."
    )
    version: Optional[str] = Field(None, description="The release version available for upgrade.")
    resource_type: Optional[ResourceType] = Field(
        None,
        alias="resourceType",
        description="The resource type of the release version.",
    )
    resource: Optional[str] = Field(
        None,
        description="Optional relative path to the resource. For example, the relative path of the node pool.",
    )
    release_channel: Optional[ReleaseChannel] = Field(
        None,
        alias="releaseChannel",
        description="The release channel of the version. If empty, it means a non-channel release.",
    )


class RollbackNodePoolUpgradeRequest(BaseModel):
    node_pool_id: Optional[str] = Field(
        None,
        alias="nodePoolId",
        description="Required. Deprecated. The name of the node pool to rollback. This field has been deprecated and replaced by the name field.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to rollback. This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster, node pool id) of the node poll to rollback upgrade. Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )


class NodeManagement(BaseModel):
    upgrade_options: Optional[AutoUpgradeOptions] = Field(
        None,
        alias="upgradeOptions",
        description="Specifies the Auto Upgrade knobs for the node pool.",
    )
    auto_upgrade: Optional[bool] = Field(
        None,
        alias="autoUpgrade",
        description="Whether the nodes will be automatically upgraded.",
    )
    auto_repair: Optional[bool] = Field(
        None,
        alias="autoRepair",
        description="Whether the nodes will be automatically repaired.",
    )


class LoggingConfig(BaseModel):
    component_config: Optional[LoggingComponentConfig] = Field(
        None, alias="componentConfig", description="Logging components configuration"
    )


class NotificationConfig(BaseModel):
    pubsub: Optional[PubSub] = Field(None, description="Notification config for Pub/Sub.")


class NodeConfig(BaseModel):
    metadata: Optional[Dict[str, str]] = Field(
        None,
        description='The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-oslogin" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value\'s size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.',
    )
    boot_disk_kms_key: Optional[str] = Field(
        None,
        alias="bootDiskKmsKey",
        description=" The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption",
    )
    spot: Optional[bool] = Field(
        None,
        description="Spot flag for enabling Spot VM, which is a rebrand of the existing preemptible flag.",
    )
    node_group: Optional[str] = Field(
        None,
        alias="nodeGroup",
        description="Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).",
    )
    shielded_instance_config: Optional[ShieldedInstanceConfig] = Field(
        None, alias="shieldedInstanceConfig", description="Shielded Instance options."
    )
    sandbox_config: Optional[SandboxConfig] = Field(
        None, alias="sandboxConfig", description="Sandbox configuration for this node."
    )
    image_type: Optional[str] = Field(
        None,
        alias="imageType",
        description="The image type to use for this node. Note that for a given image type, the latest version of it will be used.",
    )
    local_ssd_count: Optional[int] = Field(
        None,
        alias="localSsdCount",
        description="The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.",
    )
    reservation_affinity: Optional[ReservationAffinity] = Field(
        None,
        alias="reservationAffinity",
        description="The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.",
    )
    gvnic: Optional[VirtualNic] = Field(
        None, description="Enable or disable gvnic on the node pool."
    )
    oauth_scopes: Optional[List[str]] = Field(
        None,
        alias="oauthScopes",
        description='The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.',
    )
    advanced_machine_features: Optional[AdvancedMachineFeatures] = Field(
        None,
        alias="advancedMachineFeatures",
        description="Advanced features for the Compute Engine VM.",
    )
    machine_type: Optional[str] = Field(
        None,
        alias="machineType",
        description="The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types). If unspecified, the default machine type is `e2-medium`.",
    )
    tags: Optional[List[str]] = Field(
        None,
        description="The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.",
    )
    workload_metadata_config: Optional[WorkloadMetadataConfig] = Field(
        None,
        alias="workloadMetadataConfig",
        description="The workload metadata configuration for this node.",
    )
    disk_type: Optional[str] = Field(
        None,
        alias="diskType",
        description="Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'",
    )
    service_account: Optional[str] = Field(
        None,
        alias="serviceAccount",
        description='The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.',
    )
    disk_size_gb: Optional[int] = Field(
        None,
        alias="diskSizeGb",
        description="Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.",
    )
    gcfs_config: Optional[GcfsConfig] = Field(
        None,
        alias="gcfsConfig",
        description="GCFS (Google Container File System) configs.",
    )
    preemptible: Optional[bool] = Field(
        None,
        description="Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more inforamtion about preemptible VM instances.",
    )
    linux_node_config: Optional[LinuxNodeConfig] = Field(
        None,
        alias="linuxNodeConfig",
        description="Parameters that can be configured on Linux nodes.",
    )
    accelerators: Optional[List[AcceleratorConfig]] = Field(
        None,
        description="A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.",
    )
    ephemeral_storage_config: Optional[EphemeralStorageConfig] = Field(
        None,
        alias="ephemeralStorageConfig",
        description="Parameters for the ephemeral storage filesystem. If unspecified, ephemeral storage is backed by the boot disk.",
    )
    kubelet_config: Optional[NodeKubeletConfig] = Field(
        None, alias="kubeletConfig", description="Node kubelet configs."
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
    )
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description='Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)',
    )
    taints: Optional[List[NodeTaint1]] = Field(
        None,
        description="List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/",
    )


class RecurringTimeWindow(BaseModel):
    recurrence: Optional[str] = Field(
        None,
        description="An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.",
    )
    window: Optional[TimeWindow] = Field(None, description="The window of the first recurrence.")


class NetworkConfig(BaseModel):
    subnetwork: Optional[str] = Field(
        None,
        description="Output only. The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet",
    )
    datapath_provider: Optional[DatapathProvider] = Field(
        None,
        alias="datapathProvider",
        description="The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.",
    )
    enable_intra_node_visibility: Optional[bool] = Field(
        None,
        alias="enableIntraNodeVisibility",
        description="Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.",
    )
    private_ipv6_google_access: Optional[PrivateIpv6GoogleAccess] = Field(
        None,
        alias="privateIpv6GoogleAccess",
        description="The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)",
    )
    default_snat_status: Optional[DefaultSnatStatus] = Field(
        None,
        alias="defaultSnatStatus",
        description="Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.",
    )
    network: Optional[str] = Field(
        None,
        description="Output only. The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network",
    )
    enable_l4ilb_subsetting: Optional[bool] = Field(
        None,
        alias="enableL4ilbSubsetting",
        description="Whether L4ILB Subsetting is enabled for this cluster.",
    )
    dns_config: Optional[DnsConfig] = Field(
        None,
        alias="dnsConfig",
        description="DNSConfig contains clusterDNS config for this cluster.",
    )
    service_external_ips_config: Optional[ServiceExternalIPsConfig] = Field(
        None,
        alias="serviceExternalIpsConfig",
        description="ServiceExternalIPsConfig specifies if services with externalIPs field are blocked or not.",
    )


class MasterAuthorizedNetworksConfig(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether or not master authorized networks is enabled."
    )
    cidr_blocks: Optional[List[CidrBlock]] = Field(
        None,
        alias="cidrBlocks",
        description="cidr_blocks define up to 10 external networks that could access Kubernetes master through HTTPS.",
    )


class ResourceUsageExportConfig(BaseModel):
    consumption_metering_config: Optional[ConsumptionMeteringConfig] = Field(
        None,
        alias="consumptionMeteringConfig",
        description="Configuration to enable resource consumption metering.",
    )
    bigquery_destination: Optional[BigQueryDestination] = Field(
        None,
        alias="bigqueryDestination",
        description="Configuration to use BigQuery as usage export destination.",
    )
    enable_network_egress_metering: Optional[bool] = Field(
        None,
        alias="enableNetworkEgressMetering",
        description="Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.",
    )


class PrivateClusterConfig(BaseModel):
    enable_private_endpoint: Optional[bool] = Field(
        None,
        alias="enablePrivateEndpoint",
        description="Whether the master's internal IP address is used as the cluster endpoint.",
    )
    master_global_access_config: Optional[PrivateClusterMasterGlobalAccessConfig] = Field(
        None,
        alias="masterGlobalAccessConfig",
        description="Controls master global access settings.",
    )
    enable_private_nodes: Optional[bool] = Field(
        None,
        alias="enablePrivateNodes",
        description="Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.",
    )
    peering_name: Optional[str] = Field(
        None,
        alias="peeringName",
        description="Output only. The peering name in the customer VPC used by this cluster.",
    )
    private_endpoint: Optional[str] = Field(
        None,
        alias="privateEndpoint",
        description="Output only. The internal IP address of this cluster's master endpoint.",
    )
    public_endpoint: Optional[str] = Field(
        None,
        alias="publicEndpoint",
        description="Output only. The external IP address of this cluster's master endpoint.",
    )
    master_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="masterIpv4CidrBlock",
        description="The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.",
    )


class MonitoringConfig(BaseModel):
    managed_prometheus_config: Optional[ManagedPrometheusConfig] = Field(
        None,
        alias="managedPrometheusConfig",
        description="Enable Google Cloud Managed Service for Prometheus in the cluster.",
    )
    component_config: Optional[MonitoringComponentConfig] = Field(
        None, alias="componentConfig", description="Monitoring components configuration"
    )


class MasterAuth(BaseModel):
    password: Optional[str] = Field(
        None,
        description="The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication",
    )
    username: Optional[str] = Field(
        None,
        description="The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication",
    )
    cluster_ca_certificate: Optional[str] = Field(None, alias="clusterCaCertificate")
    client_key: Optional[str] = Field(
        None,
        alias="clientKey",
        description="[Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.",
    )
    client_certificate_config: Optional[ClientCertificateConfig] = Field(
        None,
        alias="clientCertificateConfig",
        description="Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.",
    )
    client_certificate: Optional[str] = Field(
        None,
        alias="clientCertificate",
        description="[Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.",
    )


class NodePoolDefaults(BaseModel):
    node_config_defaults: Optional[NodeConfigDefaults] = Field(
        None,
        alias="nodeConfigDefaults",
        description="Subset of NodeConfig message that has defaults.",
    )


class AddonsConfig(BaseModel):
    config_connector_config: Optional[ConfigConnectorConfig] = Field(
        None,
        alias="configConnectorConfig",
        description="Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API",
    )
    http_load_balancing: Optional[HttpLoadBalancing] = Field(
        None,
        alias="httpLoadBalancing",
        description="Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.",
    )
    cloud_run_config: Optional[CloudRunConfig] = Field(
        None,
        alias="cloudRunConfig",
        description="Configuration for the Cloud Run addon. The `IstioConfig` addon must be enabled in order to enable Cloud Run addon. This option can only be enabled at cluster creation time.",
    )
    kalm_config: Optional[KalmConfig] = Field(
        None,
        alias="kalmConfig",
        description="Configuration for the KALM addon, which manages the lifecycle of k8s applications.",
    )
    horizontal_pod_autoscaling: Optional[HorizontalPodAutoscaling] = Field(
        None,
        alias="horizontalPodAutoscaling",
        description="Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.",
    )
    network_policy_config: Optional[NetworkPolicyConfig] = Field(
        None,
        alias="networkPolicyConfig",
        description="Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.",
    )
    kubernetes_dashboard: Optional[KubernetesDashboard] = Field(
        None,
        alias="kubernetesDashboard",
        description="Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards",
    )
    gcp_filestore_csi_driver_config: Optional[GcpFilestoreCsiDriverConfig] = Field(
        None,
        alias="gcpFilestoreCsiDriverConfig",
        description="Configuration for the GCP Filestore CSI driver.",
    )
    gce_persistent_disk_csi_driver_config: Optional[GcePersistentDiskCsiDriverConfig] = Field(
        None,
        alias="gcePersistentDiskCsiDriverConfig",
        description="Configuration for the Compute Engine Persistent Disk CSI driver.",
    )
    dns_cache_config: Optional[DnsCacheConfig] = Field(
        None,
        alias="dnsCacheConfig",
        description="Configuration for NodeLocalDNS, a dns cache running on cluster nodes",
    )
    istio_config: Optional[IstioConfig] = Field(
        None,
        alias="istioConfig",
        description="Configuration for Istio, an open platform to connect, manage, and secure microservices.",
    )


class GetJsonWebKeysResponse(BaseModel):
    cache_header: Optional[HttpCacheControlResponseHeader] = Field(
        None,
        alias="cacheHeader",
        description="OnePlatform automatically extracts this field and uses it to set the HTTP Cache-Control header.",
    )
    keys: Optional[List[Jwk]] = Field(
        None,
        description="The public component of the keys used by the cluster to sign token requests.",
    )


class OperationProgress(BaseModel):
    metrics: Optional[List[Metric]] = Field(
        None,
        description='Progress metric bundle, for example: metrics: [{name: "nodes done", int_value: 15}, {name: "nodes total", int_value: 32}] or metrics: [{name: "progress", double_value: 0.56}, {name: "progress scale", double_value: 1.0}]',
    )
    stages: Optional[List[OperationProgress]] = Field(
        None, description="Substages of an operation or a stage."
    )
    name: Optional[str] = Field(
        None,
        description="A non-parameterized string describing an operation stage. Unset for single-stage operations.",
    )
    status: Optional[Status2] = Field(
        None,
        description="Status of an operation stage. Unset for single-stage operations.",
    )


class SetNodePoolManagementRequest(BaseModel):
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to update. This field has been deprecated and replaced by the name field.",
    )
    node_pool_id: Optional[str] = Field(
        None,
        alias="nodePoolId",
        description="Required. Deprecated. The name of the node pool to update. This field has been deprecated and replaced by the name field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster, node pool id) of the node pool to set management properties. Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    management: Optional[NodeManagement] = Field(
        None, description="Required. NodeManagement configuration for the node pool."
    )


class UsableSubnetwork(BaseModel):
    secondary_ip_ranges: Optional[List[UsableSubnetworkSecondaryRange]] = Field(
        None, alias="secondaryIpRanges", description="Secondary IP ranges."
    )
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The range of internal addresses that are owned by this subnetwork.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="Subnetwork Name. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet",
    )
    network: Optional[str] = Field(
        None,
        description="Network Name. Example: projects/my-project/global/networks/my-network",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="A human readable status message representing the reasons for cases where the caller cannot use the secondary ranges under the subnet. For example if the secondary_ip_ranges is empty due to a permission issue, an insufficient permission message will be given by status_message.",
    )


class ServerConfig(BaseModel):
    channels: Optional[List[ReleaseChannelConfig]] = Field(
        None, description="List of release channel configurations."
    )
    valid_master_versions: Optional[List[str]] = Field(
        None,
        alias="validMasterVersions",
        description="List of valid master versions, in descending order.",
    )
    windows_version_maps: Optional[Dict[str, WindowsVersions]] = Field(
        None,
        alias="windowsVersionMaps",
        description="Maps of Kubernetes version and supported Windows server versions.",
    )
    valid_image_types: Optional[List[str]] = Field(
        None, alias="validImageTypes", description="List of valid image types."
    )
    default_image_type: Optional[str] = Field(
        None, alias="defaultImageType", description="Default image type."
    )
    valid_node_versions: Optional[List[str]] = Field(
        None,
        alias="validNodeVersions",
        description="List of valid node upgrade target versions, in descending order.",
    )
    default_cluster_version: Optional[str] = Field(
        None,
        alias="defaultClusterVersion",
        description="Version of Kubernetes the service deploys by default.",
    )


class SetMasterAuthRequest(BaseModel):
    action: Optional[Action] = Field(
        None,
        description="Required. The exact form of action to be taken on the master auth.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    update: Optional[MasterAuth] = Field(None, description="Required. A description of the update.")
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to set auth. Specified in the format `projects/*/locations/*/clusters/*`.",
    )


class SetAddonsConfigRequest(BaseModel):
    addons_config: Optional[AddonsConfig] = Field(
        None,
        alias="addonsConfig",
        description="Required. The desired configurations for the various addons available to run in the cluster.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to set addons. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )


class AutoprovisioningNodePoolDefaults(BaseModel):
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description='Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform) To unset the min cpu platform field pass "automatic" as field value.',
    )
    management: Optional[NodeManagement] = Field(
        None, description="NodeManagement configuration for this NodePool."
    )
    boot_disk_kms_key: Optional[str] = Field(
        None,
        alias="bootDiskKmsKey",
        description=" The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption",
    )
    shielded_instance_config: Optional[ShieldedInstanceConfig] = Field(
        None, alias="shieldedInstanceConfig", description="Shielded Instance options."
    )
    image_type: Optional[str] = Field(
        None,
        alias="imageType",
        description="The image type to use for NAP created node.",
    )
    disk_type: Optional[str] = Field(
        None,
        alias="diskType",
        description="Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'",
    )
    service_account: Optional[str] = Field(
        None,
        alias="serviceAccount",
        description='The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.',
    )
    oauth_scopes: Optional[List[str]] = Field(
        None,
        alias="oauthScopes",
        description='The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.',
    )
    disk_size_gb: Optional[int] = Field(
        None,
        alias="diskSizeGb",
        description="Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.",
    )
    upgrade_settings: Optional[UpgradeSettings] = Field(
        None,
        alias="upgradeSettings",
        description="Upgrade settings control disruption and speed of the upgrade.",
    )


class NodePool(BaseModel):
    version: Optional[str] = Field(None, description="The version of the Kubernetes of this node.")
    instance_group_urls: Optional[List[str]] = Field(
        None,
        alias="instanceGroupUrls",
        description="[Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool.",
    )
    management: Optional[NodeManagement] = Field(
        None, description="NodeManagement configuration for this NodePool."
    )
    config: Optional[NodeConfig] = Field(None, description="The node configuration of the pool.")
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="[Output only] Deprecated. Use conditions instead. Additional information about the current status of this node pool instance, if available.",
    )
    status: Optional[Status1] = Field(
        None, description="[Output only] The status of the nodes in this pool instance."
    )
    network_config: Optional[NodeNetworkConfig] = Field(
        None,
        alias="networkConfig",
        description="Networking configuration for this NodePool. If specified, it overrides the cluster-level defaults.",
    )
    locations: Optional[List[str]] = Field(
        None,
        description="The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.",
    )
    name: Optional[str] = Field(None, description="The name of the node pool.")
    conditions: Optional[List[StatusCondition]] = Field(
        None, description="Which conditions caused the current node pool state."
    )
    autoscaling: Optional[NodePoolAutoscaling] = Field(
        None,
        description="Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.",
    )
    upgrade_settings: Optional[UpgradeSettings] = Field(
        None,
        alias="upgradeSettings",
        description="Upgrade settings control disruption and speed of the upgrade.",
    )
    pod_ipv4_cidr_size: Optional[int] = Field(
        None,
        alias="podIpv4CidrSize",
        description="[Output only] The pod CIDR block size per node in this node pool.",
    )
    initial_node_count: Optional[int] = Field(
        None,
        alias="initialNodeCount",
        description="The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output only] Server-defined URL for the resource.",
    )
    max_pods_constraint: Optional[MaxPodsConstraint] = Field(
        None,
        alias="maxPodsConstraint",
        description="The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.",
    )


class MaintenanceWindow(BaseModel):
    daily_maintenance_window: Optional[DailyMaintenanceWindow] = Field(
        None,
        alias="dailyMaintenanceWindow",
        description="DailyMaintenanceWindow specifies a daily maintenance operation window.",
    )
    recurring_window: Optional[RecurringTimeWindow] = Field(
        None,
        alias="recurringWindow",
        description="RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.",
    )
    maintenance_exclusions: Optional[Dict[str, TimeWindow]] = Field(
        None,
        alias="maintenanceExclusions",
        description="Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.",
    )


class ClusterAutoscaling(BaseModel):
    autoprovisioning_locations: Optional[List[str]] = Field(
        None,
        alias="autoprovisioningLocations",
        description="The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.",
    )
    enable_node_autoprovisioning: Optional[bool] = Field(
        None,
        alias="enableNodeAutoprovisioning",
        description="Enables automatic node pool creation and deletion.",
    )
    autoscaling_profile: Optional[AutoscalingProfile] = Field(
        None, alias="autoscalingProfile", description="Defines autoscaling behaviour."
    )
    autoprovisioning_node_pool_defaults: Optional[AutoprovisioningNodePoolDefaults] = Field(
        None,
        alias="autoprovisioningNodePoolDefaults",
        description="AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.",
    )
    resource_limits: Optional[List[ResourceLimit]] = Field(
        None,
        alias="resourceLimits",
        description="Contains global constraints regarding minimum and maximum amount of resources in the cluster.",
    )


class Operation(BaseModel):
    target_link: Optional[str] = Field(
        None,
        alias="targetLink",
        description="Server-defined URL for the target of the operation.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="[Output only] The time the operation started, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.",
    )
    self_link: Optional[str] = Field(
        None, alias="selfLink", description="Server-defined URL for the resource."
    )
    location: Optional[str] = Field(
        None,
        description="[Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available) or [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available) in which the cluster resides.",
    )
    progress: Optional[OperationProgress] = Field(
        None,
        description="Output only. [Output only] Progress information for an operation.",
    )
    zone: Optional[str] = Field(
        None,
        description="The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the operation is taking place. This field is deprecated, use location instead.",
    )
    operation_type: Optional[OperationType] = Field(
        None, alias="operationType", description="The operation type."
    )
    detail: Optional[str] = Field(None, description="Detailed operation progress, if available.")
    status: Optional[Status2] = Field(None, description="The current status of the operation.")
    end_time: Optional[str] = Field(
        None,
        alias="endTime",
        description="[Output only] The time the operation completed, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="Output only. If an error has occurred, a textual description of the error. Deprecated. Use field error instead.",
    )
    name: Optional[str] = Field(None, description="The server-assigned ID for the operation.")
    error: Optional[Status4] = Field(
        None, description="The error result of the operation in case of failure."
    )
    cluster_conditions: Optional[List[StatusCondition]] = Field(
        None,
        alias="clusterConditions",
        description="Which conditions caused the current cluster state. Deprecated. Use field error instead.",
    )
    nodepool_conditions: Optional[List[StatusCondition]] = Field(
        None,
        alias="nodepoolConditions",
        description="Which conditions caused the current node pool state. Deprecated. Use field error instead.",
    )


class ListUsableSubnetworksResponse(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="This token allows you to get the next page of results for list requests. If the number of results is larger than `page_size`, use the `next_page_token` as a value for the query parameter `page_token` in the next request. The value will become empty when there are no more pages.",
    )
    subnetworks: Optional[List[UsableSubnetwork]] = Field(
        None,
        description="A list of usable subnetworks in the specified network project.",
    )


class ClusterUpdate(BaseModel):
    desired_shielded_nodes: Optional[ShieldedNodes] = Field(
        None,
        alias="desiredShieldedNodes",
        description="Configuration for Shielded Nodes.",
    )
    desired_notification_config: Optional[NotificationConfig] = Field(
        None,
        alias="desiredNotificationConfig",
        description="The desired notification configuration.",
    )
    desired_gcfs_config: Optional[GcfsConfig] = Field(
        None,
        alias="desiredGcfsConfig",
        description="The desired GCFS config for the cluster",
    )
    desired_default_snat_status: Optional[DefaultSnatStatus] = Field(
        None,
        alias="desiredDefaultSnatStatus",
        description="The desired status of whether to disable default sNAT for this cluster.",
    )
    desired_master_version: Optional[str] = Field(
        None,
        alias="desiredMasterVersion",
        description='The Kubernetes version to change the master to. The only valid value is the latest supported version. Users may specify either explicit versions offered by Kubernetes Engine or version aliases, which have the following behavior: - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-": picks the default Kubernetes version',
    )
    desired_monitoring_config: Optional[MonitoringConfig] = Field(
        None,
        alias="desiredMonitoringConfig",
        description="The desired monitoring configuration.",
    )
    desired_workload_certificates: Optional[WorkloadCertificates] = Field(
        None,
        alias="desiredWorkloadCertificates",
        description="Configuration for issuance of mTLS keys and certificates to Kubernetes pods.",
    )
    desired_monitoring_service: Optional[str] = Field(
        None,
        alias="desiredMonitoringService",
        description='The monitoring service the cluster should use to write metrics. Currently available options: * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster. If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.',
    )
    desired_cluster_autoscaling: Optional[ClusterAutoscaling] = Field(
        None,
        alias="desiredClusterAutoscaling",
        description="Cluster-level autoscaling configuration.",
    )
    desired_authenticator_groups_config: Optional[AuthenticatorGroupsConfig] = Field(
        None,
        alias="desiredAuthenticatorGroupsConfig",
        description="AuthenticatorGroupsConfig specifies the config for the cluster security groups settings.",
    )
    desired_intra_node_visibility_config: Optional[IntraNodeVisibilityConfig] = Field(
        None,
        alias="desiredIntraNodeVisibilityConfig",
        description="The desired config of Intra-node visibility.",
    )
    desired_service_external_ips_config: Optional[ServiceExternalIPsConfig] = Field(
        None,
        alias="desiredServiceExternalIpsConfig",
        description="ServiceExternalIPsConfig specifies the config for the use of Services with ExternalIPs field.",
    )
    desired_pod_security_policy_config: Optional[PodSecurityPolicyConfig] = Field(
        None,
        alias="desiredPodSecurityPolicyConfig",
        description="The desired configuration options for the PodSecurityPolicy feature.",
    )
    desired_image_type: Optional[str] = Field(
        None,
        alias="desiredImageType",
        description='The desired image type for the node pool. NOTE: Set the "desired_node_pool" field as well.',
    )
    desired_release_channel: Optional[ReleaseChannel] = Field(
        None,
        alias="desiredReleaseChannel",
        description="The desired release channel configuration.",
    )
    desired_private_cluster_config: Optional[PrivateClusterConfig] = Field(
        None,
        alias="desiredPrivateClusterConfig",
        description="The desired private cluster configuration.",
    )
    desired_mesh_certificates: Optional[MeshCertificates] = Field(
        None,
        alias="desiredMeshCertificates",
        description="Configuration for issuance of mTLS keys and certificates to Kubernetes pods.",
    )
    desired_cluster_telemetry: Optional[ClusterTelemetry] = Field(
        None,
        alias="desiredClusterTelemetry",
        description="The desired telemetry integration for the cluster.",
    )
    desired_node_pool_autoscaling: Optional[NodePoolAutoscaling] = Field(
        None,
        alias="desiredNodePoolAutoscaling",
        description="Autoscaler configuration for the node pool specified in desired_node_pool_id. If there is only one pool in the cluster and desired_node_pool_id is not provided then the change applies to that single node pool.",
    )
    desired_addons_config: Optional[AddonsConfig] = Field(
        None,
        alias="desiredAddonsConfig",
        description="Configurations for the various addons available to run in the cluster.",
    )
    desired_resource_usage_export_config: Optional[ResourceUsageExportConfig] = Field(
        None,
        alias="desiredResourceUsageExportConfig",
        description="The desired configuration for exporting resource usage.",
    )
    desired_l4ilb_subsetting_config: Optional[IlbSubsettingConfig] = Field(
        None,
        alias="desiredL4ilbSubsettingConfig",
        description="The desired L4 Internal Load Balancer Subsetting configuration.",
    )
    desired_node_version: Optional[str] = Field(
        None,
        alias="desiredNodeVersion",
        description='The Kubernetes version to change the nodes to (typically an upgrade). Users may specify either explicit versions offered by Kubernetes Engine or version aliases, which have the following behavior: - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-": picks the Kubernetes master version',
    )
    desired_locations: Optional[List[str]] = Field(
        None,
        alias="desiredLocations",
        description="The desired list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the cluster's nodes should be located. This list must always include the cluster's primary zone. Warning: changing cluster locations will update the locations of all node pools and will result in nodes being added and/or removed.",
    )
    desired_tpu_config: Optional[TpuConfig] = Field(
        None,
        alias="desiredTpuConfig",
        description="The desired Cloud TPU configuration.",
    )
    desired_logging_config: Optional[LoggingConfig] = Field(
        None,
        alias="desiredLoggingConfig",
        description="The desired logging configuration.",
    )
    desired_database_encryption: Optional[DatabaseEncryption] = Field(
        None,
        alias="desiredDatabaseEncryption",
        description="Configuration of etcd encryption.",
    )
    desired_dns_config: Optional[DnsConfig] = Field(
        None,
        alias="desiredDnsConfig",
        description="DNSConfig contains clusterDNS config for this cluster.",
    )
    desired_logging_service: Optional[str] = Field(
        None,
        alias="desiredLoggingService",
        description="The logging service the cluster should use to write logs. Currently available options: * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer available as of GKE 1.15). * `none` - no logs will be exported from the cluster. If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.",
    )
    desired_master: Optional[Master] = Field(
        None, alias="desiredMaster", description="Configuration for master components."
    )
    desired_identity_service_config: Optional[IdentityServiceConfig] = Field(
        None,
        alias="desiredIdentityServiceConfig",
        description="The desired Identity Service component configuration.",
    )
    desired_master_authorized_networks_config: Optional[MasterAuthorizedNetworksConfig] = Field(
        None,
        alias="desiredMasterAuthorizedNetworksConfig",
        description="The desired configuration options for master authorized networks feature.",
    )
    desired_workload_identity_config: Optional[WorkloadIdentityConfig] = Field(
        None,
        alias="desiredWorkloadIdentityConfig",
        description="Configuration for Workload Identity.",
    )
    desired_vertical_pod_autoscaling: Optional[VerticalPodAutoscaling] = Field(
        None,
        alias="desiredVerticalPodAutoscaling",
        description="Cluster-level Vertical Pod Autoscaling configuration.",
    )
    desired_binary_authorization: Optional[BinaryAuthorization] = Field(
        None,
        alias="desiredBinaryAuthorization",
        description="The desired configuration options for the Binary Authorization feature.",
    )
    desired_datapath_provider: Optional[DatapathProvider] = Field(
        None,
        alias="desiredDatapathProvider",
        description="The desired datapath provider for the cluster.",
    )
    desired_private_ipv6_google_access: Optional[PrivateIpv6GoogleAccess] = Field(
        None,
        alias="desiredPrivateIpv6GoogleAccess",
        description="The desired state of IPv6 connectivity to Google Services.",
    )
    desired_node_pool_id: Optional[str] = Field(
        None,
        alias="desiredNodePoolId",
        description='The node pool to be upgraded. This field is mandatory if "desired_node_version", "desired_image_family", "desired_node_pool_autoscaling", or "desired_workload_metadata_config" is specified and there is more than one node pool on the cluster.',
    )


class CreateNodePoolRequest(BaseModel):
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster. This field has been deprecated and replaced by the parent field.",
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://developers.google.com/console/help/new/#projectnumber). This field has been deprecated and replaced by the parent field.",
    )
    node_pool: Optional[NodePool] = Field(
        None, alias="nodePool", description="Required. The node pool to create."
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the parent field.",
    )
    parent: Optional[str] = Field(
        None,
        description="The parent (project, location, cluster id) where the node pool will be created. Specified in the format `projects/*/locations/*/clusters/*`.",
    )


class ListNodePoolsResponse(BaseModel):
    node_pools: Optional[List[NodePool]] = Field(
        None, alias="nodePools", description="A list of node pools for a cluster."
    )


class ListOperationsResponse(BaseModel):
    operations: Optional[List[Operation]] = Field(
        None, description="A list of operations in the project in the specified zone."
    )
    missing_zones: Optional[List[str]] = Field(
        None,
        alias="missingZones",
        description="If any zones are listed here, the list of operations returned may be missing the operations from those zones.",
    )


class UpdateClusterRequest(BaseModel):
    update: Optional[ClusterUpdate] = Field(
        None, description="Required. A description of the update."
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the name field.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster) of the cluster to update. Specified in the format `projects/*/locations/*/clusters/*`.",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the name field.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the name field.",
    )


class MaintenancePolicy(BaseModel):
    window: Optional[MaintenanceWindow] = Field(
        None,
        description="Specifies the maintenance window in which maintenance may be performed.",
    )
    resource_version: Optional[str] = Field(
        None,
        alias="resourceVersion",
        description="A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.",
    )


class SetMaintenancePolicyRequest(BaseModel):
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840).",
    )
    cluster_id: Optional[str] = Field(
        None,
        alias="clusterId",
        description="Required. The name of the cluster to update.",
    )
    maintenance_policy: Optional[MaintenancePolicy] = Field(
        None,
        alias="maintenancePolicy",
        description="Required. The maintenance policy to be set for the cluster. An empty field clears the existing maintenance policy.",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides.",
    )
    name: Optional[str] = Field(
        None,
        description="The name (project, location, cluster id) of the cluster to set maintenance policy. Specified in the format `projects/*/locations/*/clusters/*`.",
    )


class Cluster(BaseModel):
    ip_allocation_policy: Optional[IpAllocationPolicy] = Field(
        None,
        alias="ipAllocationPolicy",
        description="Configuration for cluster IP allocation.",
    )
    master: Optional[Master] = Field(None, description="Configuration for master components.")
    cluster_telemetry: Optional[ClusterTelemetry] = Field(
        None,
        alias="clusterTelemetry",
        description="Telemetry integration for the cluster.",
    )
    conditions: Optional[List[StatusCondition]] = Field(
        None, description="Which conditions caused the current cluster state."
    )
    database_encryption: Optional[DatabaseEncryption] = Field(
        None,
        alias="databaseEncryption",
        description="Configuration of etcd encryption.",
    )
    autopilot: Optional[Autopilot] = Field(
        None, description="Autopilot configuration for the cluster."
    )
    vertical_pod_autoscaling: Optional[VerticalPodAutoscaling] = Field(
        None,
        alias="verticalPodAutoscaling",
        description="Cluster-level Vertical Pod Autoscaling configuration.",
    )
    logging_config: Optional[LoggingConfig] = Field(
        None,
        alias="loggingConfig",
        description="Logging configuration for the cluster.",
    )
    locations: Optional[List[str]] = Field(
        None,
        description="The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the cluster's nodes should be located. This field provides a default value if [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations) are not specified during node pool creation. Warning: changing cluster locations will update the [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations) of all node pools and will result in nodes being added and/or removed.",
    )
    create_time: Optional[str] = Field(
        None,
        alias="createTime",
        description="[Output only] The time the cluster was created, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.",
    )
    endpoint: Optional[str] = Field(
        None,
        description="[Output only] The IP address of this cluster's master endpoint. The endpoint can be accessed from the internet at `https://username:password@endpoint/`. See the `masterAuth` property of this resource for username and password information.",
    )
    notification_config: Optional[NotificationConfig] = Field(
        None,
        alias="notificationConfig",
        description="Notification configuration of the cluster.",
    )
    node_pools: Optional[List[NodePool]] = Field(
        None,
        alias="nodePools",
        description='The node pools associated with this cluster. This field should not be set if "node_config" or "initial_node_count" are specified.',
    )
    maintenance_policy: Optional[MaintenancePolicy] = Field(
        None,
        alias="maintenancePolicy",
        description="Configure the maintenance policy for this cluster.",
    )
    node_ipv4_cidr_size: Optional[int] = Field(
        None,
        alias="nodeIpv4CidrSize",
        description="[Output only] The size of the address space on each node for hosting containers. This is provisioned from within the `container_ipv4_cidr` range. This field will only be set when cluster is in route-based network mode.",
    )
    network_policy: Optional[NetworkPolicy] = Field(
        None,
        alias="networkPolicy",
        description="Configuration options for the NetworkPolicy feature.",
    )
    enable_tpu: Optional[bool] = Field(
        None,
        alias="enableTpu",
        description="Enable the ability to use Cloud TPUs in this cluster. This field is deprecated, use tpu_config.enabled instead.",
    )
    instance_group_urls: Optional[List[str]] = Field(
        None,
        alias="instanceGroupUrls",
        description="Deprecated. Use node_pools.instance_group_urls.",
    )
    master_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="masterIpv4CidrBlock",
        description="The IP prefix in CIDR notation to use for the hosted master network. This prefix will be used for assigning private IP addresses to the master or set of masters, as well as the ILB VIP. This field is deprecated, use private_cluster_config.master_ipv4_cidr_block instead.",
    )
    pod_security_policy_config: Optional[PodSecurityPolicyConfig] = Field(
        None,
        alias="podSecurityPolicyConfig",
        description="Configuration for the PodSecurityPolicy feature.",
    )
    current_node_version: Optional[str] = Field(
        None,
        alias="currentNodeVersion",
        description="[Output only] Deprecated, use [NodePool.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools) instead. The current version of the node software components. If they are currently at multiple versions because they're in the process of being upgraded, this reflects the minimum version of all nodes.",
    )
    identity_service_config: Optional[IdentityServiceConfig] = Field(
        None,
        alias="identityServiceConfig",
        description="Configuration for Identity Service component.",
    )
    monitoring_service: Optional[str] = Field(
        None,
        alias="monitoringService",
        description='The monitoring service the cluster should use to write metrics. Currently available options: * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster. If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.',
    )
    id: Optional[str] = Field(None, description="Output only. Unique id for the cluster.")
    network_config: Optional[NetworkConfig] = Field(
        None, alias="networkConfig", description="Configuration for cluster networking."
    )
    mesh_certificates: Optional[MeshCertificates] = Field(
        None,
        alias="meshCertificates",
        description="Configuration for issuance of mTLS keys and certificates to Kubernetes pods.",
    )
    tpu_config: Optional[TpuConfig] = Field(
        None, alias="tpuConfig", description="Configuration for Cloud TPU support;"
    )
    master_authorized_networks_config: Optional[MasterAuthorizedNetworksConfig] = Field(
        None,
        alias="masterAuthorizedNetworksConfig",
        description="The configuration options for master authorized networks feature.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="The fingerprint of the set of labels for this cluster.",
    )
    resource_usage_export_config: Optional[ResourceUsageExportConfig] = Field(
        None,
        alias="resourceUsageExportConfig",
        description="Configuration for exporting resource usages. Resource usage export is disabled when this config unspecified.",
    )
    resource_labels: Optional[Dict[str, str]] = Field(
        None,
        alias="resourceLabels",
        description="The resource labels for the cluster to use to annotate any related Google Compute Engine resources.",
    )
    legacy_abac: Optional[LegacyAbac] = Field(
        None,
        alias="legacyAbac",
        description="Configuration for the legacy ABAC authorization mode.",
    )
    tpu_ipv4_cidr_block: Optional[str] = Field(
        None,
        alias="tpuIpv4CidrBlock",
        description="[Output only] The IP address range of the Cloud TPUs in this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`).",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output only] Server-defined URL for the resource.",
    )
    enable_kubernetes_alpha: Optional[bool] = Field(
        None,
        alias="enableKubernetesAlpha",
        description="Kubernetes alpha features are enabled on this cluster. This includes alpha API groups (e.g. v1beta1) and features that may not be production ready in the kubernetes version of the master and nodes. The cluster has no SLA for uptime and master/node upgrades are disabled. Alpha enabled clusters are automatically deleted thirty days after creation.",
    )
    current_master_version: Optional[str] = Field(
        None,
        alias="currentMasterVersion",
        description="[Output only] The current software version of the master endpoint.",
    )
    binary_authorization: Optional[BinaryAuthorization] = Field(
        None,
        alias="binaryAuthorization",
        description="Configuration for Binary Authorization.",
    )
    logging_service: Optional[str] = Field(
        None,
        alias="loggingService",
        description="The logging service the cluster should use to write logs. Currently available options: * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer available as of GKE 1.15). * `none` - no logs will be exported from the cluster. If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.",
    )
    authenticator_groups_config: Optional[AuthenticatorGroupsConfig] = Field(
        None,
        alias="authenticatorGroupsConfig",
        description="Configuration controlling RBAC group membership information.",
    )
    default_max_pods_constraint: Optional[MaxPodsConstraint] = Field(
        None,
        alias="defaultMaxPodsConstraint",
        description="The default constraint on the maximum number of pods that can be run simultaneously on a node in the node pool of this cluster. Only honored if cluster created with IP Alias support.",
    )
    description: Optional[str] = Field(None, description="An optional description of this cluster.")
    initial_node_count: Optional[int] = Field(
        None,
        alias="initialNodeCount",
        description='The number of nodes to create in this cluster. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota. For requests, this field should only be used in lieu of a "node_pool" object, since this configuration (along with the "node_config") will be used to create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the same time. This field is deprecated, use node_pool.initial_node_count instead.',
    )
    private_cluster_config: Optional[PrivateClusterConfig] = Field(
        None,
        alias="privateClusterConfig",
        description="Configuration for private cluster.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="The name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which the cluster is connected. On output this shows the subnetwork ID instead of the name.",
    )
    monitoring_config: Optional[MonitoringConfig] = Field(
        None,
        alias="monitoringConfig",
        description="Monitoring configuration for the cluster.",
    )
    current_node_count: Optional[int] = Field(
        None,
        alias="currentNodeCount",
        description="[Output only] The number of nodes currently in the cluster. Deprecated. Call Kubernetes API directly to retrieve node information.",
    )
    master_auth: Optional[MasterAuth] = Field(
        None,
        alias="masterAuth",
        description='The authentication information for accessing the master endpoint. If unspecified, the defaults are used: For clusters before v1.12, if master_auth is unspecified, `username` will be set to "admin", a random password will be generated, and a client certificate will be issued.',
    )
    expire_time: Optional[str] = Field(
        None,
        alias="expireTime",
        description="[Output only] The time the cluster will be automatically deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="[Output only] Deprecated. Use conditions instead. Additional information about the current status of this cluster, if available.",
    )
    private_cluster: Optional[bool] = Field(
        None,
        alias="privateCluster",
        description="If this is a private cluster setup. Private clusters are clusters that, by default have no external IP addresses on the nodes and where nodes and the master communicate over private IP addresses. This field is deprecated, use private_cluster_config.enable_private_nodes instead.",
    )
    initial_cluster_version: Optional[str] = Field(
        None,
        alias="initialClusterVersion",
        description='The initial Kubernetes version for this cluster. Valid versions are those found in validMasterVersions returned by getServerConfig. The version can be upgraded over time; such upgrades are reflected in currentMasterVersion and currentNodeVersion. Users may specify either explicit versions offered by Kubernetes Engine or version aliases, which have the following behavior: - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "","-": picks the default Kubernetes version',
    )
    shielded_nodes: Optional[ShieldedNodes] = Field(
        None, alias="shieldedNodes", description="Shielded Nodes configuration."
    )
    network: Optional[str] = Field(
        None,
        description="The name of the Google Compute Engine [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. If left unspecified, the `default` network will be used. On output this shows the network ID instead of the name.",
    )
    release_channel: Optional[ReleaseChannel] = Field(
        None, alias="releaseChannel", description="Release channel configuration."
    )
    node_config: Optional[NodeConfig] = Field(
        None,
        alias="nodeConfig",
        description='Parameters used in creating the cluster\'s nodes. For requests, this field should only be used in lieu of a "node_pool" object, since this configuration (along with the "initial_node_count") will be used to create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the same time. For responses, this field will be populated with the node configuration of the first node pool. (For configuration of each node pool, see `node_pool.config`) If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.',
    )
    status: Optional[Status] = Field(
        None, description="[Output only] The current status of this cluster."
    )
    zone: Optional[str] = Field(
        None,
        description="[Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field is deprecated, use location instead.",
    )
    services_ipv4_cidr: Optional[str] = Field(
        None,
        alias="servicesIpv4Cidr",
        description="[Output only] The IP address range of the Kubernetes services in this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`). Service addresses are typically put in the last `/16` from the container CIDR.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of this cluster. The name must be unique within this project and location (e.g. zone or region), and can be up to 40 characters with the following restrictions: * Lowercase letters, numbers, and hyphens only. * Must start with a letter. * Must end with a number or a letter.",
    )
    autoscaling: Optional[ClusterAutoscaling] = Field(
        None, description="Cluster-level autoscaling configuration."
    )
    cluster_ipv4_cidr: Optional[str] = Field(
        None,
        alias="clusterIpv4Cidr",
        description="The IP address range of the container pods in this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`). Leave blank to have one automatically chosen or specify a `/14` block in `10.0.0.0/8`.",
    )
    location: Optional[str] = Field(
        None,
        description="[Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available) or [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available) in which the cluster resides.",
    )
    workload_certificates: Optional[WorkloadCertificates] = Field(
        None,
        alias="workloadCertificates",
        description="Configuration for issuance of mTLS keys and certificates to Kubernetes pods.",
    )
    workload_identity_config: Optional[WorkloadIdentityConfig] = Field(
        None,
        alias="workloadIdentityConfig",
        description="Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.",
    )
    confidential_nodes: Optional[ConfidentialNodes] = Field(
        None,
        alias="confidentialNodes",
        description="Configuration of Confidential Nodes",
    )
    node_pool_defaults: Optional[NodePoolDefaults] = Field(
        None,
        alias="nodePoolDefaults",
        description="Default NodePool settings for the entire cluster. These settings are overridden if specified on the specific NodePool object.",
    )
    addons_config: Optional[AddonsConfig] = Field(
        None,
        alias="addonsConfig",
        description="Configurations for the various addons available to run in the cluster.",
    )


class CreateClusterRequest(BaseModel):
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="Required. Deprecated. The Google Developers Console [project ID or project number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and replaced by the parent field.",
    )
    parent: Optional[str] = Field(
        None,
        description="The parent (project and location) where the cluster will be created. Specified in the format `projects/*/locations/*`.",
    )
    cluster: Optional[Cluster] = Field(
        None,
        description="Required. A [cluster resource](https://cloud.google.com/container-engine/reference/rest/v1beta1/projects.locations.clusters)",
    )
    zone: Optional[str] = Field(
        None,
        description="Required. Deprecated. The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field has been deprecated and replaced by the parent field.",
    )


class ListClustersResponse(BaseModel):
    missing_zones: Optional[List[str]] = Field(
        None,
        alias="missingZones",
        description="If any zones are listed here, the list of clusters returned may be missing those zones.",
    )
    clusters: Optional[List[Cluster]] = Field(
        None,
        description="A list of clusters in the project in the specified zone, or across all ones.",
    )


class Model(BaseModel):
    autoprovisioning_node_pool_defaults: Optional[AutoprovisioningNodePoolDefaults] = Field(
        None, alias="AutoprovisioningNodePoolDefaults"
    )
    linux_node_config: Optional[LinuxNodeConfig] = Field(None, alias="LinuxNodeConfig")
    big_query_destination: Optional[BigQueryDestination] = Field(None, alias="BigQueryDestination")
    cluster_telemetry: Optional[ClusterTelemetry] = Field(None, alias="ClusterTelemetry")
    legacy_abac: Optional[LegacyAbac] = Field(None, alias="LegacyAbac")
    authenticator_groups_config: Optional[AuthenticatorGroupsConfig] = Field(
        None, alias="AuthenticatorGroupsConfig"
    )
    list_clusters_response: Optional[ListClustersResponse] = Field(
        None, alias="ListClustersResponse"
    )
    get_json_web_keys_response: Optional[GetJsonWebKeysResponse] = Field(
        None, alias="GetJSONWebKeysResponse"
    )
    set_network_policy_request: Optional[SetNetworkPolicyRequest] = Field(
        None, alias="SetNetworkPolicyRequest"
    )
    operation: Optional[Operation] = Field(None, alias="Operation")
    node_taint: Optional[NodeTaint1] = Field(None, alias="NodeTaint")
    recurring_time_window: Optional[RecurringTimeWindow] = Field(None, alias="RecurringTimeWindow")
    private_cluster_master_global_access_config: Optional[
        PrivateClusterMasterGlobalAccessConfig
    ] = Field(None, alias="PrivateClusterMasterGlobalAccessConfig")
    set_locations_request: Optional[SetLocationsRequest] = Field(None, alias="SetLocationsRequest")
    service_external_i_ps_config: Optional[ServiceExternalIPsConfig] = Field(
        None, alias="ServiceExternalIPsConfig"
    )
    workload_identity_config: Optional[WorkloadIdentityConfig] = Field(
        None, alias="WorkloadIdentityConfig"
    )
    update_master_request: Optional[UpdateMasterRequest] = Field(None, alias="UpdateMasterRequest")
    set_node_pool_management_request: Optional[SetNodePoolManagementRequest] = Field(
        None, alias="SetNodePoolManagementRequest"
    )
    complete_ip_rotation_request: Optional[CompleteIpRotationRequest] = Field(
        None, alias="CompleteIPRotationRequest"
    )
    node_pool_defaults: Optional[NodePoolDefaults] = Field(None, alias="NodePoolDefaults")
    list_usable_subnetworks_response: Optional[ListUsableSubnetworksResponse] = Field(
        None, alias="ListUsableSubnetworksResponse"
    )
    cloud_run_config: Optional[CloudRunConfig] = Field(None, alias="CloudRunConfig")
    ephemeral_storage_config: Optional[EphemeralStorageConfig] = Field(
        None, alias="EphemeralStorageConfig"
    )
    set_node_pool_autoscaling_request: Optional[SetNodePoolAutoscalingRequest] = Field(
        None, alias="SetNodePoolAutoscalingRequest"
    )
    tpu_config: Optional[TpuConfig] = Field(None, alias="TpuConfig")
    node_pool_autoscaling: Optional[NodePoolAutoscaling] = Field(None, alias="NodePoolAutoscaling")
    set_logging_service_request: Optional[SetLoggingServiceRequest] = Field(
        None, alias="SetLoggingServiceRequest"
    )
    network_tags: Optional[NetworkTags] = Field(None, alias="NetworkTags")
    upgrade_settings: Optional[UpgradeSettings] = Field(None, alias="UpgradeSettings")
    cancel_operation_request: Optional[CancelOperationRequest] = Field(
        None, alias="CancelOperationRequest"
    )
    master_auth: Optional[MasterAuth] = Field(None, alias="MasterAuth")
    monitoring_config: Optional[MonitoringConfig] = Field(None, alias="MonitoringConfig")
    identity_service_config: Optional[IdentityServiceConfig] = Field(
        None, alias="IdentityServiceConfig"
    )
    shielded_nodes: Optional[ShieldedNodes] = Field(None, alias="ShieldedNodes")
    status_condition: Optional[StatusCondition] = Field(None, alias="StatusCondition")
    upgrade_event: Optional[UpgradeEvent] = Field(None, alias="UpgradeEvent")
    reservation_affinity: Optional[ReservationAffinity] = Field(None, alias="ReservationAffinity")
    sandbox_config: Optional[SandboxConfig] = Field(None, alias="SandboxConfig")
    date: Optional[Date] = Field(None, alias="Date")
    ip_allocation_policy: Optional[IpAllocationPolicy] = Field(None, alias="IPAllocationPolicy")
    network_policy_config: Optional[NetworkPolicyConfig] = Field(None, alias="NetworkPolicyConfig")
    logging_config: Optional[LoggingConfig] = Field(None, alias="LoggingConfig")
    private_cluster_config: Optional[PrivateClusterConfig] = Field(
        None, alias="PrivateClusterConfig"
    )
    cluster_update: Optional[ClusterUpdate] = Field(None, alias="ClusterUpdate")
    autopilot: Optional[Autopilot] = Field(None, alias="Autopilot")
    node_config: Optional[NodeConfig] = Field(None, alias="NodeConfig")
    node_kubelet_config: Optional[NodeKubeletConfig] = Field(None, alias="NodeKubeletConfig")
    usable_subnetwork: Optional[UsableSubnetwork] = Field(None, alias="UsableSubnetwork")
    accelerator_config: Optional[AcceleratorConfig] = Field(None, alias="AcceleratorConfig")
    dns_cache_config: Optional[DnsCacheConfig] = Field(None, alias="DnsCacheConfig")
    node_taints: Optional[NodeTaints] = Field(None, alias="NodeTaints")
    cluster: Optional[Cluster] = Field(None, alias="Cluster")
    gce_persistent_disk_csi_driver_config: Optional[GcePersistentDiskCsiDriverConfig] = Field(
        None, alias="GcePersistentDiskCsiDriverConfig"
    )
    create_node_pool_request: Optional[CreateNodePoolRequest] = Field(
        None, alias="CreateNodePoolRequest"
    )
    release_channel: Optional[ReleaseChannel] = Field(None, alias="ReleaseChannel")
    http_load_balancing: Optional[HttpLoadBalancing] = Field(None, alias="HttpLoadBalancing")
    daily_maintenance_window: Optional[DailyMaintenanceWindow] = Field(
        None, alias="DailyMaintenanceWindow"
    )
    available_version: Optional[AvailableVersion] = Field(None, alias="AvailableVersion")
    get_open_id_config_response: Optional[GetOpenIdConfigResponse] = Field(
        None, alias="GetOpenIDConfigResponse"
    )
    workload_certificates: Optional[WorkloadCertificates] = Field(
        None, alias="WorkloadCertificates"
    )
    intra_node_visibility_config: Optional[IntraNodeVisibilityConfig] = Field(
        None, alias="IntraNodeVisibilityConfig"
    )
    ilb_subsetting_config: Optional[IlbSubsettingConfig] = Field(None, alias="ILBSubsettingConfig")
    advanced_machine_features: Optional[AdvancedMachineFeatures] = Field(
        None, alias="AdvancedMachineFeatures"
    )
    client_certificate_config: Optional[ClientCertificateConfig] = Field(
        None, alias="ClientCertificateConfig"
    )
    status: Optional[Status4] = Field(None, alias="Status")
    resource_limit: Optional[ResourceLimit] = Field(None, alias="ResourceLimit")
    node_labels: Optional[NodeLabels] = Field(None, alias="NodeLabels")
    node_network_config: Optional[NodeNetworkConfig] = Field(None, alias="NodeNetworkConfig")
    database_encryption: Optional[DatabaseEncryption] = Field(None, alias="DatabaseEncryption")
    node_pool: Optional[NodePool] = Field(None, alias="NodePool")
    master_authorized_networks_config: Optional[MasterAuthorizedNetworksConfig] = Field(
        None, alias="MasterAuthorizedNetworksConfig"
    )
    logging_component_config: Optional[LoggingComponentConfig] = Field(
        None, alias="LoggingComponentConfig"
    )
    confidential_nodes: Optional[ConfidentialNodes] = Field(None, alias="ConfidentialNodes")
    create_cluster_request: Optional[CreateClusterRequest] = Field(
        None, alias="CreateClusterRequest"
    )
    http_cache_control_response_header: Optional[HttpCacheControlResponseHeader] = Field(
        None, alias="HttpCacheControlResponseHeader"
    )
    addons_config: Optional[AddonsConfig] = Field(None, alias="AddonsConfig")
    max_pods_constraint: Optional[MaxPodsConstraint] = Field(None, alias="MaxPodsConstraint")
    location: Optional[Location] = Field(None, alias="Location")
    time_window: Optional[TimeWindow] = Field(None, alias="TimeWindow")
    network_policy: Optional[NetworkPolicy] = Field(None, alias="NetworkPolicy")
    set_maintenance_policy_request: Optional[SetMaintenancePolicyRequest] = Field(
        None, alias="SetMaintenancePolicyRequest"
    )
    workload_metadata_config: Optional[WorkloadMetadataConfig] = Field(
        None, alias="WorkloadMetadataConfig"
    )
    windows_version: Optional[WindowsVersion1] = Field(None, alias="WindowsVersion")
    metric: Optional[Metric] = Field(None, alias="Metric")
    usable_subnetwork_secondary_range: Optional[UsableSubnetworkSecondaryRange] = Field(
        None, alias="UsableSubnetworkSecondaryRange"
    )
    maintenance_policy: Optional[MaintenancePolicy] = Field(None, alias="MaintenancePolicy")
    pub_sub: Optional[PubSub] = Field(None, alias="PubSub")
    empty: Optional[Empty] = Field(None, alias="Empty")
    list_node_pools_response: Optional[ListNodePoolsResponse] = Field(
        None, alias="ListNodePoolsResponse"
    )
    cidr_block: Optional[CidrBlock] = Field(None, alias="CidrBlock")
    config_connector_config: Optional[ConfigConnectorConfig] = Field(
        None, alias="ConfigConnectorConfig"
    )
    monitoring_component_config: Optional[MonitoringComponentConfig] = Field(
        None, alias="MonitoringComponentConfig"
    )
    set_node_pool_size_request: Optional[SetNodePoolSizeRequest] = Field(
        None, alias="SetNodePoolSizeRequest"
    )
    set_monitoring_service_request: Optional[SetMonitoringServiceRequest] = Field(
        None, alias="SetMonitoringServiceRequest"
    )
    default_snat_status: Optional[DefaultSnatStatus] = Field(None, alias="DefaultSnatStatus")
    vertical_pod_autoscaling: Optional[VerticalPodAutoscaling] = Field(
        None, alias="VerticalPodAutoscaling"
    )
    operation_progress: Optional[OperationProgress] = Field(None, alias="OperationProgress")
    set_legacy_abac_request: Optional[SetLegacyAbacRequest] = Field(
        None, alias="SetLegacyAbacRequest"
    )
    auto_upgrade_options: Optional[AutoUpgradeOptions] = Field(None, alias="AutoUpgradeOptions")
    managed_prometheus_config: Optional[ManagedPrometheusConfig] = Field(
        None, alias="ManagedPrometheusConfig"
    )
    set_labels_request: Optional[SetLabelsRequest] = Field(None, alias="SetLabelsRequest")
    start_ip_rotation_request: Optional[StartIpRotationRequest] = Field(
        None, alias="StartIPRotationRequest"
    )
    dns_config: Optional[DnsConfig] = Field(None, alias="DNSConfig")
    list_locations_response: Optional[ListLocationsResponse] = Field(
        None, alias="ListLocationsResponse"
    )
    mesh_certificates: Optional[MeshCertificates] = Field(None, alias="MeshCertificates")
    gcp_filestore_csi_driver_config: Optional[GcpFilestoreCsiDriverConfig] = Field(
        None, alias="GcpFilestoreCsiDriverConfig"
    )
    server_config: Optional[ServerConfig] = Field(None, alias="ServerConfig")
    maintenance_window: Optional[MaintenanceWindow] = Field(None, alias="MaintenanceWindow")
    kubernetes_dashboard: Optional[KubernetesDashboard] = Field(None, alias="KubernetesDashboard")
    notification_config: Optional[NotificationConfig] = Field(None, alias="NotificationConfig")
    gcfs_config: Optional[GcfsConfig] = Field(None, alias="GcfsConfig")
    update_node_pool_request: Optional[UpdateNodePoolRequest] = Field(
        None, alias="UpdateNodePoolRequest"
    )
    network_config: Optional[NetworkConfig] = Field(None, alias="NetworkConfig")
    windows_versions: Optional[WindowsVersions] = Field(None, alias="WindowsVersions")
    virtual_nic: Optional[VirtualNic] = Field(None, alias="VirtualNIC")
    set_master_auth_request: Optional[SetMasterAuthRequest] = Field(
        None, alias="SetMasterAuthRequest"
    )
    release_channel_config: Optional[ReleaseChannelConfig] = Field(
        None, alias="ReleaseChannelConfig"
    )
    consumption_metering_config: Optional[ConsumptionMeteringConfig] = Field(
        None, alias="ConsumptionMeteringConfig"
    )
    node_config_defaults: Optional[NodeConfigDefaults] = Field(None, alias="NodeConfigDefaults")
    istio_config: Optional[IstioConfig] = Field(None, alias="IstioConfig")
    kalm_config: Optional[KalmConfig] = Field(None, alias="KalmConfig")
    node_management: Optional[NodeManagement] = Field(None, alias="NodeManagement")
    master: Optional[Master] = Field(None, alias="Master")
    shielded_instance_config: Optional[ShieldedInstanceConfig] = Field(
        None, alias="ShieldedInstanceConfig"
    )
    list_operations_response: Optional[ListOperationsResponse] = Field(
        None, alias="ListOperationsResponse"
    )
    jwk: Optional[Jwk] = Field(None, alias="Jwk")
    upgrade_available_event: Optional[UpgradeAvailableEvent] = Field(
        None, alias="UpgradeAvailableEvent"
    )
    set_addons_config_request: Optional[SetAddonsConfigRequest] = Field(
        None, alias="SetAddonsConfigRequest"
    )
    update_cluster_request: Optional[UpdateClusterRequest] = Field(
        None, alias="UpdateClusterRequest"
    )
    pod_security_policy_config: Optional[PodSecurityPolicyConfig] = Field(
        None, alias="PodSecurityPolicyConfig"
    )
    binary_authorization: Optional[BinaryAuthorization] = Field(None, alias="BinaryAuthorization")
    cluster_autoscaling: Optional[ClusterAutoscaling] = Field(None, alias="ClusterAutoscaling")
    rollback_node_pool_upgrade_request: Optional[RollbackNodePoolUpgradeRequest] = Field(
        None, alias="RollbackNodePoolUpgradeRequest"
    )
    resource_usage_export_config: Optional[ResourceUsageExportConfig] = Field(
        None, alias="ResourceUsageExportConfig"
    )
    horizontal_pod_autoscaling: Optional[HorizontalPodAutoscaling] = Field(
        None, alias="HorizontalPodAutoscaling"
    )


OperationProgress.update_forward_refs()
