# generated by datamodel-codegen:
#   filename:  schemas.json
#   timestamp: 2022-05-24T16:15:52+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional

from pydantic import BaseModel, Field, constr


class Code(Enum):
    cleanup_failed = "CLEANUP_FAILED"
    deprecated_resource_used = "DEPRECATED_RESOURCE_USED"
    deprecated_type_used = "DEPRECATED_TYPE_USED"
    disk_size_larger_than_image_size = "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
    experimental_type_used = "EXPERIMENTAL_TYPE_USED"
    external_api_warning = "EXTERNAL_API_WARNING"
    field_value_overriden = "FIELD_VALUE_OVERRIDEN"
    injected_kernels_deprecated = "INJECTED_KERNELS_DEPRECATED"
    large_deployment_warning = "LARGE_DEPLOYMENT_WARNING"
    missing_type_dependency = "MISSING_TYPE_DEPENDENCY"
    next_hop_address_not_assigned = "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
    next_hop_cannot_ip_forward = "NEXT_HOP_CANNOT_IP_FORWARD"
    next_hop_instance_has_no_ipv6_interface = "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE"
    next_hop_instance_not_found = "NEXT_HOP_INSTANCE_NOT_FOUND"
    next_hop_instance_not_on_network = "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
    next_hop_not_running = "NEXT_HOP_NOT_RUNNING"
    not_critical_error = "NOT_CRITICAL_ERROR"
    no_results_on_page = "NO_RESULTS_ON_PAGE"
    partial_success = "PARTIAL_SUCCESS"
    required_tos_agreement = "REQUIRED_TOS_AGREEMENT"
    resource_in_use_by_other_resource_warning = "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
    resource_not_deleted = "RESOURCE_NOT_DELETED"
    schema_validation_ignored = "SCHEMA_VALIDATION_IGNORED"
    single_instance_property_template = "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
    undeclared_properties = "UNDECLARED_PROPERTIES"
    unreachable = "UNREACHABLE"


class Datum(BaseModel):
    value: Optional[str] = Field(
        None, description="[Output Only] A warning data value corresponding to the key."
    )
    key: Optional[str] = Field(
        None,
        description="[Output Only] A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).",
    )


class Warning(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum1(Datum):
    pass


class Warning1(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum1]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Error1(BaseModel):
    message: Optional[str] = Field(
        None, description="[Output Only] An optional, human-readable error message."
    )
    location: Optional[str] = Field(
        None,
        description="[Output Only] Indicates the field in the request that caused the error. This property is optional.",
    )
    code: Optional[str] = Field(
        None, description="[Output Only] The error type identifier for this error."
    )


class Error(BaseModel):
    errors: Optional[List[Error1]] = Field(
        None,
        description="[Output Only] The array of errors encountered while processing this operation.",
    )


class Status(Enum):
    done = "DONE"
    pending = "PENDING"
    running = "RUNNING"


class Datum2(BaseModel):
    key: Optional[str] = Field(
        None,
        description="[Output Only] A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).",
    )
    value: Optional[str] = Field(
        None, description="[Output Only] A warning data value corresponding to the key."
    )


class Warning2(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum2]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Operation(BaseModel):
    name: Optional[str] = Field(None, description="[Output Only] Name of the operation.")
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="[Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the operation. This identifier is defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#operation",
        description="[Output Only] Type of the resource. Always `compute#operation` for Operation resources.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.",
    )
    error: Optional[Error] = Field(
        None,
        description="[Output Only] If errors are generated during processing of the operation, this field will be populated.",
    )
    http_error_status_code: Optional[int] = Field(
        None,
        alias="httpErrorStatusCode",
        description="[Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="[Output Only] An optional textual description of the current status of the operation.",
    )
    description: Optional[str] = Field(
        None,
        description="[Output Only] A textual description of the operation, which is set when the operation is created.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    progress: Optional[int] = Field(
        None,
        description="[Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.",
    )
    operation_type: Optional[str] = Field(
        None,
        alias="operationType",
        description="[Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.",
    )
    http_error_message: Optional[str] = Field(
        None,
        alias="httpErrorMessage",
        description="[Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Deprecated] This field is deprecated.",
    )
    operation_group_id: Optional[str] = Field(
        None,
        alias="operationGroupId",
        description="[Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.",
    )
    insert_time: Optional[str] = Field(
        None,
        alias="insertTime",
        description="[Output Only] The time that this operation was requested. This value is in RFC3339 text format.",
    )
    target_id: Optional[str] = Field(
        None,
        alias="targetId",
        description="[Output Only] The unique target ID, which identifies a specific incarnation of the target resource.",
    )
    user: Optional[str] = Field(
        None,
        description="[Output Only] User who requested the operation, for example: `user@example.com`.",
    )
    end_time: Optional[str] = Field(
        None,
        alias="endTime",
        description="[Output Only] The time that this operation was completed. This value is in RFC3339 text format.",
    )
    status: Optional[Status] = Field(
        None,
        description="[Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.",
    )
    target_link: Optional[str] = Field(
        None,
        alias="targetLink",
        description="[Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.",
    )
    client_operation_id: Optional[str] = Field(
        None,
        alias="clientOperationId",
        description="[Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.",
    )
    warnings: Optional[List[Warning2]] = Field(
        None,
        description="[Output Only] If warning messages are generated during processing of the operation, this field will be populated.",
    )


class InstanceGroupManagersRecreateInstancesRequest(BaseModel):
    instances: Optional[List[str]] = Field(
        None,
        description="The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )


class State(Enum):
    effective = "EFFECTIVE"
    ineffective = "INEFFECTIVE"


class FirewallPolicyRuleSecureTag(BaseModel):
    state: Optional[State] = Field(
        None,
        description="[Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.",
    )
    name: Optional[constr(regex=r"tagValues/[0-9]+")] = Field(
        None,
        description="Name of the secure tag, created with TagManager's TagValue API.",
    )


class Type(Enum):
    project = "PROJECT"
    xpn_resource_type_unspecified = "XPN_RESOURCE_TYPE_UNSPECIFIED"


class XpnResourceId(BaseModel):
    id: Optional[str] = Field(
        None,
        description="The ID of the service resource. In the case of projects, this field supports project id (e.g., my-project-123) and project number (e.g. 12345678).",
    )
    type: Optional[Type] = Field(None, description="The type of the service resource.")


class PrivateIpv6GoogleAccess(Enum):
    enable_bidirectional_access_to_google = "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE"
    enable_outbound_vm_access_to_google = "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE"
    inherit_from_subnetwork = "INHERIT_FROM_SUBNETWORK"


class Item(BaseModel):
    value: Optional[str] = Field(
        None,
        description="Value for the metadata entry. These are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on values is that their size must be less than or equal to 262144 bytes (256 KiB).",
    )
    key: Optional[constr(regex=r"[a-zA-Z0-9-_]{1,128}")] = Field(
        None,
        description="Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes in length. This is reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project.",
    )


class Metadata(BaseModel):
    fingerprint: Optional[str] = Field(
        None,
        description="Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.",
    )
    items: Optional[List[Item]] = Field(
        None,
        description="Array of key/value pairs. The total size of all keys and values must be less than 512 KB.",
    )
    kind: Optional[str] = Field(
        "compute#metadata",
        description="[Output Only] Type of the resource. Always compute#metadata for metadata.",
    )


class Tags(BaseModel):
    items: Optional[List[str]] = Field(
        None,
        description="An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.",
        regex="[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Specifies a fingerprint for this request, which is essentially a hash of the tags' contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update tags. You must always provide an up-to-date fingerprint hash in order to update or change tags. To see the latest fingerprint, make get() request to the instance.",
    )


class TotalEgressBandwidthTier(Enum):
    default = "DEFAULT"
    tier_1 = "TIER_1"


class NetworkPerformanceConfig(BaseModel):
    total_egress_bandwidth_tier: Optional[TotalEgressBandwidthTier] = Field(
        None, alias="totalEgressBandwidthTier"
    )


class ConfidentialInstanceConfig(BaseModel):
    enable_confidential_compute: Optional[bool] = Field(
        None,
        alias="enableConfidentialCompute",
        description="Defines whether the instance should have confidential compute enabled.",
    )


class ShieldedInstanceConfig(BaseModel):
    enable_secure_boot: Optional[bool] = Field(
        None,
        alias="enableSecureBoot",
        description="Defines whether the instance has Secure Boot enabled. Disabled by default.",
    )
    enable_integrity_monitoring: Optional[bool] = Field(
        None,
        alias="enableIntegrityMonitoring",
        description="Defines whether the instance has integrity monitoring enabled. Enabled by default.",
    )
    enable_vtpm: Optional[bool] = Field(
        None,
        alias="enableVtpm",
        description="Defines whether the instance has the vTPM enabled. Enabled by default.",
    )


class AcceleratorConfig(BaseModel):
    accelerator_type: Optional[str] = Field(
        None,
        alias="acceleratorType",
        description="Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.",
    )
    accelerator_count: Optional[int] = Field(
        None,
        alias="acceleratorCount",
        description="The number of the guest accelerator cards exposed to this instance.",
    )


class Mode(Enum):
    read_only = "READ_ONLY"
    read_write = "READ_WRITE"


class Type1(Enum):
    persistent = "PERSISTENT"
    scratch = "SCRATCH"


class Interface(Enum):
    nvme = "NVME"
    scsi = "SCSI"


class Type2(Enum):
    feature_type_unspecified = "FEATURE_TYPE_UNSPECIFIED"
    gvnic = "GVNIC"
    multi_ip_subnet = "MULTI_IP_SUBNET"
    secure_boot = "SECURE_BOOT"
    sev_capable = "SEV_CAPABLE"
    uefi_compatible = "UEFI_COMPATIBLE"
    virtio_scsi_multiqueue = "VIRTIO_SCSI_MULTIQUEUE"
    windows = "WINDOWS"


class GuestOsFeature(BaseModel):
    type: Optional[Type2] = Field(
        None,
        description="The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE - SEV_SNP_CAPABLE For more information, see Enabling guest operating system features.",
    )


class FileType(Enum):
    bin = "BIN"
    undefined = "UNDEFINED"
    x509 = "X509"


class FileContentBuffer(BaseModel):
    file_type: Optional[FileType] = Field(
        None, alias="fileType", description="The file type of source file."
    )
    content: Optional[str] = Field(None, description="The raw content in the secure keys file.")


class CustomerEncryptionKey(BaseModel):
    rsa_encrypted_key: Optional[str] = Field(
        None,
        alias="rsaEncryptedKey",
        description='Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem ',
    )
    sha256: Optional[str] = Field(
        None,
        description="[Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.",
    )
    kms_key_service_account: Optional[str] = Field(
        None,
        alias="kmsKeyServiceAccount",
        description='The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/ ',
    )
    kms_key_name: Optional[str] = Field(
        None,
        alias="kmsKeyName",
        description='The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key ',
    )
    raw_key: Optional[str] = Field(
        None,
        alias="rawKey",
        description='Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=" ',
    )


class OnUpdateAction(Enum):
    recreate_disk = "RECREATE_DISK"
    recreate_disk_if_source_changed = "RECREATE_DISK_IF_SOURCE_CHANGED"
    use_existing_disk = "USE_EXISTING_DISK"


class AttachedDiskInitializeParams(BaseModel):
    description: Optional[str] = Field(
        None,
        description="An optional description. Provide this property when creating the disk.",
    )
    provisioned_iops: Optional[str] = Field(
        None,
        alias="provisionedIops",
        description="Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.",
    )
    source_snapshot: Optional[str] = Field(
        None,
        alias="sourceSnapshot",
        description="The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.",
    )
    disk_type: Optional[str] = Field(
        None,
        alias="diskType",
        description="Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you define this field, you can provide either the full or partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is the name of the disk type, not URL.",
    )
    licenses: Optional[List[str]] = Field(
        None,
        description="A list of publicly visible licenses. Reserved for Google's use.",
    )
    source_image_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceImageEncryptionKey",
        description="The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.",
    )
    disk_name: Optional[str] = Field(
        None,
        alias="diskName",
        description="Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.",
    )
    disk_size_gb: Optional[str] = Field(
        None,
        alias="diskSizeGb",
        description="Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.",
    )
    source_snapshot_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceSnapshotEncryptionKey",
        description="The customer-supplied encryption key of the source snapshot.",
    )
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.",
    )
    source_image: Optional[str] = Field(
        None,
        alias="sourceImage",
        description="The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.",
    )
    on_update_action: Optional[OnUpdateAction] = Field(
        None,
        alias="onUpdateAction",
        description="Specifies which action to take on instance update with this disk. Default is to use the existing disk.",
    )


class ServiceAccount(BaseModel):
    scopes: Optional[List[str]] = Field(
        None,
        description="The list of scopes to be made available for this service account.",
    )
    email: Optional[str] = Field(None, description="Email address of the service account.")


class AdvancedMachineFeatures(BaseModel):
    enable_nested_virtualization: Optional[bool] = Field(
        None,
        alias="enableNestedVirtualization",
        description="Whether to enable nested virtualization or not (default is false).",
    )
    enable_uefi_networking: Optional[bool] = Field(
        None,
        alias="enableUefiNetworking",
        description="Whether to enable UEFI networking for instance creation.",
    )
    threads_per_core: Optional[int] = Field(
        None,
        alias="threadsPerCore",
        description="The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.",
    )


class InstanceTerminationAction(Enum):
    delete = "DELETE"
    instance_termination_action_unspecified = "INSTANCE_TERMINATION_ACTION_UNSPECIFIED"
    stop = "STOP"


class ProvisioningModel(Enum):
    spot = "SPOT"
    standard = "STANDARD"


class OnHostMaintenance(Enum):
    migrate = "MIGRATE"
    terminate = "TERMINATE"


class Operator(Enum):
    in_ = "IN"
    not_in = "NOT_IN"
    operator_unspecified = "OPERATOR_UNSPECIFIED"


class SchedulingNodeAffinity(BaseModel):
    key: Optional[str] = Field(None, description="Corresponds to the label key of Node resource.")
    operator: Optional[Operator] = Field(
        None,
        description="Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.",
    )
    values: Optional[List[str]] = Field(
        None, description="Corresponds to the label values of Node resource."
    )


class Ipv6AccessType(Enum):
    external = "EXTERNAL"
    internal = "INTERNAL"


class NicType(Enum):
    gvnic = "GVNIC"
    unspecified_nic_type = "UNSPECIFIED_NIC_TYPE"
    virtio_net = "VIRTIO_NET"


class StackType(Enum):
    ipv4_ipv6 = "IPV4_IPV6"
    ipv4_only = "IPV4_ONLY"


class NetworkTier(Enum):
    fixed_standard = "FIXED_STANDARD"
    premium = "PREMIUM"
    standard = "STANDARD"
    standard_overrides_fixed_standard = "STANDARD_OVERRIDES_FIXED_STANDARD"


class Type3(Enum):
    direct_ipv6 = "DIRECT_IPV6"
    one_to_one_nat = "ONE_TO_ONE_NAT"


class AccessConfig(BaseModel):
    external_ipv6_prefix_length: Optional[int] = Field(
        None,
        alias="externalIpv6PrefixLength",
        description="The prefix length of the external IPv6 range.",
    )
    public_ptr_domain_name: Optional[str] = Field(
        None,
        alias="publicPtrDomainName",
        description="The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be createc for first IP in associated external IPv6 range.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.",
    )
    external_ipv6: Optional[str] = Field(
        None,
        alias="externalIpv6",
        description="The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.",
    )
    set_public_ptr: Optional[bool] = Field(
        None,
        alias="setPublicPtr",
        description="Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.",
    )
    network_tier: Optional[NetworkTier] = Field(
        None,
        alias="networkTier",
        description="This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.",
    )
    type: Optional[Type3] = Field(
        "ONE_TO_ONE_NAT",
        description="The type of configuration. The default and only option is ONE_TO_ONE_NAT.",
    )
    kind: Optional[str] = Field(
        "compute#accessConfig",
        description="[Output Only] Type of the resource. Always compute#accessConfig for access configs.",
    )
    nat_ip: Optional[str] = Field(
        None,
        alias="natIP",
        description="An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.",
    )


class AliasIpRange(BaseModel):
    subnetwork_range_name: Optional[str] = Field(
        None,
        alias="subnetworkRangeName",
        description="The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.",
    )
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).",
    )


class ConsumeReservationType(Enum):
    any_reservation = "ANY_RESERVATION"
    no_reservation = "NO_RESERVATION"
    specific_reservation = "SPECIFIC_RESERVATION"
    unspecified = "UNSPECIFIED"


class ReservationAffinity(BaseModel):
    consume_reservation_type: Optional[ConsumeReservationType] = Field(
        None,
        alias="consumeReservationType",
        description="Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='Corresponds to the label values of a reservation resource. This can be either a name to a reservation in the same project or "projects/different-project/reservations/some-reservation-name" to target a shared reservation in the same zone but in a different project.',
    )
    key: Optional[str] = Field(
        None,
        description="Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.",
    )


class LocationPresence(Enum):
    global_ = "GLOBAL"
    local_region = "LOCAL_REGION"
    lp_global = "LP_GLOBAL"
    lp_local_region = "LP_LOCAL_REGION"


class InterconnectLocationRegionInfo(BaseModel):
    location_presence: Optional[LocationPresence] = Field(
        None,
        alias="locationPresence",
        description="Identifies the network presence of this location.",
    )
    region: Optional[str] = Field(None, description="URL for the region of this location.")
    expected_rtt_ms: Optional[str] = Field(
        None,
        alias="expectedRttMs",
        description="Expected round-trip time in milliseconds, from this InterconnectLocation to a VM in this region.",
    )


class Status1(Enum):
    applying = "APPLYING"
    deleting = "DELETING"
    effective = "EFFECTIVE"
    none = "NONE"
    unapplied = "UNAPPLIED"
    unapplied_deletion = "UNAPPLIED_DELETION"


class AutoDelete(Enum):
    never = "NEVER"
    on_permanent_instance_deletion = "ON_PERMANENT_INSTANCE_DELETION"


class PreservedStatePreservedDisk(BaseModel):
    source: Optional[str] = Field(
        None,
        description="The URL of the disk resource that is stateful and should be attached to the VM instance.",
    )
    auto_delete: Optional[AutoDelete] = Field(
        None,
        alias="autoDelete",
        description="These stateful disks will never be deleted during autohealing, update, instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole MIG is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.",
    )
    mode: Optional[Mode] = Field(
        None,
        description="The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.",
    )


class IssueType(Enum):
    it_outage = "IT_OUTAGE"
    it_partial_outage = "IT_PARTIAL_OUTAGE"
    outage = "OUTAGE"
    partial_outage = "PARTIAL_OUTAGE"


class State1(Enum):
    active = "ACTIVE"
    cancelled = "CANCELLED"
    completed = "COMPLETED"
    ns_active = "NS_ACTIVE"
    ns_canceled = "NS_CANCELED"


class Source(Enum):
    google = "GOOGLE"
    nsrc_google = "NSRC_GOOGLE"


class InterconnectOutageNotification(BaseModel):
    affected_circuits: Optional[List[str]] = Field(
        None,
        alias="affectedCircuits",
        description="If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.",
    )
    issue_type: Optional[IssueType] = Field(
        None,
        alias="issueType",
        description='Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.',
    )
    state: Optional[State1] = Field(
        None,
        description='State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.',
    )
    end_time: Optional[str] = Field(
        None,
        alias="endTime",
        description="Scheduled end time for the outage (milliseconds since Unix epoch).",
    )
    description: Optional[str] = Field(
        None, description="A description about the purpose of the outage."
    )
    name: Optional[str] = Field(None, description="Unique identifier for this outage notification.")
    source: Optional[Source] = Field(
        None,
        description="The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="Scheduled start time for the outage (milliseconds since Unix epoch).",
    )


class Type4(Enum):
    cloud_armor = "CLOUD_ARMOR"
    cloud_armor_edge = "CLOUD_ARMOR_EDGE"
    cloud_armor_network = "CLOUD_ARMOR_NETWORK"


class SecurityPolicyRecaptchaOptionsConfig(BaseModel):
    redirect_site_key: Optional[str] = Field(
        None,
        alias="redirectSiteKey",
        description="An optional field to supply a reCAPTCHA site key to be used for all the rules using the redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the specified site key. If not specified, a Google-managed site key is used.",
    )


class RuleVisibility(Enum):
    premium = "PREMIUM"
    standard = "STANDARD"


class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig(BaseModel):
    rule_visibility: Optional[RuleVisibility] = Field(
        None,
        alias="ruleVisibility",
        description="Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.",
    )
    enable: Optional[bool] = Field(
        None, description="If set to true, enables CAAP for L7 DDoS detection."
    )


class JsonParsing(Enum):
    disabled = "DISABLED"
    standard = "STANDARD"


class LogLevel(Enum):
    normal = "NORMAL"
    verbose = "VERBOSE"


class SecurityPolicyAdvancedOptionsConfig(BaseModel):
    json_parsing: Optional[JsonParsing] = Field(None, alias="jsonParsing")
    log_level: Optional[LogLevel] = Field(None, alias="logLevel")


class DdosProtection(Enum):
    advanced = "ADVANCED"
    standard = "STANDARD"


class SecurityPolicyDdosProtectionConfig(BaseModel):
    ddos_protection: Optional[DdosProtection] = Field(None, alias="ddosProtection")


class VersionedExpr(Enum):
    src_ips_v1 = "SRC_IPS_V1"


class Expr(BaseModel):
    expression: Optional[str] = Field(
        None,
        description="Textual representation of an expression in Common Expression Language syntax.",
    )
    location: Optional[str] = Field(
        None,
        description="Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.",
    )
    description: Optional[str] = Field(
        None,
        description="Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.",
    )
    title: Optional[str] = Field(
        None,
        description="Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.",
    )


class SecurityPolicyRuleMatcherConfig(BaseModel):
    src_ip_ranges: Optional[List[str]] = Field(
        None,
        alias="srcIpRanges",
        description="CIDR IP address range. Maximum number of src_ip_ranges allowed is 10.",
    )


class Type5(Enum):
    external_302 = "EXTERNAL_302"
    google_recaptcha = "GOOGLE_RECAPTCHA"


class SecurityPolicyRuleRedirectOptions(BaseModel):
    target: Optional[str] = Field(
        None,
        description="Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.",
    )
    type: Optional[Type5] = Field(None, description="Type of the redirect action.")


class SecurityPolicyRuleHttpHeaderActionHttpHeaderOption(BaseModel):
    header_name: Optional[str] = Field(
        None, alias="headerName", description="The name of the header to set."
    )
    header_value: Optional[str] = Field(
        None, alias="headerValue", description="The value to set the named header to."
    )


class EnforceOnKey(Enum):
    all = "ALL"
    http_cookie = "HTTP_COOKIE"
    http_header = "HTTP_HEADER"
    ip = "IP"
    xff_ip = "XFF_IP"


class SecurityPolicyRuleRateLimitOptionsThreshold(BaseModel):
    count: Optional[int] = Field(
        None, description="Number of HTTP(S) requests for calculating the threshold."
    )
    interval_sec: Optional[int] = Field(
        None,
        alias="intervalSec",
        description="Interval over which the threshold is computed.",
    )


class ExternalVpnGatewayInterface(BaseModel):
    id: Optional[int] = Field(
        None,
        description="The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3 ",
    )
    ip_address: Optional[str] = Field(
        None,
        alias="ipAddress",
        description="IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.",
    )


class Duration(BaseModel):
    nanos: Optional[int] = Field(
        None,
        description="Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.",
    )
    seconds: Optional[str] = Field(
        None,
        description="Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years",
    )


class HttpFaultAbort(BaseModel):
    http_status: Optional[int] = Field(
        None,
        alias="httpStatus",
        description="The HTTP status code used to abort the request. The value must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.",
    )
    percentage: Optional[float] = Field(
        None,
        description="The percentage of traffic for connections, operations, or requests that is aborted as part of fault injection. The value must be from 0.0 to 100.0 inclusive.",
    )


class Datum3(Datum2):
    pass


class Warning3(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum3]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Reference(BaseModel):
    reference_type: Optional[str] = Field(
        None,
        alias="referenceType",
        description="A description of the reference type with no implied semantics. Possible values include: 1. MEMBER_OF ",
    )
    kind: Optional[str] = Field(
        "compute#reference",
        description="[Output Only] Type of the resource. Always compute#reference for references.",
    )
    target: Optional[str] = Field(
        None, description="URL of the resource to which this reference points."
    )
    referrer: Optional[str] = Field(
        None, description="URL of the resource which refers to the target."
    )


class Datum4(Datum2):
    pass


class Warning4(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum4]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class State2(Enum):
    active = "ACTIVE"
    deleted = "DELETED"
    deprecated = "DEPRECATED"
    obsolete = "OBSOLETE"


class DeprecationStatus(BaseModel):
    obsolete: Optional[str] = Field(
        None,
        description="An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.",
    )
    replacement: Optional[str] = Field(
        None,
        description="The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.",
    )
    deleted: Optional[str] = Field(
        None,
        description="An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.",
    )
    state: Optional[State2] = Field(
        None,
        description="The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.",
    )
    deprecated: Optional[str] = Field(
        None,
        description="An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.",
    )


class Datum5(Datum2):
    pass


class Warning5(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum5]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class RouteStatus(Enum):
    active = "ACTIVE"
    dropped = "DROPPED"
    inactive = "INACTIVE"
    pending = "PENDING"


class RouteType(Enum):
    bgp = "BGP"
    static = "STATIC"
    subnet = "SUBNET"
    transit = "TRANSIT"


class PathSegmentType(Enum):
    as_confed_sequence = "AS_CONFED_SEQUENCE"
    as_confed_set = "AS_CONFED_SET"
    as_sequence = "AS_SEQUENCE"
    as_set = "AS_SET"


class RouteAsPath(BaseModel):
    path_segment_type: Optional[PathSegmentType] = Field(
        None,
        alias="pathSegmentType",
        description="[Output Only] The type of the AS Path, which can be one of the following values: - 'AS_SET': unordered set of autonomous systems that the route in has traversed - 'AS_SEQUENCE': ordered set of autonomous systems that the route has traversed - 'AS_CONFED_SEQUENCE': ordered set of Member Autonomous Systems in the local confederation that the route has traversed - 'AS_CONFED_SET': unordered set of Member Autonomous Systems in the local confederation that the route has traversed ",
    )
    as_lists: Optional[List[int]] = Field(
        None,
        alias="asLists",
        description="[Output Only] The AS numbers of the AS Path.",
    )


class ShieldedInstanceIdentityEntry(BaseModel):
    ek_pub: Optional[str] = Field(None, alias="ekPub", description="A PEM-encoded public key.")
    ek_cert: Optional[str] = Field(
        None,
        alias="ekCert",
        description="A PEM-encoded X.509 certificate. This field can be empty.",
    )


class HealthCheckServiceReference(BaseModel):
    health_check_service: Optional[str] = Field(None, alias="healthCheckService")


class HealthCheckReference(BaseModel):
    health_check: Optional[str] = Field(None, alias="healthCheck")


class Datum6(Datum2):
    pass


class Warning6(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum6]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class HealthStatusAggregationPolicy(Enum):
    and_ = "AND"
    no_aggregation = "NO_AGGREGATION"


class HealthCheckService(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    network_endpoint_groups: Optional[List[str]] = Field(
        None,
        alias="networkEndpointGroups",
        description="A list of URLs to the NetworkEndpointGroup resources. Must not have more than 100. For regional HealthCheckService, NEGs must be in zones in the region of the HealthCheckService.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthCheckService. An up-to-date fingerprint must be provided in order to patch/update the HealthCheckService; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthCheckService.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the health check service resides. This field is not applicable to global health check services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    health_checks: Optional[List[str]] = Field(
        None,
        alias="healthChecks",
        description="A list of URLs to the HealthCheck resources. Must have at least one HealthCheck, and not more than 10. HealthCheck resources must have portSpecification=USE_SERVING_PORT or portSpecification=USE_FIXED_PORT. For regional HealthCheckService, the HealthCheck must be regional and in the same region. For global HealthCheckService, HealthCheck must be global. Mix of regional and global HealthChecks is not supported. Multiple regional HealthChecks must belong to the same region. Regional HealthChecks must belong to the same region as zones of NEGs.",
    )
    notification_endpoints: Optional[List[str]] = Field(
        None,
        alias="notificationEndpoints",
        description="A list of URLs to the NotificationEndpoint resources. Must not have more than 10. A list of endpoints for receiving notifications of change in health status. For regional HealthCheckService, NotificationEndpoint must be regional and in the same region. For global HealthCheckService, NotificationEndpoint must be global.",
    )
    kind: Optional[str] = Field(
        "compute#healthCheckService",
        description="[Output only] Type of the resource. Always compute#healthCheckServicefor health check services.",
    )
    health_status_aggregation_policy: Optional[HealthStatusAggregationPolicy] = Field(
        None,
        alias="healthStatusAggregationPolicy",
        description="Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. .",
    )


class Datum7(Datum2):
    pass


class Warning7(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum7]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class NamedPort(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.",
    )
    port: Optional[int] = Field(
        None, description="The port number, which can be a value between 1 and 65535."
    )


class CorsPolicy(BaseModel):
    allow_origins: Optional[List[str]] = Field(
        None,
        alias="allowOrigins",
        description="Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.",
    )
    allow_credentials: Optional[bool] = Field(
        None,
        alias="allowCredentials",
        description="In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.",
    )
    disabled: Optional[bool] = Field(
        None,
        description="If true, the setting specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.",
    )
    max_age: Optional[int] = Field(
        None,
        alias="maxAge",
        description="Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.",
    )
    allow_origin_regexes: Optional[List[str]] = Field(
        None,
        alias="allowOriginRegexes",
        description="Specifies a regular expression that matches allowed origins. For more information about the regular expression syntax, see Syntax. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.",
    )
    expose_headers: Optional[List[str]] = Field(
        None,
        alias="exposeHeaders",
        description="Specifies the content for the Access-Control-Expose-Headers header.",
    )
    allow_methods: Optional[List[str]] = Field(
        None,
        alias="allowMethods",
        description="Specifies the content for the Access-Control-Allow-Methods header.",
    )
    allow_headers: Optional[List[str]] = Field(
        None,
        alias="allowHeaders",
        description="Specifies the content for the Access-Control-Allow-Headers header.",
    )


class LoadBalancingScheme(Enum):
    external = "EXTERNAL"
    external_managed = "EXTERNAL_MANAGED"
    load_balancing_scheme_unspecified = "LOAD_BALANCING_SCHEME_UNSPECIFIED"


class UrlMapTestHeader(BaseModel):
    value: Optional[str] = Field(None, description="Header value.")
    name: Optional[str] = Field(None, description="Header name.")


class HttpHeaderOption(BaseModel):
    replace: Optional[bool] = Field(
        None,
        description="If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is false. ",
    )
    header_value: Optional[str] = Field(
        None, alias="headerValue", description="The value of the header to add."
    )
    header_name: Optional[str] = Field(
        None, alias="headerName", description="The name of the header."
    )


class UrlRewrite(BaseModel):
    host_rewrite: Optional[str] = Field(
        None,
        alias="hostRewrite",
        description="Before forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite. The value must be from 1 to 255 characters.",
    )
    path_prefix_rewrite: Optional[str] = Field(
        None,
        alias="pathPrefixRewrite",
        description="Before forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite. The value must be from 1 to 1024 characters.",
    )


class RequestMirrorPolicy(BaseModel):
    backend_service: Optional[str] = Field(
        None,
        alias="backendService",
        description="The full or partial URL to the BackendService resource being mirrored to.",
    )


class HttpRetryPolicy(BaseModel):
    num_retries: Optional[int] = Field(
        None,
        alias="numRetries",
        description="Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.",
    )
    per_try_timeout: Optional[Duration] = Field(
        None,
        alias="perTryTimeout",
        description="Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.",
    )
    retry_conditions: Optional[List[str]] = Field(
        None,
        alias="retryConditions",
        description="Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable ",
    )


class RedirectResponseCode(Enum):
    found = "FOUND"
    moved_permanently_default = "MOVED_PERMANENTLY_DEFAULT"
    permanent_redirect = "PERMANENT_REDIRECT"
    see_other = "SEE_OTHER"
    temporary_redirect = "TEMPORARY_REDIRECT"


class HttpRedirectAction(BaseModel):
    path_redirect: Optional[str] = Field(
        None,
        alias="pathRedirect",
        description="The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.",
    )
    redirect_response_code: Optional[RedirectResponseCode] = Field(
        None,
        alias="redirectResponseCode",
        description="The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained. ",
    )
    strip_query: Optional[bool] = Field(
        None,
        alias="stripQuery",
        description="If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false. ",
    )
    prefix_redirect: Optional[str] = Field(
        None,
        alias="prefixRedirect",
        description="The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.",
    )
    host_redirect: Optional[str] = Field(
        None,
        alias="hostRedirect",
        description="The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.",
    )
    https_redirect: Optional[bool] = Field(
        None,
        alias="httpsRedirect",
        description="If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.",
    )


class HttpQueryParameterMatch(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.",
    )
    regex_match: Optional[str] = Field(
        None,
        alias="regexMatch",
        description="The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For more information about regular expression syntax, see Syntax. Only one of presentMatch, exactMatch, or regexMatch must be set. regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED. ",
    )
    exact_match: Optional[str] = Field(
        None,
        alias="exactMatch",
        description="The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set. ",
    )
    present_match: Optional[bool] = Field(
        None,
        alias="presentMatch",
        description="Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch, or regexMatch must be set. ",
    )


class FilterMatchCriteria(Enum):
    match_all = "MATCH_ALL"
    match_any = "MATCH_ANY"
    not_set = "NOT_SET"


class MetadataFilterLabelMatch(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of metadata label. The name can have a maximum length of 1024 characters and must be at least 1 character long.",
    )
    value: Optional[str] = Field(
        None,
        description="The value of the label must match the specified value. value can have a maximum length of 1024 characters.",
    )


class Int64RangeMatch(BaseModel):
    range_start: Optional[str] = Field(
        None,
        alias="rangeStart",
        description="The start of the range (inclusive) in signed long integer format.",
    )
    range_end: Optional[str] = Field(
        None,
        alias="rangeEnd",
        description="The end of the range (exclusive) in signed long integer format.",
    )


class HostRule(BaseModel):
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    path_matcher: Optional[str] = Field(
        None,
        alias="pathMatcher",
        description="The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.",
    )
    hosts: Optional[List[str]] = Field(
        None,
        description="The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character, and if followed by anything, the immediate following character must be either - or .. * based matching is not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.",
    )


class Datum8(Datum):
    pass


class Warning8(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum8]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Status2(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    invalid = "INVALID"
    ready = "READY"


class MaintenancePolicy(Enum):
    default = "DEFAULT"
    maintenance_policy_unspecified = "MAINTENANCE_POLICY_UNSPECIFIED"
    migrate_within_node_group = "MIGRATE_WITHIN_NODE_GROUP"
    restart_in_place = "RESTART_IN_PLACE"


class NodeGroupMaintenanceWindow(BaseModel):
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.",
    )
    maintenance_duration: Optional[Duration] = Field(
        None,
        alias="maintenanceDuration",
        description="[Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.",
    )


class Mode2(Enum):
    mode_unspecified = "MODE_UNSPECIFIED"
    off = "OFF"
    on = "ON"
    only_scale_out = "ONLY_SCALE_OUT"


class NodeGroupAutoscalingPolicy(BaseModel):
    min_nodes: Optional[int] = Field(
        None,
        alias="minNodes",
        description="The minimum number of nodes that the group should have.",
    )
    mode: Optional[Mode2] = Field(
        None,
        description="The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.",
    )
    max_nodes: Optional[int] = Field(
        None,
        alias="maxNodes",
        description="The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.",
    )


class WafExpressionSetExpression(BaseModel):
    id: Optional[str] = Field(
        None,
        description="Expression ID should uniquely identify the origin of the expression. E.g. owasp-crs-v020901-id973337 identifies Owasp core rule set version 2.9.1 rule id 973337. The ID could be used to determine the individual attack definition that has been detected. It could also be used to exclude it from the policy in case of false positive. required",
    )


class Datum9(Datum2):
    pass


class Warning9(BaseModel):
    data: Optional[List[Datum9]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status3(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    expired = "EXPIRED"
    invalid = "INVALID"
    ready = "READY"


class ResourcePolicyResourceStatusInstanceSchedulePolicyStatus(BaseModel):
    next_run_start_time: Optional[str] = Field(
        None,
        alias="nextRunStartTime",
        description="[Output Only] The next time the schedule is planned to run. The actual time might be slightly different. The timestamp is an RFC3339 string.",
    )
    last_run_start_time: Optional[str] = Field(
        None,
        alias="lastRunStartTime",
        description="[Output Only] The last time the schedule successfully ran. The timestamp is an RFC3339 string.",
    )


class ResourcePolicyInstanceSchedulePolicySchedule(BaseModel):
    schedule: Optional[str] = Field(
        None,
        description="Specifies the frequency for the operation, using the unix-cron format.",
    )


class Collocation(Enum):
    collocated = "COLLOCATED"
    unspecified_collocation = "UNSPECIFIED_COLLOCATION"


class ResourcePolicyGroupPlacementPolicy(BaseModel):
    collocation: Optional[Collocation] = Field(None, description="Specifies network collocation")
    availability_domain_count: Optional[int] = Field(
        None,
        alias="availabilityDomainCount",
        description="The number of availability domains to spread instances across. If two instances are in different availability domain, they are not in the same low latency network.",
    )
    vm_count: Optional[int] = Field(
        None,
        alias="vmCount",
        description="Number of VMs in this placement group. Google does not recommend that you use this field unless you use a compact policy and you want your policy to work only if it contains this exact number of VMs.",
    )


class OnSourceDiskDelete(Enum):
    apply_retention_policy = "APPLY_RETENTION_POLICY"
    keep_auto_snapshots = "KEEP_AUTO_SNAPSHOTS"
    unspecified_on_source_disk_delete = "UNSPECIFIED_ON_SOURCE_DISK_DELETE"


class ResourcePolicySnapshotSchedulePolicyRetentionPolicy(BaseModel):
    on_source_disk_delete: Optional[OnSourceDiskDelete] = Field(
        None,
        alias="onSourceDiskDelete",
        description="Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.",
    )
    max_retention_days: Optional[int] = Field(
        None,
        alias="maxRetentionDays",
        description="Maximum age of the snapshot that is allowed to be kept.",
    )


class ResourcePolicyDailyCycle(BaseModel):
    days_in_cycle: Optional[int] = Field(
        None,
        alias="daysInCycle",
        description="Defines a schedule with units measured in days. The value determines how many days pass between the start of each cycle.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.",
    )
    duration: Optional[str] = Field(
        None,
        description="[Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.",
    )


class ResourcePolicyHourlyCycle(BaseModel):
    hours_in_cycle: Optional[int] = Field(
        None,
        alias="hoursInCycle",
        description="Defines a schedule with units measured in hours. The value determines how many hours pass between the start of each cycle.",
    )
    duration: Optional[str] = Field(
        None,
        description="[Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description='Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.',
    )


class Day(Enum):
    friday = "FRIDAY"
    invalid = "INVALID"
    monday = "MONDAY"
    saturday = "SATURDAY"
    sunday = "SUNDAY"
    thursday = "THURSDAY"
    tuesday = "TUESDAY"
    wednesday = "WEDNESDAY"


class ResourcePolicyWeeklyCycleDayOfWeek(BaseModel):
    duration: Optional[str] = Field(
        None,
        description="[Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description='Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.',
    )
    day: Optional[Day] = Field(
        None,
        description="Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.",
    )


class ResourcePolicySnapshotSchedulePolicySnapshotProperties(BaseModel):
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.",
    )
    storage_locations: Optional[List[str]] = Field(
        None,
        alias="storageLocations",
        description="Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).",
    )
    chain_name: Optional[str] = Field(
        None,
        alias="chainName",
        description="Chain name that the snapshot is created in.",
    )
    guest_flush: Optional[bool] = Field(
        None,
        alias="guestFlush",
        description="Indication to perform a 'guest aware' snapshot.",
    )


class InstanceGroupManagerStatusStatefulPerInstanceConfigs(BaseModel):
    all_effective: Optional[bool] = Field(
        None,
        alias="allEffective",
        description="A bit indicating if all of the group's per-instance configurations (listed in the output of a listPerInstanceConfigs API call) have status EFFECTIVE or there are no per-instance-configs.",
    )


class InstanceGroupManagerStatusVersionTarget(BaseModel):
    is_reached: Optional[bool] = Field(
        None,
        alias="isReached",
        description="[Output Only] A bit indicating whether version target has been reached in this managed instance group, i.e. all instances are in their target version. Instances' target version are specified by version field on Instance Group Manager.",
    )


class Datum10(Datum2):
    pass


class Warning10(BaseModel):
    data: Optional[List[Datum10]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status4(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    failed = "FAILED"
    ready = "READY"


class TargetVpnGateway(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    forwarding_rules: Optional[List[str]] = Field(
        None,
        alias="forwardingRules",
        description="[Output Only] A list of URLs to the ForwardingRule resources. ForwardingRules are created using compute.forwardingRules.insert and associated with a VPN gateway.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the target VPN gateway resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    network: Optional[str] = Field(
        None,
        description="URL of the network to which this VPN gateway is attached. Provided by the client when the VPN gateway is created.",
    )
    status: Optional[Status4] = Field(
        None,
        description="[Output Only] The status of the VPN gateway, which can be one of the following: CREATING, READY, FAILED, or DELETING.",
    )
    tunnels: Optional[List[str]] = Field(
        None,
        description="[Output Only] A list of URLs to VpnTunnel resources. VpnTunnels are created using the compute.vpntunnels.insert method and associated with a VPN gateway.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    kind: Optional[str] = Field(
        "compute#targetVpnGateway",
        description="[Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.",
    )


class Datum11(Datum):
    pass


class Warning11(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum11]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum12(Datum):
    pass


class Warning12(BaseModel):
    data: Optional[List[Datum12]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Type6(Enum):
    accelerator_optimized = "ACCELERATOR_OPTIMIZED"
    compute_optimized = "COMPUTE_OPTIMIZED"
    compute_optimized_c2_d = "COMPUTE_OPTIMIZED_C2D"
    general_purpose = "GENERAL_PURPOSE"
    general_purpose_e2 = "GENERAL_PURPOSE_E2"
    general_purpose_n2 = "GENERAL_PURPOSE_N2"
    general_purpose_n2_d = "GENERAL_PURPOSE_N2D"
    general_purpose_t2_d = "GENERAL_PURPOSE_T2D"
    memory_optimized = "MEMORY_OPTIMIZED"
    memory_optimized_m3 = "MEMORY_OPTIMIZED_M3"
    type_unspecified = "TYPE_UNSPECIFIED"


class Status5(Enum):
    active = "ACTIVE"
    creating = "CREATING"
    expired = "EXPIRED"
    not_yet_active = "NOT_YET_ACTIVE"


class Category(Enum):
    category_unspecified = "CATEGORY_UNSPECIFIED"
    license = "LICENSE"
    machine = "MACHINE"


class Plan(Enum):
    invalid = "INVALID"
    thirty_six_month = "THIRTY_SIX_MONTH"
    twelve_month = "TWELVE_MONTH"


class Type7(Enum):
    accelerator = "ACCELERATOR"
    local_ssd = "LOCAL_SSD"
    memory = "MEMORY"
    unspecified = "UNSPECIFIED"
    vcpu = "VCPU"


class ResourceCommitment(BaseModel):
    accelerator_type: Optional[str] = Field(
        None,
        alias="acceleratorType",
        description="Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.",
    )
    amount: Optional[str] = Field(
        None,
        description="The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.",
    )
    type: Optional[Type7] = Field(
        None,
        description="Type of resource for which this commitment applies. Possible values are VCPU and MEMORY",
    )


class LicenseResourceCommitment(BaseModel):
    amount: Optional[str] = Field(None, description="The number of licenses purchased.")
    license: Optional[str] = Field(None, description="Any applicable license URI.")
    cores_per_license: Optional[str] = Field(
        None,
        alias="coresPerLicense",
        description="Specifies the core range of the instance for which this license applies.",
    )


class Status6(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    invalid = "INVALID"
    ready = "READY"
    updating = "UPDATING"


class AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk(BaseModel):
    interface: Optional[Interface] = Field(
        None,
        description="Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.",
    )
    disk_size_gb: Optional[str] = Field(
        None,
        alias="diskSizeGb",
        description="Specifies the size of the disk in base-2 GB.",
    )


class ShareType(Enum):
    local = "LOCAL"
    share_type_unspecified = "SHARE_TYPE_UNSPECIFIED"
    specific_projects = "SPECIFIC_PROJECTS"


class ShareSettingsProjectConfig(BaseModel):
    project_id: Optional[str] = Field(
        None,
        alias="projectId",
        description="The project ID, should be same as the key of this project config in the parent map.",
    )


class Protocol(Enum):
    grpc = "GRPC"
    http = "HTTP"
    http2 = "HTTP2"
    https = "HTTPS"
    ssl = "SSL"
    tcp = "TCP"
    udp = "UDP"
    unspecified = "UNSPECIFIED"


class SessionAffinity(Enum):
    client_ip = "CLIENT_IP"
    client_ip_no_destination = "CLIENT_IP_NO_DESTINATION"
    client_ip_port_proto = "CLIENT_IP_PORT_PROTO"
    client_ip_proto = "CLIENT_IP_PROTO"
    generated_cookie = "GENERATED_COOKIE"
    header_field = "HEADER_FIELD"
    http_cookie = "HTTP_COOKIE"
    none = "NONE"


class LoadBalancingScheme1(Enum):
    external = "EXTERNAL"
    external_managed = "EXTERNAL_MANAGED"
    internal = "INTERNAL"
    internal_managed = "INTERNAL_MANAGED"
    internal_self_managed = "INTERNAL_SELF_MANAGED"
    invalid_load_balancing_scheme = "INVALID_LOAD_BALANCING_SCHEME"


class LocalityLbPolicy(Enum):
    invalid_lb_policy = "INVALID_LB_POLICY"
    least_request = "LEAST_REQUEST"
    maglev = "MAGLEV"
    original_destination = "ORIGINAL_DESTINATION"
    random = "RANDOM"
    ring_hash = "RING_HASH"
    round_robin = "ROUND_ROBIN"


class TrackingMode(Enum):
    invalid_tracking_mode = "INVALID_TRACKING_MODE"
    per_connection = "PER_CONNECTION"
    per_session = "PER_SESSION"


class ConnectionPersistenceOnUnhealthyBackends(Enum):
    always_persist = "ALWAYS_PERSIST"
    default_for_protocol = "DEFAULT_FOR_PROTOCOL"
    never_persist = "NEVER_PERSIST"


class BackendServiceConnectionTrackingPolicy(BaseModel):
    idle_timeout_sec: Optional[int] = Field(
        None,
        alias="idleTimeoutSec",
        description="Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For Internal TCP/UDP Load Balancing: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For Network Load Balancer the default is 60 seconds. This option is not available publicly.",
    )
    tracking_mode: Optional[TrackingMode] = Field(
        None,
        alias="trackingMode",
        description="Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).",
    )
    connection_persistence_on_unhealthy_backends: Optional[
        ConnectionPersistenceOnUnhealthyBackends
    ] = Field(
        None,
        alias="connectionPersistenceOnUnhealthyBackends",
        description="Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).",
    )
    enable_strong_affinity: Optional[bool] = Field(
        None,
        alias="enableStrongAffinity",
        description="Enable Strong Session Affinity for Network Load Balancing. This option is not available publicly.",
    )


class CacheMode(Enum):
    cache_all_static = "CACHE_ALL_STATIC"
    force_cache_all = "FORCE_CACHE_ALL"
    invalid_cache_mode = "INVALID_CACHE_MODE"
    use_origin_headers = "USE_ORIGIN_HEADERS"


class BackendServiceCdnPolicyNegativeCachingPolicy(BaseModel):
    code: Optional[int] = Field(
        None,
        description="The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.",
    )
    ttl: Optional[int] = Field(
        None,
        description="The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.",
    )


class CacheKeyPolicy(BaseModel):
    include_protocol: Optional[bool] = Field(
        None,
        alias="includeProtocol",
        description="If true, http and https requests will be cached separately.",
    )
    query_string_whitelist: Optional[List[str]] = Field(
        None,
        alias="queryStringWhitelist",
        description="Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.",
    )
    include_query_string: Optional[bool] = Field(
        None,
        alias="includeQueryString",
        description="If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.",
    )
    include_http_headers: Optional[List[str]] = Field(
        None,
        alias="includeHttpHeaders",
        description="Allows HTTP request headers (by name) to be used in the cache key.",
    )
    include_host: Optional[bool] = Field(
        None,
        alias="includeHost",
        description="If true, requests to different hosts will be cached separately.",
    )
    include_named_cookies: Optional[List[str]] = Field(
        None,
        alias="includeNamedCookies",
        description="Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.",
    )
    query_string_blacklist: Optional[List[str]] = Field(
        None,
        alias="queryStringBlacklist",
        description="Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.",
    )


class BackendServiceCdnPolicyBypassCacheOnRequestHeader(BaseModel):
    header_name: Optional[str] = Field(
        None,
        alias="headerName",
        description="The header field name to match on when bypassing cache. Values are case-insensitive.",
    )


class CircuitBreakers(BaseModel):
    max_pending_requests: Optional[int] = Field(
        None,
        alias="maxPendingRequests",
        description="The maximum number of pending requests allowed to the backend service. If not specified, there is no limit. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    max_requests_per_connection: Optional[int] = Field(
        None,
        alias="maxRequestsPerConnection",
        description="Maximum requests for a single connection to the backend service. This parameter is respected by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this parameter to 1 will effectively disable keep alive. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    max_retries: Optional[int] = Field(
        None,
        alias="maxRetries",
        description="The maximum number of parallel retries allowed to the backend cluster. If not specified, the default is 1. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    max_requests: Optional[int] = Field(
        None,
        alias="maxRequests",
        description="The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.",
    )
    max_connections: Optional[int] = Field(
        None,
        alias="maxConnections",
        description="The maximum number of connections to the backend service. If not specified, there is no limit. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )


class BalancingMode(Enum):
    connection = "CONNECTION"
    rate = "RATE"
    utilization = "UTILIZATION"


class Backend(BaseModel):
    failover: Optional[bool] = Field(
        None,
        description="This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.",
    )
    max_connections_per_endpoint: Optional[int] = Field(
        None,
        alias="maxConnectionsPerEndpoint",
        description="Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.",
    )
    max_rate_per_instance: Optional[float] = Field(
        None,
        alias="maxRatePerInstance",
        description="Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.",
    )
    capacity_scaler: Optional[float] = Field(
        None,
        alias="capacityScaler",
        description="A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.",
    )
    max_connections_per_instance: Optional[int] = Field(
        None,
        alias="maxConnectionsPerInstance",
        description="Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.",
    )
    max_rate: Optional[int] = Field(
        None,
        alias="maxRate",
        description="Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.",
    )
    max_connections: Optional[int] = Field(
        None,
        alias="maxConnections",
        description="Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.",
    )
    max_utilization: Optional[float] = Field(
        None,
        alias="maxUtilization",
        description="Optional parameter to define a target capacity for the UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    max_rate_per_endpoint: Optional[float] = Field(
        None,
        alias="maxRatePerEndpoint",
        description="Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.",
    )
    group: Optional[str] = Field(
        None,
        description="The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.",
    )
    balancing_mode: Optional[BalancingMode] = Field(
        None,
        alias="balancingMode",
        description="Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.",
    )


class BackendServiceFailoverPolicy(BaseModel):
    disable_connection_drain_on_failover: Optional[bool] = Field(
        None,
        alias="disableConnectionDrainOnFailover",
        description="This can be set to true only if the protocol is TCP. The default is false.",
    )
    drop_traffic_if_unhealthy: Optional[bool] = Field(
        None,
        alias="dropTrafficIfUnhealthy",
        description="If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.",
    )
    failover_ratio: Optional[float] = Field(
        None,
        alias="failoverRatio",
        description="The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).",
    )


class Policy(Enum):
    consistent_hash_subsetting = "CONSISTENT_HASH_SUBSETTING"
    none = "NONE"


class Subsetting(BaseModel):
    policy: Optional[Policy] = None


class OutlierDetection(BaseModel):
    consecutive_errors: Optional[int] = Field(
        None,
        alias="consecutiveErrors",
        description="Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.",
    )
    success_rate_request_volume: Optional[int] = Field(
        None,
        alias="successRateRequestVolume",
        description="The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.",
    )
    enforcing_consecutive_errors: Optional[int] = Field(
        None,
        alias="enforcingConsecutiveErrors",
        description="The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.",
    )
    base_ejection_time: Optional[Duration] = Field(
        None,
        alias="baseEjectionTime",
        description="The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.",
    )
    max_ejection_percent: Optional[int] = Field(
        None,
        alias="maxEjectionPercent",
        description="Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.",
    )
    enforcing_consecutive_gateway_failure: Optional[int] = Field(
        None,
        alias="enforcingConsecutiveGatewayFailure",
        description="The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.",
    )
    consecutive_gateway_failure: Optional[int] = Field(
        None,
        alias="consecutiveGatewayFailure",
        description="The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.",
    )
    enforcing_success_rate: Optional[int] = Field(
        None,
        alias="enforcingSuccessRate",
        description="The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.",
    )
    success_rate_stdev_factor: Optional[int] = Field(
        None,
        alias="successRateStdevFactor",
        description="This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.",
    )
    interval: Optional[Duration] = Field(
        None,
        description="Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.",
    )
    success_rate_minimum_hosts: Optional[int] = Field(
        None,
        alias="successRateMinimumHosts",
        description="The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.",
    )


class BackendServiceLogConfig(BaseModel):
    enable: Optional[bool] = Field(
        None,
        description="This field denotes whether to enable logging for the load balancer traffic served by this backend service.",
    )
    sample_rate: Optional[float] = Field(
        None,
        alias="sampleRate",
        description="This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.",
    )


class BackendServiceIap(BaseModel):
    oauth2_client_id: Optional[str] = Field(
        None,
        alias="oauth2ClientId",
        description="OAuth2 client ID to use for the authentication flow.",
    )
    enabled: Optional[bool] = Field(
        None,
        description="Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.",
    )
    oauth2_client_secret_sha256: Optional[str] = Field(
        None,
        alias="oauth2ClientSecretSha256",
        description="[Output Only] SHA256 hash value for the field oauth2_client_secret above.",
    )
    oauth2_client_secret: Optional[str] = Field(
        None,
        alias="oauth2ClientSecret",
        description="OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly",
    )


class SecuritySettings(BaseModel):
    subject_alt_names: Optional[List[str]] = Field(
        None,
        alias="subjectAltNames",
        description="Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service. Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities. Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode). Note: This field currently has no impact.",
    )
    client_tls_policy: Optional[str] = Field(
        None,
        alias="clientTlsPolicy",
        description="Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends. clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank, communications are not encrypted. Note: This field currently has no impact.",
    )


class BackendServiceLocalityLoadBalancingPolicyConfigPolicy(BaseModel):
    name: Optional[LocalityLbPolicy] = Field(
        None,
        description="The name of a locality load balancer policy to be used. The value should be one of the predefined ones as supported by localityLbPolicy, although at the moment only ROUND_ROBIN is supported. This field should only be populated when the customPolicy field is not used. Note that specifying the same policy more than once for a backend is not a valid configuration and will be rejected.",
    )


class BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Identifies the custom policy. The value should match the type the custom implementation is registered with on the gRPC clients. It should follow protocol buffer message naming conventions and include the full path (e.g. myorg.CustomLbPolicy). The maximum length is 256 characters. Note that specifying the same custom policy more than once for a backend is not a valid configuration and will be rejected.",
    )
    data: Optional[str] = Field(
        None,
        description="An optional, arbitrary JSON object with configuration data, understood by a locally installed custom policy implementation.",
    )


class ConnectionDraining(BaseModel):
    draining_timeout_sec: Optional[int] = Field(
        None,
        alias="drainingTimeoutSec",
        description="Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.",
    )


class ConsistentHashLoadBalancerSettingsHttpCookie(BaseModel):
    ttl: Optional[Duration] = Field(None, description="Lifetime of the cookie.")
    name: Optional[str] = Field(None, description="Name of the cookie.")
    path: Optional[str] = Field(None, description="Path to set for the cookie.")


class Datum13(Datum):
    pass


class Warning13(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum13]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Status7(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    failed = "FAILED"
    ready = "READY"
    restoring = "RESTORING"


class Disk(BaseModel):
    source_snapshot_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceSnapshotEncryptionKey",
        description="The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.",
    )
    physical_block_size_bytes: Optional[str] = Field(
        None,
        alias="physicalBlockSizeBytes",
        description="Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.",
    )
    kind: Optional[str] = Field(
        "compute#disk",
        description="[Output Only] Type of the resource. Always compute#disk for disks.",
    )
    source_disk_id: Optional[str] = Field(
        None,
        alias="sourceDiskId",
        description="[Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined fully-qualified URL for this resource.",
    )
    source_image: Optional[str] = Field(
        None,
        alias="sourceImage",
        description="The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family ",
    )
    size_gb: Optional[str] = Field(
        None,
        alias="sizeGb",
        description="Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.",
    )
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies applied to this disk for automatic snapshot creations.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    source_storage_object: Optional[str] = Field(
        None,
        alias="sourceStorageObject",
        description="The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.",
    )
    licenses: Optional[List[str]] = Field(
        None,
        description="A list of publicly visible licenses. Reserved for Google's use.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to this disk. These can be later modified by the setLabels method.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="diskEncryptionKey",
        description='Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don\'t need to provide a key to use the disk later.',
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    status: Optional[Status7] = Field(
        None,
        description="[Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting. ",
    )
    options: Optional[str] = Field(None, description="Internal use only.")
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    location_hint: Optional[str] = Field(
        None,
        alias="locationHint",
        description="An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.",
    )
    source_image_id: Optional[str] = Field(
        None,
        alias="sourceImageId",
        description="[Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    license_codes: Optional[List[str]] = Field(
        None,
        alias="licenseCodes",
        description="Integer license codes indicating which licenses are attached to this disk.",
    )
    replica_zones: Optional[List[str]] = Field(
        None,
        alias="replicaZones",
        description="URLs of the zones where the disk should be replicated to. Only applicable for regional resources.",
    )
    source_image_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceImageEncryptionKey",
        description="The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    last_attach_timestamp: Optional[str] = Field(
        None,
        alias="lastAttachTimestamp",
        description="[Output Only] Last attach timestamp in RFC3339 text format.",
    )
    last_detach_timestamp: Optional[str] = Field(
        None,
        alias="lastDetachTimestamp",
        description="[Output Only] Last detach timestamp in RFC3339 text format.",
    )
    source_snapshot: Optional[str] = Field(
        None,
        alias="sourceSnapshot",
        description="The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot ",
    )
    provisioned_iops: Optional[str] = Field(
        None,
        alias="provisionedIops",
        description="Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.",
    )
    type: Optional[str] = Field(
        None,
        description="URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.",
    )
    source_snapshot_id: Optional[str] = Field(
        None,
        alias="sourceSnapshotId",
        description="[Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.",
    )
    users: Optional[List[str]] = Field(
        None,
        description="[Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance",
    )
    guest_os_features: Optional[List[GuestOsFeature]] = Field(
        None,
        alias="guestOsFeatures",
        description="A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.",
    )
    source_disk: Optional[str] = Field(
        None,
        alias="sourceDisk",
        description="The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk ",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.",
    )


class Datum14(Datum):
    pass


class Warning14(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum14]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Status8(Enum):
    deprovisioning = "DEPROVISIONING"
    provisioning = "PROVISIONING"
    repairing = "REPAIRING"
    running = "RUNNING"
    staging = "STAGING"
    stopped = "STOPPED"
    stopping = "STOPPING"
    suspended = "SUSPENDED"
    suspending = "SUSPENDING"
    terminated = "TERMINATED"


class InstanceParams(BaseModel):
    resource_manager_tags: Optional[Dict[str, str]] = Field(
        None,
        alias="resourceManagerTags",
        description="Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.",
    )


class DisplayDevice(BaseModel):
    enable_display: Optional[bool] = Field(
        None,
        alias="enableDisplay",
        description="Defines whether the instance has Display enabled.",
    )


class ShieldedInstanceIntegrityPolicy(BaseModel):
    update_auto_learn_policy: Optional[bool] = Field(
        None,
        alias="updateAutoLearnPolicy",
        description="Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.",
    )


class InstancesSetServiceAccountRequest(BaseModel):
    email: Optional[str] = Field(None, description="Email address of the service account.")
    scopes: Optional[List[str]] = Field(
        None,
        description="The list of scopes to be made available for this service account.",
    )


class NetworkEndpointType(Enum):
    gce_vm_ip = "GCE_VM_IP"
    gce_vm_ip_port = "GCE_VM_IP_PORT"
    internet_fqdn_port = "INTERNET_FQDN_PORT"
    internet_ip_port = "INTERNET_IP_PORT"
    non_gcp_private_ip_port = "NON_GCP_PRIVATE_IP_PORT"
    private_service_connect = "PRIVATE_SERVICE_CONNECT"
    serverless = "SERVERLESS"


class NetworkEndpointGroupCloudFunction(BaseModel):
    url_mask: Optional[str] = Field(
        None,
        alias="urlMask",
        description='A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services. For example, request URLs " mydomain.com/function1" and "mydomain.com/function2" can be backed by the same Serverless NEG with URL mask "/". The URL mask will parse them to { function = "function1" } and { function = "function2" } respectively.',
    )
    function: Optional[str] = Field(
        None,
        description='A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".',
    )


class NetworkEndpointGroupCloudRun(BaseModel):
    url_mask: Optional[str] = Field(
        None,
        alias="urlMask",
        description='A template to parse <service> and <tag> fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services. For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2" can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask "<tag>.domain.com/<service>". The URL mask will parse them to { service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.',
    )
    service: Optional[str] = Field(
        None,
        description='Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long, and comply with RFC1035. Example value: "run-service".',
    )
    tag: Optional[str] = Field(
        None,
        description='Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035. Example value: "revision-0010".',
    )


class NetworkEndpointGroupAppEngine(BaseModel):
    version: Optional[str] = Field(
        None,
        description='Optional serving version. The version name is case-sensitive and must be 1-100 characters long. Example value: "v1", "v2".',
    )
    service: Optional[str] = Field(
        None,
        description='Optional serving service. The service name is case-sensitive and must be 1-63 characters long. Example value: "default", "my-service".',
    )
    url_mask: Optional[str] = Field(
        None,
        alias="urlMask",
        description='A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services. For example, the request URLs "foo1-dot-appname.appspot.com/v1" and "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with URL mask "-dot-appname.appspot.com/". The URL mask will parse them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.',
    )


class ProxyHeader(Enum):
    none = "NONE"
    proxy_v1 = "PROXY_V1"


class TargetSslProxiesSetProxyHeaderRequest(BaseModel):
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.",
    )


class DiskMoveRequest(BaseModel):
    destination_zone: Optional[str] = Field(
        None,
        alias="destinationZone",
        description="The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - https://www.googleapis.com/compute/v1/projects/project/zones/zone - projects/project/zones/zone - zones/zone ",
    )
    target_disk: Optional[str] = Field(
        None,
        alias="targetDisk",
        description="The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk ",
    )


class Datum15(Datum2):
    pass


class Warning15(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum15]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum16(Datum):
    pass


class Warning16(BaseModel):
    data: Optional[List[Datum16]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum17(Datum):
    pass


class Warning17(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum17]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum18(Datum2):
    pass


class Warning18(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum18]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class HttpsHealthCheck(BaseModel):
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    request_path: Optional[str] = Field(
        None,
        alias="requestPath",
        description='The request path of the HTTPS health check request. The default value is "/".',
    )
    timeout_sec: Optional[int] = Field(
        None,
        alias="timeoutSec",
        description="How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have a greater value than checkIntervalSec.",
    )
    check_interval_sec: Optional[int] = Field(
        None,
        alias="checkIntervalSec",
        description="How often (in seconds) to send a health check. The default value is 5 seconds.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    kind: Optional[str] = Field("compute#httpsHealthCheck", description="Type of the resource.")
    unhealthy_threshold: Optional[int] = Field(
        None,
        alias="unhealthyThreshold",
        description="A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.",
    )
    healthy_threshold: Optional[int] = Field(
        None,
        alias="healthyThreshold",
        description="A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the HTTPS health check request. The default value is 443.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    host: Optional[str] = Field(
        None,
        description="The value of the host header in the HTTPS health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.",
    )


class UnsatisfiedReason(Enum):
    incomplete_tunnels_coverage = "INCOMPLETE_TUNNELS_COVERAGE"


class State3(Enum):
    connection_redundancy_met = "CONNECTION_REDUNDANCY_MET"
    connection_redundancy_not_met = "CONNECTION_REDUNDANCY_NOT_MET"


class VpnGatewayStatusHighAvailabilityRequirementState(BaseModel):
    unsatisfied_reason: Optional[UnsatisfiedReason] = Field(
        None,
        alias="unsatisfiedReason",
        description="Indicates the reason why the VPN connection does not meet the high availability redundancy criteria/requirement. Valid values is INCOMPLETE_TUNNELS_COVERAGE.",
    )
    state: Optional[State3] = Field(
        None,
        description="Indicates the high availability requirement state for the VPN connection. Valid values are CONNECTION_REDUNDANCY_MET, CONNECTION_REDUNDANCY_NOT_MET.",
    )


class VpnGatewayStatusTunnel(BaseModel):
    peer_gateway_interface: Optional[int] = Field(
        None,
        alias="peerGatewayInterface",
        description="The peer gateway interface this VPN tunnel is connected to, the peer gateway could either be an external VPN gateway or GCP VPN gateway.",
    )
    local_gateway_interface: Optional[int] = Field(
        None,
        alias="localGatewayInterface",
        description="The VPN gateway interface this VPN tunnel is associated with.",
    )
    tunnel_url: Optional[str] = Field(
        None, alias="tunnelUrl", description="URL reference to the VPN tunnel."
    )


class SourceSubnetworkIpRangesToNat(Enum):
    all_subnetworks_all_ip_ranges = "ALL_SUBNETWORKS_ALL_IP_RANGES"
    all_subnetworks_all_primary_ip_ranges = "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES"
    list_of_subnetworks = "LIST_OF_SUBNETWORKS"


class NatIpAllocateOption(Enum):
    auto_only = "AUTO_ONLY"
    manual_only = "MANUAL_ONLY"


class EndpointType(Enum):
    endpoint_type_swg = "ENDPOINT_TYPE_SWG"
    endpoint_type_vm = "ENDPOINT_TYPE_VM"


class Filter(Enum):
    all = "ALL"
    errors_only = "ERRORS_ONLY"
    translations_only = "TRANSLATIONS_ONLY"


class RouterNatLogConfig(BaseModel):
    filter: Optional[Filter] = Field(
        None,
        description="Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values: - ERRORS_ONLY: Export logs only for connection failures. - TRANSLATIONS_ONLY: Export logs only for successful connections. - ALL: Export logs for all connections, successful and unsuccessful. ",
    )
    enable: Optional[bool] = Field(
        None,
        description="Indicates whether or not to export logs. This is false by default.",
    )


class RouterNatRuleAction(BaseModel):
    source_nat_drain_ips: Optional[List[str]] = Field(
        None,
        alias="sourceNatDrainIps",
        description="A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.",
    )
    source_nat_active_ips: Optional[List[str]] = Field(
        None,
        alias="sourceNatActiveIps",
        description="A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.",
    )


class SourceIpRangesToNatEnum(Enum):
    all_ip_ranges = "ALL_IP_RANGES"
    list_of_secondary_ip_ranges = "LIST_OF_SECONDARY_IP_RANGES"
    primary_ip_range = "PRIMARY_IP_RANGE"


class RouterNatSubnetworkToNat(BaseModel):
    source_ip_ranges_to_nat: Optional[List[SourceIpRangesToNatEnum]] = Field(
        None,
        alias="sourceIpRangesToNat",
        description='Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]',
    )
    name: Optional[str] = Field(
        None, description="URL for the subnetwork resource that will use NAT."
    )
    secondary_ip_range_names: Optional[List[str]] = Field(
        None,
        alias="secondaryIpRangeNames",
        description='A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.',
    )


class Datum19(Datum):
    pass


class Warning19(BaseModel):
    data: Optional[List[Datum19]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class XpnProjectStatus(Enum):
    host = "HOST"
    unspecified_xpn_project_status = "UNSPECIFIED_XPN_PROJECT_STATUS"


class Metric(Enum):
    a2_cpus = "A2_CPUS"
    affinity_groups = "AFFINITY_GROUPS"
    autoscalers = "AUTOSCALERS"
    backend_buckets = "BACKEND_BUCKETS"
    backend_services = "BACKEND_SERVICES"
    c2_d_cpus = "C2D_CPUS"
    c2_cpus = "C2_CPUS"
    c3_cpus = "C3_CPUS"
    commitments = "COMMITMENTS"
    committed_a2_cpus = "COMMITTED_A2_CPUS"
    committed_c2_d_cpus = "COMMITTED_C2D_CPUS"
    committed_c2_cpus = "COMMITTED_C2_CPUS"
    committed_c3_cpus = "COMMITTED_C3_CPUS"
    committed_cpus = "COMMITTED_CPUS"
    committed_e2_cpus = "COMMITTED_E2_CPUS"
    committed_licenses = "COMMITTED_LICENSES"
    committed_local_ssd_total_gb = "COMMITTED_LOCAL_SSD_TOTAL_GB"
    committed_m3_cpus = "COMMITTED_M3_CPUS"
    committed_memory_optimized_cpus = "COMMITTED_MEMORY_OPTIMIZED_CPUS"
    committed_n2_a_cpus = "COMMITTED_N2A_CPUS"
    committed_n2_d_cpus = "COMMITTED_N2D_CPUS"
    committed_n2_cpus = "COMMITTED_N2_CPUS"
    committed_nvidia_a100_80_gb_gpus = "COMMITTED_NVIDIA_A100_80GB_GPUS"
    committed_nvidia_a100_gpus = "COMMITTED_NVIDIA_A100_GPUS"
    committed_nvidia_k80_gpus = "COMMITTED_NVIDIA_K80_GPUS"
    committed_nvidia_p100_gpus = "COMMITTED_NVIDIA_P100_GPUS"
    committed_nvidia_p4_gpus = "COMMITTED_NVIDIA_P4_GPUS"
    committed_nvidia_t4_gpus = "COMMITTED_NVIDIA_T4_GPUS"
    committed_nvidia_v100_gpus = "COMMITTED_NVIDIA_V100_GPUS"
    committed_t2_a_cpus = "COMMITTED_T2A_CPUS"
    committed_t2_d_cpus = "COMMITTED_T2D_CPUS"
    cpus = "CPUS"
    cpus_all_regions = "CPUS_ALL_REGIONS"
    disks_total_gb = "DISKS_TOTAL_GB"
    e2_cpus = "E2_CPUS"
    external_managed_forwarding_rules = "EXTERNAL_MANAGED_FORWARDING_RULES"
    external_network_lb_forwarding_rules = "EXTERNAL_NETWORK_LB_FORWARDING_RULES"
    external_protocol_forwarding_rules = "EXTERNAL_PROTOCOL_FORWARDING_RULES"
    external_vpn_gateways = "EXTERNAL_VPN_GATEWAYS"
    firewalls = "FIREWALLS"
    forwarding_rules = "FORWARDING_RULES"
    global_external_managed_forwarding_rules = "GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES"
    global_internal_addresses = "GLOBAL_INTERNAL_ADDRESSES"
    gpus_all_regions = "GPUS_ALL_REGIONS"
    health_checks = "HEALTH_CHECKS"
    images = "IMAGES"
    instances = "INSTANCES"
    instance_groups = "INSTANCE_GROUPS"
    instance_group_managers = "INSTANCE_GROUP_MANAGERS"
    instance_templates = "INSTANCE_TEMPLATES"
    interconnects = "INTERCONNECTS"
    interconnect_attachments_per_region = "INTERCONNECT_ATTACHMENTS_PER_REGION"
    interconnect_attachments_total_mbps = "INTERCONNECT_ATTACHMENTS_TOTAL_MBPS"
    interconnect_total_gbps = "INTERCONNECT_TOTAL_GBPS"
    internal_addresses = "INTERNAL_ADDRESSES"
    internal_traffic_director_forwarding_rules = "INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES"
    in_place_snapshots = "IN_PLACE_SNAPSHOTS"
    in_use_addresses = "IN_USE_ADDRESSES"
    in_use_backup_schedules = "IN_USE_BACKUP_SCHEDULES"
    in_use_snapshot_schedules = "IN_USE_SNAPSHOT_SCHEDULES"
    local_ssd_total_gb = "LOCAL_SSD_TOTAL_GB"
    m1_cpus = "M1_CPUS"
    m2_cpus = "M2_CPUS"
    m3_cpus = "M3_CPUS"
    machine_images = "MACHINE_IMAGES"
    n2_a_cpus = "N2A_CPUS"
    n2_d_cpus = "N2D_CPUS"
    n2_cpus = "N2_CPUS"
    networks = "NETWORKS"
    network_endpoint_groups = "NETWORK_ENDPOINT_GROUPS"
    network_firewall_policies = "NETWORK_FIREWALL_POLICIES"
    node_groups = "NODE_GROUPS"
    node_templates = "NODE_TEMPLATES"
    nvidia_a100_80_gb_gpus = "NVIDIA_A100_80GB_GPUS"
    nvidia_a100_gpus = "NVIDIA_A100_GPUS"
    nvidia_k80_gpus = "NVIDIA_K80_GPUS"
    nvidia_p100_gpus = "NVIDIA_P100_GPUS"
    nvidia_p100_vws_gpus = "NVIDIA_P100_VWS_GPUS"
    nvidia_p4_gpus = "NVIDIA_P4_GPUS"
    nvidia_p4_vws_gpus = "NVIDIA_P4_VWS_GPUS"
    nvidia_t4_gpus = "NVIDIA_T4_GPUS"
    nvidia_t4_vws_gpus = "NVIDIA_T4_VWS_GPUS"
    nvidia_v100_gpus = "NVIDIA_V100_GPUS"
    packet_mirrorings = "PACKET_MIRRORINGS"
    pd_extreme_total_provisioned_iops = "PD_EXTREME_TOTAL_PROVISIONED_IOPS"
    preemptible_cpus = "PREEMPTIBLE_CPUS"
    preemptible_local_ssd_gb = "PREEMPTIBLE_LOCAL_SSD_GB"
    preemptible_nvidia_a100_80_gb_gpus = "PREEMPTIBLE_NVIDIA_A100_80GB_GPUS"
    preemptible_nvidia_a100_gpus = "PREEMPTIBLE_NVIDIA_A100_GPUS"
    preemptible_nvidia_k80_gpus = "PREEMPTIBLE_NVIDIA_K80_GPUS"
    preemptible_nvidia_p100_gpus = "PREEMPTIBLE_NVIDIA_P100_GPUS"
    preemptible_nvidia_p100_vws_gpus = "PREEMPTIBLE_NVIDIA_P100_VWS_GPUS"
    preemptible_nvidia_p4_gpus = "PREEMPTIBLE_NVIDIA_P4_GPUS"
    preemptible_nvidia_p4_vws_gpus = "PREEMPTIBLE_NVIDIA_P4_VWS_GPUS"
    preemptible_nvidia_t4_gpus = "PREEMPTIBLE_NVIDIA_T4_GPUS"
    preemptible_nvidia_t4_vws_gpus = "PREEMPTIBLE_NVIDIA_T4_VWS_GPUS"
    preemptible_nvidia_v100_gpus = "PREEMPTIBLE_NVIDIA_V100_GPUS"
    psc_ilb_consumer_forwarding_rules_per_producer_network = (
        "PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK"
    )
    psc_internal_lb_forwarding_rules = "PSC_INTERNAL_LB_FORWARDING_RULES"
    public_advertised_prefixes = "PUBLIC_ADVERTISED_PREFIXES"
    public_delegated_prefixes = "PUBLIC_DELEGATED_PREFIXES"
    regional_autoscalers = "REGIONAL_AUTOSCALERS"
    regional_instance_group_managers = "REGIONAL_INSTANCE_GROUP_MANAGERS"
    reservations = "RESERVATIONS"
    resource_policies = "RESOURCE_POLICIES"
    routers = "ROUTERS"
    routes = "ROUTES"
    security_policies = "SECURITY_POLICIES"
    security_policies_per_region = "SECURITY_POLICIES_PER_REGION"
    security_policy_ceval_rules = "SECURITY_POLICY_CEVAL_RULES"
    security_policy_rules = "SECURITY_POLICY_RULES"
    security_policy_rules_per_region = "SECURITY_POLICY_RULES_PER_REGION"
    service_attachments = "SERVICE_ATTACHMENTS"
    snapshots = "SNAPSHOTS"
    ssd_total_gb = "SSD_TOTAL_GB"
    ssl_certificates = "SSL_CERTIFICATES"
    static_addresses = "STATIC_ADDRESSES"
    static_byoip_addresses = "STATIC_BYOIP_ADDRESSES"
    subnetworks = "SUBNETWORKS"
    t2_a_cpus = "T2A_CPUS"
    t2_d_cpus = "T2D_CPUS"
    target_https_proxies = "TARGET_HTTPS_PROXIES"
    target_http_proxies = "TARGET_HTTP_PROXIES"
    target_instances = "TARGET_INSTANCES"
    target_pools = "TARGET_POOLS"
    target_ssl_proxies = "TARGET_SSL_PROXIES"
    target_tcp_proxies = "TARGET_TCP_PROXIES"
    target_vpn_gateways = "TARGET_VPN_GATEWAYS"
    url_maps = "URL_MAPS"
    vpn_gateways = "VPN_GATEWAYS"
    vpn_tunnels = "VPN_TUNNELS"
    xpn_service_projects = "XPN_SERVICE_PROJECTS"


class Quota(BaseModel):
    metric: Optional[Metric] = Field(None, description="[Output Only] Name of the quota metric.")
    owner: Optional[str] = Field(
        None,
        description="[Output Only] Owning resource. This is the resource on which this quota is applied.",
    )
    limit: Optional[float] = Field(None, description="[Output Only] Quota limit for this metric.")
    usage: Optional[float] = Field(None, description="[Output Only] Current usage of this metric.")


class UsageExportLocation(BaseModel):
    report_name_prefix: Optional[str] = Field(
        None,
        alias="reportNamePrefix",
        description="An optional prefix for the name of the usage report object stored in bucketName. If not supplied, defaults to usage_gce. The report is stored as a CSV file named report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the day of the usage according to Pacific Time. If you supply a prefix, it should conform to Cloud Storage object naming conventions.",
    )
    bucket_name: Optional[str] = Field(
        None,
        alias="bucketName",
        description="The name of an existing bucket in Cloud Storage where the usage report object is stored. The Google Service Account is granted write access to this bucket. This can either be the bucket name by itself, such as example-bucket, or the bucket name with gs:// or https://storage.googleapis.com/ in front of it, such as gs://example-bucket.",
    )


class ManagementType(Enum):
    managed_by_attachment = "MANAGED_BY_ATTACHMENT"
    managed_by_user = "MANAGED_BY_USER"


class RouterInterface(BaseModel):
    redundant_interface: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        alias="redundantInterface",
        description="Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    linked_vpn_tunnel: Optional[str] = Field(
        None,
        alias="linkedVpnTunnel",
        description="URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.",
    )
    linked_interconnect_attachment: Optional[str] = Field(
        None,
        alias="linkedInterconnectAttachment",
        description="URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.",
    )
    management_type: Optional[ManagementType] = Field(
        None,
        alias="managementType",
        description="[Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted. ",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    private_ip_address: Optional[str] = Field(
        None,
        alias="privateIpAddress",
        description="The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.",
    )
    ip_range: Optional[str] = Field(
        None,
        alias="ipRange",
        description="IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.",
    )


class ReservationsResizeRequest(BaseModel):
    specific_sku_count: Optional[str] = Field(
        None,
        alias="specificSkuCount",
        description="Number of allocated resources can be resized with minimum = 1 and maximum = 1000.",
    )


class InterconnectAttachmentPartnerMetadata(BaseModel):
    partner_name: Optional[str] = Field(
        None,
        alias="partnerName",
        description="Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.",
    )
    interconnect_name: Optional[str] = Field(
        None,
        alias="interconnectName",
        description='Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner\'s portal. For instance "Chicago 1". This value may be validated to match approved Partner values.',
    )
    portal_url: Optional[str] = Field(
        None,
        alias="portalUrl",
        description="URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.",
    )


class SubnetworksExpandIpCidrRangeRequest(BaseModel):
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The IP (in CIDR format or netmask) of internal addresses that are legal on this Subnetwork. This range should be disjoint from other subnetworks within this network. This range can only be larger than (i.e. a superset of) the range previously defined before the update.",
    )


class AdvertisedGroup(Enum):
    all_subnets = "ALL_SUBNETS"


class AdvertiseMode(Enum):
    custom = "CUSTOM"
    default = "DEFAULT"


class Enable(Enum):
    false = "FALSE"
    true = "TRUE"


class SessionInitializationMode(Enum):
    active = "ACTIVE"
    disabled = "DISABLED"
    passive = "PASSIVE"


class RouterBgpPeerBfd(BaseModel):
    min_transmit_interval: Optional[int] = Field(
        None,
        alias="minTransmitInterval",
        description="The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.",
    )
    min_receive_interval: Optional[int] = Field(
        None,
        alias="minReceiveInterval",
        description="The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.",
    )
    session_initialization_mode: Optional[SessionInitializationMode] = Field(
        None,
        alias="sessionInitializationMode",
        description="The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.",
    )
    multiplier: Optional[int] = Field(
        None,
        description="The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.",
    )


class RouterAdvertisedIpRange(BaseModel):
    description: Optional[str] = Field(
        None, description="User-specified description for the IP range."
    )
    range: Optional[str] = Field(
        None,
        description="The IP range to advertise. The value must be a CIDR-formatted string.",
    )


class RouterBgp(BaseModel):
    advertise_mode: Optional[AdvertiseMode] = Field(
        None,
        alias="advertiseMode",
        description="User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.",
    )
    advertised_groups: Optional[List[AdvertisedGroup]] = Field(
        None,
        alias="advertisedGroups",
        description="User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.",
    )
    asn: Optional[int] = Field(
        None,
        description="Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.",
    )
    advertised_ip_ranges: Optional[List[RouterAdvertisedIpRange]] = Field(
        None,
        alias="advertisedIpRanges",
        description="User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.",
    )
    keepalive_interval: Optional[int] = Field(
        None,
        alias="keepaliveInterval",
        description="The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.",
    )


class BfdStatusPacketCounts(BaseModel):
    num_rx_successful: Optional[int] = Field(
        None,
        alias="numRxSuccessful",
        description="Number of packets received that were successfully processed since the beginning of the current BFD session.",
    )
    num_rx: Optional[int] = Field(
        None,
        alias="numRx",
        description="Number of packets received since the beginning of the current BFD session.",
    )
    num_rx_rejected: Optional[int] = Field(
        None,
        alias="numRxRejected",
        description="Number of packets received that were rejected because of errors since the beginning of the current BFD session.",
    )
    num_tx: Optional[int] = Field(
        None,
        alias="numTx",
        description="Number of packets transmitted since the beginning of the current BFD session.",
    )


class InstanceGroupManagersDeleteInstancesRequest(BaseModel):
    instances: Optional[List[str]] = Field(
        None,
        description="The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )
    skip_instances_on_validation_error: Optional[bool] = Field(
        None,
        alias="skipInstancesOnValidationError",
        description="Specifies whether the request should proceed despite the inclusion of instances that are not members of the group or that are already in the process of being deleted or abandoned. If this field is set to `false` and such an instance is specified in the request, the operation fails. The operation always fails if the request contains a malformed instance URL or a reference to an instance that exists in a zone or region other than the group's zone or region.",
    )


class RedundancyType(Enum):
    four_ips_redundancy = "FOUR_IPS_REDUNDANCY"
    single_ip_internally_redundant = "SINGLE_IP_INTERNALLY_REDUNDANT"
    two_ips_redundancy = "TWO_IPS_REDUNDANCY"


class ExternalVpnGateway(BaseModel):
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.",
    )
    interfaces: Optional[List[ExternalVpnGatewayInterface]] = Field(
        None,
        description="A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.",
    )
    kind: Optional[str] = Field(
        "compute#externalVpnGateway",
        description="[Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    redundancy_type: Optional[RedundancyType] = Field(
        None,
        alias="redundancyType",
        description="Indicates the user-supplied redundancy type of this external VPN gateway.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )


class Datum20(Datum2):
    pass


class Warning20(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum20]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum21(Datum2):
    pass


class Warning21(BaseModel):
    data: Optional[List[Datum21]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status9(Enum):
    active = "ACTIVE"
    deleting = "DELETING"
    error = "ERROR"
    pending = "PENDING"


class Mode3(Enum):
    off = "OFF"
    on = "ON"
    only_scale_out = "ONLY_SCALE_OUT"
    only_up = "ONLY_UP"


class UtilizationTargetType(Enum):
    delta_per_minute = "DELTA_PER_MINUTE"
    delta_per_second = "DELTA_PER_SECOND"
    gauge = "GAUGE"


class AutoscalingPolicyCustomMetricUtilization(BaseModel):
    utilization_target_type: Optional[UtilizationTargetType] = Field(
        None,
        alias="utilizationTargetType",
        description="Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.",
    )
    utilization_target: Optional[float] = Field(
        None,
        alias="utilizationTarget",
        description="The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.",
    )
    filter: Optional[str] = Field(
        None,
        description="A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.",
    )
    single_instance_assignment: Optional[float] = Field(
        None,
        alias="singleInstanceAssignment",
        description="If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.",
    )
    metric: Optional[str] = Field(
        None,
        description="The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.",
    )


class FixedOrPercent(BaseModel):
    fixed: Optional[int] = Field(
        None,
        description="Specifies a fixed number of VM instances. This must be a positive integer.",
    )
    percent: Optional[int] = Field(
        None,
        description="Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.",
    )
    calculated: Optional[int] = Field(
        None,
        description="[Output Only] Absolute value of VM instances calculated based on the specific mode. - If the value is fixed, then the calculated value is equal to the fixed value. - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded. ",
    )


class AutoscalingPolicyLoadBalancingUtilization(BaseModel):
    utilization_target: Optional[float] = Field(
        None,
        alias="utilizationTarget",
        description="Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.",
    )


class AutoscalingPolicyScalingSchedule(BaseModel):
    duration_sec: Optional[int] = Field(
        None,
        alias="durationSec",
        description="The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.",
    )
    description: Optional[str] = Field(None, description="A description of a scaling schedule.")
    disabled: Optional[bool] = Field(
        None,
        description="A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.",
    )
    time_zone: Optional[str] = Field(
        None,
        alias="timeZone",
        description="The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of “UTC” if left empty.",
    )
    min_required_replicas: Optional[int] = Field(
        None,
        alias="minRequiredReplicas",
        description="The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.",
    )
    schedule: Optional[str] = Field(
        None,
        description="The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.",
    )


class PredictiveMethod(Enum):
    none = "NONE"
    optimize_availability = "OPTIMIZE_AVAILABILITY"


class AutoscalingPolicyCpuUtilization(BaseModel):
    utilization_target: Optional[float] = Field(
        None,
        alias="utilizationTarget",
        description="The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.",
    )
    predictive_method: Optional[PredictiveMethod] = Field(
        None,
        alias="predictiveMethod",
        description="Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.",
    )


class Type8(Enum):
    all_instances_unhealthy = "ALL_INSTANCES_UNHEALTHY"
    backend_service_does_not_exist = "BACKEND_SERVICE_DOES_NOT_EXIST"
    capped_at_max_num_replicas = "CAPPED_AT_MAX_NUM_REPLICAS"
    custom_metric_data_points_too_sparse = "CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE"
    custom_metric_invalid = "CUSTOM_METRIC_INVALID"
    min_equals_max = "MIN_EQUALS_MAX"
    missing_custom_metric_data_points = "MISSING_CUSTOM_METRIC_DATA_POINTS"
    missing_load_balancing_data_points = "MISSING_LOAD_BALANCING_DATA_POINTS"
    mode_off = "MODE_OFF"
    mode_only_scale_out = "MODE_ONLY_SCALE_OUT"
    mode_only_up = "MODE_ONLY_UP"
    more_than_one_backend_service = "MORE_THAN_ONE_BACKEND_SERVICE"
    not_enough_quota_available = "NOT_ENOUGH_QUOTA_AVAILABLE"
    region_resource_stockout = "REGION_RESOURCE_STOCKOUT"
    scaling_target_does_not_exist = "SCALING_TARGET_DOES_NOT_EXIST"
    scheduled_instances_greater_than_autoscaler_max = (
        "SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX"
    )
    scheduled_instances_less_than_autoscaler_min = "SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN"
    unknown = "UNKNOWN"
    unsupported_max_rate_load_balancing_configuration = (
        "UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION"
    )
    zone_resource_stockout = "ZONE_RESOURCE_STOCKOUT"


class AutoscalerStatusDetails(BaseModel):
    type: Optional[Type8] = Field(
        None,
        description="The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the \"Autoscale only out\" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.",
    )
    message: Optional[str] = Field(None, description="The status message.")


class State4(Enum):
    active = "ACTIVE"
    disabled = "DISABLED"
    obsolete = "OBSOLETE"
    ready = "READY"


class ScalingScheduleStatus(BaseModel):
    last_start_time: Optional[str] = Field(
        None,
        alias="lastStartTime",
        description="[Output Only] The last time the scaling schedule became active. Note: this is a timestamp when a schedule actually became active, not when it was planned to do so. The timestamp is in RFC3339 text format.",
    )
    state: Optional[State4] = Field(
        None, description="[Output Only] The current state of a scaling schedule."
    )
    next_start_time: Optional[str] = Field(
        None,
        alias="nextStartTime",
        description="[Output Only] The next time the scaling schedule is to become active. Note: this is a timestamp when a schedule is planned to run, but the actual time might be slightly different. The timestamp is in RFC3339 text format.",
    )


class TargetHttpsProxiesSetCertificateMapRequest(BaseModel):
    certificate_map: Optional[str] = Field(
        None,
        alias="certificateMap",
        description="URL of the Certificate Map to associate with this TargetHttpsProxy.",
    )


class NetworkEndpoint(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None, description="Metadata defined as annotations on the network endpoint."
    )
    port: Optional[int] = Field(
        None,
        description="Optional port number of network endpoint. If not specified, the defaultPort for the network endpoint group will be used.",
    )
    fqdn: Optional[str] = Field(
        None,
        description="Optional fully qualified domain name of network endpoint. This can only be specified when NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.",
    )
    ip_address: Optional[str] = Field(
        None,
        alias="ipAddress",
        description="Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine (either the primary IP or as part of an aliased IP range). If the IP address is not specified, then the primary IP address for the VM instance in the network that the network endpoint group belongs to will be used.",
    )
    instance: Optional[str] = Field(
        None,
        description="The name for a specific VM instance that the IP address belongs to. This is required for network endpoints of type GCE_VM_IP_PORT. The instance must be in the same zone of network endpoint group. The name must be 1-63 characters long, and comply with RFC1035.",
    )


class Status10(Enum):
    deleting = "DELETING"
    failed = "FAILED"
    pending = "PENDING"
    ready = "READY"


class ContainerType(Enum):
    tar = "TAR"


class RawDisk(BaseModel):
    container_type: Optional[ContainerType] = Field(
        None,
        alias="containerType",
        description="The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.",
    )
    sha1_checksum: Optional[constr(regex=r"[a-f0-9]{40}")] = Field(
        None,
        alias="sha1Checksum",
        description="[Deprecated] This field is deprecated. An optional SHA1 checksum of the disk image before unpackaging provided by the client when the disk image is created.",
    )
    source: Optional[str] = Field(
        None,
        description="The full Google Cloud Storage URL where the raw disk image archive is stored. The following are valid formats for the URL: - https://storage.googleapis.com/bucket_name/image_archive_name - https://storage.googleapis.com/bucket_name/folder_name/ image_archive_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL ",
    )


class SourceType(Enum):
    raw = "RAW"


class Datum22(Datum):
    pass


class Warning22(BaseModel):
    data: Optional[List[Datum22]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class InstanceReference(BaseModel):
    instance: Optional[str] = Field(
        None,
        description="The URL for a specific instance. @required compute.instancegroups.addInstances/removeInstances",
    )


class Datum23(Datum2):
    pass


class Warning23(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum23]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class EdgeAvailabilityDomain(Enum):
    availability_domain_1 = "AVAILABILITY_DOMAIN_1"
    availability_domain_2 = "AVAILABILITY_DOMAIN_2"
    availability_domain_any = "AVAILABILITY_DOMAIN_ANY"


class Bandwidth(Enum):
    bps_100_m = "BPS_100M"
    bps_10_g = "BPS_10G"
    bps_1_g = "BPS_1G"
    bps_200_m = "BPS_200M"
    bps_20_g = "BPS_20G"
    bps_2_g = "BPS_2G"
    bps_300_m = "BPS_300M"
    bps_400_m = "BPS_400M"
    bps_500_m = "BPS_500M"
    bps_50_g = "BPS_50G"
    bps_50_m = "BPS_50M"
    bps_5_g = "BPS_5G"


class Type9(Enum):
    dedicated = "DEDICATED"
    partner = "PARTNER"
    partner_provider = "PARTNER_PROVIDER"


class Encryption(Enum):
    ipsec = "IPSEC"
    none = "NONE"


class OperationalStatus(Enum):
    os_active = "OS_ACTIVE"
    os_unprovisioned = "OS_UNPROVISIONED"


class State5(Enum):
    active = "ACTIVE"
    defunct = "DEFUNCT"
    partner_request_received = "PARTNER_REQUEST_RECEIVED"
    pending_customer = "PENDING_CUSTOMER"
    pending_partner = "PENDING_PARTNER"
    state_unspecified = "STATE_UNSPECIFIED"
    unprovisioned = "UNPROVISIONED"


class InterconnectAttachmentPrivateInfo(BaseModel):
    tag8021q: Optional[int] = Field(
        None,
        description="[Output Only] 802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.",
    )


class NodeGroupsDeleteNodesRequest(BaseModel):
    nodes: Optional[List[str]] = Field(None, description="Names of the nodes to delete.")


class NotificationEndpointGrpcSettings(BaseModel):
    resend_interval: Optional[Duration] = Field(
        None,
        alias="resendInterval",
        description="Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed.",
    )
    authority: Optional[str] = Field(
        None,
        description="Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3",
    )
    retry_duration_sec: Optional[int] = Field(
        None,
        alias="retryDurationSec",
        description="How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.",
    )
    payload_name: Optional[str] = Field(
        None,
        alias="payloadName",
        description='Optional. If specified, this field is used to populate the "name" field in gRPC requests.',
    )
    endpoint: Optional[str] = Field(
        None,
        description="Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.",
    )


class VmEndpointNatMappingsInterfaceNatMappings(BaseModel):
    num_total_drain_nat_ports: Optional[int] = Field(
        None,
        alias="numTotalDrainNatPorts",
        description="Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.",
    )
    num_total_nat_ports: Optional[int] = Field(
        None,
        alias="numTotalNatPorts",
        description="Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.",
    )
    nat_ip_port_ranges: Optional[List[str]] = Field(
        None,
        alias="natIpPortRanges",
        description='A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].',
    )
    drain_nat_ip_port_ranges: Optional[List[str]] = Field(
        None,
        alias="drainNatIpPortRanges",
        description='List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].',
    )
    source_alias_ip_range: Optional[str] = Field(
        None,
        alias="sourceAliasIpRange",
        description='Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".',
    )
    source_virtual_ip: Optional[str] = Field(
        None, alias="sourceVirtualIp", description="Primary IP of the VM for this NIC."
    )


class TargetPoolsAddHealthCheckRequest(BaseModel):
    health_checks: Optional[List[HealthCheckReference]] = Field(
        None,
        alias="healthChecks",
        description="The HttpHealthCheck to add to the target pool.",
    )


class TargetReference(BaseModel):
    target: Optional[str] = None


class Datum24(Datum2):
    pass


class Warning24(BaseModel):
    data: Optional[List[Datum24]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum25(Datum):
    pass


class Warning25(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum25]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Status11(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    failed = "FAILED"
    ready = "READY"
    uploading = "UPLOADING"


class StorageBytesStatus(Enum):
    updating = "UPDATING"
    up_to_date = "UP_TO_DATE"


class Snapshot(BaseModel):
    storage_locations: Optional[List[str]] = Field(
        None,
        alias="storageLocations",
        description="Cloud Storage bucket storage location of the snapshot (regional or multi-regional).",
    )
    source_disk: Optional[str] = Field(
        None,
        alias="sourceDisk",
        description="The source disk used to create this snapshot.",
    )
    auto_created: Optional[bool] = Field(
        None,
        alias="autoCreated",
        description="[Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.",
    )
    licenses: Optional[List[str]] = Field(
        None,
        description="[Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    download_bytes: Optional[str] = Field(
        None,
        alias="downloadBytes",
        description="[Output Only] Number of bytes downloaded to restore a snapshot to a disk.",
    )
    source_disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceDiskEncryptionKey",
        description="The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.",
    )
    chain_name: Optional[str] = Field(
        None,
        alias="chainName",
        description="Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    storage_bytes: Optional[str] = Field(
        None,
        alias="storageBytes",
        description="[Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.",
    )
    source_disk_id: Optional[str] = Field(
        None,
        alias="sourceDiskId",
        description="[Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.",
    )
    disk_size_gb: Optional[str] = Field(
        None,
        alias="diskSizeGb",
        description="[Output Only] Size of the source disk, specified in GB.",
    )
    status: Optional[Status11] = Field(
        None,
        description="[Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.",
    )
    snapshot_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="snapshotEncryptionKey",
        description="Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    kind: Optional[str] = Field(
        "compute#snapshot",
        description="[Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.",
    )
    location_hint: Optional[str] = Field(
        None,
        alias="locationHint",
        description="An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.",
    )
    license_codes: Optional[List[str]] = Field(
        None,
        alias="licenseCodes",
        description="[Output Only] Integer license codes indicating which licenses are attached to this snapshot.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.",
    )
    storage_bytes_status: Optional[StorageBytesStatus] = Field(
        None,
        alias="storageBytesStatus",
        description="[Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.",
    )


class RegionDisksResizeRequest(BaseModel):
    size_gb: Optional[str] = Field(
        None,
        alias="sizeGb",
        description="The new size of the regional persistent disk, which is specified in GB.",
    )


class FirewallPolicyAssociation(BaseModel):
    name: Optional[str] = Field(None, description="The name for an association.")
    attachment_target: Optional[str] = Field(
        None,
        alias="attachmentTarget",
        description="The target that the firewall policy is attached to.",
    )
    firewall_policy_id: Optional[str] = Field(
        None,
        alias="firewallPolicyId",
        description="[Output Only] The firewall policy ID of the association.",
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="[Output Only] Deprecated, please use short name instead. The display name of the firewall policy of the association.",
    )
    short_name: Optional[str] = Field(
        None,
        alias="shortName",
        description="[Output Only] The short name of the firewall policy of the association.",
    )


class Datum26(Datum):
    pass


class Warning26(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum26]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status12(Enum):
    initial = "INITIAL"
    prefix_configuration_complete = "PREFIX_CONFIGURATION_COMPLETE"
    prefix_configuration_in_progress = "PREFIX_CONFIGURATION_IN_PROGRESS"
    prefix_removal_in_progress = "PREFIX_REMOVAL_IN_PROGRESS"
    ptr_configured = "PTR_CONFIGURED"
    reverse_dns_lookup_failed = "REVERSE_DNS_LOOKUP_FAILED"
    validated = "VALIDATED"


class PublicAdvertisedPrefixPublicDelegatedPrefix(BaseModel):
    name: Optional[str] = Field(None, description="The name of the public delegated prefix")
    region: Optional[str] = Field(
        None,
        description="The region of the public delegated prefix if it is regional. If absent, the prefix is global.",
    )
    status: Optional[str] = Field(
        None,
        description="The status of the public delegated prefix. Possible values are: INITIALIZING: The public delegated prefix is being initialized and addresses cannot be created yet. ANNOUNCED: The public delegated prefix is active.",
    )
    project: Optional[str] = Field(
        None, description="The project number of the public delegated prefix"
    )
    ip_range: Optional[str] = Field(
        None,
        alias="ipRange",
        description="The IP address range of the public delegated prefix",
    )


class Status13(Enum):
    allocating_resources = "ALLOCATING_RESOURCES"
    authorization_error = "AUTHORIZATION_ERROR"
    deprovisioning = "DEPROVISIONING"
    established = "ESTABLISHED"
    failed = "FAILED"
    first_handshake = "FIRST_HANDSHAKE"
    negotiation_failure = "NEGOTIATION_FAILURE"
    network_error = "NETWORK_ERROR"
    no_incoming_packets = "NO_INCOMING_PACKETS"
    provisioning = "PROVISIONING"
    rejected = "REJECTED"
    stopped = "STOPPED"
    waiting_for_full_config = "WAITING_FOR_FULL_CONFIG"


class VpnTunnel(BaseModel):
    remote_traffic_selector: Optional[List[str]] = Field(
        None,
        alias="remoteTrafficSelector",
        description="Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported.",
    )
    detailed_status: Optional[str] = Field(
        None,
        alias="detailedStatus",
        description="[Output Only] Detailed status message for the VPN tunnel.",
    )
    peer_gcp_gateway: Optional[str] = Field(
        None,
        alias="peerGcpGateway",
        description="URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer GCP VPN gateway.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    peer_external_gateway_interface: Optional[int] = Field(
        None,
        alias="peerExternalGatewayInterface",
        description="The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created.",
    )
    target_vpn_gateway: Optional[str] = Field(
        None,
        alias="targetVpnGateway",
        description="URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created.",
    )
    ike_version: Optional[int] = Field(
        None,
        alias="ikeVersion",
        description="IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.",
    )
    local_traffic_selector: Optional[List[str]] = Field(
        None,
        alias="localTrafficSelector",
        description="Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported.",
    )
    vpn_gateway: Optional[str] = Field(
        None,
        alias="vpnGateway",
        description="URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.",
    )
    status: Optional[Status13] = Field(
        None,
        description="[Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel. ",
    )
    kind: Optional[str] = Field(
        "compute#vpnTunnel",
        description="[Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    vpn_gateway_interface: Optional[int] = Field(
        None,
        alias="vpnGatewayInterface",
        description="The interface ID of the VPN gateway with which this VPN tunnel is associated.",
    )
    router: Optional[str] = Field(
        None, description="URL of the router resource to be used for dynamic routing."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    peer_external_gateway: Optional[str] = Field(
        None,
        alias="peerExternalGateway",
        description="URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.",
    )
    peer_ip: Optional[str] = Field(
        None,
        alias="peerIp",
        description="IP address of the peer VPN gateway. Only IPv4 is supported.",
    )
    shared_secret: Optional[str] = Field(
        None,
        alias="sharedSecret",
        description="Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    shared_secret_hash: Optional[str] = Field(
        None, alias="sharedSecretHash", description="Hash of the shared secret."
    )


class StatefulPolicyPreservedStateDiskDevice(BaseModel):
    auto_delete: Optional[AutoDelete] = Field(
        None,
        alias="autoDelete",
        description="These stateful disks will never be deleted during autohealing, update or VM instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.",
    )


class PortSpecification(Enum):
    use_fixed_port = "USE_FIXED_PORT"
    use_named_port = "USE_NAMED_PORT"
    use_serving_port = "USE_SERVING_PORT"


class GrpcHealthCheck(BaseModel):
    port_specification: Optional[PortSpecification] = Field(
        None,
        alias="portSpecification",
        description="Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.",
    )
    port: Optional[int] = Field(
        None,
        description="The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.",
    )
    grpc_service_name: Optional[str] = Field(
        None,
        alias="grpcServiceName",
        description="The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.",
    )


class Datum27(Datum2):
    pass


class Warning27(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum27]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status14(Enum):
    announced = "ANNOUNCED"
    deleting = "DELETING"
    initializing = "INITIALIZING"
    ready_to_announce = "READY_TO_ANNOUNCE"


class Status15(Enum):
    active = "ACTIVE"
    inactive = "INACTIVE"


class PublicDelegatedPrefixPublicDelegatedSubPrefix(BaseModel):
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    name: Optional[str] = Field(None, description="The name of the sub public delegated prefix.")
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The IPv4 address range, in CIDR format, represented by this sub public delegated prefix.",
    )
    is_address: Optional[bool] = Field(
        None,
        alias="isAddress",
        description="Whether the sub prefix is delegated to create Address resources in the delegatee project.",
    )
    status: Optional[Status15] = Field(
        None, description="[Output Only] The status of the sub public delegated prefix."
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The region of the sub public delegated prefix if it is regional. If absent, the sub prefix is global.",
    )
    delegatee_project: Optional[str] = Field(
        None,
        alias="delegateeProject",
        description="Name of the project scoping this PublicDelegatedSubPrefix.",
    )


class Datum28(Datum):
    pass


class Warning28(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum28]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class FirewallPolicyRuleMatcherLayer4Config(BaseModel):
    ports: Optional[List[str]] = Field(
        None,
        description='An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].',
    )
    ip_protocol: Optional[str] = Field(
        None,
        alias="ipProtocol",
        description="The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.",
    )


class RegionTargetHttpsProxiesSetSslCertificatesRequest(BaseModel):
    ssl_certificates: Optional[List[str]] = Field(
        None,
        alias="sslCertificates",
        description="New set of SslCertificate resources to associate with this TargetHttpsProxy resource. Currently exactly one SslCertificate resource must be specified.",
    )


class InstanceGroupsAddInstancesRequest(BaseModel):
    instances: Optional[List[InstanceReference]] = Field(
        None, description="The list of instances to add to the instance group."
    )


class LogType(Enum):
    admin_read = "ADMIN_READ"
    data_read = "DATA_READ"
    data_write = "DATA_WRITE"
    log_type_unspecified = "LOG_TYPE_UNSPECIFIED"


class AuditLogConfig(BaseModel):
    log_type: Optional[LogType] = Field(
        None, alias="logType", description="The log type that this config enables."
    )
    ignore_child_exemptions: Optional[bool] = Field(
        None,
        alias="ignoreChildExemptions",
        description="This is deprecated and has no effect. Do not use.",
    )
    exempted_members: Optional[List[str]] = Field(
        None,
        alias="exemptedMembers",
        description="Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.",
    )


class Datum29(Datum):
    pass


class Warning29(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum29]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class DiskType(BaseModel):
    default_disk_size_gb: Optional[str] = Field(
        None,
        alias="defaultDiskSizeGb",
        description="[Output Only] Server-defined default disk size in GB.",
    )
    description: Optional[str] = Field(
        None, description="[Output Only] An optional description of this resource."
    )
    kind: Optional[str] = Field(
        "compute#diskType",
        description="[Output Only] Type of the resource. Always compute#diskType for disk types.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    valid_disk_size: Optional[str] = Field(
        None,
        alias="validDiskSize",
        description='[Output Only] An optional textual description of the valid disk size, such as "10GB-10TB".',
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    deprecated: Optional[DeprecationStatus] = Field(
        None,
        description="[Output Only] The deprecation status associated with this disk type.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None, description="[Output Only] Name of the resource."
    )


class RoutingMode(Enum):
    global_ = "GLOBAL"
    regional = "REGIONAL"


class NetworkRoutingConfig(BaseModel):
    routing_mode: Optional[RoutingMode] = Field(
        None,
        alias="routingMode",
        description="The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.",
    )


class QuicOverride(Enum):
    disable = "DISABLE"
    enable = "ENABLE"
    none = "NONE"


class TargetHttpsProxy(BaseModel):
    ssl_certificates: Optional[List[str]] = Field(
        None,
        alias="sslCertificates",
        description="URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the TargetHttpsProxy.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    ssl_policy: Optional[str] = Field(
        None,
        alias="sslPolicy",
        description="URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not set, the TargetHttpsProxy resource has no SSL policy configured.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional TargetHttpsProxy resides. This field is not applicable to global TargetHttpsProxies.",
    )
    quic_override: Optional[QuicOverride] = Field(
        None,
        alias="quicOverride",
        description="Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE, ENABLE, or DISABLE. - When quic-override is set to NONE, Google manages whether QUIC is used. - When quic-override is set to ENABLE, the load balancer uses QUIC when possible. - When quic-override is set to DISABLE, the load balancer doesn't use QUIC. - If the quic-override flag is not specified, NONE is implied. ",
    )
    server_tls_policy: Optional[str] = Field(
        None,
        alias="serverTlsPolicy",
        description="Optional. A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the proxy should authenticate inbound traffic. serverTlsPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank, communications are not encrypted. Note: This field currently has no impact.",
    )
    kind: Optional[str] = Field(
        "compute#targetHttpsProxy",
        description="[Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.",
    )
    authorization_policy: Optional[str] = Field(
        None,
        alias="authorizationPolicy",
        description="Optional. A URL referring to a networksecurity.AuthorizationPolicy resource that describes how the proxy should authorize inbound traffic. If left blank, access will not be restricted by an authorization policy. Refer to the AuthorizationPolicy resource for additional details. authorizationPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. Note: This field currently has no impact.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    proxy_bind: Optional[bool] = Field(
        None,
        alias="proxyBind",
        description="This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies set up inbound traffic interception and bind to the IP address and port specified in the forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for inbound requests and handles requests when it receives them. The default is false.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    url_map: Optional[str] = Field(
        None,
        alias="urlMap",
        description="A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL to the BackendService. For example, the following are all valid URLs for specifying a URL map: - https://www.googleapis.compute/v1/projects/project/global/urlMaps/ url-map - projects/project/global/urlMaps/url-map - global/urlMaps/url-map ",
    )
    certificate_map: Optional[str] = Field(
        None,
        alias="certificateMap",
        description="URL of a certificate map that identifies a certificate map associated with the given target proxy. This field can only be set for global target proxies. If set, sslCertificates will be ignored.",
    )


class TestFailure(BaseModel):
    expected_service: Optional[str] = Field(
        None,
        alias="expectedService",
        description="Expected BackendService or BackendBucket resource the given URL should be mapped to.",
    )
    path: Optional[str] = Field(
        None, description="Path portion including query parameters in the URL."
    )
    actual_redirect_response_code: Optional[int] = Field(
        None,
        alias="actualRedirectResponseCode",
        description="Actual HTTP status code for rule with `urlRedirect` calculated by load balancer",
    )
    actual_output_url: Optional[str] = Field(
        None,
        alias="actualOutputUrl",
        description="The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.",
    )
    host: Optional[str] = Field(None, description="Host portion of the URL.")
    headers: Optional[List[UrlMapTestHeader]] = Field(
        None, description="HTTP headers of the request."
    )
    actual_service: Optional[str] = Field(
        None,
        alias="actualService",
        description="BackendService or BackendBucket returned by load balancer.",
    )
    expected_redirect_response_code: Optional[int] = Field(
        None,
        alias="expectedRedirectResponseCode",
        description="Expected HTTP status code for rule with `urlRedirect` calculated by load balancer",
    )
    expected_output_url: Optional[str] = Field(
        None,
        alias="expectedOutputUrl",
        description="The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.",
    )


class GlobalNetworkEndpointGroupsDetachEndpointsRequest(BaseModel):
    network_endpoints: Optional[List[NetworkEndpoint]] = Field(
        None,
        alias="networkEndpoints",
        description="The list of network endpoints to be detached.",
    )


class Datum30(Datum2):
    pass


class Warning30(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum30]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum31(Datum2):
    pass


class Warning31(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum31]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class VpnTunnelsScopedList(BaseModel):
    warning: Optional[Warning31] = Field(
        None,
        description="Informational warning which replaces the list of addresses when the list is empty.",
    )
    vpn_tunnels: Optional[List[VpnTunnel]] = Field(
        None,
        alias="vpnTunnels",
        description="A list of VPN tunnels contained in this scope.",
    )


class Binding(BaseModel):
    role: Optional[str] = Field(
        None,
        description="Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.",
    )
    members: Optional[List[str]] = Field(
        None,
        description="Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. ",
    )
    binding_id: Optional[str] = Field(
        None,
        alias="bindingId",
        description="This is deprecated and has no effect. Do not use.",
    )
    condition: Optional[Expr] = Field(
        None,
        description="The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
    )


class PacketMirroringMirroredResourceInfoSubnetInfo(BaseModel):
    url: Optional[str] = Field(
        None,
        description="Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.",
    )
    canonical_url: Optional[str] = Field(
        None,
        alias="canonicalUrl",
        description="[Output Only] Unique identifier for the subnetwork; defined by the server.",
    )


class Status16(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    invalid = "INVALID"
    ready = "READY"
    uploading = "UPLOADING"


class SavedAttachedDisk(BaseModel):
    auto_delete: Optional[bool] = Field(
        None,
        alias="autoDelete",
        description="Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).",
    )
    kind: Optional[str] = Field(
        "compute#savedAttachedDisk",
        description="[Output Only] Type of the resource. Always compute#attachedDisk for attached disks.",
    )
    disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None, alias="diskEncryptionKey", description="The encryption key for the disk."
    )
    disk_size_gb: Optional[str] = Field(
        None, alias="diskSizeGb", description="The size of the disk in base-2 GB."
    )
    guest_os_features: Optional[List[GuestOsFeature]] = Field(
        None,
        alias="guestOsFeatures",
        description="A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.",
    )
    device_name: Optional[str] = Field(
        None,
        alias="deviceName",
        description="Specifies the name of the disk attached to the source instance.",
    )
    boot: Optional[bool] = Field(
        None,
        description="Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.",
    )
    source: Optional[str] = Field(
        None, description="Specifies a URL of the disk attached to the source instance."
    )
    licenses: Optional[List[str]] = Field(
        None, description="[Output Only] Any valid publicly visible licenses."
    )
    mode: Optional[Mode] = Field(
        None,
        description="The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.",
    )
    storage_bytes_status: Optional[StorageBytesStatus] = Field(
        None,
        alias="storageBytesStatus",
        description="[Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.",
    )
    type: Optional[Type1] = Field(
        None,
        description="Specifies the type of the attached disk, either SCRATCH or PERSISTENT.",
    )
    disk_type: Optional[str] = Field(
        None,
        alias="diskType",
        description="[Output Only] URL of the disk type resource. For example: projects/project /zones/zone/diskTypes/pd-standard or pd-ssd",
    )
    storage_bytes: Optional[str] = Field(
        None,
        alias="storageBytes",
        description="[Output Only] A size of the storage used by the disk's snapshot by this machine image.",
    )
    interface: Optional[Interface] = Field(
        None,
        description="Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.",
    )
    index: Optional[int] = Field(
        None,
        description="Specifies zero-based index of the disk that is attached to the source instance.",
    )


class SourceDiskEncryptionKey(BaseModel):
    disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="diskEncryptionKey",
        description="The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.",
    )
    source_disk: Optional[str] = Field(
        None,
        alias="sourceDisk",
        description="URL of the disk attached to the source instance. This can be a full or valid partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk ",
    )


class SavedDisk(BaseModel):
    storage_bytes: Optional[str] = Field(
        None,
        alias="storageBytes",
        description="[Output Only] Size of the individual disk snapshot used by this machine image.",
    )
    kind: Optional[str] = Field(
        "compute#savedDisk",
        description="[Output Only] Type of the resource. Always compute#savedDisk for attached disks.",
    )
    storage_bytes_status: Optional[StorageBytesStatus] = Field(
        None,
        alias="storageBytesStatus",
        description="[Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.",
    )
    source_disk: Optional[str] = Field(
        None,
        alias="sourceDisk",
        description="Specifies a URL of the disk attached to the source instance.",
    )


class Action(Enum):
    abandoning = "ABANDONING"
    creating = "CREATING"
    creating_without_retries = "CREATING_WITHOUT_RETRIES"
    deleting = "DELETING"
    none = "NONE"
    recreating = "RECREATING"
    refreshing = "REFRESHING"
    restarting = "RESTARTING"
    resuming = "RESUMING"
    starting = "STARTING"
    stopping = "STOPPING"
    suspending = "SUSPENDING"
    verifying = "VERIFYING"


class ManagedInstanceVersion(BaseModel):
    name: Optional[str] = Field(None, description="[Output Only] Name of the version.")
    instance_template: Optional[str] = Field(
        None,
        alias="instanceTemplate",
        description="[Output Only] The intended template of the instance. This field is empty when current_action is one of { DELETING, ABANDONING }.",
    )


class InstanceManagedByIgmErrorManagedInstanceError(BaseModel):
    code: Optional[str] = Field(None, description="[Output Only] Error code.")
    message: Optional[str] = Field(None, description="[Output Only] Error message.")


class SslHealthCheck(BaseModel):
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.",
    )
    port_specification: Optional[PortSpecification] = Field(
        None,
        alias="portSpecification",
        description="Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, SSL health check follows behavior specified in port and portName fields.",
    )
    request: Optional[str] = Field(
        None,
        description="The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.",
    )
    response: Optional[str] = Field(
        None,
        description="The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.",
    )
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )


class GlobalSetLabelsRequest(BaseModel):
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='A list of labels to apply for this resource. Each label must comply with the requirements for labels. For example, "webserver-frontend": "images". A label value can also be empty (e.g. "my-label": "").',
    )


class Datum32(Datum):
    pass


class Warning32(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum32]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class HealthState(Enum):
    draining = "DRAINING"
    healthy = "HEALTHY"
    unhealthy = "UNHEALTHY"
    unknown = "UNKNOWN"


class ForwardingRuleReference(BaseModel):
    forwarding_rule: Optional[str] = Field(None, alias="forwardingRule")


class BackendServiceReference(BaseModel):
    backend_service: Optional[str] = Field(None, alias="backendService")


class Datum33(Datum2):
    pass


class Warning33(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum33]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum34(Datum):
    pass


class Warning34(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum34]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class ConnectionPreference(Enum):
    accept_automatic = "ACCEPT_AUTOMATIC"
    accept_manual = "ACCEPT_MANUAL"
    connection_preference_unspecified = "CONNECTION_PREFERENCE_UNSPECIFIED"


class Status17(Enum):
    accepted = "ACCEPTED"
    closed = "CLOSED"
    pending = "PENDING"
    rejected = "REJECTED"
    status_unspecified = "STATUS_UNSPECIFIED"


class ServiceAttachmentConnectedEndpoint(BaseModel):
    status: Optional[Status17] = Field(
        None,
        description="The status of a connected endpoint to this service attachment.",
    )
    psc_connection_id: Optional[str] = Field(
        None,
        alias="pscConnectionId",
        description="The PSC connection id of the connected endpoint.",
    )
    endpoint: Optional[str] = Field(None, description="The url of a connected endpoint.")


class Uint128(BaseModel):
    high: Optional[str] = None
    low: Optional[str] = None


class ServiceAttachmentConsumerProjectLimit(BaseModel):
    connection_limit: Optional[int] = Field(
        None, alias="connectionLimit", description="The value of the limit to set."
    )
    project_id_or_num: Optional[str] = Field(
        None,
        alias="projectIdOrNum",
        description="The project id or number for the project to set the limit for.",
    )


class Datum35(Datum2):
    pass


class Warning35(BaseModel):
    data: Optional[List[Datum35]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class NotificationEndpoint(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] A unique identifier for this resource type. The server generates this identifier.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    grpc_settings: Optional[NotificationEndpointGrpcSettings] = Field(
        None,
        alias="grpcSettings",
        description="Settings of the gRPC notification endpoint including the endpoint URL and the retry duration.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the notification endpoint resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    kind: Optional[str] = Field(
        "compute#notificationEndpoint",
        description="[Output Only] Type of the resource. Always compute#notificationEndpoint for notification endpoints.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class Datum36(Datum):
    pass


class Warning36(BaseModel):
    data: Optional[List[Datum36]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetSslProxy(BaseModel):
    ssl_certificates: Optional[List[str]] = Field(
        None,
        alias="sslCertificates",
        description="URLs to SslCertificate resources that are used to authenticate connections to Backends. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.",
    )
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    certificate_map: Optional[str] = Field(
        None,
        alias="certificateMap",
        description="URL of a certificate map that identifies a certificate map associated with the given target proxy. This field can only be set for global target proxies. If set, sslCertificates will be ignored.",
    )
    service: Optional[str] = Field(None, description="URL to the BackendService resource.")
    ssl_policy: Optional[str] = Field(
        None,
        alias="sslPolicy",
        description="URL of SslPolicy resource that will be associated with the TargetSslProxy resource. If not set, the TargetSslProxy resource will not have any SSL policy configured.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    kind: Optional[str] = Field(
        "compute#targetSslProxy",
        description="[Output Only] Type of the resource. Always compute#targetSslProxy for target SSL proxies.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )


class Type11(Enum):
    grpc = "GRPC"
    http = "HTTP"
    http2 = "HTTP2"
    https = "HTTPS"
    invalid = "INVALID"
    ssl = "SSL"
    tcp = "TCP"


class Http2HealthCheck(BaseModel):
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )
    response: Optional[str] = Field(
        None,
        description="The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.",
    )
    host: Optional[str] = Field(
        None,
        description="The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.",
    )
    request_path: Optional[str] = Field(
        None,
        alias="requestPath",
        description="The request path of the HTTP/2 health check request. The default value is /.",
    )
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.",
    )
    port_specification: Optional[PortSpecification] = Field(
        None,
        alias="portSpecification",
        description="Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.",
    )


class HttpHealthCheck(BaseModel):
    port_specification: Optional[PortSpecification] = Field(
        None,
        alias="portSpecification",
        description="Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.",
    )
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )
    response: Optional[str] = Field(
        None,
        description="The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.",
    )
    request_path: Optional[str] = Field(
        None,
        alias="requestPath",
        description="The request path of the HTTP health check request. The default value is /.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.",
    )
    host: Optional[str] = Field(
        None,
        description="The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.",
    )
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.",
    )


class HttpsHealthCheck1(BaseModel):
    host: Optional[str] = Field(
        None,
        description="The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.",
    )
    port_specification: Optional[PortSpecification] = Field(
        None,
        alias="portSpecification",
        description="Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.",
    )
    response: Optional[str] = Field(
        None,
        description="The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.",
    )
    request_path: Optional[str] = Field(
        None,
        alias="requestPath",
        description="The request path of the HTTPS health check request. The default value is /.",
    )
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.",
    )
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )


class TcpHealthCheck(BaseModel):
    port_specification: Optional[PortSpecification] = Field(
        None,
        alias="portSpecification",
        description="Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, TCP health check follows behavior specified in port and portName fields.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.",
    )
    request: Optional[str] = Field(
        None,
        description="The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.",
    )
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.",
    )
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )
    response: Optional[str] = Field(
        None,
        description="The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.",
    )


class HealthCheckLogConfig(BaseModel):
    enable: Optional[bool] = Field(
        None,
        description="Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.",
    )


class RegionInstanceGroupsSetNamedPortsRequest(BaseModel):
    fingerprint: Optional[str] = Field(
        None,
        description="The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.",
    )
    named_ports: Optional[List[NamedPort]] = Field(
        None,
        alias="namedPorts",
        description="The list of named ports to set for this instance group.",
    )


class Datum37(Datum2):
    pass


class Warning37(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum37]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum38(Datum):
    pass


class Warning38(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum38]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum39(Datum):
    pass


class Warning39(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum39]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum40(Datum):
    pass


class Warning40(BaseModel):
    data: Optional[List[Datum40]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Purpose(Enum):
    dns_resolver = "DNS_RESOLVER"
    gce_endpoint = "GCE_ENDPOINT"
    ipsec_interconnect = "IPSEC_INTERCONNECT"
    nat_auto = "NAT_AUTO"
    private_service_connect = "PRIVATE_SERVICE_CONNECT"
    serverless = "SERVERLESS"
    shared_loadbalancer_vip = "SHARED_LOADBALANCER_VIP"
    vpc_peering = "VPC_PEERING"


class Status18(Enum):
    in_use = "IN_USE"
    reserved = "RESERVED"
    reserving = "RESERVING"


class AddressType(Enum):
    external = "EXTERNAL"
    internal = "INTERNAL"
    unspecified_type = "UNSPECIFIED_TYPE"


class IpVersion(Enum):
    ipv4 = "IPV4"
    ipv6 = "IPV6"
    unspecified_version = "UNSPECIFIED_VERSION"


class Address(BaseModel):
    kind: Optional[str] = Field(
        "compute#address",
        description="[Output Only] Type of the resource. Always compute#address for addresses.",
    )
    users: Optional[List[str]] = Field(
        None,
        description="[Output Only] The URLs of the resources that are using this address.",
    )
    address: Optional[str] = Field(
        None, description="The static IP address represented by this resource."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.",
    )
    network: Optional[str] = Field(
        None,
        description="The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.",
    )
    purpose: Optional[Purpose] = Field(
        None,
        description="The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *IPsec-encrypted Cloud Interconnect* configuration. These addresses are regional resources. Not currently available publicly. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose. ",
    )
    prefix_length: Optional[int] = Field(
        None,
        alias="prefixLength",
        description="The prefix length if the resource represents an IP range.",
    )
    status: Optional[Status18] = Field(
        None,
        description="[Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.",
    )
    address_type: Optional[AddressType] = Field(
        None,
        alias="addressType",
        description="The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    network_tier: Optional[NetworkTier] = Field(
        None,
        alias="networkTier",
        description="This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this field when you create the resource.",
    )
    ip_version: Optional[IpVersion] = Field(
        None,
        alias="ipVersion",
        description="The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. *This field is not applicable to global addresses.*",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class RegionInstanceGroupManagersRecreateRequest(BaseModel):
    instances: Optional[List[str]] = Field(
        None,
        description="The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )


class BackendBucketCdnPolicyNegativeCachingPolicy(BaseModel):
    code: Optional[int] = Field(
        None,
        description="The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.",
    )
    ttl: Optional[int] = Field(
        None,
        description="The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.",
    )


class BackendBucketCdnPolicyBypassCacheOnRequestHeader(BaseModel):
    header_name: Optional[str] = Field(
        None,
        alias="headerName",
        description="The header field name to match on when bypassing cache. Values are case-insensitive.",
    )


class BackendBucketCdnPolicyCacheKeyPolicy(BaseModel):
    query_string_whitelist: Optional[List[str]] = Field(
        None,
        alias="queryStringWhitelist",
        description="Names of query string parameters to include in cache keys. Default parameters are always included. '&' and '=' will be percent encoded and not treated as delimiters.",
    )
    include_http_headers: Optional[List[str]] = Field(
        None,
        alias="includeHttpHeaders",
        description="Allows HTTP request headers (by name) to be used in the cache key.",
    )


class TargetSslProxiesSetSslCertificatesRequest(BaseModel):
    ssl_certificates: Optional[List[str]] = Field(
        None,
        alias="sslCertificates",
        description="New set of URLs to SslCertificate resources to associate with this TargetSslProxy. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates.",
    )


class Datum41(Datum):
    pass


class Warning41(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum41]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum42(Datum):
    pass


class Warning42(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum42]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class InstanceWithNamedPorts(BaseModel):
    named_ports: Optional[List[NamedPort]] = Field(
        None,
        alias="namedPorts",
        description="[Output Only] The named ports that belong to this instance group.",
    )
    status: Optional[Status8] = Field(None, description="[Output Only] The status of the instance.")
    instance: Optional[str] = Field(None, description="[Output Only] The URL of the instance.")


class Datum43(Datum):
    pass


class Warning43(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum43]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum44(Datum2):
    pass


class Warning44(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum44]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class CpuOvercommitType(Enum):
    cpu_overcommit_type_unspecified = "CPU_OVERCOMMIT_TYPE_UNSPECIFIED"
    enabled = "ENABLED"
    none = "NONE"


class LocalDisk(BaseModel):
    disk_count: Optional[int] = Field(
        None, alias="diskCount", description="Specifies the number of such disks."
    )
    disk_type: Optional[str] = Field(
        None,
        alias="diskType",
        description="Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.",
    )
    disk_size_gb: Optional[int] = Field(
        None,
        alias="diskSizeGb",
        description="Specifies the size of the disk in base-2 GB.",
    )


class Type12(Enum):
    restart_node_on_any_server = "RESTART_NODE_ON_ANY_SERVER"
    restart_node_on_minimal_servers = "RESTART_NODE_ON_MINIMAL_SERVERS"
    server_binding_type_unspecified = "SERVER_BINDING_TYPE_UNSPECIFIED"


class ServerBinding(BaseModel):
    type: Optional[Type12] = None


class NodeTemplateNodeTypeFlexibility(BaseModel):
    memory: Optional[str] = None
    cpus: Optional[str] = None
    local_ssd: Optional[str] = Field(None, alias="localSsd")


class Datum45(Datum2):
    pass


class Warning45(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum45]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class InstantiateFrom(Enum):
    attach_read_only = "ATTACH_READ_ONLY"
    blank = "BLANK"
    custom_image = "CUSTOM_IMAGE"
    default = "DEFAULT"
    do_not_include = "DO_NOT_INCLUDE"
    source_image = "SOURCE_IMAGE"
    source_image_family = "SOURCE_IMAGE_FAMILY"


class DiskInstantiationConfig(BaseModel):
    custom_image: Optional[str] = Field(
        None,
        alias="customImage",
        description="The custom source image to be used to restore this disk when instantiating this instance template.",
    )
    device_name: Optional[str] = Field(
        None,
        alias="deviceName",
        description="Specifies the device name of the disk to which the configurations apply to.",
    )
    instantiate_from: Optional[InstantiateFrom] = Field(
        None,
        alias="instantiateFrom",
        description="Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks. ",
    )
    auto_delete: Optional[bool] = Field(
        None,
        alias="autoDelete",
        description="Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).",
    )


class Action1(Enum):
    allow = "ALLOW"
    allow_with_log = "ALLOW_WITH_LOG"
    deny = "DENY"
    deny_with_log = "DENY_WITH_LOG"
    log = "LOG"
    no_action = "NO_ACTION"


class Sys(Enum):
    ip = "IP"
    name = "NAME"
    no_attr = "NO_ATTR"
    region = "REGION"
    service = "SERVICE"


class Op(Enum):
    discharged = "DISCHARGED"
    equals = "EQUALS"
    in_ = "IN"
    not_equals = "NOT_EQUALS"
    not_in = "NOT_IN"
    no_op = "NO_OP"


class Iam(Enum):
    approver = "APPROVER"
    attribution = "ATTRIBUTION"
    authority = "AUTHORITY"
    credentials_type = "CREDENTIALS_TYPE"
    creds_assertion = "CREDS_ASSERTION"
    justification_type = "JUSTIFICATION_TYPE"
    no_attr = "NO_ATTR"
    security_realm = "SECURITY_REALM"


class Condition(BaseModel):
    svc: Optional[str] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    sys: Optional[Sys] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    op: Optional[Op] = Field(None, description="This is deprecated and has no effect. Do not use.")
    values: Optional[List[str]] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    iam: Optional[Iam] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )


class LogName(Enum):
    admin_activity = "ADMIN_ACTIVITY"
    data_access = "DATA_ACCESS"
    unspecified_log_name = "UNSPECIFIED_LOG_NAME"


class PermissionType(Enum):
    admin_read = "ADMIN_READ"
    admin_write = "ADMIN_WRITE"
    data_read = "DATA_READ"
    data_write = "DATA_WRITE"
    permission_type_unspecified = "PERMISSION_TYPE_UNSPECIFIED"


class AuthorizationLoggingOptions(BaseModel):
    permission_type: Optional[PermissionType] = Field(
        None,
        alias="permissionType",
        description="This is deprecated and has no effect. Do not use.",
    )


class LogMode(Enum):
    log_fail_closed = "LOG_FAIL_CLOSED"
    log_mode_unspecified = "LOG_MODE_UNSPECIFIED"


class LogConfigDataAccessOptions(BaseModel):
    log_mode: Optional[LogMode] = Field(
        None,
        alias="logMode",
        description="This is deprecated and has no effect. Do not use.",
    )


class LogConfigCounterOptionsCustomField(BaseModel):
    value: Optional[str] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    name: Optional[str] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )


class StatefulPolicyPreservedState(BaseModel):
    disks: Optional[Dict[str, StatefulPolicyPreservedStateDiskDevice]] = Field(
        None,
        description="Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.",
    )


class Continent(Enum):
    africa = "AFRICA"
    asia_pac = "ASIA_PAC"
    c_africa = "C_AFRICA"
    c_asia_pac = "C_ASIA_PAC"
    c_europe = "C_EUROPE"
    c_north_america = "C_NORTH_AMERICA"
    c_south_america = "C_SOUTH_AMERICA"
    europe = "EUROPE"
    north_america = "NORTH_AMERICA"
    south_america = "SOUTH_AMERICA"


class Status21(Enum):
    available = "AVAILABLE"
    closed = "CLOSED"


class InterconnectLocation(BaseModel):
    continent: Optional[Continent] = Field(
        None,
        description="[Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA ",
    )
    description: Optional[str] = Field(
        None, description="[Output Only] An optional description of the resource."
    )
    city: Optional[str] = Field(
        None,
        description='[Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".',
    )
    facility_provider_facility_id: Optional[str] = Field(
        None,
        alias="facilityProviderFacilityId",
        description="[Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).",
    )
    region_infos: Optional[List[InterconnectLocationRegionInfo]] = Field(
        None,
        alias="regionInfos",
        description="[Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    address: Optional[str] = Field(
        None,
        description="[Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.",
    )
    availability_zone: Optional[str] = Field(
        None,
        alias="availabilityZone",
        description='[Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".',
    )
    peeringdb_facility_id: Optional[str] = Field(
        None,
        alias="peeringdbFacilityId",
        description="[Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).",
    )
    kind: Optional[str] = Field(
        "compute#interconnectLocation",
        description="[Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.",
    )
    supports_pzs: Optional[bool] = Field(
        None,
        alias="supportsPzs",
        description="[Output Only] Set to true for locations that support physical zone separation. Defaults to false if the field is not present.",
    )
    facility_provider: Optional[str] = Field(
        None,
        alias="facilityProvider",
        description="[Output Only] The name of the provider for this facility (e.g., EQUINIX).",
    )
    name: Optional[str] = Field(None, description="[Output Only] Name of the resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    status: Optional[Status21] = Field(
        None,
        description="[Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects. ",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )


class State6(Enum):
    disabled = "DISABLED"
    enabled = "ENABLED"
    restricted = "RESTRICTED"
    state_unspecified = "STATE_UNSPECIFIED"
    terminated = "TERMINATED"


class LicenseCodeLicenseAlias(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] URL of license corresponding to this License Code.",
    )
    description: Optional[str] = Field(
        None, description="[Output Only] Description of this License Code."
    )


class NodeGroupsAddNodesRequest(BaseModel):
    additional_node_count: Optional[int] = Field(
        None,
        alias="additionalNodeCount",
        description="Count of additional nodes to be added to the node group.",
    )


class BulkInsertInstanceResourcePerInstanceProperties(BaseModel):
    name: Optional[str] = Field(
        None,
        description="This field is only temporary. It will be removed. Do not use it.",
    )


class ProjectsListXpnHostsRequest(BaseModel):
    organization: Optional[str] = Field(
        None,
        description="Optional organization ID managed by Cloud Resource Manager, for which to list shared VPC host projects. If not specified, the organization will be inferred from the project.",
    )


class TargetShape(Enum):
    any = "ANY"
    any_single_zone = "ANY_SINGLE_ZONE"
    balanced = "BALANCED"


class Preference(Enum):
    allow = "ALLOW"
    deny = "DENY"
    preference_unspecified = "PREFERENCE_UNSPECIFIED"


class LocationPolicyLocation(BaseModel):
    preference: Optional[Preference] = Field(None, description="Preference for a given location.")


class Datum46(Datum2):
    pass


class Warning46(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum46]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class TargetHttpProxy(BaseModel):
    proxy_bind: Optional[bool] = Field(
        None,
        alias="proxyBind",
        description="This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies set up inbound traffic interception and bind to the IP address and port specified in the forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for inbound requests and handles requests when it receives them. The default is false.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional Target HTTP Proxy resides. This field is not applicable to global Target HTTP Proxies.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the TargetHttpProxy.",
    )
    url_map: Optional[str] = Field(
        None,
        alias="urlMap",
        description="URL to the UrlMap resource that defines the mapping from URL to the BackendService.",
    )
    kind: Optional[str] = Field(
        "compute#targetHttpProxy",
        description="[Output Only] Type of resource. Always compute#targetHttpProxy for target HTTP proxies.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class Datum47(Datum):
    pass


class Warning47(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum47]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum48(Datum2):
    pass


class Warning48(BaseModel):
    data: Optional[List[Datum48]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum49(Datum2):
    pass


class Warning49(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum49]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class TargetHttpsProxyList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[TargetHttpsProxy]] = Field(
        None, description="A list of TargetHttpsProxy resources."
    )
    warning: Optional[Warning49] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#targetHttpsProxyList",
        description="Type of resource. Always compute#targetHttpsProxyList for lists of target HTTPS proxies.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class AuditConfig(BaseModel):
    audit_log_configs: Optional[List[AuditLogConfig]] = Field(
        None,
        alias="auditLogConfigs",
        description="The configuration for logging of each type of permission.",
    )
    exempted_members: Optional[List[str]] = Field(
        None,
        alias="exemptedMembers",
        description="This is deprecated and has no effect. Do not use.",
    )
    service: Optional[str] = Field(
        None,
        description="Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.",
    )


class InstancesAddResourcePoliciesRequest(BaseModel):
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies to be added to this instance.",
    )


class Datum50(Datum2):
    pass


class Warning50(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum50]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class AggregationInterval(Enum):
    interval_10_min = "INTERVAL_10_MIN"
    interval_15_min = "INTERVAL_15_MIN"
    interval_1_min = "INTERVAL_1_MIN"
    interval_30_sec = "INTERVAL_30_SEC"
    interval_5_min = "INTERVAL_5_MIN"
    interval_5_sec = "INTERVAL_5_SEC"


class Metadata1(Enum):
    custom_metadata = "CUSTOM_METADATA"
    exclude_all_metadata = "EXCLUDE_ALL_METADATA"
    include_all_metadata = "INCLUDE_ALL_METADATA"


class SubnetworkLogConfig(BaseModel):
    flow_sampling: Optional[float] = Field(
        None,
        alias="flowSampling",
        description="Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.",
    )
    aggregation_interval: Optional[AggregationInterval] = Field(
        None,
        alias="aggregationInterval",
        description="Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.",
    )
    enable: Optional[bool] = Field(
        None,
        description="Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled.",
    )
    metadata: Optional[Metadata1] = Field(
        None,
        description="Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.",
    )
    filter_expr: Optional[str] = Field(
        None,
        alias="filterExpr",
        description="Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.",
    )
    metadata_fields: Optional[List[str]] = Field(
        None,
        alias="metadataFields",
        description='Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.',
    )


class Datum51(Datum):
    pass


class Warning51(BaseModel):
    data: Optional[List[Datum51]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum52(Datum):
    pass


class Warning52(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum52]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class IpProtocol(Enum):
    ah = "AH"
    esp = "ESP"
    icmp = "ICMP"
    l3_default = "L3_DEFAULT"
    sctp = "SCTP"
    tcp = "TCP"
    udp = "UDP"


class LoadBalancingScheme2(Enum):
    external = "EXTERNAL"
    external_managed = "EXTERNAL_MANAGED"
    internal = "INTERNAL"
    internal_managed = "INTERNAL_MANAGED"
    internal_self_managed = "INTERNAL_SELF_MANAGED"
    invalid = "INVALID"


class ForwardingRuleServiceDirectoryRegistration(BaseModel):
    service: Optional[str] = Field(
        None,
        description="Service Directory service to register the forwarding rule under.",
    )
    namespace: Optional[str] = Field(
        None,
        description="Service Directory namespace to register the forwarding rule under.",
    )
    service_directory_region: Optional[str] = Field(
        None,
        alias="serviceDirectoryRegion",
        description='[Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.',
    )


class TargetTcpProxiesSetBackendServiceRequest(BaseModel):
    service: Optional[str] = Field(
        None,
        description="The URL of the new BackendService resource for the targetTcpProxy.",
    )


class State7(Enum):
    draining = "DRAINING"
    ready = "READY"


class Role(Enum):
    active = "ACTIVE"
    backup = "BACKUP"


class PrivateIpv6GoogleAccess2(Enum):
    disable_google_access = "DISABLE_GOOGLE_ACCESS"
    enable_bidirectional_access_to_google = "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE"
    enable_outbound_vm_access_to_google = "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE"


class Purpose1(Enum):
    internal_https_load_balancer = "INTERNAL_HTTPS_LOAD_BALANCER"
    private = "PRIVATE"
    private_rfc_1918 = "PRIVATE_RFC_1918"
    private_service_connect = "PRIVATE_SERVICE_CONNECT"
    regional_managed_proxy = "REGIONAL_MANAGED_PROXY"


class SubnetworkSecondaryRange(BaseModel):
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported. The range can be any range listed in the Valid ranges list.",
    )
    range_name: Optional[str] = Field(
        None,
        alias="rangeName",
        description="The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.",
    )


class Datum53(Datum2):
    pass


class Warning53(BaseModel):
    data: Optional[List[Datum53]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Error2(BaseModel):
    location: Optional[str] = Field(
        None,
        description="[Output Only] Indicates the field in the request that caused the error. This property is optional.",
    )
    message: Optional[str] = Field(
        None, description="[Output Only] An optional, human-readable error message."
    )
    code: Optional[str] = Field(
        None, description="[Output Only] The error type identifier for this error."
    )


class Errors(BaseModel):
    errors: Optional[List[Error2]] = Field(
        None,
        description="[Output Only] The array of errors encountered while processing this operation.",
    )


class ManagedInstanceLastAttempt(BaseModel):
    errors: Optional[Errors] = Field(
        None,
        description="[Output Only] Encountered errors during the last attempt to create or delete the instance.",
    )


class DetailedHealthState(Enum):
    draining = "DRAINING"
    healthy = "HEALTHY"
    timeout = "TIMEOUT"
    unhealthy = "UNHEALTHY"
    unknown = "UNKNOWN"


class ManagedInstanceInstanceHealth(BaseModel):
    detailed_health_state: Optional[DetailedHealthState] = Field(
        None,
        alias="detailedHealthState",
        description="[Output Only] The current detailed instance health state.",
    )
    health_check: Optional[str] = Field(
        None,
        alias="healthCheck",
        description="[Output Only] The URL for the health check that verifies whether the instance is healthy.",
    )


class Datum54(Datum):
    pass


class Warning54(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum54]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class NetworkFirewallPolicyEnforcementOrder(Enum):
    after_classic_firewall = "AFTER_CLASSIC_FIREWALL"
    before_classic_firewall = "BEFORE_CLASSIC_FIREWALL"


class NetworkPeering(BaseModel):
    peer_mtu: Optional[int] = Field(
        None, alias="peerMtu", description="Maximum Transmission Unit in bytes."
    )
    auto_create_routes: Optional[bool] = Field(
        None,
        alias="autoCreateRoutes",
        description="This field will be deprecated soon. Use the exchange_subnet_routes field instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of this peering. Provided by the client when the peering is created. The name must comply with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all the following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    export_custom_routes: Optional[bool] = Field(
        None,
        alias="exportCustomRoutes",
        description="Whether to export the custom routes to peer network. The default value is false.",
    )
    export_subnet_routes_with_public_ip: Optional[bool] = Field(
        None,
        alias="exportSubnetRoutesWithPublicIp",
        description="Whether subnet routes with public IP range are exported. The default value is true, all subnet routes are exported. IPv4 special-use ranges are always exported to peers and are not controlled by this field.",
    )
    import_subnet_routes_with_public_ip: Optional[bool] = Field(
        None,
        alias="importSubnetRoutesWithPublicIp",
        description="Whether subnet routes with public IP range are imported. The default value is false. IPv4 special-use ranges are always imported from peers and are not controlled by this field.",
    )
    state_details: Optional[str] = Field(
        None,
        alias="stateDetails",
        description="[Output Only] Details about the current state of the peering.",
    )
    stack_type: Optional[StackType] = Field(
        None,
        alias="stackType",
        description="Which IP version(s) of traffic and routes are allowed to be imported or exported between peer networks. The default value is IPV4_ONLY.",
    )
    import_custom_routes: Optional[bool] = Field(
        None,
        alias="importCustomRoutes",
        description="Whether to import the custom routes from peer network. The default value is false.",
    )
    network: Optional[str] = Field(
        None,
        description="The URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.",
    )
    state: Optional[Status15] = Field(
        None,
        description="[Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.",
    )
    exchange_subnet_routes: Optional[bool] = Field(
        None,
        alias="exchangeSubnetRoutes",
        description="Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.",
    )


class Datum55(Datum2):
    pass


class Warning55(BaseModel):
    data: Optional[List[Datum55]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum56(Datum2):
    pass


class Warning56(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum56]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class InstanceGroupManagerActionsSummary(BaseModel):
    creating_without_retries: Optional[int] = Field(
        None,
        alias="creatingWithoutRetries",
        description="[Output Only] The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group's targetSize value accordingly.",
    )
    stopping: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be stopped or are currently being stopped.",
    )
    none: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are running and have no scheduled actions.",
    )
    resuming: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be resumed or are currently being resumed.",
    )
    creating: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully. If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.",
    )
    refreshing: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.",
    )
    verifying: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.",
    )
    deleting: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.",
    )
    starting: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be started or are currently being started.",
    )
    abandoning: Optional[int] = Field(
        None,
        description="[Output Only] The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.",
    )
    recreating: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.",
    )
    restarting: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.",
    )
    suspending: Optional[int] = Field(
        None,
        description="[Output Only] The number of instances in the managed instance group that are scheduled to be suspended or are currently being suspended.",
    )


class Datum57(Datum2):
    pass


class Warning57(BaseModel):
    data: Optional[List[Datum57]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status22(Enum):
    creating = "CREATING"
    deleting = "DELETING"
    invalid = "INVALID"
    ready = "READY"
    repairing = "REPAIRING"


class NodeGroupNode(BaseModel):
    cpu_overcommit_type: Optional[CpuOvercommitType] = Field(
        None, alias="cpuOvercommitType", description="CPU overcommit."
    )
    accelerators: Optional[List[AcceleratorConfig]] = Field(
        None, description="Accelerators for this node."
    )
    disks: Optional[List[LocalDisk]] = Field(None, description="Local disk configurations.")
    status: Optional[Status22] = None
    node_type: Optional[str] = Field(None, alias="nodeType", description="The type of this node.")
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    name: Optional[str] = Field(None, description="The name of the node.")
    instances: Optional[List[str]] = Field(None, description="Instances scheduled on this node.")
    server_id: Optional[str] = Field(
        None, alias="serverId", description="Server ID associated with this node."
    )
    server_binding: Optional[ServerBinding] = Field(
        None,
        alias="serverBinding",
        description="Binding properties for the physical server.",
    )


class Datum58(Datum):
    pass


class Warning58(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum58]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum59(Datum):
    pass


class Warning59(BaseModel):
    data: Optional[List[Datum59]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum60(Datum):
    pass


class Warning60(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum60]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetVpnGatewaysScopedList(BaseModel):
    warning: Optional[Warning60] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of addresses when the list is empty.",
    )
    target_vpn_gateways: Optional[List[TargetVpnGateway]] = Field(
        None,
        alias="targetVpnGateways",
        description="[Output Only] A list of target VPN gateways contained in this scope.",
    )


class Direction(Enum):
    both = "BOTH"
    egress = "EGRESS"
    ingress = "INGRESS"


class PacketMirroringFilter(BaseModel):
    cidr_ranges: Optional[List[str]] = Field(
        None,
        alias="cidrRanges",
        description="IP CIDR ranges that apply as filter on the source (ingress) or destination (egress) IP in the IP header. Only IPv4 is supported. If no ranges are specified, all traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.",
    )
    direction: Optional[Direction] = Field(
        None,
        description="Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.",
    )
    ip_protocols: Optional[List[str]] = Field(
        None,
        alias="IPProtocols",
        description="Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.",
    )


class Datum61(Datum):
    pass


class Warning61(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum61]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum62(Datum2):
    pass


class Warning62(BaseModel):
    data: Optional[List[Datum62]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum63(Datum2):
    pass


class Warning63(BaseModel):
    data: Optional[List[Datum63]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetShape1(Enum):
    any = "ANY"
    balanced = "BALANCED"
    even = "EVEN"


class DistributionPolicyZoneConfiguration(BaseModel):
    zone: Optional[str] = Field(
        None,
        description="The URL of the zone. The zone must exist in the region where the managed instance group is located.",
    )


class ReplacementMethod(Enum):
    recreate = "RECREATE"
    substitute = "SUBSTITUTE"


class MinimalAction(Enum):
    none = "NONE"
    refresh = "REFRESH"
    replace = "REPLACE"
    restart = "RESTART"


class Type13(Enum):
    opportunistic = "OPPORTUNISTIC"
    proactive = "PROACTIVE"


class InstanceRedistributionType(Enum):
    none = "NONE"
    proactive = "PROACTIVE"


class InstanceGroupManagerUpdatePolicy(BaseModel):
    replacement_method: Optional[ReplacementMethod] = Field(
        None,
        alias="replacementMethod",
        description="What action should be used to replace instances. See minimal_action.REPLACE",
    )
    minimal_action: Optional[MinimalAction] = Field(
        None,
        alias="minimalAction",
        description="Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes. ",
    )
    max_unavailable: Optional[FixedOrPercent] = Field(
        None,
        alias="maxUnavailable",
        description="The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.",
    )
    type: Optional[Type13] = Field(
        None,
        description="The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).",
    )
    max_surge: Optional[FixedOrPercent] = Field(
        None,
        alias="maxSurge",
        description="The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.",
    )
    most_disruptive_allowed_action: Optional[MinimalAction] = Field(
        None,
        alias="mostDisruptiveAllowedAction",
        description="Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.",
    )
    instance_redistribution_type: Optional[InstanceRedistributionType] = Field(
        None,
        alias="instanceRedistributionType",
        description="The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled. ",
    )


class InstanceGroupManagerVersion(BaseModel):
    target_size: Optional[FixedOrPercent] = Field(
        None,
        alias="targetSize",
        description="Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the version. Unique among all versions in the scope of this managed instance group.",
    )
    instance_template: Optional[str] = Field(
        None,
        alias="instanceTemplate",
        description="The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.",
    )


class StatefulPolicy(BaseModel):
    preserved_state: Optional[StatefulPolicyPreservedState] = Field(None, alias="preservedState")


class InstanceGroupManagerAutoHealingPolicy(BaseModel):
    health_check: Optional[str] = Field(
        None,
        alias="healthCheck",
        description="The URL for the health check that signals autohealing.",
    )
    initial_delay_sec: Optional[int] = Field(
        None,
        alias="initialDelaySec",
        description="The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].",
    )


class RegionInstanceGroupManagerDeleteInstanceConfigReq(BaseModel):
    names: Optional[List[str]] = Field(
        None,
        description="The list of instance names for which we want to delete per-instance configs on this managed instance group.",
    )


class TestPermissionsResponse(BaseModel):
    permissions: Optional[List[str]] = Field(
        None,
        description="A subset of `TestPermissionsRequest.permissions` that the caller is allowed.",
    )


class InstanceState(Enum):
    all = "ALL"
    running = "RUNNING"


class RegionInstanceGroupsListInstancesRequest(BaseModel):
    port_name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        alias="portName",
        description="Name of port user is interested in. It is optional. If it is set, only information about this ports will be returned. If it is not set, all the named ports will be returned. Always lists all instances.",
    )
    instance_state: Optional[InstanceState] = Field(
        None,
        alias="instanceState",
        description="Instances in which state should be returned. Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.",
    )


class Datum64(Datum2):
    pass


class Warning64(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum64]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum65(Datum2):
    pass


class Warning65(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum65]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class State9(Enum):
    high_alarm = "HIGH_ALARM"
    high_warning = "HIGH_WARNING"
    low_alarm = "LOW_ALARM"
    low_warning = "LOW_WARNING"
    ok = "OK"


class InterconnectDiagnosticsLinkOpticalPower(BaseModel):
    state: Optional[State9] = Field(
        None,
        description="The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning threshold. - LOW_WARNING: The value has crossed below the low warning threshold. - HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high alarm threshold. ",
    )
    value: Optional[float] = Field(
        None,
        description="Value of the current receiving or transmitting optical power, read in dBm. Take a known good optical value, give it a 10% margin and trigger warnings relative to that value. In general, a -7dBm warning and a -11dBm alarm are good optical value estimates for most links.",
    )


class State10(Enum):
    active = "ACTIVE"
    detached = "DETACHED"


class InterconnectDiagnosticsLinkLacpStatus(BaseModel):
    google_system_id: Optional[str] = Field(
        None,
        alias="googleSystemId",
        description="System ID of the port on Google's side of the LACP exchange.",
    )
    neighbor_system_id: Optional[str] = Field(
        None,
        alias="neighborSystemId",
        description="System ID of the port on the neighbor's side of the LACP exchange.",
    )
    state: Optional[State10] = Field(
        None,
        description="The state of a LACP link, which can take one of the following values: - ACTIVE: The link is configured and active within the bundle. - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty. ",
    )


class InterconnectDiagnosticsArpEntry(BaseModel):
    ip_address: Optional[str] = Field(
        None, alias="ipAddress", description="The IP address of this ARP neighbor."
    )
    mac_address: Optional[str] = Field(
        None, alias="macAddress", description="The MAC address of this ARP neighbor."
    )


class RegionInstanceGroupManagersApplyUpdatesRequest(BaseModel):
    all_instances: Optional[bool] = Field(
        None,
        alias="allInstances",
        description="Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.",
    )
    instances: Optional[List[str]] = Field(
        None,
        description="The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )
    minimal_action: Optional[MinimalAction] = Field(
        None,
        alias="minimalAction",
        description="The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.",
    )
    most_disruptive_allowed_action: Optional[MinimalAction] = Field(
        None,
        alias="mostDisruptiveAllowedAction",
        description="The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.",
    )


class Screenshot(BaseModel):
    kind: Optional[str] = Field(
        "compute#screenshot",
        description="[Output Only] Type of the resource. Always compute#screenshot for the screenshots.",
    )
    contents: Optional[str] = Field(
        None, description="[Output Only] The Base64-encoded screenshot data."
    )


class Datum66(Datum):
    pass


class Warning66(BaseModel):
    data: Optional[List[Datum66]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class VpnGatewayVpnGatewayInterface(BaseModel):
    interconnect_attachment: Optional[str] = Field(
        None,
        alias="interconnectAttachment",
        description="URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface. When the value of this field is present, the VPN gateway is used for IPsec-encrypted Cloud Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the specified VLAN attachment resource. Not currently available publicly. ",
    )
    id: Optional[int] = Field(
        None,
        description="[Output Only] Numeric identifier for this VPN interface associated with the VPN gateway.",
    )
    ip_address: Optional[str] = Field(
        None,
        alias="ipAddress",
        description="[Output Only] IP address for this VPN interface associated with the VPN gateway. The IP address could be either a regional external IP address or a regional internal IP address. The two IP addresses for a VPN gateway must be all regional external or regional internal IP addresses. There cannot be a mix of regional external IP addresses and regional internal IP addresses. For IPsec-encrypted Cloud Interconnect, the IP addresses for both interfaces could either be regional internal IP addresses or regional external IP addresses. For regular (non IPsec-encrypted Cloud Interconnect) HA VPN tunnels, the IP address must be a regional external IP address.",
    )


class Datum67(Datum2):
    pass


class Warning67(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum67]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum68(Datum2):
    pass


class Warning68(BaseModel):
    data: Optional[List[Datum68]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Direction1(Enum):
    egress = "EGRESS"
    ingress = "INGRESS"


class FirewallPolicyRuleMatcher(BaseModel):
    layer4_configs: Optional[List[FirewallPolicyRuleMatcherLayer4Config]] = Field(
        None,
        alias="layer4Configs",
        description="Pairs of IP protocols and ports that the rule should match.",
    )
    dest_ip_ranges: Optional[List[str]] = Field(
        None,
        alias="destIpRanges",
        description="CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.",
    )
    src_ip_ranges: Optional[List[str]] = Field(
        None,
        alias="srcIpRanges",
        description="CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.",
    )
    src_secure_tags: Optional[List[FirewallPolicyRuleSecureTag]] = Field(
        None,
        alias="srcSecureTags",
        description="List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.",
    )


class Datum69(Datum2):
    pass


class Warning69(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum69]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum70(Datum2):
    pass


class Warning70(BaseModel):
    data: Optional[List[Datum70]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class PacketMirroringForwardingRuleInfo(BaseModel):
    url: Optional[str] = Field(
        None,
        description="Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.",
    )
    canonical_url: Optional[str] = Field(
        None,
        alias="canonicalUrl",
        description="[Output Only] Unique identifier for the forwarding rule; defined by the server.",
    )


class PacketMirroringMirroredResourceInfoInstanceInfo(BaseModel):
    url: Optional[str] = Field(
        None,
        description="Resource URL to the virtual machine instance which is being mirrored.",
    )
    canonical_url: Optional[str] = Field(
        None,
        alias="canonicalUrl",
        description="[Output Only] Unique identifier for the instance; defined by the server.",
    )


class PacketMirroringNetworkInfo(BaseModel):
    url: Optional[str] = Field(None, description="URL of the network resource.")
    canonical_url: Optional[str] = Field(
        None,
        alias="canonicalUrl",
        description="[Output Only] Unique identifier for the network; defined by the server.",
    )


class State11(Enum):
    admin_down = "ADMIN_DOWN"
    down = "DOWN"
    init = "INIT"
    state_unspecified = "STATE_UNSPECIFIED"
    up = "UP"


class Diagnostic(Enum):
    administratively_down = "ADMINISTRATIVELY_DOWN"
    concatenated_path_down = "CONCATENATED_PATH_DOWN"
    control_detection_time_expired = "CONTROL_DETECTION_TIME_EXPIRED"
    diagnostic_unspecified = "DIAGNOSTIC_UNSPECIFIED"
    echo_function_failed = "ECHO_FUNCTION_FAILED"
    forwarding_plane_reset = "FORWARDING_PLANE_RESET"
    neighbor_signaled_session_down = "NEIGHBOR_SIGNALED_SESSION_DOWN"
    no_diagnostic = "NO_DIAGNOSTIC"
    path_down = "PATH_DOWN"
    reverse_concatenated_path_down = "REVERSE_CONCATENATED_PATH_DOWN"


class BfdPacket(BaseModel):
    authentication_present: Optional[bool] = Field(
        None,
        alias="authenticationPresent",
        description="The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    my_discriminator: Optional[int] = Field(
        None,
        alias="myDiscriminator",
        description="The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    length: Optional[int] = Field(
        None,
        description="The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880",
    )
    state: Optional[State11] = Field(
        None,
        description="The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880",
    )
    your_discriminator: Optional[int] = Field(
        None,
        alias="yourDiscriminator",
        description="The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    min_echo_rx_interval_ms: Optional[int] = Field(
        None,
        alias="minEchoRxIntervalMs",
        description="The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    min_tx_interval_ms: Optional[int] = Field(
        None,
        alias="minTxIntervalMs",
        description="The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    version: Optional[int] = Field(
        None,
        description="The version number of the BFD protocol, as specified in section 4.1 of RFC5880.",
    )
    multipoint: Optional[bool] = Field(
        None,
        description="The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    control_plane_independent: Optional[bool] = Field(
        None,
        alias="controlPlaneIndependent",
        description="The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    diagnostic: Optional[Diagnostic] = Field(
        None,
        description="The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880",
    )
    min_rx_interval_ms: Optional[int] = Field(
        None,
        alias="minRxIntervalMs",
        description="The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    demand: Optional[bool] = Field(
        None,
        description="The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    multiplier: Optional[int] = Field(
        None,
        description="The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    final: Optional[bool] = Field(
        None,
        description="The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880",
    )
    poll: Optional[bool] = Field(
        None,
        description="The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880",
    )


class Profile(Enum):
    compatible = "COMPATIBLE"
    custom = "CUSTOM"
    modern = "MODERN"
    restricted = "RESTRICTED"


class MinTlsVersion(Enum):
    tls_1_0 = "TLS_1_0"
    tls_1_1 = "TLS_1_1"
    tls_1_2 = "TLS_1_2"


class Datum71(Datum):
    pass


class Warning71(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum71]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class SslPolicy(BaseModel):
    kind: Optional[str] = Field(
        "compute#sslPolicy",
        description="[Output only] Type of the resource. Always compute#sslPolicyfor SSL policies.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    profile: Optional[Profile] = Field(
        None,
        description="Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients. This can be one of COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If using CUSTOM, the set of SSL features to enable must be specified in the customFeatures field.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a SslPolicy. An up-to-date fingerprint must be provided in order to update the SslPolicy, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an SslPolicy.",
    )
    custom_features: Optional[List[str]] = Field(
        None,
        alias="customFeatures",
        description="A list of features enabled when the selected profile is CUSTOM. The method returns the set of features that can be specified in this list. This field must be empty if the profile is not CUSTOM.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    min_tls_version: Optional[MinTlsVersion] = Field(
        None,
        alias="minTlsVersion",
        description="The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer. This can be one of TLS_1_0, TLS_1_1, TLS_1_2.",
    )
    warnings: Optional[List[Warning71]] = Field(
        None,
        description="[Output Only] If potential misconfigurations are detected for this SSL policy, this field will be populated with warning messages.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    enabled_features: Optional[List[str]] = Field(
        None,
        alias="enabledFeatures",
        description="[Output Only] The list of features enabled in the SSL policy.",
    )


class Datum72(Datum2):
    pass


class Warning72(BaseModel):
    data: Optional[List[Datum72]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum73(Datum):
    pass


class Warning73(BaseModel):
    data: Optional[List[Datum73]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class TargetPool(BaseModel):
    failover_ratio: Optional[float] = Field(
        None,
        alias="failoverRatio",
        description='This field is applicable only when the containing target pool is serving a forwarding rule as the primary pool (i.e., not as a backup pool to some other target pool). The value of the field must be in [0, 1]. If set, backupPool must also be set. They together define the fallback behavior of the primary target pool: if the ratio of the healthy instances in the primary pool is at or below this number, traffic arriving at the load-balanced IP will be directed to the backup pool. In case where failoverRatio is not set or all the instances in the backup pool are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where traffic will be spread to the healthy instances with the best effort, or to all instances when no instance is healthy.',
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the target pool resides.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    kind: Optional[str] = Field(
        "compute#targetPool",
        description="[Output Only] Type of the resource. Always compute#targetPool for target pools.",
    )
    health_checks: Optional[List[str]] = Field(
        None,
        alias="healthChecks",
        description="The URL of the HttpHealthCheck resource. A member instance in this pool is considered healthy if and only if the health checks pass. Only legacy HttpHealthChecks are supported. Only one health check may be specified.",
    )
    backup_pool: Optional[str] = Field(
        None,
        alias="backupPool",
        description='The server-defined URL for the resource. This field is applicable only when the containing target pool is serving a forwarding rule as the primary pool, and its failoverRatio field is properly set to a value between [0, 1]. backupPool and failoverRatio together define the fallback behavior of the primary target pool: if the ratio of the healthy instances in the primary pool is at or below failoverRatio, traffic arriving at the load-balanced IP will be directed to the backup pool. In case where failoverRatio and backupPool are not set, or all the instances in the backup pool are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where traffic will be spread to the healthy instances with the best effort, or to all instances when no instance is healthy.',
    )
    session_affinity: Optional[SessionAffinity] = Field(
        None,
        alias="sessionAffinity",
        description="Session affinity option, must be one of the following values: NONE: Connections from the same client IP may go to any instance in the pool. CLIENT_IP: Connections from the same client IP will go to the same instance in the pool while that instance remains healthy. CLIENT_IP_PROTO: Connections from the same client IP with the same IP protocol will go to the same instance in the pool while that instance remains healthy.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    instances: Optional[List[str]] = Field(
        None,
        description="A list of resource URLs to the virtual machine instances serving this pool. They must live in zones contained in the same region as this pool.",
    )


class Datum74(Datum):
    pass


class Warning74(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum74]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class ExternalVpnGatewayList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#externalVpnGatewayList",
        description="[Output Only] Type of resource. Always compute#externalVpnGatewayList for lists of externalVpnGateways.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    etag: Optional[str] = None
    warning: Optional[Warning74] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[ExternalVpnGateway]] = Field(
        None, description="A list of ExternalVpnGateway resources."
    )


class TargetPoolsAddInstanceRequest(BaseModel):
    instances: Optional[List[InstanceReference]] = Field(
        None,
        description="A full or partial URL to an instance to add to this target pool. This can be a full or partial URL. For example, the following are valid URLs: - https://www.googleapis.com/compute/v1/projects/project-id/zones/zone /instances/instance-name - projects/project-id/zones/zone/instances/instance-name - zones/zone/instances/instance-name ",
    )


class RegionSetLabelsRequest(BaseModel):
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None, description="The labels to set for this resource."
    )


class NetworksUpdatePeeringRequest(BaseModel):
    network_peering: Optional[NetworkPeering] = Field(None, alias="networkPeering")


class Datum75(Datum2):
    pass


class Warning75(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum75]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class AcceleratorType(BaseModel):
    maximum_cards_per_instance: Optional[int] = Field(
        None,
        alias="maximumCardsPerInstance",
        description="[Output Only] Maximum number of accelerator cards allowed per instance.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#acceleratorType",
        description="[Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined, fully qualified URL for this resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    deprecated: Optional[DeprecationStatus] = Field(
        None,
        description="[Output Only] The deprecation status associated with this accelerator type.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None, description="[Output Only] Name of the resource."
    )
    description: Optional[str] = Field(
        None,
        description="[Output Only] An optional textual description of the resource.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )


class TargetHttpsProxiesSetQuicOverrideRequest(BaseModel):
    quic_override: Optional[QuicOverride] = Field(
        None,
        alias="quicOverride",
        description="QUIC policy for the TargetHttpsProxy resource.",
    )


class Datum76(Datum2):
    pass


class Warning76(BaseModel):
    data: Optional[List[Datum76]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum77(Datum):
    pass


class Warning77(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum77]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class NetworkEdgeSecurityService(BaseModel):
    kind: Optional[str] = Field(
        "compute#networkEdgeSecurityService",
        description="[Output only] Type of the resource. Always compute#networkEdgeSecurityService for NetworkEdgeSecurityServices",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the resource resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    self_link_with_id: Optional[str] = Field(
        None,
        alias="selfLinkWithId",
        description="[Output Only] Server-defined URL for this resource with the resource id.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    security_policy: Optional[str] = Field(
        None,
        alias="securityPolicy",
        description="The resource URL for the network edge security service associated with this network edge security service.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a NetworkEdgeSecurityService. An up-to-date fingerprint must be provided in order to update the NetworkEdgeSecurityService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a NetworkEdgeSecurityService.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )


class CacheInvalidationRule(BaseModel):
    path: Optional[str] = None
    host: Optional[str] = Field(
        None,
        description="If set, this invalidation rule will only apply to requests with a Host header matching host.",
    )


class Datum78(Datum2):
    pass


class Warning78(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum78]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class WeightError(Enum):
    invalid_weight = "INVALID_WEIGHT"
    missing_weight = "MISSING_WEIGHT"
    unavailable_weight = "UNAVAILABLE_WEIGHT"
    weight_none = "WEIGHT_NONE"


class HealthState1(Enum):
    healthy = "HEALTHY"
    unhealthy = "UNHEALTHY"


class HealthStatus(BaseModel):
    weight_error: Optional[WeightError] = Field(None, alias="weightError")
    port: Optional[int] = Field(
        None,
        description="The named port of the instance group, not necessarily the port that is health-checked.",
    )
    forwarding_rule: Optional[str] = Field(
        None,
        alias="forwardingRule",
        description="URL of the forwarding rule associated with the health status of the instance.",
    )
    annotations: Optional[Dict[str, str]] = Field(
        None, description="Metadata defined as annotations for network endpoint."
    )
    instance: Optional[str] = Field(None, description="URL of the instance resource.")
    weight: Optional[str] = None
    ip_address: Optional[str] = Field(
        None,
        alias="ipAddress",
        description="For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.",
    )
    forwarding_rule_ip: Optional[str] = Field(
        None,
        alias="forwardingRuleIp",
        description="A forwarding rule IP address assigned to this instance.",
    )
    health_state: Optional[HealthState1] = Field(
        None, alias="healthState", description="Health state of the instance."
    )


class TargetPoolsRemoveInstanceRequest(BaseModel):
    instances: Optional[List[InstanceReference]] = Field(
        None, description="URLs of the instances to be removed from target pool."
    )


class Datum79(Datum2):
    pass


class Warning79(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum79]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Type14(Enum):
    hierarchy = "HIERARCHY"
    network = "NETWORK"
    network_regional = "NETWORK_REGIONAL"
    unspecified = "UNSPECIFIED"


class AllowedItem(BaseModel):
    ip_protocol: Optional[str] = Field(
        None,
        alias="IPProtocol",
        description="The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.",
    )
    ports: Optional[List[str]] = Field(
        None,
        description='An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].',
    )


class DeniedItem(AllowedItem):
    pass


class Metadata2(Enum):
    exclude_all_metadata = "EXCLUDE_ALL_METADATA"
    include_all_metadata = "INCLUDE_ALL_METADATA"


class FirewallLogConfig(BaseModel):
    metadata: Optional[Metadata2] = Field(
        None,
        description="This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.",
    )
    enable: Optional[bool] = Field(
        None,
        description="This field denotes whether to enable logging for a particular firewall rule.",
    )


class CustomerEncryptionKeyProtectedDisk(BaseModel):
    source: Optional[str] = Field(
        None,
        description='Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks. For example: "source": "/compute/v1/projects/project_id/zones/zone/disks/ disk_name ',
    )
    disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="diskEncryptionKey",
        description="Decrypts data associated with the disk with a customer-supplied encryption key.",
    )


class Type15(Enum):
    hierarchy = "HIERARCHY"
    network = "NETWORK"
    unspecified = "UNSPECIFIED"


class Datum80(Datum):
    pass


class Warning80(BaseModel):
    data: Optional[List[Datum80]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Status23(Enum):
    down = "DOWN"
    unknown = "UNKNOWN"
    up = "UP"


class Duration1(Enum):
    duration_unspecified = "DURATION_UNSPECIFIED"
    hour = "HOUR"
    max = "MAX"
    minute = "MINUTE"


class Type16(Enum):
    loopback = "LOOPBACK"
    receive = "RECEIVE"
    transmit = "TRANSMIT"
    type_unspecified = "TYPE_UNSPECIFIED"


class PacketIntervals(BaseModel):
    duration: Optional[Duration1] = Field(
        None, description="From how long ago in the past these intervals were observed."
    )
    type: Optional[Type16] = Field(
        None,
        description="The type of packets for which inter-packet intervals were computed.",
    )
    num_intervals: Optional[str] = Field(
        None,
        alias="numIntervals",
        description="Number of inter-packet intervals from which these statistics were derived.",
    )
    min_ms: Optional[str] = Field(
        None,
        alias="minMs",
        description="Minimum observed inter-packet interval in milliseconds.",
    )
    max_ms: Optional[str] = Field(
        None,
        alias="maxMs",
        description="Maximum observed inter-packet interval in milliseconds.",
    )
    avg_ms: Optional[str] = Field(
        None,
        alias="avgMs",
        description="Average observed inter-packet interval in milliseconds.",
    )


class RouterStatusNatStatusNatRuleStatus(BaseModel):
    num_vm_endpoints_with_nat_mappings: Optional[int] = Field(
        None,
        alias="numVmEndpointsWithNatMappings",
        description="Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.",
    )
    rule_number: Optional[int] = Field(
        None, alias="ruleNumber", description="Rule number of the rule."
    )
    min_extra_ips_needed: Optional[int] = Field(
        None,
        alias="minExtraIpsNeeded",
        description="The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.",
    )
    active_nat_ips: Optional[List[str]] = Field(
        None,
        alias="activeNatIps",
        description='A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].',
    )
    drain_nat_ips: Optional[List[str]] = Field(
        None,
        alias="drainNatIps",
        description='A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].',
    )


class Datum81(Datum):
    pass


class Warning81(BaseModel):
    data: Optional[List[Datum81]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class InstanceGroupsListInstances(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning81] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[InstanceWithNamedPorts]] = Field(
        None, description="A list of InstanceWithNamedPorts resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#instanceGroupsListInstances",
        description="[Output Only] The resource type, which is always compute#instanceGroupsListInstances for the list of instances in the specified instance group.",
    )


class Datum82(Datum):
    pass


class Warning82(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum82]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Status24(Enum):
    down = "DOWN"
    up = "UP"


class Region(BaseModel):
    description: Optional[str] = Field(
        None, description="[Output Only] Textual description of the resource."
    )
    deprecated: Optional[DeprecationStatus] = Field(
        None,
        description="[Output Only] The deprecation status associated with this region.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    name: Optional[str] = Field(None, description="[Output Only] Name of the resource.")
    status: Optional[Status24] = Field(
        None, description="[Output Only] Status of the region, either UP or DOWN."
    )
    supports_pzs: Optional[bool] = Field(
        None, alias="supportsPzs", description="[Output Only] Reserved for future use."
    )
    quotas: Optional[List[Quota]] = Field(
        None, description="[Output Only] Quotas assigned to this region."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    kind: Optional[str] = Field(
        "compute#region",
        description="[Output Only] Type of the resource. Always compute#region for regions.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    zones: Optional[List[str]] = Field(
        None,
        description="[Output Only] A list of zones available in this region, in the form of resource URLs.",
    )


class InstanceGroupsListInstancesRequest(BaseModel):
    instance_state: Optional[InstanceState] = Field(
        None,
        alias="instanceState",
        description="A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.",
    )


class RegionInstanceGroupManagersSetTemplateRequest(BaseModel):
    instance_template: Optional[str] = Field(
        None,
        alias="instanceTemplate",
        description="URL of the InstanceTemplate resource from which all new instances will be created.",
    )


class InstancesSetMachineTypeRequest(BaseModel):
    machine_type: Optional[str] = Field(
        None,
        alias="machineType",
        description="Full or partial URL of the machine type resource. See Machine Types for a full list of machine types. For example: zones/us-central1-f/machineTypes/n1-standard-1",
    )


class Datum83(Datum2):
    pass


class Warning83(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum83]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class DisksScopedList(BaseModel):
    warning: Optional[Warning83] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of disks when the list is empty.",
    )
    disks: Optional[List[Disk]] = Field(
        None, description="[Output Only] A list of disks contained in this scope."
    )


class GuestAttributesEntry(BaseModel):
    value: Optional[str] = Field(None, description="Value for the guest attribute entry.")
    key: Optional[str] = Field(None, description="Key for the guest attribute entry.")
    namespace: Optional[str] = Field(None, description="Namespace for the guest attribute entry.")


class Datum84(Datum2):
    pass


class Warning84(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum84]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class SslPolicyReference(BaseModel):
    ssl_policy: Optional[str] = Field(
        None,
        alias="sslPolicy",
        description="URL of the SSL policy resource. Set this to empty string to clear any existing SSL policy associated with the target proxy resource.",
    )


class Datum85(Datum):
    pass


class Warning85(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum85]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class DisksAddResourcePoliciesRequest(BaseModel):
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Full or relative path to the resource policy to be added to this disk. You can only specify one resource policy.",
    )


class Datum86(Datum2):
    pass


class Warning86(BaseModel):
    data: Optional[List[Datum86]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class InterconnectLocationList(BaseModel):
    kind: Optional[str] = Field(
        "compute#interconnectLocationList",
        description="[Output Only] Type of resource. Always compute#interconnectLocationList for lists of interconnect locations.",
    )
    items: Optional[List[InterconnectLocation]] = Field(
        None, description="A list of InterconnectLocation resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning86] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class SslCertificateSelfManagedSslCertificate(BaseModel):
    certificate: Optional[str] = Field(
        None,
        description="A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.",
    )
    private_key: Optional[str] = Field(
        None,
        alias="privateKey",
        description="A write-only private key in PEM format. Only insert requests will include this field.",
    )


class Datum87(Datum2):
    pass


class Warning87(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum87]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class TargetHttpsProxiesScopedList(BaseModel):
    warning: Optional[Warning87] = Field(
        None,
        description="Informational warning which replaces the list of backend services when the list is empty.",
    )
    target_https_proxies: Optional[List[TargetHttpsProxy]] = Field(
        None,
        alias="targetHttpsProxies",
        description="A list of TargetHttpsProxies contained in this scope.",
    )


class InstancesSetMinCpuPlatformRequest(BaseModel):
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description="Minimum cpu/platform this instance should be started at.",
    )


class Datum88(Datum):
    pass


class Warning88(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum88]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum89(Datum):
    pass


class Warning89(BaseModel):
    data: Optional[List[Datum89]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Type18(Enum):
    managed = "MANAGED"
    self_managed = "SELF_MANAGED"
    type_unspecified = "TYPE_UNSPECIFIED"


class Status25(Enum):
    active = "ACTIVE"
    managed_certificate_status_unspecified = "MANAGED_CERTIFICATE_STATUS_UNSPECIFIED"
    provisioning = "PROVISIONING"
    provisioning_failed = "PROVISIONING_FAILED"
    provisioning_failed_permanently = "PROVISIONING_FAILED_PERMANENTLY"
    renewal_failed = "RENEWAL_FAILED"


class DomainStatus(Enum):
    active = "ACTIVE"
    domain_status_unspecified = "DOMAIN_STATUS_UNSPECIFIED"
    failed_caa_checking = "FAILED_CAA_CHECKING"
    failed_caa_forbidden = "FAILED_CAA_FORBIDDEN"
    failed_not_visible = "FAILED_NOT_VISIBLE"
    failed_rate_limited = "FAILED_RATE_LIMITED"
    provisioning = "PROVISIONING"


class SslCertificateManagedSslCertificate(BaseModel):
    status: Optional[Status25] = Field(
        None, description="[Output only] Status of the managed certificate resource."
    )
    domain_status: Optional[Dict[str, DomainStatus]] = Field(
        None,
        alias="domainStatus",
        description="[Output only] Detailed statuses of the domains specified for managed certificate resource.",
    )
    domains: Optional[List[str]] = Field(
        None,
        description="The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).",
    )


class Datum90(Datum):
    pass


class Warning90(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum90]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum91(Datum2):
    pass


class Warning91(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum91]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class InstanceGroupManagersApplyUpdatesRequest(BaseModel):
    all_instances: Optional[bool] = Field(
        None,
        alias="allInstances",
        description="Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.",
    )
    minimal_action: Optional[MinimalAction] = Field(
        None,
        alias="minimalAction",
        description="The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.",
    )
    most_disruptive_allowed_action: Optional[MinimalAction] = Field(
        None,
        alias="mostDisruptiveAllowedAction",
        description="The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.",
    )
    instances: Optional[List[str]] = Field(
        None,
        description="The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )


class Datum92(Datum2):
    pass


class Warning92(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum92]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class TargetPoolList(BaseModel):
    items: Optional[List[TargetPool]] = Field(None, description="A list of TargetPool resources.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#targetPoolList",
        description="[Output Only] Type of resource. Always compute#targetPoolList for lists of target pools.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning92] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class Datum93(Datum2):
    pass


class Warning93(BaseModel):
    data: Optional[List[Datum93]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum94(Datum):
    pass


class Warning94(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum94]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class TestPermissionsRequest(BaseModel):
    permissions: Optional[List[str]] = Field(
        None,
        description="The set of permissions to check for the 'resource'. Permissions with wildcards (such as '*' or 'storage.*') are not allowed.",
    )


class Datum95(Datum2):
    pass


class Warning95(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum95]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class InstanceMoveRequest(BaseModel):
    destination_zone: Optional[str] = Field(
        None,
        alias="destinationZone",
        description="The URL of the destination zone to move the instance. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - https://www.googleapis.com/compute/v1/projects/project/zones/zone - projects/project/zones/zone - zones/zone ",
    )
    target_instance: Optional[str] = Field(
        None,
        alias="targetInstance",
        description="The URL of the target instance to move. This can be a full or partial URL. For example, the following are all valid URLs to an instance: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance - zones/zone/instances/instance ",
    )


class Datum96(Datum):
    pass


class Warning96(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum96]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class SslPoliciesList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[SslPolicy]] = Field(None, description="A list of SslPolicy resources.")
    kind: Optional[str] = Field(
        "compute#sslPoliciesList",
        description="[Output Only] Type of the resource. Always compute#sslPoliciesList for lists of sslPolicies.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning96] = Field(
        None, description="[Output Only] Informational warning message."
    )


class Datum97(Datum):
    pass


class Warning97(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum97]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class InstanceGroupsRemoveInstancesRequest(BaseModel):
    instances: Optional[List[InstanceReference]] = Field(
        None, description="The list of instances to remove from the instance group."
    )


class Datum98(Datum2):
    pass


class Warning98(BaseModel):
    data: Optional[List[Datum98]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum99(Datum):
    pass


class Warning99(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum99]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class NatPolicy(Enum):
    no_nat = "NO_NAT"


class TargetInstance(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    instance: Optional[str] = Field(
        None,
        description="A URL to the virtual machine instance that handles traffic for this target instance. When creating a target instance, you can provide the fully-qualified URL or a valid partial URL to the desired virtual machine. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance - zones/zone/instances/instance ",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    nat_policy: Optional[NatPolicy] = Field(
        None,
        alias="natPolicy",
        description="NAT option controlling how IPs are NAT'ed to the instance. Currently only NO_NAT (default value) is supported.",
    )
    network: Optional[str] = Field(
        None,
        description="The URL of the network this target instance uses to forward traffic. If not specified, the traffic will be forwarded to the network that the default network interface belongs to.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    kind: Optional[str] = Field(
        "compute#targetInstance",
        description="[Output Only] The type of the resource. Always compute#targetInstance for target instances.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] URL of the zone where the target instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )


class Datum100(Datum):
    pass


class Warning100(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum100]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class State12(Enum):
    active = "ACTIVE"
    unprovisioned = "UNPROVISIONED"


class LinkType(Enum):
    link_type_ethernet_100_g_lr = "LINK_TYPE_ETHERNET_100G_LR"
    link_type_ethernet_10_g_lr = "LINK_TYPE_ETHERNET_10G_LR"


class InterconnectType(Enum):
    dedicated = "DEDICATED"
    it_private = "IT_PRIVATE"
    partner = "PARTNER"


class InterconnectCircuitInfo(BaseModel):
    google_circuit_id: Optional[str] = Field(
        None,
        alias="googleCircuitId",
        description="Google-assigned unique ID for this circuit. Assigned at circuit turn-up.",
    )
    google_demarc_id: Optional[str] = Field(
        None,
        alias="googleDemarcId",
        description="Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.",
    )
    customer_demarc_id: Optional[str] = Field(
        None,
        alias="customerDemarcId",
        description="Customer-side demarc ID for this circuit.",
    )


class Datum101(Datum2):
    pass


class Warning101(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum101]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum102(Datum2):
    pass


class Warning102(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum102]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Zone(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    name: Optional[str] = Field(None, description="[Output Only] Name of the resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] Full URL reference to the region which hosts the zone.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    status: Optional[Status24] = Field(
        None, description="[Output Only] Status of the zone, either UP or DOWN."
    )
    deprecated: Optional[DeprecationStatus] = Field(
        None,
        description="[Output Only] The deprecation status associated with this zone.",
    )
    available_cpu_platforms: Optional[List[str]] = Field(
        None,
        alias="availableCpuPlatforms",
        description="[Output Only] Available cpu/platform selections for the zone.",
    )
    description: Optional[str] = Field(
        None, description="[Output Only] Textual description of the resource."
    )
    kind: Optional[str] = Field(
        "compute#zone",
        description="[Output Only] Type of the resource. Always compute#zone for zones.",
    )
    supports_pzs: Optional[bool] = Field(
        None, alias="supportsPzs", description="[Output Only] Reserved for future use."
    )


class ZoneSetLabelsRequest(BaseModel):
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None, description="The labels to set for this resource."
    )


class Datum103(Datum2):
    pass


class Warning103(BaseModel):
    data: Optional[List[Datum103]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum104(Datum2):
    pass


class Warning104(BaseModel):
    data: Optional[List[Datum104]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum105(Datum):
    pass


class Warning105(BaseModel):
    data: Optional[List[Datum105]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum106(Datum):
    pass


class Warning106(BaseModel):
    data: Optional[List[Datum106]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum107(Datum):
    pass


class Warning107(BaseModel):
    data: Optional[List[Datum107]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum108(Datum):
    pass


class Warning108(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum108]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class InstancesRemoveResourcePoliciesRequest(BaseModel):
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies to be removed from this instance.",
    )


class Datum109(Datum2):
    pass


class Warning109(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum109]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum110(Datum2):
    pass


class Warning110(BaseModel):
    data: Optional[List[Datum110]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class SerialPortOutput(BaseModel):
    contents: Optional[str] = Field(
        None, description="[Output Only] The contents of the console output."
    )
    next: Optional[str] = Field(
        None,
        description="[Output Only] The position of the next byte of content, regardless of whether the content exists, following the output returned in the `contents` property. Use this value in the next request as the start parameter.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#serialPortOutput",
        description="[Output Only] Type of the resource. Always compute#serialPortOutput for serial port output.",
    )
    start: Optional[str] = Field(
        None,
        description="The starting byte position of the output that was returned. This should match the start parameter sent with the request. If the serial console output exceeds the size of the buffer (1 MB), older output is overwritten by newer content. The output start value will indicate the byte position of the output that was returned, which might be different than the `start` value that was specified in the request.",
    )


class Datum111(Datum2):
    pass


class Warning111(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum111]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class OperationList(BaseModel):
    warning: Optional[Warning111] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#operationList",
        description="[Output Only] Type of resource. Always `compute#operations` for Operations resource.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than `maxResults`, use the `nextPageToken` as a value for the query parameter `pageToken` in the next list request. Subsequent list requests will have their own `nextPageToken` to continue paging through the results.",
    )
    items: Optional[List[Operation]] = Field(
        None, description="[Output Only] A list of Operation resources."
    )


class Datum112(Datum2):
    pass


class Warning112(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum112]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class LicenseResourceRequirements(BaseModel):
    min_memory_mb: Optional[int] = Field(
        None,
        alias="minMemoryMb",
        description="Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.",
    )
    min_guest_cpu_count: Optional[int] = Field(
        None,
        alias="minGuestCpuCount",
        description="Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.",
    )


class InstancesSetMachineResourcesRequest(BaseModel):
    guest_accelerators: Optional[List[AcceleratorConfig]] = Field(
        None,
        alias="guestAccelerators",
        description="A list of the type and count of accelerator cards attached to the instance.",
    )


class TargetHttpsProxiesSetSslCertificatesRequest(BaseModel):
    ssl_certificates: Optional[List[str]] = Field(
        None,
        alias="sslCertificates",
        description="New set of SslCertificate resources to associate with this TargetHttpsProxy resource. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates.",
    )


class Datum113(Datum2):
    pass


class Warning113(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum113]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class TargetHttpsProxyAggregatedList(BaseModel):
    warning: Optional[Warning113] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, TargetHttpsProxiesScopedList]] = Field(
        None, description="A list of TargetHttpsProxiesScopedList resources."
    )
    kind: Optional[str] = Field(
        "compute#targetHttpsProxyAggregatedList",
        description="[Output Only] Type of resource. Always compute#targetHttpsProxyAggregatedList for lists of Target HTTP Proxies.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class SecurityPolicyReference(BaseModel):
    security_policy: Optional[str] = Field(None, alias="securityPolicy")


class SslPoliciesListAvailableFeaturesResponse(BaseModel):
    features: Optional[List[str]] = None


class Datum114(Datum):
    pass


class Warning114(BaseModel):
    data: Optional[List[Datum114]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum115(Datum2):
    pass


class Warning115(BaseModel):
    data: Optional[List[Datum115]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class RegionDisksRemoveResourcePoliciesRequest(BaseModel):
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies to be removed from this disk.",
    )


class HealthStatus1(Enum):
    show = "SHOW"
    skip = "SKIP"


class NetworkEndpointGroupsListEndpointsRequest(BaseModel):
    health_status: Optional[HealthStatus1] = Field(
        None,
        alias="healthStatus",
        description="Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don't specify this parameter, the health status of network endpoints will not be provided.",
    )


class Datum116(Datum):
    pass


class Warning116(BaseModel):
    data: Optional[List[Datum116]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum117(Datum2):
    pass


class Warning117(BaseModel):
    data: Optional[List[Datum117]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetTcpProxy(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    kind: Optional[str] = Field(
        "compute#targetTcpProxy",
        description="[Output Only] Type of the resource. Always compute#targetTcpProxy for target TCP proxies.",
    )
    service: Optional[str] = Field(None, description="URL to the BackendService resource.")
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    proxy_bind: Optional[bool] = Field(
        None,
        alias="proxyBind",
        description="This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies set up inbound traffic interception and bind to the IP address and port specified in the forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for inbound requests and handles requests when it receives them. The default is false.",
    )
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )


class Datum118(Datum):
    pass


class Warning118(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum118]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetGrpcProxy(BaseModel):
    url_map: Optional[str] = Field(
        None,
        alias="urlMap",
        description="URL to the UrlMap resource that defines the mapping from URL to the BackendService. The protocol field in the BackendService must be set to GRPC.",
    )
    kind: Optional[str] = Field(
        "compute#targetGrpcProxy",
        description="[Output Only] Type of the resource. Always compute#targetGrpcProxy for target grpc proxies.",
    )
    self_link_with_id: Optional[str] = Field(
        None,
        alias="selfLinkWithId",
        description="[Output Only] Server-defined URL with id for the resource.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    validate_for_proxyless: Optional[bool] = Field(
        None,
        alias="validateForProxyless",
        description='If true, indicates that the BackendServices referenced by the urlMap may be accessed by gRPC applications without using a sidecar proxy. This will enable configuration checks on urlMap and its referenced BackendServices to not allow unsupported features. A gRPC application must use "xds:///" scheme in the target URI of the service it is connecting to. If false, indicates that the BackendServices referenced by the urlMap will be accessed by gRPC applications via a sidecar proxy. In this case, a gRPC application must not use "xds:///" scheme in the target URI of the service it is connecting to',
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource type. The server generates this identifier.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a TargetGrpcProxy. An up-to-date fingerprint must be provided in order to patch/update the TargetGrpcProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the TargetGrpcProxy.",
    )


class Datum119(Datum2):
    pass


class Warning119(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum119]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class ScratchDisk(BaseModel):
    disk_gb: Optional[int] = Field(
        None, alias="diskGb", description="Size of the scratch disk, defined in GB."
    )


class Accelerator(BaseModel):
    guest_accelerator_type: Optional[str] = Field(
        None,
        alias="guestAcceleratorType",
        description="The accelerator type resource name, not a full URL, e.g. 'nvidia-tesla-k80'.",
    )
    guest_accelerator_count: Optional[int] = Field(
        None,
        alias="guestAcceleratorCount",
        description="Number of accelerator cards exposed to the guest.",
    )


class MachineType(BaseModel):
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    memory_mb: Optional[int] = Field(
        None,
        alias="memoryMb",
        description="[Output Only] The amount of physical memory available to the instance, defined in MB.",
    )
    maximum_persistent_disks_size_gb: Optional[str] = Field(
        None,
        alias="maximumPersistentDisksSizeGb",
        description="[Output Only] Maximum total persistent disks size (GB) allowed.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The name of the zone where the machine type resides, such as us-central1-a.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    maximum_persistent_disks: Optional[int] = Field(
        None,
        alias="maximumPersistentDisks",
        description="[Output Only] Maximum persistent disks allowed.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    scratch_disks: Optional[List[ScratchDisk]] = Field(
        None,
        alias="scratchDisks",
        description="[Output Only] A list of extended scratch disks assigned to the instance.",
    )
    deprecated: Optional[DeprecationStatus] = Field(
        None,
        description="[Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.",
    )
    accelerators: Optional[List[Accelerator]] = Field(
        None,
        description="[Output Only] A list of accelerator configurations assigned to this machine type.",
    )
    is_shared_cpu: Optional[bool] = Field(
        None,
        alias="isSharedCpu",
        description="[Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.",
    )
    kind: Optional[str] = Field(
        "compute#machineType",
        description="[Output Only] The type of the resource. Always compute#machineType for machine types.",
    )
    guest_cpus: Optional[int] = Field(
        None,
        alias="guestCpus",
        description="[Output Only] The number of virtual CPUs that are available to the instance.",
    )
    description: Optional[str] = Field(
        None,
        description="[Output Only] An optional textual description of the resource.",
    )
    image_space_gb: Optional[int] = Field(
        None,
        alias="imageSpaceGb",
        description="[Deprecated] This property is deprecated and will never be populated with any relevant values.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None, description="[Output Only] Name of the resource."
    )


class Datum120(Datum):
    pass


class Warning120(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum120]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class VpnTunnelList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning120] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#vpnTunnelList",
        description="[Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[VpnTunnel]] = Field(None, description="A list of VpnTunnel resources.")


class Datum121(Datum2):
    pass


class Warning121(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum121]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum122(Datum2):
    pass


class Warning122(BaseModel):
    data: Optional[List[Datum122]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class SignedUrlKey(BaseModel):
    key_name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        alias="keyName",
        description="Name of the key. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    key_value: Optional[str] = Field(
        None,
        alias="keyValue",
        description="128-bit key value used for signing the URL. The key value must be a valid RFC 4648 Section 5 base64url encoded string.",
    )


class Datum123(Datum2):
    pass


class Warning123(BaseModel):
    data: Optional[List[Datum123]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class RegionDiskTypeList(BaseModel):
    kind: Optional[str] = Field(
        "compute#regionDiskTypeList",
        description="[Output Only] Type of resource. Always compute#regionDiskTypeList for region disk types.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning123] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[DiskType]] = Field(None, description="A list of DiskType resources.")


class InstanceGroupsSetNamedPortsRequest(BaseModel):
    fingerprint: Optional[str] = Field(
        None,
        description="The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request. A request with an incorrect fingerprint will fail with error 412 conditionNotMet.",
    )
    named_ports: Optional[List[NamedPort]] = Field(
        None,
        alias="namedPorts",
        description="The list of named ports to set for this instance group.",
    )


class NetworkEndpointGroupsAttachEndpointsRequest(BaseModel):
    network_endpoints: Optional[List[NetworkEndpoint]] = Field(
        None,
        alias="networkEndpoints",
        description="The list of network endpoints to be attached.",
    )


class UsableSubnetworkSecondaryRange(BaseModel):
    range_name: Optional[str] = Field(
        None,
        alias="rangeName",
        description="The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.",
    )
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The range of IP addresses belonging to this subnetwork secondary range.",
    )


class NodeGroupsSetNodeTemplateRequest(BaseModel):
    node_template: Optional[str] = Field(
        None,
        alias="nodeTemplate",
        description="Full or partial URL of the node template resource to be updated for this node group.",
    )


class DisksResizeRequest(BaseModel):
    size_gb: Optional[str] = Field(
        None,
        alias="sizeGb",
        description="The new size of the persistent disk, which is specified in GB.",
    )


class Datum124(Datum2):
    pass


class Warning124(BaseModel):
    data: Optional[List[Datum124]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetTcpProxiesSetProxyHeaderRequest(BaseModel):
    proxy_header: Optional[ProxyHeader] = Field(
        None,
        alias="proxyHeader",
        description="The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.",
    )


class Datum125(Datum):
    pass


class Warning125(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum125]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class HttpHealthCheck1(BaseModel):
    timeout_sec: Optional[int] = Field(
        None,
        alias="timeoutSec",
        description="How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.",
    )
    healthy_threshold: Optional[int] = Field(
        None,
        alias="healthyThreshold",
        description="A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    port: Optional[int] = Field(
        None,
        description="The TCP port number for the HTTP health check request. The default value is 80.",
    )
    kind: Optional[str] = Field(
        "compute#httpHealthCheck",
        description="[Output Only] Type of the resource. Always compute#httpHealthCheck for HTTP health checks.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    request_path: Optional[str] = Field(
        None,
        alias="requestPath",
        description="The request path of the HTTP health check request. The default value is /. This field does not support query parameters.",
    )
    check_interval_sec: Optional[int] = Field(
        None,
        alias="checkIntervalSec",
        description="How often (in seconds) to send a health check. The default value is 5 seconds.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    host: Optional[str] = Field(
        None,
        description="The value of the host header in the HTTP health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.",
    )
    unhealthy_threshold: Optional[int] = Field(
        None,
        alias="unhealthyThreshold",
        description="A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.",
    )


class ProjectsDisableXpnResourceRequest(BaseModel):
    xpn_resource: Optional[XpnResourceId] = Field(
        None,
        alias="xpnResource",
        description="Service resource (a.k.a service project) ID.",
    )


class TargetSslProxiesSetCertificateMapRequest(BaseModel):
    certificate_map: Optional[str] = Field(
        None,
        alias="certificateMap",
        description="URL of the Certificate Map to associate with this TargetSslProxy.",
    )


class NetworksAddPeeringRequest(BaseModel):
    network_peering: Optional[NetworkPeering] = Field(
        None,
        alias="networkPeering",
        description="Network peering parameters. In order to specify route policies for peering using import and export custom routes, you must specify all peering related parameters (name, peer network, exchange_subnet_routes) in the network_peering field. The corresponding fields in NetworksAddPeeringRequest will be deprecated soon.",
    )
    peer_network: Optional[str] = Field(
        None,
        alias="peerNetwork",
        description="URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.",
    )
    name: Optional[str] = Field(
        None, description="Name of the peering, which should conform to RFC1035."
    )
    auto_create_routes: Optional[bool] = Field(
        None,
        alias="autoCreateRoutes",
        description="This field will be deprecated soon. Use exchange_subnet_routes in network_peering instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.",
    )


class Datum126(Datum):
    pass


class Warning126(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum126]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class InstanceGroupManagersSetTargetPoolsRequest(BaseModel):
    fingerprint: Optional[str] = Field(
        None,
        description="The fingerprint of the target pools information. Use this optional property to prevent conflicts when multiple users change the target pools settings concurrently. Obtain the fingerprint with the instanceGroupManagers.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.",
    )
    target_pools: Optional[List[str]] = Field(
        None,
        alias="targetPools",
        description="The list of target pool URLs that instances in this managed instance group belong to. The managed instance group applies these target pools to all of the instances in the group. Existing instances and new instances in the group all receive these target pool settings.",
    )


class Datum127(Datum2):
    pass


class Warning127(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum127]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class ZoneList(BaseModel):
    items: Optional[List[Zone]] = Field(None, description="A list of Zone resources.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field("compute#zoneList", description="Type of resource.")
    warning: Optional[Warning127] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class InstanceGroupManagersAbandonInstancesRequest(BaseModel):
    instances: Optional[List[str]] = Field(
        None,
        description="The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )


class NetworksRemovePeeringRequest(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the peering, which should conform to RFC1035."
    )


class Datum128(Datum2):
    pass


class Warning128(BaseModel):
    data: Optional[List[Datum128]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class TargetHttpProxyList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[TargetHttpProxy]] = Field(
        None, description="A list of TargetHttpProxy resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#targetHttpProxyList",
        description="Type of resource. Always compute#targetHttpProxyList for lists of target HTTP proxies.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning128] = Field(
        None, description="[Output Only] Informational warning message."
    )


class Datum129(Datum2):
    pass


class Warning129(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum129]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class DiskAggregatedList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#diskAggregatedList",
        description="[Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning129] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[Dict[str, DisksScopedList]] = Field(
        None, description="A list of DisksScopedList resources."
    )


class Datum130(Datum2):
    pass


class Warning130(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum130]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum131(Datum2):
    pass


class Warning131(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum131]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum132(Datum):
    pass


class Warning132(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum132]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum133(Datum):
    pass


class Warning133(BaseModel):
    data: Optional[List[Datum133]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum134(Datum2):
    pass


class Warning134(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum134]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class TargetInstancesScopedList(BaseModel):
    warning: Optional[Warning134] = Field(
        None,
        description="Informational warning which replaces the list of addresses when the list is empty.",
    )
    target_instances: Optional[List[TargetInstance]] = Field(
        None,
        alias="targetInstances",
        description="A list of target instances contained in this scope.",
    )


class DisksRemoveResourcePoliciesRequest(BaseModel):
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies to be removed from this disk.",
    )


class GlobalNetworkEndpointGroupsAttachEndpointsRequest(BaseModel):
    network_endpoints: Optional[List[NetworkEndpoint]] = Field(
        None,
        alias="networkEndpoints",
        description="The list of network endpoints to be attached.",
    )


class BackendServiceGroupHealth(BaseModel):
    health_status: Optional[List[HealthStatus]] = Field(
        None,
        alias="healthStatus",
        description="Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.",
    )
    kind: Optional[str] = Field(
        "compute#backendServiceGroupHealth",
        description="[Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.",
    )
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description="Metadata defined as annotations on the network endpoint group.",
    )


class RegionInstanceGroupManagersSetTargetPoolsRequest(BaseModel):
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of the target pools information, which is a hash of the contents. This field is used for optimistic locking when you update the target pool entries. This field is optional.",
    )
    target_pools: Optional[List[str]] = Field(
        None,
        alias="targetPools",
        description="The URL of all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.",
    )


class Datum135(Datum2):
    pass


class Warning135(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum135]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class Datum136(Datum):
    pass


class Warning136(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum136]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum137(Datum2):
    pass


class Warning137(BaseModel):
    data: Optional[List[Datum137]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class ResourceGroupReference(BaseModel):
    group: Optional[str] = Field(
        None,
        description="A URI referencing one of the instance groups or network endpoint groups listed in the backend service.",
    )


class UrlMapReference(BaseModel):
    url_map: Optional[str] = Field(None, alias="urlMap")


class RegionInstanceGroupManagersAbandonInstancesRequest(BaseModel):
    instances: Optional[List[str]] = Field(
        None,
        description="The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )


class ProjectsEnableXpnResourceRequest(BaseModel):
    xpn_resource: Optional[XpnResourceId] = Field(
        None,
        alias="xpnResource",
        description="Service resource (a.k.a service project) ID.",
    )


class Datum138(Datum):
    pass


class Warning138(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum138]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class ProjectsSetDefaultNetworkTierRequest(BaseModel):
    network_tier: Optional[NetworkTier] = Field(
        None, alias="networkTier", description="Default network tier to be set."
    )


class Datum139(Datum):
    pass


class Warning139(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum139]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class InstanceGroupManagersSetInstanceTemplateRequest(BaseModel):
    instance_template: Optional[str] = Field(
        None,
        alias="instanceTemplate",
        description="The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.",
    )


class RegionInstanceGroupManagersDeleteInstancesRequest(BaseModel):
    skip_instances_on_validation_error: Optional[bool] = Field(
        None,
        alias="skipInstancesOnValidationError",
        description="Specifies whether the request should proceed despite the inclusion of instances that are not members of the group or that are already in the process of being deleted or abandoned. If this field is set to `false` and such an instance is specified in the request, the operation fails. The operation always fails if the request contains a malformed instance URL or a reference to an instance that exists in a zone or region other than the group's zone or region.",
    )
    instances: Optional[List[str]] = Field(
        None,
        description="The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].",
    )


class Datum140(Datum):
    pass


class Warning140(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum140]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Type19(Enum):
    dynamic_peering_route = "DYNAMIC_PEERING_ROUTE"
    static_peering_route = "STATIC_PEERING_ROUTE"
    subnet_peering_route = "SUBNET_PEERING_ROUTE"


class ExchangedPeeringRoute(BaseModel):
    imported: Optional[bool] = Field(
        None,
        description="True if the peering route has been imported from a peer. The actual import happens if the field networkPeering.importCustomRoutes is true for this network, and networkPeering.exportCustomRoutes is true for the peer network, and the import does not result in a route conflict.",
    )
    priority: Optional[int] = Field(None, description="The priority of the peering route.")
    dest_range: Optional[str] = Field(
        None, alias="destRange", description="The destination range of the route."
    )
    next_hop_region: Optional[str] = Field(
        None,
        alias="nextHopRegion",
        description="The region of peering route next hop, only applies to dynamic routes.",
    )
    type: Optional[Type19] = Field(None, description="The type of the peering route.")


class Datum141(Datum):
    pass


class Warning141(BaseModel):
    data: Optional[List[Datum141]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum142(Datum2):
    pass


class Warning142(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum142]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class Datum143(Datum):
    pass


class Warning143(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum143]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum144(Datum2):
    pass


class Warning144(BaseModel):
    data: Optional[List[Datum144]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class DiskTypeList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#diskTypeList",
        description="[Output Only] Type of resource. Always compute#diskTypeList for disk types.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[DiskType]] = Field(None, description="A list of DiskType resources.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning144] = Field(
        None, description="[Output Only] Informational warning message."
    )


class InstanceGroupManagersDeletePerInstanceConfigsReq(BaseModel):
    names: Optional[List[str]] = Field(
        None,
        description="The list of instance names for which we want to delete per-instance configs on this managed instance group.",
    )


class InstancesSetLabelsRequest(BaseModel):
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="Fingerprint of the previous set of labels for this resource, used to prevent conflicts. Provide the latest fingerprint value when making a request to add or change labels.",
    )
    labels: Optional[Dict[str, str]] = None


class Datum145(Datum2):
    pass


class Warning145(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum145]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum146(Datum):
    pass


class Warning146(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum146]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )


class AddressList(BaseModel):
    warning: Optional[Warning146] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#addressList",
        description="[Output Only] Type of resource. Always compute#addressList for lists of addresses.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[Address]] = Field(None, description="A list of Address resources.")


class TargetSslProxiesSetBackendServiceRequest(BaseModel):
    service: Optional[str] = Field(
        None,
        description="The URL of the new BackendService resource for the targetSslProxy.",
    )


class RegionDisksAddResourcePoliciesRequest(BaseModel):
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies to be added to this disk.",
    )


class Datum147(Datum2):
    pass


class Warning147(BaseModel):
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    data: Optional[List[Datum147]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class MachineTypeList(BaseModel):
    items: Optional[List[MachineType]] = Field(None, description="A list of MachineType resources.")
    warning: Optional[Warning147] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#machineTypeList",
        description="[Output Only] Type of resource. Always compute#machineTypeList for lists of machine types.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class Datum148(Datum):
    pass


class Warning148(BaseModel):
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )
    data: Optional[List[Datum148]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )


class Datum149(Datum2):
    pass


class Warning149(BaseModel):
    data: Optional[List[Datum149]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class SubnetworksSetPrivateIpGoogleAccessRequest(BaseModel):
    private_ip_google_access: Optional[bool] = Field(None, alias="privateIpGoogleAccess")


class Datum150(Datum):
    pass


class Warning150(BaseModel):
    data: Optional[List[Datum150]] = Field(
        None,
        description='[Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } ',
    )
    message: Optional[str] = Field(
        None,
        description="[Output Only] A human-readable description of the warning code.",
    )
    code: Optional[Code] = Field(
        None,
        description="[Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.",
    )


class AcceleratorTypeList(BaseModel):
    kind: Optional[str] = Field(
        "compute#acceleratorTypeList",
        description="[Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.",
    )
    warning: Optional[Warning150] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[AcceleratorType]] = Field(
        None, description="A list of AcceleratorType resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class OperationsScopedList(BaseModel):
    warning: Optional[Warning1] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of operations when the list is empty.",
    )
    operations: Optional[List[Operation]] = Field(
        None, description="[Output Only] A list of operations contained in this scope."
    )


class ProjectsGetXpnResources(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    resources: Optional[List[XpnResourceId]] = Field(
        None,
        description="Service resources (a.k.a service projects) attached to this project as their shared VPC host.",
    )
    kind: Optional[str] = Field(
        "compute#projectsGetXpnResources",
        description="[Output Only] Type of resource. Always compute#projectsGetXpnResources for lists of service resources (a.k.a service projects)",
    )


class InitialStateConfig(BaseModel):
    keks: Optional[List[FileContentBuffer]] = Field(None, description="The Key Exchange Key (KEK).")
    pk: Optional[FileContentBuffer] = Field(None, description="The Platform Key (PK).")
    dbxs: Optional[List[FileContentBuffer]] = Field(
        None, description="The forbidden key database (dbx)."
    )
    dbs: Optional[List[FileContentBuffer]] = Field(None, description="The Key Database (db).")


class Scheduling(BaseModel):
    instance_termination_action: Optional[InstanceTerminationAction] = Field(
        None,
        alias="instanceTerminationAction",
        description="Specifies the termination action for the instance.",
    )
    preemptible: Optional[bool] = Field(
        None,
        description="Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.",
    )
    node_affinities: Optional[List[SchedulingNodeAffinity]] = Field(
        None,
        alias="nodeAffinities",
        description="A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.",
    )
    provisioning_model: Optional[ProvisioningModel] = Field(
        None,
        alias="provisioningModel",
        description="Specifies the provisioning model of the instance.",
    )
    automatic_restart: Optional[bool] = Field(
        None,
        alias="automaticRestart",
        description="Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.",
    )
    min_node_cpus: Optional[int] = Field(
        None,
        alias="minNodeCpus",
        description="The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.",
    )
    location_hint: Optional[str] = Field(
        None,
        alias="locationHint",
        description="An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.",
    )
    on_host_maintenance: Optional[OnHostMaintenance] = Field(
        None,
        alias="onHostMaintenance",
        description="Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM availability policies.",
    )


class NetworkInterface(BaseModel):
    network: Optional[str] = Field(
        None,
        description="URL of the VPC network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used. If the selected project doesn't have the default network, you must specify a network or subnet. If the network is not specified but the subnetwork is specified, the network is inferred. If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/global/networks/ network - projects/project/global/networks/network - global/networks/default ",
    )
    ipv6_address: Optional[str] = Field(
        None,
        alias="ipv6Address",
        description="An IPv6 internal network address for this network interface.",
    )
    access_configs: Optional[List[AccessConfig]] = Field(
        None,
        alias="accessConfigs",
        description="An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.",
    )
    kind: Optional[str] = Field(
        "compute#networkInterface",
        description="[Output Only] Type of the resource. Always compute#networkInterface for network interfaces.",
    )
    internal_ipv6_prefix_length: Optional[int] = Field(
        None,
        alias="internalIpv6PrefixLength",
        description="The prefix length of the primary internal IPv6 range.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork ",
    )
    ipv6_access_type: Optional[Ipv6AccessType] = Field(
        None,
        alias="ipv6AccessType",
        description="[Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork. Valid only if stackType is IPV4_IPV6.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint hash of contents stored in this network interface. This field will be ignored when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided in order to update the NetworkInterface. The request will fail with error 400 Bad Request if the fingerprint is not provided, or 412 Precondition Failed if the fingerprint is out of date.",
    )
    alias_ip_ranges: Optional[List[AliasIpRange]] = Field(
        None,
        alias="aliasIpRanges",
        description="An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.",
    )
    name: Optional[str] = Field(
        None,
        description="[Output Only] The name of the network interface, which is generated by the server. For a VM, the network interface uses the nicN naming format. Where N is a value between 0 and 7. The default interface value is nic0.",
    )
    queue_count: Optional[int] = Field(
        None,
        alias="queueCount",
        description="The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.",
    )
    nic_type: Optional[NicType] = Field(
        None,
        alias="nicType",
        description="The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.",
    )
    network_ip: Optional[str] = Field(
        None,
        alias="networkIP",
        description="An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.",
    )
    stack_type: Optional[StackType] = Field(
        None,
        alias="stackType",
        description="The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at instance creation and update network interface operations.",
    )
    ipv6_access_configs: Optional[List[AccessConfig]] = Field(
        None,
        alias="ipv6AccessConfigs",
        description="An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.",
    )


class PreservedState(BaseModel):
    disks: Optional[Dict[str, PreservedStatePreservedDisk]] = Field(
        None,
        description="Preserved disks defined for this instance. This map is keyed with the device names of the disks.",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, description="Preserved metadata defined for this instance."
    )


class SecurityPolicyAdaptiveProtectionConfig(BaseModel):
    layer7_ddos_defense_config: Optional[
        SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
    ] = Field(
        None,
        alias="layer7DdosDefenseConfig",
        description="If set to true, enables Cloud Armor Machine Learning.",
    )


class SecurityPolicyRuleMatcher(BaseModel):
    expr: Optional[Expr] = Field(
        None,
        description="User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.",
    )
    versioned_expr: Optional[VersionedExpr] = Field(
        None,
        alias="versionedExpr",
        description="Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.",
    )
    config: Optional[SecurityPolicyRuleMatcherConfig] = Field(
        None,
        description="The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.",
    )


class SecurityPolicyRuleHttpHeaderAction(BaseModel):
    request_headers_to_adds: Optional[
        List[SecurityPolicyRuleHttpHeaderActionHttpHeaderOption]
    ] = Field(
        None,
        alias="requestHeadersToAdds",
        description="The list of request headers to add or overwrite if they're already present.",
    )


class SecurityPolicyRuleRateLimitOptions(BaseModel):
    enforce_on_key: Optional[EnforceOnKey] = Field(
        None,
        alias="enforceOnKey",
        description='Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if this field \'enforce_on_key\' is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. ',
    )
    conform_action: Optional[str] = Field(
        None,
        alias="conformAction",
        description='Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.',
    )
    ban_duration_sec: Optional[int] = Field(
        None,
        alias="banDurationSec",
        description='Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.',
    )
    exceed_redirect_options: Optional[SecurityPolicyRuleRedirectOptions] = Field(
        None,
        alias="exceedRedirectOptions",
        description="Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect.",
    )
    exceed_action: Optional[str] = Field(
        None,
        alias="exceedAction",
        description='Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny(status)", where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceedRedirectOptions below.',
    )
    enforce_on_key_name: Optional[str] = Field(
        None,
        alias="enforceOnKeyName",
        description="Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.",
    )
    rate_limit_threshold: Optional[SecurityPolicyRuleRateLimitOptionsThreshold] = Field(
        None,
        alias="rateLimitThreshold",
        description="Threshold at which to begin ratelimiting.",
    )
    ban_threshold: Optional[SecurityPolicyRuleRateLimitOptionsThreshold] = Field(
        None,
        alias="banThreshold",
        description="Can only be specified if the action for the rule is \"rate_based_ban\". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.",
    )


class HttpFaultDelay(BaseModel):
    percentage: Optional[float] = Field(
        None,
        description="The percentage of traffic for connections, operations, or requests for which a delay is introduced as part of fault injection. The value must be from 0.0 to 100.0 inclusive.",
    )
    fixed_delay: Optional[Duration] = Field(
        None,
        alias="fixedDelay",
        description="Specifies the value of the fixed delay interval.",
    )


class InstanceListReferrers(BaseModel):
    kind: Optional[str] = Field(
        "compute#instanceListReferrers",
        description="[Output Only] Type of resource. Always compute#instanceListReferrers for lists of Instance referrers.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Reference]] = Field(None, description="A list of Reference resources.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning3] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class NodeType(BaseModel):
    deprecated: Optional[DeprecationStatus] = Field(
        None,
        description="[Output Only] The deprecation status associated with this node type.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The name of the zone where the node type resides, such as us-central1-a.",
    )
    guest_cpus: Optional[int] = Field(
        None,
        alias="guestCpus",
        description="[Output Only] The number of virtual CPUs that are available to the node type.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None, description="[Output Only] Name of the resource."
    )
    cpu_platform: Optional[str] = Field(
        None,
        alias="cpuPlatform",
        description="[Output Only] The CPU platform used by this node type.",
    )
    memory_mb: Optional[int] = Field(
        None,
        alias="memoryMb",
        description="[Output Only] The amount of physical memory available to the node type, defined in MB.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    local_ssd_gb: Optional[int] = Field(
        None,
        alias="localSsdGb",
        description="[Output Only] Local SSD available to the node type, defined in GB.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    description: Optional[str] = Field(
        None,
        description="[Output Only] An optional textual description of the resource.",
    )
    kind: Optional[str] = Field(
        "compute#nodeType",
        description="[Output Only] The type of the resource. Always compute#nodeType for node types.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class Route1(BaseModel):
    next_hop_network: Optional[str] = Field(
        None,
        alias="nextHopNetwork",
        description="The URL of the local network if it should handle matching packets.",
    )
    dest_range: Optional[str] = Field(
        None,
        alias="destRange",
        description="The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    next_hop_ilb: Optional[str] = Field(
        None,
        alias="nextHopIlb",
        description="The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule ",
    )
    priority: Optional[int] = Field(
        None,
        description="The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined fully-qualified URL for this resource.",
    )
    tags: Optional[List[str]] = Field(
        None, description="A list of instance tags to which this route applies."
    )
    next_hop_ip: Optional[str] = Field(
        None,
        alias="nextHopIp",
        description="The network IP address of an instance that should handle matching packets. Only IPv4 is supported.",
    )
    next_hop_instance: Optional[str] = Field(
        None,
        alias="nextHopInstance",
        description="The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/",
    )
    warnings: Optional[List[Warning5]] = Field(
        None,
        description="[Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.",
    )
    kind: Optional[str] = Field(
        "compute#route",
        description="[Output Only] Type of this resource. Always compute#routes for Route resources.",
    )
    route_status: Optional[RouteStatus] = Field(
        None, alias="routeStatus", description="[Output only] The status of the route."
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this field when you create the resource.",
    )
    next_hop_gateway: Optional[str] = Field(
        None,
        alias="nextHopGateway",
        description="The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway",
    )
    network: Optional[str] = Field(
        None,
        description="Fully-qualified URL of the network that this route applies to.",
    )
    next_hop_vpn_tunnel: Optional[str] = Field(
        None,
        alias="nextHopVpnTunnel",
        description="The URL to a VpnTunnel that should handle matching packets.",
    )
    next_hop_peering: Optional[str] = Field(
        None,
        alias="nextHopPeering",
        description="[Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    as_paths: Optional[List[RouteAsPath]] = Field(
        None, alias="asPaths", description="[Output Only] AS path."
    )
    route_type: Optional[RouteType] = Field(
        None,
        alias="routeType",
        description="[Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route",
    )


class ShieldedInstanceIdentity(BaseModel):
    encryption_key: Optional[ShieldedInstanceIdentityEntry] = Field(
        None,
        alias="encryptionKey",
        description="An Endorsement Key (EK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.",
    )
    kind: Optional[str] = Field(
        "compute#shieldedInstanceIdentity",
        description="[Output Only] Type of the resource. Always compute#shieldedInstanceIdentity for shielded Instance identity entry.",
    )
    signing_key: Optional[ShieldedInstanceIdentityEntry] = Field(
        None,
        alias="signingKey",
        description="An Attestation Key (AK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.",
    )


class TargetPoolsRemoveHealthCheckRequest(BaseModel):
    health_checks: Optional[List[HealthCheckReference]] = Field(
        None,
        alias="healthChecks",
        description="Health check URL to be removed. This can be a full or valid partial URL. For example, the following are valid URLs: - https://www.googleapis.com/compute/beta/projects/project /global/httpHealthChecks/health-check - projects/project/global/httpHealthChecks/health-check - global/httpHealthChecks/health-check ",
    )


class HealthCheckServicesList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning6] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[HealthCheckService]] = Field(
        None, description="A list of HealthCheckService resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#healthCheckServicesList",
        description="[Output Only] Type of the resource. Always compute#healthCheckServicesList for lists of HealthCheckServices.",
    )


class InstanceGroup(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] A unique identifier for this instance group, generated by the server.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the subnetwork to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] The URL for this instance group. The server generates this URL.",
    )
    network: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the network to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).",
    )
    named_ports: Optional[List[NamedPort]] = Field(
        None,
        alias="namedPorts",
        description=' Assigns a name to a port number. For example: {name: "http", port: 80} This allows the system to reference ports by the assigned name instead of a port number. Named ports can also contain multiple ports. For example: [{name: "app1", port: 8080}, {name: "app1", port: 8081}, {name: "app2", port: 8082}] Named ports apply to all instances in this instance group. ',
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the region where the instance group is located (for regional resources).",
    )
    size: Optional[int] = Field(
        None,
        description="[Output Only] The total number of instances in the instance group.",
    )
    kind: Optional[str] = Field(
        "compute#instanceGroup",
        description="[Output Only] The resource type, which is always compute#instanceGroup for instance groups.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="[Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect conflicts when multiple users change the named ports concurrently.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the zone where the instance group is located (for zonal resources).",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] The creation timestamp for this instance group in RFC3339 text format.",
    )


class UrlMapTest(BaseModel):
    host: Optional[str] = Field(
        None,
        description="Host portion of the URL. If headers contains a host header, then host must also match the header value.",
    )
    path: Optional[str] = Field(None, description="Path portion of the URL.")
    service: Optional[str] = Field(
        None,
        description="Expected BackendService or BackendBucket resource the given URL should be mapped to. The service field cannot be set if expectedRedirectResponseCode is set.",
    )
    expected_redirect_response_code: Optional[int] = Field(
        None,
        alias="expectedRedirectResponseCode",
        description="For rules with urlRedirect, the test passes only if expectedRedirectResponseCode matches the HTTP status code in load balancer's redirect response. expectedRedirectResponseCode cannot be set when service is set.",
    )
    headers: Optional[List[UrlMapTestHeader]] = Field(
        None,
        description="HTTP headers for this request. If headers contains a host header, then host must also match the header value.",
    )
    description: Optional[str] = Field(None, description="Description of this test case.")
    expected_output_url: Optional[str] = Field(
        None,
        alias="expectedOutputUrl",
        description="The expected output URL evaluated by the load balancer containing the scheme, host, path and query parameters. For rules that forward requests to backends, the test passes only when expectedOutputUrl matches the request forwarded by the load balancer to backends. For rules with urlRewrite, the test verifies that the forwarded request matches hostRewrite and pathPrefixRewrite in the urlRewrite action. When service is specified, expectedOutputUrl`s scheme is ignored. For rules with urlRedirect, the test passes only if expectedOutputUrl matches the URL in the load balancer's redirect response. If urlRedirect specifies https_redirect, the test passes only if the scheme in expectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query, the test passes only if expectedOutputUrl does not contain any query parameters. expectedOutputUrl is optional when service is specified.",
    )


class HttpHeaderAction(BaseModel):
    response_headers_to_remove: Optional[List[str]] = Field(
        None,
        alias="responseHeadersToRemove",
        description="A list of header names for headers that need to be removed from the response before sending the response back to the client.",
    )
    request_headers_to_add: Optional[List[HttpHeaderOption]] = Field(
        None,
        alias="requestHeadersToAdd",
        description="Headers to add to a matching request before forwarding the request to the backendService.",
    )
    request_headers_to_remove: Optional[List[str]] = Field(
        None,
        alias="requestHeadersToRemove",
        description="A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.",
    )
    response_headers_to_add: Optional[List[HttpHeaderOption]] = Field(
        None,
        alias="responseHeadersToAdd",
        description="Headers to add the response before sending the response back to the client.",
    )


class MetadataFilter(BaseModel):
    filter_match_criteria: Optional[FilterMatchCriteria] = Field(
        None,
        alias="filterMatchCriteria",
        description="Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata. ",
    )
    filter_labels: Optional[List[MetadataFilterLabelMatch]] = Field(
        None,
        alias="filterLabels",
        description="The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.",
    )


class HttpHeaderMatch(BaseModel):
    prefix_match: Optional[str] = Field(
        None,
        alias="prefixMatch",
        description="The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.",
    )
    range_match: Optional[Int64RangeMatch] = Field(
        None,
        alias="rangeMatch",
        description="The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.",
    )
    regex_match: Optional[str] = Field(
        None,
        alias="regexMatch",
        description="The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.",
    )
    invert_match: Optional[bool] = Field(
        None,
        alias="invertMatch",
        description="If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false. ",
    )
    present_match: Optional[bool] = Field(
        None,
        alias="presentMatch",
        description="A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.",
    )
    exact_match: Optional[str] = Field(
        None,
        alias="exactMatch",
        description="The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.",
    )
    header_name: Optional[str] = Field(
        None,
        alias="headerName",
        description='The name of the HTTP header to match. For matching against the HTTP request\'s authority, use a headerMatch with the header name ":authority". For matching a request\'s method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.',
    )
    suffix_match: Optional[str] = Field(
        None,
        alias="suffixMatch",
        description="The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.",
    )


class NodeGroup(BaseModel):
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    fingerprint: Optional[str] = None
    size: Optional[int] = Field(
        None, description="[Output Only] The total number of nodes in the node group."
    )
    status: Optional[Status2] = None
    maintenance_window: Optional[NodeGroupMaintenanceWindow] = Field(
        None, alias="maintenanceWindow"
    )
    node_template: Optional[str] = Field(
        None,
        alias="nodeTemplate",
        description="URL of the node template to create the node group from.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    kind: Optional[str] = Field(
        "compute#nodeGroup",
        description="[Output Only] The type of the resource. Always compute#nodeGroup for node group.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    autoscaling_policy: Optional[NodeGroupAutoscalingPolicy] = Field(
        None,
        alias="autoscalingPolicy",
        description="Specifies how autoscaling should behave.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The name of the zone where the node group resides, such as us-central1-a.",
    )
    maintenance_policy: Optional[MaintenancePolicy] = Field(
        None,
        alias="maintenancePolicy",
        description="Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    location_hint: Optional[str] = Field(
        None,
        alias="locationHint",
        description="An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.",
    )


class WafExpressionSet(BaseModel):
    id: Optional[str] = Field(
        None,
        description="Google specified expression set ID. The format should be: - E.g. XSS-20170329 required",
    )
    expressions: Optional[List[WafExpressionSetExpression]] = Field(
        None, description="List of available expressions."
    )
    aliases: Optional[List[str]] = Field(
        None,
        description='A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can\'t be used for more than one entity set.',
    )


class ResourcePolicyResourceStatus(BaseModel):
    instance_schedule_policy: Optional[
        ResourcePolicyResourceStatusInstanceSchedulePolicyStatus
    ] = Field(
        None,
        alias="instanceSchedulePolicy",
        description="[Output Only] Specifies a set of output values reffering to the instance_schedule_policy system status. This field should have the same name as corresponding policy field.",
    )


class ResourcePolicyInstanceSchedulePolicy(BaseModel):
    vm_stop_schedule: Optional[ResourcePolicyInstanceSchedulePolicySchedule] = Field(
        None,
        alias="vmStopSchedule",
        description="Specifies the schedule for stopping instances.",
    )
    vm_start_schedule: Optional[ResourcePolicyInstanceSchedulePolicySchedule] = Field(
        None,
        alias="vmStartSchedule",
        description="Specifies the schedule for starting instances.",
    )
    expiration_time: Optional[str] = Field(
        None,
        alias="expirationTime",
        description="The expiration time of the schedule. The timestamp is an RFC3339 string.",
    )
    time_zone: Optional[str] = Field(
        None,
        alias="timeZone",
        description="Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="The start time of the schedule. The timestamp is an RFC3339 string.",
    )


class ResourcePolicyWeeklyCycle(BaseModel):
    day_of_weeks: Optional[List[ResourcePolicyWeeklyCycleDayOfWeek]] = Field(
        None,
        alias="dayOfWeeks",
        description="Up to 7 intervals/windows, one for each day of the week.",
    )


class InstanceGroupManagerStatusStateful(BaseModel):
    per_instance_configs: Optional[InstanceGroupManagerStatusStatefulPerInstanceConfigs] = Field(
        None,
        alias="perInstanceConfigs",
        description="[Output Only] Status of per-instance configurations on the instance.",
    )
    has_stateful_config: Optional[bool] = Field(
        None,
        alias="hasStatefulConfig",
        description="[Output Only] A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful configuration even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions.",
    )


class TargetVpnGatewayList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning10] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[TargetVpnGateway]] = Field(
        None, description="A list of TargetVpnGateway resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#targetVpnGatewayList",
        description="[Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.",
    )


class AllocationSpecificSkuAllocationReservedInstanceProperties(BaseModel):
    guest_accelerators: Optional[List[AcceleratorConfig]] = Field(
        None,
        alias="guestAccelerators",
        description="Specifies accelerator type and count.",
    )
    machine_type: Optional[str] = Field(
        None,
        alias="machineType",
        description="Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.",
    )
    location_hint: Optional[str] = Field(
        None,
        alias="locationHint",
        description="An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.",
    )
    local_ssds: Optional[
        List[AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk]
    ] = Field(
        None,
        alias="localSsds",
        description="Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.",
    )
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description="Minimum cpu platform the reservation.",
    )


class ShareSettings(BaseModel):
    share_type: Optional[ShareType] = Field(
        None,
        alias="shareType",
        description="Type of sharing for this shared-reservation",
    )
    project_map: Optional[Dict[str, ShareSettingsProjectConfig]] = Field(
        None,
        alias="projectMap",
        description="A map of project id and project config. This is only valid when share_type's value is SPECIFIC_PROJECTS.",
    )


class BackendServiceCdnPolicy(BaseModel):
    negative_caching_policy: Optional[List[BackendServiceCdnPolicyNegativeCachingPolicy]] = Field(
        None,
        alias="negativeCachingPolicy",
        description="Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.",
    )
    cache_key_policy: Optional[CacheKeyPolicy] = Field(
        None,
        alias="cacheKeyPolicy",
        description="The CacheKeyPolicy for this CdnPolicy.",
    )
    bypass_cache_on_request_headers: Optional[
        List[BackendServiceCdnPolicyBypassCacheOnRequestHeader]
    ] = Field(
        None,
        alias="bypassCacheOnRequestHeaders",
        description="Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.",
    )
    client_ttl: Optional[int] = Field(
        None,
        alias="clientTtl",
        description='Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).',
    )
    default_ttl: Optional[int] = Field(
        None,
        alias="defaultTtl",
        description='Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.',
    )
    signed_url_cache_max_age_sec: Optional[str] = Field(
        None,
        alias="signedUrlCacheMaxAgeSec",
        description='Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.',
    )
    signed_url_key_names: Optional[List[str]] = Field(
        None,
        alias="signedUrlKeyNames",
        description="[Output Only] Names of the keys for signing request URLs.",
    )
    max_ttl: Optional[int] = Field(
        None,
        alias="maxTtl",
        description='Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.',
    )
    cache_mode: Optional[CacheMode] = Field(
        None,
        alias="cacheMode",
        description='Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google\'s edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.',
    )
    serve_while_stale: Optional[int] = Field(
        None,
        alias="serveWhileStale",
        description='Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.',
    )
    request_coalescing: Optional[bool] = Field(
        None,
        alias="requestCoalescing",
        description="If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.",
    )
    negative_caching: Optional[bool] = Field(
        None,
        alias="negativeCaching",
        description="Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.",
    )


class BackendServiceLocalityLoadBalancingPolicyConfig(BaseModel):
    policy: Optional[BackendServiceLocalityLoadBalancingPolicyConfigPolicy] = None
    custom_policy: Optional[BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy] = Field(
        None, alias="customPolicy"
    )


class ConsistentHashLoadBalancerSettings(BaseModel):
    http_header_name: Optional[str] = Field(
        None,
        alias="httpHeaderName",
        description="The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.",
    )
    http_cookie: Optional[ConsistentHashLoadBalancerSettingsHttpCookie] = Field(
        None,
        alias="httpCookie",
        description="Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    minimum_ring_size: Optional[str] = Field(
        None,
        alias="minimumRingSize",
        description="The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.",
    )


class DiskList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Disk]] = Field(None, description="A list of Disk resources.")
    kind: Optional[str] = Field(
        "compute#diskList",
        description="[Output Only] Type of resource. Always compute#diskList for lists of disks.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning13] = Field(
        None, description="[Output Only] Informational warning message."
    )


class NetworkEndpointGroup(BaseModel):
    size: Optional[int] = Field(
        None,
        description="[Output only] Number of network endpoints in the network endpoint group.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the region where the network endpoint group is located.",
    )
    network: Optional[str] = Field(
        None,
        description='The URL of the network to which all network endpoints in the NEG belong. Uses "default" project network if unspecified.',
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the zone where the network endpoint group is located.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    cloud_function: Optional[NetworkEndpointGroupCloudFunction] = Field(
        None,
        alias="cloudFunction",
        description='Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine or cloudFunction may be set.',
    )
    subnetwork: Optional[str] = Field(
        None,
        description="Optional URL of the subnetwork to which all network endpoints in the NEG belong.",
    )
    kind: Optional[str] = Field(
        "compute#networkEndpointGroup",
        description="[Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    cloud_run: Optional[NetworkEndpointGroupCloudRun] = Field(
        None,
        alias="cloudRun",
        description='Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine or cloudFunction may be set.',
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    default_port: Optional[int] = Field(
        None,
        alias="defaultPort",
        description="The default port used if the port number is not specified in the network endpoint.",
    )
    psc_target_service: Optional[str] = Field(
        None,
        alias="pscTargetService",
        description='The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: "asia-northeast3-cloudkms.googleapis.com"',
    )
    app_engine: Optional[NetworkEndpointGroupAppEngine] = Field(
        None,
        alias="appEngine",
        description='Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine or cloudFunction may be set.',
    )
    network_endpoint_type: Optional[NetworkEndpointType] = Field(
        None,
        alias="networkEndpointType",
        description="Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT.",
    )
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description="Metadata defined as annotations on the network endpoint group.",
    )


class NodeTypesScopedList(BaseModel):
    node_types: Optional[List[NodeType]] = Field(
        None,
        alias="nodeTypes",
        description="[Output Only] A list of node types contained in this scope.",
    )
    warning: Optional[Warning15] = Field(
        None,
        description="[Output Only] An informational warning that appears when the node types list is empty.",
    )


class HttpsHealthCheckList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field("compute#httpsHealthCheckList", description="Type of resource.")
    items: Optional[List[HttpsHealthCheck]] = Field(
        None, description="A list of HttpsHealthCheck resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning18] = Field(
        None, description="[Output Only] Informational warning message."
    )


class VpnGatewayStatusVpnConnection(BaseModel):
    state: Optional[VpnGatewayStatusHighAvailabilityRequirementState] = Field(
        None, description="HighAvailabilityRequirementState for the VPN connection."
    )
    tunnels: Optional[List[VpnGatewayStatusTunnel]] = Field(
        None, description="List of VPN tunnels that are in this VPN connection."
    )
    peer_gcp_gateway: Optional[str] = Field(
        None,
        alias="peerGcpGateway",
        description="URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.",
    )
    peer_external_gateway: Optional[str] = Field(
        None,
        alias="peerExternalGateway",
        description="URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.",
    )


class RouterNatRule(BaseModel):
    action: Optional[RouterNatRuleAction] = Field(
        None,
        description="The action to be enforced for traffic that matches this rule.",
    )
    description: Optional[str] = Field(None, description="An optional description of this rule.")
    match: Optional[str] = Field(
        None,
        description="CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: \"inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')\" \"destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'\" The following example is a valid match expression for private NAT: \"nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'\"",
    )
    rule_number: Optional[int] = Field(
        None,
        alias="ruleNumber",
        description="An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.",
    )


class Project(BaseModel):
    kind: Optional[str] = Field(
        "compute#project",
        description="[Output Only] Type of the resource. Always compute#project for projects.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    default_service_account: Optional[str] = Field(
        None,
        alias="defaultServiceAccount",
        description="[Output Only] Default service account used by VMs running in this project.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.",
    )
    description: Optional[str] = Field(
        None, description="An optional textual description of the resource."
    )
    enabled_features: Optional[List[str]] = Field(
        None,
        alias="enabledFeatures",
        description="Restricted features enabled for use on this project.",
    )
    common_instance_metadata: Optional[Metadata] = Field(
        None,
        alias="commonInstanceMetadata",
        description="Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.",
    )
    xpn_project_status: Optional[XpnProjectStatus] = Field(
        None,
        alias="xpnProjectStatus",
        description="[Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.",
    )
    quotas: Optional[List[Quota]] = Field(
        None, description="[Output Only] Quotas assigned to this project."
    )
    default_network_tier: Optional[NetworkTier] = Field(
        None,
        alias="defaultNetworkTier",
        description="This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    name: Optional[str] = Field(
        None,
        description="The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.",
    )
    usage_export_location: Optional[UsageExportLocation] = Field(
        None,
        alias="usageExportLocation",
        description="The naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.",
    )


class RouterBgpPeer(BaseModel):
    advertised_route_priority: Optional[int] = Field(
        None,
        alias="advertisedRoutePriority",
        description="The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.",
    )
    bfd: Optional[RouterBgpPeerBfd] = Field(
        None, description="BFD configuration for the BGP peering."
    )
    interface_name: Optional[str] = Field(
        None,
        alias="interfaceName",
        description="Name of the interface the BGP peer is associated with.",
    )
    advertised_ip_ranges: Optional[List[RouterAdvertisedIpRange]] = Field(
        None,
        alias="advertisedIpRanges",
        description='User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.',
    )
    advertised_groups: Optional[List[AdvertisedGroup]] = Field(
        None,
        alias="advertisedGroups",
        description='User-specified list of prefix groups to advertise in custom mode, which can take one of the following options: - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets. - ALL_VPC_SUBNETS: Advertises the router\'s own VPC subnets. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.',
    )
    peer_ip_address: Optional[str] = Field(
        None,
        alias="peerIpAddress",
        description="IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.",
    )
    enable_ipv6: Optional[bool] = Field(
        None,
        alias="enableIpv6",
        description="Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.",
    )
    peer_ipv6_nexthop_address: Optional[str] = Field(
        None,
        alias="peerIpv6NexthopAddress",
        description="IPv6 address of the BGP interface outside Google Cloud Platform.",
    )
    peer_asn: Optional[int] = Field(
        None,
        alias="peerAsn",
        description="Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    ipv6_nexthop_address: Optional[str] = Field(
        None,
        alias="ipv6NexthopAddress",
        description="IPv6 address of the interface inside Google Cloud Platform.",
    )
    management_type: Optional[ManagementType] = Field(
        None,
        alias="managementType",
        description="[Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted. ",
    )
    advertise_mode: Optional[AdvertiseMode] = Field(
        None,
        alias="advertiseMode",
        description="User-specified flag to indicate which mode to use for advertisement.",
    )
    enable: Optional[Enable] = Field(
        None,
        description="The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.",
    )
    ip_address: Optional[str] = Field(
        None,
        alias="ipAddress",
        description="IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.",
    )
    router_appliance_instance: Optional[str] = Field(
        None,
        alias="routerApplianceInstance",
        description="URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.",
    )


class AutoscalingPolicyScaleInControl(BaseModel):
    max_scaled_in_replicas: Optional[FixedOrPercent] = Field(
        None,
        alias="maxScaledInReplicas",
        description="Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.",
    )
    time_window_sec: Optional[int] = Field(
        None,
        alias="timeWindowSec",
        description="How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.",
    )


class NetworkEndpointGroupsDetachEndpointsRequest(BaseModel):
    network_endpoints: Optional[List[NetworkEndpoint]] = Field(
        None,
        alias="networkEndpoints",
        description="The list of network endpoints to be detached.",
    )


class Image(BaseModel):
    licenses: Optional[List[str]] = Field(None, description="Any applicable license URI.")
    source_image: Optional[str] = Field(
        None,
        alias="sourceImage",
        description="URL of the source image used to create this image. The following are valid formats for the URL: - https://www.googleapis.com/compute/v1/projects/project_id/global/ images/image_name - projects/project_id/global/images/image_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL ",
    )
    status: Optional[Status10] = Field(
        None,
        description="[Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.",
    )
    archive_size_bytes: Optional[str] = Field(
        None,
        alias="archiveSizeBytes",
        description="Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    source_image_id: Optional[str] = Field(
        None,
        alias="sourceImageId",
        description="[Output Only] The ID value of the image used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given image name.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for the labels being applied to this image, which is essentially a hash of the labels used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an image.",
    )
    image_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="imageEncryptionKey",
        description="Encrypts the image using a customer-supplied encryption key. After you encrypt an image with a customer-supplied key, you must provide the same key if you use the image later (e.g. to create a disk from the image). Customer-supplied encryption keys do not protect access to metadata of the disk. If you do not provide an encryption key when creating the image, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the image later.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    source_snapshot_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceSnapshotEncryptionKey",
        description="The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.",
    )
    shielded_instance_initial_state: Optional[InitialStateConfig] = Field(
        None,
        alias="shieldedInstanceInitialState",
        description="Set the secure boot keys of shielded instance.",
    )
    disk_size_gb: Optional[str] = Field(
        None,
        alias="diskSizeGb",
        description="Size of the image when restored onto a persistent disk (in GB).",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    license_codes: Optional[List[str]] = Field(
        None,
        alias="licenseCodes",
        description="Integer license codes indicating which licenses are attached to this image.",
    )
    source_disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceDiskEncryptionKey",
        description="The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.",
    )
    deprecated: Optional[DeprecationStatus] = Field(
        None, description="The deprecation status associated with this image."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    source_image_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceImageEncryptionKey",
        description="The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.",
    )
    family: Optional[str] = Field(
        None,
        description="The name of the image family to which this image belongs. You can create disks by specifying an image family instead of a specific image name. The image family always returns its latest image that is not deprecated. The name of the image family must comply with RFC1035.",
    )
    guest_os_features: Optional[List[GuestOsFeature]] = Field(
        None,
        alias="guestOsFeatures",
        description="A list of features to enable on the guest operating system. Applicable only for bootable images. To see a list of available options, see the guestOSfeatures[].type parameter.",
    )
    raw_disk: Optional[RawDisk] = Field(
        None, alias="rawDisk", description="The parameters of the raw disk image."
    )
    storage_locations: Optional[List[str]] = Field(
        None,
        alias="storageLocations",
        description="Cloud Storage bucket storage location of the image (regional or multi-regional).",
    )
    source_disk_id: Optional[str] = Field(
        None,
        alias="sourceDiskId",
        description="[Output Only] The ID value of the disk used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given disk name.",
    )
    source_type: Optional[SourceType] = Field(
        "RAW",
        alias="sourceType",
        description="The type of the image used to create this disk. The default and only valid value is RAW.",
    )
    source_disk: Optional[str] = Field(
        None,
        alias="sourceDisk",
        description="URL of the source disk used to create this image. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL ",
    )
    kind: Optional[str] = Field(
        "compute#image",
        description="[Output Only] Type of the resource. Always compute#image for images.",
    )
    source_snapshot: Optional[str] = Field(
        None,
        alias="sourceSnapshot",
        description="URL of the source snapshot used to create this image. The following are valid formats for the URL: - https://www.googleapis.com/compute/v1/projects/project_id/global/ snapshots/snapshot_name - projects/project_id/global/snapshots/snapshot_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL ",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to this image. These can be later modified by the setLabels method.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    source_snapshot_id: Optional[str] = Field(
        None,
        alias="sourceSnapshotId",
        description="[Output Only] The ID value of the snapshot used to create this image. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given snapshot name.",
    )


class NodeTypeAggregatedList(BaseModel):
    kind: Optional[str] = Field(
        "compute#nodeTypeAggregatedList",
        description="[Output Only] Type of resource.Always compute#nodeTypeAggregatedList for aggregated lists of node types.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning22] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[Dict[str, NodeTypesScopedList]] = Field(
        None, description="A list of NodeTypesScopedList resources."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class VpnGatewayStatus(BaseModel):
    vpn_connections: Optional[List[VpnGatewayStatusVpnConnection]] = Field(
        None,
        alias="vpnConnections",
        description="List of VPN connection for this VpnGateway.",
    )


class InterconnectAttachment(BaseModel):
    ipsec_internal_addresses: Optional[List[str]] = Field(
        None,
        alias="ipsecInternalAddresses",
        description="A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool. Not currently available publicly. ",
    )
    candidate_ipv6_subnets: Optional[List[str]] = Field(
        None, alias="candidateIpv6Subnets", description="This field is not available."
    )
    edge_availability_domain: Optional[EdgeAvailabilityDomain] = Field(
        None,
        alias="edgeAvailabilityDomain",
        description="Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.",
    )
    partner_asn: Optional[str] = Field(
        None,
        alias="partnerAsn",
        description="Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.",
    )
    stack_type: Optional[StackType] = Field(
        None,
        alias="stackType",
        description="The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.",
    )
    customer_router_ip_address: Optional[str] = Field(
        None,
        alias="customerRouterIpAddress",
        description="[Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.",
    )
    bandwidth: Optional[Bandwidth] = Field(
        None,
        description="Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s ",
    )
    interconnect: Optional[str] = Field(
        None,
        description="URL of the underlying Interconnect object that this attachment's traffic will traverse through.",
    )
    google_reference_id: Optional[str] = Field(
        None,
        alias="googleReferenceId",
        description="[Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.",
    )
    partner_metadata: Optional[InterconnectAttachmentPartnerMetadata] = Field(
        None,
        alias="partnerMetadata",
        description="Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.",
    )
    cloud_router_ip_address: Optional[str] = Field(
        None,
        alias="cloudRouterIpAddress",
        description="[Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.",
    )
    admin_enabled: Optional[bool] = Field(
        None,
        alias="adminEnabled",
        description="Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    kind: Optional[str] = Field(
        "compute#interconnectAttachment",
        description="[Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.",
    )
    description: Optional[str] = Field(
        None, description="An optional description of this resource."
    )
    candidate_subnets: Optional[List[str]] = Field(
        None,
        alias="candidateSubnets",
        description="Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.",
    )
    mtu: Optional[int] = Field(
        None,
        description="Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.",
    )
    customer_router_ipv6_address: Optional[str] = Field(
        None,
        alias="customerRouterIpv6Address",
        description="[Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    vlan_tag8021q: Optional[int] = Field(
        None,
        alias="vlanTag8021q",
        description="The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.",
    )
    type: Optional[Type9] = Field(
        None,
        description="The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner. ",
    )
    encryption: Optional[Encryption] = Field(
        None,
        description="Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *IPsec-encrypted Cloud Interconnect*, the VLAN attachment must be created with this option. Not currently available publicly. ",
    )
    operational_status: Optional[OperationalStatus] = Field(
        None,
        alias="operationalStatus",
        description="[Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. ",
    )
    cloud_router_ipv6_interface_id: Optional[str] = Field(
        None,
        alias="cloudRouterIpv6InterfaceId",
        description="This field is not available.",
    )
    private_interconnect_info: Optional[InterconnectAttachmentPrivateInfo] = Field(
        None,
        alias="privateInterconnectInfo",
        description="[Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.",
    )
    pairing_key: Optional[str] = Field(
        None,
        alias="pairingKey",
        description='[Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"',
    )
    router: Optional[str] = Field(
        None,
        description="URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.",
    )
    customer_router_ipv6_interface_id: Optional[str] = Field(
        None,
        alias="customerRouterIpv6InterfaceId",
        description="This field is not available.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None,
        alias="satisfiesPzs",
        description="[Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.",
    )
    state: Optional[State5] = Field(
        None,
        description="[Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted. ",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    cloud_router_ipv6_address: Optional[str] = Field(
        None,
        alias="cloudRouterIpv6Address",
        description="[Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    dataplane_version: Optional[int] = Field(
        None,
        alias="dataplaneVersion",
        description="[Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.",
    )


class VmEndpointNatMappings(BaseModel):
    instance_name: Optional[str] = Field(
        None,
        alias="instanceName",
        description="Name of the VM instance which the endpoint belongs to",
    )
    interface_nat_mappings: Optional[List[VmEndpointNatMappingsInterfaceNatMappings]] = Field(
        None, alias="interfaceNatMappings"
    )


class SnapshotList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field("compute#snapshotList", description="Type of resource.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning25] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[Snapshot]] = Field(None, description="A list of Snapshot resources.")


class FirewallPoliciesListAssociationsResponse(BaseModel):
    associations: Optional[List[FirewallPolicyAssociation]] = Field(
        None, description="A list of associations."
    )
    kind: Optional[str] = Field(
        "compute#firewallPoliciesListAssociationsResponse",
        description="[Output Only] Type of firewallPolicy associations. Always compute#FirewallPoliciesListAssociations for lists of firewallPolicy associations.",
    )


class PublicAdvertisedPrefix(BaseModel):
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The IPv4 address range, in CIDR format, represented by this public advertised prefix.",
    )
    shared_secret: Optional[str] = Field(
        None,
        alias="sharedSecret",
        description="[Output Only] The shared secret to be used for reverse DNS verification.",
    )
    kind: Optional[str] = Field(
        "compute#publicAdvertisedPrefix",
        description="[Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.",
    )
    status: Optional[Status12] = Field(
        None,
        description="The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed. ",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    dns_verification_ip: Optional[str] = Field(
        None,
        alias="dnsVerificationIp",
        description="The IPv4 address to be used for reverse DNS verification.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    public_delegated_prefixs: Optional[List[PublicAdvertisedPrefixPublicDelegatedPrefix]] = Field(
        None,
        alias="publicDelegatedPrefixs",
        description="[Output Only] The list of public delegated prefixes that exist for this public advertised prefix.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource type. The server generates this identifier.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )


class PublicDelegatedPrefix(BaseModel):
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    status: Optional[Status14] = Field(
        None,
        description="[Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned. ",
    )
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The IPv4 address range, in CIDR format, represented by this public delegated prefix.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource type. The server generates this identifier.",
    )
    public_delegated_sub_prefixs: Optional[
        List[PublicDelegatedPrefixPublicDelegatedSubPrefix]
    ] = Field(
        None,
        alias="publicDelegatedSubPrefixs",
        description="The list of sub public delegated prefixes that exist for this public delegated prefix.",
    )
    parent_prefix: Optional[str] = Field(
        None,
        alias="parentPrefix",
        description="The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    is_live_migration: Optional[bool] = Field(
        None,
        alias="isLiveMigration",
        description="If true, the prefix will be live migrated.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    kind: Optional[str] = Field(
        "compute#publicDelegatedPrefix",
        description="[Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.",
    )


class InstanceGroupList(BaseModel):
    items: Optional[List[InstanceGroup]] = Field(
        None, description="A list of InstanceGroup resources."
    )
    warning: Optional[Warning28] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#instanceGroupList",
        description="[Output Only] The resource type, which is always compute#instanceGroupList for instance group lists.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class DiskTypesScopedList(BaseModel):
    warning: Optional[Warning29] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of disk types when the list is empty.",
    )
    disk_types: Optional[List[DiskType]] = Field(
        None,
        alias="diskTypes",
        description="[Output Only] A list of disk types contained in this scope.",
    )


class UrlMapValidationResult(BaseModel):
    load_succeeded: Optional[bool] = Field(
        None,
        alias="loadSucceeded",
        description="Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.",
    )
    test_passed: Optional[bool] = Field(
        None,
        alias="testPassed",
        description="If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.",
    )
    test_failures: Optional[List[TestFailure]] = Field(None, alias="testFailures")
    load_errors: Optional[List[str]] = Field(None, alias="loadErrors")


class VpnTunnelAggregatedList(BaseModel):
    kind: Optional[str] = Field(
        "compute#vpnTunnelAggregatedList",
        description="[Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning30] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[Dict[str, VpnTunnelsScopedList]] = Field(
        None, description="A list of VpnTunnelsScopedList resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class SourceInstanceProperties(BaseModel):
    service_accounts: Optional[List[ServiceAccount]] = Field(
        None,
        alias="serviceAccounts",
        description="A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.",
    )
    can_ip_forward: Optional[bool] = Field(
        None,
        alias="canIpForward",
        description="Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.",
    )
    scheduling: Optional[Scheduling] = Field(
        None,
        description="Specifies the scheduling options for the instances that are created from this machine image.",
    )
    deletion_protection: Optional[bool] = Field(
        None,
        alias="deletionProtection",
        description="Whether the instance created from this machine image should be protected against deletion.",
    )
    disks: Optional[List[SavedAttachedDisk]] = Field(
        None,
        description="An array of disks that are associated with the instances that are created from this machine image.",
    )
    tags: Optional[Tags] = Field(
        None,
        description="A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.",
    )
    guest_accelerators: Optional[List[AcceleratorConfig]] = Field(
        None,
        alias="guestAccelerators",
        description="A list of guest accelerator cards' type and count to use for instances created from this machine image.",
    )
    machine_type: Optional[str] = Field(
        None,
        alias="machineType",
        description="The machine type to use for instances that are created from this machine image.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to instances that are created from this machine image.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional text description for the instances that are created from this machine image.",
    )
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description='Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.',
    )
    network_interfaces: Optional[List[NetworkInterface]] = Field(
        None,
        alias="networkInterfaces",
        description="An array of network access configurations for this interface.",
    )
    metadata: Optional[Metadata] = Field(
        None,
        description="The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.",
    )


class InstanceManagedByIgmErrorInstanceActionDetails(BaseModel):
    version: Optional[ManagedInstanceVersion] = Field(
        None,
        description="[Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.",
    )
    action: Optional[Action] = Field(
        None,
        description="[Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:",
    )
    instance: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.",
    )


class HealthStatusForNetworkEndpoint(BaseModel):
    health_check_service: Optional[HealthCheckServiceReference] = Field(
        None,
        alias="healthCheckService",
        description="URL of the health check service associated with the health state of the network endpoint.",
    )
    health_check: Optional[HealthCheckReference] = Field(
        None,
        alias="healthCheck",
        description="URL of the health check associated with the health state of the network endpoint.",
    )
    forwarding_rule: Optional[ForwardingRuleReference] = Field(
        None,
        alias="forwardingRule",
        description="URL of the forwarding rule associated with the health state of the network endpoint.",
    )
    health_state: Optional[HealthState] = Field(
        None,
        alias="healthState",
        description="Health state of the network endpoint determined based on the health checks configured.",
    )
    backend_service: Optional[BackendServiceReference] = Field(
        None,
        alias="backendService",
        description="URL of the backend service associated with the health state of the network endpoint.",
    )


class ServiceAttachment(BaseModel):
    connected_endpoints: Optional[List[ServiceAttachmentConnectedEndpoint]] = Field(
        None,
        alias="connectedEndpoints",
        description="[Output Only] An array of connections for all the consumers connected to this service attachment.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource type. The server generates this identifier.",
    )
    psc_service_attachment_id: Optional[Uint128] = Field(
        None,
        alias="pscServiceAttachmentId",
        description="[Output Only] An 128-bit global unique ID of the PSC service attachment.",
    )
    consumer_reject_lists: Optional[List[str]] = Field(
        None,
        alias="consumerRejectLists",
        description="Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.",
    )
    producer_forwarding_rule: Optional[str] = Field(
        None,
        alias="producerForwardingRule",
        description="The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.",
    )
    connection_preference: Optional[ConnectionPreference] = Field(
        None,
        alias="connectionPreference",
        description="The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    nat_subnets: Optional[List[str]] = Field(
        None,
        alias="natSubnets",
        description="An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.",
    )
    domain_names: Optional[List[str]] = Field(
        None,
        alias="domainNames",
        description='If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.',
    )
    consumer_accept_lists: Optional[List[ServiceAttachmentConsumerProjectLimit]] = Field(
        None,
        alias="consumerAcceptLists",
        description="Projects that are allowed to connect to this service attachment.",
    )
    enable_proxy_protocol: Optional[bool] = Field(
        None,
        alias="enableProxyProtocol",
        description="If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.",
    )
    kind: Optional[str] = Field(
        "compute#serviceAttachment",
        description="[Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.",
    )
    target_service: Optional[str] = Field(
        None,
        alias="targetService",
        description="The URL of a service serving the endpoint identified by this service attachment.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class NotificationEndpointList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#notificationEndpointList",
        description="[Output Only] Type of the resource. Always compute#notificationEndpoint for notification endpoints.",
    )
    items: Optional[List[NotificationEndpoint]] = Field(
        None, description="A list of NotificationEndpoint resources."
    )
    warning: Optional[Warning35] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class TargetSslProxyList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field("compute#targetSslProxyList", description="Type of resource.")
    warning: Optional[Warning36] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[TargetSslProxy]] = Field(
        None, description="A list of TargetSslProxy resources."
    )


class HealthCheck(BaseModel):
    grpc_health_check: Optional[GrpcHealthCheck] = Field(None, alias="grpcHealthCheck")
    kind: Optional[str] = Field("compute#healthCheck", description="Type of the resource.")
    healthy_threshold: Optional[int] = Field(
        None,
        alias="healthyThreshold",
        description="A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.",
    )
    http2_health_check: Optional[Http2HealthCheck] = Field(None, alias="http2HealthCheck")
    timeout_sec: Optional[int] = Field(
        None,
        alias="timeoutSec",
        description="How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.",
    )
    http_health_check: Optional[HttpHealthCheck] = Field(None, alias="httpHealthCheck")
    check_interval_sec: Optional[int] = Field(
        None,
        alias="checkIntervalSec",
        description="How often (in seconds) to send a health check. The default value is 5 seconds.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    https_health_check: Optional[HttpsHealthCheck1] = Field(None, alias="httpsHealthCheck")
    region: Optional[str] = Field(
        None,
        description="[Output Only] Region where the health check resides. Not applicable to global health checks.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in 3339 text format.",
    )
    unhealthy_threshold: Optional[int] = Field(
        None,
        alias="unhealthyThreshold",
        description="A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.",
    )
    tcp_health_check: Optional[TcpHealthCheck] = Field(None, alias="tcpHealthCheck")
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.",
    )
    log_config: Optional[HealthCheckLogConfig] = Field(
        None, alias="logConfig", description="Configure logging on this health check."
    )
    type: Optional[Type11] = Field(
        None,
        description="Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. Exactly one of the protocol-specific health check field must be specified, which must match type field.",
    )
    ssl_health_check: Optional[SslHealthCheck] = Field(None, alias="sslHealthCheck")
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )


class NodeGroupsScopedList(BaseModel):
    node_groups: Optional[List[NodeGroup]] = Field(
        None,
        alias="nodeGroups",
        description="[Output Only] A list of node groups contained in this scope.",
    )
    warning: Optional[Warning39] = Field(
        None,
        description="[Output Only] An informational warning that appears when the nodeGroup list is empty.",
    )


class AddressesScopedList(BaseModel):
    warning: Optional[Warning40] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of addresses when the list is empty.",
    )
    addresses: Optional[List[Address]] = Field(
        None, description="[Output Only] A list of addresses contained in this scope."
    )


class BackendBucketCdnPolicy(BaseModel):
    negative_caching_policy: Optional[List[BackendBucketCdnPolicyNegativeCachingPolicy]] = Field(
        None,
        alias="negativeCachingPolicy",
        description="Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.",
    )
    bypass_cache_on_request_headers: Optional[
        List[BackendBucketCdnPolicyBypassCacheOnRequestHeader]
    ] = Field(
        None,
        alias="bypassCacheOnRequestHeaders",
        description="Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.",
    )
    signed_url_cache_max_age_sec: Optional[str] = Field(
        None,
        alias="signedUrlCacheMaxAgeSec",
        description='Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.',
    )
    serve_while_stale: Optional[int] = Field(
        None,
        alias="serveWhileStale",
        description='Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.',
    )
    request_coalescing: Optional[bool] = Field(
        None,
        alias="requestCoalescing",
        description="If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.",
    )
    cache_key_policy: Optional[BackendBucketCdnPolicyCacheKeyPolicy] = Field(
        None,
        alias="cacheKeyPolicy",
        description="The CacheKeyPolicy for this CdnPolicy.",
    )
    signed_url_key_names: Optional[List[str]] = Field(
        None,
        alias="signedUrlKeyNames",
        description="[Output Only] Names of the keys for signing request URLs.",
    )
    client_ttl: Optional[int] = Field(
        None,
        alias="clientTtl",
        description='Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).',
    )
    negative_caching: Optional[bool] = Field(
        None,
        alias="negativeCaching",
        description="Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.",
    )
    cache_mode: Optional[CacheMode] = Field(
        None,
        alias="cacheMode",
        description='Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google\'s edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.',
    )
    default_ttl: Optional[int] = Field(
        None,
        alias="defaultTtl",
        description='Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.',
    )
    max_ttl: Optional[int] = Field(
        None,
        alias="maxTtl",
        description='Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.',
    )


class RegionInstanceGroupsListInstances(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning42] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[InstanceWithNamedPorts]] = Field(
        None, description="A list of InstanceWithNamedPorts resources."
    )
    kind: Optional[str] = Field(
        "compute#regionInstanceGroupsListInstances", description="The resource type."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class NodeTemplate(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    disks: Optional[List[LocalDisk]] = None
    server_binding: Optional[ServerBinding] = Field(
        None,
        alias="serverBinding",
        description="Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.",
    )
    cpu_overcommit_type: Optional[CpuOvercommitType] = Field(
        None, alias="cpuOvercommitType", description="CPU overcommit."
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The name of the region where the node template resides, such as us-central1.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    accelerators: Optional[List[AcceleratorConfig]] = None
    kind: Optional[str] = Field(
        "compute#nodeTemplate",
        description="[Output Only] The type of the resource. Always compute#nodeTemplate for node templates.",
    )
    node_affinity_labels: Optional[Dict[str, str]] = Field(
        None,
        alias="nodeAffinityLabels",
        description="Labels to use for node affinity, which will be used in instance scheduling.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="[Output Only] An optional, human-readable explanation of the status.",
    )
    node_type_flexibility: Optional[NodeTemplateNodeTypeFlexibility] = Field(
        None,
        alias="nodeTypeFlexibility",
        description="The flexible properties of the desired node type. Node groups that use this node template will create nodes of a type that matches these properties. This field is mutually exclusive with the node_type property; you can only define one or the other, but not both.",
    )
    status: Optional[Status2] = Field(
        None,
        description="[Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    node_type: Optional[str] = Field(
        None,
        alias="nodeType",
        description="The node type to use for nodes group that are created from this template.",
    )


class VmEndpointNatMappingsList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning45] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#vmEndpointNatMappingsList",
        description="[Output Only] Type of resource. Always compute#vmEndpointNatMappingsList for lists of Nat mappings of VM endpoints.",
    )
    result: Optional[List[VmEndpointNatMappings]] = Field(
        None,
        description="[Output Only] A list of Nat mapping information of VM endpoints.",
    )


class SourceInstanceParams(BaseModel):
    disk_configs: Optional[List[DiskInstantiationConfig]] = Field(
        None,
        alias="diskConfigs",
        description="Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.",
    )


class LogConfigCloudAuditOptions(BaseModel):
    authorization_logging_options: Optional[AuthorizationLoggingOptions] = Field(
        None,
        alias="authorizationLoggingOptions",
        description="This is deprecated and has no effect. Do not use.",
    )
    log_name: Optional[LogName] = Field(
        None,
        alias="logName",
        description="This is deprecated and has no effect. Do not use.",
    )


class LogConfigCounterOptions(BaseModel):
    custom_fields: Optional[List[LogConfigCounterOptionsCustomField]] = Field(
        None,
        alias="customFields",
        description="This is deprecated and has no effect. Do not use.",
    )
    field: Optional[str] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    metric: Optional[str] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )


class LicenseCode(BaseModel):
    transferable: Optional[bool] = Field(
        None,
        description="[Output Only] If true, the license will remain attached when creating images or snapshots from disks. Otherwise, the license is not transferred.",
    )
    state: Optional[State6] = Field(
        None, description="[Output Only] Current state of this License Code."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    name: Optional[constr(regex=r"[0-9]{0,20}?")] = Field(
        None,
        description="[Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit integer.",
    )
    description: Optional[str] = Field(
        None, description="[Output Only] Description of this License Code."
    )
    license_alias: Optional[List[LicenseCodeLicenseAlias]] = Field(
        None,
        alias="licenseAlias",
        description="[Output Only] URL and description aliases of Licenses with the same License Code.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    kind: Optional[str] = Field(
        "compute#licenseCode",
        description="[Output Only] Type of resource. Always compute#licenseCode for licenses.",
    )


class LocationPolicy(BaseModel):
    locations: Optional[Dict[str, LocationPolicyLocation]] = Field(
        None,
        description="Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.",
    )
    target_shape: Optional[TargetShape] = Field(
        None,
        alias="targetShape",
        description="Strategy for distributing VMs across zones in a region.",
    )


class TargetHttpProxiesScopedList(BaseModel):
    warning: Optional[Warning46] = Field(
        None,
        description="Informational warning which replaces the list of backend services when the list is empty.",
    )
    target_http_proxies: Optional[List[TargetHttpProxy]] = Field(
        None,
        alias="targetHttpProxies",
        description="A list of TargetHttpProxies contained in this scope.",
    )


class PublicDelegatedPrefixesScopedList(BaseModel):
    warning: Optional[Warning48] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of public delegated prefixes when the list is empty.",
    )
    public_delegated_prefixes: Optional[List[PublicDelegatedPrefix]] = Field(
        None,
        alias="publicDelegatedPrefixes",
        description="[Output Only] A list of PublicDelegatedPrefixes contained in this scope.",
    )


class NetworkEndpointGroupsScopedList(BaseModel):
    warning: Optional[Warning50] = Field(
        None,
        description="[Output Only] An informational warning that replaces the list of network endpoint groups when the list is empty.",
    )
    network_endpoint_groups: Optional[List[NetworkEndpointGroup]] = Field(
        None,
        alias="networkEndpointGroups",
        description="[Output Only] The list of network endpoint groups that are contained in this scope.",
    )


class ForwardingRule(BaseModel):
    service_label: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        alias="serviceLabel",
        description="An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    allow_global_access: Optional[bool] = Field(
        None,
        alias="allowGlobalAccess",
        description="This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    ip_protocol: Optional[IpProtocol] = Field(
        None,
        alias="IPProtocol",
        description="The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).",
    )
    service_directory_registrations: Optional[
        List[ForwardingRuleServiceDirectoryRegistration]
    ] = Field(
        None,
        alias="serviceDirectoryRegistrations",
        description="Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.",
    )
    port_range: Optional[str] = Field(
        None,
        alias="portRange",
        description="This field can be used only if: - Load balancing scheme is one of EXTERNAL, INTERNAL_SELF_MANAGED or INTERNAL_MANAGED - IPProtocol is one of TCP, UDP, or SCTP. Packets addressed to ports in the specified range will be forwarded to target or backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint ports. Some types of forwarding target have constraints on the acceptable ports. For more information, see [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications). @pattern: \\\\d+(?:-\\\\d+)?",
    )
    backend_service: Optional[str] = Field(
        None,
        alias="backendService",
        description="Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.",
    )
    network: Optional[str] = Field(
        None,
        description="This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.",
    )
    kind: Optional[str] = Field(
        "compute#forwardingRule",
        description="[Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.",
    )
    load_balancing_scheme: Optional[LoadBalancingScheme2] = Field(
        None,
        alias="loadBalancingScheme",
        description="Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.",
    )
    subnetwork: Optional[str] = Field(
        None,
        description="This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.",
    )
    all_ports: Optional[bool] = Field(
        None,
        alias="allPorts",
        description="This field is used along with the backend_service field for Internal TCP/UDP Load Balancing or Network Load Balancing, or with the target field for internal and external TargetInstance. You can only use one of ports and port_range, or allPorts. The three are mutually exclusive. For TCP, UDP and SCTP traffic, packets addressed to any ports will be forwarded to the target or backendService.",
    )
    psc_connection_status: Optional[Status17] = Field(None, alias="pscConnectionStatus")
    is_mirroring_collector: Optional[bool] = Field(
        None,
        alias="isMirroringCollector",
        description="Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    no_automate_dns_zone: Optional[bool] = Field(
        None,
        alias="noAutomateDnsZone",
        description="This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.",
    )
    network_tier: Optional[NetworkTier] = Field(
        None,
        alias="networkTier",
        description="This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.",
    )
    ports: Optional[List[str]] = Field(
        None,
        description="The ports field is only supported when the forwarding rule references a backend_service directly. Only packets addressed to the [specified list of ports]((https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)) are forwarded to backends. You can only use one of ports and port_range, or allPorts. The three are mutually exclusive. You can specify a list of up to five ports, which can be non-contiguous. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint ports. @pattern: \\\\d+(?:-\\\\d+)?",
    )
    service_name: Optional[str] = Field(
        None,
        alias="serviceName",
        description="[Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.",
    )
    metadata_filters: Optional[List[MetadataFilter]] = Field(
        None,
        alias="metadataFilters",
        description="Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.",
    )
    target: Optional[str] = None
    psc_connection_id: Optional[str] = Field(
        None,
        alias="pscConnectionId",
        description="[Output Only] The PSC connection id of the PSC Forwarding Rule.",
    )
    ip_version: Optional[IpVersion] = Field(
        None,
        alias="ipVersion",
        description="The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.",
    )
    ip_address: Optional[str] = Field(
        None,
        alias="IPAddress",
        description="IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region /addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.",
    )


class Subnetwork(BaseModel):
    state: Optional[State7] = Field(
        None,
        description="[Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY",
    )
    internal_ipv6_prefix: Optional[str] = Field(
        None,
        alias="internalIpv6Prefix",
        description="[Output Only] The internal IPv6 address range that is assigned to this subnetwork.",
    )
    ipv6_access_type: Optional[Ipv6AccessType] = Field(
        None,
        alias="ipv6AccessType",
        description="The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.",
    )
    gateway_address: Optional[str] = Field(
        None,
        alias="gatewayAddress",
        description="[Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.",
    )
    network: Optional[str] = Field(
        None,
        description="The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.",
    )
    ipv6_cidr_range: Optional[str] = Field(
        None,
        alias="ipv6CidrRange",
        description="[Output Only] This field is for internal use.",
    )
    private_ip_google_access: Optional[bool] = Field(
        None,
        alias="privateIpGoogleAccess",
        description="Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.",
    )
    stack_type: Optional[StackType] = Field(
        None,
        alias="stackType",
        description="The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.",
    )
    role: Optional[Role] = Field(
        None,
        description="The role of subnetwork. Currently, this field is only used when purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.",
    )
    secondary_ip_ranges: Optional[List[SubnetworkSecondaryRange]] = Field(
        None,
        alias="secondaryIpRanges",
        description="An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.",
    )
    region: Optional[str] = Field(
        None,
        description="URL of the region where the Subnetwork resides. This field can be set only at resource creation time.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    private_ipv6_google_access: Optional[PrivateIpv6GoogleAccess2] = Field(
        None,
        alias="privateIpv6GoogleAccess",
        description="This field is for internal use. This field can be both set at resource creation time and updated using patch.",
    )
    enable_flow_logs: Optional[bool] = Field(
        None,
        alias="enableFlowLogs",
        description="Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    external_ipv6_prefix: Optional[str] = Field(
        None,
        alias="externalIpv6Prefix",
        description="[Output Only] The external IPv6 address range that is assigned to this subnetwork.",
    )
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.",
    )
    purpose: Optional[Purpose1] = Field(
        None,
        description="The purpose of the resource. This field can be either PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is reserved for Internal HTTP(S) Load Balancing. If unspecified, the purpose defaults to PRIVATE_RFC_1918. The enableFlowLogs field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.",
    )
    log_config: Optional[SubnetworkLogConfig] = Field(
        None,
        alias="logConfig",
        description="This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.",
    )
    kind: Optional[str] = Field(
        "compute#subnetwork",
        description="[Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.",
    )


class ForwardingRuleList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[ForwardingRule]] = Field(
        None, description="A list of ForwardingRule resources."
    )
    kind: Optional[str] = Field("compute#forwardingRuleList", description="Type of resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning53] = Field(
        None, description="[Output Only] Informational warning message."
    )


class ManagedInstance(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output only] The unique identifier for this resource. This field is empty when instance does not exist.",
    )
    instance: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.",
    )
    preserved_state_from_policy: Optional[PreservedState] = Field(
        None,
        alias="preservedStateFromPolicy",
        description="[Output Only] Preserved state generated based on stateful policy for this instance.",
    )
    version: Optional[ManagedInstanceVersion] = Field(
        None, description="[Output Only] Intended version of this instance."
    )
    last_attempt: Optional[ManagedInstanceLastAttempt] = Field(
        None,
        alias="lastAttempt",
        description="[Output Only] Information about the last attempt to create or delete the instance.",
    )
    instance_status: Optional[Status8] = Field(
        None,
        alias="instanceStatus",
        description="[Output Only] The status of the instance. This field is empty when the instance does not exist.",
    )
    instance_health: Optional[List[ManagedInstanceInstanceHealth]] = Field(
        None,
        alias="instanceHealth",
        description="[Output Only] Health state of the instance per health-check.",
    )
    current_action: Optional[Action] = Field(
        None,
        alias="currentAction",
        description="[Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified. ",
    )
    preserved_state_from_config: Optional[PreservedState] = Field(
        None,
        alias="preservedStateFromConfig",
        description="[Output Only] Preserved state applied from per-instance config for this instance.",
    )


class Network(BaseModel):
    i_pv4_range: Optional[constr(regex=r"[0-9]{1,3}(?:\.[0-9]{1,3}){3}/[0-9]{1,2}")] = Field(
        None,
        alias="IPv4Range",
        description="Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    internal_ipv6_range: Optional[str] = Field(
        None,
        alias="internalIpv6Range",
        description="When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .",
    )
    auto_create_subnetworks: Optional[bool] = Field(
        None,
        alias="autoCreateSubnetworks",
        description="Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.",
    )
    kind: Optional[str] = Field(
        "compute#network",
        description="[Output Only] Type of the resource. Always compute#network for networks.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this field when you create the resource.",
    )
    gateway_i_pv4: Optional[constr(regex=r"[0-9]{1,3}(?:\.[0-9]{1,3}){3}")] = Field(
        None,
        alias="gatewayIPv4",
        description="[Output Only] The gateway address for default routing out of the network, selected by GCP.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    enable_ula_internal_ipv6: Optional[bool] = Field(
        None,
        alias="enableUlaInternalIpv6",
        description="Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .",
    )
    network_firewall_policy_enforcement_order: Optional[
        NetworkFirewallPolicyEnforcementOrder
    ] = Field(
        None,
        alias="networkFirewallPolicyEnforcementOrder",
        description="The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.",
    )
    routing_config: Optional[NetworkRoutingConfig] = Field(
        None,
        alias="routingConfig",
        description="The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    self_link_with_id: Optional[str] = Field(
        None,
        alias="selfLinkWithId",
        description="[Output Only] Server-defined URL for this resource with the resource id.",
    )
    mtu: Optional[int] = Field(
        None,
        description="Maximum Transmission Unit in bytes. The minimum value for this field is 1460 and the maximum value is 1500 bytes. If unspecified, defaults to 1460.",
    )
    peerings: Optional[List[NetworkPeering]] = Field(
        None, description="[Output Only] A list of network peerings for the resource."
    )
    subnetworks: Optional[List[str]] = Field(
        None,
        description="[Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.",
    )


class NodeGroupsListNodes(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[NodeGroupNode]] = Field(None, description="A list of Node resources.")
    kind: Optional[str] = Field(
        "compute#nodeGroupsListNodes",
        description="[Output Only] The resource type, which is always compute.nodeGroupsListNodes for the list of nodes in the specified node group.",
    )
    warning: Optional[Warning57] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class AddressAggregatedList(BaseModel):
    warning: Optional[Warning58] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#addressAggregatedList",
        description="[Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[Dict[str, AddressesScopedList]] = Field(
        None, description="A list of AddressesScopedList resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class TargetVpnGatewayAggregatedList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[Dict[str, TargetVpnGatewaysScopedList]] = Field(
        None, description="A list of TargetVpnGateway resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#targetVpnGatewayAggregatedList",
        description="[Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.",
    )
    warning: Optional[Warning59] = Field(
        None, description="[Output Only] Informational warning message."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class NodeTemplateList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#nodeTemplateList",
        description="[Output Only] Type of resource.Always compute#nodeTemplateList for lists of node templates.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning61] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[NodeTemplate]] = Field(
        None, description="A list of NodeTemplate resources."
    )


class DistributionPolicy(BaseModel):
    zones: Optional[List[DistributionPolicyZoneConfiguration]] = Field(
        None,
        description="Zones where the regional managed instance group will create and manage its instances.",
    )
    target_shape: Optional[TargetShape1] = Field(
        None,
        alias="targetShape",
        description="The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).",
    )


class HealthChecksScopedList(BaseModel):
    health_checks: Optional[List[HealthCheck]] = Field(
        None,
        alias="healthChecks",
        description="A list of HealthChecks contained in this scope.",
    )
    warning: Optional[Warning65] = Field(
        None,
        description="Informational warning which replaces the list of backend services when the list is empty.",
    )


class InterconnectDiagnosticsLinkStatus(BaseModel):
    transmitting_optical_power: Optional[InterconnectDiagnosticsLinkOpticalPower] = Field(
        None,
        alias="transmittingOpticalPower",
        description="An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.",
    )
    lacp_status: Optional[InterconnectDiagnosticsLinkLacpStatus] = Field(None, alias="lacpStatus")
    arp_caches: Optional[List[InterconnectDiagnosticsArpEntry]] = Field(
        None,
        alias="arpCaches",
        description="A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled",
    )
    google_demarc: Optional[str] = Field(
        None,
        alias="googleDemarc",
        description="The Demarc address assigned by Google and provided in the LoA.",
    )
    receiving_optical_power: Optional[InterconnectDiagnosticsLinkOpticalPower] = Field(
        None,
        alias="receivingOpticalPower",
        description="An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.",
    )
    circuit_id: Optional[str] = Field(
        None,
        alias="circuitId",
        description="The unique ID for this link assigned during turn up by Google.",
    )


class VpnGateway(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    vpn_interfaces: Optional[List[VpnGatewayVpnGatewayInterface]] = Field(
        None,
        alias="vpnInterfaces",
        description="The list of VPN interfaces associated with this VPN gateway.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.",
    )
    network: Optional[str] = Field(
        None,
        description="URL of the network to which this VPN gateway is attached. Provided by the client when the VPN gateway is created.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an VpnGateway.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the VPN gateway resides.",
    )
    kind: Optional[str] = Field(
        "compute#vpnGateway",
        description="[Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    stack_type: Optional[StackType] = Field(
        None,
        alias="stackType",
        description="The stack type for this VPN gateway to identify the IP protocols that are enabled. If not specified, IPV4_ONLY will be used.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )


class FirewallPolicyRule(BaseModel):
    kind: Optional[str] = Field(
        "compute#firewallPolicyRule",
        description="[Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules",
    )
    action: Optional[str] = Field(
        None,
        description='The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.',
    )
    rule_tuple_count: Optional[int] = Field(
        None,
        alias="ruleTupleCount",
        description="[Output Only] Calculation of the complexity of a single firewall policy rule.",
    )
    match: Optional[FirewallPolicyRuleMatcher] = Field(
        None,
        description="A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.",
    )
    target_resources: Optional[List[str]] = Field(
        None,
        alias="targetResources",
        description="A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.",
    )
    direction: Optional[Direction1] = Field(
        None, description="The direction in which this rule applies."
    )
    rule_name: Optional[str] = Field(
        None,
        alias="ruleName",
        description="An optional name for the rule. This field is not a unique identifier and can be updated.",
    )
    target_secure_tags: Optional[List[FirewallPolicyRuleSecureTag]] = Field(
        None,
        alias="targetSecureTags",
        description="A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.",
    )
    priority: Optional[int] = Field(
        None,
        description="An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.",
    )
    enable_logging: Optional[bool] = Field(
        None,
        alias="enableLogging",
        description='Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.',
    )
    disabled: Optional[bool] = Field(
        None,
        description="Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.",
    )
    description: Optional[str] = Field(
        None, description="An optional description for this resource."
    )
    target_service_accounts: Optional[List[str]] = Field(
        None,
        alias="targetServiceAccounts",
        description="A list of service accounts indicating the sets of instances that are applied with this rule.",
    )


class SubnetworksScopedList(BaseModel):
    subnetworks: Optional[List[Subnetwork]] = Field(
        None, description="A list of subnetworks contained in this scope."
    )
    warning: Optional[Warning70] = Field(
        None,
        description="An informational warning that appears when the list of addresses is empty.",
    )


class PacketMirroringMirroredResourceInfo(BaseModel):
    instances: Optional[List[PacketMirroringMirroredResourceInfoInstanceInfo]] = Field(
        None,
        description="A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.",
    )
    subnetworks: Optional[List[PacketMirroringMirroredResourceInfoSubnetInfo]] = Field(
        None,
        description="A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.",
    )
    tags: Optional[List[str]] = Field(
        None,
        description="A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.",
    )


class TargetPoolsScopedList(BaseModel):
    warning: Optional[Warning73] = Field(
        None,
        description="Informational warning which replaces the list of addresses when the list is empty.",
    )
    target_pools: Optional[List[TargetPool]] = Field(
        None,
        alias="targetPools",
        description="A list of target pools contained in this scope.",
    )


class AcceleratorTypesScopedList(BaseModel):
    accelerator_types: Optional[List[AcceleratorType]] = Field(
        None,
        alias="acceleratorTypes",
        description="[Output Only] A list of accelerator types contained in this scope.",
    )
    warning: Optional[Warning75] = Field(
        None,
        description="[Output Only] An informational warning that appears when the accelerator types list is empty.",
    )


class NetworkEdgeSecurityServicesScopedList(BaseModel):
    warning: Optional[Warning77] = Field(
        None,
        description="Informational warning which replaces the list of security policies when the list is empty.",
    )
    network_edge_security_services: Optional[List[NetworkEdgeSecurityService]] = Field(
        None,
        alias="networkEdgeSecurityServices",
        description="A list of NetworkEdgeSecurityServices contained in this scope.",
    )


class RouteList(BaseModel):
    warning: Optional[Warning78] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field("compute#routeList", description="Type of resource.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[Route1]] = Field(None, description="A list of Route resources.")


class TargetPoolInstanceHealth(BaseModel):
    health_status: Optional[List[HealthStatus]] = Field(None, alias="healthStatus")
    kind: Optional[str] = Field(
        "compute#targetPoolInstanceHealth",
        description="[Output Only] Type of resource. Always compute#targetPoolInstanceHealth when checking the health of an instance.",
    )


class HealthCheckList(BaseModel):
    kind: Optional[str] = Field("compute#healthCheckList", description="Type of resource.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning79] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[HealthCheck]] = Field(None, description="A list of HealthCheck resources.")


class InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(BaseModel):
    type: Optional[Type14] = Field(
        None,
        description="[Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL.",
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="[Output Only] Deprecated, please use short name instead. The display name of the firewall policy.",
    )
    short_name: Optional[str] = Field(
        None,
        alias="shortName",
        description="[Output Only] The short name of the firewall policy.",
    )
    name: Optional[str] = Field(None, description="[Output Only] The name of the firewall policy.")
    rules: Optional[List[FirewallPolicyRule]] = Field(
        None, description="The rules that apply to the network."
    )


class Firewall(BaseModel):
    kind: Optional[str] = Field(
        "compute#firewall",
        description="[Output Only] Type of the resource. Always compute#firewall for firewall rules.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    priority: Optional[int] = Field(
        None,
        description="Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.",
    )
    log_config: Optional[FirewallLogConfig] = Field(
        None,
        alias="logConfig",
        description="This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.",
    )
    allowed: Optional[List[AllowedItem]] = Field(
        None,
        description="The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this field when you create the resource.",
    )
    destination_ranges: Optional[List[str]] = Field(
        None,
        alias="destinationRanges",
        description="If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.",
    )
    direction: Optional[Direction1] = Field(
        None,
        description="Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.",
    )
    source_ranges: Optional[List[str]] = Field(
        None,
        alias="sourceRanges",
        description="If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.",
    )
    denied: Optional[List[DeniedItem]] = Field(
        None,
        description="The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    source_service_accounts: Optional[List[str]] = Field(
        None,
        alias="sourceServiceAccounts",
        description="If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.",
    )
    source_tags: Optional[List[str]] = Field(
        None,
        alias="sourceTags",
        description="If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.",
    )
    target_tags: Optional[List[str]] = Field(
        None,
        alias="targetTags",
        description="A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.",
    )
    target_service_accounts: Optional[List[str]] = Field(
        None,
        alias="targetServiceAccounts",
        description="A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.",
    )
    network: Optional[str] = Field(
        None,
        description="URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default ",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.",
    )
    disabled: Optional[bool] = Field(
        None,
        description="Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.",
    )


class InstancesStartWithEncryptionKeyRequest(BaseModel):
    disks: Optional[List[CustomerEncryptionKeyProtectedDisk]] = Field(
        None,
        description="Array of disks associated with this instance that are protected with a customer-supplied encryption key. In order to start the instance, the disk url and its corresponding key must be provided. If the disk is not protected with a customer-supplied encryption key it should not be specified.",
    )


class NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(BaseModel):
    name: Optional[str] = Field(None, description="[Output Only] The name of the firewall policy.")
    type: Optional[Type15] = Field(
        None, description="[Output Only] The type of the firewall policy."
    )
    short_name: Optional[str] = Field(
        None,
        alias="shortName",
        description="[Output Only] The short name of the firewall policy.",
    )
    rules: Optional[List[FirewallPolicyRule]] = Field(
        None, description="The rules that apply to the network."
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="[Output Only] Deprecated, please use short name instead. The display name of the firewall policy.",
    )


class BfdStatus(BaseModel):
    bfd_session_initialization_mode: Optional[SessionInitializationMode] = Field(
        None,
        alias="bfdSessionInitializationMode",
        description="The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.",
    )
    local_state: Optional[State11] = Field(
        None,
        alias="localState",
        description="The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880",
    )
    rx_packet: Optional[BfdPacket] = Field(
        None,
        alias="rxPacket",
        description="The most recent Rx control packet for this BFD session.",
    )
    tx_packet: Optional[BfdPacket] = Field(
        None,
        alias="txPacket",
        description="The most recent Tx control packet for this BFD session.",
    )
    config_update_timestamp_micros: Optional[str] = Field(
        None,
        alias="configUpdateTimestampMicros",
        description="Unix timestamp of the most recent config update.",
    )
    negotiated_local_control_tx_interval_ms: Optional[int] = Field(
        None,
        alias="negotiatedLocalControlTxIntervalMs",
        description="Negotiated transmit interval for control packets.",
    )
    uptime_ms: Optional[str] = Field(
        None,
        alias="uptimeMs",
        description="Session uptime in milliseconds. Value will be 0 if session is not up.",
    )
    local_diagnostic: Optional[Diagnostic] = Field(
        None,
        alias="localDiagnostic",
        description="The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880",
    )
    control_packet_intervals: Optional[List[PacketIntervals]] = Field(
        None,
        alias="controlPacketIntervals",
        description="Inter-packet time interval statistics for control packets.",
    )
    control_packet_counts: Optional[BfdStatusPacketCounts] = Field(
        None,
        alias="controlPacketCounts",
        description="Control packet counts for the current BFD session.",
    )


class RouterStatusNatStatus(BaseModel):
    name: Optional[str] = Field(None, description="Unique name of this NAT.")
    drain_user_allocated_nat_ips: Optional[List[str]] = Field(
        None,
        alias="drainUserAllocatedNatIps",
        description='A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].',
    )
    min_extra_nat_ips_needed: Optional[int] = Field(
        None,
        alias="minExtraNatIpsNeeded",
        description="The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.",
    )
    user_allocated_nat_ip_resources: Optional[List[str]] = Field(
        None,
        alias="userAllocatedNatIpResources",
        description="A list of fully qualified URLs of reserved IP address resources.",
    )
    auto_allocated_nat_ips: Optional[List[str]] = Field(
        None,
        alias="autoAllocatedNatIps",
        description='A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]',
    )
    rule_status: Optional[List[RouterStatusNatStatusNatRuleStatus]] = Field(
        None, alias="ruleStatus", description="Status of rules in this NAT."
    )
    user_allocated_nat_ips: Optional[List[str]] = Field(
        None,
        alias="userAllocatedNatIps",
        description='A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".',
    )
    drain_auto_allocated_nat_ips: Optional[List[str]] = Field(
        None,
        alias="drainAutoAllocatedNatIps",
        description='A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].',
    )
    num_vm_endpoints_with_nat_mappings: Optional[int] = Field(
        None,
        alias="numVmEndpointsWithNatMappings",
        description="Number of VM endpoints (i.e., Nics) that can use NAT.",
    )


class RegionList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#regionList",
        description="[Output Only] Type of resource. Always compute#regionList for lists of regions.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning82] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[Region]] = Field(None, description="A list of Region resources.")


class PreconfiguredWafSet(BaseModel):
    expression_sets: Optional[List[WafExpressionSet]] = Field(
        None,
        alias="expressionSets",
        description="List of entities that are currently supported for WAF rules.",
    )


class InstanceGroupManagersListManagedInstancesResponse(BaseModel):
    managed_instances: Optional[List[ManagedInstance]] = Field(
        None,
        alias="managedInstances",
        description="[Output Only] The list of instances in the managed instance group.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class GuestAttributesValue(BaseModel):
    items: Optional[List[GuestAttributesEntry]] = None


class RegionInstanceGroupManagersListInstancesResponse(BaseModel):
    managed_instances: Optional[List[ManagedInstance]] = Field(
        None, alias="managedInstances", description="A list of managed instances."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class FirewallList(BaseModel):
    items: Optional[List[Firewall]] = Field(None, description="A list of Firewall resources.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#firewallList",
        description="[Output Only] Type of resource. Always compute#firewallList for lists of firewalls.",
    )
    warning: Optional[Warning88] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class TargetHttpProxyAggregatedList(BaseModel):
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, TargetHttpProxiesScopedList]] = Field(
        None, description="A list of TargetHttpProxiesScopedList resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#targetHttpProxyAggregatedList",
        description="[Output Only] Type of resource. Always compute#targetHttpProxyAggregatedList for lists of Target HTTP Proxies.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(BaseModel):
    rules: Optional[List[FirewallPolicyRule]] = Field(
        None, description="The rules that apply to the network."
    )
    display_name: Optional[str] = Field(
        None,
        alias="displayName",
        description="[Output Only] The display name of the firewall policy.",
    )
    name: Optional[str] = Field(None, description="[Output Only] The name of the firewall policy.")
    type: Optional[Type14] = Field(
        None,
        description="[Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL.",
    )


class SslCertificate(BaseModel):
    subject_alternative_names: Optional[List[str]] = Field(
        None,
        alias="subjectAlternativeNames",
        description="[Output Only] Domains associated with the certificate via Subject Alternative Name.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output only] Server-defined URL for the resource.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    self_managed: Optional[SslCertificateSelfManagedSslCertificate] = Field(
        None,
        alias="selfManaged",
        description="Configuration and status of a self-managed SSL certificate.",
    )
    type: Optional[Type18] = Field(
        None,
        description='(Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.',
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    certificate: Optional[str] = Field(
        None,
        description="A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.",
    )
    expire_time: Optional[str] = Field(
        None,
        alias="expireTime",
        description="[Output Only] Expire time of the certificate. RFC3339",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    managed: Optional[SslCertificateManagedSslCertificate] = Field(
        None, description="Configuration and status of a managed SSL certificate."
    )
    kind: Optional[str] = Field(
        "compute#sslCertificate",
        description="[Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.",
    )
    private_key: Optional[str] = Field(
        None,
        alias="privateKey",
        description="A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.",
    )


class VpnGatewayList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#vpnGatewayList",
        description="[Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.",
    )
    items: Optional[List[VpnGateway]] = Field(None, description="A list of VpnGateway resources.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning90] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class SubnetworkList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Subnetwork]] = Field(None, description="A list of Subnetwork resources.")
    warning: Optional[Warning95] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#subnetworkList",
        description="[Output Only] Type of resource. Always compute#subnetworkList for lists of subnetworks.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class TargetInstanceList(BaseModel):
    items: Optional[List[TargetInstance]] = Field(
        None, description="A list of TargetInstance resources."
    )
    warning: Optional[Warning99] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field("compute#targetInstanceList", description="Type of resource.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class Interconnect(BaseModel):
    customer_name: Optional[str] = Field(
        None,
        alias="customerName",
        description="Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.",
    )
    circuit_infos: Optional[List[InterconnectCircuitInfo]] = Field(
        None,
        alias="circuitInfos",
        description="[Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.",
    )
    location: Optional[str] = Field(
        None,
        description="URL of the InterconnectLocation object that represents where this connection is to be provisioned.",
    )
    state: Optional[State12] = Field(
        None,
        description="[Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect. ",
    )
    peer_ip_address: Optional[str] = Field(
        None,
        alias="peerIpAddress",
        description="[Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None,
        alias="satisfiesPzs",
        description="[Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.",
    )
    google_reference_id: Optional[str] = Field(
        None,
        alias="googleReferenceId",
        description="[Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.",
    )
    interconnect_attachments: Optional[List[str]] = Field(
        None,
        alias="interconnectAttachments",
        description="[Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.",
    )
    link_type: Optional[LinkType] = Field(
        None,
        alias="linkType",
        description="Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    noc_contact_email: Optional[str] = Field(
        None,
        alias="nocContactEmail",
        description="Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    expected_outages: Optional[List[InterconnectOutageNotification]] = Field(
        None,
        alias="expectedOutages",
        description="[Output Only] A list of outages expected for this Interconnect.",
    )
    interconnect_type: Optional[InterconnectType] = Field(
        None,
        alias="interconnectType",
        description="Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.",
    )
    admin_enabled: Optional[bool] = Field(
        None,
        alias="adminEnabled",
        description="Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    requested_link_count: Optional[int] = Field(
        None,
        alias="requestedLinkCount",
        description="Target number of physical links in the link bundle, as requested by the customer.",
    )
    provisioned_link_count: Optional[int] = Field(
        None,
        alias="provisionedLinkCount",
        description="[Output Only] Number of links actually provisioned in this interconnect.",
    )
    operational_status: Optional[OperationalStatus] = Field(
        None,
        alias="operationalStatus",
        description="[Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect. ",
    )
    kind: Optional[str] = Field(
        "compute#interconnect",
        description="[Output Only] Type of the resource. Always compute#interconnect for interconnects.",
    )
    google_ip_address: Optional[str] = Field(
        None,
        alias="googleIpAddress",
        description="[Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )


class ImageList(BaseModel):
    items: Optional[List[Image]] = Field(None, description="A list of Image resources.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning102] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field("compute#imageList", description="Type of resource.")


class ServiceAttachmentList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning103] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[ServiceAttachment]] = Field(
        None, description="A list of ServiceAttachment resources."
    )
    kind: Optional[str] = Field(
        "compute#serviceAttachmentList",
        description="[Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.",
    )


class NetworkEndpointGroupAggregatedList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning104] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#networkEndpointGroupAggregatedList",
        description="[Output Only] The resource type, which is always compute#networkEndpointGroupAggregatedList for aggregated lists of network endpoint groups.",
    )
    items: Optional[Dict[str, NetworkEndpointGroupsScopedList]] = Field(
        None, description="A list of NetworkEndpointGroupsScopedList resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class SslCertificateList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[SslCertificate]] = Field(
        None, description="A list of SslCertificate resources."
    )
    warning: Optional[Warning105] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field("compute#sslCertificateList", description="Type of resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class TargetPoolAggregatedList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, TargetPoolsScopedList]] = Field(
        None, description="A list of TargetPool resources."
    )
    kind: Optional[str] = Field(
        "compute#targetPoolAggregatedList",
        description="[Output Only] Type of resource. Always compute#targetPoolAggregatedList for aggregated lists of target pools.",
    )
    warning: Optional[Warning106] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class InterconnectAttachmentsScopedList(BaseModel):
    warning: Optional[Warning108] = Field(
        None,
        description="Informational warning which replaces the list of addresses when the list is empty.",
    )
    interconnect_attachments: Optional[List[InterconnectAttachment]] = Field(
        None,
        alias="interconnectAttachments",
        description="A list of interconnect attachments contained in this scope.",
    )


class NetworkEndpointGroupList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[NetworkEndpointGroup]] = Field(
        None, description="A list of NetworkEndpointGroup resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning109] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#networkEndpointGroupList",
        description="[Output Only] The resource type, which is always compute#networkEndpointGroupList for network endpoint group lists.",
    )


class License(BaseModel):
    transferable: Optional[bool] = Field(
        None,
        description="If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.",
    )
    resource_requirements: Optional[LicenseResourceRequirements] = Field(
        None, alias="resourceRequirements"
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    license_code: Optional[str] = Field(
        None,
        alias="licenseCode",
        description="[Output Only] The unique code used to attach this license to images, snapshots, and disks.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional textual description of the resource; provided by the client when the resource is created.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. The name must be 1-63 characters long and comply with RFC1035.",
    )
    charges_use_fee: Optional[bool] = Field(
        None,
        alias="chargesUseFee",
        description="[Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.",
    )
    kind: Optional[str] = Field(
        "compute#license",
        description="[Output Only] Type of resource. Always compute#license for licenses.",
    )


class AcceleratorTypeAggregatedList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#acceleratorTypeAggregatedList",
        description="[Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning115] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[Dict[str, AcceleratorTypesScopedList]] = Field(
        None, description="A list of AcceleratorTypesScopedList resources."
    )


class BackendBucket(BaseModel):
    custom_response_headers: Optional[List[str]] = Field(
        None,
        alias="customResponseHeaders",
        description="Headers that the HTTP/S load balancer should add to proxied responses.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    edge_security_policy: Optional[str] = Field(
        None,
        alias="edgeSecurityPolicy",
        description="[Output Only] The resource URL for the edge security policy associated with this backend bucket.",
    )
    bucket_name: Optional[str] = Field(
        None, alias="bucketName", description="Cloud Storage bucket name."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    cdn_policy: Optional[BackendBucketCdnPolicy] = Field(
        None,
        alias="cdnPolicy",
        description="Cloud CDN configuration for this BackendBucket.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field("compute#backendBucket", description="Type of the resource.")
    enable_cdn: Optional[bool] = Field(
        None,
        alias="enableCdn",
        description="If true, enable Cloud CDN for this BackendBucket.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional textual description of the resource; provided by the client when the resource is created.",
    )


class TargetTcpProxyList(BaseModel):
    kind: Optional[str] = Field("compute#targetTcpProxyList", description="Type of resource.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[TargetTcpProxy]] = Field(
        None, description="A list of TargetTcpProxy resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning117] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class TargetGrpcProxyList(BaseModel):
    items: Optional[List[TargetGrpcProxy]] = Field(
        None, description="A list of TargetGrpcProxy resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#targetGrpcProxyList",
        description="[Output Only] Type of the resource. Always compute#targetGrpcProxy for target grpc proxies.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning118] = Field(
        None, description="[Output Only] Informational warning message."
    )


class MachineTypesScopedList(BaseModel):
    warning: Optional[Warning119] = Field(
        None,
        description="[Output Only] An informational warning that appears when the machine types list is empty.",
    )
    machine_types: Optional[List[MachineType]] = Field(
        None,
        alias="machineTypes",
        description="[Output Only] A list of machine types contained in this scope.",
    )


class UsableSubnetwork(BaseModel):
    secondary_ip_ranges: Optional[List[UsableSubnetworkSecondaryRange]] = Field(
        None, alias="secondaryIpRanges", description="Secondary IP ranges."
    )
    network: Optional[str] = Field(None, description="Network URL.")
    ip_cidr_range: Optional[str] = Field(
        None,
        alias="ipCidrRange",
        description="The range of internal addresses that are owned by this subnetwork.",
    )
    subnetwork: Optional[str] = Field(None, description="Subnetwork URL.")


class HttpHealthCheckList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field("compute#httpHealthCheckList", description="Type of resource.")
    items: Optional[List[HttpHealthCheck1]] = Field(
        None, description="A list of HttpHealthCheck resources."
    )
    warning: Optional[Warning125] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class GuestAttributes(BaseModel):
    variable_value: Optional[str] = Field(
        None,
        alias="variableValue",
        description="[Output Only] The value found for the requested key.",
    )
    query_path: Optional[str] = Field(
        None,
        alias="queryPath",
        description="The path to be queried. This can be the default namespace ('') or a nested namespace ('\\/') or a specified key ('\\/\\').",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#guestAttributes",
        description="[Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.",
    )
    variable_key: Optional[str] = Field(
        None, alias="variableKey", description="The key to search for."
    )
    query_value: Optional[GuestAttributesValue] = Field(
        None,
        alias="queryValue",
        description="[Output Only] The value of the requested queried path.",
    )


class InstanceGroupsScopedList(BaseModel):
    warning: Optional[Warning130] = Field(
        None,
        description="[Output Only] An informational warning that replaces the list of instance groups when the list is empty.",
    )
    instance_groups: Optional[List[InstanceGroup]] = Field(
        None,
        alias="instanceGroups",
        description="[Output Only] The list of instance groups that are contained in this scope.",
    )


class MachineTypeAggregatedList(BaseModel):
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning131] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#machineTypeAggregatedList",
        description="[Output Only] Type of resource. Always compute#machineTypeAggregatedList for aggregated lists of machine types.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, MachineTypesScopedList]] = Field(
        None, description="A list of MachineTypesScopedList resources."
    )


class TargetInstanceAggregatedList(BaseModel):
    warning: Optional[Warning133] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#targetInstanceAggregatedList", description="Type of resource."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[Dict[str, TargetInstancesScopedList]] = Field(
        None, description="A list of TargetInstance resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class BackendBucketList(BaseModel):
    warning: Optional[Warning135] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[BackendBucket]] = Field(
        None, description="A list of BackendBucket resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field("compute#backendBucketList", description="Type of resource.")


class ExchangedPeeringRoutesList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning140] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#exchangedPeeringRoutesList",
        description="[Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for exchanged peering routes lists.",
    )
    items: Optional[List[ExchangedPeeringRoute]] = Field(
        None, description="A list of ExchangedPeeringRoute resources."
    )


class DiskTypeAggregatedList(BaseModel):
    kind: Optional[str] = Field(
        "compute#diskTypeAggregatedList",
        description="[Output Only] Type of resource. Always compute#diskTypeAggregatedList.",
    )
    items: Optional[Dict[str, DiskTypesScopedList]] = Field(
        None, description="A list of DiskTypesScopedList resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning145] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class UsableSubnetworksAggregatedList(BaseModel):
    kind: Optional[str] = Field(
        "compute#usableSubnetworksAggregatedList",
        description="[Output Only] Type of resource. Always compute#usableSubnetworksAggregatedList for aggregated lists of usable subnetworks.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results. In special cases listUsable may return 0 subnetworks and nextPageToken which still should be used to get the next page of results.",
    )
    warning: Optional[Warning148] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[UsableSubnetwork]] = Field(
        None, description="[Output] A list of usable subnetwork URLs."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )


class InstanceGroupAggregatedList(BaseModel):
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, InstanceGroupsScopedList]] = Field(
        None, description="A list of InstanceGroupsScopedList resources."
    )
    warning: Optional[Warning149] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#instanceGroupAggregatedList",
        description="[Output Only] The resource type, which is always compute#instanceGroupAggregatedList for aggregated lists of instance groups.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class OperationAggregatedList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than `maxResults`, use the `nextPageToken` as a value for the query parameter `pageToken` in the next list request. Subsequent list requests will have their own `nextPageToken` to continue paging through the results.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    kind: Optional[str] = Field(
        "compute#operationAggregatedList",
        description="[Output Only] Type of resource. Always `compute#operationAggregatedList` for aggregated lists of operations.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[Dict[str, OperationsScopedList]] = Field(
        None, description="[Output Only] A map of scoped operation lists."
    )
    warning: Optional[Warning] = Field(
        None, description="[Output Only] Informational warning message."
    )


class AttachedDisk(BaseModel):
    index: Optional[int] = Field(
        None,
        description="[Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.",
    )
    source: Optional[str] = Field(
        None,
        description="Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.",
    )
    mode: Optional[Mode] = Field(
        None,
        description="The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.",
    )
    kind: Optional[str] = Field(
        "compute#attachedDisk",
        description="[Output Only] Type of the resource. Always compute#attachedDisk for attached disks.",
    )
    guest_os_features: Optional[List[GuestOsFeature]] = Field(
        None,
        alias="guestOsFeatures",
        description="A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.",
    )
    disk_size_gb: Optional[str] = Field(
        None, alias="diskSizeGb", description="The size of the disk in GB."
    )
    auto_delete: Optional[bool] = Field(
        None,
        alias="autoDelete",
        description="Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).",
    )
    shielded_instance_initial_state: Optional[InitialStateConfig] = Field(
        None,
        alias="shieldedInstanceInitialState",
        description="[Output Only] shielded vm initial state stored on disk",
    )
    disk_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="diskEncryptionKey",
        description="Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.",
    )
    boot: Optional[bool] = Field(
        None,
        description="Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.",
    )
    type: Optional[Type1] = Field(
        None,
        description="Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.",
    )
    device_name: Optional[str] = Field(
        None,
        alias="deviceName",
        description="Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.",
    )
    initialize_params: Optional[AttachedDiskInitializeParams] = Field(
        None,
        alias="initializeParams",
        description="[Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.",
    )
    interface: Optional[Interface] = Field(
        None,
        description="Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.",
    )
    licenses: Optional[List[str]] = Field(
        None, description="[Output Only] Any valid publicly visible licenses."
    )


class PerInstanceConfig(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.",
    )
    status: Optional[Status1] = Field(
        None,
        description="The status of applying this per-instance configuration on the corresponding managed instance.",
    )
    preserved_state: Optional[PreservedState] = Field(
        None,
        alias="preservedState",
        description="The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.",
    )


class SecurityPolicyRule(BaseModel):
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    match: Optional[SecurityPolicyRuleMatcher] = Field(
        None,
        description="A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.",
    )
    redirect_options: Optional[SecurityPolicyRuleRedirectOptions] = Field(
        None,
        alias="redirectOptions",
        description="Parameters defining the redirect action. Cannot be specified for any other actions.",
    )
    header_action: Optional[SecurityPolicyRuleHttpHeaderAction] = Field(
        None,
        alias="headerAction",
        description="Optional, additional actions that are performed on headers.",
    )
    kind: Optional[str] = Field(
        "compute#securityPolicyRule",
        description="[Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules",
    )
    rate_limit_options: Optional[SecurityPolicyRuleRateLimitOptions] = Field(
        None,
        alias="rateLimitOptions",
        description='Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.',
    )
    priority: Optional[int] = Field(
        None,
        description="An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.",
    )
    action: Optional[str] = Field(
        None,
        description="The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(): deny access to target, returns the HTTP response code specified (valid values are 403, 404, and 502). - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. ",
    )
    preview: Optional[bool] = Field(
        None, description="If set to true, the specified action is not enforced."
    )


class HttpFaultInjection(BaseModel):
    delay: Optional[HttpFaultDelay] = Field(
        None,
        description="The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.",
    )
    abort: Optional[HttpFaultAbort] = Field(
        None,
        description="The specification for how client requests are aborted as part of fault injection.",
    )


class NodeTypeList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#nodeTypeList",
        description="[Output Only] Type of resource.Always compute#nodeTypeList for lists of node types.",
    )
    items: Optional[List[NodeType]] = Field(None, description="A list of NodeType resources.")
    warning: Optional[Warning4] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class RegionInstanceGroupList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning7] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[InstanceGroup]] = Field(
        None, description="A list of InstanceGroup resources."
    )
    kind: Optional[str] = Field("compute#regionInstanceGroupList", description="The resource type.")


class WeightedBackendService(BaseModel):
    weight: Optional[int] = Field(
        None,
        description="Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. The value must be from 0 to 1000.",
    )
    backend_service: Optional[str] = Field(
        None,
        alias="backendService",
        description="The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.",
    )
    header_action: Optional[HttpHeaderAction] = Field(
        None,
        alias="headerAction",
        description="Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )


class HttpRouteRuleMatch(BaseModel):
    query_parameter_matches: Optional[List[HttpQueryParameterMatch]] = Field(
        None,
        alias="queryParameterMatches",
        description="Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.",
    )
    metadata_filters: Optional[List[MetadataFilter]] = Field(
        None,
        alias="metadataFilters",
        description="Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )
    regex_match: Optional[str] = Field(
        None,
        alias="regexMatch",
        description="For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.",
    )
    ignore_case: Optional[bool] = Field(
        None,
        alias="ignoreCase",
        description="Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.",
    )
    full_path_match: Optional[str] = Field(
        None,
        alias="fullPathMatch",
        description="For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.",
    )
    prefix_match: Optional[str] = Field(
        None,
        alias="prefixMatch",
        description="For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.",
    )
    header_matches: Optional[List[HttpHeaderMatch]] = Field(
        None,
        alias="headerMatches",
        description="Specifies a list of header match criteria, all of which must match corresponding headers in the request.",
    )


class NodeGroupList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#nodeGroupList",
        description="[Output Only] Type of resource.Always compute#nodeGroupList for lists of node groups.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[NodeGroup]] = Field(None, description="A list of NodeGroup resources.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning8] = Field(
        None, description="[Output Only] Informational warning message."
    )


class ResourcePolicySnapshotSchedulePolicySchedule(BaseModel):
    daily_schedule: Optional[ResourcePolicyDailyCycle] = Field(None, alias="dailySchedule")
    hourly_schedule: Optional[ResourcePolicyHourlyCycle] = Field(None, alias="hourlySchedule")
    weekly_schedule: Optional[ResourcePolicyWeeklyCycle] = Field(None, alias="weeklySchedule")


class InstanceGroupManagerStatus(BaseModel):
    autoscaler: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the Autoscaler that targets this instance group manager.",
    )
    is_stable: Optional[bool] = Field(
        None,
        alias="isStable",
        description="[Output Only] A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.",
    )
    stateful: Optional[InstanceGroupManagerStatusStateful] = Field(
        None,
        description="[Output Only] Stateful status of the given Instance Group Manager.",
    )
    version_target: Optional[InstanceGroupManagerStatusVersionTarget] = Field(
        None,
        alias="versionTarget",
        description="[Output Only] A status of consistency of Instances' versions with their target version specified by version field on Instance Group Manager.",
    )


class AllocationSpecificSkuReservation(BaseModel):
    count: Optional[str] = Field(
        None, description="Specifies the number of resources that are allocated."
    )
    in_use_count: Optional[str] = Field(
        None,
        alias="inUseCount",
        description="[Output Only] Indicates how many instances are in use.",
    )
    assured_count: Optional[str] = Field(
        None,
        alias="assuredCount",
        description="[Output Only] Indicates how many instances are actually usable currently.",
    )
    instance_properties: Optional[
        AllocationSpecificSkuAllocationReservedInstanceProperties
    ] = Field(
        None,
        alias="instanceProperties",
        description="The instance properties for the reservation.",
    )


class BackendService(BaseModel):
    connection_tracking_policy: Optional[BackendServiceConnectionTrackingPolicy] = Field(
        None,
        alias="connectionTrackingPolicy",
        description="Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for Network Load Balancing and Internal TCP/UDP Load Balancing.",
    )
    cdn_policy: Optional[BackendServiceCdnPolicy] = Field(
        None,
        alias="cdnPolicy",
        description="Cloud CDN configuration for this BackendService. Only available for specified load balancer types.",
    )
    port_name: Optional[str] = Field(
        None,
        alias="portName",
        description="A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For Internal TCP/UDP Load Balancing and Network Load Balancing, omit port_name.",
    )
    health_checks: Optional[List[str]] = Field(
        None,
        alias="healthChecks",
        description="The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    network: Optional[str] = Field(
        None,
        description="The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.",
    )
    protocol: Optional[Protocol] = Field(
        None,
        description="The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    circuit_breakers: Optional[CircuitBreakers] = Field(None, alias="circuitBreakers")
    backends: Optional[List[Backend]] = Field(
        None, description="The list of backends that serve this BackendService."
    )
    kind: Optional[str] = Field(
        "compute#backendService",
        description="[Output Only] Type of resource. Always compute#backendService for backend services.",
    )
    failover_policy: Optional[BackendServiceFailoverPolicy] = Field(
        None,
        alias="failoverPolicy",
        description="Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).",
    )
    subsetting: Optional[Subsetting] = None
    enable_cdn: Optional[bool] = Field(
        None,
        alias="enableCDN",
        description="If true, enables Cloud CDN for the backend service of an external HTTP(S) load balancer.",
    )
    outlier_detection: Optional[OutlierDetection] = Field(
        None,
        alias="outlierDetection",
        description="Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    max_stream_duration: Optional[Duration] = Field(
        None,
        alias="maxStreamDuration",
        description="Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.",
    )
    session_affinity: Optional[SessionAffinity] = Field(
        None,
        alias="sessionAffinity",
        description="Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    log_config: Optional[BackendServiceLogConfig] = Field(
        None,
        alias="logConfig",
        description="This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.",
    )
    custom_request_headers: Optional[List[str]] = Field(
        None,
        alias="customRequestHeaders",
        description="Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).",
    )
    security_policy: Optional[str] = Field(
        None,
        alias="securityPolicy",
        description="[Output Only] The resource URL for the security policy associated with this backend service.",
    )
    iap: Optional[BackendServiceIap] = Field(
        None,
        description="The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.",
    )
    security_settings: Optional[SecuritySettings] = Field(
        None,
        alias="securitySettings",
        description="This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.",
    )
    port: Optional[int] = Field(
        None,
        description="Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For Internal TCP/UDP Load Balancing and Network Load Balancing, omit port.",
    )
    load_balancing_scheme: Optional[LoadBalancingScheme1] = Field(
        None,
        alias="loadBalancingScheme",
        description="Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.",
    )
    service_bindings: Optional[List[str]] = Field(
        None,
        alias="serviceBindings",
        description="URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.",
    )
    locality_lb_policies: Optional[List[BackendServiceLocalityLoadBalancingPolicyConfig]] = Field(
        None,
        alias="localityLbPolicies",
        description="A list of locality load balancing policies to be used in order of preference. Either the policy or the customPolicy field should be set. Overrides any value set in the localityLbPolicy field. localityLbPolicies is only supported when the BackendService is referenced by a URL Map that is referenced by a target gRPC proxy that has the validateForProxyless field set to true.",
    )
    locality_lb_policy: Optional[LocalityLbPolicy] = Field(
        None,
        alias="localityLbPolicy",
        description="The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    custom_response_headers: Optional[List[str]] = Field(
        None,
        alias="customResponseHeaders",
        description="Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).",
    )
    timeout_sec: Optional[int] = Field(
        None,
        alias="timeoutSec",
        description="The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    affinity_cookie_ttl_sec: Optional[int] = Field(
        None,
        alias="affinityCookieTtlSec",
        description="Lifetime of cookies in seconds. This setting is applicable to external and internal HTTP(S) load balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.",
    )
    connection_draining: Optional[ConnectionDraining] = Field(None, alias="connectionDraining")
    edge_security_policy: Optional[str] = Field(
        None,
        alias="edgeSecurityPolicy",
        description="[Output Only] The resource URL for the edge security policy associated with this backend service.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    consistent_hash: Optional[ConsistentHashLoadBalancerSettings] = Field(
        None,
        alias="consistentHash",
        description="Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. ",
    )


class Instance(BaseModel):
    params: Optional[InstanceParams] = Field(
        None,
        description="Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.",
    )
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description='Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".',
    )
    disks: Optional[List[AttachedDisk]] = Field(
        None,
        description="Array of disks associated with this instance. Persistent disks must be created before you can assign them.",
    )
    advanced_machine_features: Optional[AdvancedMachineFeatures] = Field(
        None,
        alias="advancedMachineFeatures",
        description="Controls for advanced machine-related behavior features.",
    )
    network_interfaces: Optional[List[NetworkInterface]] = Field(
        None,
        alias="networkInterfaces",
        description="An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.",
    )
    display_device: Optional[DisplayDevice] = Field(
        None,
        alias="displayDevice",
        description="Enables display device for the instance.",
    )
    last_start_timestamp: Optional[str] = Field(
        None,
        alias="lastStartTimestamp",
        description="[Output Only] Last start timestamp in RFC3339 text format.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    service_accounts: Optional[List[ServiceAccount]] = Field(
        None,
        alias="serviceAccounts",
        description="A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.",
    )
    guest_accelerators: Optional[List[AcceleratorConfig]] = Field(
        None,
        alias="guestAccelerators",
        description="A list of the type and count of accelerator cards attached to the instance.",
    )
    machine_type: Optional[str] = Field(
        None,
        alias="machineType",
        description="Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.",
    )
    source_machine_image: Optional[str] = Field(
        None, alias="sourceMachineImage", description="Source machine image"
    )
    shielded_instance_config: Optional[ShieldedInstanceConfig] = Field(
        None, alias="shieldedInstanceConfig"
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to this instance. These can be later modified by the setLabels method.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.",
    )
    kind: Optional[str] = Field(
        "compute#instance",
        description="[Output Only] Type of the resource. Always compute#instance for instances.",
    )
    status: Optional[Status8] = Field(
        None,
        description="[Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.",
    )
    label_fingerprint: Optional[str] = Field(
        None,
        alias="labelFingerprint",
        description="A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.",
    )
    network_performance_config: Optional[NetworkPerformanceConfig] = Field(
        None, alias="networkPerformanceConfig"
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    tags: Optional[Tags] = Field(
        None,
        description="Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.",
    )
    deletion_protection: Optional[bool] = Field(
        None,
        alias="deletionProtection",
        description="Whether the resource should be protected against deletion.",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="[Output Only] An optional, human-readable explanation of the status.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    source_machine_image_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="sourceMachineImageEncryptionKey",
        description="Source machine image encryption key when creating an instance from a machine image.",
    )
    metadata: Optional[Metadata] = Field(
        None,
        description="The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    confidential_instance_config: Optional[ConfidentialInstanceConfig] = Field(
        None, alias="confidentialInstanceConfig"
    )
    cpu_platform: Optional[str] = Field(
        None,
        alias="cpuPlatform",
        description="[Output Only] The CPU platform used by this instance.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies applied to this instance.",
    )
    reservation_affinity: Optional[ReservationAffinity] = Field(
        None,
        alias="reservationAffinity",
        description="Specifies the reservations that this instance can consume from.",
    )
    private_ipv6_google_access: Optional[PrivateIpv6GoogleAccess] = Field(
        None,
        alias="privateIpv6GoogleAccess",
        description="The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.",
    )
    hostname: Optional[str] = Field(
        None,
        description="Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    shielded_instance_integrity_policy: Optional[ShieldedInstanceIntegrityPolicy] = Field(
        None, alias="shieldedInstanceIntegrityPolicy"
    )
    last_suspended_timestamp: Optional[str] = Field(
        None,
        alias="lastSuspendedTimestamp",
        description="[Output Only] Last suspended timestamp in RFC3339 text format.",
    )
    scheduling: Optional[Scheduling] = Field(
        None, description="Sets the scheduling options for this instance."
    )
    start_restricted: Optional[bool] = Field(
        None,
        alias="startRestricted",
        description="[Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.",
    )
    can_ip_forward: Optional[bool] = Field(
        None,
        alias="canIpForward",
        description="Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    last_stop_timestamp: Optional[str] = Field(
        None,
        alias="lastStopTimestamp",
        description="[Output Only] Last stop timestamp in RFC3339 text format.",
    )


class InstancesScopedList(BaseModel):
    warning: Optional[Warning17] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of instances when the list is empty.",
    )
    instances: Optional[List[Instance]] = Field(
        None, description="[Output Only] A list of instances contained in this scope."
    )


class RouterNat(BaseModel):
    log_config: Optional[RouterNatLogConfig] = Field(
        None, alias="logConfig", description="Configure logging on this NAT."
    )
    icmp_idle_timeout_sec: Optional[int] = Field(
        None,
        alias="icmpIdleTimeoutSec",
        description="Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.",
    )
    tcp_time_wait_timeout_sec: Optional[int] = Field(
        None,
        alias="tcpTimeWaitTimeoutSec",
        description="Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.",
    )
    enable_dynamic_port_allocation: Optional[bool] = Field(
        None,
        alias="enableDynamicPortAllocation",
        description="Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config. ",
    )
    drain_nat_ips: Optional[List[str]] = Field(
        None,
        alias="drainNatIps",
        description="A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.",
    )
    source_subnetwork_ip_ranges_to_nat: Optional[SourceSubnetworkIpRangesToNat] = Field(
        None,
        alias="sourceSubnetworkIpRangesToNat",
        description="Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.",
    )
    enable_endpoint_independent_mapping: Optional[bool] = Field(
        None, alias="enableEndpointIndependentMapping"
    )
    max_ports_per_vm: Optional[int] = Field(
        None,
        alias="maxPortsPerVm",
        description="Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.",
    )
    nat_ip_allocate_option: Optional[NatIpAllocateOption] = Field(
        None,
        alias="natIpAllocateOption",
        description="Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty. ",
    )
    nat_ips: Optional[List[str]] = Field(
        None,
        alias="natIps",
        description="A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.",
    )
    rules: Optional[List[RouterNatRule]] = Field(
        None, description="A list of rules associated with this NAT."
    )
    udp_idle_timeout_sec: Optional[int] = Field(
        None,
        alias="udpIdleTimeoutSec",
        description="Timeout (in seconds) for UDP connections. Defaults to 30s if not set.",
    )
    endpoint_types: Optional[List[EndpointType]] = Field(
        None,
        alias="endpointTypes",
        description="List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM",
    )
    min_ports_per_vm: Optional[int] = Field(
        None,
        alias="minPortsPerVm",
        description="Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.",
    )
    subnetworks: Optional[List[RouterNatSubnetworkToNat]] = Field(
        None,
        description="A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.",
    )
    tcp_established_idle_timeout_sec: Optional[int] = Field(
        None,
        alias="tcpEstablishedIdleTimeoutSec",
        description="Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.",
    )
    tcp_transitory_idle_timeout_sec: Optional[int] = Field(
        None,
        alias="tcpTransitoryIdleTimeoutSec",
        description="Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.",
    )


class XpnHostList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Project]] = Field(
        None, description="[Output Only] A list of shared VPC host project URLs."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning19] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#xpnHostList",
        description="[Output Only] Type of resource. Always compute#xpnHostList for lists of shared VPC hosts.",
    )


class Router(BaseModel):
    bgp_peers: Optional[List[RouterBgpPeer]] = Field(
        None,
        alias="bgpPeers",
        description="BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.",
    )
    bgp: Optional[RouterBgp] = Field(None, description="BGP information specific to this router.")
    nats: Optional[List[RouterNat]] = Field(
        None, description="A list of NAT services created in this router."
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    interfaces: Optional[List[RouterInterface]] = Field(
        None,
        description="Router interfaces. Each interface requires either one linked resource, (for example, linkedVpnTunnel), or IP address and IP address range (for example, ipRange), or both.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    encrypted_interconnect_router: Optional[bool] = Field(
        None,
        alias="encryptedInterconnectRouter",
        description="Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments). Not currently available publicly. ",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    kind: Optional[str] = Field(
        "compute#router",
        description="[Output Only] Type of resource. Always compute#router for routers.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    network: Optional[str] = Field(
        None, description="URI of the network to which this router belongs."
    )


class AutoscalingPolicy(BaseModel):
    max_num_replicas: Optional[int] = Field(
        None,
        alias="maxNumReplicas",
        description="The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.",
    )
    custom_metric_utilizations: Optional[List[AutoscalingPolicyCustomMetricUtilization]] = Field(
        None,
        alias="customMetricUtilizations",
        description="Configuration parameters of autoscaling based on a custom metric.",
    )
    min_num_replicas: Optional[int] = Field(
        None,
        alias="minNumReplicas",
        description="The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.",
    )
    scale_in_control: Optional[AutoscalingPolicyScaleInControl] = Field(
        None, alias="scaleInControl"
    )
    mode: Optional[Mode3] = Field(None, description="Defines operating mode for this policy.")
    load_balancing_utilization: Optional[AutoscalingPolicyLoadBalancingUtilization] = Field(
        None,
        alias="loadBalancingUtilization",
        description="Configuration parameters of autoscaling based on load balancer.",
    )
    scaling_schedules: Optional[Dict[str, AutoscalingPolicyScalingSchedule]] = Field(
        None,
        alias="scalingSchedules",
        description="Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.",
    )
    cool_down_period_sec: Optional[int] = Field(
        None,
        alias="coolDownPeriodSec",
        description="The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds. Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.",
    )
    cpu_utilization: Optional[AutoscalingPolicyCpuUtilization] = Field(
        None,
        alias="cpuUtilization",
        description="Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.",
    )


class ImageFamilyView(BaseModel):
    image: Optional[Image] = Field(
        None,
        description="The latest image that is part of the specified image family in the requested location, and that is not deprecated.",
    )


class VpnGatewaysGetStatusResponse(BaseModel):
    result: Optional[VpnGatewayStatus] = None


class InterconnectAttachmentList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[InterconnectAttachment]] = Field(
        None, description="A list of InterconnectAttachment resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning23] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#interconnectAttachmentList",
        description="[Output Only] Type of resource. Always compute#interconnectAttachmentList for lists of interconnect attachments.",
    )


class PublicAdvertisedPrefixList(BaseModel):
    kind: Optional[str] = Field(
        "compute#publicAdvertisedPrefixList",
        description="[Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning26] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[PublicAdvertisedPrefix]] = Field(
        None, description="A list of PublicAdvertisedPrefix resources."
    )


class PublicDelegatedPrefixList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[PublicDelegatedPrefix]] = Field(
        None, description="A list of PublicDelegatedPrefix resources."
    )
    kind: Optional[str] = Field(
        "compute#publicDelegatedPrefixList",
        description="[Output Only] Type of the resource. Always compute#publicDelegatedPrefixList for public delegated prefixes.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning27] = Field(
        None, description="[Output Only] Informational warning message."
    )


class UrlMapsValidateResponse(BaseModel):
    result: Optional[UrlMapValidationResult] = None


class InstanceManagedByIgmError(BaseModel):
    instance_action_details: Optional[InstanceManagedByIgmErrorInstanceActionDetails] = Field(
        None,
        alias="instanceActionDetails",
        description="[Output Only] Details of the instance action that triggered this error. May be null, if the error was not caused by an action on an instance. This field is optional.",
    )
    error: Optional[InstanceManagedByIgmErrorManagedInstanceError] = Field(
        None, description="[Output Only] Contents of the error."
    )
    timestamp: Optional[str] = Field(
        None,
        description="[Output Only] The time that this error occurred. This value is in RFC3339 text format.",
    )


class NetworkEndpointWithHealthStatus(BaseModel):
    network_endpoint: Optional[NetworkEndpoint] = Field(
        None, alias="networkEndpoint", description="[Output only] The network endpoint;"
    )
    healths: Optional[List[HealthStatusForNetworkEndpoint]] = Field(
        None, description="[Output only] The health status of network endpoint;"
    )


class ServiceAttachmentsScopedList(BaseModel):
    warning: Optional[Warning34] = Field(
        None,
        description="Informational warning which replaces the list of service attachments when the list is empty.",
    )
    service_attachments: Optional[List[ServiceAttachment]] = Field(
        None,
        alias="serviceAttachments",
        description="A list of ServiceAttachments contained in this scope.",
    )


class InstanceGroupManagersCreateInstancesRequest(BaseModel):
    instances: Optional[List[PerInstanceConfig]] = Field(
        None, description="[Required] List of specifications of per-instance configs."
    )


class NodeGroupAggregatedList(BaseModel):
    warning: Optional[Warning38] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    kind: Optional[str] = Field(
        "compute#nodeGroupAggregatedList",
        description="[Output Only] Type of resource.Always compute#nodeGroupAggregatedList for aggregated lists of node groups.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, NodeGroupsScopedList]] = Field(
        None, description="A list of NodeGroupsScopedList resources."
    )


class NodeTemplatesScopedList(BaseModel):
    node_templates: Optional[List[NodeTemplate]] = Field(
        None,
        alias="nodeTemplates",
        description="[Output Only] A list of node templates contained in this scope.",
    )
    warning: Optional[Warning44] = Field(
        None,
        description="[Output Only] An informational warning that appears when the node templates list is empty.",
    )


class LogConfig(BaseModel):
    cloud_audit: Optional[LogConfigCloudAuditOptions] = Field(
        None,
        alias="cloudAudit",
        description="This is deprecated and has no effect. Do not use.",
    )
    data_access: Optional[LogConfigDataAccessOptions] = Field(
        None,
        alias="dataAccess",
        description="This is deprecated and has no effect. Do not use.",
    )
    counter: Optional[LogConfigCounterOptions] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )


class PublicDelegatedPrefixAggregatedList(BaseModel):
    warning: Optional[Warning47] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[Dict[str, PublicDelegatedPrefixesScopedList]] = Field(
        None, description="A list of PublicDelegatedPrefixesScopedList resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#publicDelegatedPrefixAggregatedList",
        description="[Output Only] Type of the resource. Always compute#publicDelegatedPrefixAggregatedList for aggregated lists of public delegated prefixes.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class ForwardingRulesScopedList(BaseModel):
    forwarding_rules: Optional[List[ForwardingRule]] = Field(
        None,
        alias="forwardingRules",
        description="A list of forwarding rules contained in this scope.",
    )
    warning: Optional[Warning52] = Field(
        None,
        description="Informational warning which replaces the list of forwarding rules when the list is empty.",
    )


class NetworkList(BaseModel):
    warning: Optional[Warning54] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#networkList",
        description="[Output Only] Type of resource. Always compute#networkList for lists of networks.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Network]] = Field(None, description="A list of Network resources.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class RoutersScopedList(BaseModel):
    routers: Optional[List[Router]] = Field(
        None, description="A list of routers contained in this scope."
    )
    warning: Optional[Warning56] = Field(
        None,
        description="Informational warning which replaces the list of routers when the list is empty.",
    )


class InstanceGroupManager(BaseModel):
    instance_group: Optional[str] = Field(
        None,
        alias="instanceGroup",
        description="[Output Only] The URL of the Instance Group resource.",
    )
    distribution_policy: Optional[DistributionPolicy] = Field(
        None,
        alias="distributionPolicy",
        description="Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.",
    )
    named_ports: Optional[List[NamedPort]] = Field(
        None,
        alias="namedPorts",
        description="Named ports configured for the Instance Groups complementary to this Instance Group Manager.",
    )
    update_policy: Optional[InstanceGroupManagerUpdatePolicy] = Field(
        None,
        alias="updatePolicy",
        description="The update policy for this managed instance group.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] The URL of the region where the managed instance group resides (for regional resources).",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] The creation timestamp for this managed instance group in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None, description="An optional description of this resource."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] The URL for this managed instance group. The server defines this URL.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] The URL of a zone where the managed instance group is located (for zonal resources).",
    )
    versions: Optional[List[InstanceGroupManagerVersion]] = Field(
        None,
        description="Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.",
    )
    stateful_policy: Optional[StatefulPolicy] = Field(
        None,
        alias="statefulPolicy",
        description="Stateful configuration for this Instanced Group Manager",
    )
    status: Optional[InstanceGroupManagerStatus] = Field(
        None, description="[Output Only] The status of this managed instance group."
    )
    current_actions: Optional[InstanceGroupManagerActionsSummary] = Field(
        None,
        alias="currentActions",
        description="[Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.",
    )
    kind: Optional[str] = Field(
        "compute#instanceGroupManager",
        description="[Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] A unique identifier for this resource type. The server generates this identifier.",
    )
    instance_template: Optional[str] = Field(
        None,
        alias="instanceTemplate",
        description="The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.",
    )
    target_size: Optional[int] = Field(
        None,
        alias="targetSize",
        description="The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.",
    )
    target_pools: Optional[List[str]] = Field(
        None,
        alias="targetPools",
        description="The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.",
    )
    base_instance_name: Optional[constr(regex=r"[a-z][-a-z0-9]{0,57}")] = Field(
        None,
        alias="baseInstanceName",
        description="The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.",
    )
    auto_healing_policies: Optional[List[InstanceGroupManagerAutoHealingPolicy]] = Field(
        None,
        alias="autoHealingPolicies",
        description="The autohealing policy for this managed instance group. You can specify only one value.",
    )


class HealthChecksAggregatedList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, HealthChecksScopedList]] = Field(
        None, description="A list of HealthChecksScopedList resources."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning64] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#healthChecksAggregatedList", description="Type of resource."
    )


class InterconnectDiagnostics(BaseModel):
    links: Optional[List[InterconnectDiagnosticsLinkStatus]] = Field(
        None,
        description="A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.",
    )
    arp_caches: Optional[List[InterconnectDiagnosticsArpEntry]] = Field(
        None,
        alias="arpCaches",
        description="A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.",
    )
    mac_address: Optional[str] = Field(
        None,
        alias="macAddress",
        description="The MAC address of the Interconnect's bundle interface.",
    )


class VpnGatewaysScopedList(BaseModel):
    warning: Optional[Warning66] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of addresses when the list is empty.",
    )
    vpn_gateways: Optional[List[VpnGateway]] = Field(
        None,
        alias="vpnGateways",
        description="[Output Only] A list of VPN gateways contained in this scope.",
    )


class FirewallPolicy(BaseModel):
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional firewall policy resides. This field is not applicable to global firewall policies. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    self_link_with_id: Optional[str] = Field(
        None,
        alias="selfLinkWithId",
        description="[Output Only] Server-defined URL for this resource with the resource id.",
    )
    rules: Optional[List[FirewallPolicyRule]] = Field(
        None,
        description='A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a default rule with action "allow" will be added.',
    )
    rule_tuple_count: Optional[int] = Field(
        None,
        alias="ruleTupleCount",
        description="[Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    associations: Optional[List[FirewallPolicyAssociation]] = Field(
        None, description="A list of associations that belong to this firewall policy."
    )
    kind: Optional[str] = Field(
        "compute#firewallPolicy",
        description="[Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies",
    )
    parent: Optional[str] = Field(
        None, description="[Output Only] The parent of the firewall policy."
    )
    short_name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        alias="shortName",
        description="User-provided name of the Organization firewall plicy. The name should be unique in the organization in which the firewall policy is created. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the firewall policy.",
    )
    name: Optional[str] = Field(
        None,
        description="[Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely identifies the Firewall Policy.",
    )
    display_name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        alias="displayName",
        description="Deprecated, please use short name instead. User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )


class SubnetworkAggregatedList(BaseModel):
    items: Optional[Dict[str, SubnetworksScopedList]] = Field(
        None, description="A list of SubnetworksScopedList resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#subnetworkAggregatedList",
        description="[Output Only] Type of resource. Always compute#subnetworkAggregatedList for aggregated lists of subnetworks.",
    )
    warning: Optional[Warning69] = Field(
        None, description="[Output Only] Informational warning message."
    )


class PacketMirroring(BaseModel):
    collector_ilb: Optional[PacketMirroringForwardingRuleInfo] = Field(
        None,
        alias="collectorIlb",
        description="The Forwarding Rule resource of type loadBalancingScheme=INTERNAL that will be used as collector for mirrored traffic. The specified forwarding rule must have isMirroringCollector set to true.",
    )
    mirrored_resources: Optional[PacketMirroringMirroredResourceInfo] = Field(
        None,
        alias="mirroredResources",
        description="PacketMirroring mirroredResourceInfos. MirroredResourceInfo specifies a set of mirrored VM instances, subnetworks and/or tags for which traffic from/to all VM instances will be mirrored.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    network: Optional[PacketMirroringNetworkInfo] = Field(
        None,
        description="Specifies the mirrored VPC network. Only packets in this network will be mirrored. All mirrored VMs should have a NIC in the given network. All mirrored subnetworks should belong to the given network.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    enable: Optional[Enable] = Field(
        None,
        description="Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet mirroring policy will not be enforced on the network. The default is TRUE.",
    )
    priority: Optional[int] = Field(
        None,
        description="The priority of applying this configuration. Priority is used to break ties in cases where there is more than one matching rule. In the case of two rules that apply for a given Instance, the one with the lowest-numbered priority value wins. Default value is 1000. Valid range is 0 through 65535.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URI of the region where the packetMirroring resides.",
    )
    kind: Optional[str] = Field(
        "compute#packetMirroring",
        description="[Output Only] Type of the resource. Always compute#packetMirroring for packet mirrorings.",
    )
    filter: Optional[PacketMirroringFilter] = Field(
        None,
        description="Filter for mirrored traffic. If unspecified, all traffic is mirrored.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class NetworkEdgeSecurityServiceAggregatedList(BaseModel):
    kind: Optional[str] = Field(
        "compute#networkEdgeSecurityServiceAggregatedList",
        description="[Output Only] Type of resource. Always compute#networkEdgeSecurityServiceAggregatedList for lists of Network Edge Security Services.",
    )
    warning: Optional[Warning76] = Field(
        None, description="[Output Only] Informational warning message."
    )
    etag: Optional[str] = None
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[Dict[str, NetworkEdgeSecurityServicesScopedList]] = Field(
        None, description="A list of NetworkEdgeSecurityServicesScopedList resources."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class InstancesGetEffectiveFirewallsResponse(BaseModel):
    firewall_policys: Optional[
        List[InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy]
    ] = Field(
        None,
        alias="firewallPolicys",
        description="Effective firewalls from firewall policies.",
    )
    firewalls: Optional[List[Firewall]] = Field(
        None, description="Effective firewalls on the instance."
    )


class NetworksGetEffectiveFirewallsResponse(BaseModel):
    firewalls: Optional[List[Firewall]] = Field(
        None, description="Effective firewalls on the network."
    )
    firewall_policys: Optional[
        List[NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy]
    ] = Field(
        None,
        alias="firewallPolicys",
        description="Effective firewalls from firewall policy.",
    )


class InstanceGroupManagersListPerInstanceConfigsResp(BaseModel):
    items: Optional[List[PerInstanceConfig]] = Field(
        None, description="[Output Only] The list of PerInstanceConfig."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning80] = Field(
        None, description="[Output Only] Informational warning message."
    )


class RouterStatusBgpPeerStatus(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of this BGP peer. Unique within the Routers resource."
    )
    ip_address: Optional[str] = Field(
        None, alias="ipAddress", description="IP address of the local BGP interface."
    )
    num_learned_routes: Optional[int] = Field(
        None,
        alias="numLearnedRoutes",
        description="Number of routes learned from the remote BGP Peer.",
    )
    bfd_status: Optional[BfdStatus] = Field(None, alias="bfdStatus")
    status: Optional[Status23] = Field(None, description="Status of the BGP peer: {UP, DOWN}")
    peer_ip_address: Optional[str] = Field(
        None,
        alias="peerIpAddress",
        description="IP address of the remote BGP interface.",
    )
    uptime: Optional[str] = Field(
        None,
        description="Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds",
    )
    uptime_seconds: Optional[str] = Field(
        None,
        alias="uptimeSeconds",
        description="Time this session has been up, in seconds. Format: 145",
    )
    router_appliance_instance: Optional[str] = Field(
        None,
        alias="routerApplianceInstance",
        description="[Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.",
    )
    state: Optional[str] = Field(
        None,
        description="The state of the BGP session. For a list of possible values for this field, see BGP session states.",
    )
    linked_vpn_tunnel: Optional[str] = Field(
        None,
        alias="linkedVpnTunnel",
        description="URL of the VPN tunnel that this BGP peer controls.",
    )
    advertised_routes: Optional[List[Route1]] = Field(
        None,
        alias="advertisedRoutes",
        description="Routes that were advertised to the remote BGP peer",
    )


class SecurityPoliciesWafConfig(BaseModel):
    waf_rules: Optional[PreconfiguredWafSet] = Field(None, alias="wafRules")


class InstanceGroupManagersPatchPerInstanceConfigsReq(BaseModel):
    per_instance_configs: Optional[List[PerInstanceConfig]] = Field(
        None,
        alias="perInstanceConfigs",
        description="The list of per-instance configurations to insert or patch on this managed instance group.",
    )


class PacketMirroringsScopedList(BaseModel):
    warning: Optional[Warning84] = Field(
        None,
        description="Informational warning which replaces the list of packetMirrorings when the list is empty.",
    )
    packet_mirrorings: Optional[List[PacketMirroring]] = Field(
        None,
        alias="packetMirrorings",
        description="A list of packetMirrorings contained in this scope.",
    )


class InstanceGroupManagerList(BaseModel):
    warning: Optional[Warning85] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[InstanceGroupManager]] = Field(
        None, description="A list of InstanceGroupManager resources."
    )
    kind: Optional[str] = Field(
        "compute#instanceGroupManagerList",
        description="[Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse(BaseModel):
    firewall_policys: Optional[
        List[RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy]
    ] = Field(
        None,
        alias="firewallPolicys",
        description="Effective firewalls from firewall policy.",
    )
    firewalls: Optional[List[Firewall]] = Field(
        None, description="Effective firewalls on the network."
    )


class SslCertificatesScopedList(BaseModel):
    warning: Optional[Warning89] = Field(
        None,
        description="Informational warning which replaces the list of backend services when the list is empty.",
    )
    ssl_certificates: Optional[List[SslCertificate]] = Field(
        None,
        alias="sslCertificates",
        description="List of SslCertificates contained in this scope.",
    )


class RouterList(BaseModel):
    kind: Optional[str] = Field(
        "compute#routerList",
        description="[Output Only] Type of resource. Always compute#router for routers.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[Router]] = Field(None, description="A list of Router resources.")
    warning: Optional[Warning93] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class BackendServiceList(BaseModel):
    kind: Optional[str] = Field(
        "compute#backendServiceList",
        description="[Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[BackendService]] = Field(
        None, description="A list of BackendService resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning94] = Field(
        None, description="[Output Only] Informational warning message."
    )


class InstanceGroupManagersUpdatePerInstanceConfigsReq(BaseModel):
    per_instance_configs: Optional[List[PerInstanceConfig]] = Field(
        None,
        alias="perInstanceConfigs",
        description="The list of per-instance configurations to insert or patch on this managed instance group.",
    )


class BackendServicesScopedList(BaseModel):
    warning: Optional[Warning98] = Field(
        None,
        description="Informational warning which replaces the list of backend services when the list is empty.",
    )
    backend_services: Optional[List[BackendService]] = Field(
        None,
        alias="backendServices",
        description="A list of BackendServices contained in this scope.",
    )


class InterconnectList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[Interconnect]] = Field(
        None, description="A list of Interconnect resources."
    )
    warning: Optional[Warning100] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#interconnectList",
        description="[Output Only] Type of resource. Always compute#interconnectList for lists of interconnects.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class RegionInstanceGroupManagersListInstanceConfigsResp(BaseModel):
    warning: Optional[Warning101] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[PerInstanceConfig]] = Field(
        None, description="[Output Only] The list of PerInstanceConfig."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class RegionInstanceGroupManagerPatchInstanceConfigReq(BaseModel):
    per_instance_configs: Optional[List[PerInstanceConfig]] = Field(
        None,
        alias="perInstanceConfigs",
        description="The list of per-instance configurations to insert or patch on this managed instance group.",
    )


class InterconnectAttachmentAggregatedList(BaseModel):
    items: Optional[Dict[str, InterconnectAttachmentsScopedList]] = Field(
        None, description="A list of InterconnectAttachmentsScopedList resources."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    kind: Optional[str] = Field(
        "compute#interconnectAttachmentAggregatedList",
        description="[Output Only] Type of resource. Always compute#interconnectAttachmentAggregatedList for aggregated lists of interconnect attachments.",
    )
    warning: Optional[Warning107] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class LicensesListResponse(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[License]] = Field(None, description="A list of License resources.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning112] = Field(
        None, description="[Output Only] Informational warning message."
    )


class SslCertificateAggregatedList(BaseModel):
    items: Optional[Dict[str, SslCertificatesScopedList]] = Field(
        None, description="A list of SslCertificatesScopedList resources."
    )
    warning: Optional[Warning114] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#sslCertificateAggregatedList",
        description="[Output Only] Type of resource. Always compute#sslCertificateAggregatedList for lists of SSL Certificates.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class PacketMirroringAggregatedList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#packetMirroringAggregatedList", description="Type of resource."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, PacketMirroringsScopedList]] = Field(
        None, description="A list of PacketMirroring resources."
    )
    warning: Optional[Warning116] = Field(
        None, description="[Output Only] Informational warning message."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class InstanceGroupManagersListErrorsResponse(BaseModel):
    items: Optional[List[InstanceManagedByIgmError]] = Field(
        None,
        description="[Output Only] The list of errors of the managed instance group.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class BackendServiceAggregatedList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, BackendServicesScopedList]] = Field(
        None, description="A list of BackendServicesScopedList resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#backendServiceAggregatedList", description="Type of resource."
    )
    warning: Optional[Warning124] = Field(
        None, description="[Output Only] Informational warning message."
    )


class PacketMirroringList(BaseModel):
    kind: Optional[str] = Field(
        "compute#packetMirroringList",
        description="[Output Only] Type of resource. Always compute#packetMirroring for packetMirrorings.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[PacketMirroring]] = Field(
        None, description="A list of PacketMirroring resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning139] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class RegionInstanceGroupManagerUpdateInstanceConfigReq(BaseModel):
    per_instance_configs: Optional[List[PerInstanceConfig]] = Field(
        None,
        alias="perInstanceConfigs",
        description="The list of per-instance configurations to insert or patch on this managed instance group.",
    )


class RegionInstanceGroupManagerList(BaseModel):
    kind: Optional[str] = Field(
        "compute#regionInstanceGroupManagerList",
        description="[Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups that exist in th regional scope.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[InstanceGroupManager]] = Field(
        None, description="A list of InstanceGroupManager resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning142] = Field(
        None, description="[Output Only] Informational warning message."
    )


class VpnGatewayAggregatedList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning143] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#vpnGatewayAggregatedList",
        description="[Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, VpnGatewaysScopedList]] = Field(
        None, description="A list of VpnGateway resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class InstanceProperties(BaseModel):
    machine_type: Optional[str] = Field(
        None,
        alias="machineType",
        description="The machine type to use for instances that are created from these properties.",
    )
    min_cpu_platform: Optional[str] = Field(
        None,
        alias="minCpuPlatform",
        description='Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.',
    )
    private_ipv6_google_access: Optional[PrivateIpv6GoogleAccess] = Field(
        None,
        alias="privateIpv6GoogleAccess",
        description="The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.",
    )
    metadata: Optional[Metadata] = Field(
        None,
        description="The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.",
    )
    resource_policies: Optional[List[str]] = Field(
        None,
        alias="resourcePolicies",
        description="Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional text description for the instances that are created from these properties.",
    )
    tags: Optional[Tags] = Field(
        None,
        description="A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.",
    )
    network_performance_config: Optional[NetworkPerformanceConfig] = Field(
        None,
        alias="networkPerformanceConfig",
        description="Note that for MachineImage, this is not supported yet.",
    )
    confidential_instance_config: Optional[ConfidentialInstanceConfig] = Field(
        None,
        alias="confidentialInstanceConfig",
        description="Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.",
    )
    shielded_instance_config: Optional[ShieldedInstanceConfig] = Field(
        None,
        alias="shieldedInstanceConfig",
        description="Note that for MachineImage, this is not supported yet.",
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description="Labels to apply to instances that are created from these properties.",
    )
    guest_accelerators: Optional[List[AcceleratorConfig]] = Field(
        None,
        alias="guestAccelerators",
        description="A list of guest accelerator cards' type and count to use for instances created from these properties.",
    )
    disks: Optional[List[AttachedDisk]] = Field(
        None,
        description="An array of disks that are associated with the instances that are created from these properties.",
    )
    service_accounts: Optional[List[ServiceAccount]] = Field(
        None,
        alias="serviceAccounts",
        description="A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.",
    )
    can_ip_forward: Optional[bool] = Field(
        None,
        alias="canIpForward",
        description="Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.",
    )
    advanced_machine_features: Optional[AdvancedMachineFeatures] = Field(
        None,
        alias="advancedMachineFeatures",
        description="Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.",
    )
    scheduling: Optional[Scheduling] = Field(
        None,
        description="Specifies the scheduling options for the instances that are created from these properties.",
    )
    resource_manager_tags: Optional[Dict[str, str]] = Field(
        None,
        alias="resourceManagerTags",
        description="Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.",
    )
    network_interfaces: Optional[List[NetworkInterface]] = Field(
        None,
        alias="networkInterfaces",
        description="An array of network access configurations for this interface.",
    )
    reservation_affinity: Optional[ReservationAffinity] = Field(
        None,
        alias="reservationAffinity",
        description="Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.",
    )


class RegionInstanceGroupManagersCreateInstancesRequest(BaseModel):
    instances: Optional[List[PerInstanceConfig]] = Field(
        None, description="[Required] List of specifications of per-instance configs."
    )


class SecurityPolicy(BaseModel):
    kind: Optional[str] = Field(
        "compute#securityPolicy",
        description="[Output only] Type of the resource. Always compute#securityPolicyfor security policies",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.",
    )
    recaptcha_options_config: Optional[SecurityPolicyRecaptchaOptionsConfig] = Field(
        None, alias="recaptchaOptionsConfig"
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.",
    )
    adaptive_protection_config: Optional[SecurityPolicyAdaptiveProtectionConfig] = Field(
        None, alias="adaptiveProtectionConfig"
    )
    advanced_options_config: Optional[SecurityPolicyAdvancedOptionsConfig] = Field(
        None, alias="advancedOptionsConfig"
    )
    ddos_protection_config: Optional[SecurityPolicyDdosProtectionConfig] = Field(
        None, alias="ddosProtectionConfig"
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    rules: Optional[List[SecurityPolicyRule]] = Field(
        None,
        description='A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.',
    )
    type: Optional[Type4] = Field(
        None,
        description="The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. This field can be set only at resource creation time.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )


class HttpRouteAction(BaseModel):
    weighted_backend_services: Optional[List[WeightedBackendService]] = Field(
        None,
        alias="weightedBackendServices",
        description="A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.",
    )
    url_rewrite: Optional[UrlRewrite] = Field(
        None,
        alias="urlRewrite",
        description="The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.",
    )
    max_stream_duration: Optional[Duration] = Field(
        None,
        alias="maxStreamDuration",
        description="Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.",
    )
    timeout: Optional[Duration] = Field(
        None,
        description="Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )
    request_mirror_policy: Optional[RequestMirrorPolicy] = Field(
        None,
        alias="requestMirrorPolicy",
        description="Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.",
    )
    fault_injection_policy: Optional[HttpFaultInjection] = Field(
        None,
        alias="faultInjectionPolicy",
        description="The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the global external HTTP(S) load balancer (classic). To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.",
    )
    cors_policy: Optional[CorsPolicy] = Field(
        None,
        alias="corsPolicy",
        description="The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.",
    )
    retry_policy: Optional[HttpRetryPolicy] = Field(
        None,
        alias="retryPolicy",
        description="Specifies the retry policy associated with this route.",
    )


class PathRule(BaseModel):
    service: Optional[str] = Field(
        None,
        description="The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.",
    )
    route_action: Optional[HttpRouteAction] = Field(
        None,
        alias="routeAction",
        description="In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for external HTTP(S) load balancers support only the urlRewrite action within a path rule's routeAction.",
    )
    paths: Optional[List[str]] = Field(
        None,
        description="The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.",
    )
    url_redirect: Optional[HttpRedirectAction] = Field(
        None,
        alias="urlRedirect",
        description="When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.",
    )


class HttpRouteRule(BaseModel):
    header_action: Optional[HttpHeaderAction] = Field(
        None,
        alias="headerAction",
        description="Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )
    match_rules: Optional[List[HttpRouteRuleMatch]] = Field(
        None,
        alias="matchRules",
        description="The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.",
    )
    url_redirect: Optional[HttpRedirectAction] = Field(
        None,
        alias="urlRedirect",
        description="When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.",
    )
    priority: Optional[int] = Field(
        None,
        description="For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.",
    )
    description: Optional[str] = Field(
        None,
        description="The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.",
    )
    route_action: Optional[HttpRouteAction] = Field(
        None,
        alias="routeAction",
        description="In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a route rule's routeAction.",
    )
    service: Optional[str] = Field(
        None,
        description="The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.",
    )


class ResourcePolicySnapshotSchedulePolicy(BaseModel):
    retention_policy: Optional[ResourcePolicySnapshotSchedulePolicyRetentionPolicy] = Field(
        None,
        alias="retentionPolicy",
        description="Retention policy applied to snapshots created by this resource policy.",
    )
    schedule: Optional[ResourcePolicySnapshotSchedulePolicySchedule] = Field(
        None,
        description="A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.",
    )
    snapshot_properties: Optional[ResourcePolicySnapshotSchedulePolicySnapshotProperties] = Field(
        None,
        alias="snapshotProperties",
        description="Properties with which snapshots are created such as labels, encryption keys.",
    )


class Reservation(BaseModel):
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    specific_reservation: Optional[AllocationSpecificSkuReservation] = Field(
        None,
        alias="specificReservation",
        description="Reservation for instances with specific machine shapes.",
    )
    specific_reservation_required: Optional[bool] = Field(
        None,
        alias="specificReservationRequired",
        description='Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.',
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    commitment: Optional[str] = Field(
        None,
        description="[Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.",
    )
    share_settings: Optional[ShareSettings] = Field(
        None, alias="shareSettings", description="Share-settings for shared-reservation"
    )
    kind: Optional[str] = Field(
        "compute#reservation",
        description="[Output Only] Type of the resource. Always compute#reservations for reservations.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    zone: Optional[str] = Field(
        None,
        description="Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined fully-qualified URL for this resource.",
    )
    status: Optional[Status6] = Field(
        None, description="[Output Only] The status of the reservation."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )


class InstanceList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Instance]] = Field(None, description="A list of Instance resources.")
    warning: Optional[Warning14] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#instanceList",
        description="[Output Only] Type of resource. Always compute#instanceList for lists of Instance resources.",
    )


class InstanceAggregatedList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[Dict[str, InstancesScopedList]] = Field(
        None, description="An object that contains a list of instances scoped by zone."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning16] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#instanceAggregatedList",
        description="[Output Only] Type of resource. Always compute#instanceAggregatedList for aggregated lists of Instance resources.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class RoutersPreviewResponse(BaseModel):
    resource: Optional[Router] = Field(None, description="Preview of given router.")


class Autoscaler(BaseModel):
    kind: Optional[str] = Field(
        "compute#autoscaler",
        description="[Output Only] Type of the resource. Always compute#autoscaler for autoscalers.",
    )
    target: Optional[str] = Field(
        None,
        description="URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.",
    )
    zone: Optional[str] = Field(
        None,
        description="[Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).",
    )
    status: Optional[Status9] = Field(
        None,
        description="[Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).",
    )
    autoscaling_policy: Optional[AutoscalingPolicy] = Field(
        None,
        alias="autoscalingPolicy",
        description="The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    status_details: Optional[List[AutoscalerStatusDetails]] = Field(
        None,
        alias="statusDetails",
        description="[Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.",
    )
    recommended_size: Optional[int] = Field(
        None,
        alias="recommendedSize",
        description="[Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    scaling_schedule_status: Optional[Dict[str, ScalingScheduleStatus]] = Field(
        None,
        alias="scalingScheduleStatus",
        description="[Output Only] Status information of existing scaling schedules.",
    )


class ReservationsScopedList(BaseModel):
    reservations: Optional[List[Reservation]] = Field(
        None, description="A list of reservations contained in this scope."
    )
    warning: Optional[Warning24] = Field(
        None,
        description="Informational warning which replaces the list of reservations when the list is empty.",
    )


class MachineImage(BaseModel):
    guest_flush: Optional[bool] = Field(
        None,
        alias="guestFlush",
        description="[Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.",
    )
    storage_locations: Optional[List[str]] = Field(
        None,
        alias="storageLocations",
        description="The regional or multi-regional Cloud Storage bucket location where the machine image is stored.",
    )
    total_storage_bytes: Optional[str] = Field(
        None,
        alias="totalStorageBytes",
        description="[Output Only] Total size of the storage used by the machine image.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    source_instance_properties: Optional[SourceInstanceProperties] = Field(
        None,
        alias="sourceInstanceProperties",
        description="[Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    source_disk_encryption_keys: Optional[List[SourceDiskEncryptionKey]] = Field(
        None,
        alias="sourceDiskEncryptionKeys",
        description="[Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] The creation timestamp for this machine image in RFC3339 text format.",
    )
    kind: Optional[str] = Field(
        "compute#machineImage",
        description="[Output Only] The resource type, which is always compute#machineImage for machine image.",
    )
    saved_disks: Optional[List[SavedDisk]] = Field(
        None,
        alias="savedDisks",
        description="An array of Machine Image specific properties for disks attached to the source instance",
    )
    satisfies_pzs: Optional[bool] = Field(
        None, alias="satisfiesPzs", description="[Output Only] Reserved for future use."
    )
    status: Optional[Status16] = Field(
        None,
        description="[Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] A unique identifier for this machine image. The server defines this identifier.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] The URL for this machine image. The server defines this URL.",
    )
    source_instance: Optional[str] = Field(
        None,
        alias="sourceInstance",
        description="The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance ",
    )
    machine_image_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None,
        alias="machineImageEncryptionKey",
        description="Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.",
    )
    instance_properties: Optional[InstanceProperties] = Field(
        None,
        alias="instanceProperties",
        description="[Output Only] Properties of source instance",
    )


class RegionInstanceGroupManagersListErrorsResponse(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[InstanceManagedByIgmError]] = Field(
        None,
        description="[Output Only] The list of errors of the managed instance group.",
    )


class NetworkEndpointGroupsListNetworkEndpoints(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#networkEndpointGroupsListNetworkEndpoints",
        description="[Output Only] The resource type, which is always compute#networkEndpointGroupsListNetworkEndpoints for the list of network endpoints in the specified network endpoint group.",
    )
    items: Optional[List[NetworkEndpointWithHealthStatus]] = Field(
        None, description="A list of NetworkEndpointWithHealthStatus resources."
    )
    warning: Optional[Warning32] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class ServiceAttachmentAggregatedList(BaseModel):
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    kind: Optional[str] = Field(
        "compute#serviceAttachmentAggregatedList", description="Type of resource."
    )
    warning: Optional[Warning33] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, ServiceAttachmentsScopedList]] = Field(
        None, description="A list of ServiceAttachmentsScopedList resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class ReservationAggregatedList(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, ReservationsScopedList]] = Field(
        None, description="A list of Allocation resources."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning37] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#reservationAggregatedList", description="Type of resource."
    )


class NodeTemplateAggregatedList(BaseModel):
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#nodeTemplateAggregatedList",
        description="[Output Only] Type of resource.Always compute#nodeTemplateAggregatedList for aggregated lists of node templates.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning43] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[Dict[str, NodeTemplatesScopedList]] = Field(
        None, description="A list of NodeTemplatesScopedList resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class InstanceTemplate(BaseModel):
    id: Optional[str] = Field(
        None,
        description="[Output Only] A unique identifier for this instance template. The server defines this identifier.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    source_instance_params: Optional[SourceInstanceParams] = Field(
        None,
        alias="sourceInstanceParams",
        description="The source instance params to use to create this instance template.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] The URL for this instance template. The server defines this URL.",
    )
    properties: Optional[InstanceProperties] = Field(
        None, description="The instance properties for this instance template."
    )
    source_instance: Optional[str] = Field(
        None,
        alias="sourceInstance",
        description="The source instance used to create the template. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance ",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] The creation timestamp for this instance template in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    kind: Optional[str] = Field(
        "compute#instanceTemplate",
        description="[Output Only] The resource type, which is always compute#instanceTemplate for instance templates.",
    )


class Rule(BaseModel):
    conditions: Optional[List[Condition]] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    not_ins: Optional[List[str]] = Field(
        None,
        alias="notIns",
        description="This is deprecated and has no effect. Do not use.",
    )
    description: Optional[str] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    log_configs: Optional[List[LogConfig]] = Field(
        None,
        alias="logConfigs",
        description="This is deprecated and has no effect. Do not use.",
    )
    action: Optional[Action1] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    ins: Optional[List[str]] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    permissions: Optional[List[str]] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )


class BulkInsertInstanceResource(BaseModel):
    per_instance_properties: Optional[
        Dict[str, BulkInsertInstanceResourcePerInstanceProperties]
    ] = Field(
        None,
        alias="perInstanceProperties",
        description="Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.",
    )
    source_instance_template: Optional[str] = Field(
        None,
        alias="sourceInstanceTemplate",
        description="Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.",
    )
    location_policy: Optional[LocationPolicy] = Field(
        None, alias="locationPolicy", description="Policy for chosing target zone."
    )
    count: Optional[str] = Field(None, description="The maximum number of instances to create.")
    min_count: Optional[str] = Field(
        None,
        alias="minCount",
        description="The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.",
    )
    instance_properties: Optional[InstanceProperties] = Field(
        None,
        alias="instanceProperties",
        description="The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.",
    )
    name_pattern: Optional[str] = Field(
        None,
        alias="namePattern",
        description="The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.",
    )


class Policy1(BaseModel):
    rules: Optional[List[Rule]] = Field(
        None, description="This is deprecated and has no effect. Do not use."
    )
    bindings: Optional[List[Binding]] = Field(
        None,
        description="Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.",
    )
    version: Optional[int] = Field(
        None,
        description="Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
    )
    audit_configs: Optional[List[AuditConfig]] = Field(
        None,
        alias="auditConfigs",
        description="Specifies cloud audit logging configuration for this policy.",
    )
    etag: Optional[str] = Field(
        None,
        description="`etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.",
    )


class ForwardingRuleAggregatedList(BaseModel):
    warning: Optional[Warning51] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[Dict[str, ForwardingRulesScopedList]] = Field(
        None, description="A list of ForwardingRulesScopedList resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#forwardingRuleAggregatedList",
        description="[Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )


class RouterAggregatedList(BaseModel):
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    warning: Optional[Warning55] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field("compute#routerAggregatedList", description="Type of resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[Dict[str, RoutersScopedList]] = Field(
        None, description="A list of Router resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )


class InstanceGroupManagersScopedList(BaseModel):
    instance_group_managers: Optional[List[InstanceGroupManager]] = Field(
        None,
        alias="instanceGroupManagers",
        description="[Output Only] The list of managed instance groups that are contained in the specified project and zone.",
    )
    warning: Optional[Warning63] = Field(
        None,
        description="[Output Only] The warning that replaces the list of managed instance groups when the list is empty.",
    )


class InterconnectsGetDiagnosticsResponse(BaseModel):
    result: Optional[InterconnectDiagnostics] = None


class FirewallPolicyList(BaseModel):
    warning: Optional[Warning68] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[FirewallPolicy]] = Field(
        None, description="A list of FirewallPolicy resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#firewallPolicyList",
        description="[Output Only] Type of resource. Always compute#firewallPolicyList for listsof FirewallPolicies",
    )


class AutoscalerList(BaseModel):
    items: Optional[List[Autoscaler]] = Field(None, description="A list of Autoscaler resources.")
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning72] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#autoscalerList",
        description="[Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.",
    )


class RegionSetPolicyRequest(BaseModel):
    policy: Optional[Policy1] = Field(
        None,
        description="REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.",
    )
    etag: Optional[str] = Field(
        None,
        description="Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.",
    )
    bindings: Optional[List[Binding]] = Field(
        None,
        description="Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use 'policy' to specify bindings.",
    )


class RouterStatus(BaseModel):
    best_routes_for_router: Optional[List[Route1]] = Field(
        None,
        alias="bestRoutesForRouter",
        description="Best routes learned by this router.",
    )
    network: Optional[str] = Field(
        None, description="URI of the network to which this router belongs."
    )
    best_routes: Optional[List[Route1]] = Field(
        None, alias="bestRoutes", description="Best routes for this router's network."
    )
    bgp_peer_status: Optional[List[RouterStatusBgpPeerStatus]] = Field(None, alias="bgpPeerStatus")
    nat_status: Optional[List[RouterStatusNatStatus]] = Field(None, alias="natStatus")


class SecurityPoliciesListPreconfiguredExpressionSetsResponse(BaseModel):
    preconfigured_expression_sets: Optional[SecurityPoliciesWafConfig] = Field(
        None, alias="preconfiguredExpressionSets"
    )


class SecurityPolicyList(BaseModel):
    warning: Optional[Warning91] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#securityPolicyList",
        description="[Output Only] Type of resource. Always compute#securityPolicyList for listsof securityPolicies",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[SecurityPolicy]] = Field(
        None, description="A list of SecurityPolicy resources."
    )


class InstanceTemplateList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#instanceTemplateList",
        description="[Output Only] The resource type, which is always compute#instanceTemplatesListResponse for instance template lists.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning97] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    items: Optional[List[InstanceTemplate]] = Field(
        None, description="A list of InstanceTemplate resources."
    )


class ZoneSetPolicyRequest(BaseModel):
    etag: Optional[str] = Field(
        None,
        description="Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.",
    )
    policy: Optional[Policy1] = Field(
        None,
        description="REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.",
    )
    bindings: Optional[List[Binding]] = Field(
        None,
        description="Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use 'policy' to specify bindings.",
    )


class SecurityPoliciesScopedList(BaseModel):
    security_policies: Optional[List[SecurityPolicy]] = Field(
        None,
        alias="securityPolicies",
        description="A list of SecurityPolicies contained in this scope.",
    )
    warning: Optional[Warning122] = Field(
        None,
        description="Informational warning which replaces the list of security policies when the list is empty.",
    )


class RegionAutoscalerList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning136] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field("compute#regionAutoscalerList", description="Type of resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[List[Autoscaler]] = Field(None, description="A list of Autoscaler resources.")


class ReservationList(BaseModel):
    warning: Optional[Warning137] = Field(
        None, description="[Output Only] Informational warning message."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    items: Optional[List[Reservation]] = Field(
        None, description="[Output Only] A list of Allocation resources."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#reservationList",
        description="[Output Only] Type of resource.Always compute#reservationsList for listsof reservations",
    )


class MachineImageList(BaseModel):
    items: Optional[List[MachineImage]] = Field(
        None, description="A list of MachineImage resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#machineImageList",
        description="[Output Only] The resource type, which is always compute#machineImagesListResponse for machine image lists.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning138] = Field(
        None, description="[Output Only] Informational warning message."
    )


class GlobalOrganizationSetPolicyRequest(BaseModel):
    bindings: Optional[List[Binding]] = Field(
        None,
        description="Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.",
    )
    policy: Optional[Policy1] = Field(
        None,
        description="REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.",
    )
    etag: Optional[str] = Field(
        None,
        description="Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.",
    )


class PathMatcher(BaseModel):
    path_rules: Optional[List[PathRule]] = Field(
        None,
        alias="pathRules",
        description="The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/* will match before /a/b/* irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.",
    )
    default_url_redirect: Optional[HttpRedirectAction] = Field(
        None,
        alias="defaultUrlRedirect",
        description="When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    default_service: Optional[str] = Field(
        None,
        alias="defaultService",
        description="The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. Only one of defaultService, defaultUrlRedirect , or defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use ",
    )
    header_action: Optional[HttpHeaderAction] = Field(
        None,
        alias="headerAction",
        description="Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )
    default_route_action: Optional[HttpRouteAction] = Field(
        None,
        alias="defaultRouteAction",
        description="defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a path matcher's defaultRouteAction.",
    )
    route_rules: Optional[List[HttpRouteRule]] = Field(
        None,
        alias="routeRules",
        description="The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.",
    )
    name: Optional[str] = Field(
        None,
        description="The name to which this PathMatcher is referred by the HostRule.",
    )


class ResourcePolicy(BaseModel):
    resource_status: Optional[ResourcePolicyResourceStatus] = Field(
        None,
        alias="resourceStatus",
        description="[Output Only] The system status of the resource policy.",
    )
    description: Optional[str] = None
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    instance_schedule_policy: Optional[ResourcePolicyInstanceSchedulePolicy] = Field(
        None,
        alias="instanceSchedulePolicy",
        description="Resource policy for scheduling instance operations.",
    )
    group_placement_policy: Optional[ResourcePolicyGroupPlacementPolicy] = Field(
        None,
        alias="groupPlacementPolicy",
        description="Resource policy for instances for placement configuration.",
    )
    snapshot_schedule_policy: Optional[ResourcePolicySnapshotSchedulePolicy] = Field(
        None,
        alias="snapshotSchedulePolicy",
        description="Resource policy for persistent disks for creating snapshots.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    status: Optional[Status3] = Field(
        None, description="[Output Only] The status of resource policy creation."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined fully-qualified URL for this resource.",
    )
    kind: Optional[str] = Field(
        "compute#resourcePolicy",
        description="[Output Only] Type of the resource. Always compute#resource_policies for resource policies.",
    )
    region: Optional[str] = None


class Commitment(BaseModel):
    resources: Optional[List[ResourceCommitment]] = Field(
        None,
        description="A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.",
    )
    kind: Optional[str] = Field(
        "compute#commitment",
        description="[Output Only] Type of the resource. Always compute#commitment for commitments.",
    )
    auto_renew: Optional[bool] = Field(
        None,
        alias="autoRenew",
        description="Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.",
    )
    status_message: Optional[str] = Field(
        None,
        alias="statusMessage",
        description="[Output Only] An optional, human-readable explanation of the status.",
    )
    license_resource: Optional[LicenseResourceCommitment] = Field(
        None,
        alias="licenseResource",
        description="The license specification required as part of a license commitment.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    type: Optional[Type6] = Field(
        None,
        description="The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.",
    )
    status: Optional[Status5] = Field(
        None,
        description="[Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where this commitment may be used.",
    )
    category: Optional[Category] = Field(
        None,
        description="The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    start_timestamp: Optional[str] = Field(
        None,
        alias="startTimestamp",
        description="[Output Only] Commitment start time in RFC3339 text format.",
    )
    reservations: Optional[List[Reservation]] = Field(
        None, description="List of reservations in this commitment."
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    end_timestamp: Optional[str] = Field(
        None,
        alias="endTimestamp",
        description="[Output Only] Commitment end time in RFC3339 text format.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    plan: Optional[Plan] = Field(
        None,
        description="The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).",
    )


class AutoscalersScopedList(BaseModel):
    warning: Optional[Warning21] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of autoscalers when the list is empty.",
    )
    autoscalers: Optional[List[Autoscaler]] = Field(
        None, description="[Output Only] A list of autoscalers contained in this scope."
    )


class GlobalSetPolicyRequest(BaseModel):
    policy: Optional[Policy1] = Field(
        None,
        description="REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.",
    )
    bindings: Optional[List[Binding]] = Field(
        None,
        description="Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.",
    )
    etag: Optional[str] = Field(
        None,
        description="Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.",
    )


class InstanceGroupManagerAggregatedList(BaseModel):
    items: Optional[Dict[str, InstanceGroupManagersScopedList]] = Field(
        None, description="A list of InstanceGroupManagersScopedList resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    kind: Optional[str] = Field(
        "compute#instanceGroupManagerAggregatedList",
        description="[Output Only] The resource type, which is always compute#instanceGroupManagerAggregatedList for an aggregated list of managed instance groups.",
    )
    warning: Optional[Warning62] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class RouterStatusResponse(BaseModel):
    kind: Optional[str] = Field("compute#routerStatusResponse", description="Type of resource.")
    result: Optional[RouterStatus] = None


class CommitmentList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field(
        "compute#commitmentList",
        description="[Output Only] Type of resource. Always compute#commitmentList for lists of commitments.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    warning: Optional[Warning110] = Field(
        None, description="[Output Only] Informational warning message."
    )
    items: Optional[List[Commitment]] = Field(None, description="A list of Commitment resources.")


class SecurityPoliciesAggregatedList(BaseModel):
    etag: Optional[str] = None
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    items: Optional[Dict[str, SecurityPoliciesScopedList]] = Field(
        None, description="A list of SecurityPoliciesScopedList resources."
    )
    kind: Optional[str] = Field(
        "compute#securityPoliciesAggregatedList",
        description="[Output Only] Type of resource. Always compute#securityPolicyAggregatedList for lists of Security Policies.",
    )
    warning: Optional[Warning121] = Field(
        None, description="[Output Only] Informational warning message."
    )


class ResourcePolicyList(BaseModel):
    items: Optional[List[ResourcePolicy]] = Field(
        None, description="[Output Only] A list of ResourcePolicy resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning126] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    etag: Optional[str] = None
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#resourcePolicyList",
        description="[Output Only] Type of resource.Always compute#resourcePoliciesList for listsof resourcePolicies",
    )


class UrlMap(BaseModel):
    tests: Optional[List[UrlMapTest]] = Field(
        None,
        description="The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )
    default_service: Optional[str] = Field(
        None,
        alias="defaultService",
        description="The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of defaultService, defaultUrlRedirect , or defaultRouteAction.weightedBackendService must be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.",
    )
    description: Optional[str] = Field(
        None,
        description="An optional description of this resource. Provide this property when you create the resource.",
    )
    default_route_action: Optional[HttpRouteAction] = Field(
        None,
        alias="defaultRouteAction",
        description="defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for the resource.",
    )
    fingerprint: Optional[str] = Field(
        None,
        description="Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.",
    )
    header_action: Optional[HttpHeaderAction] = Field(
        None,
        alias="headerAction",
        description="Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.",
    )
    creation_timestamp: Optional[str] = Field(
        None,
        alias="creationTimestamp",
        description="[Output Only] Creation timestamp in RFC3339 text format.",
    )
    region: Optional[str] = Field(
        None,
        description="[Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.",
    )
    path_matchers: Optional[List[PathMatcher]] = Field(
        None,
        alias="pathMatchers",
        description="The list of named PathMatchers to use against the URL.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] The unique identifier for the resource. This identifier is defined by the server.",
    )
    kind: Optional[str] = Field(
        "compute#urlMap",
        description="[Output Only] Type of the resource. Always compute#urlMaps for url maps.",
    )
    host_rules: Optional[List[HostRule]] = Field(
        None,
        alias="hostRules",
        description="The list of host rules to use against the URL.",
    )
    name: Optional[constr(regex=r"[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?")] = Field(
        None,
        description="Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.",
    )
    default_url_redirect: Optional[HttpRedirectAction] = Field(
        None,
        alias="defaultUrlRedirect",
        description="When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.",
    )


class ResourcePoliciesScopedList(BaseModel):
    warning: Optional[Warning9] = Field(
        None,
        description="Informational warning which replaces the list of resourcePolicies when the list is empty.",
    )
    resource_policies: Optional[List[ResourcePolicy]] = Field(
        None,
        alias="resourcePolicies",
        description="A list of resourcePolicies contained in this scope.",
    )


class CommitmentsScopedList(BaseModel):
    warning: Optional[Warning12] = Field(
        None,
        description="[Output Only] Informational warning which replaces the list of commitments when the list is empty.",
    )
    commitments: Optional[List[Commitment]] = Field(
        None, description="[Output Only] A list of commitments contained in this scope."
    )


class RegionUrlMapsValidateRequest(BaseModel):
    resource: Optional[UrlMap] = Field(None, description="Content of the UrlMap to be validated.")


class AutoscalerAggregatedList(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning20] = Field(
        None, description="[Output Only] Informational warning message."
    )
    kind: Optional[str] = Field(
        "compute#autoscalerAggregatedList",
        description="[Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    unreachables: Optional[List[str]] = Field(
        None,
        description="[Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder",
    )
    items: Optional[Dict[str, AutoscalersScopedList]] = Field(
        None, description="A list of AutoscalersScopedList resources."
    )


class UrlMapsScopedList(BaseModel):
    warning: Optional[Warning41] = Field(
        None,
        description="Informational warning which replaces the list of backend services when the list is empty.",
    )
    url_maps: Optional[List[UrlMap]] = Field(
        None, alias="urlMaps", description="A list of UrlMaps contained in this scope."
    )


class ResourcePolicyAggregatedList(BaseModel):
    warning: Optional[Warning67] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    etag: Optional[str] = None
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, ResourcePoliciesScopedList]] = Field(
        None, description="A list of ResourcePolicy resources."
    )
    kind: Optional[str] = Field(
        "compute#resourcePolicyAggregatedList", description="Type of resource."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class UrlMapsAggregatedList(BaseModel):
    warning: Optional[Warning132] = Field(
        None, description="[Output Only] Informational warning message."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    kind: Optional[str] = Field("compute#urlMapsAggregatedList", description="Type of resource.")
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    items: Optional[Dict[str, UrlMapsScopedList]] = Field(
        None, description="A list of UrlMapsScopedList resources."
    )


class UrlMapList(BaseModel):
    kind: Optional[str] = Field("compute#urlMapList", description="Type of resource.")
    items: Optional[List[UrlMap]] = Field(None, description="A list of UrlMap resources.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )
    warning: Optional[Warning141] = Field(
        None, description="[Output Only] Informational warning message."
    )
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )


class UrlMapsValidateRequest(BaseModel):
    resource: Optional[UrlMap] = Field(None, description="Content of the UrlMap to be validated.")
    load_balancing_schemes: Optional[List[LoadBalancingScheme]] = Field(
        None,
        alias="loadBalancingSchemes",
        description="Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for HTTP/HTTPS External Global Load Balancer with Advanced Traffic Management. Use EXTERNAL for Classic HTTP/HTTPS External Global Load Balancer. Other load balancer types are not supported. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.",
    )


class CommitmentAggregatedList(BaseModel):
    self_link: Optional[str] = Field(
        None,
        alias="selfLink",
        description="[Output Only] Server-defined URL for this resource.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="[Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.",
    )
    warning: Optional[Warning11] = Field(
        None, description="[Output Only] Informational warning message."
    )
    unreachables: Optional[List[str]] = Field(
        None, description="[Output Only] Unreachable resources."
    )
    kind: Optional[str] = Field(
        "compute#commitmentAggregatedList",
        description="[Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.",
    )
    items: Optional[Dict[str, CommitmentsScopedList]] = Field(
        None, description="A list of CommitmentsScopedList resources."
    )
    id: Optional[str] = Field(
        None,
        description="[Output Only] Unique identifier for the resource; defined by the server.",
    )


class Model(BaseModel):
    operation_aggregated_list: Optional[OperationAggregatedList] = Field(
        None, alias="OperationAggregatedList"
    )
    instance_group_managers_recreate_instances_request: Optional[
        InstanceGroupManagersRecreateInstancesRequest
    ] = Field(None, alias="InstanceGroupManagersRecreateInstancesRequest")
    firewall_policy_rule_secure_tag: Optional[FirewallPolicyRuleSecureTag] = Field(
        None, alias="FirewallPolicyRuleSecureTag"
    )
    projects_get_xpn_resources: Optional[ProjectsGetXpnResources] = Field(
        None, alias="ProjectsGetXpnResources"
    )
    instance_properties: Optional[InstanceProperties] = Field(None, alias="InstanceProperties")
    interconnect_location_region_info: Optional[InterconnectLocationRegionInfo] = Field(
        None, alias="InterconnectLocationRegionInfo"
    )
    region_instance_group_managers_create_instances_request: Optional[
        RegionInstanceGroupManagersCreateInstancesRequest
    ] = Field(None, alias="RegionInstanceGroupManagersCreateInstancesRequest")
    interconnect_outage_notification: Optional[InterconnectOutageNotification] = Field(
        None, alias="InterconnectOutageNotification"
    )
    security_policy: Optional[SecurityPolicy] = Field(None, alias="SecurityPolicy")
    external_vpn_gateway_interface: Optional[ExternalVpnGatewayInterface] = Field(
        None, alias="ExternalVpnGatewayInterface"
    )
    http_fault_injection: Optional[HttpFaultInjection] = Field(None, alias="HttpFaultInjection")
    instance_list_referrers: Optional[InstanceListReferrers] = Field(
        None, alias="InstanceListReferrers"
    )
    node_type_list: Optional[NodeTypeList] = Field(None, alias="NodeTypeList")
    route: Optional[Route1] = Field(None, alias="Route")
    shielded_instance_identity: Optional[ShieldedInstanceIdentity] = Field(
        None, alias="ShieldedInstanceIdentity"
    )
    health_check_service_reference: Optional[HealthCheckServiceReference] = Field(
        None, alias="HealthCheckServiceReference"
    )
    target_pools_remove_health_check_request: Optional[TargetPoolsRemoveHealthCheckRequest] = Field(
        None, alias="TargetPoolsRemoveHealthCheckRequest"
    )
    health_check_services_list: Optional[HealthCheckServicesList] = Field(
        None, alias="HealthCheckServicesList"
    )
    region_instance_group_list: Optional[RegionInstanceGroupList] = Field(
        None, alias="RegionInstanceGroupList"
    )
    per_instance_config: Optional[PerInstanceConfig] = Field(None, alias="PerInstanceConfig")
    cors_policy: Optional[CorsPolicy] = Field(None, alias="CorsPolicy")
    url_maps_validate_request: Optional[UrlMapsValidateRequest] = Field(
        None, alias="UrlMapsValidateRequest"
    )
    node_group_list: Optional[NodeGroupList] = Field(None, alias="NodeGroupList")
    waf_expression_set: Optional[WafExpressionSet] = Field(None, alias="WafExpressionSet")
    resource_policies_scoped_list: Optional[ResourcePoliciesScopedList] = Field(
        None, alias="ResourcePoliciesScopedList"
    )
    instance_group_manager_status: Optional[InstanceGroupManagerStatus] = Field(
        None, alias="InstanceGroupManagerStatus"
    )
    target_vpn_gateway_list: Optional[TargetVpnGatewayList] = Field(
        None, alias="TargetVpnGatewayList"
    )
    commitment_aggregated_list: Optional[CommitmentAggregatedList] = Field(
        None, alias="CommitmentAggregatedList"
    )
    backend_service: Optional[BackendService] = Field(None, alias="BackendService")
    disk_list: Optional[DiskList] = Field(None, alias="DiskList")
    instance_list: Optional[InstanceList] = Field(None, alias="InstanceList")
    region_url_maps_validate_request: Optional[RegionUrlMapsValidateRequest] = Field(
        None, alias="RegionUrlMapsValidateRequest"
    )
    instances_set_service_account_request: Optional[InstancesSetServiceAccountRequest] = Field(
        None, alias="InstancesSetServiceAccountRequest"
    )
    network_endpoint_group: Optional[NetworkEndpointGroup] = Field(
        None, alias="NetworkEndpointGroup"
    )
    preserved_state_preserved_disk: Optional[PreservedStatePreservedDisk] = Field(
        None, alias="PreservedStatePreservedDisk"
    )
    target_ssl_proxies_set_proxy_header_request: Optional[
        TargetSslProxiesSetProxyHeaderRequest
    ] = Field(None, alias="TargetSslProxiesSetProxyHeaderRequest")
    disk_move_request: Optional[DiskMoveRequest] = Field(None, alias="DiskMoveRequest")
    node_types_scoped_list: Optional[NodeTypesScopedList] = Field(None, alias="NodeTypesScopedList")
    instance_aggregated_list: Optional[InstanceAggregatedList] = Field(
        None, alias="InstanceAggregatedList"
    )
    https_health_check_list: Optional[HttpsHealthCheckList] = Field(
        None, alias="HttpsHealthCheckList"
    )
    vpn_gateway_status_vpn_connection: Optional[VpnGatewayStatusVpnConnection] = Field(
        None, alias="VpnGatewayStatusVpnConnection"
    )
    router_nat: Optional[RouterNat] = Field(None, alias="RouterNat")
    waf_expression_set_expression: Optional[WafExpressionSetExpression] = Field(
        None, alias="WafExpressionSetExpression"
    )
    xpn_host_list: Optional[XpnHostList] = Field(None, alias="XpnHostList")
    connection_draining: Optional[ConnectionDraining] = Field(None, alias="ConnectionDraining")
    router_interface: Optional[RouterInterface] = Field(None, alias="RouterInterface")
    security_policy_rule_matcher: Optional[SecurityPolicyRuleMatcher] = Field(
        None, alias="SecurityPolicyRuleMatcher"
    )
    reservations_resize_request: Optional[ReservationsResizeRequest] = Field(
        None, alias="ReservationsResizeRequest"
    )
    interconnect_attachment_partner_metadata: Optional[
        InterconnectAttachmentPartnerMetadata
    ] = Field(None, alias="InterconnectAttachmentPartnerMetadata")
    subnetworks_expand_ip_cidr_range_request: Optional[SubnetworksExpandIpCidrRangeRequest] = Field(
        None, alias="SubnetworksExpandIpCidrRangeRequest"
    )
    routers_preview_response: Optional[RoutersPreviewResponse] = Field(
        None, alias="RoutersPreviewResponse"
    )
    weighted_backend_service: Optional[WeightedBackendService] = Field(
        None, alias="WeightedBackendService"
    )
    bfd_status_packet_counts: Optional[BfdStatusPacketCounts] = Field(
        None, alias="BfdStatusPacketCounts"
    )
    allocation_specific_sku_allocation_reserved_instance_properties: Optional[
        AllocationSpecificSkuAllocationReservedInstanceProperties
    ] = Field(None, alias="AllocationSpecificSKUAllocationReservedInstanceProperties")
    instance_group_managers_delete_instances_request: Optional[
        InstanceGroupManagersDeleteInstancesRequest
    ] = Field(None, alias="InstanceGroupManagersDeleteInstancesRequest")
    project: Optional[Project] = Field(None, alias="Project")
    external_vpn_gateway: Optional[ExternalVpnGateway] = Field(None, alias="ExternalVpnGateway")
    autoscaler_aggregated_list: Optional[AutoscalerAggregatedList] = Field(
        None, alias="AutoscalerAggregatedList"
    )
    autoscaling_policy_cpu_utilization: Optional[AutoscalingPolicyCpuUtilization] = Field(
        None, alias="AutoscalingPolicyCpuUtilization"
    )
    target_https_proxies_set_certificate_map_request: Optional[
        TargetHttpsProxiesSetCertificateMapRequest
    ] = Field(None, alias="TargetHttpsProxiesSetCertificateMapRequest")
    resource_policy_instance_schedule_policy_schedule: Optional[
        ResourcePolicyInstanceSchedulePolicySchedule
    ] = Field(None, alias="ResourcePolicyInstanceSchedulePolicySchedule")
    network_endpoint_groups_detach_endpoints_request: Optional[
        NetworkEndpointGroupsDetachEndpointsRequest
    ] = Field(None, alias="NetworkEndpointGroupsDetachEndpointsRequest")
    image_family_view: Optional[ImageFamilyView] = Field(None, alias="ImageFamilyView")
    node_type_aggregated_list: Optional[NodeTypeAggregatedList] = Field(
        None, alias="NodeTypeAggregatedList"
    )
    instance_reference: Optional[InstanceReference] = Field(None, alias="InstanceReference")
    node_type: Optional[NodeType] = Field(None, alias="NodeType")
    vpn_gateways_get_status_response: Optional[VpnGatewaysGetStatusResponse] = Field(
        None, alias="VpnGatewaysGetStatusResponse"
    )
    reservation_affinity: Optional[ReservationAffinity] = Field(None, alias="ReservationAffinity")
    backend_service_locality_load_balancing_policy_config_custom_policy: Optional[
        BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy
    ] = Field(None, alias="BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy")
    interconnect_attachment_list: Optional[InterconnectAttachmentList] = Field(
        None, alias="InterconnectAttachmentList"
    )
    node_groups_delete_nodes_request: Optional[NodeGroupsDeleteNodesRequest] = Field(
        None, alias="NodeGroupsDeleteNodesRequest"
    )
    notification_endpoint_grpc_settings: Optional[NotificationEndpointGrpcSettings] = Field(
        None, alias="NotificationEndpointGrpcSettings"
    )
    access_config: Optional[AccessConfig] = Field(None, alias="AccessConfig")
    vm_endpoint_nat_mappings: Optional[VmEndpointNatMappings] = Field(
        None, alias="VmEndpointNatMappings"
    )
    target_pools_add_health_check_request: Optional[TargetPoolsAddHealthCheckRequest] = Field(
        None, alias="TargetPoolsAddHealthCheckRequest"
    )
    target_reference: Optional[TargetReference] = Field(None, alias="TargetReference")
    reservations_scoped_list: Optional[ReservationsScopedList] = Field(
        None, alias="ReservationsScopedList"
    )
    router_nat_rule_action: Optional[RouterNatRuleAction] = Field(None, alias="RouterNatRuleAction")
    snapshot_list: Optional[SnapshotList] = Field(None, alias="SnapshotList")
    region_disks_resize_request: Optional[RegionDisksResizeRequest] = Field(
        None, alias="RegionDisksResizeRequest"
    )
    firewall_policies_list_associations_response: Optional[
        FirewallPoliciesListAssociationsResponse
    ] = Field(None, alias="FirewallPoliciesListAssociationsResponse")
    public_advertised_prefix_list: Optional[PublicAdvertisedPrefixList] = Field(
        None, alias="PublicAdvertisedPrefixList"
    )
    vpn_tunnel: Optional[VpnTunnel] = Field(None, alias="VpnTunnel")
    backend_service_cdn_policy_bypass_cache_on_request_header: Optional[
        BackendServiceCdnPolicyBypassCacheOnRequestHeader
    ] = Field(None, alias="BackendServiceCdnPolicyBypassCacheOnRequestHeader")
    stateful_policy_preserved_state_disk_device: Optional[
        StatefulPolicyPreservedStateDiskDevice
    ] = Field(None, alias="StatefulPolicyPreservedStateDiskDevice")
    grpc_health_check: Optional[GrpcHealthCheck] = Field(None, alias="GRPCHealthCheck")
    public_delegated_prefix_list: Optional[PublicDelegatedPrefixList] = Field(
        None, alias="PublicDelegatedPrefixList"
    )
    autoscaler_status_details: Optional[AutoscalerStatusDetails] = Field(
        None, alias="AutoscalerStatusDetails"
    )
    instance_group_list: Optional[InstanceGroupList] = Field(None, alias="InstanceGroupList")
    firewall_policy_rule_matcher_layer4_config: Optional[
        FirewallPolicyRuleMatcherLayer4Config
    ] = Field(None, alias="FirewallPolicyRuleMatcherLayer4Config")
    region_target_https_proxies_set_ssl_certificates_request: Optional[
        RegionTargetHttpsProxiesSetSslCertificatesRequest
    ] = Field(None, alias="RegionTargetHttpsProxiesSetSslCertificatesRequest")
    instance_groups_add_instances_request: Optional[InstanceGroupsAddInstancesRequest] = Field(
        None, alias="InstanceGroupsAddInstancesRequest"
    )
    audit_log_config: Optional[AuditLogConfig] = Field(None, alias="AuditLogConfig")
    duration: Optional[Duration] = Field(None, alias="Duration")
    disk_types_scoped_list: Optional[DiskTypesScopedList] = Field(None, alias="DiskTypesScopedList")
    reference: Optional[Reference] = Field(None, alias="Reference")
    network_routing_config: Optional[NetworkRoutingConfig] = Field(
        None, alias="NetworkRoutingConfig"
    )
    url_rewrite: Optional[UrlRewrite] = Field(None, alias="UrlRewrite")
    target_https_proxy: Optional[TargetHttpsProxy] = Field(None, alias="TargetHttpsProxy")
    url_maps_validate_response: Optional[UrlMapsValidateResponse] = Field(
        None, alias="UrlMapsValidateResponse"
    )
    resource_policy_snapshot_schedule_policy: Optional[
        ResourcePolicySnapshotSchedulePolicy
    ] = Field(None, alias="ResourcePolicySnapshotSchedulePolicy")
    global_network_endpoint_groups_detach_endpoints_request: Optional[
        GlobalNetworkEndpointGroupsDetachEndpointsRequest
    ] = Field(None, alias="GlobalNetworkEndpointGroupsDetachEndpointsRequest")
    vpn_tunnel_aggregated_list: Optional[VpnTunnelAggregatedList] = Field(
        None, alias="VpnTunnelAggregatedList"
    )
    binding: Optional[Binding] = Field(None, alias="Binding")
    packet_mirroring_mirrored_resource_info_subnet_info: Optional[
        PacketMirroringMirroredResourceInfoSubnetInfo
    ] = Field(None, alias="PacketMirroringMirroredResourceInfoSubnetInfo")
    machine_image: Optional[MachineImage] = Field(None, alias="MachineImage")
    region_instance_group_managers_list_errors_response: Optional[
        RegionInstanceGroupManagersListErrorsResponse
    ] = Field(None, alias="RegionInstanceGroupManagersListErrorsResponse")
    ssl_health_check: Optional[SslHealthCheck] = Field(None, alias="SSLHealthCheck")
    global_set_labels_request: Optional[GlobalSetLabelsRequest] = Field(
        None, alias="GlobalSetLabelsRequest"
    )
    network_endpoint_groups_list_network_endpoints: Optional[
        NetworkEndpointGroupsListNetworkEndpoints
    ] = Field(None, alias="NetworkEndpointGroupsListNetworkEndpoints")
    service_attachment_aggregated_list: Optional[ServiceAttachmentAggregatedList] = Field(
        None, alias="ServiceAttachmentAggregatedList"
    )
    notification_endpoint_list: Optional[NotificationEndpointList] = Field(
        None, alias="NotificationEndpointList"
    )
    target_ssl_proxy_list: Optional[TargetSslProxyList] = Field(None, alias="TargetSslProxyList")
    network_interface: Optional[NetworkInterface] = Field(None, alias="NetworkInterface")
    node_group_autoscaling_policy: Optional[NodeGroupAutoscalingPolicy] = Field(
        None, alias="NodeGroupAutoscalingPolicy"
    )
    security_policy_advanced_options_config: Optional[SecurityPolicyAdvancedOptionsConfig] = Field(
        None, alias="SecurityPolicyAdvancedOptionsConfig"
    )
    health_check: Optional[HealthCheck] = Field(None, alias="HealthCheck")
    health_check_log_config: Optional[HealthCheckLogConfig] = Field(
        None, alias="HealthCheckLogConfig"
    )
    region_instance_groups_set_named_ports_request: Optional[
        RegionInstanceGroupsSetNamedPortsRequest
    ] = Field(None, alias="RegionInstanceGroupsSetNamedPortsRequest")
    reservation_aggregated_list: Optional[ReservationAggregatedList] = Field(
        None, alias="ReservationAggregatedList"
    )
    instance_managed_by_igm_error_instance_action_details: Optional[
        InstanceManagedByIgmErrorInstanceActionDetails
    ] = Field(None, alias="InstanceManagedByIgmErrorInstanceActionDetails")
    instance_group_managers_create_instances_request: Optional[
        InstanceGroupManagersCreateInstancesRequest
    ] = Field(None, alias="InstanceGroupManagersCreateInstancesRequest")
    node_group_aggregated_list: Optional[NodeGroupAggregatedList] = Field(
        None, alias="NodeGroupAggregatedList"
    )
    addresses_scoped_list: Optional[AddressesScopedList] = Field(None, alias="AddressesScopedList")
    autoscaling_policy: Optional[AutoscalingPolicy] = Field(None, alias="AutoscalingPolicy")
    region_instance_group_managers_recreate_request: Optional[
        RegionInstanceGroupManagersRecreateRequest
    ] = Field(None, alias="RegionInstanceGroupManagersRecreateRequest")
    backend_bucket_cdn_policy: Optional[BackendBucketCdnPolicy] = Field(
        None, alias="BackendBucketCdnPolicy"
    )
    target_ssl_proxies_set_ssl_certificates_request: Optional[
        TargetSslProxiesSetSslCertificatesRequest
    ] = Field(None, alias="TargetSslProxiesSetSslCertificatesRequest")
    reservation: Optional[Reservation] = Field(None, alias="Reservation")
    share_settings: Optional[ShareSettings] = Field(None, alias="ShareSettings")
    license_resource_commitment: Optional[LicenseResourceCommitment] = Field(
        None, alias="LicenseResourceCommitment"
    )
    confidential_instance_config: Optional[ConfidentialInstanceConfig] = Field(
        None, alias="ConfidentialInstanceConfig"
    )
    url_maps_scoped_list: Optional[UrlMapsScopedList] = Field(None, alias="UrlMapsScopedList")
    region_instance_groups_list_instances: Optional[RegionInstanceGroupsListInstances] = Field(
        None, alias="RegionInstanceGroupsListInstances"
    )
    alias_ip_range: Optional[AliasIpRange] = Field(None, alias="AliasIpRange")
    node_template_aggregated_list: Optional[NodeTemplateAggregatedList] = Field(
        None, alias="NodeTemplateAggregatedList"
    )
    vm_endpoint_nat_mappings_list: Optional[VmEndpointNatMappingsList] = Field(
        None, alias="VmEndpointNatMappingsList"
    )
    instance_managed_by_igm_error_managed_instance_error: Optional[
        InstanceManagedByIgmErrorManagedInstanceError
    ] = Field(None, alias="InstanceManagedByIgmErrorManagedInstanceError")
    source_instance_properties: Optional[SourceInstanceProperties] = Field(
        None, alias="SourceInstanceProperties"
    )
    snapshot: Optional[Snapshot] = Field(None, alias="Snapshot")
    shielded_instance_integrity_policy: Optional[ShieldedInstanceIntegrityPolicy] = Field(
        None, alias="ShieldedInstanceIntegrityPolicy"
    )
    instance_template: Optional[InstanceTemplate] = Field(None, alias="InstanceTemplate")
    rule: Optional[Rule] = Field(None, alias="Rule")
    stateful_policy_preserved_state: Optional[StatefulPolicyPreservedState] = Field(
        None, alias="StatefulPolicyPreservedState"
    )
    interconnect_location: Optional[InterconnectLocation] = Field(
        None, alias="InterconnectLocation"
    )
    license_code: Optional[LicenseCode] = Field(None, alias="LicenseCode")
    commitments_scoped_list: Optional[CommitmentsScopedList] = Field(
        None, alias="CommitmentsScopedList"
    )
    node_groups_add_nodes_request: Optional[NodeGroupsAddNodesRequest] = Field(
        None, alias="NodeGroupsAddNodesRequest"
    )
    int64_range_match: Optional[Int64RangeMatch] = Field(None, alias="Int64RangeMatch")
    router_nat_rule: Optional[RouterNatRule] = Field(None, alias="RouterNatRule")
    security_policy_rule: Optional[SecurityPolicyRule] = Field(None, alias="SecurityPolicyRule")
    bulk_insert_instance_resource_per_instance_properties: Optional[
        BulkInsertInstanceResourcePerInstanceProperties
    ] = Field(None, alias="BulkInsertInstanceResourcePerInstanceProperties")
    projects_list_xpn_hosts_request: Optional[ProjectsListXpnHostsRequest] = Field(
        None, alias="ProjectsListXpnHostsRequest"
    )
    vpn_gateway_status: Optional[VpnGatewayStatus] = Field(None, alias="VpnGatewayStatus")
    network_endpoint_group_app_engine: Optional[NetworkEndpointGroupAppEngine] = Field(
        None, alias="NetworkEndpointGroupAppEngine"
    )
    bulk_insert_instance_resource: Optional[BulkInsertInstanceResource] = Field(
        None, alias="BulkInsertInstanceResource"
    )
    resource_policy_group_placement_policy: Optional[ResourcePolicyGroupPlacementPolicy] = Field(
        None, alias="ResourcePolicyGroupPlacementPolicy"
    )
    target_http_proxies_scoped_list: Optional[TargetHttpProxiesScopedList] = Field(
        None, alias="TargetHttpProxiesScopedList"
    )
    public_delegated_prefix_aggregated_list: Optional[PublicDelegatedPrefixAggregatedList] = Field(
        None, alias="PublicDelegatedPrefixAggregatedList"
    )
    target_https_proxy_list: Optional[TargetHttpsProxyList] = Field(
        None, alias="TargetHttpsProxyList"
    )
    global_set_policy_request: Optional[GlobalSetPolicyRequest] = Field(
        None, alias="GlobalSetPolicyRequest"
    )
    instances_add_resource_policies_request: Optional[InstancesAddResourcePoliciesRequest] = Field(
        None, alias="InstancesAddResourcePoliciesRequest"
    )
    network_endpoint_groups_scoped_list: Optional[NetworkEndpointGroupsScopedList] = Field(
        None, alias="NetworkEndpointGroupsScopedList"
    )
    network_endpoint: Optional[NetworkEndpoint] = Field(None, alias="NetworkEndpoint")
    fixed_or_percent: Optional[FixedOrPercent] = Field(None, alias="FixedOrPercent")
    subnetwork_log_config: Optional[SubnetworkLogConfig] = Field(None, alias="SubnetworkLogConfig")
    forwarding_rule_aggregated_list: Optional[ForwardingRuleAggregatedList] = Field(
        None, alias="ForwardingRuleAggregatedList"
    )
    backend_service_cdn_policy: Optional[BackendServiceCdnPolicy] = Field(
        None, alias="BackendServiceCdnPolicy"
    )
    network_endpoint_group_cloud_run: Optional[NetworkEndpointGroupCloudRun] = Field(
        None, alias="NetworkEndpointGroupCloudRun"
    )
    target_tcp_proxies_set_backend_service_request: Optional[
        TargetTcpProxiesSetBackendServiceRequest
    ] = Field(None, alias="TargetTcpProxiesSetBackendServiceRequest")
    subnetwork: Optional[Subnetwork] = Field(None, alias="Subnetwork")
    forwarding_rule_list: Optional[ForwardingRuleList] = Field(None, alias="ForwardingRuleList")
    managed_instance: Optional[ManagedInstance] = Field(None, alias="ManagedInstance")
    network_list: Optional[NetworkList] = Field(None, alias="NetworkList")
    http_route_rule: Optional[HttpRouteRule] = Field(None, alias="HttpRouteRule")
    router_aggregated_list: Optional[RouterAggregatedList] = Field(
        None, alias="RouterAggregatedList"
    )
    instance_group_manager_actions_summary: Optional[InstanceGroupManagerActionsSummary] = Field(
        None, alias="InstanceGroupManagerActionsSummary"
    )
    node_groups_list_nodes: Optional[NodeGroupsListNodes] = Field(None, alias="NodeGroupsListNodes")
    autoscaling_policy_scale_in_control: Optional[AutoscalingPolicyScaleInControl] = Field(
        None, alias="AutoscalingPolicyScaleInControl"
    )
    address_aggregated_list: Optional[AddressAggregatedList] = Field(
        None, alias="AddressAggregatedList"
    )
    resource_commitment: Optional[ResourceCommitment] = Field(None, alias="ResourceCommitment")
    instance_managed_by_igm_error: Optional[InstanceManagedByIgmError] = Field(
        None, alias="InstanceManagedByIgmError"
    )
    target_vpn_gateway_aggregated_list: Optional[TargetVpnGatewayAggregatedList] = Field(
        None, alias="TargetVpnGatewayAggregatedList"
    )
    packet_mirroring_filter: Optional[PacketMirroringFilter] = Field(
        None, alias="PacketMirroringFilter"
    )
    notification_endpoint: Optional[NotificationEndpoint] = Field(
        None, alias="NotificationEndpoint"
    )
    license_code_license_alias: Optional[LicenseCodeLicenseAlias] = Field(
        None, alias="LicenseCodeLicenseAlias"
    )
    node_template_list: Optional[NodeTemplateList] = Field(None, alias="NodeTemplateList")
    instance_group_manager_aggregated_list: Optional[InstanceGroupManagerAggregatedList] = Field(
        None, alias="InstanceGroupManagerAggregatedList"
    )
    region_instance_group_manager_delete_instance_config_req: Optional[
        RegionInstanceGroupManagerDeleteInstanceConfigReq
    ] = Field(None, alias="RegionInstanceGroupManagerDeleteInstanceConfigReq")
    test_permissions_response: Optional[TestPermissionsResponse] = Field(
        None, alias="TestPermissionsResponse"
    )
    location_policy_location: Optional[LocationPolicyLocation] = Field(
        None, alias="LocationPolicyLocation"
    )
    deprecation_status: Optional[DeprecationStatus] = Field(None, alias="DeprecationStatus")
    log_config_data_access_options: Optional[LogConfigDataAccessOptions] = Field(
        None, alias="LogConfigDataAccessOptions"
    )
    outlier_detection: Optional[OutlierDetection] = Field(None, alias="OutlierDetection")
    region_instance_groups_list_instances_request: Optional[
        RegionInstanceGroupsListInstancesRequest
    ] = Field(None, alias="RegionInstanceGroupsListInstancesRequest")
    server_binding: Optional[ServerBinding] = Field(None, alias="ServerBinding")
    health_checks_aggregated_list: Optional[HealthChecksAggregatedList] = Field(
        None, alias="HealthChecksAggregatedList"
    )
    interconnects_get_diagnostics_response: Optional[InterconnectsGetDiagnosticsResponse] = Field(
        None, alias="InterconnectsGetDiagnosticsResponse"
    )
    subsetting: Optional[Subsetting] = Field(None, alias="Subsetting")
    region_instance_group_managers_apply_updates_request: Optional[
        RegionInstanceGroupManagersApplyUpdatesRequest
    ] = Field(None, alias="RegionInstanceGroupManagersApplyUpdatesRequest")
    screenshot: Optional[Screenshot] = Field(None, alias="Screenshot")
    route_as_path: Optional[RouteAsPath] = Field(None, alias="RouteAsPath")
    vpn_gateways_scoped_list: Optional[VpnGatewaysScopedList] = Field(
        None, alias="VpnGatewaysScopedList"
    )
    resource_policy_weekly_cycle_day_of_week: Optional[ResourcePolicyWeeklyCycleDayOfWeek] = Field(
        None, alias="ResourcePolicyWeeklyCycleDayOfWeek"
    )
    usage_export_location: Optional[UsageExportLocation] = Field(None, alias="UsageExportLocation")
    resource_policy_aggregated_list: Optional[ResourcePolicyAggregatedList] = Field(
        None, alias="ResourcePolicyAggregatedList"
    )
    network_peering: Optional[NetworkPeering] = Field(None, alias="NetworkPeering")
    firewall_policy_list: Optional[FirewallPolicyList] = Field(None, alias="FirewallPolicyList")
    subnetwork_aggregated_list: Optional[SubnetworkAggregatedList] = Field(
        None, alias="SubnetworkAggregatedList"
    )
    packet_mirroring: Optional[PacketMirroring] = Field(None, alias="PacketMirroring")
    bfd_packet: Optional[BfdPacket] = Field(None, alias="BfdPacket")
    ssl_policy: Optional[SslPolicy] = Field(None, alias="SslPolicy")
    resource_policy_snapshot_schedule_policy_snapshot_properties: Optional[
        ResourcePolicySnapshotSchedulePolicySnapshotProperties
    ] = Field(None, alias="ResourcePolicySnapshotSchedulePolicySnapshotProperties")
    autoscaler_list: Optional[AutoscalerList] = Field(None, alias="AutoscalerList")
    region_set_policy_request: Optional[RegionSetPolicyRequest] = Field(
        None, alias="RegionSetPolicyRequest"
    )
    target_pools_scoped_list: Optional[TargetPoolsScopedList] = Field(
        None, alias="TargetPoolsScopedList"
    )
    autoscalers_scoped_list: Optional[AutoscalersScopedList] = Field(
        None, alias="AutoscalersScopedList"
    )
    http_header_match: Optional[HttpHeaderMatch] = Field(None, alias="HttpHeaderMatch")
    resource_policy: Optional[ResourcePolicy] = Field(None, alias="ResourcePolicy")
    attached_disk: Optional[AttachedDisk] = Field(None, alias="AttachedDisk")
    interconnect_attachment_private_info: Optional[InterconnectAttachmentPrivateInfo] = Field(
        None, alias="InterconnectAttachmentPrivateInfo"
    )
    vm_endpoint_nat_mappings_interface_nat_mappings: Optional[
        VmEndpointNatMappingsInterfaceNatMappings
    ] = Field(None, alias="VmEndpointNatMappingsInterfaceNatMappings")
    router: Optional[Router] = Field(None, alias="Router")
    url_map_validation_result: Optional[UrlMapValidationResult] = Field(
        None, alias="UrlMapValidationResult"
    )
    external_vpn_gateway_list: Optional[ExternalVpnGatewayList] = Field(
        None, alias="ExternalVpnGatewayList"
    )
    target_pools_add_instance_request: Optional[TargetPoolsAddInstanceRequest] = Field(
        None, alias="TargetPoolsAddInstanceRequest"
    )
    region_set_labels_request: Optional[RegionSetLabelsRequest] = Field(
        None, alias="RegionSetLabelsRequest"
    )
    source_disk_encryption_key: Optional[SourceDiskEncryptionKey] = Field(
        None, alias="SourceDiskEncryptionKey"
    )
    instance: Optional[Instance] = Field(None, alias="Instance")
    networks_update_peering_request: Optional[NetworksUpdatePeeringRequest] = Field(
        None, alias="NetworksUpdatePeeringRequest"
    )
    local_disk: Optional[LocalDisk] = Field(None, alias="LocalDisk")
    accelerator_types_scoped_list: Optional[AcceleratorTypesScopedList] = Field(
        None, alias="AcceleratorTypesScopedList"
    )
    target_https_proxies_set_quic_override_request: Optional[
        TargetHttpsProxiesSetQuicOverrideRequest
    ] = Field(None, alias="TargetHttpsProxiesSetQuicOverrideRequest")
    named_port: Optional[NamedPort] = Field(None, alias="NamedPort")
    network_edge_security_service_aggregated_list: Optional[
        NetworkEdgeSecurityServiceAggregatedList
    ] = Field(None, alias="NetworkEdgeSecurityServiceAggregatedList")
    service_attachment: Optional[ServiceAttachment] = Field(None, alias="ServiceAttachment")
    http_route_action: Optional[HttpRouteAction] = Field(None, alias="HttpRouteAction")
    cache_invalidation_rule: Optional[CacheInvalidationRule] = Field(
        None, alias="CacheInvalidationRule"
    )
    route_list: Optional[RouteList] = Field(None, alias="RouteList")
    backend_service_log_config: Optional[BackendServiceLogConfig] = Field(
        None, alias="BackendServiceLogConfig"
    )
    target_pool_instance_health: Optional[TargetPoolInstanceHealth] = Field(
        None, alias="TargetPoolInstanceHealth"
    )
    backend_service_reference: Optional[BackendServiceReference] = Field(
        None, alias="BackendServiceReference"
    )
    image: Optional[Image] = Field(None, alias="Image")
    network_performance_config: Optional[NetworkPerformanceConfig] = Field(
        None, alias="NetworkPerformanceConfig"
    )
    target_pools_remove_instance_request: Optional[TargetPoolsRemoveInstanceRequest] = Field(
        None, alias="TargetPoolsRemoveInstanceRequest"
    )
    health_check_list: Optional[HealthCheckList] = Field(None, alias="HealthCheckList")
    https_health_check: Optional[HttpsHealthCheck1] = Field(None, alias="HTTPSHealthCheck")
    instances_get_effective_firewalls_response: Optional[
        InstancesGetEffectiveFirewallsResponse
    ] = Field(None, alias="InstancesGetEffectiveFirewallsResponse")
    instances_start_with_encryption_key_request: Optional[
        InstancesStartWithEncryptionKeyRequest
    ] = Field(None, alias="InstancesStartWithEncryptionKeyRequest")
    networks_get_effective_firewalls_response: Optional[
        NetworksGetEffectiveFirewallsResponse
    ] = Field(None, alias="NetworksGetEffectiveFirewallsResponse")
    url_map: Optional[UrlMap] = Field(None, alias="UrlMap")
    http_fault_delay: Optional[HttpFaultDelay] = Field(None, alias="HttpFaultDelay")
    instance_group_managers_list_per_instance_configs_resp: Optional[
        InstanceGroupManagersListPerInstanceConfigsResp
    ] = Field(None, alias="InstanceGroupManagersListPerInstanceConfigsResp")
    router_status_response: Optional[RouterStatusResponse] = Field(
        None, alias="RouterStatusResponse"
    )
    instance_groups_list_instances: Optional[InstanceGroupsListInstances] = Field(
        None, alias="InstanceGroupsListInstances"
    )
    node_group_node: Optional[NodeGroupNode] = Field(None, alias="NodeGroupNode")
    firewall_policy_rule_matcher: Optional[FirewallPolicyRuleMatcher] = Field(
        None, alias="FirewallPolicyRuleMatcher"
    )
    region_list: Optional[RegionList] = Field(None, alias="RegionList")
    security_policies_list_preconfigured_expression_sets_response: Optional[
        SecurityPoliciesListPreconfiguredExpressionSetsResponse
    ] = Field(None, alias="SecurityPoliciesListPreconfiguredExpressionSetsResponse")
    preserved_state: Optional[PreservedState] = Field(None, alias="PreservedState")
    instance_group_managers_list_managed_instances_response: Optional[
        InstanceGroupManagersListManagedInstancesResponse
    ] = Field(None, alias="InstanceGroupManagersListManagedInstancesResponse")
    node_group: Optional[NodeGroup] = Field(None, alias="NodeGroup")
    node_template: Optional[NodeTemplate] = Field(None, alias="NodeTemplate")
    managed_instance_instance_health: Optional[ManagedInstanceInstanceHealth] = Field(
        None, alias="ManagedInstanceInstanceHealth"
    )
    security_policy_rule_redirect_options: Optional[SecurityPolicyRuleRedirectOptions] = Field(
        None, alias="SecurityPolicyRuleRedirectOptions"
    )
    resource_policy_hourly_cycle: Optional[ResourcePolicyHourlyCycle] = Field(
        None, alias="ResourcePolicyHourlyCycle"
    )
    instance_group_managers_patch_per_instance_configs_req: Optional[
        InstanceGroupManagersPatchPerInstanceConfigsReq
    ] = Field(None, alias="InstanceGroupManagersPatchPerInstanceConfigsReq")
    interconnect_diagnostics_arp_entry: Optional[InterconnectDiagnosticsArpEntry] = Field(
        None, alias="InterconnectDiagnosticsARPEntry"
    )
    resource_policy_instance_schedule_policy: Optional[
        ResourcePolicyInstanceSchedulePolicy
    ] = Field(None, alias="ResourcePolicyInstanceSchedulePolicy")
    packet_mirroring_mirrored_resource_info: Optional[PacketMirroringMirroredResourceInfo] = Field(
        None, alias="PacketMirroringMirroredResourceInfo"
    )
    instance_groups_list_instances_request: Optional[InstanceGroupsListInstancesRequest] = Field(
        None, alias="InstanceGroupsListInstancesRequest"
    )
    instance_group_manager_status_version_target: Optional[
        InstanceGroupManagerStatusVersionTarget
    ] = Field(None, alias="InstanceGroupManagerStatusVersionTarget")
    customer_encryption_key: Optional[CustomerEncryptionKey] = Field(
        None, alias="CustomerEncryptionKey"
    )
    xpn_resource_id: Optional[XpnResourceId] = Field(None, alias="XpnResourceId")
    security_policy_ddos_protection_config: Optional[SecurityPolicyDdosProtectionConfig] = Field(
        None, alias="SecurityPolicyDdosProtectionConfig"
    )
    vpn_tunnels_scoped_list: Optional[VpnTunnelsScopedList] = Field(
        None, alias="VpnTunnelsScopedList"
    )
    guest_os_feature: Optional[GuestOsFeature] = Field(None, alias="GuestOsFeature")
    saved_attached_disk: Optional[SavedAttachedDisk] = Field(None, alias="SavedAttachedDisk")
    region_instance_group_managers_set_template_request: Optional[
        RegionInstanceGroupManagersSetTemplateRequest
    ] = Field(None, alias="RegionInstanceGroupManagersSetTemplateRequest")
    saved_disk: Optional[SavedDisk] = Field(None, alias="SavedDisk")
    instances_set_machine_type_request: Optional[InstancesSetMachineTypeRequest] = Field(
        None, alias="InstancesSetMachineTypeRequest"
    )
    disks_scoped_list: Optional[DisksScopedList] = Field(None, alias="DisksScopedList")
    subnetworks_scoped_list: Optional[SubnetworksScopedList] = Field(
        None, alias="SubnetworksScopedList"
    )
    guest_attributes_value: Optional[GuestAttributesValue] = Field(
        None, alias="GuestAttributesValue"
    )
    instance_group_manager_status_stateful: Optional[InstanceGroupManagerStatusStateful] = Field(
        None, alias="InstanceGroupManagerStatusStateful"
    )
    target_vpn_gateway: Optional[TargetVpnGateway] = Field(None, alias="TargetVpnGateway")
    autoscaling_policy_custom_metric_utilization: Optional[
        AutoscalingPolicyCustomMetricUtilization
    ] = Field(None, alias="AutoscalingPolicyCustomMetricUtilization")
    network_edge_security_service: Optional[NetworkEdgeSecurityService] = Field(
        None, alias="NetworkEdgeSecurityService"
    )
    networks_get_effective_firewalls_response_effective_firewall_policy: Optional[
        NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy
    ] = Field(None, alias="NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy")
    host_rule: Optional[HostRule] = Field(None, alias="HostRule")
    packet_mirrorings_scoped_list: Optional[PacketMirroringsScopedList] = Field(
        None, alias="PacketMirroringsScopedList"
    )
    ssl_policy_reference: Optional[SslPolicyReference] = Field(None, alias="SslPolicyReference")
    resource_policy_weekly_cycle: Optional[ResourcePolicyWeeklyCycle] = Field(
        None, alias="ResourcePolicyWeeklyCycle"
    )
    forwarding_rules_scoped_list: Optional[ForwardingRulesScopedList] = Field(
        None, alias="ForwardingRulesScopedList"
    )
    instance_group_manager_list: Optional[InstanceGroupManagerList] = Field(
        None, alias="InstanceGroupManagerList"
    )
    operations_scoped_list: Optional[OperationsScopedList] = Field(
        None, alias="OperationsScopedList"
    )
    disks_add_resource_policies_request: Optional[DisksAddResourcePoliciesRequest] = Field(
        None, alias="DisksAddResourcePoliciesRequest"
    )
    region_instance_group_managers_list_instances_response: Optional[
        RegionInstanceGroupManagersListInstancesResponse
    ] = Field(None, alias="RegionInstanceGroupManagersListInstancesResponse")
    interconnect_location_list: Optional[InterconnectLocationList] = Field(
        None, alias="InterconnectLocationList"
    )
    node_templates_scoped_list: Optional[NodeTemplatesScopedList] = Field(
        None, alias="NodeTemplatesScopedList"
    )
    http_header_action: Optional[HttpHeaderAction] = Field(None, alias="HttpHeaderAction")
    resource_policy_resource_status: Optional[ResourcePolicyResourceStatus] = Field(
        None, alias="ResourcePolicyResourceStatus"
    )
    ssl_certificate_self_managed_ssl_certificate: Optional[
        SslCertificateSelfManagedSslCertificate
    ] = Field(None, alias="SslCertificateSelfManagedSslCertificate")
    public_delegated_prefixes_scoped_list: Optional[PublicDelegatedPrefixesScopedList] = Field(
        None, alias="PublicDelegatedPrefixesScopedList"
    )
    shielded_instance_config: Optional[ShieldedInstanceConfig] = Field(
        None, alias="ShieldedInstanceConfig"
    )
    target_pool: Optional[TargetPool] = Field(None, alias="TargetPool")
    uint128: Optional[Uint128] = Field(None, alias="Uint128")
    target_https_proxies_scoped_list: Optional[TargetHttpsProxiesScopedList] = Field(
        None, alias="TargetHttpsProxiesScopedList"
    )
    security_policy_rule_http_header_action: Optional[SecurityPolicyRuleHttpHeaderAction] = Field(
        None, alias="SecurityPolicyRuleHttpHeaderAction"
    )
    instances_set_min_cpu_platform_request: Optional[InstancesSetMinCpuPlatformRequest] = Field(
        None, alias="InstancesSetMinCpuPlatformRequest"
    )
    interconnect_diagnostics_link_lacp_status: Optional[
        InterconnectDiagnosticsLinkLacpStatus
    ] = Field(None, alias="InterconnectDiagnosticsLinkLACPStatus")
    firewall_list: Optional[FirewallList] = Field(None, alias="FirewallList")
    target_http_proxy_aggregated_list: Optional[TargetHttpProxyAggregatedList] = Field(
        None, alias="TargetHttpProxyAggregatedList"
    )
    instances_get_effective_firewalls_response_effective_firewall_policy: Optional[
        InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy
    ] = Field(None, alias="InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy")
    resource_policy_snapshot_schedule_policy_retention_policy: Optional[
        ResourcePolicySnapshotSchedulePolicyRetentionPolicy
    ] = Field(None, alias="ResourcePolicySnapshotSchedulePolicyRetentionPolicy")
    backend_service_cdn_policy_negative_caching_policy: Optional[
        BackendServiceCdnPolicyNegativeCachingPolicy
    ] = Field(None, alias="BackendServiceCdnPolicyNegativeCachingPolicy")
    public_advertised_prefix: Optional[PublicAdvertisedPrefix] = Field(
        None, alias="PublicAdvertisedPrefix"
    )
    region_network_firewall_policies_get_effective_firewalls_response: Optional[
        RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse
    ] = Field(None, alias="RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse")
    disk_type: Optional[DiskType] = Field(None, alias="DiskType")
    packet_mirroring_network_info: Optional[PacketMirroringNetworkInfo] = Field(
        None, alias="PacketMirroringNetworkInfo"
    )
    ssl_certificates_scoped_list: Optional[SslCertificatesScopedList] = Field(
        None, alias="SslCertificatesScopedList"
    )
    http_health_check: Optional[HttpHealthCheck] = Field(None, alias="HTTPHealthCheck")
    instance_with_named_ports: Optional[InstanceWithNamedPorts] = Field(
        None, alias="InstanceWithNamedPorts"
    )
    network_endpoint_with_health_status: Optional[NetworkEndpointWithHealthStatus] = Field(
        None, alias="NetworkEndpointWithHealthStatus"
    )
    vpn_gateway_list: Optional[VpnGatewayList] = Field(None, alias="VpnGatewayList")
    security_policy_rule_matcher_config: Optional[SecurityPolicyRuleMatcherConfig] = Field(
        None, alias="SecurityPolicyRuleMatcherConfig"
    )
    backend_service_connection_tracking_policy: Optional[
        BackendServiceConnectionTrackingPolicy
    ] = Field(None, alias="BackendServiceConnectionTrackingPolicy")
    instance_group_manager_version: Optional[InstanceGroupManagerVersion] = Field(
        None, alias="InstanceGroupManagerVersion"
    )
    security_policy_list: Optional[SecurityPolicyList] = Field(None, alias="SecurityPolicyList")
    allocation_specific_sku_allocation_allocated_instance_properties_reserved_disk: Optional[
        AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk
    ] = Field(
        None,
        alias="AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    )
    instance_group_managers_apply_updates_request: Optional[
        InstanceGroupManagersApplyUpdatesRequest
    ] = Field(None, alias="InstanceGroupManagersApplyUpdatesRequest")
    target_pool_list: Optional[TargetPoolList] = Field(None, alias="TargetPoolList")
    backend_bucket_cdn_policy_cache_key_policy: Optional[
        BackendBucketCdnPolicyCacheKeyPolicy
    ] = Field(None, alias="BackendBucketCdnPolicyCacheKeyPolicy")
    initial_state_config: Optional[InitialStateConfig] = Field(None, alias="InitialStateConfig")
    security_policy_recaptcha_options_config: Optional[
        SecurityPolicyRecaptchaOptionsConfig
    ] = Field(None, alias="SecurityPolicyRecaptchaOptionsConfig")
    router_list: Optional[RouterList] = Field(None, alias="RouterList")
    backend_service_list: Optional[BackendServiceList] = Field(None, alias="BackendServiceList")
    log_config_cloud_audit_options: Optional[LogConfigCloudAuditOptions] = Field(
        None, alias="LogConfigCloudAuditOptions"
    )
    test_permissions_request: Optional[TestPermissionsRequest] = Field(
        None, alias="TestPermissionsRequest"
    )
    source_instance_params: Optional[SourceInstanceParams] = Field(
        None, alias="SourceInstanceParams"
    )
    metadata_filter: Optional[MetadataFilter] = Field(None, alias="MetadataFilter")
    subnetwork_list: Optional[SubnetworkList] = Field(None, alias="SubnetworkList")
    instance_move_request: Optional[InstanceMoveRequest] = Field(None, alias="InstanceMoveRequest")
    instance_group_manager_update_policy: Optional[InstanceGroupManagerUpdatePolicy] = Field(
        None, alias="InstanceGroupManagerUpdatePolicy"
    )
    url_map_test: Optional[UrlMapTest] = Field(None, alias="UrlMapTest")
    routers_scoped_list: Optional[RoutersScopedList] = Field(None, alias="RoutersScopedList")
    packet_mirroring_forwarding_rule_info: Optional[PacketMirroringForwardingRuleInfo] = Field(
        None, alias="PacketMirroringForwardingRuleInfo"
    )
    vpn_gateway_vpn_gateway_interface: Optional[VpnGatewayVpnGatewayInterface] = Field(
        None, alias="VpnGatewayVpnGatewayInterface"
    )
    instance_group_managers_update_per_instance_configs_req: Optional[
        InstanceGroupManagersUpdatePerInstanceConfigsReq
    ] = Field(None, alias="InstanceGroupManagersUpdatePerInstanceConfigsReq")
    accelerator_type: Optional[AcceleratorType] = Field(None, alias="AcceleratorType")
    ssl_policies_list: Optional[SslPoliciesList] = Field(None, alias="SslPoliciesList")
    instance_template_list: Optional[InstanceTemplateList] = Field(
        None, alias="InstanceTemplateList"
    )
    authorization_logging_options: Optional[AuthorizationLoggingOptions] = Field(
        None, alias="AuthorizationLoggingOptions"
    )
    instance_groups_remove_instances_request: Optional[
        InstanceGroupsRemoveInstancesRequest
    ] = Field(None, alias="InstanceGroupsRemoveInstancesRequest")
    consistent_hash_load_balancer_settings: Optional[ConsistentHashLoadBalancerSettings] = Field(
        None, alias="ConsistentHashLoadBalancerSettings"
    )
    log_config: Optional[LogConfig] = Field(None, alias="LogConfig")
    backend_services_scoped_list: Optional[BackendServicesScopedList] = Field(
        None, alias="BackendServicesScopedList"
    )
    target_instance_list: Optional[TargetInstanceList] = Field(None, alias="TargetInstanceList")
    subnetwork_secondary_range: Optional[SubnetworkSecondaryRange] = Field(
        None, alias="SubnetworkSecondaryRange"
    )
    interconnect_list: Optional[InterconnectList] = Field(None, alias="InterconnectList")
    zone_set_policy_request: Optional[ZoneSetPolicyRequest] = Field(
        None, alias="ZoneSetPolicyRequest"
    )
    forwarding_rule_service_directory_registration: Optional[
        ForwardingRuleServiceDirectoryRegistration
    ] = Field(None, alias="ForwardingRuleServiceDirectoryRegistration")
    region_instance_group_managers_list_instance_configs_resp: Optional[
        RegionInstanceGroupManagersListInstanceConfigsResp
    ] = Field(None, alias="RegionInstanceGroupManagersListInstanceConfigsResp")
    image_list: Optional[ImageList] = Field(None, alias="ImageList")
    preconfigured_waf_set: Optional[PreconfiguredWafSet] = Field(None, alias="PreconfiguredWafSet")
    service_account: Optional[ServiceAccount] = Field(None, alias="ServiceAccount")
    scheduling_node_affinity: Optional[SchedulingNodeAffinity] = Field(
        None, alias="SchedulingNodeAffinity"
    )
    zone: Optional[Zone] = Field(None, alias="Zone")
    zone_set_labels_request: Optional[ZoneSetLabelsRequest] = Field(
        None, alias="ZoneSetLabelsRequest"
    )
    region_instance_group_manager_patch_instance_config_req: Optional[
        RegionInstanceGroupManagerPatchInstanceConfigReq
    ] = Field(None, alias="RegionInstanceGroupManagerPatchInstanceConfigReq")
    service_attachment_consumer_project_limit: Optional[
        ServiceAttachmentConsumerProjectLimit
    ] = Field(None, alias="ServiceAttachmentConsumerProjectLimit")
    service_attachment_list: Optional[ServiceAttachmentList] = Field(
        None, alias="ServiceAttachmentList"
    )
    network_endpoint_group_aggregated_list: Optional[NetworkEndpointGroupAggregatedList] = Field(
        None, alias="NetworkEndpointGroupAggregatedList"
    )
    ssl_certificate_list: Optional[SslCertificateList] = Field(None, alias="SslCertificateList")
    router_bgp_peer_bfd: Optional[RouterBgpPeerBfd] = Field(None, alias="RouterBgpPeerBfd")
    target_pool_aggregated_list: Optional[TargetPoolAggregatedList] = Field(
        None, alias="TargetPoolAggregatedList"
    )
    consistent_hash_load_balancer_settings_http_cookie: Optional[
        ConsistentHashLoadBalancerSettingsHttpCookie
    ] = Field(None, alias="ConsistentHashLoadBalancerSettingsHttpCookie")
    interconnect_attachment_aggregated_list: Optional[InterconnectAttachmentAggregatedList] = Field(
        None, alias="InterconnectAttachmentAggregatedList"
    )
    node_group_maintenance_window: Optional[NodeGroupMaintenanceWindow] = Field(
        None, alias="NodeGroupMaintenanceWindow"
    )
    commitment: Optional[Commitment] = Field(None, alias="Commitment")
    packet_mirroring_mirrored_resource_info_instance_info: Optional[
        PacketMirroringMirroredResourceInfoInstanceInfo
    ] = Field(None, alias="PacketMirroringMirroredResourceInfoInstanceInfo")
    instances_remove_resource_policies_request: Optional[
        InstancesRemoveResourcePoliciesRequest
    ] = Field(None, alias="InstancesRemoveResourcePoliciesRequest")
    firewall_policy_association: Optional[FirewallPolicyAssociation] = Field(
        None, alias="FirewallPolicyAssociation"
    )
    network_endpoint_group_list: Optional[NetworkEndpointGroupList] = Field(
        None, alias="NetworkEndpointGroupList"
    )
    http_retry_policy: Optional[HttpRetryPolicy] = Field(None, alias="HttpRetryPolicy")
    commitment_list: Optional[CommitmentList] = Field(None, alias="Commitment