"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api description.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    OrgsOrgPatchBodyType,
    OrgsOrgHooksPostBodyType,
    OrgsOrgInvitationsPostBodyType,
    OrgsOrgHooksHookIdPatchBodyType,
    OrgsOrgHooksPostBodyPropConfigType,
    UserMembershipsOrgsOrgPatchBodyType,
    OrgsOrgHooksHookIdConfigPatchBodyType,
    OrgsOrgMembershipsUsernamePutBodyType,
    OrgsOrgHooksHookIdPatchBodyPropConfigType,
    OrgsOrgOutsideCollaboratorsUsernamePutBodyType,
)
from .models import (
    Team,
    OrgHook,
    BasicError,
    SimpleUser,
    TeamSimple,
    HookDelivery,
    OrgMembership,
    WebhookConfig,
    ValidationError,
    HookDeliveryItem,
    OrganizationFull,
    OrgsOrgPatchBody,
    OrganizationSimple,
    OrgsOrgHooksPostBody,
    ValidationErrorSimple,
    OrganizationInvitation,
    OrgsOrgInvitationsPostBody,
    OrgsOrgHooksHookIdPatchBody,
    UserMembershipsOrgsOrgPatchBody,
    OrgsOrgHooksHookIdConfigPatchBody,
    OrgsOrgMembershipsUsernamePutBody,
    OrgsOrgInstallationsGetResponse200,
    OrgsOrgOutsideCollaboratorsUsernamePutBody,
    OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class OrgsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        since: Union[Unset, int] = UNSET,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationSimple],
        )

    async def async_list(
        self,
        since: Union[Unset, int] = UNSET,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationSimple],
        )

    def get(
        self,
        org: str,
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        return self._github.request(
            "GET",
            url,
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        org: str,
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update(
        self, org: str, *, data: Union[Unset, OrgsOrgPatchBodyType] = UNSET
    ) -> "Response[OrganizationFull]":
        ...

    @overload
    def update(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        billing_email: Union[Unset, str] = UNSET,
        company: Union[Unset, str] = UNSET,
        email: Union[Unset, str] = UNSET,
        twitter_username: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        has_organization_projects: Union[Unset, bool] = UNSET,
        has_repository_projects: Union[Unset, bool] = UNSET,
        default_repository_permission: Union[
            Unset, Literal["read", "write", "admin", "none"]
        ] = "read",
        members_can_create_repositories: Union[Unset, bool] = True,
        members_can_create_internal_repositories: Union[Unset, bool] = UNSET,
        members_can_create_private_repositories: Union[Unset, bool] = UNSET,
        members_can_create_public_repositories: Union[Unset, bool] = UNSET,
        members_allowed_repository_creation_type: Union[
            Unset, Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Union[Unset, bool] = True,
        members_can_create_public_pages: Union[Unset, bool] = True,
        members_can_create_private_pages: Union[Unset, bool] = True,
        members_can_fork_private_repositories: Union[Unset, bool] = False,
        web_commit_signoff_required: Union[Unset, bool] = False,
        blog: Union[Unset, str] = UNSET,
        advanced_security_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Union[
            Unset, bool
        ] = UNSET,
        dependency_graph_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Union[
            Unset, bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Union[Unset, bool] = UNSET,
        secret_scanning_push_protection_custom_link: Union[Unset, str] = UNSET,
    ) -> "Response[OrganizationFull]":
        ...

    def update(
        self, org: str, *, data: Union[Unset, OrgsOrgPatchBodyType] = UNSET, **kwargs
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    @overload
    async def async_update(
        self, org: str, *, data: Union[Unset, OrgsOrgPatchBodyType] = UNSET
    ) -> "Response[OrganizationFull]":
        ...

    @overload
    async def async_update(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        billing_email: Union[Unset, str] = UNSET,
        company: Union[Unset, str] = UNSET,
        email: Union[Unset, str] = UNSET,
        twitter_username: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        has_organization_projects: Union[Unset, bool] = UNSET,
        has_repository_projects: Union[Unset, bool] = UNSET,
        default_repository_permission: Union[
            Unset, Literal["read", "write", "admin", "none"]
        ] = "read",
        members_can_create_repositories: Union[Unset, bool] = True,
        members_can_create_internal_repositories: Union[Unset, bool] = UNSET,
        members_can_create_private_repositories: Union[Unset, bool] = UNSET,
        members_can_create_public_repositories: Union[Unset, bool] = UNSET,
        members_allowed_repository_creation_type: Union[
            Unset, Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Union[Unset, bool] = True,
        members_can_create_public_pages: Union[Unset, bool] = True,
        members_can_create_private_pages: Union[Unset, bool] = True,
        members_can_fork_private_repositories: Union[Unset, bool] = False,
        web_commit_signoff_required: Union[Unset, bool] = False,
        blog: Union[Unset, str] = UNSET,
        advanced_security_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Union[
            Unset, bool
        ] = UNSET,
        dependency_graph_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Union[Unset, bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Union[
            Unset, bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Union[Unset, bool] = UNSET,
        secret_scanning_push_protection_custom_link: Union[Unset, str] = UNSET,
    ) -> "Response[OrganizationFull]":
        ...

    async def async_update(
        self, org: str, *, data: Union[Unset, OrgsOrgPatchBodyType] = UNSET, **kwargs
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    def list_blocked_users(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_blocked_users(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def check_blocked_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_blocked_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def block_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_block_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "422": ValidationError,
            },
        )

    def unblock_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_unblock_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_failed_invitations(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_failed_invitations(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrgHook]]":
        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrgHook]]":
        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self, org: str, *, data: OrgsOrgHooksPostBodyType
    ) -> "Response[OrgHook]":
        ...

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Union[Unset, List[str]] = ["push"],
        active: Union[Unset, bool] = True,
    ) -> "Response[OrgHook]":
        ...

    def create_webhook(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self, org: str, *, data: OrgsOrgHooksPostBodyType
    ) -> "Response[OrgHook]":
        ...

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Union[Unset, List[str]] = ["push"],
        active: Union[Unset, bool] = True,
    ) -> "Response[OrgHook]":
        ...

    async def async_create_webhook(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        return self._github.request(
            "GET",
            url,
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        config: Union[Unset, OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        active: Union[Unset, bool] = True,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        config: Union[Unset, OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        active: Union[Unset, bool] = True,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        return self._github.request(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Union[Unset, OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
        redelivery: Union[Unset, bool] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
        redelivery: Union[Unset, bool] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        return self._github.request(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        return self._github.request(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        return self._github.request(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        return await self._github.arequest(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_app_installations(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgInstallationsGetResponse200]":
        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    async def async_list_app_installations(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgInstallationsGetResponse200]":
        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    def list_pending_invitations(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        role: Union[
            Unset,
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ],
        ] = "all",
        invitation_source: Union[Unset, Literal["all", "member", "scim"]] = "all",
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_pending_invitations(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        role: Union[
            Unset,
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ],
        ] = "all",
        invitation_source: Union[Unset, Literal["all", "member", "scim"]] = "all",
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_invitation(
        self, org: str, *, data: Union[Unset, OrgsOrgInvitationsPostBodyType] = UNSET
    ) -> "Response[OrganizationInvitation]":
        ...

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        invitee_id: Union[Unset, int] = UNSET,
        email: Union[Unset, str] = UNSET,
        role: Union[
            Unset, Literal["admin", "direct_member", "billing_manager"]
        ] = "direct_member",
        team_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[OrganizationInvitation]":
        ...

    def create_invitation(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrganizationInvitation]":
        url = f"/orgs/{org}/invitations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgInvitationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_invitation(
        self, org: str, *, data: Union[Unset, OrgsOrgInvitationsPostBodyType] = UNSET
    ) -> "Response[OrganizationInvitation]":
        ...

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        invitee_id: Union[Unset, int] = UNSET,
        email: Union[Unset, str] = UNSET,
        role: Union[
            Unset, Literal["admin", "direct_member", "billing_manager"]
        ] = "direct_member",
        team_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[OrganizationInvitation]":
        ...

    async def async_create_invitation(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrganizationInvitation]":
        url = f"/orgs/{org}/invitations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgInvitationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_invitation(
        self,
        org: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/invitations/{invitation_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_cancel_invitation(
        self,
        org: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/invitations/{invitation_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    def list_members(
        self,
        org: str,
        filter_: Union[Unset, Literal["2fa_disabled", "all"]] = "all",
        role: Union[Unset, Literal["all", "admin", "member"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_members(
        self,
        org: str,
        filter_: Union[Unset, Literal["2fa_disabled", "all"]] = "all",
        role: Union[Unset, Literal["all", "admin", "member"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def check_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def remove_member(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
            },
        )

    async def async_remove_member(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
            },
        )

    def get_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        return self._github.request(
            "GET",
            url,
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgMembership]":
        ...

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Unset = UNSET,
        role: Union[Unset, Literal["admin", "member"]] = "member",
    ) -> "Response[OrgMembership]":
        ...

    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgMembership]":
        ...

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Unset = UNSET,
        role: Union[Unset, Literal["admin", "member"]] = "member",
    ) -> "Response[OrgMembership]":
        ...

    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/memberships/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/memberships/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_outside_collaborators(
        self,
        org: str,
        filter_: Union[Unset, Literal["2fa_disabled", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_outside_collaborators(
        self,
        org: str,
        filter_: Union[Unset, Literal["2fa_disabled", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Unset = UNSET,
        async_: Union[Unset, bool] = False,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgOutsideCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Unset = UNSET,
        async_: Union[Unset, bool] = False,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Union[Unset, OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgOutsideCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    def remove_outside_collaborator(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    async def async_remove_outside_collaborator(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    def list_public_members(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_public_members(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def check_public_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_public_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "403": BasicError,
            },
        )

    async def async_set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "403": BasicError,
            },
        )

    def remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_security_manager_teams(
        self,
        org: str,
    ) -> "Response[List[TeamSimple]]":
        url = f"/orgs/{org}/security-managers"

        return self._github.request(
            "GET",
            url,
            response_model=List[TeamSimple],
        )

    async def async_list_security_manager_teams(
        self,
        org: str,
    ) -> "Response[List[TeamSimple]]":
        url = f"/orgs/{org}/security-managers"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[TeamSimple],
        )

    def add_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        return self._github.request(
            "PUT",
            url,
            error_models={},
        )

    async def async_add_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={},
        )

    def remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
    ) -> "Response":
        url = f"/orgs/{org}/{security_product}/{enablement}"

        return self._github.request(
            "POST",
            url,
            error_models={},
        )

    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
    ) -> "Response":
        url = f"/orgs/{org}/{security_product}/{enablement}"

        return await self._github.arequest(
            "POST",
            url,
            error_models={},
        )

    def list_memberships_for_authenticated_user(
        self,
        state: Union[Unset, Literal["active", "pending"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrgMembership]]":
        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_memberships_for_authenticated_user(
        self,
        state: Union[Unset, Literal["active", "pending"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrgMembership]]":
        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_membership_for_authenticated_user(
        self,
        org: str,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        return self._github.request(
            "GET",
            url,
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_membership_for_authenticated_user(
        self,
        org: str,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_membership_for_authenticated_user(
        self, org: str, *, data: UserMembershipsOrgsOrgPatchBodyType
    ) -> "Response[OrgMembership]":
        ...

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        state: Literal["active"],
    ) -> "Response[OrgMembership]":
        ...

    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Union[Unset, UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserMembershipsOrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_membership_for_authenticated_user(
        self, org: str, *, data: UserMembershipsOrgsOrgPatchBodyType
    ) -> "Response[OrgMembership]":
        ...

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        state: Literal["active"],
    ) -> "Response[OrgMembership]":
        ...

    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Union[Unset, UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserMembershipsOrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationSimple],
        )

    async def async_list_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationSimple],
        )
