"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api description.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    SelectedActionsType,
    OrgsOrgActionsVariablesPostBodyType,
    OrgsOrgActionsPermissionsPutBodyType,
    ActionsWorkflowAccessToRepositoryType,
    ActionsSetDefaultWorkflowPermissionsType,
    OrgsOrgActionsVariablesNamePatchBodyType,
    OrgsOrgActionsSecretsSecretNamePutBodyType,
    ReposOwnerRepoActionsVariablesPostBodyType,
    OrgsOrgActionsRequiredWorkflowsPostBodyType,
    ReposOwnerRepoActionsPermissionsPutBodyType,
    OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ReposOwnerRepoActionsJobsJobIdRerunPostBodyType,
    ReposOwnerRepoActionsRunsRunIdRerunPostBodyType,
    ReposOwnerRepoActionsVariablesNamePatchBodyType,
    OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType,
    ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBodyType,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBodyType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
)
from .models import (
    Job,
    Runner,
    Artifact,
    Workflow,
    BasicError,
    Deployment,
    EmptyObject,
    WorkflowRun,
    ActionsSecret,
    WorkflowUsage,
    ActionsVariable,
    SelectedActions,
    ActionsCacheList,
    ActionsPublicKey,
    RequiredWorkflow,
    WorkflowRunUsage,
    OidcCustomSubRepo,
    PendingDeployment,
    RunnerApplication,
    AuthenticationToken,
    EnvironmentApprovals,
    RepoRequiredWorkflow,
    ValidationErrorSimple,
    OrganizationActionsSecret,
    OrganizationActionsVariable,
    ActionsRepositoryPermissions,
    ActionsCacheUsageByRepository,
    ActionsCacheUsageOrgEnterprise,
    ActionsOrganizationPermissions,
    OrgsOrgActionsVariablesPostBody,
    OrgsOrgActionsPermissionsPutBody,
    ActionsWorkflowAccessToRepository,
    OrgsOrgActionsRunnersGetResponse200,
    OrgsOrgActionsSecretsGetResponse200,
    ActionsGetDefaultWorkflowPermissions,
    ActionsSetDefaultWorkflowPermissions,
    OrgsOrgActionsVariablesNamePatchBody,
    OrgsOrgActionsVariablesGetResponse200,
    OrgsOrgActionsSecretsSecretNamePutBody,
    ReposOwnerRepoActionsVariablesPostBody,
    OrgsOrgActionsRequiredWorkflowsPostBody,
    ReposOwnerRepoActionsPermissionsPutBody,
    ReposOwnerRepoActionsRunsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
    ReposOwnerRepoActionsRunnersGetResponse200,
    ReposOwnerRepoActionsSecretsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
    ReposOwnerRepoActionsJobsJobIdRerunPostBody,
    ReposOwnerRepoActionsRunsRunIdRerunPostBody,
    ReposOwnerRepoActionsVariablesNamePatchBody,
    OrgsOrgActionsPermissionsRepositoriesPutBody,
    ReposOwnerRepoActionsArtifactsGetResponse200,
    ReposOwnerRepoActionsVariablesGetResponse200,
    ReposOwnerRepoActionsWorkflowsGetResponse200,
    OrgsOrgActionsRequiredWorkflowsGetResponse200,
    ReposOwnerRepoActionsSecretsSecretNamePutBody,
    OrgsOrgActionsVariablesNameRepositoriesPutBody,
    ReposOwnerRepoActionsOidcCustomizationSubPutBody,
    ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
    OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
    OrgsOrgActionsSecretsSecretNameRepositoriesPutBody,
    ReposOrgRepoActionsRequiredWorkflowsGetResponse200,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
    OrgsOrgActionsPermissionsRepositoriesGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
    OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
    ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
    ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
    ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
    OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
    OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBody,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody,
    ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
    OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBody,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody,
    ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200,
    OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
    ReposOwnerRepoActionsRequiredWorkflowsRequiredWorkflowIdForRepoRunsGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ActionsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_actions_cache_usage_for_org(
        self,
        org: str,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/orgs/{org}/actions/cache/usage"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_org(
        self,
        org: str,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/orgs/{org}/actions/cache/usage"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]":
        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    async def async_get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]":
        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    def get_github_actions_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsOrganizationPermissions]":
        url = f"/orgs/{org}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsOrganizationPermissions,
        )

    async def async_get_github_actions_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsOrganizationPermissions]":
        url = f"/orgs/{org}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsOrganizationPermissions,
        )

    @overload
    def set_github_actions_permissions_organization(
        self, org: str, *, data: OrgsOrgActionsPermissionsPutBodyType
    ) -> "Response":
        ...

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_github_actions_permissions_organization(
        self, org: str, *, data: OrgsOrgActionsPermissionsPutBodyType
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    async def async_list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self, org: str, *, data: OrgsOrgActionsPermissionsRepositoriesPutBodyType
    ) -> "Response":
        ...

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsPermissionsRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self, org: str, *, data: OrgsOrgActionsPermissionsRepositoriesPutBodyType
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsPermissionsRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_allowed_actions_organization(
        self,
        org: str,
    ) -> "Response[SelectedActions]":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_organization(
        self,
        org: str,
    ) -> "Response[SelectedActions]":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_organization(
        self, org: str, *, data: Union[Unset, SelectedActionsType] = UNSET
    ) -> "Response":
        ...

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_allowed_actions_organization(
        self, org: str, *, data: Union[Unset, SelectedActionsType] = UNSET, **kwargs
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_allowed_actions_organization(
        self, org: str, *, data: Union[Unset, SelectedActionsType] = UNSET
    ) -> "Response":
        ...

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_allowed_actions_organization(
        self, org: str, *, data: Union[Unset, SelectedActionsType] = UNSET, **kwargs
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/orgs/{org}/actions/permissions/workflow"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/orgs/{org}/actions/permissions/workflow"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/workflow"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ActionsSetDefaultWorkflowPermissions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Union[Unset, ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/workflow"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ActionsSetDefaultWorkflowPermissions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_required_workflows(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRequiredWorkflowsGetResponse200]":
        url = f"/orgs/{org}/actions/required_workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRequiredWorkflowsGetResponse200,
        )

    async def async_list_required_workflows(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRequiredWorkflowsGetResponse200]":
        url = f"/orgs/{org}/actions/required_workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRequiredWorkflowsGetResponse200,
        )

    @overload
    def create_required_workflow(
        self, org: str, *, data: OrgsOrgActionsRequiredWorkflowsPostBodyType
    ) -> "Response[RequiredWorkflow]":
        ...

    @overload
    def create_required_workflow(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        workflow_file_path: str,
        repository_id: str,
        scope: Union[Unset, Literal["selected", "all"]] = "all",
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[RequiredWorkflow]":
        ...

    def create_required_workflow(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsRequiredWorkflowsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RequiredWorkflow]":
        url = f"/orgs/{org}/actions/required_workflows"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsRequiredWorkflowsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RequiredWorkflow,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_required_workflow(
        self, org: str, *, data: OrgsOrgActionsRequiredWorkflowsPostBodyType
    ) -> "Response[RequiredWorkflow]":
        ...

    @overload
    async def async_create_required_workflow(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        workflow_file_path: str,
        repository_id: str,
        scope: Union[Unset, Literal["selected", "all"]] = "all",
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[RequiredWorkflow]":
        ...

    async def async_create_required_workflow(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsRequiredWorkflowsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RequiredWorkflow]":
        url = f"/orgs/{org}/actions/required_workflows"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsRequiredWorkflowsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RequiredWorkflow,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def get_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
    ) -> "Response[RequiredWorkflow]":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}"

        return self._github.request(
            "GET",
            url,
            response_model=RequiredWorkflow,
        )

    async def async_get_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
    ) -> "Response[RequiredWorkflow]":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RequiredWorkflow,
        )

    def delete_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBodyType,
    ) -> "Response[RequiredWorkflow]":
        ...

    @overload
    def update_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Unset = UNSET,
        workflow_file_path: Union[Unset, str] = UNSET,
        repository_id: Union[Unset, str] = UNSET,
        scope: Union[Unset, Literal["selected", "all"]] = "all",
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[RequiredWorkflow]":
        ...

    def update_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Union[
            Unset, OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RequiredWorkflow]":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RequiredWorkflow,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBodyType,
    ) -> "Response[RequiredWorkflow]":
        ...

    @overload
    async def async_update_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Unset = UNSET,
        workflow_file_path: Union[Unset, str] = UNSET,
        repository_id: Union[Unset, str] = UNSET,
        scope: Union[Unset, Literal["selected", "all"]] = "all",
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[RequiredWorkflow]":
        ...

    async def async_update_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Union[
            Unset, OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RequiredWorkflow]":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RequiredWorkflow,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def list_selected_repositories_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
    ) -> "Response[OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories"

        return self._github.request(
            "GET",
            url,
            response_model=OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesGetResponse200,
            error_models={},
        )

    async def async_list_selected_repositories_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
    ) -> "Response[OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesGetResponse200,
            error_models={},
        )

    @overload
    def set_selected_repos_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Union[
            Unset,
            OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_selected_repos_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        *,
        data: Union[
            Unset,
            OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgActionsRequiredWorkflowsRequiredWorkflowIdRepositoriesPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_selected_repo_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={},
        )

    async def async_add_selected_repo_to_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={},
        )

    def remove_selected_repo_from_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_selected_repo_from_required_workflow(
        self,
        org: str,
        required_workflow_id: int,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/required_workflows/{required_workflow_id}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def list_self_hosted_runners_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_org(
        self,
        org: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/orgs/{org}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_org(
        self,
        org: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/orgs/{org}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_org(
        self,
        org: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Union[Unset, OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsRunnersRunnerIdLabelsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Union[Unset, OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsRunnersRunnerIdLabelsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Union[Unset, OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsRunnersRunnerIdLabelsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Union[Unset, OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsRunnersRunnerIdLabelsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsSecretsGetResponse200]":
        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsSecretsGetResponse200]":
        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/orgs/{org}/actions/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/orgs/{org}/actions/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response[OrganizationActionsSecret]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=OrganizationActionsSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response[OrganizationActionsSecret]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrganizationActionsSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[Unset, OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[Unset, OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[
            Unset, OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[
            Unset, OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def list_org_variables(
        self,
        org: str,
        per_page: Union[Unset, int] = 10,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsVariablesGetResponse200]":
        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    async def async_list_org_variables(
        self,
        org: str,
        per_page: Union[Unset, int] = 10,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgActionsVariablesGetResponse200]":
        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    @overload
    def create_org_variable(
        self, org: str, *, data: OrgsOrgActionsVariablesPostBodyType
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_org_variable(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/variables"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsVariablesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_org_variable(
        self, org: str, *, data: OrgsOrgActionsVariablesPostBodyType
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_org_variable(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/variables"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsVariablesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def get_org_variable(
        self,
        org: str,
        name: str,
    ) -> "Response[OrganizationActionsVariable]":
        url = f"/orgs/{org}/actions/variables/{name}"

        return self._github.request(
            "GET",
            url,
            response_model=OrganizationActionsVariable,
        )

    async def async_get_org_variable(
        self,
        org: str,
        name: str,
    ) -> "Response[OrganizationActionsVariable]":
        url = f"/orgs/{org}/actions/variables/{name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrganizationActionsVariable,
        )

    def delete_org_variable(
        self,
        org: str,
        name: str,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_org_variable(
        self,
        org: str,
        name: str,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_org_variable(
        self, org: str, name: str, *, data: OrgsOrgActionsVariablesNamePatchBodyType
    ) -> "Response":
        ...

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Unset = UNSET,
        value: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response":
        ...

    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Union[Unset, OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsVariablesNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_update_org_variable(
        self, org: str, name: str, *, data: OrgsOrgActionsVariablesNamePatchBodyType
    ) -> "Response":
        ...

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Unset = UNSET,
        value: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response":
        ...

    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Union[Unset, OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsVariablesNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
        )

    def list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsVariablesNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    async def async_list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgActionsVariablesNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Union[Unset, OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsVariablesNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Union[Unset, OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgActionsVariablesNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    def add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={},
        )

    async def async_add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={},
        )

    def remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def list_repo_required_workflows(
        self,
        org: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOrgRepoActionsRequiredWorkflowsGetResponse200]":
        url = f"/repos/{org}/{repo}/actions/required_workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOrgRepoActionsRequiredWorkflowsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repo_required_workflows(
        self,
        org: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOrgRepoActionsRequiredWorkflowsGetResponse200]":
        url = f"/repos/{org}/{repo}/actions/required_workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOrgRepoActionsRequiredWorkflowsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def get_repo_required_workflow(
        self,
        org: str,
        repo: str,
        required_workflow_id_for_repo: int,
    ) -> "Response[RepoRequiredWorkflow]":
        url = f"/repos/{org}/{repo}/actions/required_workflows/{required_workflow_id_for_repo}"

        return self._github.request(
            "GET",
            url,
            response_model=RepoRequiredWorkflow,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_repo_required_workflow(
        self,
        org: str,
        repo: str,
        required_workflow_id_for_repo: int,
    ) -> "Response[RepoRequiredWorkflow]":
        url = f"/repos/{org}/{repo}/actions/required_workflows/{required_workflow_id_for_repo}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RepoRequiredWorkflow,
            error_models={
                "404": BasicError,
            },
        )

    def get_repo_required_workflow_usage(
        self,
        org: str,
        repo: str,
        required_workflow_id_for_repo: int,
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{org}/{repo}/actions/required_workflows/{required_workflow_id_for_repo}/timing"

        return self._github.request(
            "GET",
            url,
            response_model=WorkflowUsage,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_repo_required_workflow_usage(
        self,
        org: str,
        repo: str,
        required_workflow_id_for_repo: int,
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{org}/{repo}/actions/required_workflows/{required_workflow_id_for_repo}/timing"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WorkflowUsage,
            error_models={
                "404": BasicError,
            },
        )

    def list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    async def async_list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    def get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response[Artifact]":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Artifact,
        )

    async def async_get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response[Artifact]":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Artifact,
        )

    def delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "410": BasicError,
            },
        )

    async def async_download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "410": BasicError,
            },
        )

    def get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsCacheUsageByRepository]":
        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsCacheUsageByRepository,
        )

    async def async_get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsCacheUsageByRepository]":
        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsCacheUsageByRepository,
        )

    def get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        ref: Union[Unset, str] = UNSET,
        key: Union[Unset, str] = UNSET,
        sort: Union[
            Unset, Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = "last_accessed_at",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    async def async_get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        ref: Union[Unset, str] = UNSET,
        key: Union[Unset, str] = UNSET,
        sort: Union[
            Unset, Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = "last_accessed_at",
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        return self._github.request(
            "DELETE",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    async def async_delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            params=exclude_unset(params),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response[Job]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Job,
        )

    async def async_get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response[Job]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Job,
        )

    def download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        return await self._github.arequest(
            "GET",
            url,
        )

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Unset = UNSET,
        enable_debug_logging: Union[Unset, bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Unset = UNSET,
        enable_debug_logging: Union[Unset, bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    def get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[OidcCustomSubRepo]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        return self._github.request(
            "GET",
            url,
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[OidcCustomSubRepo]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        use_default: bool,
        include_claim_keys: Union[Unset, List[str]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsOidcCustomizationSubPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsOidcCustomizationSubPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        use_default: bool,
        include_claim_keys: Union[Unset, List[str]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsOidcCustomizationSubPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsOidcCustomizationSubPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsRepositoryPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsRepositoryPermissions,
        )

    async def async_get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsRepositoryPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsRepositoryPermissions,
        )

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        enabled: bool,
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        enabled: bool,
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsWorkflowAccessToRepository]":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsWorkflowAccessToRepository,
        )

    async def async_get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsWorkflowAccessToRepository]":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsWorkflowAccessToRepository,
        )

    @overload
    def set_workflow_access_to_repository(
        self, owner: str, repo: str, *, data: ActionsWorkflowAccessToRepositoryType
    ) -> "Response":
        ...

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        access_level: Literal["none", "user", "organization"],
    ) -> "Response":
        ...

    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ActionsWorkflowAccessToRepository, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_workflow_access_to_repository(
        self, owner: str, repo: str, *, data: ActionsWorkflowAccessToRepositoryType
    ) -> "Response":
        ...

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        access_level: Literal["none", "user", "organization"],
    ) -> "Response":
        ...

    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ActionsWorkflowAccessToRepository, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[SelectedActions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[SelectedActions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_repository(
        self, owner: str, repo: str, *, data: Union[Unset, SelectedActionsType] = UNSET
    ) -> "Response":
        ...

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_allowed_actions_repository(
        self, owner: str, repo: str, *, data: Union[Unset, SelectedActionsType] = UNSET
    ) -> "Response":
        ...

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self, owner: str, repo: str, *, data: ActionsSetDefaultWorkflowPermissionsType
    ) -> "Response":
        ...

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ActionsSetDefaultWorkflowPermissions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self, owner: str, repo: str, *, data: ActionsSetDefaultWorkflowPermissionsType
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        default_workflow_permissions: Union[Unset, Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Union[Unset, bool] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ActionsSetDefaultWorkflowPermissions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={},
        )

    def list_required_workflow_runs(
        self,
        owner: str,
        repo: str,
        required_workflow_id_for_repo: int,
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
        head_sha: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRequiredWorkflowsRequiredWorkflowIdForRepoRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/required_workflows/{required_workflow_id_for_repo}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRequiredWorkflowsRequiredWorkflowIdForRepoRunsGetResponse200,
        )

    async def async_list_required_workflow_runs(
        self,
        owner: str,
        repo: str,
        required_workflow_id_for_repo: int,
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
        head_sha: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRequiredWorkflowsRequiredWorkflowIdForRepoRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/required_workflows/{required_workflow_id_for_repo}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRequiredWorkflowsRequiredWorkflowIdForRepoRunsGetResponse200,
        )

    def list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunnersGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunnersGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
        head_sha: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    async def async_list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
        head_sha: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    def get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    def delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[EnvironmentApprovals]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        return self._github.request(
            "GET",
            url,
            response_model=List[EnvironmentApprovals],
        )

    async def async_get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[EnvironmentApprovals]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[EnvironmentApprovals],
        )

    def approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        return self._github.request(
            "POST",
            url,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        return await self._github.arequest(
            "POST",
            url,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    async def async_list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    def get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Union[Unset, bool] = False,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=WorkflowRun,
        )

    def list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        return await self._github.arequest(
            "GET",
            url,
        )

    def cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        return self._github.request(
            "POST",
            url,
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    async def async_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        return await self._github.arequest(
            "POST",
            url,
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    def list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    async def async_list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    def download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return await self._github.arequest(
            "GET",
            url,
        )

    def delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[PendingDeployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        return self._github.request(
            "GET",
            url,
            response_model=List[PendingDeployment],
        )

    async def async_get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[List[PendingDeployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[PendingDeployment],
        )

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> "Response[List[Deployment]]":
        ...

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Unset = UNSET,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> "Response[List[Deployment]]":
        ...

    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Deployment],
        )

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> "Response[List[Deployment]]":
        ...

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Unset = UNSET,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> "Response[List[Deployment]]":
        ...

    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Deployment],
        )

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Unset = UNSET,
        enable_debug_logging: Union[Unset, bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Unset = UNSET,
        enable_debug_logging: Union[Unset, bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset,
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None],
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Unset = UNSET,
        enable_debug_logging: Union[Unset, bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset,
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None],
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset,
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None],
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Unset = UNSET,
        enable_debug_logging: Union[Unset, bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Union[
            Unset,
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None],
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[WorkflowRunUsage]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        return self._github.request(
            "GET",
            url,
            response_model=WorkflowRunUsage,
        )

    async def async_get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
    ) -> "Response[WorkflowRunUsage]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WorkflowRunUsage,
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_repo_variables(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 10,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsVariablesGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    async def async_list_repo_variables(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 10,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsVariablesGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    @overload
    def create_repo_variable(
        self, owner: str, repo: str, *, data: ReposOwnerRepoActionsVariablesPostBodyType
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsVariablesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_repo_variable(
        self, owner: str, repo: str, *, data: ReposOwnerRepoActionsVariablesPostBodyType
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsVariablesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response[ActionsVariable]":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsVariable,
        )

    async def async_get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response[ActionsVariable]":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsVariable,
        )

    def delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Unset = UNSET,
        value: Union[Unset, str] = UNSET,
    ) -> "Response":
        ...

    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsVariablesNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Unset = UNSET,
        value: Union[Unset, str] = UNSET,
    ) -> "Response":
        ...

    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Union[Unset, ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoActionsVariablesNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
        )

    def list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    async def async_list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    def get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[Workflow]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Workflow,
        )

    async def async_get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[Workflow]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Workflow,
        )

    def disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        return await self._github.arequest(
            "PUT",
            url,
        )

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> "Response":
        ...

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: Unset = UNSET,
        ref: str,
        inputs: Union[
            Unset,
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
        ] = UNSET,
    ) -> "Response":
        ...

    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: Unset = UNSET,
        ref: str,
        inputs: Union[
            Unset,
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: Union[
            Unset, ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
        )

    def enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
        head_sha: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    async def async_list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        event: Union[Unset, str] = UNSET,
        status: Union[
            Unset,
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ],
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        created: Union[Unset, datetime] = UNSET,
        exclude_pull_requests: Union[Unset, bool] = False,
        check_suite_id: Union[Unset, int] = UNSET,
        head_sha: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    def get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        return self._github.request(
            "GET",
            url,
            response_model=WorkflowUsage,
        )

    async def async_get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WorkflowUsage,
        )

    def list_environment_secrets(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    async def async_list_environment_secrets(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    def get_environment_public_key(
        self,
        repository_id: int,
        environment_name: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    async def async_get_environment_public_key(
        self,
        repository_id: int,
        environment_name: str,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsPublicKey,
        )

    def get_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    async def async_get_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response[ActionsSecret]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: str,
        key_id: str,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: Union[
            Unset,
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: str,
        key_id: str,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: Union[
            Unset,
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def delete_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_environment_variables(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Union[Unset, int] = 10,
        page: Union[Unset, int] = 1,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    async def async_list_environment_variables(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Union[Unset, int] = 10,
        page: Union[Unset, int] = 1,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    @overload
    def create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: Unset = UNSET,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    def create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: Union[
            Unset,
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: Unset = UNSET,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: Union[
            Unset,
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
        )

    def get_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        name: str,
    ) -> "Response[ActionsVariable]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsVariable,
        )

    async def async_get_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        name: str,
    ) -> "Response[ActionsVariable]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsVariable,
        )

    def delete_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    def update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: Unset = UNSET,
        value: Union[Unset, str] = UNSET,
    ) -> "Response":
        ...

    def update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: Union[
            Unset,
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: Unset = UNSET,
        value: Union[Unset, str] = UNSET,
    ) -> "Response":
        ...

    async def async_update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: Union[
            Unset,
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
        )
