# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_cmap.ipynb.

# %% auto 0
__all__ = ['get_continuous_cmap']

# %% ../00_cmap.ipynb 2
from matplotlib import colors

# %% ../00_cmap.ipynb 3
def get_continuous_cmap(hex_list, float_list=None):
    ''' creates and returns a color map that can be used in heat map figures.
        If float_list is not provided, colour map graduates linearly between each color in hex_list.
        If float_list is provided, each color in hex_list is mapped to the respective location in float_list. 
        
        Parameters
        ----------
        hex_list: list of hex code strings
        float_list: list of floats between 0 and 1, same length as hex_list. Must start with 0 and end with 1.
        
        Returns
        ----------
        colour map'''
    rgb_list = [[int(x.strip('#')[i:i + len(x.strip('#')) // 3], 16)/256 for i in range(0, len(x.strip('#')), len(x.strip('#')) // 3)] for x in hex_list]
    if float_list:
        pass
    else:
        float_list = list(np.linspace(0,1,len(rgb_list)))
        
    cdict = dict()
    for num, col in enumerate(['red', 'green', 'blue']):
        cdict[col] = [[float_list[i], rgb_list[i][num], rgb_list[i][num]] for i in range(len(float_list))]
    cmp = colors.LinearSegmentedColormap('my_cmp', segmentdata=cdict, N=256)
    return cmp
