# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ptyx',
 'ptyx.extensions',
 'ptyx.extensions.extended_python',
 'ptyx.extensions.extended_python.tests',
 'ptyx.extensions.geophyx',
 'ptyx.extensions.geophyx.tests',
 'ptyx.extensions.questions',
 'ptyx.extensions.questions.tests']

package_data = \
{'': ['*'],
 'ptyx': ['.mypy_cache/*',
          '.mypy_cache/3.8/*',
          '.mypy_cache/3.8/_typeshed/*',
          '.mypy_cache/3.8/collections/*',
          '.mypy_cache/3.8/ctypes/*',
          '.mypy_cache/3.8/curses/*',
          '.mypy_cache/3.8/email/*',
          '.mypy_cache/3.8/http/*',
          '.mypy_cache/3.8/importlib/*',
          '.mypy_cache/3.8/importlib/metadata/*',
          '.mypy_cache/3.8/json/*',
          '.mypy_cache/3.8/logging/*',
          '.mypy_cache/3.8/numpy/*',
          '.mypy_cache/3.8/numpy/_typing/*',
          '.mypy_cache/3.8/numpy/compat/*',
          '.mypy_cache/3.8/numpy/core/*',
          '.mypy_cache/3.8/numpy/fft/*',
          '.mypy_cache/3.8/numpy/lib/*',
          '.mypy_cache/3.8/numpy/linalg/*',
          '.mypy_cache/3.8/numpy/ma/*',
          '.mypy_cache/3.8/numpy/matrixlib/*',
          '.mypy_cache/3.8/numpy/polynomial/*',
          '.mypy_cache/3.8/numpy/random/*',
          '.mypy_cache/3.8/numpy/testing/*',
          '.mypy_cache/3.8/numpy/testing/_private/*',
          '.mypy_cache/3.8/numpy/typing/*',
          '.mypy_cache/3.8/os/*',
          '.mypy_cache/3.8/ptyx/*',
          '.mypy_cache/3.8/ptyx/extensions/*',
          '.mypy_cache/3.8/ptyx/extensions/autoqcm/*',
          '.mypy_cache/3.8/ptyx/extensions/autoqcm/compile/*',
          '.mypy_cache/3.8/ptyx/extensions/autoqcm/scan/*',
          '.mypy_cache/3.8/ptyx/extensions/extended_python/*',
          '.mypy_cache/3.8/ptyx/extensions/geophyx/*',
          '.mypy_cache/3.8/ptyx/extensions/questions/*',
          '.mypy_cache/3.8/pyexpat/*',
          '.mypy_cache/3.8/sympy/*',
          '.mypy_cache/3.8/sympy/algebras/*',
          '.mypy_cache/3.8/sympy/assumptions/*',
          '.mypy_cache/3.8/sympy/assumptions/handlers/*',
          '.mypy_cache/3.8/sympy/assumptions/predicates/*',
          '.mypy_cache/3.8/sympy/assumptions/relation/*',
          '.mypy_cache/3.8/sympy/calculus/*',
          '.mypy_cache/3.8/sympy/categories/*',
          '.mypy_cache/3.8/sympy/codegen/*',
          '.mypy_cache/3.8/sympy/combinatorics/*',
          '.mypy_cache/3.8/sympy/concrete/*',
          '.mypy_cache/3.8/sympy/core/*',
          '.mypy_cache/3.8/sympy/discrete/*',
          '.mypy_cache/3.8/sympy/external/*',
          '.mypy_cache/3.8/sympy/functions/*',
          '.mypy_cache/3.8/sympy/functions/combinatorial/*',
          '.mypy_cache/3.8/sympy/functions/elementary/*',
          '.mypy_cache/3.8/sympy/functions/special/*',
          '.mypy_cache/3.8/sympy/geometry/*',
          '.mypy_cache/3.8/sympy/integrals/*',
          '.mypy_cache/3.8/sympy/interactive/*',
          '.mypy_cache/3.8/sympy/logic/*',
          '.mypy_cache/3.8/sympy/logic/algorithms/*',
          '.mypy_cache/3.8/sympy/matrices/*',
          '.mypy_cache/3.8/sympy/matrices/expressions/*',
          '.mypy_cache/3.8/sympy/multipledispatch/*',
          '.mypy_cache/3.8/sympy/ntheory/*',
          '.mypy_cache/3.8/sympy/parsing/*',
          '.mypy_cache/3.8/sympy/physics/*',
          '.mypy_cache/3.8/sympy/physics/control/*',
          '.mypy_cache/3.8/sympy/physics/units/*',
          '.mypy_cache/3.8/sympy/physics/units/definitions/*',
          '.mypy_cache/3.8/sympy/physics/units/systems/*',
          '.mypy_cache/3.8/sympy/plotting/*',
          '.mypy_cache/3.8/sympy/plotting/intervalmath/*',
          '.mypy_cache/3.8/sympy/plotting/pygletplot/*',
          '.mypy_cache/3.8/sympy/polys/*',
          '.mypy_cache/3.8/sympy/polys/agca/*',
          '.mypy_cache/3.8/sympy/polys/domains/*',
          '.mypy_cache/3.8/sympy/polys/matrices/*',
          '.mypy_cache/3.8/sympy/polys/numberfields/*',
          '.mypy_cache/3.8/sympy/printing/*',
          '.mypy_cache/3.8/sympy/printing/pretty/*',
          '.mypy_cache/3.8/sympy/series/*',
          '.mypy_cache/3.8/sympy/sets/*',
          '.mypy_cache/3.8/sympy/sets/handlers/*',
          '.mypy_cache/3.8/sympy/simplify/*',
          '.mypy_cache/3.8/sympy/solvers/*',
          '.mypy_cache/3.8/sympy/solvers/diophantine/*',
          '.mypy_cache/3.8/sympy/solvers/ode/*',
          '.mypy_cache/3.8/sympy/strategies/*',
          '.mypy_cache/3.8/sympy/strategies/branch/*',
          '.mypy_cache/3.8/sympy/tensor/*',
          '.mypy_cache/3.8/sympy/tensor/array/*',
          '.mypy_cache/3.8/sympy/tensor/array/expressions/*',
          '.mypy_cache/3.8/sympy/testing/*',
          '.mypy_cache/3.8/sympy/utilities/*',
          '.mypy_cache/3.8/sympy/utilities/mathml/*',
          '.mypy_cache/3.8/sympy/vector/*',
          '.mypy_cache/3.8/unittest/*',
          '.mypy_cache/3.8/urllib/*',
          '.mypy_cache/3.8/xml/*',
          '.mypy_cache/3.8/xml/dom/*',
          '.mypy_cache/3.8/xml/parsers/*',
          '.mypy_cache/3.8/xml/parsers/expat/*',
          '.mypy_cache/3.8/xml/sax/*']}

install_requires = \
['numpy>=1.23.0,<2.0.0', 'sympy>=1.10.1,<2.0.0']

entry_points = \
{'console_scripts': ['autoqcm = ptyx.extensions.autoqcm.cli:main',
                     'ptyx = ptyx.script:ptyx',
                     'scan = ptyx.extensions.autoqcm.cli:scan']}

setup_kwargs = {
    'name': 'ptyx',
    'version': '22.4.0',
    'description': 'pTyX is a python precompiler for LaTeX.',
    'long_description': "pTyX\n====\n\nOverview\n--------\npTyX is a LaTeX precompilator, written in Python.\npTyX enables to generate LaTeX documents, using custom commands or plain python code.\nOne single pTyX file may generate many latex documents, with different values.\nI developped and used pTyX to make several different versions of a same test in exams,\nfor my student, to discourage cheating.\nSince it uses sympy library, pTyX has symbolic calculus abilities too.\n\nInstallation\n------------\npTyX is only tested on GNU/Linux (Ubuntu), but should work on MacOs X too.\n\nObviously, pTyX needs a working Python installation.\nPython version 3.8 (at least) is required for pTyX to run.\n\npTyX also needs a working LaTeX installation. Command *pdflatex* must be available in your terminal.\n\nThe easiest way to install it is using pip.\n\n    $ pip install ptyx\n\nYou may also download and install the latest version from Github:\n\n    $ git clone https://github.com/wxgeo/ptyx.git\n    $ cd ptyx\n    $ pip install -e .\n\nUsage\n-----\n\nTo compile a pTyX file (see below), open a terminal, go to pTyX directory, and write:\n\n    $ ptyx my_file.ptyx\n\nFor more options:\n\n    $ ptyx --help\n\n\npTyX file specification\n-----------------------\nA pTyX file is essentially a LaTeX file, with a .ptyx extension, (optionally) some custom commands, and embedded python code.\n\nTo include python code in a pTyX file, use the #PYTHON and #END balise.\nA special *write()* command is available, to generate latex code on the flow from python.\n\n    This a simple \\emph{addition}:\\quad\n    #PYTHON\n    from random import randint\n    a = randint(5, 9)\n    b = randint(2, 4)\n    write('%s + %s = %s\\\\' % (a, b, a + b))\n    #END\n    Now, some basic \\emph{subtraction}:\\quad\n    #PYTHON\n    write('%s - %s = %s\\\\' % (a, b, a - b))\n    #END\n\nTo access any python variable outside python code scope, simply add a hashtag before the variable name.\n\nAny valid python expression can also be evaluated this way, using syntax #{python_expr}.\n\n    $#a\\mul#b=#{a*b}$\n\nHowever, pTyX has also reserved tags, like conditionals statements #IF, #ELSE, #ENDIF...\n\n(More to come...)\n",
    'author': 'Nicolas Pourcelot',
    'author_email': 'nicolas.pourcelot@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/wxgeo/ptyx',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
