from typing import Any
from sqlalchemy import Column, Integer, TEXT, REAL
from .bmp_table import BMPTable
from ...names import Names

class Reservoir(BMPTable):
    """Parameter Table for BMP: Reservoir (3)"""
    __tablename__ = Names.bmp_table_name_reservoir
    ID = Column(Integer, primary_key=True)
    XLL = Column(REAL)
    YLL = Column(REAL)
    OPERATION = Column(TEXT)
    SA_EM = Column(REAL)
    V_EM = Column(REAL)
    SA_PR = Column(REAL)
    V_PR = Column(REAL)
    INI_S = Column(REAL)
    Q_REL = Column(REAL)
    k_res = Column(REAL)
    OFLOWMN01 = Column(REAL)
    OFLOWMN02 = Column(REAL)
    OFLOWMN03 = Column(REAL)
    OFLOWMN04 = Column(REAL)
    OFLOWMN05 = Column(REAL)
    OFLOWMN06 = Column(REAL)
    OFLOWMN07 = Column(REAL)
    OFLOWMN08 = Column(REAL)
    OFLOWMN09 = Column(REAL)
    OFLOWMN10 = Column(REAL)
    OFLOWMN11 = Column(REAL)
    OFLOWMN12 = Column(REAL)
    OFLOWMX01 = Column(REAL)
    OFLOWMX02 = Column(REAL)
    OFLOWMX03 = Column(REAL)
    OFLOWMX04 = Column(REAL)
    OFLOWMX05 = Column(REAL)
    OFLOWMX06 = Column(REAL)
    OFLOWMX07 = Column(REAL)
    OFLOWMX08 = Column(REAL)
    OFLOWMX09 = Column(REAL)
    OFLOWMX10 = Column(REAL)
    OFLOWMX11 = Column(REAL)
    OFLOWMX12 = Column(REAL)
    METHOD = Column(TEXT)
    SEDMETHOD = Column(TEXT)
    INT_SC = Column(REAL)
    NSED = Column(REAL)
    D50 = Column(REAL)
    NUTMETHOD = Column(TEXT)
    FILE = Column(TEXT)
    PSETLR = Column(REAL)
    NSETLR = Column(REAL)
    CHLAR = Column(REAL)
    SECCIR = Column(REAL)
    ORGP = Column(REAL)
    SOLP = Column(REAL)
    ORGN = Column(REAL)
    NO3 = Column(REAL)
    NH3 = Column(REAL)
    NO2 = Column(REAL)
    IFLOD1R = Column(REAL)
    IFLOD2R = Column(REAL)
    NDTARGR = Column(REAL)
    STARG01 = Column(REAL)
    STARG02 = Column(REAL)
    STARG03 = Column(REAL)
    STARG04 = Column(REAL)
    STARG05 = Column(REAL)
    STARG07 = Column(REAL)
    STARG08 = Column(REAL)
    STARG09 = Column(REAL)
    STARG10 = Column(REAL)
    STARG11 = Column(REAL)
    STARG12 = Column(REAL)

    def __init__(self, id:int):
        self.ID = id
        self.XLL = 0
        self.YLL = 0
        self.OPERATION = "1900-01-01"
        self.SA_EM = 0
        self.V_EM = 0
        self.SA_PR = 0
        self.V_PR = 0
        self.INI_S = 0
        self.Q_REL = 0
        self.k_res = 0.3
        self.OFLOWMN01 = 0
        self.OFLOWMN02 = 0
        self.OFLOWMN03 = 0
        self.OFLOWMN04 = 0
        self.OFLOWMN05 = 0
        self.OFLOWMN06 = 0
        self.OFLOWMN07 = 0
        self.OFLOWMN08 = 0
        self.OFLOWMN09 = 0
        self.OFLOWMN10 = 0
        self.OFLOWMN11 = 0
        self.OFLOWMN12 = 0
        self.OFLOWMX01 = 0
        self.OFLOWMX02 = 0
        self.OFLOWMX03 = 0
        self.OFLOWMX04 = 0
        self.OFLOWMX05 = 0
        self.OFLOWMX06 = 0
        self.OFLOWMX07 = 0
        self.OFLOWMX08 = 0
        self.OFLOWMX09 = 0
        self.OFLOWMX10 = 0
        self.OFLOWMX11 = 0
        self.OFLOWMX12 = 0
        self.METHOD = "MMO_RES"
        self.SEDMETHOD = "SMB_RES"
        self.INT_SC = 0.03
        self.NSED = 1
        self.D50 = 10
        self.NUTMETHOD = "RES_NUTR_BAL"
        self.FILE = 0
        self.PSETLR = 50
        self.NSETLR = 10
        self.CHLAR = 1
        self.SECCIR = 1
        self.ORGP = 0
        self.SOLP = 0
        self.ORGN = 0
        self.NO3 = 0
        self.NH3 = 0
        self.NO2 = 0
        self.IFLOD1R = 10
        self.IFLOD2R = 3
        self.NDTARGR = 1
        self.STARG01 = 0.5
        self.STARG02 = 0.5
        self.STARG03 = 0.5
        self.STARG04 = 2
        self.STARG05 = 2
        self.STARG07 = 2
        self.STARG08 = 2
        self.STARG09 = 2
        self.STARG10 = 0.5
        self.STARG11 = 0.5
        self.STARG12 = 0.5
        self.SELECTION = 0
