import { ILabShell } from '@jupyterlab/application';
import { INotebookTracker, NotebookPanel } from '@jupyterlab/notebook';
import { SessionManager } from '@jupyterlab/services';
import { ResolveStatus } from '../types';
declare type StatusMap = {
    [notebookId: string]: {
        [did: string]: ResolveStatus;
    };
};
export declare function useNotebookResolveStatusStore(): StatusMap;
export interface NotebookListenerOptions {
    labShell: ILabShell;
    notebookTracker: INotebookTracker;
    sessionManager: SessionManager;
}
export declare class NotebookListener {
    options: NotebookListenerOptions;
    kernelNotebookMapping: {
        [kernelConnectionId: string]: string;
    };
    constructor(options: NotebookListenerOptions);
    private setup;
    private onNotebookOpened;
    private insertInjectButton;
    private onKernelRestarted;
    private onKernelDetached;
    private onKernelAttached;
    private clearKernelResolverStatus;
    private setupKernelReceiverComm;
    private processIncomingMessage;
    injectUninjected(notebookPanel: NotebookPanel): void;
    reinject(notebookPanel: NotebookPanel): void;
    reinjectSpecificDID(notebookPanel: NotebookPanel, did: string): void;
    private getAttachmentsFromMetadata;
    private injectUninjectedAttachments;
    private removeNonExistentInjectedAttachments;
    private injectAttachments;
    private injectVariables;
    private resolveAttachments;
    private resolveAttachment;
    private setResolveStatus;
    private getCollectionDIDPaths;
    private getFileDIDPaths;
    private resolveFileDIDDetails;
    private resolveCollectionDIDDetails;
    private getNotebookIdFromKernelConnectionId;
    private setKernelNotebookMapping;
    private deleteKernelNotebookMapping;
    private isExtensionProperlySetup;
}
export {};
