var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { UIStore } from '../stores/UIStore';
import { actions } from './Actions';
export class PollingRequesterRef {
}
class DIDPollingManager {
    constructor() {
        this.pollingRequesterMap = {};
        setInterval(() => {
            this.poll();
        }, 10000);
    }
    requestPolling(did, type, ref, fetchNow = true) {
        if (!this.pollingRequesterMap[did]) {
            this.pollingRequesterMap[did] = { type, refs: [] };
        }
        const requesterRef = ref || new PollingRequesterRef();
        this.pollingRequesterMap[did].refs.push(requesterRef);
        if (fetchNow) {
            this.fetchDid(did);
        }
        return () => {
            this.disablePolling(did, requesterRef);
        };
    }
    disablePolling(did, ref) {
        if (this.pollingRequesterMap[did]) {
            this.pollingRequesterMap[did].refs = this.pollingRequesterMap[did].refs.filter(r => r !== ref);
        }
    }
    poll() {
        const dids = Object.keys(this.pollingRequesterMap).filter(did => {
            return this.pollingRequesterMap[did] && this.pollingRequesterMap[did].refs.length > 0;
        });
        dids.forEach(did => {
            this.fetchDid(did);
        });
    }
    fetchDid(did) {
        const { activeInstance } = UIStore.getRawState();
        if (!activeInstance) {
            return;
        }
        const type = this.pollingRequesterMap[did].type;
        switch (type) {
            case 'file':
                actions.getFileDIDDetails(activeInstance.name, did, true).then(details => {
                    if (details.status !== 'REPLICATING') {
                        delete this.pollingRequesterMap[did];
                    }
                });
                break;
            case 'collection':
                actions.getCollectionDIDDetails(activeInstance.name, did, true).then(didDetails => {
                    if (!didDetails.find(d => d.status === 'REPLICATING')) {
                        delete this.pollingRequesterMap[did];
                    }
                });
                break;
        }
    }
}
export const didPollingManager = new DIDPollingManager();
//eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
export function withPollingManager(Component) {
    return class WithPollingManager extends React.Component {
        //eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
        render() {
            const props = __rest(this.props, []);
            return React.createElement(Component, Object.assign({}, props, { didPollingManager: didPollingManager }));
        }
    };
}
