var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import qs from 'querystring';
import { requestAPI } from './ApiRequest';
import { UIStore } from '../stores/UIStore';
export class Actions {
    async fetchInstancesConfig() {
        return requestAPI('instances');
    }
    async postActiveInstance(instanceName, authType) {
        const init = {
            method: 'PUT',
            body: JSON.stringify({
                instance: instanceName,
                auth: authType
            })
        };
        return requestAPI('instances', init);
    }
    async fetchAuthConfig(namespace, type) {
        const query = { namespace, type };
        return requestAPI(`auth?${qs.encode(query)}`);
    }
    async putAuthConfig(namespace, type, params) {
        const init = {
            method: 'PUT',
            body: JSON.stringify({
                namespace,
                type,
                params
            })
        };
        return requestAPI('auth', init);
    }
    async searchDID(namespace, did, type) {
        const query = { namespace, did, type };
        return requestAPI(`did-search?${qs.encode(query)}`);
    }
    async fetchAttachedFileDIDs(namespace, did) {
        const query = { namespace, did };
        return requestAPI(`files?${qs.encode(query)}`);
    }
    async fetchDIDDetails(namespace, did, poll = false) {
        const query = { namespace, did, poll: poll ? 1 : undefined };
        return requestAPI('did?' + qs.encode(query));
    }
    async getFileDIDDetails(namespace, did, poll = false) {
        const fileDetails = UIStore.getRawState().fileDetails[did];
        if (!poll && !!fileDetails) {
            return fileDetails;
        }
        const didDetails = await this.fetchDIDDetails(namespace, did, poll);
        const didMap = didDetails.reduce((acc, curr) => {
            acc[curr.did] = curr;
            return acc;
        }, {});
        UIStore.update(s => {
            s.fileDetails = Object.assign(Object.assign({}, s.fileDetails), didMap);
        });
        return didDetails[0];
    }
    async getCollectionDIDDetails(namespace, did, poll = false) {
        const collectionDetails = UIStore.getRawState().collectionDetails[did];
        if (!poll && !!collectionDetails) {
            return collectionDetails;
        }
        const didDetails = await this.fetchDIDDetails(namespace, did, poll);
        UIStore.update(s => {
            s.collectionDetails[did] = didDetails;
        });
        return didDetails;
    }
    async makeFileAvailable(namespace, did) {
        const fileDetails = UIStore.getRawState().fileDetails[did];
        UIStore.update(s => {
            s.fileDetails[did] = Object.assign(Object.assign({}, fileDetails), { status: 'REPLICATING' });
        });
        const init = {
            method: 'POST',
            body: JSON.stringify({ did })
        };
        return requestAPI('did/make-available?namespace=' + encodeURIComponent(namespace), init);
    }
    async makeCollectionAvailable(namespace, did) {
        const collectionAttachedFiles = UIStore.getRawState().collectionDetails[did];
        const updatedCollectionAttachedFiles = collectionAttachedFiles.map(f => (Object.assign(Object.assign({}, f), { status: f.status === 'OK' ? 'OK' : 'REPLICATING' })));
        UIStore.update(s => {
            s.collectionDetails[did] = updatedCollectionAttachedFiles;
        });
        const init = {
            method: 'POST',
            body: JSON.stringify({ did })
        };
        return requestAPI('did/make-available?namespace=' + encodeURIComponent(namespace), init);
    }
    async listDirectory(path) {
        return requestAPI('file-browser?path=' + encodeURIComponent(path));
    }
}
export const actions = new Actions();
//eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
export function withRequestAPI(Component) {
    return class WithRequestAPI extends React.Component {
        //eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
        render() {
            const props = __rest(this.props, []);
            return React.createElement(Component, Object.assign({}, props, { actions: actions }));
        }
    };
}
