var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useState, useEffect, useCallback } from 'react';
import { createUseStyles } from 'react-jss';
import { FixedSizeList } from 'react-window';
import AutoSizer from 'react-virtualized-auto-sizer';
import Popover from 'react-popover';
import { withRequestAPI } from '../../utils/Actions';
const useStyles = createUseStyles({
    main: {
        width: '300px',
        background: 'var(--jp-layout-color1)',
        color: 'var(--jp-ui-font-color1)'
    },
    heading: {
        background: 'var(--jp-layout-color2)',
        color: 'var(--jp-ui-font-color2)',
        padding: '8px',
        borderBottom: '1px solid var(--jp-border-color2)',
        fontSize: '9pt'
    },
    content: {
        fontSize: '10pt',
        overflow: 'auto',
        height: '250px',
        '&.loading': {
            opacity: 0.4,
            pointerEvents: 'none'
        }
    },
    icon: {
        fontSize: '16px',
        verticalAlign: 'middle'
    },
    clickable: {
        cursor: 'pointer'
    },
    folderName: {
        verticalAlign: 'middle'
    },
    listItem: {
        display: 'flex',
        padding: '8px',
        borderBottom: '1px solid var(--jp-border-color2)',
        flexDirection: 'row',
        fontSize: '9pt',
        cursor: 'pointer',
        alignItems: 'center',
        boxSizing: 'border-box',
        '&:hover': {
            backgroundColor: 'var(--jp-layout-color2)'
        }
    },
    textContainer: {
        flex: 1,
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
    },
    iconContainer: {
        lineHeight: 0,
        marginRight: '8px'
    },
    fileIcon: {
        extend: 'icon',
        color: '#66B100'
    },
    dirIcon: {
        extend: 'icon',
        color: '#5DC0FD'
    }
});
const _FilePickerPopover = (_a) => {
    var { children, onFilePicked } = _a, props = __rest(_a, ["children", "onFilePicked"]);
    const { actions } = props;
    const classes = useStyles();
    const [path, setPath] = useState([]);
    const [open, setOpen] = useState(false);
    const [loading, setLoading] = useState(false);
    const [directoryItems, setDirectoryItems] = useState([]);
    const [itemsCache, setItemsCache] = useState({});
    const openPopover = () => {
        setOpen(true);
        setPath([]);
        setDirectoryItems([]);
        setItemsCache({});
    };
    const itemsSortFunction = (a, b) => {
        if (a.type === b.type) {
            return a.name.toLowerCase() < b.name.toLowerCase() ? -1 : 1;
        }
        return a.type === 'dir' && b.type === 'file' ? -1 : 1;
    };
    const loadDirectoryItem = () => {
        const pathString = path.join('/');
        if (itemsCache[pathString]) {
            setDirectoryItems(itemsCache[pathString]);
        }
        else {
            setLoading(true);
            actions
                .listDirectory(pathString)
                .then(items => items.sort(itemsSortFunction))
                .then(items => {
                const newItemsCache = Object.assign({}, itemsCache);
                newItemsCache[pathString] = items;
                setItemsCache(newItemsCache);
                setDirectoryItems(items);
            })
                .catch(() => setDirectoryItems([]))
                .finally(() => {
                setLoading(false);
            });
        }
    };
    useEffect(loadDirectoryItem, [path]);
    const moveToUpperDirectory = () => {
        const newPath = path.filter((p, i) => {
            return i < path.length - 1;
        });
        setPath(newPath);
    };
    const moveToHomeDirectory = () => {
        setPath([]);
    };
    const onKeyDown = useCallback(event => {
        if (event.keyCode === 27) {
            setOpen(false);
        }
    }, []);
    useEffect(() => {
        document.addEventListener('keydown', onKeyDown, false);
        return () => {
            document.removeEventListener('keydown', onKeyDown, false);
        };
    }, []);
    const onItemClick = (item) => {
        if (item.type === 'dir') {
            setPath([...path, item.name]);
        }
        else {
            onFilePicked(item.path);
            setOpen(false);
        }
    };
    const Row = ({ index, style }) => {
        const item = directoryItems[index];
        return React.createElement(ListItem, { style: style, directoryItem: item, key: item.path, onClick: () => onItemClick(item) });
    };
    const popoverBody = (React.createElement("div", { className: classes.main },
        React.createElement("div", { className: classes.heading },
            React.createElement("span", { className: `material-icons ${classes.icon} ${classes.clickable}`, onClick: moveToHomeDirectory }, "home"),
            path.length === 0 && React.createElement("span", { className: classes.folderName }, "\u00A0 Home"),
            path.length >= 1 && React.createElement("span", { className: `material-icons ${classes.icon}` }, "navigate_next"),
            path.length >= 2 && (React.createElement(React.Fragment, null,
                React.createElement("span", { className: `material-icons ${classes.icon} ${classes.clickable}`, onClick: moveToUpperDirectory }, "more_horiz"),
                React.createElement("span", { className: `material-icons ${classes.icon}` }, "navigate_next"))),
            React.createElement("span", { className: classes.folderName }, path ? path[path.length - 1] : '')),
        React.createElement("div", { className: `${classes.content} ${loading ? 'loading' : ''}` },
            React.createElement(AutoSizer, null, ({ height, width }) => (React.createElement(FixedSizeList, { height: height, itemCount: directoryItems.length, itemSize: 32, width: width }, Row))))));
    return (React.createElement(Popover, { enterExitTransitionDurationMs: 0, isOpen: open, preferPlace: "above", body: popoverBody, onOuterAction: () => setOpen(false) },
        React.createElement("div", { onClick: openPopover }, children)));
};
const ListItem = ({ directoryItem, onClick, style }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.listItem, onClick: onClick, style: style },
        React.createElement("div", { className: classes.iconContainer },
            directoryItem.type === 'file' && React.createElement("i", { className: `${classes.fileIcon} material-icons` }, "attachment"),
            directoryItem.type === 'dir' && React.createElement("i", { className: `${classes.dirIcon} material-icons` }, "folder")),
        React.createElement("div", { className: classes.textContainer }, directoryItem.name)));
};
export const FilePickerPopover = withRequestAPI(_FilePickerPopover);
