"""
    Merge ATS API

    The unified API for building rich integrations with multiple Applicant Tracking System platforms.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: hello@merge.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from MergeATSClient.api_client import ApiClient, Endpoint as _Endpoint
from MergeATSClient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from MergeATSClient.model.application import Application
from MergeATSClient.model.application_endpoint_request import ApplicationEndpointRequest
from MergeATSClient.model.application_response import ApplicationResponse
from MergeATSClient.model.paginated_application_list import PaginatedApplicationList


class ApplicationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __applications_create(
            self,
            x_account_token,
            application_endpoint_request,
            **kwargs
        ):
            """applications_create  # noqa: E501

            Creates an `Application` object with the given values.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.applications_create(x_account_token, application_endpoint_request, async_req=True)
            >>> result = thread.get()

            Args:
                x_account_token (str): Token identifying the end user.
                application_endpoint_request (ApplicationEndpointRequest):

            Keyword Args:
                run_async (bool): Whether or not third-party updates should be run asynchronously.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['x_account_token'] = \
                x_account_token
            kwargs['application_endpoint_request'] = \
                application_endpoint_request
            return self.call_with_http_info(**kwargs)

        self.applications_create = _Endpoint(
            settings={
                'response_type': (ApplicationResponse,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/applications',
                'operation_id': 'applications_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_account_token',
                    'application_endpoint_request',
                    'run_async',
                ],
                'required': [
                    'x_account_token',
                    'application_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_account_token':
                        (str,),
                    'application_endpoint_request':
                        (ApplicationEndpointRequest,),
                    'run_async':
                        (bool,),
                },
                'attribute_map': {
                    'x_account_token': 'X-Account-Token',
                    'run_async': 'run_async',
                },
                'location_map': {
                    'x_account_token': 'header',
                    'application_endpoint_request': 'body',
                    'run_async': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__applications_create
        )

        def __applications_list(
            self,
            x_account_token,
            **kwargs
        ):
            """applications_list  # noqa: E501

            Returns a list of `Application` objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.applications_list(x_account_token, async_req=True)
            >>> result = thread.get()

            Args:
                x_account_token (str): Token identifying the end user.

            Keyword Args:
                candidate_id (str): If provided, will only return applications for this candidate.. [optional]
                created_after (datetime): If provided, will only return objects created after this datetime.. [optional]
                created_before (datetime): If provided, will only return objects created before this datetime.. [optional]
                credited_to_id (str): If provided, will only return applications credited to this user.. [optional]
                current_stage_id (str): If provided, will only return applications at this interview stage.. [optional]
                cursor (str): The pagination cursor value.. [optional]
                expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
                include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
                job_id (str): If provided, will only return applications for this job.. [optional]
                modified_after (datetime): If provided, will only return objects modified after this datetime.. [optional]
                modified_before (datetime): If provided, will only return objects modified before this datetime.. [optional]
                page_size (int): Number of results to return per page.. [optional]
                reject_reason_id (str): If provided, will only return applications with this reject reason.. [optional]
                remote_id (str, none_type): The API provider's ID for the given object.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedApplicationList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['x_account_token'] = \
                x_account_token
            return self.call_with_http_info(**kwargs)

        self.applications_list = _Endpoint(
            settings={
                'response_type': (PaginatedApplicationList,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/applications',
                'operation_id': 'applications_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_account_token',
                    'candidate_id',
                    'created_after',
                    'created_before',
                    'credited_to_id',
                    'current_stage_id',
                    'cursor',
                    'expand',
                    'include_remote_data',
                    'job_id',
                    'modified_after',
                    'modified_before',
                    'page_size',
                    'reject_reason_id',
                    'remote_id',
                ],
                'required': [
                    'x_account_token',
                ],
                'nullable': [
                    'remote_id',
                ],
                'enum': [
                    'expand',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "CANDIDATE": "candidate",
                        "CANDIDATE,CREDITED_TO": "candidate,credited_to",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE": "candidate,credited_to,current_stage",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,credited_to,current_stage,reject_reason",
                        "CANDIDATE,CREDITED_TO,REJECT_REASON": "candidate,credited_to,reject_reason",
                        "CANDIDATE,CURRENT_STAGE": "candidate,current_stage",
                        "CANDIDATE,CURRENT_STAGE,REJECT_REASON": "candidate,current_stage,reject_reason",
                        "CANDIDATE,JOB": "candidate,job",
                        "CANDIDATE,JOB,CREDITED_TO": "candidate,job,credited_to",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE": "candidate,job,credited_to,current_stage",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,job,credited_to,current_stage,reject_reason",
                        "CANDIDATE,JOB,CREDITED_TO,REJECT_REASON": "candidate,job,credited_to,reject_reason",
                        "CANDIDATE,JOB,CURRENT_STAGE": "candidate,job,current_stage",
                        "CANDIDATE,JOB,CURRENT_STAGE,REJECT_REASON": "candidate,job,current_stage,reject_reason",
                        "CANDIDATE,JOB,REJECT_REASON": "candidate,job,reject_reason",
                        "CANDIDATE,REJECT_REASON": "candidate,reject_reason",
                        "CREDITED_TO": "credited_to",
                        "CREDITED_TO,CURRENT_STAGE": "credited_to,current_stage",
                        "CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "credited_to,current_stage,reject_reason",
                        "CREDITED_TO,REJECT_REASON": "credited_to,reject_reason",
                        "CURRENT_STAGE": "current_stage",
                        "CURRENT_STAGE,REJECT_REASON": "current_stage,reject_reason",
                        "JOB": "job",
                        "JOB,CREDITED_TO": "job,credited_to",
                        "JOB,CREDITED_TO,CURRENT_STAGE": "job,credited_to,current_stage",
                        "JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "job,credited_to,current_stage,reject_reason",
                        "JOB,CREDITED_TO,REJECT_REASON": "job,credited_to,reject_reason",
                        "JOB,CURRENT_STAGE": "job,current_stage",
                        "JOB,CURRENT_STAGE,REJECT_REASON": "job,current_stage,reject_reason",
                        "JOB,REJECT_REASON": "job,reject_reason",
                        "REJECT_REASON": "reject_reason"
                    },
                },
                'openapi_types': {
                    'x_account_token':
                        (str,),
                    'candidate_id':
                        (str,),
                    'created_after':
                        (datetime,),
                    'created_before':
                        (datetime,),
                    'credited_to_id':
                        (str,),
                    'current_stage_id':
                        (str,),
                    'cursor':
                        (str,),
                    'expand':
                        (str,),
                    'include_remote_data':
                        (bool,),
                    'job_id':
                        (str,),
                    'modified_after':
                        (datetime,),
                    'modified_before':
                        (datetime,),
                    'page_size':
                        (int,),
                    'reject_reason_id':
                        (str,),
                    'remote_id':
                        (str, none_type,),
                },
                'attribute_map': {
                    'x_account_token': 'X-Account-Token',
                    'candidate_id': 'candidate_id',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'credited_to_id': 'credited_to_id',
                    'current_stage_id': 'current_stage_id',
                    'cursor': 'cursor',
                    'expand': 'expand',
                    'include_remote_data': 'include_remote_data',
                    'job_id': 'job_id',
                    'modified_after': 'modified_after',
                    'modified_before': 'modified_before',
                    'page_size': 'page_size',
                    'reject_reason_id': 'reject_reason_id',
                    'remote_id': 'remote_id',
                },
                'location_map': {
                    'x_account_token': 'header',
                    'candidate_id': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'credited_to_id': 'query',
                    'current_stage_id': 'query',
                    'cursor': 'query',
                    'expand': 'query',
                    'include_remote_data': 'query',
                    'job_id': 'query',
                    'modified_after': 'query',
                    'modified_before': 'query',
                    'page_size': 'query',
                    'reject_reason_id': 'query',
                    'remote_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__applications_list
        )

        def __applications_retrieve(
            self,
            x_account_token,
            id,
            **kwargs
        ):
            """applications_retrieve  # noqa: E501

            Returns an `Application` object with the given `id`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.applications_retrieve(x_account_token, id, async_req=True)
            >>> result = thread.get()

            Args:
                x_account_token (str): Token identifying the end user.
                id (str):

            Keyword Args:
                expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
                include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['x_account_token'] = \
                x_account_token
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.applications_retrieve = _Endpoint(
            settings={
                'response_type': (Application,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/applications/{id}',
                'operation_id': 'applications_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_account_token',
                    'id',
                    'expand',
                    'include_remote_data',
                ],
                'required': [
                    'x_account_token',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'expand',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "CANDIDATE": "candidate",
                        "CANDIDATE,CREDITED_TO": "candidate,credited_to",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE": "candidate,credited_to,current_stage",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,credited_to,current_stage,reject_reason",
                        "CANDIDATE,CREDITED_TO,REJECT_REASON": "candidate,credited_to,reject_reason",
                        "CANDIDATE,CURRENT_STAGE": "candidate,current_stage",
                        "CANDIDATE,CURRENT_STAGE,REJECT_REASON": "candidate,current_stage,reject_reason",
                        "CANDIDATE,JOB": "candidate,job",
                        "CANDIDATE,JOB,CREDITED_TO": "candidate,job,credited_to",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE": "candidate,job,credited_to,current_stage",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,job,credited_to,current_stage,reject_reason",
                        "CANDIDATE,JOB,CREDITED_TO,REJECT_REASON": "candidate,job,credited_to,reject_reason",
                        "CANDIDATE,JOB,CURRENT_STAGE": "candidate,job,current_stage",
                        "CANDIDATE,JOB,CURRENT_STAGE,REJECT_REASON": "candidate,job,current_stage,reject_reason",
                        "CANDIDATE,JOB,REJECT_REASON": "candidate,job,reject_reason",
                        "CANDIDATE,REJECT_REASON": "candidate,reject_reason",
                        "CREDITED_TO": "credited_to",
                        "CREDITED_TO,CURRENT_STAGE": "credited_to,current_stage",
                        "CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "credited_to,current_stage,reject_reason",
                        "CREDITED_TO,REJECT_REASON": "credited_to,reject_reason",
                        "CURRENT_STAGE": "current_stage",
                        "CURRENT_STAGE,REJECT_REASON": "current_stage,reject_reason",
                        "JOB": "job",
                        "JOB,CREDITED_TO": "job,credited_to",
                        "JOB,CREDITED_TO,CURRENT_STAGE": "job,credited_to,current_stage",
                        "JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "job,credited_to,current_stage,reject_reason",
                        "JOB,CREDITED_TO,REJECT_REASON": "job,credited_to,reject_reason",
                        "JOB,CURRENT_STAGE": "job,current_stage",
                        "JOB,CURRENT_STAGE,REJECT_REASON": "job,current_stage,reject_reason",
                        "JOB,REJECT_REASON": "job,reject_reason",
                        "REJECT_REASON": "reject_reason"
                    },
                },
                'openapi_types': {
                    'x_account_token':
                        (str,),
                    'id':
                        (str,),
                    'expand':
                        (str,),
                    'include_remote_data':
                        (bool,),
                },
                'attribute_map': {
                    'x_account_token': 'X-Account-Token',
                    'id': 'id',
                    'expand': 'expand',
                    'include_remote_data': 'include_remote_data',
                },
                'location_map': {
                    'x_account_token': 'header',
                    'id': 'path',
                    'expand': 'query',
                    'include_remote_data': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__applications_retrieve
        )
