SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
--SET row_security = off;

SET search_path = ref_nomenclatures, pg_catalog, public;

-- TODO: virer l’id type en dur …
INSERT INTO bib_nomenclatures_types (id_type, mnemonique, label_fr, definition_fr, source, statut, meta_create_date, meta_update_date) VALUES
(2, 'DS_PUBLIQUE', 'Code d''origine de la donnée', 'Nomenclature des codes d''origine de la donnée : publique, privée, mixte...', 'SINP', 'Validé',  '2013-12-05 00:00:00', '2013-12-05 00:00:00')
,(3, 'NAT_OBJ_GEO', 'Nature d''objet géographique', 'Nomenclature des natures d''objets géographiques', 'SINP', 'Validé',  '2014-01-22 00:00:00', '2015-10-15 00:00:00')
,(4, 'DEE_FLOU', 'Existence d''un floutage sur la donnée', 'Nomenclature indiquant l''existence d''un floutage sur la donnée lors de sa création en tant que DEE.', 'SINP', 'Validé',  '2015-09-18 00:00:00', '2015-10-15 00:00:00')
,(5, 'NIV_PRECIS', 'Niveaux de précision de diffusion souhaités', 'Nomenclature des niveaux de précision de diffusion souhaités par le producteur.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-10-15 00:00:00')
,(6, 'OBJ_DENBR', 'Objet du dénombrement', 'Nomenclature des objets qui peuvent être dénombrés', 'SINP', 'Validé',  '2014-01-22 00:00:00', '2015-10-15 00:00:00')
,(7, 'ETA_BIO', 'Etat biologique de l''observation', 'Nomenclature des états biologiques de l''observation.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-10-19 00:00:00')
,(8, 'NATURALITE', 'Niveau de naturalité', 'Nomenclature des niveaux de naturalité', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-10-19 00:00:00')
,(9, 'SEXE', 'Sexe', 'Nomenclature des sexes', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-10-19 00:00:00')
,(10, 'STADE_VIE', 'Stade de vie : stade de développement du sujet', 'Nomenclature des stades de vie : stades de développement du sujet de l''observation.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2016-03-24 00:00:00')
,(11, 'STAT_BIOGEO', 'Statut biogéographique', 'Nomenclature des statuts biogéographiques.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-10-15 00:00:00')
,(12, 'REF_HAB', 'Référentiels d''habitats et typologies', 'Nomenclature des référentiels d''habitats et typologies utilisés pour rapporter un habitat au sein du standard. La référence à paraître prochainement est HABREF. http://inpn.mnhn.fr/telechargement/referentiels/habitats Les typologies sont disponibles à la même adresse, mais seront prochainement à l''adresse suivante : http://inpn.mnhn.fr/telechargement/referentiels/habitats/typologies', 'SINP', 'Validé',  '2013-03-13 00:00:00', '2016-06-23 00:00:00')
,(13, 'STATUT_BIO', 'Statut biologique', 'Nomenclature des statuts biologiques.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-12-16 00:00:00')
,(14, 'METH_OBS', 'Méthodes d''observation', 'Nomenclature des méthodes d''observation, indiquant de quelle manière ou avec quel indice on a pu observer le sujet.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-12-16 00:00:00')
,(15, 'PREUVE_EXIST', 'Preuve existante', 'Nomenclature de l''existence des preuves.', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2015-12-16 00:00:00')
,(16, 'SENSIBILITE', 'Niveaux de sensibilité', 'Nomenclature des niveaux de sensibilité possibles', 'SINP', 'Validé',  '2015-06-10 00:00:00', '2016-06-23 00:00:00')
,(17, 'SENSIBLE', 'Valeurs de sensibilité qualitative', 'Nomenclature des valeurs de sensibilité qualitative (oui/non)', 'SINP', 'Validé',  '2015-07-29 00:00:00', '2016-04-07 00:00:00')
,(18, 'STATUT_OBS', 'Statut d''observation', 'Nomenclature des statuts d''observation.', 'SINP', 'Validé',  '2013-12-05 00:00:00', '2016-03-24 00:00:00')
,(19, 'STATUT_SOURCE', 'Statut de la source', 'Nomenclature des statuts possibles de la source.', 'SINP', 'Validé',  '2013-12-04 00:00:00', '2013-12-04 00:00:00')
,(20, 'TYP_ATTR', 'Type de l''attribut', 'Nomenclature des types d''attributs additionnels.', 'SINP', 'Validé',  '2015-09-16 00:00:00', '2015-12-07 00:00:00')
,(21, 'TYP_DENBR', 'Type de dénombrement', 'Nomenclature des types de dénombrement possibles (comptage, estimation...)', 'SINP', 'Validé',  '2014-01-22 00:00:00', '2015-12-16 00:00:00')
,(22, 'TYP_EN', 'Type d''espace naturel', 'Nomenclature des types d''espaces naturels.', 'SINP', 'Validé',  '2014-01-22 00:00:00', '2016-06-15 00:00:00')
,(23, 'TYP_INF_GEO', 'Type d''information géographique', 'Nomenclature des types d''information géographique dans le cas de l''utilisation d''un rattachement à un objet géographique (commune, département, espace naturel, masse d''eau...).', 'SINP', 'Validé',  '2015-09-18 00:00:00', '2015-12-16 00:00:00')
,(24, 'TYP_GRP', 'Type de regroupement', 'Nomenclature listant les valeurs possibles pour le type de regroupement.', 'SINP', 'Validé',  '2015-06-09 00:00:00', '2015-12-07 00:00:00')
,(25, 'VERS_ME', 'Version des masses d''eau', 'Nomenclature des versions du référentiel SANDRE utilisé pour les masses d''eau.', 'SINP', 'Validé',  '2015-09-18 00:00:00', '2015-12-16 00:00:00')
,(26, 'ACC2', 'Raison de niveau d''accessibilité', 'Nomenclature des raisons d''un niveau d''accessibilité', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(27, 'ACC', 'Niveau d''accessibilité', 'Nomenclature des niveaux d''accessibilité à un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(28, 'AUTPREAL', 'Autorisation préalable pour accès', 'Nomenclature des valeurs concernant l''éventuelle délivrance d''une autorisation préalable pour accéder à un site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(29, 'GILGES', 'Code Gilges', 'Nomenclature des codes Gilges', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(30, 'REGION', 'Code région', 'Nomenclature des codes région', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(31, 'CONFID', 'Valeur de confidentialité', 'Nomenclatures des valeurs de confidentialité', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(32, 'COUPGEOL', 'Présence/absence de coupe géologique', 'Nomenclature de présence/absence de coupe géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(33, 'ETAT1', 'Niveau d''état d''un site géologique', 'Nomenclature des niveaux d''état potentiels d''un site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(34, 'ETAT2', 'Raison du niveau d''état d''un site géologique', 'Nomenclature indiquant les raisons du niveau d''état du site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(35, 'EXISTPROT', 'Existence d''une protection pour un site géologique', 'Nomenclature indiquant si une protection existe ou non', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(36, 'INTGEOL', 'Intérêt géologique du site géologique', 'Nomenclature des intérêts géologiques que peut avoir un site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(37, 'INTSECTYP', 'Type d''intérêt secondaire du site géologique', 'Nomenclature des types d''intérêt secondaire potentiels d''un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(38, 'INTSEC', 'Intérêt secondaire du site géologique', 'Nomenclature des intérêts secondaires potentiels, fonction des types d''intérêts secondaires.', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(39, 'MODIF', 'Statut de modification de fiche de site géologique', 'Nomenclature des statuts de modification de fiche de site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(40, 'PAY', 'Paiement spécifique à l''accès du site géologique', 'Nomenclature qui indique si un site nécessite un paiement spécifique pour y accéder', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(41, 'PEROUV', 'Périodes d''ouverture du site géologique', 'Nomenclature des périodes d''ouverture d''un site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(42, 'PHENGEOL', 'Phénomène géologique', 'Nomenclature des phénomènes géologiques', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(43, 'RARETE', 'Niveau de rareté du site géologique', 'Nomenclature des niveaux de rareté pour les sites géologiques', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(44, 'JUR1', 'Statut de protection, éléments primaires, pour un site géologique', 'Nomenclature des statuts de protection, éléments primaires', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(45, 'JUR2', 'Statut de protection, éléments secondaires, pour un site géologique', 'Nomenclature des statuts de protection, éléments secondaires', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(46, 'PROT1', 'Type générique de statut de protection pour un site géologique', 'Nomenclature des types génériques (ou primaires) de statuts de protection et/ou de gestion', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(47, 'PROT2', 'Type spécifique de statut de protection pour un site  géologique', 'Nomenclature des types spécifiques (ou secondaires) de statuts de protection et/ou gestion d''un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(48, 'VALNAT', 'Statut de validation nationale pour un site géologique', 'Nomenclature des statuts de validation nationaux pour un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(49, 'VALREG', 'Statut de validation régionale pour un site géologique', 'Nomenclature des statuts de validation régionaux pour le site considéré.', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(50, 'DOC', 'Type de document', 'Nomenclature des types de documents', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(51, 'INVGEOL', 'Type d''inventaire géologique', 'Nomenclature des types d''inventaires géologiques pouvant être réalisés sur un site', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-09-01 00:00:00')
,(52, 'TYPPERS', 'Intervenant fiche (type de personne)', 'Nomenclature des types de personnes ayant pu intervenir sur une fiche de site géologique, de quelque manière que ce soit, ou types de personnes.', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(53, 'TYPO1', 'Typologie primaire d''un site géologique', 'Nomenclature des éléments de typologie primaire d''un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(54, 'TYPO2', 'Typologie secondaire d''un site géologique', 'Nomenclature des éléments secondaires de typologie du site géologique. Certains éléments de cette liste sont restreints à certains éléments primaires uniquement (cf. nomenclature 53).', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(55, 'TYPO3', 'Typologie tertiaire d''un site géologique', 'Nomenclature des éléments tertiaires de typologie du site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(56, 'UNITSURF', 'Unité de superficie pour un site géologique', 'Nomenclature des unités de superficie pouvant être utilisées pour indiquer la surface d''un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(57, 'USEACTU', 'Usage d''un site géologique', 'Nomenclature des usages qui peuvent être faits d''un site géologique', 'SINP', 'Validé',  '2016-04-07 00:00:00', '2016-04-08 00:00:00')
,(58, 'AIRECONNUE', 'Aire connue', 'Nomenclature des valeurs indiquant si la surface d''un relevé est connue ou non', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(59, 'BRANCHEMETH', 'Méthodes phytosociologiques, branches', 'Nomenclature des branches de méthodes phytosociologiques', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(60, 'BRAUNBLANQABDOM', 'Braun Blanquet Pavillard, abondance-dominance', 'Nomenclature des valeurs pour l''échelle d''abondance-dominance de Braun-Blanquet Pavillard (1928)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(61, 'BRAUNBARK', 'Braun Blanquet Barkman, abondance-dominance', 'Nomenclature des valeurs de l''échelle de Braun-Blanquet Barkman complétée telle que dans le dictionnaire de sociologie et synécologie végétales (Géhu, 2006)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(62, 'BRAUNPAV', 'Braun Blanquet Pavillard, abondance', 'Nomenclature des valeurs de l''échelle d''abondance de Braun-Blanquet Pavillard (1928)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(63, 'COMPLETREL', 'Complétude des relevés', 'Nomenclature des valeurs de complétude des relevés phytosociologiques détaillés', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(64, 'RATTACH', 'Rattachement au syntaxon, confère', 'Nomenclature des indicateurs de doute dans le rattachement au syntaxon (confère).', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(65, 'DOMIN', 'Echelle de Domin', 'Nomenclature des valeurs de l''échelle de Domin (Source : Evans & Dahl, 1955)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(66, 'EXPOSITION', 'Exposition d''un terrain', 'Nomenclature des points cardinaux et intercardinaux permettant d''indiquer l''exposition d''un terrain.', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(67, 'FORMES', 'Formes du relevé', 'Nomenclature des formes possibles pour un relevé phytosociologique', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(68, 'LONDO', 'Echelle de Londo', 'Nomenclature des valeurs de l''échelle d''abondance-dominnance de Londo suivant Londo, 1976 (The decimal scale for releves of permanent quadrats)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(69, 'NIVORGA', 'Niveaux d''organisation des relevés', 'Nomenclature des niveaux d''organisation auxquels peuvent se trouver des relevés phytosociologiques détaillés', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(70, 'ORDIN', 'Echelle ordinale', 'Nomenclature des valeurs de l''échelle ordinale d''abondance-dominance, suivant Barkman (1964)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(71, 'PRES', 'Présence', 'Nomenclature des cas de présence d''un taxon', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(72, 'SOCIAB', 'Sociabilité', 'Nomenclature des valeurs de sociabilité des taxons végétaux suivant Braun Blanquet (1964)', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(73, 'TYPEAIRE', 'Types de surface', 'Nomenclature des types de surfaces utilisées pour les relevés phytosociologiques', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(74, 'TYPCORR', 'Type de correspondance avec le syntaxon', 'Nomenclature des types de correspondance entre relevés synusiaux et syntaxons sigmatistes', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(75, 'TYPECH', 'Type d''échelle', 'Nomenclature des types d''échelles utilisées pour l''évaluation d''un paramètre de taxon en phytosociologie', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(76, 'TYPEPARM', 'Paramètres suivis pour un taxon, phytosociologie', 'Nomenclature des types de paramètres potentiellement suivis pour un taxon en phytosociologie', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(77, 'UNITOP', 'Unités opérationnelles', 'Liste des modifications morphologiques végétales particulières, génétiquement non fixées (unités morphologiques opérationnelles, unités biologiques opérationnelles, et/ou accommodats), imposées par le milieu', 'SINP', 'Validé',  '2016-06-21 00:00:00', '2016-06-21 00:00:00')
,(0, 'ROOT', 'Racine des nomenclatures', 'Racine. Parent de toutes les nomenclatures', 'GEONATURE', 'Non validé', '2017-06-15 12:51:30.197042', '2017-06-15 12:51:30.197042')
,(100, 'TECHNIQUE_OBS', 'Techniques d''observation', 'Une technique désigne l''ensemble des savoirs-faire, procédés et outils spécifiques, mobilisés de manière logique (règles, étapes et principes) pour collecter des données associées à un paramètre à observer ou à un facteur écologique à prendre en compte. Ce sont les moyens mis en oeuvre sur le terrain pour l''observation d''espèces ou d''habitats. Une technique est définie par rapport à une cible. Dans le cadre d''un protocole, elle doit être reproductible dans le temps et dans l''espace.', 'CAMPANULE', 'Validation en cours', '2017-06-19 15:03:31.135525', '2017-06-19 15:03:31.135525')
,(101, 'STATUT_VALID', 'Statut de validation', 'Nomenclature des statuts de validations de la données', 'GEONATURE', 'Non validé', '2017-08-08 00:00:00', '2017-08-08 00:00:00')
,(102, 'RESOURCE_TYP', 'Type de ressources', 'Nomenclature des types de ressources relatifs aux jeux de données', 'SINP', 'Validé', '2017-10-16 00:00:00', '2017-10-16 00:00:00')
,(103, 'DATA_TYP', 'Type de données', 'Nomenclature des types de données SINP relatifs aux jeux de données', 'SINP', 'Validé', '2017-10-16 00:00:00', '2017-10-16 00:00:00')
,(104, 'SAMPLING_PLAN_TYP', 'Type de plan d''échantillonnage', 'Processus de sélection des unités d''échantillonnage sur lesquelles sont effectuées les mesures des paramètres prévus dans le protocole', 'SINP', 'Validé', '2017-10-16 00:00:00', '2017-10-16 00:00:00')
,(105, 'SAMPLING_UNITS_TYP', 'Type d''unités d''échantillonnage', 'L''unité d''échantillonnage désigne l''unité sur laquelle sont mesurés les paramètres étudiés', 'SINP', 'Validé', '2017-10-16 00:00:00', '2017-10-16 00:00:00')
,(106, 'METH_DETERMIN', 'Méthode de détermination', 'Nomenclature des méthodes de détermination, indiquant quelle méthode a été utilisée pour déterminer le sujet.', 'GEONATURE', 'Non validé', '2017-10-26 00:00:00', '2017-10-26 00:00:00')
,(107, 'NIVEAU_TERRITORIAL', 'Niveau Territorial', 'Nomenclature des valeurs pour le niveau territorial.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(108, 'CA_OBJECTIFS', 'Objectif du cadre d''acquisition', 'Nomenclature des valeurs permises pour les objectifs du cadre d''acquisition.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(109, 'ROLE_ACTEUR', 'Role de l''Acteur', 'Liste des types de rôles pour les acteurs. Chaque valeur correspond exactement à une valeur de la norme ISO 19115. Cela est précisé pour chacune d''entre elles.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(110, 'TERRITOIRE', 'Territoire', 'Nomenclature des territoires.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(111, 'TYPE_FINANCEMENT', 'Type de financement', 'Nomenclature des types de financement.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(112, 'TYPE_PROTOCOLE', 'Type de protocole', 'Nomenclature des types de protocles.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(113, 'VOLET_SINP', 'Volet SINP', 'Nomenclature des volets que peut viser le SINP.', 'SINP', 'Validé', '2017-10-30 00:00:00', '2017-10-30 00:00:00')
,(114, 'JDD_OBJECTIFS', 'Objectif du jeu de données', 'Nomenclature des valeurs permises pour les objectifs du jeu de données.', 'SINP', 'Validé', '2017-11-02 00:00:00', '2017-11-02 00:00:00')
,(115, 'METHO_RECUEIL', 'Méthode de recueil des données', 'Nomenclature de l''ensemble de techniques, savoir-faire et outils mobilisés pour collecter des données.', 'SINP', 'Validé', '2017-11-02 00:00:00', '2017-11-02 00:00:00')
,(116, 'TYPE_SITE', 'Type de sites', 'Nomenclature des types de sites suivi dans gn_monitoring.', 'GEONATURE', 'Non validé', '2018-03-13 00:00:00', '2018-03-13 00:00:00')
,(117, 'TYPE_MEDIA', 'Type de médias', 'Nomenclature des types de médias.', 'GEONATURE', 'Non validé', '2018-04-12 00:00:00', '2018-04-12 00:00:00')
,(118, 'DETERMINATION_TYP_HAB', 'Type de détermination de l''habitat', 'Nomenclature des types de détermination de l''habitat', 'SINP', 'Validé', '2018-05-14 00:00:00', '2018-05-14 00:00:00')
,(119, 'TECHNIQUE_COLLECT_HAB', 'Technique de collecte de l''information habitats', 'Nomenclature des techniques de collectes ayant présidé à l''obtention de l''information sur l''habitat', 'SINP', 'Validé', '2017-09-29 00:00:00', '2017-09-29 00:00:00')
,(120, 'ABONDANCE_HAB', 'Abondance des habitats', 'Nomenclature des coefficients de Braun-Blanquet et Pavillard adaptés pour décrire l''abondance relative des habitats au sein d''une station', 'SINP', 'Validé', '2017-09-29 00:00:00', '2017-09-29 00:00:00')
,(121, 'HAB_INTERET_COM', 'Habitat d''intérêt communautaire', 'Nomenclature des valeurs permettant d''indiquer si un habitat est d''intérêt communautaire', 'SINP', 'Validé', '2017-09-29 00:00:00', '2017-09-29 00:00:00')
,(122, 'METHOD_CALCUL_SURFACE', 'Méthode de calcul de surface', 'Nomenclature des types de détermination d''une surface', 'SINP', 'Validé', '2017-09-29 00:00:00', '2017-09-29 00:00:00')
,(124, 'OCC_COMPORTEMENT', 'Comportement des occurrences observées', 'Nomenclature des domportement des occurrences observées', 'SINP', 'Validé', '2018-05-09 00:00:00', '2018-05-09 00:00:00');
;

SELECT setval('ref_nomenclatures.bib_nomenclatures_types_id_type_seq', (SELECT max(id_type) FROM ref_nomenclatures.bib_nomenclatures_types), true);


UPDATE bib_nomenclatures_types SET label_default = label_fr;
UPDATE bib_nomenclatures_types SET definition_default = definition_fr;
ALTER TABLE bib_nomenclatures_types ALTER COLUMN label_default SET NOT NULL;
ALTER TABLE bib_nomenclatures_types ALTER COLUMN label_fr SET NOT NULL;

--la séquence commence à 1, le cas particulier de la nomenclature 0 est insérer sans la séquence.
INSERT INTO t_nomenclatures (id_nomenclature,id_type, cd_nomenclature, mnemonique, label_fr, definition_fr,  source, statut, id_broader, hierarchy, meta_create_date, meta_update_date, active) VALUES
(0,get_id_nomenclature_type('ROOT'), '0', 'Root', 'Racine des nomenclatures', 'Racine = Parent de toutes les nomenclatures', 'GEONATURE', 'non validé', 0, '000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true);

INSERT INTO t_nomenclatures (id_type, cd_nomenclature, mnemonique, label_fr, definition_fr,  source, statut, id_broader, hierarchy, meta_create_date, meta_update_date, active) VALUES
(get_id_nomenclature_type('STADE_VIE'), '0', 'Inconnu', 'Inconnu', 'Le stade de vie de l''individu n''est pas connu.', 'SINP', 'Validé', 0, '010.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '1', 'Indéterminé', 'Indéterminé', 'Le stade de vie de l''individu n''a pu être déterminé (observation insuffisante pour la détermination).', 'SINP', 'Validé', 0, '010.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '2', 'Adulte', 'Adulte', 'L''individu est au stade adulte.', 'SINP', 'Validé', 0, '010.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '3', 'Juvénile', 'Juvénile', 'L''individu n''a pas encore atteint le stade adulte. C''est un individu jeune.', 'SINP', 'Validé', 0, '010.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '4', 'Immature', 'Immature', 'Individu n''ayant pas atteint sa maturité sexuelle.', 'SINP', 'Validé', 0, '010.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '5', 'Sub-adulte', 'Sub-adulte', 'Individu ayant presque atteint la taille adulte mais qui n''est pas considéré en tant que tel par ses congénères.', 'SINP', 'Validé', 0, '010.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '6', 'Larve', 'Larve', 'Individu dans l''état où il est en sortant de l''œuf, état dans lequel il passe un temps plus ou moins long avant métamorphose.', 'SINP', 'Validé', 0, '010.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '7', 'Chenille', 'Chenille', 'Larve éruciforme des lépidoptères ou papillons.', 'SINP', 'Validé', 0, '010.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '8', 'Têtard', 'Têtard', 'Larve de batracien.', 'SINP', 'Validé', 0, '010.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '9', 'Œuf', 'Œuf', 'L''individu se trouve dans un œuf, ou au sein d''un regroupement d''œufs (ponte)', 'SINP', 'Validé', 0, '010.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '10', 'Mue', 'Mue', 'L''individu est en cours de mue (pour les reptiles : renouvellement de la peau, pour les oiseaux/mammifères : renouvellement du plumage/pelage, pour les cervidés : chute des bois).', 'SINP', 'Validé', 0, '010.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '11', 'Exuvie', 'Exuvie', 'L''individu est en cours d''exuviation : l''exuvie est une enveloppe (cuticule chitineuse ou peau) que le corps de l''animal a quittée lors de la mue ou de la métamorphose.', 'SINP', 'Validé', 0, '010.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '12', 'Chrysalide', 'Chrysalide', 'Nymphe des lépidoptères ou papillons.', 'SINP', 'Validé', 0, '010.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '13', 'Nymphe', 'Nymphe', 'Stade de développement intermédiaire, entre larve et imago, pendant lequel l''individu ne se nourrit pas.', 'SINP', 'Validé', 0, '010.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '14', 'Pupe', 'Pupe', 'Nymphe des diptères.', 'SINP', 'Validé', 0, '010.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '15', 'Imago', 'Imago', 'Stade final d''un individu dont le développement se déroule en plusieurs phases (en général, œuf, larve, imago).', 'SINP', 'Validé', 0, '010.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '16', 'Sub-imago', 'Sub-imago', 'Stade de développement chez certains insectess : insecte mobile, incomplet et sexuellement immature, bien qu''évoquant assez fortement la forme définitive de l''adulte, l''imago.', 'SINP', 'Validé', 0, '010.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '17', 'Alevin', 'Alevin', 'L''individu, un poisson, est à un stade juvénile.', 'SINP', 'Validé', 0, '010.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '18', 'Germination', 'Germination', 'L''individu est en cours de germination.', 'SINP', 'Validé', 0, '010.018', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '19', 'Fané', 'Fané', 'L''individu est altéré dans ses couleurs et sa fraîcheur, par rapport à un individu normal.', 'SINP', 'Validé', 0, '010.019', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '20', 'Graine', 'Graine', 'La graine est la structure qui contient et protège l''embryon végétal.', 'SINP', 'Validé', 0, '010.020', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '21', 'Thalle, protothalle', 'Thalle, protothalle', 'Un thalle est un appareil végétatif ne possédant ni feuilles, ni tiges, ni racines, produit par certains organismes non mobiles.', 'SINP', 'Validé', 0, '010.021', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '22', 'Tubercule', 'Tubercule', 'Un tubercule est un organe de réserve, généralement souterrain, assurant la survie des plantes pendant la saison d''hiver ou en période de sécheresse, et souvent leur multiplication par voie végétative.', 'SINP', 'Validé', 0, '010.022', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '23', 'Bulbe', 'Bulbe', 'Un bulbe est une pousse souterraine verticale disposant de feuilles modifiées utilisées comme organe de stockage de nourriture par une plante à dormance.', 'SINP', 'Validé', 0, '010.023', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '24', 'Rhizome', 'Rhizome', 'Le rhizome est une tige souterraine et parfois subaquatique remplie de réserves alimentaires chez certaines plantes vivaces.', 'SINP', 'Validé', 0, '010.024', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '25', 'Emergent', 'Emergent', 'L''individu est au stade émergent : sortie de l''œuf.', 'SINP', 'Validé', 0, '010.025', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '26', 'Post-Larve', 'Post-Larve', 'Stade qui suit immédiatement celui de la larve et présente certains caractères du juvénile.', 'SINP', 'Validé', 0, '010.026', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STADE_VIE'), '27', 'Fruit', 'Fruit', 'Fruit : L''individu est sous forme de fruit.', 'SINP', 'Validé', 0, '010.027', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('STATUT_BIO'), '0', 'Inconnu', 'Inconnu', 'Inconnu : Le statut biologique de l''individu n''est pas connu.', 'SINP', 'Validé', 0, '013.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '1', 'Non renseigné', 'Non renseigné', 'Non renseigné : Le statut biologique de l''individu n''a pas été renseigné.', 'SINP', 'Validé', 0, '013.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '2', 'Non Déterminé', 'Non Déterminé', 'Non déterminé : Le statut biologique de l''individu n''a pas pu être déterminé.', 'SINP', 'Validé', 0, '013.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '3', 'Reproduction', 'Reproduction', 'Reproduction : Le sujet d''observation en est au stade de reproduction (nicheur, gravide, carpophore, floraison, fructification…)', 'SINP', 'Validé', 0, '013.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '4', 'Hibernation', 'Hibernation', 'Hibernation : L''hibernation est un état d''hypothermie régulée, durant plusieurs jours ou semaines qui permet aux animaux de conserver leur énergie pendant l''hiver. ', 'SINP', 'Validé', 0, '013.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '5', 'Estivation', 'Estivation', 'Estivation : L''estivation est un phénomène analogue à celui de l''hibernation, au cours duquel les animaux tombent en léthargie. L''estivation se produit durant les périodes les plus chaudes et les plus sèches de l''été.', 'SINP', 'Validé', 0, '013.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '9', 'Pas de reproduction', 'Pas de reproduction', 'Pas de reproduction : Indique que l''individu n''a pas un comportement reproducteur. Chez les végétaux : absence de fleurs, de fruits…', 'SINP', 'Validé', 0, '013.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_BIO'), '13', 'Végétatif', 'Végétatif', 'L''individu est au stade végétatif.', 'SINP', 'Validé', 0, '013.013', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('METH_OBS'), '0', 'Vu', 'Vu', 'Observation directe d''un individu vivant.', 'SINP', 'Validé', 0, '014.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '1', 'Entendu', 'Entendu', 'Observation acoustique d''un individu vivant.', 'SINP', 'Validé', 0, '014.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '2', 'Coquilles d''œuf', 'Coquilles d''œuf', 'Observation indirecte via coquilles d''œuf.', 'SINP', 'Validé', 0, '014.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '3', 'Ultrasons', 'Ultrasons', 'Observation acoustique indirecte d''un individu vivant avec matériel spécifique permettant de transduire des ultrasons en sons perceptibles par un humain.', 'SINP', 'Validé', 0, '014.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '4', 'Empreintes', 'Empreintes', 'Observation indirecte via empreintes.', 'SINP', 'Validé', 0, '014.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '5', 'Exuvie', 'Exuvie', 'Observation indirecte : une exuvie.', 'SINP', 'Validé', 0, '014.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '6', 'Fèces/Guano/Epreintes', 'Fèces/Guano/Epreintes', 'Observation indirecte par les excréments', 'SINP', 'Validé', 0, '014.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '7', 'Mues', 'Mues', 'Observation indirecte par des plumes, poils, phanères, peau, bois... issus d''une mue.', 'SINP', 'Validé', 0, '014.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '8', 'Nid/Gîte', 'Nid/Gîte', 'Observation indirecte par présence d''un nid ou d''un gîte non occupé au moment de l''observation.', 'SINP', 'Validé', 0, '014.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '9', 'Pelote de réjection', 'Pelote de réjection', 'Identifie l''espèce ayant produit la pelote de réjection.', 'SINP', 'Validé', 0, '014.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '10', 'Restes dans pelote de réjection', 'Restes dans pelote de réjection', 'Identifie l''espèce à laquelle appartiennent les restes retrouvés dans la pelote de réjection (os ou exosquelettes, par exemple).', 'SINP', 'Validé', 0, '014.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '11', 'Poils/plumes/phanères', 'Poils/plumes/phanères', 'Observation indirecte de l''espèce par ses poils, plumes ou phanères, non nécessairement issus d''une mue.', 'SINP', 'Validé', 0, '014.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '12', 'Restes de repas', 'Restes de repas', 'Observation indirecte par le biais de restes de l''alimentation de l''individu.', 'SINP', 'Validé', 0, '014.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '13', 'Spore', 'Spore', 'Identification d''un individu ou groupe d''individus d''un taxon par l''observation de spores, corpuscules unicellulaires ou pluricellulaires pouvant donner naissance sans fécondation à un nouvel individu. Chez les végétaux, corpuscules reproducteurs donnant des prothalles rudimentaires mâles et femelles (correspondant respectivement aux grains de pollen et au sac embryonnaire), dont les produits sont les gamètes.', 'SINP', 'Validé', 0, '014.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '14', 'Pollen', 'Pollen', 'Observation indirecte d''un individu ou groupe d''individus d''un taxon par l''observation de pollen, poussière très fine produite dans les loges des anthères et dont chaque grain microscopique est un utricule ou petit sac membraneux contenant le fluide fécondant (d''apr. Bouillet 1859).', 'SINP', 'Validé', 0, '014.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '15', 'Oosphère', 'Oosphère', 'Observation indirecte. Cellule sexuelle femelle chez les végétaux qui, après sa fécondation, devient l''oeuf.', 'SINP', 'Validé', 0, '014.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '16', 'Ovule', 'Ovule', 'Observation indirecte. Organe contenant le gamète femelle. Macrosporange des spermaphytes.', 'SINP', 'Validé', 0, '014.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '17', 'Fleur', 'Fleur', 'Identification d''un individu ou groupe d''individus d''un taxon par l''observation  de fleurs. La fleur correspond à un ensemble de feuilles modifiées, en enveloppe florale et en organe sexuel, disposées sur un réceptacle. Un pédoncule la relie à la tige. (ex : chaton).', 'SINP', 'Validé', 0, '014.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '18', 'Feuille', 'Feuille', 'Identification d''un individu ou groupe d''individus d''un taxon par l''observation  de feuilles. Organe aérien très important dans la nutrition de la plante, lieu de la photosynthèse qui aboutit à des composés organiques (sucres, protéines) formant la sève.', 'SINP', 'Validé', 0, '014.018', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '19', 'ADN environnemental', 'ADN environnemental', 'Séquence ADN trouvée dans un prélèvement environnemental (eau ou sol).', 'SINP', 'Validé', 0, '014.019', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '20', 'Autre', 'Autre', 'Pour tout cas qui ne rentrerait pas dans la présente liste. Le nombre d''apparitions permettra de faire évoluer la nomenclature.', 'SINP', 'Validé', 0, '014.020', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '21', 'Inconnu', 'Inconnu', 'Inconnu : La méthode n''est pas mentionnée dans les documents de l''observateur (bibliographie par exemple).', 'SINP', 'Validé', 0, '014.021', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '22', 'Mine', 'Mine', 'Galerie forée dans l''épaisseur d''une feuille, entre l''épiderme supérieur et l''épiderme inférieur par des larves', 'SINP', 'Validé', 0, '014.022', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '23', 'Galerie/terrier', 'Galerie/terrier', 'Observation indirecte : Galerie forée dans le bois, les racines ou les tiges, par des larves (Lépidoptères, Coléoptères, Diptères) ou creusée dans la terre (micro-mammifères, mammifères... ).', 'SINP', 'Validé', 0, '014.023', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '24', 'Oothèque', 'Oothèque', 'Membrane-coque qui protège la ponte de certains insectes et certains mollusques.', 'SINP', 'Validé', 0, '014.024', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '25', 'Vu et entendu', 'Vu et entendu', 'Vu et entendu : l''occurrence a à la fois été vue et entendue.', 'SINP', 'Validé', 0, '014.025', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_OBS'), '26', 'Olfactif', 'Olfactif', 'Contact olfactif : l''occurrence a été sentie sur le lieu d''observation', 'SINP', 'Validé', 0, '014.026', '2020-08-31 00:00:00', '2018-07-04 00:00:00', true)
,(get_id_nomenclature_type('METH_OBS'), '27', 'Empreintes et fèces', 'Empreintes et fèces', 'Empreintes et fèces', 'SINP', 'Validé', 0, '014.027', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('SENSIBILITE'), '0', '0', 'Non sensible - Diffusion précise', 'Donnée non sensible - Diffusion précise', 'SINP', 'Validé', 0, '016.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SENSIBILITE'), '1', '1', 'Sensible - Diffusion à la Commune ou Znieff', 'Sensible - Commune ou Znieff (visible uniquement à partir du niveau)', 'SINP', 'Validé', 0, '016.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SENSIBILITE'), '2', '2', 'Sensible - Diffusion à la maille 10km', 'Sensibile - Mailles 10 (visible uniquement à partir du niveau)', 'SINP', 'Validé', 0, '016.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SENSIBILITE'), '3', '3', 'Sensible - Diffusion au département', 'Sensible - Départements (visible uniquement à partir du niveau)', 'SINP', 'Validé', 0, '016.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SENSIBILITE'), '4', '4', 'Sensible - Aucune diffusion', 'Sensible - Aucune diffusion', 'SINP', 'Validé', 0, '016.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_SOURCE'), 'Co', 'Co', 'Collection', 'Collection : l''observation concerne une base de données de collection.', 'SINP', 'Validé', 0, '019.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_SOURCE'), 'Li', 'Li', 'Littérature', 'Littérature : l''observation a été extraite d''un article ou un ouvrage scientifique.', 'SINP', 'Validé', 0, '019.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_SOURCE'), 'NSP', 'NSP', 'Ne Sait Pas', 'Ne Sait Pas : la source est inconnue.', 'SINP', 'Validé', 0, '019.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_SOURCE'), 'Te', 'Te', 'Terrain', 'Terrain : l''observation provient directement d''une base de données ou d''un document issu de la prospection sur le terrain.', 'SINP', 'Validé', 0, '019.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DS_PUBLIQUE'), 'NSP', 'Ne sait pas', 'Ne sait pas', 'Ne sait pas : L''information indiquant si la Donnée Source est publique ou privée n''est pas connue.', 'SINP', 'Validé', 0, '002.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DS_PUBLIQUE'), 'Pr', 'Privée', 'Privée', 'Privée : La Donnée Source a été produite par un organisme privé ou un individu à titre personnel. Aucun organisme ayant autorité publique n''a acquis les droits patrimoniaux,  la Donnée Source reste la propriété de l''organisme ou de l''individu privé. Seul ce cas autorise un floutage géographique de la DEE.', 'SINP', 'Validé', 0, '002.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DS_PUBLIQUE'), 'Pu', 'Publique', 'Publique', 'Publique : La Donnée Source est publique qu''elle soit produite en « régie » ou « acquise ».', 'SINP', 'Validé', 0, '002.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('PREUVE_EXIST'), '0', 'NSP', 'Inconnu', 'Indique que la personne ayant fourni la donnée ignore s''il existe une preuve, ou qu''il est indiqué dans la donnée qu''il y a eu une preuve qui a pu servir pour la détermination, sans moyen de le vérifier.', 'SINP', 'Validé', 0, '015.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('PREUVE_EXIST'), '1', 'Oui', 'Oui', 'Indique qu''une preuve existe ou a existé pour la détermination, et est toujours accessible.', 'SINP', 'Validé', 0, '015.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('PREUVE_EXIST'), '2', 'Non', 'Non', 'Indique l''absence de preuve.', 'SINP', 'Validé', 0, '015.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('PREUVE_EXIST'), '3', 'NonAcquise', 'Non acquise', 'NonAcquise : La donnée de départ mentionne une preuve, ou non, mais n''est pas suffisamment standardisée pour qu''il soit possible de récupérer des informations. L''information n''est donc pas acquise lors du transfert.', 'SINP', 'Validé', 0, '015.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SENSIBLE'), 'NON', 'Non', 'Non', '"Indique que la donnée n''est pas sensible (par défaut, équivalent au niveau ""0"" des niveaux de sensibilité)."', 'SINP', 'Validé', 0, '017.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SENSIBLE'), 'OUI', 'Oui', 'Oui', 'Indique que la donnée est sensible.', 'SINP', 'Validé', 0, '017.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_OBS'), 'No', 'No', 'Non observé', 'Non Observé : L''observateur n''a pas détecté un taxon particulier, recherché suivant le protocole adéquat à la localisation et à la date de l''observation. Le taxon peut être présent et non vu, temporairement absent, ou réellement absent.', 'SINP', 'Validé', 0, '018.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_OBS'), 'Pr', 'Pr', 'Présent', 'Présent : Un ou plusieurs individus du taxon ont été effectivement observés et/ou des indices témoignant de la présence du taxon', 'SINP', 'Validé', 0, '018.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_OBS'), 'NSP', 'NSP', 'Ne Sait Pas', 'Ne Sait Pas : l''information n''est pas connue', 'SINP', 'Validé', 0, '018.003', '2020-12-22 00:00:00', '2020-12-22 00:00:00', true)

,(get_id_nomenclature_type('TYP_ATTR'), 'QTA', 'QTA', 'Quantitatif', 'Le paramètre est de type quantitatif : il peut être mesuré par une valeur numérique. Exemples : âge précis, taille, nombre de cercles ligneux...', 'SINP', 'Validé', 0, '020.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_ATTR'), 'QUAL', 'QUAL', 'Qualitatif', 'Le paramètre est de type qualitatif : Il décrit une qualité qui ne peut être définie par une quantité numérique. Exemples : individu âgé / individu jeune, eau trouble, milieu clairsemé…', 'SINP', 'Validé', 0, '020.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_DENBR'), 'Ca', 'Ca', 'Calculé', 'Calculé : Dénombrement par opération mathématique', 'SINP', 'Validé', 0, '021.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_DENBR'), 'Co', 'Co', 'Compté', 'Compté : Dénombrement par énumération des individus', 'SINP', 'Validé', 0, '021.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_DENBR'), 'Es', 'Es', 'Estimé', 'Estimé : Dénombrement qualifié d''estimé lorsque le produit concerné n''a fait l''objet d''aucune action de détermination de cette valeur du paramètre par le biais d''une technique de mesure.', 'SINP', 'Validé', 0, '021.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_DENBR'), 'NSP', 'NSP', 'Ne sait pas', 'Ne sait Pas : La méthode de dénombrement n''est pas connue', 'SINP', 'Validé', 0, '021.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'AAPN', 'AAPN', 'AAPN', 'Aire d''adhésion de parc national', 'SINP', 'Validé', 0, '022.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ANTAR', 'ANTAR', 'ANTAR', 'Zone protégée du Traité de l''Antarctique', 'SINP', 'Validé', 0, '022.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'APB', 'APB', 'APB', 'Arrêté de protection de biotope', 'SINP', 'Validé', 0, '022.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'APIA', 'APIA', 'APIA', 'Zone protégée de la convention d''Apia', 'SINP', 'Validé', 0, '022.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ASPIM', 'ASPIM', 'ASPIM', 'Aire spécialement protégée d''importance méditerranéenne', 'SINP', 'Validé', 0, '022.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'BPM', 'BPM', 'BPM', 'Bien inscrit sur la liste du patrimoine mondial de l''UNESCO', 'SINP', 'Validé', 0, '022.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'CARTH', 'CARTH', 'CARTH', 'Zone protégée de la convention de Carthagène', 'SINP', 'Validé', 0, '022.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'CNP', 'CNP', 'CNP', '"Coeur de parc national. Valeur gelée le 15/06/2016 et remplacée par ""CPN"""', 'SINP', 'Gelé', 0, '022.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ENS', 'ENS', 'ENS', 'Espace naturel sensible', 'SINP', 'Validé', 0, '022.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'MAB', 'MAB', 'MAB', 'Réserve de biosphère (Man and Biosphère)', 'SINP', 'Validé', 0, '022.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'N2000', 'N2000', 'N2000', 'Natura 2000', 'SINP', 'Validé', 0, '022.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'NAIRO', 'NAIRO', 'NAIRO', 'Zone spécialement protégée de la convention de Nairobi', 'SINP', 'Validé', 0, '022.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'OSPAR', 'OSPAR', 'OSPAR', 'Zone marine protégée de la convention OSPAR', 'SINP', 'Validé', 0, '022.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'PNM', 'PNM', 'PNM', 'Parc naturel marin', 'SINP', 'Validé', 0, '022.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'PNR', 'PNR', 'PNR', 'Parc naturel régional', 'SINP', 'Validé', 0, '022.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'PRN', 'PRN', 'PRN', 'Périmètre de protection de réserve naturelle', 'SINP', 'Validé', 0, '022.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RAMSAR', 'RAMSAR', 'RAMSAR', 'Site Ramsar : Zone humide d''importance internationale', 'SINP', 'Validé', 0, '022.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RBD', 'RBD', 'RBD', 'Réserve biologique', 'SINP', 'Validé', 0, '022.018', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RBI', 'RBI', 'RBI', 'Réserve biologique intégrale', 'SINP', 'Validé', 0, '022.019', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RCFS', 'RCFS', 'RCFS', 'Réserve de chasse et de faune sauvage', 'SINP', 'Validé', 0, '022.020', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RIPN', 'RIPN', 'RIPN', 'Réserve intégrale de parc national', 'SINP', 'Validé', 0, '022.021', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RNC', 'RNC', 'RNC', 'Réserve naturelle de Corse', 'SINP', 'Validé', 0, '022.022', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RNCFS', 'RNCFS', 'RNCFS', 'Réserve nationale de chasse et faune sauvage', 'SINP', 'Validé', 0, '022.023', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RNN', 'RNN', 'RNN', 'Réserve naturelle nationale', 'SINP', 'Validé', 0, '022.024', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'RNR', 'RNR', 'RNR', 'Réserve naturelle régionale', 'SINP', 'Validé', 0, '022.025', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'SCEN', 'SCEN', 'SCEN', 'Site de Conservatoire d''espaces naturels', 'SINP', 'Validé', 0, '022.026', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'SCL', 'SCL', 'SCL', 'Site du Conservatoire du littoral', 'SINP', 'Validé', 0, '022.027', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ZHAE', 'ZHAE', 'ZHAE', 'Zone humide acquise par une Agence de l''eau', 'SINP', 'Validé', 0, '022.028', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ZNIEFF', 'ZNIEFF', 'ZNIEFF', 'Zone Naturelle d''Intérêt Ecologique Faunistique et Floristique (type non précisé)', 'SINP', 'Validé', 0, '022.029', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ZNIEFF1', 'ZNIEFF1', 'ZNIEFF1', 'Zone Naturelle d''Intérêt Ecologique Faunistique et Floristique de type I', 'SINP', 'Validé', get_id_nomenclature('TYP_EN', 'ZNIEFF'), '022.029.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_EN'), 'ZNIEFF2', 'ZNIEFF2', 'ZNIEFF2', 'Zone Naturelle d''Intérêt Ecologique Faunistique et Floristique de type II', 'SINP', 'Validé', get_id_nomenclature('TYP_EN', 'ZNIEFF'), '022.029.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_INF_GEO'), '1', '1', 'Géoréférencement', 'Géoréférencement de l''objet géographique. L''objet géographique est celui sur lequel on a effectué l''observation.', 'SINP', 'Validé', 0, '023.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_INF_GEO'), '2', '2', 'Rattachement', 'Rattachement à l''objet géographique : l''objet géographique n''est pas la géoréférence d''origine, ou a été déduit d''informations autres.', 'SINP', 'Validé', 0, '023.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'AUTR', 'AUTR', 'AUTR', 'La valeur n''est pas contenue dans la présente liste. Elle doit être complétée par d''autres informations.', 'SINP', 'Validé', 0, '024.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'CAMP', 'CAMP', 'CAMP', 'Campagne de prélèvement', 'SINP', 'Validé', 0, '024.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'INVSTA', 'INVSTA', 'INVSTA', 'Inventaire stationnel', 'SINP', 'Validé', 0, '024.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'LIEN', 'LIEN', 'LIEN', 'Lien : Indique un lien fort entre 2 observations. (Une occurrence portée par l''autre, une symbiose, un parasitisme…)', 'SINP', 'Validé', 0, '024.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'NSP', 'NSP', 'NSP', 'Ne sait pas : l''information n''est pas connue.', 'SINP', 'Validé', 0, '024.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'OBS', 'OBS', 'OBS', 'Observations', 'SINP', 'Validé', 0, '024.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'OP', 'OP', 'OP', 'Opération de prélèvement', 'SINP', 'Validé', 0, '024.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'PASS', 'PASS', 'PASS', 'Passage', 'SINP', 'Validé', 0, '024.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'POINT', 'POINT', 'POINT', 'Point de prélèvement ou point d''observation.', 'SINP', 'Validé', 0, '024.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'REL', 'REL', 'REL', 'Relevé (qu''il soit phytosociologique, d''observation, ou autre...)', 'SINP', 'Validé', 0, '024.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYP_GRP'), 'STRAT', 'STRAT', 'STRAT', 'Strate', 'SINP', 'Validé', 0, '024.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIV_PRECIS'), '0', 'Standard', 'Standard', 'Diffusion standard : à la maille, à la ZNIEFF, à la commune, à l''espace protégé (statut par défaut).', 'SINP', 'Validé', 0, '005.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIV_PRECIS'), '1', 'Commune', 'Commune', 'Diffusion floutée de la DEE par rattachement à la commune.', 'SINP', 'Validé', 0, '005.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIV_PRECIS'), '2', 'Maille', 'Maille', 'Diffusion floutée par rattachement à la maille 10 x 10 km', 'SINP', 'Validé', 0, '005.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIV_PRECIS'), '3', 'Département', 'Département', 'Diffusion floutée par rattachement au département.', 'SINP', 'Validé', 0, '005.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIV_PRECIS'), '4', 'Aucune', 'Aucune', 'Aucune diffusion (cas exceptionnel), correspond à une donnée de sensibilité 4.', 'SINP', 'Validé', 0, '005.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIV_PRECIS'), '5', 'Précise', 'Précise', 'Diffusion telle quelle : si une donnée précise existe, elle doit être diffusée telle quelle.', 'SINP', 'Validé', 0, '005.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'NSP', 'Ne Sait Pas', 'Ne Sait Pas', 'La méthode de dénombrement n''est pas connue.', 'SINP', 'Validé', 0, '006.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'IND', 'Individu', 'Individu', 'Nombre d''individus observés.', 'SINP', 'Validé', 0, '006.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'CPL', 'Couple', 'Couple', 'Nombre de couples observé.', 'SINP', 'Validé', 0, '006.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'COL', 'Colonie', 'Colonie', 'Nombre de colonies observées.', 'SINP', 'Validé', 0, '006.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'NID', 'Nid', 'Nid', 'Nombre de nids observés.', 'SINP', 'Validé', 0, '006.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'PON', 'Ponte', 'Ponte', 'Nombre de pontes observées.', 'SINP', 'Validé', 0, '006.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'HAM', 'Hampe florale', 'Hampe florale', 'Nombre de hampes florales observées.', 'SINP', 'Validé', 0, '006.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'TIGE', 'Tige', 'Tige', 'Nombre de tiges observées.', 'SINP', 'Validé', 0, '006.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'TOUF', 'Touffe', 'Touffe', 'Nombre de touffes observées.', 'SINP', 'Validé', 0, '006.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('OBJ_DENBR'), 'SURF', 'Surface', 'Surface', 'Zone aréale occupée par le taxon, en mètres carrés.', 'SINP', 'Validé', 0, '006.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ETA_BIO'), '0', 'NSP', 'NSP', 'Inconnu (peut être utilisé pour les virus ou les végétaux fanés par exemple).', 'SINP', 'Validé', 0, '007.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ETA_BIO'), '1', 'Non renseigné', 'Non renseigné', 'L''information n''a pas été renseignée.', 'SINP', 'Validé', 0, '007.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ETA_BIO'), '2', 'Observé vivant', 'Observé vivant', 'L''individu a été observé vivant.', 'SINP', 'Validé', 0, '007.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ETA_BIO'), '3', 'Trouvé mort', 'Trouvé mort', 'L''individu a été trouvé mort : Cadavre entier ou crâne par exemple. La mort est antérieure au processus d''observation.', 'SINP', 'Validé', 0, '007.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NATURALITE'), '0', 'Inconnu', 'Inconnu', 'Inconnu : la naturalité du sujet est inconnue', 'SINP', 'Validé', 0, '008.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NATURALITE'), '1', 'Sauvage', 'Sauvage', 'Sauvage : Qualifie un animal ou végétal à l''état sauvage, individu autochtone, se retrouvant dans son aire de répartition naturelle et dont les individus sont le résultat d''une reproduction naturelle, sans intervention humaine.', 'SINP', 'Validé', 0, '008.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NATURALITE'), '2', 'Cultivé/élevé', 'Cultivé/élevé', 'Cultivé/élevé : Qualifie un individu d''une population allochtone introduite volontairement dans des espaces non naturels dédiés à la culture, ou à l''élevage.', 'SINP', 'Validé', 0, '008.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NATURALITE'), '3', 'Planté', 'Planté', 'Planté : Qualifie un végétal d''une population allochtone introduite ponctuellement et  volontairement dans un espace naturel/semi naturel.', 'SINP', 'Validé', 0, '008.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NATURALITE'), '4', 'Féral', 'Féral', 'Féral : Qualifie un animal élevé retourné à l''état sauvage, individu d''une population allochtone.', 'SINP', 'Validé', 0, '008.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NATURALITE'), '5', 'Subspontané', 'Subspontané', '"Subspontané : Qualifie un végétal d''une population allochtone, introduite volontairement, qui persiste plus ou moins longtemps dans sa station d''origine et qui a une dynamique propre peu étendue et limitée aux alentours de son implantation initiale. ""Echappée des jardins""."', 'SINP', 'Validé', 0, '008.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '0', 'Inconnu', 'Inconnu', 'Inconnu : Il n''y a pas d''information disponible pour cet individu.', 'SINP', 'Validé', 0, '009.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '1', 'Indéterminé', 'Indéterminé', 'Indéterminé : Le sexe de l''individu n''a pu être déterminé', 'SINP', 'Validé', 0, '009.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '2', 'Femelle', 'Femelle', 'Féminin : L''individu est de sexe féminin.', 'SINP', 'Validé', 0, '009.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '3', 'Mâle', 'Mâle', 'Masculin : L''individu est de sexe masculin.', 'SINP', 'Validé', 0, '009.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '4', 'Hermaphrodite', 'Hermaphrodite', 'Hermaphrodite : L''individu est hermaphrodite.', 'SINP', 'Validé', 0, '009.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '5', 'Mixte', 'Mixte', 'Mixte : Sert lorsque l''on décrit plusieurs individus.', 'SINP', 'Validé', 0, '009.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SEXE'), '6', 'Non renseigné', 'Non renseigné', 'Non renseigné : l''information n''a pas été renseignée dans le document à l''origine de la donnée.', 'SINP', 'Validé', 0, '009.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NAT_OBJ_GEO'), 'In', 'Inventoriel', 'Inventoriel', 'Inventoriel : Le taxon observé est présent quelque part dans l''objet géographique', 'SINP', 'Validé', 0, '003.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NAT_OBJ_GEO'), 'NSP', 'Ne sait pas', 'Ne sait pas', 'Ne Sait Pas : L''information est inconnue', 'SINP', 'Validé', 0, '003.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NAT_OBJ_GEO'), 'St', 'Stationnel', 'Stationnel', 'Stationnel : Le taxon observé est présent sur l''ensemble de l''objet géographique', 'SINP', 'Validé', 0, '003.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DEE_FLOU'), 'NON', 'Non', 'Non', 'Non : indique qu''aucun floutage n''a eu lieu. Donnée non floutée, fournie précise par le producteur.', 'SINP', 'Validé', 0, '004.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DEE_FLOU'), 'OUI', 'Oui', 'Oui', 'Oui : indique qu''un floutage a eu lieu. Floutage effectué par le producteur avant envoi vers le SINP (une plateforme du SINP).', 'SINP', 'Validé', 0, '004.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DEE_FLOU'), 'NSP', 'NSP', 'NSP', 'NSP : Indique qu''on ignore si un floutage a eu lieu.', 'SINP', 'Validé', 0, '004.003', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '0', 'Inconnu/cryptogène', 'Inconnu/cryptogène', 'Individu dont le taxon a une aire d''origine inconnue qui fait qu''on ne peut donc pas dire s''il est indigène ou introduit.', 'SINP', 'Validé', 0, '011.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '1', 'Non renseigné', 'Non renseigné', 'Individu pour lequel l''information n''a pas été renseignée.', 'SINP', 'Validé', 0, '011.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '2', 'Présent (indigène ou indéterminé)', 'Présent (indigène ou indéterminé)', 'Individu d''un taxon présent au sens large dans la zone géographique considérée, c''est-à-dire taxon indigène ou taxon dont on ne sait pas s''il appartient à l''une des autres catégories. Le défaut de connaissance profite donc à l''indigénat.  Par indigène on entend : taxon qui est issu de la zone géographique considérée et qui s''y est naturellement développé sans contribution humaine, ou taxon qui est arrivé là sans intervention humaine (intentionnelle ou non) à partir d''une zone dans laquelle il est indigène6.  (NB : exclut les hybrides dont l''un des parents au moins est introduit dans la zone considérée)  Sont regroupés sous ce statut tous les taxons catégorisés « natif » ou « autochtone ».  Les taxons hivernant quelques mois de l''année entrent dans cette catégorie.', 'SINP', 'Validé', 0, '011.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '3', 'Introduit', 'Introduit', 'Taxon introduit (établi ou possiblement établi) au niveau local.  Par introduit on entend : taxon dont la présence locale est due à une intervention humaine, intentionnelle ou non, ou taxon qui est arrivé dans la zone sans intervention humaine mais à partir d''une zone dans laquelle il est introduit.  Par établi (terme pour la faune, naturalisé pour la flore) on entend : taxon introduit qui forme des populations viables (se reproduisant) et durables qui se maintiennent dans le milieu naturel sans besoin d''intervention humaine.  Sont regroupés sous ce statut tous les taxons catégorisés « non-indigène », « exotique », « exogène », « allogène », « allochtone », « non-natif », « naturalisé » dans une publication scientifique.', 'SINP', 'Validé', 0, '011.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '4', 'Introduit envahissant', 'Introduit envahissant', '"Individu d''un taxon introduit  localement, qui produit des descendants fertiles souvent en grand nombre, et qui a le potentiel pour s''étendre de façon exponentielle sur une grande aire, augmentant ainsi rapidement son aire de répartition. Cela induit souvent des conséquences écologiques, économiques ou sanitaires négatives. Sont regroupés sous ce statut tous les individus de taxons catégorisés ""introduits envahissants"", ""exotiques envahissants"", ou ""invasif""."', 'SINP', 'Validé', 0, '011.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '5', 'Introduit non établi (dont domestique)', 'Introduit non établi (dont domestique)', 'Individu dont le taxon est introduit, qui se reproduit occasionnellement hors de son aire de culture ou captivité, mais qui ne peut se maintenir à l''état sauvage.', 'SINP', 'Validé', 0, '011.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STAT_BIOGEO'), '6', 'Occasionnel', 'Occasionnel', 'Individu dont le taxon est occasionnel, non nicheur, accidentel ou exceptionnel dans la zone géographique considérée (par exemple migrateur de passage), qui est locale.', 'SINP', 'Validé', 0, '011.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '1', 'Analyse ADN environnemental (ADNe)', 'Analyse ADN environnemental (ADNe)', 'Analyse ADN environnemental (ADNe)', 'CAMPANULE', 'Validation en cours', 0, '100.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '2', 'Analyse de restes de prédateurs - pelotes de réjection, restes de repas de carnivores, analyses stomacales', 'Analyse de restes de prédateurs - pelotes de réjection, restes de repas de carnivores, analyses stomacales', 'Analyse de restes de prédateurs - pelotes de réjection, restes de repas de carnivores, analyses stomacales', 'CAMPANULE', 'Validation en cours', 0, '100.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '3', 'Aspirateur à air comprimé (marin)', 'Aspirateur à air comprimé (marin)', 'Aspirateur à air comprimé (marin)', 'CAMPANULE', 'Validation en cours', 0, '100.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '4', 'Aspiration moteur type D-VAC (aspirateur à moteur)', 'Aspiration moteur type D-VAC (aspirateur à moteur)', 'Aspiration moteur type D-VAC (aspirateur à moteur)', 'CAMPANULE', 'Validation en cours', 0, '100.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '5', 'Attraction pour observation (miellée, phéromones…)', 'Attraction pour observation (miellée, phéromones…)', 'Attraction pour observation (miellée, phéromones…)', 'CAMPANULE', 'Validation en cours', 0, '100.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '6', 'Battage (battage de la végétation, parapluie japonais)', 'Battage (battage de la végétation, parapluie japonais)', 'Battage (battage de la végétation, parapluie japonais)', 'CAMPANULE', 'Validation en cours', 0, '100.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '7', 'Battue avec rabatteurs', 'Battue avec rabatteurs', 'Battue avec rabatteurs', 'CAMPANULE', 'Validation en cours', 0, '100.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '8', 'Brossage (terrestre : écorces…)', 'Brossage (terrestre : écorces…)', 'Brossage (terrestre : écorces…)', 'CAMPANULE', 'Validation en cours', 0, '100.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '9', 'Capture au collet', 'Capture au collet', 'Capture au collet', 'CAMPANULE', 'Validation en cours', 0, '100.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '10', 'Capture au filet Cryldé', 'Capture au filet Cryldé', 'Capture au filet Cryldé', 'CAMPANULE', 'Validation en cours', 0, '100.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '11', 'Capture au filet japonais', 'Capture au filet japonais', 'Capture au filet japonais', 'CAMPANULE', 'Validation en cours', 0, '100.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '12', 'Capture au filet stationnaire', 'Capture au filet stationnaire', 'Capture au filet stationnaire', 'CAMPANULE', 'Validation en cours', 0, '100.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '13', 'Capture directe (capture à vue, capture relâche)', 'Capture directe (capture à vue, capture relâche)', 'Capture directe (capture à vue, capture relâche)', 'CAMPANULE', 'Validation en cours', 0, '100.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '14', 'Chalutage terrestre (capture au filet de toit - voiture)', 'Chalutage terrestre (capture au filet de toit - voiture)', 'Chalutage terrestre (capture au filet de toit - voiture)', 'CAMPANULE', 'Validation en cours', 0, '100.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '15', 'Création d''habitat refuge : autres techniques', 'Création d''habitat refuge : autres techniques', 'Création d''habitat refuge : autres techniques', 'CAMPANULE', 'Validation en cours', 0, '100.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '16', 'Création d''habitat refuge : couverture du sol (plaques, bâches)', 'Création d''habitat refuge : couverture du sol (plaques, bâches)', 'Création d''habitat refuge : couverture du sol (plaques, bâches)', 'CAMPANULE', 'Validation en cours', 0, '100.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '17', 'Création d''habitat refuge : dévitalisation de plantes, mutilation', 'Création d''habitat refuge : dévitalisation de plantes, mutilation', 'Création d''habitat refuge : dévitalisation de plantes, mutilation', 'CAMPANULE', 'Validation en cours', 0, '100.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '18', 'Création d''habitat refuge : hôtels à insectes, nichoirs', 'Création d''habitat refuge : hôtels à insectes, nichoirs', 'Création d''habitat refuge : hôtels à insectes, nichoirs', 'CAMPANULE', 'Validation en cours', 0, '100.018', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '19', 'Création d''habitat refuge : substrat artificiel aquatique', 'Création d''habitat refuge : substrat artificiel aquatique', 'Création d''habitat refuge : substrat artificiel aquatique', 'CAMPANULE', 'Validation en cours', 0, '100.019', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '20', 'Détection au chien d''arrêt', 'Détection au chien d''arrêt', 'Détection au chien d''arrêt', 'CAMPANULE', 'Validation en cours', 0, '100.020', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '21', 'Détection des ultrasons (écoute indirecte, analyse sonore, détection ultrasonore)', 'Détection des ultrasons (écoute indirecte, analyse sonore, détection ultrasonore)', 'Détection des ultrasons (écoute indirecte, analyse sonore, détection ultrasonore)', 'CAMPANULE', 'Validation en cours', 0, '100.021', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '22', 'Détection nocturne à la lampe frontale (chasse de nuit à la lampe frontale)', 'Détection nocturne à la lampe frontale (chasse de nuit à la lampe frontale)', 'Détection nocturne à la lampe frontale (chasse de nuit à la lampe frontale)', 'CAMPANULE', 'Validation en cours', 0, '100.022', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '23', 'Ecorcage', 'Ecorcage', 'Ecorcage', 'CAMPANULE', 'Validation en cours', 0, '100.023', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '24', 'Ecoute directe (reconnaissance sonore directe, détection auditive)', 'Ecoute directe (reconnaissance sonore directe, détection auditive)', 'Ecoute directe (reconnaissance sonore directe, détection auditive)', 'CAMPANULE', 'Validation en cours', 0, '100.024', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '25', 'Ecoute directe avec hydrophone', 'Ecoute directe avec hydrophone', 'Ecoute directe avec hydrophone', 'CAMPANULE', 'Validation en cours', 0, '100.025', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '26', 'Ecoute directe avec repasse', 'Ecoute directe avec repasse', 'Ecoute directe avec repasse', 'CAMPANULE', 'Validation en cours', 0, '100.026', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '27', 'Enregistrement sonore avec hydrophone', 'Enregistrement sonore avec hydrophone', 'Enregistrement sonore avec hydrophone', 'CAMPANULE', 'Validation en cours', 0, '100.027', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '28', 'Enregistrement sonore simple', 'Enregistrement sonore simple', 'Enregistrement sonore simple', 'CAMPANULE', 'Validation en cours', 0, '100.028', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '29', 'Etude de la banque de graines du sol', 'Etude de la banque de graines du sol', 'Etude de la banque de graines du sol', 'CAMPANULE', 'Validation en cours', 0, '100.029', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '30', 'Examen des hôtes - écrevisses et poissons (sangsues piscicolidae et branchiobdellidae)', 'Examen des hôtes - écrevisses et poissons (sangsues piscicolidae et branchiobdellidae)', 'Examen des hôtes - écrevisses et poissons (sangsues piscicolidae et branchiobdellidae)', 'CAMPANULE', 'Validation en cours', 0, '100.030', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '31', 'Extraction de substrat : délitage de susbtrats durs (marin)', 'Extraction de substrat : délitage de susbtrats durs (marin)', 'Extraction de substrat : délitage de susbtrats durs (marin)', 'CAMPANULE', 'Validation en cours', 0, '100.031', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '32', 'Extraction de substrat par benne (Van Veen, Smith McIntyre, Hamon…)', 'Extraction de substrat par benne (Van Veen, Smith McIntyre, Hamon…)', 'Extraction de substrat par benne (Van Veen, Smith McIntyre, Hamon…)', 'CAMPANULE', 'Validation en cours', 0, '100.032', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '33', 'Extraction de substrat par carottier à main (en plongée)', 'Extraction de substrat par carottier à main (en plongée)', 'Extraction de substrat par carottier à main (en plongée)', 'CAMPANULE', 'Validation en cours', 0, '100.033', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '34', 'Extraction de substrat par carottier à main (sans plongée - continental ou supra/médiolittoral)', 'Extraction de substrat par carottier à main (sans plongée - continental ou supra/médiolittoral)', 'Extraction de substrat par carottier à main (sans plongée - continental ou supra/médiolittoral)', 'CAMPANULE', 'Validation en cours', 0, '100.034', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '35', 'Extraction de substrat par filet dragueur ou haveneau (drague Rallier du Baty, Charcot Picard…)', 'Extraction de substrat par filet dragueur ou haveneau (drague Rallier du Baty, Charcot Picard…)', 'Extraction de substrat par filet dragueur ou haveneau (drague Rallier du Baty, Charcot Picard…)', 'CAMPANULE', 'Validation en cours', 0, '100.035', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '36', 'Extraction de substrat terrestre : bloc de sol, récolte de litière…', 'Extraction de substrat terrestre : bloc de sol, récolte de litière…', 'Extraction de substrat terrestre : bloc de sol, récolte de litière…', 'CAMPANULE', 'Validation en cours', 0, '100.036', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '37', 'Fauchage marin au filet fauchoir (en plongée)', 'Fauchage marin au filet fauchoir (en plongée)', 'Fauchage marin au filet fauchoir (en plongée)', 'CAMPANULE', 'Validation en cours', 0, '100.037', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '38', 'Fauchage marin au filet fauchoir (sans plongée - supra/médiolittoral)', 'Fauchage marin au filet fauchoir (sans plongée - supra/médiolittoral)', 'Fauchage marin au filet fauchoir (sans plongée - supra/médiolittoral)', 'CAMPANULE', 'Validation en cours', 0, '100.038', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '39', 'Fauchage terrestre au filet fauchoir (fauchage de la végétation)', 'Fauchage terrestre au filet fauchoir (fauchage de la végétation)', 'Fauchage terrestre au filet fauchoir (fauchage de la végétation)', 'CAMPANULE', 'Validation en cours', 0, '100.039', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '40', 'Fumigation (fogging, thermonébulisation insecticide)', 'Fumigation (fogging, thermonébulisation insecticide)', 'Fumigation (fogging, thermonébulisation insecticide)', 'CAMPANULE', 'Validation en cours', 0, '100.040', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '41', 'Grattage, brossage du susbtrat (marin)', 'Grattage, brossage du susbtrat (marin)', 'Grattage, brossage du susbtrat (marin)', 'CAMPANULE', 'Validation en cours', 0, '100.041', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '42', 'Méthode de De Vries (méthode des prélèvements, méthode des poignées)', 'Méthode de De Vries (méthode des prélèvements, méthode des poignées)', 'Méthode de De Vries (méthode des prélèvements, méthode des poignées)', 'CAMPANULE', 'Validation en cours', 0, '100.042', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '43', 'Méthode de l''élastique (lézards arboricoles)', 'Méthode de l''élastique (lézards arboricoles)', 'Méthode de l''élastique (lézards arboricoles)', 'CAMPANULE', 'Validation en cours', 0, '100.043', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '44', 'Observation à la moutarde - vers de terre', 'Observation à la moutarde - vers de terre', 'Observation à la moutarde - vers de terre', 'CAMPANULE', 'Validation en cours', 0, '100.044', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '45', 'Observation aux jumelles (observation à la longue-vue)', 'Observation aux jumelles (observation à la longue-vue)', 'Observation aux jumelles (observation à la longue-vue)', 'CAMPANULE', 'Validation en cours', 0, '100.045', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '46', 'Observation aux lunettes polarisantes', 'Observation aux lunettes polarisantes', 'Observation aux lunettes polarisantes', 'CAMPANULE', 'Validation en cours', 0, '100.046', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '47', 'Observation de détritus d''inondation, débris et laisses de crues', 'Observation de détritus d''inondation, débris et laisses de crues', 'Observation de détritus d''inondation, débris et laisses de crues', 'CAMPANULE', 'Validation en cours', 0, '100.047', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '48', 'Observation de larves (recherche de larves)', 'Observation de larves (recherche de larves)', 'Observation de larves (recherche de larves)', 'CAMPANULE', 'Validation en cours', 0, '100.048', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '49', 'Observation de macro-restes (cadavres, élytres…)', 'Observation de macro-restes (cadavres, élytres…)', 'Observation de macro-restes (cadavres, élytres…)', 'CAMPANULE', 'Validation en cours', 0, '100.049', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '50', 'Observation de micro-habitats (recherche de gîtes, chandelles, polypores, dendrotelmes…) ', 'Observation de micro-habitats (recherche de gîtes, chandelles, polypores, dendrotelmes…) ', 'Observation de micro-habitats (recherche de gîtes, chandelles, polypores, dendrotelmes…) ', 'CAMPANULE', 'Validation en cours', 0, '100.050', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '51', 'Observation de pontes (observation des œufs, recherche des pontes)', 'Observation de pontes (observation des œufs, recherche des pontes)', 'Observation de pontes (observation des œufs, recherche des pontes)', 'CAMPANULE', 'Validation en cours', 0, '100.051', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '52', 'Observation de substrat et tamisage', 'Observation de substrat et tamisage', 'Observation de substrat et tamisage', 'CAMPANULE', 'Validation en cours', 0, '100.052', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '53', 'Observation de substrat par extraction : appareil de Berlèse-Tullgren, Winckler-Moczarski…', 'Observation de substrat par extraction : appareil de Berlèse-Tullgren, Winckler-Moczarski…', 'Observation de substrat par extraction : appareil de Berlèse-Tullgren, Winckler-Moczarski…', 'CAMPANULE', 'Validation en cours', 0, '100.053', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '54', 'Observation de substrat par extraction : par flottaison (par densité)', 'Observation de substrat par extraction : par flottaison (par densité)', 'Observation de substrat par extraction : par flottaison (par densité)', 'CAMPANULE', 'Validation en cours', 0, '100.054', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '55', 'Observation de trous de sortie, trous d''émergence', 'Observation de trous de sortie, trous d''émergence', 'Observation de trous de sortie, trous d''émergence', 'CAMPANULE', 'Validation en cours', 0, '100.055', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '56', 'Observation d''exuvies', 'Observation d''exuvies', 'Observation d''exuvies', 'CAMPANULE', 'Validation en cours', 0, '100.056', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '57', 'Observation d''indices de présence', 'Observation d''indices de présence', 'Observation d''indices de présence', 'CAMPANULE', 'Validation en cours', 0, '100.057', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '58', 'Observation directe marine (observation en plongée)', 'Observation directe marine (observation en plongée)', 'Observation directe marine (observation en plongée)', 'CAMPANULE', 'Validation en cours', 0, '100.058', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '59', 'Observation directe terrestre diurne (chasse à vue de jour)', 'Observation directe terrestre diurne (chasse à vue de jour)', 'Observation directe terrestre diurne (chasse à vue de jour)', 'CAMPANULE', 'Validation en cours', 0, '100.059', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '60', 'Observation directe terrestre nocturne (chasse à vue de nuit)', 'Observation directe terrestre nocturne (chasse à vue de nuit)', 'Observation directe terrestre nocturne (chasse à vue de nuit)', 'CAMPANULE', 'Validation en cours', 0, '100.060', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '61', 'Observation directe terrestre nocturne au phare', 'Observation directe terrestre nocturne au phare', 'Observation directe terrestre nocturne au phare', 'CAMPANULE', 'Validation en cours', 0, '100.061', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '62', 'Observation manuelle de substrat (litière, sol…)', 'Observation manuelle de substrat (litière, sol…)', 'Observation manuelle de substrat (litière, sol…)', 'CAMPANULE', 'Validation en cours', 0, '100.062', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '63', 'Observation marine par caméra suspendue', 'Observation marine par caméra suspendue', 'Observation marine par caméra suspendue', 'CAMPANULE', 'Validation en cours', 0, '100.063', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '64', 'Observation marine par traineau vidéo', 'Observation marine par traineau vidéo', 'Observation marine par traineau vidéo', 'CAMPANULE', 'Validation en cours', 0, '100.064', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '65', 'Observation marine par véhicule téléguidé (ROV)', 'Observation marine par véhicule téléguidé (ROV)', 'Observation marine par véhicule téléguidé (ROV)', 'CAMPANULE', 'Validation en cours', 0, '100.065', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '66', 'Observation marine photographique (observation photographique en plongée)', 'Observation marine photographique (observation photographique en plongée)', 'Observation marine photographique (observation photographique en plongée)', 'CAMPANULE', 'Validation en cours', 0, '100.066', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '67', 'Observation par piège photographique', 'Observation par piège photographique', 'Observation par piège photographique', 'CAMPANULE', 'Validation en cours', 0, '100.067', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '68', 'Observation photographique aérienne, prise de vue aérienne', 'Observation photographique aérienne, prise de vue aérienne', 'Observation photographique aérienne, prise de vue aérienne', 'CAMPANULE', 'Validation en cours', 0, '100.068', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '69', 'Observation photographique terrestre (affût photographique)', 'Observation photographique terrestre (affût photographique)', 'Observation photographique terrestre (affût photographique)', 'CAMPANULE', 'Validation en cours', 0, '100.069', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '70', 'Paniers à vers de terre', 'Paniers à vers de terre', 'Paniers à vers de terre', 'CAMPANULE', 'Validation en cours', 0, '100.070', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '71', 'Pêche à la palangre', 'Pêche à la palangre', 'Pêche à la palangre', 'CAMPANULE', 'Validation en cours', 0, '100.071', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '72', 'Pêche à l''épuisette (capture par épuisette, chasse à l''épuisette)', 'Pêche à l''épuisette (capture par épuisette, chasse à l''épuisette)', 'Pêche à l''épuisette (capture par épuisette, chasse à l''épuisette)', 'CAMPANULE', 'Validation en cours', 0, '100.072', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '73', 'Pêche au chalut, chalutage (chalut à perche...)', 'Pêche au chalut, chalutage (chalut à perche...)', 'Pêche au chalut, chalutage (chalut à perche...)', 'CAMPANULE', 'Validation en cours', 0, '100.073', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '74', 'Pêche au filet - à détailler', 'Pêche au filet - à détailler', 'Pêche au filet - à détailler', 'CAMPANULE', 'Validation en cours', 0, '100.074', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '75', 'Pêche au filet lesté (pêche à la senne)', 'Pêche au filet lesté (pêche à la senne)', 'Pêche au filet lesté (pêche à la senne)', 'CAMPANULE', 'Validation en cours', 0, '100.075', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '76', 'Pêche au filet Surber', 'Pêche au filet Surber', 'Pêche au filet Surber', 'CAMPANULE', 'Validation en cours', 0, '100.076', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '77', 'Pêche au filet troubleau (chasse au filet troubleau)', 'Pêche au filet troubleau (chasse au filet troubleau)', 'Pêche au filet troubleau (chasse au filet troubleau)', 'CAMPANULE', 'Validation en cours', 0, '100.077', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '78', 'Pêche électrique, électropêche', 'Pêche électrique, électropêche', 'Pêche électrique, électropêche', 'CAMPANULE', 'Validation en cours', 0, '100.078', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '79', 'Piégeage à appât type Plantrou (piège à Charaxes)', 'Piégeage à appât type Plantrou (piège à Charaxes)', 'Piégeage à appât type Plantrou (piège à Charaxes)', 'CAMPANULE', 'Validation en cours', 0, '100.079', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '80', 'Piégeage à cornet (capture par piège cornet unidirectionnel)', 'Piégeage à cornet (capture par piège cornet unidirectionnel)', 'Piégeage à cornet (capture par piège cornet unidirectionnel)', 'CAMPANULE', 'Validation en cours', 0, '100.080', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '81', 'Piégeage à fosse à coprophages', 'Piégeage à fosse à coprophages', 'Piégeage à fosse à coprophages', 'CAMPANULE', 'Validation en cours', 0, '100.081', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '82', 'Piégeage à fosse à nécrophages', 'Piégeage à fosse à nécrophages', 'Piégeage à fosse à nécrophages', 'CAMPANULE', 'Validation en cours', 0, '100.082', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '83', 'Piégeage à fosse appâté (capture par piège à fosse avec liquide conservateur, piège Barber, pot-piège)', 'Piégeage à fosse appâté (capture par piège à fosse avec liquide conservateur, piège Barber, pot-piège)', 'Piégeage à fosse appâté (capture par piège à fosse avec liquide conservateur, piège Barber, pot-piège)', 'CAMPANULE', 'Validation en cours', 0, '100.083', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '84', 'Piégeage à fosse non appâté (piège à fosse sans liquide conservateur)', 'Piégeage à fosse non appâté (piège à fosse sans liquide conservateur)', 'Piégeage à fosse non appâté (piège à fosse sans liquide conservateur)', 'CAMPANULE', 'Validation en cours', 0, '100.084', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '85', 'Piégeage adhésif (piège collant, piège gluant, bande collante)', 'Piégeage adhésif (piège collant, piège gluant, bande collante)', 'Piégeage adhésif (piège collant, piège gluant, bande collante)', 'CAMPANULE', 'Validation en cours', 0, '100.085', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '86', 'Piégeage aérien à succion (aspirateur échantillonneur, piège à moustiques)', 'Piégeage aérien à succion (aspirateur échantillonneur, piège à moustiques)', 'Piégeage aérien à succion (aspirateur échantillonneur, piège à moustiques)', 'CAMPANULE', 'Validation en cours', 0, '100.086', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '87', 'Piégeage aérien rotatif', 'Piégeage aérien rotatif', 'Piégeage aérien rotatif', 'CAMPANULE', 'Validation en cours', 0, '100.087', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '88', 'Piégeage au sol - à détailler', 'Piégeage au sol - à détailler', 'Piégeage au sol - à détailler', 'CAMPANULE', 'Validation en cours', 0, '100.088', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '89', 'Piégeage bouteille (piège à vin, piège à appât fermenté, piège à cétoines)', 'Piégeage bouteille (piège à vin, piège à appât fermenté, piège à cétoines)', 'Piégeage bouteille (piège à vin, piège à appât fermenté, piège à cétoines)', 'CAMPANULE', 'Validation en cours', 0, '100.089', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '90', 'Piégeage entomologique composite (PEC)', 'Piégeage entomologique composite (PEC)', 'Piégeage entomologique composite (PEC)', 'CAMPANULE', 'Validation en cours', 0, '100.090', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '91', 'Piégeage lumineux aquatique à fluorescence', 'Piégeage lumineux aquatique à fluorescence', 'Piégeage lumineux aquatique à fluorescence', 'CAMPANULE', 'Validation en cours', 0, '100.091', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '92', 'Piégeage lumineux aquatique à incandescence', 'Piégeage lumineux aquatique à incandescence', 'Piégeage lumineux aquatique à incandescence', 'CAMPANULE', 'Validation en cours', 0, '100.092', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '93', 'Piégeage lumineux aquatique à LED', 'Piégeage lumineux aquatique à LED', 'Piégeage lumineux aquatique à LED', 'CAMPANULE', 'Validation en cours', 0, '100.093', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '94', 'Piégeage lumineux automatique à fluorescence', 'Piégeage lumineux automatique à fluorescence', 'Piégeage lumineux automatique à fluorescence', 'CAMPANULE', 'Validation en cours', 0, '100.094', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '95', 'Piégeage lumineux automatique à incandescence', 'Piégeage lumineux automatique à incandescence', 'Piégeage lumineux automatique à incandescence', 'CAMPANULE', 'Validation en cours', 0, '100.095', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '96', 'Piégeage lumineux automatique à LED', 'Piégeage lumineux automatique à LED', 'Piégeage lumineux automatique à LED', 'CAMPANULE', 'Validation en cours', 0, '100.096', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '97', 'Piégeage lumineux manuel à fluorescence', 'Piégeage lumineux manuel à fluorescence', 'Piégeage lumineux manuel à fluorescence', 'CAMPANULE', 'Validation en cours', 0, '100.097', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '98', 'Piégeage lumineux manuel à incandescence', 'Piégeage lumineux manuel à incandescence', 'Piégeage lumineux manuel à incandescence', 'CAMPANULE', 'Validation en cours', 0, '100.098', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '99', 'Piégeage lumineux manuel à LED', 'Piégeage lumineux manuel à LED', 'Piégeage lumineux manuel à LED', 'CAMPANULE', 'Validation en cours', 0, '100.099', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '100', 'Piégeage Malaise (capture par tente Malaise)', 'Piégeage Malaise (capture par tente Malaise)', 'Piégeage Malaise (capture par tente Malaise)', 'CAMPANULE', 'Validation en cours', 0, '100.100', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '101', 'Piégeage Marris House Net (capture par piège Malaise type Marris House Net)', 'Piégeage Marris House Net (capture par piège Malaise type Marris House Net)', 'Piégeage Marris House Net (capture par piège Malaise type Marris House Net)', 'CAMPANULE', 'Validation en cours', 0, '100.101', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '102', 'Piégeage microtube à fourmis', 'Piégeage microtube à fourmis', 'Piégeage microtube à fourmis', 'CAMPANULE', 'Validation en cours', 0, '100.102', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '103', 'Piégeage par assiettes colorées (piège coloré, plaque colorée adhésive)', 'Piégeage par assiettes colorées (piège coloré, plaque colorée adhésive)', 'Piégeage par assiettes colorées (piège coloré, plaque colorée adhésive)', 'CAMPANULE', 'Validation en cours', 0, '100.103', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '104', 'Piégeage par attraction sexuelle avec femelles', 'Piégeage par attraction sexuelle avec femelles', 'Piégeage par attraction sexuelle avec femelles', 'CAMPANULE', 'Validation en cours', 0, '100.104', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '105', 'Piégeage par attraction sexuelle avec phéromones', 'Piégeage par attraction sexuelle avec phéromones', 'Piégeage par attraction sexuelle avec phéromones', 'CAMPANULE', 'Validation en cours', 0, '100.105', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '106', 'Piégeage par enceinte à émergence aquatique (nasse à émergence aquatique)', 'Piégeage par enceinte à émergence aquatique (nasse à émergence aquatique)', 'Piégeage par enceinte à émergence aquatique (nasse à émergence aquatique)', 'CAMPANULE', 'Validation en cours', 0, '100.106', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '107', 'Piégeage par enceinte à émergence terrestre ex situ (nasse à émergence terrestre, éclosoir)', 'Piégeage par enceinte à émergence terrestre ex situ (nasse à émergence terrestre, éclosoir)', 'Piégeage par enceinte à émergence terrestre ex situ (nasse à émergence terrestre, éclosoir)', 'CAMPANULE', 'Validation en cours', 0, '100.107', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '108', 'Piégeage par enceinte à émergence terrestre in situ (nasse à émergence terrestre, éclosoir)', 'Piégeage par enceinte à émergence terrestre in situ (nasse à émergence terrestre, éclosoir)', 'Piégeage par enceinte à émergence terrestre in situ (nasse à émergence terrestre, éclosoir)', 'CAMPANULE', 'Validation en cours', 0, '100.108', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '109', 'Piégeage par enceinte type biocénomètre', 'Piégeage par enceinte type biocénomètre', 'Piégeage par enceinte type biocénomètre', 'CAMPANULE', 'Validation en cours', 0, '100.109', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '110', 'Piégeage par nasse à Coléoptères Hydrocanthares (piège appâté aquatique)', 'Piégeage par nasse à Coléoptères Hydrocanthares (piège appâté aquatique)', 'Piégeage par nasse à Coléoptères Hydrocanthares (piège appâté aquatique)', 'CAMPANULE', 'Validation en cours', 0, '100.110', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '111', 'Piégeage par nasses aquatiques ou filets verveux (appâtés)', 'Piégeage par nasses aquatiques ou filets verveux (appâtés)', 'Piégeage par nasses aquatiques ou filets verveux (appâtés)', 'CAMPANULE', 'Validation en cours', 0, '100.111', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '112', 'Piégeage par nasses aquatiques ou filets verveux (non appâtés)', 'Piégeage par nasses aquatiques ou filets verveux (non appâtés)', 'Piégeage par nasses aquatiques ou filets verveux (non appâtés)', 'CAMPANULE', 'Validation en cours', 0, '100.112', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '113', 'Piégeage par piège à entonnoir terrestre (funnel trap) (appâté)', 'Piégeage par piège à entonnoir terrestre (funnel trap) (appâté)', 'Piégeage par piège à entonnoir terrestre (funnel trap) (appâté)', 'CAMPANULE', 'Validation en cours', 0, '100.113', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '114', 'Piégeage par piège à entonnoir terrestre (funnel trap) (non appâté)', 'Piégeage par piège à entonnoir terrestre (funnel trap) (non appâté)', 'Piégeage par piège à entonnoir terrestre (funnel trap) (non appâté)', 'CAMPANULE', 'Validation en cours', 0, '100.114', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '115', E'Piégeage par piège-vitre bidirectionnel \\"mimant une cavité\\" (bande noire)', E'Piégeage par piège-vitre bidirectionnel \\"mimant une cavité\\" (bande noire)', E'Piégeage par piège-vitre bidirectionnel \\"mimant une cavité\\" (bande noire)', 'CAMPANULE', 'Validation en cours', 0, '100.115', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '116', 'Piégeage par piège-vitre bidirectionnel (piège fenêtre, piège-vitre plan)', 'Piégeage par piège-vitre bidirectionnel (piège fenêtre, piège-vitre plan)', 'Piégeage par piège-vitre bidirectionnel (piège fenêtre, piège-vitre plan)', 'CAMPANULE', 'Validation en cours', 0, '100.116', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '117', 'Piégeage par piège-vitre multidirectionnel avec alcool (piège Polytrap, PIMUL)', 'Piégeage par piège-vitre multidirectionnel avec alcool (piège Polytrap, PIMUL)', 'Piégeage par piège-vitre multidirectionnel avec alcool (piège Polytrap, PIMUL)', 'CAMPANULE', 'Validation en cours', 0, '100.117', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '118', 'Piégeage par piège-vitre multidirectionnel sans alcool (piège Polytrap, PIMUL)', 'Piégeage par piège-vitre multidirectionnel sans alcool (piège Polytrap, PIMUL)', 'Piégeage par piège-vitre multidirectionnel sans alcool (piège Polytrap, PIMUL)', 'CAMPANULE', 'Validation en cours', 0, '100.118', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '119', 'Piégeage par sac collecteur de feuillage et rameaux ligneux', 'Piégeage par sac collecteur de feuillage et rameaux ligneux', 'Piégeage par sac collecteur de feuillage et rameaux ligneux', 'CAMPANULE', 'Validation en cours', 0, '100.119', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '120', 'Piégeage par sélecteur de Chauvin', 'Piégeage par sélecteur de Chauvin', 'Piégeage par sélecteur de Chauvin', 'CAMPANULE', 'Validation en cours', 0, '100.120', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '121', 'Piégeage par tissu imbibé d''insecticide', 'Piégeage par tissu imbibé d''insecticide', 'Piégeage par tissu imbibé d''insecticide', 'CAMPANULE', 'Validation en cours', 0, '100.121', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '122', 'Piégeage SLAM (capture par piège Sand Land and Air Malaise)', 'Piégeage SLAM (capture par piège Sand Land and Air Malaise)', 'Piégeage SLAM (capture par piège Sand Land and Air Malaise)', 'CAMPANULE', 'Validation en cours', 0, '100.122', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '123', 'Piégeages par pièges barrières (pots-pièges associés à une barrière d''interception)', 'Piégeages par pièges barrières (pots-pièges associés à une barrière d''interception)', 'Piégeages par pièges barrières (pots-pièges associés à une barrière d''interception)', 'CAMPANULE', 'Validation en cours', 0, '100.123', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '124', 'Pièges à poils', 'Pièges à poils', 'Pièges à poils', 'CAMPANULE', 'Validation en cours', 0, '100.124', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '125', 'Pièges à traces (pièges à empreintes)', 'Pièges à traces (pièges à empreintes)', 'Pièges à traces (pièges à empreintes)', 'CAMPANULE', 'Validation en cours', 0, '100.125', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '126', 'Pièges aquatiques à sangsues (bouteilles percées, appâtées…)', 'Pièges aquatiques à sangsues (bouteilles percées, appâtées…)', 'Pièges aquatiques à sangsues (bouteilles percées, appâtées…)', 'CAMPANULE', 'Validation en cours', 0, '100.126', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '127', 'Pièges cache-tubes', 'Pièges cache-tubes', 'Pièges cache-tubes', 'CAMPANULE', 'Validation en cours', 0, '100.127', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '128', 'Pièges cache-tubes adhésifs (tubes capteurs de poils)', 'Pièges cache-tubes adhésifs (tubes capteurs de poils)', 'Pièges cache-tubes adhésifs (tubes capteurs de poils)', 'CAMPANULE', 'Validation en cours', 0, '100.128', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '129', 'Prélèvement par râteau ou grappin (macrophytes)', 'Prélèvement par râteau ou grappin (macrophytes)', 'Prélèvement par râteau ou grappin (macrophytes)', 'CAMPANULE', 'Validation en cours', 0, '100.129', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '130', 'Prospection à pied de cours d''eau (macrophytes)', 'Prospection à pied de cours d''eau (macrophytes)', 'Prospection à pied de cours d''eau (macrophytes)', 'CAMPANULE', 'Validation en cours', 0, '100.130', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '131', 'Prospection active dans l''habitat naturel (talus, souches, pierres…)', 'Prospection active dans l''habitat naturel (talus, souches, pierres…)', 'Prospection active dans l''habitat naturel (talus, souches, pierres…)', 'CAMPANULE', 'Validation en cours', 0, '100.131', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '132', 'Recherche dans filtres de piscines, skimmer', 'Recherche dans filtres de piscines, skimmer', 'Recherche dans filtres de piscines, skimmer', 'CAMPANULE', 'Validation en cours', 0, '100.132', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TECHNIQUE_OBS'), '133', 'Non renseigné', 'Non renseigné', 'La  technique d''observation n''est pas renseignée', 'GEONATURE', 'non validé', 0, '100.133', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '1', 'Certain - très probable', 'Certain - très probable', 'La donnée est exacte. Il n’y a pas de doute notable et significatif quant à l’exactitude de l’observation ou de la détermination du taxon. La validation a été réalisée notamment à partir d’une preuve de l’observation qui confirme la détermination du producteur ou après vérification auprès de l’observateur et/ou du déterminateur.', 'SINP', 'validé', 0, '101.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '2', 'Probable', 'Probable', ' La donnée présente un bon niveau de fiabilité. Elle est vraisemblable et crédible. Il n’y a, a priori, aucune raison de douter de l’exactitude de la donnée mais il n’y a pas d’éléments complémentaires suffisants disponibles ou évalués (notamment la présence d’une preuve ou la possibilité de revenir à la donnée source) permettant d’attribuer un plus haut niveau de certitude.', 'SINP', 'validé', 0, '101.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '3', 'Douteux', 'Douteux', 'La donnée est peu vraisemblable ou surprenante mais on ne dispose pas d’éléments suffisants pour attester d’une erreur manifeste. La donnée est considérée comme douteuse.', 'SINP', 'validé', 0, '101.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '4', 'Invalide', 'Invalide', 'La donnée a été infirmée (erreur manifeste/avérée) ou présente un trop bas niveau de fiabilité. Elle est considérée comme trop improbable (aberrante notamment au regard de l’aire de répartition connue, des paramètres biotiques et abiotiques de la niche écologique du taxon, la preuve révèle une erreur de détermination). Elle est considérée comme invalide.', 'SINP', 'validé', 0, '101.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '5', 'Non réalisable', 'Non réalisable', 'La donnée a été soumise à l’ensemble du processus de validation mais l’opérateur (humain ou machine) n’a pas pu statuer sur le niveau de fiabilité, notamment à cause des points suivants : état des connaissances du taxon insuffisantes, ou informations insuffisantes sur l’observation.', 'SINP', 'validé', 0, '101.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '6', 'Inconnu', 'Inconnu', 'Le statut de validation n''est pas connu.', 'GEONATURE', 'non validé', 0, '101.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('RESOURCE_TYP'), '1', 'Dataset', 'Dataset', 'Jeu de données', 'SINP', 'Validé', 0, '102.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('RESOURCE_TYP'), '2', 'Series', 'Series', 'ensemble de séries de données', 'SINP', 'Validé', 0, '102.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('DATA_TYP'), '1', 'Occtax', 'Occurrences de Taxons', 'Occurrences de Taxons', 'SINP', 'Validé', 0, '103.001', '2017-12-18 00:00:00', '2017-12-18 00:00:00', true)
,(get_id_nomenclature_type('DATA_TYP'), '2', 'Occhab', 'Occurrences d''habitats', 'Occurrences d''habitats', 'SINP', 'Validé', 0, '103.002', '2017-12-18 00:00:00', '2017-12-18 00:00:00', true)
,(get_id_nomenclature_type('DATA_TYP'), '3', 'Syntax', 'Syntax', 'Synthèse de taxons', 'SINP', 'Validé', 0, '103.003', '2017-12-18 00:00:00', '2017-12-18 00:00:00', true)
,(get_id_nomenclature_type('DATA_TYP'), '4', 'Synhab', 'Synhab', 'Synthese d''habitats', 'SINP', 'Validé', 0, '103.004', '2017-12-18 00:00:00', '2017-12-18 00:00:00', true)
,(get_id_nomenclature_type('DATA_TYP'), '5', 'NR', 'Non renseigné', 'Non renseigné', 'SINP', 'Validé', 0, '103.005', '2017-12-18 00:00:00', '2017-12-18 00:00:00', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '1', 'Aléatoire simple', 'Aléatoire simple', 'Les tirages des unités sont équiprobables et indépendants)', 'SINP', 'Validé', 0, '104.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '2', 'Systématique', 'Systématique', 'Les unités sont ordonnées (par ex. selon leurs coordonnées). Une première unité est tirée au hasard et les suivantes s''en déduisent en respectant l''agencement', 'SINP', 'Validé', 0, '104.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '3', 'Stratifié', 'Stratifié', 'La zone d''étude est découpée en strates plus homogènes (selon les grands types de milieux par ex.), et les unités d''échantillonnage sont sélectionnées au sein de chaque strate selon un plan d''échantillonnage secondaire', 'SINP', 'Validé', 0, '104.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '4', 'Adaptative sampling', 'Adaptative sampling', 'Tirage aléatoire d''un premier lot d''unités, puis de nouvelles unités sont ajoutées selon les résultats obtenus sur les premières', 'SINP', 'Validé', 0, '104.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '5', 'Probabilités inégales', 'Probabilités inégales (distance sampling, relascope)', 'Le tirage des unités est aléatoire avec probabilités inégales (chaque unité d''échantillonnage n''a pas la même probabilité d''être sélectionnée). C''est souvent le cas pour des unités de taille variable', 'SINP', 'Validé', 0, '104.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '6', 'Par degrés, par grappes', 'Par degrés, par grappes', 'La sélection des unités s''effectue dans un système hiérarchisé d''unités primaires, composées d''unités secondaires, etc. Par exemple, des arbres sont sélectionnés au sein de placettes, elles-mêmes sélectionnées au sein de peuplements forestiers, etc', 'SINP', 'Validé', 0, '104.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '7', 'Subjectif', 'Subjectif', 'Le choix des unités d''échantillonnage est effectué selon des critères propres à l''observateur (pas toujours précisés)', 'SINP', 'Validé', 0, '104.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_PLAN_TYP'), '8', 'Autre', 'Autre', 'Autre type de plan d''échantillonnage', 'SINP', 'Validé', 0, '104.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_UNITS_TYP'), '1', 'Individus', 'Individus', 'Individus', 'SINP', 'Validé', 0, '105.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_UNITS_TYP'), '2', 'Points', 'Points', 'Points', 'SINP', 'Validé', 0, '105.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_UNITS_TYP'), '3', 'Quadrats', 'Quadrats', 'Surface impérativement carrée.', 'SINP', 'Validé', 0, '105.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_UNITS_TYP'), '4', 'Placettes', 'Placettes', 'Surface de format variable (souvent circulaire, peut également être rectangulaire, etc.)', 'SINP', 'Validé', 0, '105.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_UNITS_TYP'), '5', 'Transects', 'Transects', 'Mesure en continu le long d''un tracé entre deux points (Désigne parfois une série de placettes effectuées le long d''un parcours entre deux points, mais c''est un abus de langage : dans ce cas, l''unité d''échantillonnage est la placette)', 'SINP', 'Validé', 0, '105.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('SAMPLING_UNITS_TYP'), '6', 'Autre', 'Autre', 'Autre type d''unités d''échantillonnage', 'SINP', 'Validé', 0, '105.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '3', 'Analyse d’ADN environnemental', 'Analyse d’ADN environnemental', 'La détermination a été effectuée sur la base des résultats d''une analyse d''ADN environnemental', 'GEONATURE', 'non validé', 0, '106.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '4', 'Analyse ADN de l''individu ou de ses restes', 'Analyse ADN de l''individu ou de ses restes', 'La détermination a été effectuée sur la base des résultats d''une analyse d''ADN réalisée à partir d''un échantillon prélevé sur un ou des individus, des traces ou restes (fragments ou résidus) d''individus', 'GEONATURE', 'non validé', 0, '106.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '5', 'Analyse biophysique ou biochimique', 'Analyse biophysique ou biochimique', 'La détermination repose sur des méthodes biophysiques ou biochimiques', 'GEONATURE', 'non validé', 0, '106.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '6', 'Déduction de l''espèce par n° d''identification', 'Déduction de l''espèce par n° d''identification', 'L''espèce est déduite sur la base d''un numéro d''identification attribué précédemment à un individu : n° de bague, n° de balise gps etc', 'GEONATURE', 'non validé', 0, '106.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '7', 'Détermination informatique par un outil de reconnaissance automatique', 'Détermination informatique par un outil de reconnaissance automatique', 'La détermination a été effectuée à l''aide d''une ou des applications de reconnaissance automatique visuelle ou auditive des espèces, sur informatique ou appareils mobiles', 'GEONATURE', 'non validé', 0, '106.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '8', 'Examen biométrique', 'Examen biométrique', 'La détermination repose sur des examens biométriques', 'GEONATURE', 'non validé', 0, '106.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '9', 'Examen auditif direct', 'Examen auditif direct', 'La détermination repose sur une écoute directe des sons produits par l''espèce, à l''oreille et sans transformation', 'GEONATURE', 'non validé', 0, '106.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '10', 'Examen auditif avec transformation électronique', 'Examen auditif avec transformation électronique', 'La détermination repose sur une écoute des sons produits par l''espèce après transformation électronique : transformation d''ultrasons, signaux hétérodynes, expansions de temps…', 'GEONATURE', 'non validé', 0, '106.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '11', 'Examen des organes reproducteurs ou critères spécifiques en laboratoire', 'Examen des organes reproducteurs ou critères spécifiques en laboratoire', 'La détermination repose sur l''examen précis des organes reproducteurs ou autres critères spécifiques en laboratoire', 'GEONATURE', 'non validé', 0, '106.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '2', 'Autre méthode de détermination', 'Autre méthode de détermination', 'La méthode de détermination n''est pas présente dans cette liste', 'GEONATURE', 'non validé', 0, '106.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '1', 'International', 'International', 'Niveau international', 'SINP', 'Validé', 0, '107.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '2', 'Européen', 'Européen', 'Niveau européen', 'SINP', 'Validé', 0, '107.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '3', 'National', 'National', 'Niveau national', 'SINP', 'Validé', 0, '107.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '4', 'Inter-régional terrestre, ou région marine', 'Inter-régional terrestre, ou région marine', 'Niveau inter-régional terrestre, ou région marine', 'SINP', 'Validé', 0, '107.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '5', 'Régional terrestre, ou sous-région marine', 'Régional terrestre, ou sous-région marine', 'Niveau régional terrestre, ou sous-région marine', 'SINP', 'Validé', 0, '107.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '6', 'Départemental, ou secteur marin', 'Départemental, ou secteur marin', 'Niveau départemental, ou secteur marin', 'SINP', 'Validé', 0, '107.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('NIVEAU_TERRITORIAL'), '7', 'Communal ou local', 'Communal ou local', 'Niveau communal ou local', 'SINP', 'Validé', 0, '107.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '1', 'Contact principal', 'Contact principal', 'Contact principal', 'SINP', 'Validé', 0, '109.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '2', 'Financeur', 'Financeur', 'Financeur', 'SINP', 'Validé', 0, '109.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '3', 'Maître d''ouvrage', 'Maître d''ouvrage', 'Maître d''ouvrage', 'SINP', 'Validé', 0, '109.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '4', 'Maître d''oeuvre', 'Maître d''oeuvre', 'Maître d''oeuvre', 'SINP', 'Validé', 0, '109.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '5', 'Fournisseur du jeu de données', 'Fournisseur du jeu de données', 'Fournisseur du jeu de données', 'SINP', 'Validé', 0, '109.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '6', 'Producteur du jeu de données', 'Producteur du jeu de données', 'Producteur du jeu de données', 'SINP', 'Validé', 0, '109.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '7', 'Point de contact base de données de production', 'Point de contact base de données de production', 'Point de contact base de données de productions', 'SINP', 'Validé', 0, '109.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'METROP', 'Métropole', 'Métropole', 'Métropole', 'SINP', 'Validé', 0, '110.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'GUF', 'Guyane française', 'Guyane française', 'Guyane française', 'SINP', 'Validé', 0, '110.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'MTQ', 'Martinique', 'Martinique', 'Martinique', 'SINP', 'Validé', 0, '110.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'GLP', 'Guadeloupe', 'Guadeloupe', 'Guadeloupe', 'SINP', 'Validé', 0, '110.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'MAF', 'Saint-Martin', 'Saint-Martin', 'Saint-Martin', 'SINP', 'Validé', 0, '110.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'BLM', 'Saint-Barthélemy', 'Saint-Barthélemy', 'Saint-Barthélemy', 'SINP', 'Validé', 0, '110.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'SPM', 'Saint-Pierre et Miquelon', 'Saint-Pierre et Miquelon', 'Saint-Pierre et Miquelon', 'SINP', 'Validé', 0, '110.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'MYT', 'Mayotte', 'Mayotte', 'Mayotte', 'SINP', 'Validé', 0, '110.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'REU', 'Réunion', 'Réunion', 'Réunion', 'SINP', 'Validé', 0, '110.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'NCL', 'Nouvelle-Calédonie', 'Nouvelle-Calédonie', 'Nouvelle-Calédonie', 'SINP', 'Validé', 0, '110.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'WLF', 'Wallis-et-Futuna', 'Wallis-et-Futuna', 'Wallis-et-Futuna', 'SINP', 'Validé', 0, '110.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'PYF', 'Polynésie française', 'Polynésie française', 'Polynésie française', 'SINP', 'Validé', 0, '110.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'CLI', 'Clipperton', 'Clipperton', 'Clipperton', 'SINP', 'Validé', 0, '110.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'EPA', 'TAAF : Iles Eparses', 'TAAF : Iles Eparses', 'TAAF : Iles Eparses', 'SINP', 'Validé', 0, '110.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'SUBANT', 'TAAF : Iles sub-Antarctiques', 'TAAF : Iles sub-Antarctiques', 'TAAF : Iles sub-Antarctiques', 'SINP', 'Validé', 0, '110.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'TADL', 'TAAF : Terre-Adélie', 'TAAF : Terre-Adélie', 'TAAF : Terre-Adélie', 'SINP', 'Validé', 0, '110.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TERRITOIRE'), 'HORSFR', 'Hors territoire', 'Hors territoire', 'Hors territoire', 'SINP', 'Validé', 0, '110.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_FINANCEMENT'), '1', 'Publique', 'Publique', 'Type de financement public', 'SINP', 'Validé', 0, '111.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_FINANCEMENT'), '2', 'Privée', 'Privée', 'Type de financement privé', 'SINP', 'Validé', 0, '111.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_FINANCEMENT'), '3', 'Mixte', 'Mixte', 'Mélange de financement public et privé', 'SINP', 'Validé', 0, '111.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_FINANCEMENT'), '4', 'Non financé', 'Non financé', 'Absence de financement', 'SINP', 'Validé', 0, '111.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_PROTOCOLE'), '0', 'Inconnu', 'Inconnu', 'Inconnu', 'SINP', 'Validé', 0, '112.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_PROTOCOLE'), '1', 'Protocole de collecte', 'Protocole de collecte', 'Protocole de collecte', 'SINP', 'Validé', 0, '1121.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_PROTOCOLE'), '2', 'Protocole de synthèse', 'Protocole de synthèse', 'Protocole de synthèse', 'SINP', 'Validé', 0, '112.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_PROTOCOLE'), '3', 'Protocole de conformité et de cohérence', 'Protocole de conformité et de cohérence', 'Protocole de conformité et de cohérence', 'SINP', 'Validé', 0, '111.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_PROTOCOLE'), '4', 'Protocole de validation', 'Protocole de validation', 'Protocole de validation', 'SINP', 'Validé', 0, '112.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('VOLET_SINP'), '1', 'Terre', 'Terre', 'Toutes les données relatives à la nature/biodiversité française du domaine terrestre (outre-mer compris) : habitats, flore, faune, champignons..., les données relatives aux espaces naturels (protégés / gérés ou non), aux sites géologiques, aux écosystèmes et leur fonctionnement.', 'SINP', 'Validé', 0, '113.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('VOLET_SINP'), '2', 'Mer', 'Mer', 'Toutes les données relatives à la nature / biodiversité française du domaine marin (outre-mer compris) : habitats, flore, faune, champignons..., les données relatives aux espaces naturels (protégés/gérés ou non), aux sites géologiques, aux écosystèmes et leur fonctionnement.', 'SINP', 'Validé', 0, '113.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('VOLET_SINP'), '3', 'Paysage', 'Paysage', 'Toutes les données relatives aux paysages, c''est-à-dire des données relatives aux formes du territoire, aux perceptions sociales et aux dynamiques du territoire. Elles intègrent également des inventaires particuliers. Elles concernent les espaces naturels, ruraux, urbains et périurbains. Elles incluent les espaces terrestres, les eaux intérieures et maritimes. Elles concernent tant les paysages pouvant être considérés comme remarquables que les paysages du quotidien et les paysages dégradés.', 'SINP', 'Validé', 0, '113.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('ROLE_ACTEUR'), '8', 'Point de contact pour les métadonnées', 'Point de contact pour les métadonnées', 'Point de contact pour les métadonnées', 'GEONATURE', 'non validé', 0, '109.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '1', 'Observation directe : Vue, écoute, olfactive, tactile', 'Observation directe : Vue, écoute, olfactive, tactile', 'Observation directe : Vue, écoute, olfactive, tactile', 'SINP', 'Validé', 0, '115.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '2', 'Pièges photo', 'Pièges photo', 'Pièges photo', 'SINP', 'Validé', 0, '115.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '3', 'Détection d''ultrasons', 'Détection d''ultrasons', 'Détection d''ultrasons', 'SINP', 'Validé', 0, '115.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '4', 'Recherche d''indices de présence', 'Recherche d''indices de présence', 'Recherche d''indices de présence', 'SINP', 'Validé', 0, '115.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '5', 'Photographies aériennes', 'Photographies aériennes', 'Photographies aériennes', 'SINP', 'Validé', 0, '115.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '6', 'Télédétection', 'Télédétection', 'Télédétection', 'SINP', 'Validé', 0, '115.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '7', 'Télémétrie', 'Télémétrie', 'Télémétrie', 'SINP', 'Validé', 0, '115.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '8', 'Capture d''individus (sans capture d''échantillon) : capture-relâcher', 'Capture d''individus (sans capture d''échantillon) : capture-relâcher', 'Capture d''individus (sans capture d''échantillon) : capture-relâcher', 'SINP', 'Validé', 0, '115.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '9', 'Prélèvement (capture avec collecte d''échantillon) : capture-conservation', 'Prélèvement (capture avec collecte d''échantillon) : capture-conservation', 'Prélèvement (capture avec collecte d''échantillon) : capture-conservation', 'SINP', 'Validé', 0, '115.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '10', 'Capture marquage recapture', 'Capture marquage recapture', 'Capture marquage recapture', 'SINP', 'Validé', 0, '115.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '11', 'Capture-suivi (radiotracking)', 'Capture-suivi (radiotracking)', 'Capture-suivi (radiotracking)', 'SINP', 'Validé', 0, '115.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METHO_RECUEIL'), '12', 'Autre', 'Autre', 'Autre', 'SINP', 'Validé', 0, '115.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '1.1', 'Observations naturalistes opportunistes', 'Observations naturalistes opportunistes', 'Les programmes d’observation participative (tous publics ou experts bénévoles, «recording scheme »), recueillant les données d’observation, sans plan d’échantillonnage particulier ni objectif prédéfini. La saisie de carnet de terrain entre dans cette rubrique. De même des observations annexes (groupe non cible) faites lors d’un programme spécifique entrent dans cette catégorie. Si ces informations sont recueillies dans un programme d’atlas en ligne, elles entrent dans la catégorie 1.2', 'SINP', 'Validé', 0, '114.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '1.2', 'Inventaire de répartition', 'Inventaire de répartition', 'Logique de projet avec un échantillonnage visant à couvrir le plus de territoire possible pour une espèce ou un groupe taxonomique donné, afin d’établir sa distribution dans une logique d’atlas, quelques soit son échelle (généralement départemental, régional ou national). Quand l’inventaire de répartition est la logique dominante, et qu’elle s’accompagne d’observations occasionnelles (non cible : exemple observation d’une couleuvre à collier lors d’un carré d’atlas oiseaux nicheur), ces observations occasionnelles peuvent être inclues dans cette catégorie mais devraient le plus possible faire l’objet d’un jdd distinct dans le même CA avec la catégorie « observation naturalistes opportunistes »', 'SINP', 'Validé', 0, '114.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '1.3', 'Inventaire pour étude d’espèces ou de communautés', 'Inventaire pour étude d’espèces ou de communautés', 'Logique d’acquisition de données associées à un protocole dans le but d’avoir des informations sur les facteurs qui structurent la présence et/ou l’observation d’une espèce, d’une population ou d’une communauté à l’échelle d’une station ou d’un éco-complexe. Les objectifs peuvent être multiples (conservation, éthologie, dynamique des populations, interactions biologiques, structuration des communautés ...). La mise en place de protocoles pour établir des indices de détectabilité pour les espèces et/ou leur degré de spécialisation vis-à-vis d’un habitat rentre dans ce cas.', 'SINP', 'Validé', 0, '114.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '1.4', 'Numérisation de collections', 'Numérisation de collections', 'Jeux de données généré par la mobilisation (saisie) de données d’une ou plusieurs collections de spécimens (herbier, collection entomologiques etc.) et visant à les rendre disponibles pour tout usage. Ce cas n’est à utiliser que si aucun autre motif plus précis à l’origine de la constitution de la collection ne peut être affecté : par exemple dans le cas où une campagne d’exploration génère des collections, le rattachement doit se faire à l’objectif « ATBI et exploration » (cf. libellé 2.5)', 'SINP', 'Validé', 0, '114.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '1.5', 'Numérisation de bibliographie', 'Numérisation de bibliographie', 'Cas particulier d’un jeu de données contenant uniquement des données issues de l’analyse de la bibliographie (qu’elle soit publié ou en littérature grise) et visant à les rendre disponibles pour tout usage. Ce cas n’est à utiliser que si aucun autre motif plus précis à l’origine de la constitution de la bibliographie ne peut être affecté : par exemple dans le cas où une campagne d’exploration d’un site génère des publications, le rattachement doit se faire à l’objectif « ATBI et exploration ». Les carnets d’observation de terrain relèvent plutôt du 1.1, Observation opportunistes', 'SINP', 'Validé', 0, '114.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '2.1', 'Cartographie habitats', 'Cartographie habitats', 'Données correspondant à une cartographie des végétations-habitats-écosystèmes établie à une échelle large (département, région, PNR, petite région naturelle) et non selon une logique de site ou réseau de site. Les approches terrain, traitement d’image ou la combinaison des deux sont inclues. Relevés de communauté d’espèces (généralement végétation/relevés phytosociologiques ou benthos pour les habitats marins) réalisés dans le cadre d’une cartographie des végétations-habitats-écosystèmes. Si seuls des relevés sont effectués (sans détermination du type de végétation ou habitat), il faut affecter à une autre rubrique.', 'SINP', 'Validé', 0, '114.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '2.2', 'Inventaire d’habitat', 'Inventaire d’habitat', 'Plan d’échantillonnage de l’espace avec détermination du type de végétation-habitat-écosystème. Relevés de communauté d’espèces (généralement végétation/relevés phytosociologiques ou benthos pour les habitats marins) réalisé dans le cadre d’un inventaire des végétations-habitats-écosystèmes. Si seuls des relevés sont effectués (sans détermination du type de végétation ou habitat), il faut affecter à une autre rubrique', 'SINP', 'Validé', 0, '114.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '2.3', 'Données opportuniste d’habitat', 'Données opportuniste d’habitat', 'Relevé de présence d’un type de végétation-habitat-écosystème n’entrant pas dans un plan d’échantillonnage prédéfini', 'SINP', 'Validé', 0, '114.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '2.4', 'Inventaire pour étude d’habitat', 'Inventaire pour étude d’habitat', 'Relevés de communauté d’espèces (généralement végétation/relevés phytosociologiques ou benthos pour les habitats marins) réalisé pour des études ou de la recherche sur les végétations-habitats-écosystèmes. Logique d’acquisition de données associées à un protocole dans le but d’améliorer la connaissance ou la définition d’un habitat, de construire une typologie, ou de préciser son fonctionnement, évaluer son état de conservation... Si seuls des relevés sont effectués (sans lien avec le type de végétation ou habitat), il faut affecter à une autre rubrique (1.3)', 'SINP', 'Validé', 0, '114.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '2.5', 'Numérisation de bibliographie habitat', 'Numérisation de bibliographie habitat', 'Cas particulier d’un jeu de données contenant uniquement des données issues de l’analyse de la bibliographie (qu’elle soit publié ou en littérature grise) et visant à les rendre disponibles pour tout usage concernant les habitats et les relevés standardisés associés (phytosociologiques, benthos)', 'SINP', 'Validé', 0, '114.010', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.1', 'Inventaire type ABC', 'Inventaire type ABC', 'Inventaires menés dans le cadre de la réalisation d’un atlas de la biodiversité communale, que ce soit la démarche « Ministère » ou une démarche similaire (démarche des PNR, IBC par exemple). Les données pré-existantes numérisées à l’occasion et pour l’ABC entrent dans cette catégorie. Les éventuels suivis temporels initiés dans un ABC n’entrent pas dans cette rubrique', 'SINP', 'Validé', 0, '114.011', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.2', 'Inventaire de Zonages d’intérêt', 'Inventaire de Zonages d’intérêt', 'Acquisition de données de terrain (pas de synthèse) pour établir/confirmer ou actualiser les zonages d’inventaires ZNIEFF (et éventuelles approches type ZICO ou IBA). Les inventaires pour accompagner la gestion d’espaces (déjà désignés) entrent dans la rubrique suivante (3.3)', 'SINP', 'Validé', 0, '114.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.3', 'Inventaire/évaluation pour plans de gestion', 'Inventaire/évaluation pour plans de gestion', 'Acquisition structurée de données naturalistes pour préparer, réviser ou actualiser un plan de gestion (au sens large) d’un espace naturel à statut de protection ou de gestion particulier (Natura 2000, Réserves, Parcs, forêt publique...) ou d’un site privé pour sa gestion écologique (exemple golfs, emprise LGV...). Y compris les évaluations permettant d’évaluer l’intérêt patrimonial du site (type IQE), l’état de conservation de ses habitats, de définir des enjeux par secteurs... Les données « opportunistes » collectées par ces gestionnaires peuvent aussi entrer dans cette catégorie mais devraient mieux faire l’objet de jeux de données distincts des données protocolées (cat. 2.4)', 'SINP', 'Validé', 0, '114.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.4', 'Observations opportunistes sur un site', 'Observations opportunistes sur un site', 'Données opportunistes collectées dans le cadre d’une logique site-centrée : lors d’opérations de gestion, données connexes d’observation faites lors d’un inventaire ou d''un suivi de site. La notion de site recouvre un espace (ou un réseau d’espace) prédéfini, avec un enjeu de gestion (réserves, site de conservatoire, sites d’une entreprise, espace vert...)', 'SINP', 'Validé', 0, '114.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.5', 'Inventaires généralisés & exploration', 'Inventaires généralisés & exploration', 'Programme ciblé sur un ou quelques sites, visant à dresser un vaste inventaire des taxons présents, multi-groupes et généralement pour découvrir de nouvelles espèces (pour la Science ou pour le territoire). Exemples : ATBI, IBG... Ces programmes comportent généralement de la mise en collection, du barcode, des travaux de taxonomie etc. Un travail d’inventaire sur un site portant sur un ordre d’invertébrés très vaste (Hyménoptères, ou Diptères, Coléoptères ou Lépidoptères, Arachnides etc.) rentre dans cette catégorie', 'SINP', 'Validé', 0, '114.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.6', 'Inventaire pour étude d''impact', 'Inventaire pour étude d''impact', 'Inventaires dans le cadre des procédures réglementaires d’études d’impact ou d’études d’incidence, avant la réalisation des impacts. Les suivis réglementaires post-implantatoires (ex mortalité chiroptères) ou de compensation ne sont pas concernés par cette catégorie (relève catégorie 5.4)', 'SINP', 'Validé', 0, '114.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '3.7', 'Cartographie d’habitat d’un site', 'Cartographie d’habitat d’un site', 'Données correspondant à une cartographie des végétations-habitats-écosystèmes pour un site, dans une logique d’appui à la gestion (détermination des enjeux, adaptation de la gestion etc.) Les approches terrain, les traitements d’image ou la combinaison des deux sont incluses. Les relevés de communauté d’espèces (généralement végétation/relevés phytosociologiques ou benthos pour les habitats marins) réalisés dans le cadre d’un inventaire ou d’une cartographie des végétations-habitats-écosystèmes d’un site. Si seuls des relevés sont effectués (sans détermination du type de végétation ou habitat), il faut affecter à une autre rubrique.', 'SINP', 'Validé', 0, '114.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '4.1', 'Évaluation de la ressource / prélèvements', 'Évaluation de la ressource / prélèvements', 'Inventaires et suivis piscicoles, de pêcheries, halieutiques, cynégétiques, pharmaceutiques ou dendrologiques afin de quantifier la ressource disponible, les stocks ou les prélèvements effectués (tableau de chasse...)', 'SINP', 'Validé', 0, '114.018', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '4.2', 'Évaluation des collisions/échouages', 'Évaluation des collisions/échouages', 'Recensement et suivi des points de collisions faune / infrastructure linéaire de transport. On met également dans cette rubrique les suivis d’échouages d’animaux marins (tortues, cétacés...)', 'SINP', 'Validé', 0, '114.019', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '5.1', 'Suivi individus centré', 'Suivi individus centré', 'Travaux, généralement dans le domaine de la recherche, visant à étudier le comportement à l’échelle d’un individu : dispersion, trajectoire de déplacement, trajectoire migratoire, occupation de l’espace à différentes périodes... etc.', 'SINP', 'Validé', 0, '114.020', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '5.2', 'Surveillance temporelle d''espèces', 'Surveillance temporelle d''espèces', 'Cette catégorie comprend uniquement des données obtenues selon un protocole répété dans le temps qui vise à fournir une image fiable de l’évolution des variables mesurées à l’échelle d’une population, d’une espèce ou de plusieurs espèces mais qui ne constituent pas une communauté en interaction. Elle concerne une échelle généralement assez vaste (réseaux de sites, département à national), un échantillonnage généralement représentatif, exhaustif ou régulier et ne vise pas directement à tester une hypothèse avec manipulation (si c’est le cas, catégorie 5.). Les cas de répétition d’atlas permettant in fine de mesurer des changements de distribution entrent dans la catégorie 1.2', 'SINP', 'Validé', 0, '114.021', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '5.3', 'Surveillance communauté d’espèces', 'Surveillance communauté d’espèces', 'Cette catégorie comprend uniquement des données obtenues selon un protocole de relevés d’espèces en interaction répétés dans le temps, qui vise à fournir une image fiable de l’évolution dans le temps des variables mesurées concernant une communauté d’espèces, éventuellement rattachée à un type d’habitat. Elle concerne une échelle assez vaste (réseaux de sites, département à national), un échantillonnage généralement représentatif, exhaustif ou régulier et ne vise pas directement à tester une hypothèse avec manipulation (si c’est le cas, catégorie 6.2 ou 6.3)', 'SINP', 'Validé', 0, '114.022', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '5.4', 'Surveillance des habitats', 'Surveillance des habitats', 'Cette catégorie comprend uniquement des données obtenues selon un protocole répété dans le temps qui vise à fournir une image fiable de l’évolution dans le temps de la présence et/ou surface d’un habitat au sens large (végétation, écosystème...). Elle concerne une échelle généralement assez vaste (réseaux de sites, département à national), un échantillonnage généralement représentatif, exhaustif ou régulier et ne vise pas directement à tester une hypothèse avec manipulation (si c’est le cas, catégorie 6.2). Les relevés de communauté d’espèces (généralement végétation/relevés phytosociologiques ou benthos pour les habitats marins) réalisé pour la surveillance entrent dans ce cadre. Si seuls des relevés sont effectués (sans détermination du type de végétation ou habitat), il faut affecter à la rubrique précédente', 'SINP', 'Validé', 0, '114.023', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '5.5', 'Surveillance de pathogènes et EEE', 'Surveillance de pathogènes et EEE', 'Dispositifs dédiés à détecter la présence (ou l’abondance...) et suivre l’évolution d’espèces ayant un impact négatif sur l’agriculture, la sylviculture, la santé ou la biodiversité... Participatifs ou professionnels, enquêtes... Les observations connexes de ces protocoles entrent aussi dans cette catégorie mais devraient idéalement faire l’objet d’un autre jeu de données. Les suivis des espèces dites « nuisibles » entrent dans cette catégorie', 'SINP', 'Validé', 0, '114.024', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '6.1', 'Surveillance site', 'Surveillance site', 'Il s’agit des dispositifs de surveillance/ veille dans le temps pour détecter sans a priori des changements des variables mesurées (abondance d’une population d’espèce à enjeux, traits des individus, indice d’abondance, taux d’occupation, traits et autres métriques de communauté d’espèces, surface d’occupation de végétations-habitats-écosystèmes...). Elle concerne une échelle locale (site ou réseau de sites pré-déterminés – réseaux de réserves etc.). Ne vise pas directement à tester une hypothèse avec manipulation (si c’est le cas, catégorie 6.2). Design expérimental : série temporelle', 'SINP', 'Validé', 0, '114.025', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '6.2', 'Suivis de gestion ou expérimental', 'Suivis de gestion ou expérimental', 'Suivi dans le temps (avant/ après, avec éventuellement des contrôles) couplant des espèces ou communautés, des végétations-habitats-écosystèmes, et une action de gestion (y compris la non intervention) ou d’une pression afin d’en déterminer l’effet. Généralement dans un cadre d’espace naturel ou de la restauration ou encore pour la compensation (vérification d’un gain dans le temps) voir des travaux de recherche. Concerne généralement un site ou un réseau de sites. Design expérimental : B/A (before/after) et BACI (before/after control/impact) Un éventuel dispositif adaptatif à large échelle entrerait dans cette catégorie', 'SINP', 'Validé', 0, '114.026', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '6.3', 'Étude effet gestion', 'Étude effet gestion', 'Étude des effets de la gestion (ou de pression, ou non gestion etc.) sur des espèces ou communautés, des végétations-habitats-écosystèmes, avec une substitution espace/temps. C’est-à-dire que l’effet est mesuré uniquement à un temps t, en comparant différents historiques de gestions mais sans mesure avant/après (si avant/après : 6.2). Design expérimental : C/I (control/ impact)', 'SINP', 'Validé', 0, '114.027', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '6.4', 'Suivis réglementaires', 'Suivis réglementaires', 'Il s’agit des suivis temporels visant à suivre les impacts après implantation d’un ouvrage, imposés par la loi ou lors de l’autorisation de réalisation des travaux. Par exemples les suivis de mortalité des oiseaux et chiroptères après mise en place d’un parc éolien. Les suivis réglementaires dans le cadre de compensations entrent aussi dans cette catégorie', 'SINP', 'Validé', 0, '114.028', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '7.1', 'Regroupement de données', 'Regroupement de données', 'Catégorie à utiliser quand le jeu de données mélange divers types de données, sans métadonnées permettant pour l’instant de les séparer en jeux de données plus précis et plus cohérents. On peut inclure ici les CA et JDD constitué par des regroupements de Données Elémentaires d''Echange (DEE) pour réaliser un atlas, uniquement quand l’objectif original de collecte des données n’est pas déterminable. Lorsqu’on ne dispose pas d’information sur les raisons de l’acquisition des données, cette rubrique doit être utilisée', 'SINP', 'Validé', 0, '114.029', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('JDD_OBJECTIFS'), '7.2', 'Autres études et programmes', 'Autres études et programmes', 'Cas n’entrant pas clairement dans les autres rubriques. Dans ce cas les métadonnées (champ libres « description » et « protocole » des fiches de métadonnées) devront bien expliquer en quoi consiste le but de l’acquisition des données', 'SINP', 'Validé', 0, '114.030', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '1', 'Non renseigné', 'Non renseigné', 'La méthode de détermination n''a pas été renseignée', 'GEONATURE', 'non validé', 0, '106.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), 'CHI', 'Site chiroptère', 'Site chiroptère', 'Site pour le suivi des chiroptères', 'GEONATURE', 'Non validé', 0, '116.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '1', 'Grotte', 'Grotte', 'Site chiroptères de type grotte', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.001', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '2', 'Mine', 'Mine', 'Site chiroptères de type mine', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '3', 'Bâti', 'Bâti', 'Site chiroptères de type bâti', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '4', 'Arbre', 'Arbre', 'Site chiroptères de type arbre', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '5', 'Rocher', 'Rocher', 'Site chiroptères de type rocher', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '6', 'Hors gîte', 'Hors gîte', 'Site chiroptères de type hors gîte', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_SITE'), '7', 'Indéterminé', 'Indéterminé', 'Site chiroptères de type indéterminé', 'GEONATURE', 'Non validé', get_id_nomenclature('TYP_SITE', 'CHI'), '116.001.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '12', 'Examen des organes reproducteurs ou critères spécifiques sur le terrain', 'Examen des organes reproducteurs ou critères spécifiques sur le terrain', 'La détermination repose sur l''examen des organes reproducteurs ou autres critères spécifiques directement sur le terrain', 'GEONATURE', 'non validé', 0, '106.012', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '13', 'Examen des restes de l’individu sous loupe ou microscope', 'Examen des restes de l’individu sous loupe ou microscope', 'La détermination repose sur un examen visuel précis des restes (fragments ou résidus) de l''individu sous loupe ou microscope ', 'GEONATURE', 'non validé', 0, '106.013', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '14', 'Examen visuel des restes de l’individu', 'Examen visuel des restes de l’individu', 'La détermination repose sur un examen visuel des restes (fragments ou résidus) de l''individu à l''œil nu', 'GEONATURE', 'non validé', 0, '106.014', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '15', 'Examen des restes de l''individu sur photo ou vidéo', 'Examen des restes de l''individu sur photo ou vidéo', 'La détermination repose sur un examen visuel des restes (fragments ou résidus) de l''individu sur photographie ou vidéo', 'GEONATURE', 'non validé', 0, '106.015', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '16', 'Examen des traces ou indices de présence sur photo ou vidéo', 'Examen des traces ou indices de présence sur photo ou vidéo', 'La détermination repose sur l''examen de photographies ou de vidéos représentant des traces ou indices de présences', 'GEONATURE', 'non validé', 0, '106.016', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '17', 'Examen direct des traces ou indices de présence', 'Examen direct des traces ou indices de présence', 'La détermination repose sur l''examen direct des traces ou indices de présences par le déterminateur', 'GEONATURE', 'non validé', 0, '106.017', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '18', 'Examen visuel à distance', 'Examen visuel à distance', 'La détermination a été effectuée à distance sur le terrain, à l''œil nu ou à l''aide de longue vue, jumelles etc', 'GEONATURE', 'non validé', 0, '106.018', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '19', 'Examen visuel en collection ', 'Examen visuel en collection ', 'La détermination repose sur l''examen visuel d''un individu en collection : boite entomologique, herbier, collections en alcool ou formol…', 'GEONATURE', 'non validé', 0, '106.019', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '20', 'Examen visuel sous loupe ou microscope', 'Examen visuel sous loupe ou microscope', 'La détermination repose sur l''examen précis de l''individu sous loupe ou microscope', 'GEONATURE', 'non validé', 0, '106.020', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '21', 'Examen visuel de l’individu en main', 'Examen visuel de l’individu en main', 'La détermination repose sur l''examen direct de l''individu en main à l''œil nu', 'GEONATURE', 'non validé', 0, '106.021', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('METH_DETERMIN'), '22', 'Examen visuel sur photo ou vidéo', 'Examen visuel sur photo ou vidéo', 'La détermination repose sur l''examen de photographies ou de vidéos sur lesquelles apparait l''espèce', 'GEONATURE', 'non validé', 0, '106.022', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('STATUT_VALID'), '0', 'En attente de validation', 'En attente de validation', 'Le travail de validation n''a pas encore été réalisé. Le statut de validation est en attente', 'GEONATURE', 'non validé', 0, '101.000', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '2', 'Photo', 'Photo', 'Média de type image', 'GEONATURE', 'Non validé', 0, '117.002', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '3', 'Page web', 'Page web', 'Média de type page web', 'GEONATURE', 'Non validé', 0, '117.003', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '4', 'PDF', 'PDF', 'Média de type document PDF', 'GEONATURE', 'Non validé', 0, '117.004', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '5', 'Audio', 'Audio', 'Média de type fichier audio mp3', 'GEONATURE', 'Non validé', 0, '117.005', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '6', 'Vidéo (fichier)', 'Vidéo (fichier)', 'Média de type fichier vidéo hébergé', 'GEONATURE', 'Non validé', 0, '117.006', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '7', 'Vidéo Youtube', 'Vidéo Youtube', 'ID d''une video hébergée sur Youtube', 'GEONATURE', 'Non validé', 0, '117.007', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '8', 'Vidéo Dailymotion', 'Vidéo Dailymotion', 'ID d''une video hébergée sur Dailymotion', 'GEONATURE', 'Non validé', 0, '117.008', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('TYPE_MEDIA'), '9', 'Vidéo Vimeo', 'Vidéo Vimeo', 'ID d''une video hébergée sur Vimeo', 'GEONATURE', 'Non validé', 0, '117.009', '2018-07-04 16:41:12.551179', '2018-07-04 16:41:12.594534', true)
,(get_id_nomenclature_type('CONFID'), '1', 'Public', 'Public', 'Public : la fiche du site n''est pas confidentielle.', 'SINP', 'Validé', 0, '031.001', '2016-04-08 00:00:00', '2016-04-08 00:00:00', true)
,(get_id_nomenclature_type('CONFID'), '2', 'Confidentiel', 'Confidentiel', 'Confidentiel : la fiche a un niveau de confidentialité élevé.', 'SINP', 'Validé', 0, '031.002', '2016-04-08 00:00:00', '2016-04-08 00:00:00', true)
,(get_id_nomenclature_type('SOCIAB'), '1', '1', '1', '1 : Individu qui pousse seul', 'SINP', 'Validé', 0, '072.001', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('SOCIAB'), '2', '2', '2', '2 : Individu cespiteux, qui pousse en touffe', 'SINP', 'Validé', 0, '072.002', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('SOCIAB'), '3', '3', '3', '3 : Individu qui pousse en groupe formant de petits patchs ou des coussins', 'SINP', 'Validé', 0, '072.003', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('SOCIAB'), '4', '4', '4', '4 : Individu qui pousse en colonie formant de grands patchs ou des tapis', 'SINP', 'Validé', 0, '072.004', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('SOCIAB'), '5', '5', '5', '5 : Individu qui pousse en grand nombre, population pure, monospécifique', 'SINP', 'Validé', 0, '072.005', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('METHOD_CALCUL_SURFACE'), 'es', 'es','Estimée : la surface est estimée par l''opérateur', 'Estimée : la surface est estimée par l''opérateur', 'SINP', 'Validé', 0, '120.001', '2018-05-09', '2018-05-09', true)
,(get_id_nomenclature_type('METHOD_CALCUL_SURFACE'), 'sig', 'sig','La surface est calculée directement par usage d''un logiciel SIG', 'La surface est calculée directement par usage d''un logiciel SIG', 'SINP', 'Validé', 0, '120.002', '2018-05-09', '2018-05-09', true)
,(get_id_nomenclature_type('METHOD_CALCUL_SURFACE'), 'nsp', 'nsp', 'Ne sait pas : la méthode de calcul est inconnue', 'Ne sait pas : la méthode de calcul est inconnue', 'SINP', 'Validé', 0, '120.003', '2018-05-09', '2018-05-09', true)
,(get_id_nomenclature_type('METHOD_CALCUL_SURFACE'), 'lin', 'lin','Calculée à partir de la largeur du linéaire', 'Calculée à partir de la largeur du linéaire', 'SINP', 'Validé', 0, '120.004', '2018-05-09', '2018-05-09', true)
,(get_id_nomenclature_type('DETERMINATION_TYP_HAB'), '0', '0', 'Inconnu', 'Inconnu : le type de détermination n''est pas connu', 'SINP', 'Validé', 0, '118.001','2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('DETERMINATION_TYP_HAB'), '1', '1','Attribué terrain', 'Attribué terrain : la détermination a été attribuée sur le terrain, ou en laboratoire après examens d''éléments en provenance du terrain', 'SINP', 'Validé', 0,'118.002', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('DETERMINATION_TYP_HAB'), '2', '2', 'Expertise a posteriori', 'Expertise a posteriori : La détermination a été attribuée a posteriori sur la base du relevé d''espèces et/ou d''une expertise extérieure et/ou consultation de documents complémentaires.', 'SINP', 'Validé', 0, '118.003','2018-05-09', '2018-05-09', true)
,(get_id_nomenclature_type('DETERMINATION_TYP_HAB'), '3', '3', 'Correspondance typologique : code attribué par l''application d''une correspondance entre typologies existantes de façon automatique.', 'Correspondance typologique : code attribué par l''application d''une correspondance entre typologies existantes de façon automatique', 'SINP', 'Validé', 0,'118.004', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
, (get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '0', '0', 'Ne sait pas', 'Ne sait pas : la technique de collecte utilisée n''est pas connue', 'SINP', 'Validé', 0, '119.001', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '1', '1', 'In situ', 'In situ : observation directe, sur le terrain (parcouru ou longé). Correspond à Observation directe terrestre diurne dans la base de données CAMPANULE', 'SINP', 'Validé', 0,'119.002', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '2', '2','Télédétection (satellite, LIDAR...)', 'Télédétection (satellite, LIDAR...)', 'SINP', 'Validé', 0, '119.003', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '2.1', '2.1', 'Lidar', 'Lidar', 'SINP', 'Validé', 0, '119.004', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '2.2', '2.2', 'Radar', 'Radar', 'SINP', 'Validé', 0,'119.005', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '2.3', '2.3', 'Imagerie numérique aéroportée', 'Imagerie numérique aéroportée', 'SINP', 'Validé', 0, '119.006', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '2.4', '2.4', 'Imagerie satellitaire', 'Imagerie satellitaire', 'SINP', 'Validé', 0,'119.007', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3', '3', 'Techniques acoustiques', 'Techniques acoustiques', 'SINP', 'Validé', 0, '119.008','2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.1', '3.1','Sonar à balayage latéral', 'Sonar à balayage latéral', 'SINP', 'Validé', 0,'119.009', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.2', '3.2','Sondeur multifaisceaux', 'Sondeur multifaisceaux', 'SINP', 'Validé', 0, '119.010', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.3', '3.3', 'Sonar à interféromètre', 'Sonar à interféromètre', 'SINP', 'Validé', 0, '119.011', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.4', '3.4', 'Sonar à interféromètre', 'Sonar à interféromètre', 'SINP', 'Validé', 0,'119.012', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.5', '3.5','Imagerie sismique', 'Imagerie sismique', 'SINP', 'Validé', 0,'119.013', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.6', '3.6', 'Sondeur de sédiments', 'Sondeur de sédiments', 'SINP', 'Validé', 0, '119.014', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '3.7', '3.7', 'Sondeur monofaisceau', 'Sondeur monofaisceau', 'SINP', 'Validé', 0,'119.015', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '4', '4','Modélisation', 'Modélisation', 'SINP', 'Validé', 0, '119.016','2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '5', '5','Observation à distance (jumelles par exemple).', 'Observation à distance (jumelles par exemple).', 'SINP', 'Validé', 0,'119.017', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '6', '6', 'Observation directe marine (observation en plongée)', 'Observation directe marine (observation en plongée)', 'SINP', 'Validé', 0,'119.018', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '7', '7', 'Extrapolation', 'Extrapolation', 'SINP', 'Validé', 0,'119.019', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8', '8', 'Techniques de prélèvements in situ', 'Techniques de prélèvements in situ', 'SINP', 'Validé', 0,'119.020', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.1', '8.1', 'Plongées','Plongées', 'SINP', 'Validé', 0,'119.021', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.2', '8.2','Mesures géotechniques', 'Mesures géotechniques', 'SINP', 'Validé', 0,'119.022', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.3', '8.3', 'Prélèvement à la benne', 'Prélèvement à la benne', 'SINP', 'Validé', 0,'119.023', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.4', '8.4', 'Prélèvement au chalut ou à la drague', 'Prélèvement au chalut ou à la drague', 'SINP', 'Validé', 0, '119.024', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.4.1', '8.4.1', 'Prélèvement au chalut', 'Prélèvement au chalut', 'SINP', 'Validé', 0,'119.025', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.4.2', '8.4.2', 'Prélèvement à la drague', 'Prélèvement à la drague', 'SINP', 'Validé', 0, '119.026', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '8.5', '8.5', 'Carottage', 'Carottage', 'SINP', 'Validé', 0, '119.027','2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '9', '9', 'Vidéo et photographies', 'Vidéo et photographies', 'SINP', 'Validé', 0, '119.028', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '9.1', '9.1', 'Imagerie des profils sédimentaires', 'Imagerie des profils sédimentaires', 'SINP', 'Validé', 0,'119.029', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '9.2', '9.2', 'Caméra tractée ou téléguidée', 'Caméra tractée ou téléguidée', 'SINP', 'Validé', 0, '2018-05-09 00:00:00', '119.030', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '9.3', '9.3',  'Observation marine photographique (observation photographique en plongée)', 'Observation marine photographique (observation photographique en plongée)', 'SINP', 'Validé', 0, '119.031', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '9.4', '9.4', 'Observation photographique aérienne, prise de vue aérienne, suivie d''une photointerprétation', 'Observation photographique aérienne, prise de vue aérienne, suivie d''une photointerprétation', 'SINP', 'Validé', 0, '119.032', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '9.5', '9.5', 'Observation photographique terrestre suivie d''une photointerprétation.', 'Observation photographique terrestre suivie d''une photointerprétation.', 'SINP', 'Validé', 0, '119.033',  '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('TECHNIQUE_COLLECT_HAB'), '10', '10',  'Autre, préciser', 'Autre, préciser', 'SINP', 'Validé', 0, '119.034',  '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('CA_OBJECTIFS'), '8', 'InvCart', 'Inventaires et cartographie', 'L''acquisition des données d''occurrence est réalisée avec la démarche d''avoir des informations sur la présence/absence ou effectif/abondance (dénombrement…) d''un ou de plusieurs objets de biodiversité. Le dispositif de collecte est établi pour avoir une représentation spatiale de la répartition d''un ou de plusieurs objets de biodiversité à des dates ou des périodes prédéfinies.', 'SINP', 'Validé', 0, '108.008', '2020-08-28 0:00:00.000001', '2020-08-28 0:00:00.000001', true)
,(get_id_nomenclature_type('CA_OBJECTIFS'), '9', 'SuivSurv', 'Suivi/surveillance dans le temps', 'L''acquisition des données d''occurrence est réalisée avec un dispositif de collecte comprenant une répétition de l''acquisition au cours du temps. La démarche permet une comparaison d''un état entre différentes périodes pour un ou plusieurs objets de biodiversité. Elle est mise en place en lien avec une thématique prédéterminée (biologie de la conservation, changements globaux, …).', 'SINP', 'Validé', 0, '108.009', '2020-08-28 0:00:00.000001', '2020-08-28 0:00:00.000001', true)
,(get_id_nomenclature_type('CA_OBJECTIFS'), '10', 'Exp/Rech', 'Expérimentation/recherche', 'L''acquisition des données est réalisée avec une démarche d''amélioration de la connaissance scientifique ciblée sur une ou plusieurs questions précises (de la description des patrons de biodiversité à l''expérimentation pour expliquer les processus ou démontrer des relations causales de type ''avant/après'' (effet de la gestion, mécanismes etc.)). L''expérimentation et la recherche de type purement ''observationnelle'' ou ''corrélative'' doivent figurer dans les catégories ''inventaires'' ou ''suivis/surveillance''.', 'SINP', 'Validé', 0, '108.010', '2020-08-28 0:00:00.000001', '2020-08-28 0:00:00.000001', true)
,(get_id_nomenclature_type('CA_OBJECTIFS'), '11', 'MultAutr', 'Multiples ou autres', 'L''acquisition des données est réalisée avec une démarche propre faisant intervenir plusieurs démarches préalablement décrites.', 'SINP', 'Validé', 0, '108.011', '2020-08-28 0:00:00.000001', '2020-08-28 0:00:00.000001', true)


-- ABONDANCE
,(get_id_nomenclature_type('ABONDANCE_HAB'), '1', '1', 'Recouvrement très faible', 'Recouvrement très faible', 'SINP', 'Validé', 0, '120.001',  '2017-02-08 00:00:00', '2017-09-27 00:00:00', true)
,(get_id_nomenclature_type('ABONDANCE_HAB'), '2', '2', 'Habitat recouvrant environ 1/20 à 1/4 de la surface (5 à 25 %)', 'Habitat recouvrant environ 1/20 à 1/4 de la surface (5 à 25 %)', 'SINP', 'Validé', 0, '120.002', '2017-02-08 00:00:00', '2017-09-27 00:00:00', true)
,(get_id_nomenclature_type('ABONDANCE_HAB'), '3', '3', 'Habitat recouvrant environ 1/4 à 1/2 de la surface (25 à 50 %)', 'Habitat recouvrant environ 1/4 à 1/2 de la surface (25 à 50 %)', 'SINP', 'Validé', 0,'120.003', '2017-02-08 00:00:00', '2017-09-27 00:00:00', true)
,(get_id_nomenclature_type('ABONDANCE_HAB'), '4', '4', 'Habitat recouvrant environ 1/2 à 3/4 de la surface (50 à 75 %)', 'Habitat recouvrant environ 1/2 à 3/4 de la surface (50 à 75 %)', 'SINP', 'Validé', 0,'120.004', '2017-02-08 00:00:00', '2017-09-27 00:00:00', true)
,(get_id_nomenclature_type('ABONDANCE_HAB'), '5', '5', 'Habitat recouvrant plus des 3/4 de la surface (>75 %)', 'Habitat recouvrant plus des 3/4 de la surface (>75 %)', 'SINP', 'Validé', 0,'120.005', '2017-02-08 00:00:00', '2017-09-27 00:00:00', true)
,(get_id_nomenclature_type('HAB_INTERET_COM'), '1', 'Oui', 'Oui : l''habitat est bien d''intérêt communautaire.', 'Oui : l''habitat est bien d''intérêt communautaire.', 'SINP', 'Validé', 0, '121.001', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('HAB_INTERET_COM'), '2', 'Non', 'Non : l''habitat n''est pas d''intérêt communautaire', 'Non : l''habitat n''est pas d''intérêt communautaire', 'SINP', 'Validé', 0,'121.002', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
,(get_id_nomenclature_type('HAB_INTERET_COM'), '3', 'OuiPrio', 'Oui, prioritaire : Oui, l''habitat est d''intérêt communautaire prioritaire. Exemple : Pelouses calcicoles riches en orchidées.', 'Oui, prioritaire : Oui, l''habitat est d''intérêt communautaire prioritaire. Exemple : Pelouses calcicoles riches en orchidées.', 'SINP', 'Validé', 0, '121.003', '2018-05-09 00:00:00', '2018-05-09 00:00:00', true)
-- exposition
,(get_id_nomenclature_type('EXPOSITION'), 'E', 'E', 'Est', 'Est : 78.75° - 101.25°', 'SINP', 'Validé', 0, '121.001', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'ENE', 'ENE', 'Est-Nord-Est', 'Est-Nord-Est : 56.25° - 78.75°', 'SINP', 'Validé', 0, '121.002', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'ESE', 'ESE', 'Est-Sud-Est', 'Est-Sud-Est : 101.25° - 123.75°', 'SINP', 'Validé', 0, '121.003', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'N', 'N', 'Nord', 'Nord : 348.75° - 11.25°', 'SINP', 'Validé', 0, '121.004', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'NE', 'NE', 'Nord-Est', 'Nord-Est : 33.75° - 56.25°', 'SINP', 'Validé', 0, '121.005', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'NNE', 'NNE', 'Nord-Nord-Est', 'Nord-Nord-Est : 11.25° - 33.75°', 'SINP', 'Validé', 0,'121.006', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'NNO', 'NNO', 'Nord-Nord-Ouest', 'Nord-Nord-Ouest : 326.25° - 348.75°', 'SINP', 'Validé', 0,'121.007', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'NO', 'NO','Nord-Ouest', 'Nord-Ouest : 303.75° - 326.25 °', 'SINP', 'Validé', 0, '121.008', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'O', 'O', 'Ouest', 'Ouest : 258.75° - 281.25°', 'SINP', 'Validé', 0, '121.009', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'ONO', 'ONO', 'Ouest-Nord-Ouest', 'Ouest-Nord-Ouest : 281.25° - 303.75 °', 'SINP', 'Validé', 0, '121.010', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'OSO', 'OSO',  'Ouest-Sud-Ouest', 'Ouest-Sud-Ouest : 236.25° - 258.75°', 'SINP', 'Validé', 0, '121.011', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'S', 'S', 'Sud', 'Sud : 168.75° - 191.25°', 'SINP', 'Validé', 0,'121.012', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'SE', 'SE', 'Sud-Est', 'Sud-Est : 123.75°- 146.25°', 'SINP', 'Validé', 0, '121.013', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'SO', 'SO', 'Sud-Ouest', 'Sud-Ouest : 213.75° - 236.25°', 'SINP', 'Validé', 0, '121.014', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'SSE', 'SSE', 'Sud-Sud-Est', 'Sud-Sud-Est : 146.25° - 168.75°', 'SINP', 'Validé', 0, '121.015', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
,(get_id_nomenclature_type('EXPOSITION'), 'SSO', 'SSO','Sud-Sud-Ouest', 'Sud-Sud-Ouest : 191.25° - 213.75°', 'SINP', 'Validé', 0, '121.016', '2016-06-21 00:00:00', '2016-06-21 00:00:00', true)
-- comportement
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '0', 'NSP', 'Inconnu', 'Inconnu : Le statut biologique de l''individu n''est pas connu.', 'SINP', 'Validé', 0, '122.000', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '1', '1', 'Non renseigné', 'Non renseigné : Le statut biologique de l''individu n''a pas été renseigné.', 'SINP', 'Validé', 0, '122.001', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '2', '2', 'Echouage', 'Echouage : l''individu tente de s''échouer ou vient de s''échouer sur le rivage', 'SINP', 'Validé', 0, '122.002', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '3', '3', 'Dortoir', 'Dortoir : individus se regroupant dans une zone définie pour y passer la nuit ou la journée.', 'SINP', 'Validé', 0, '122.003', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '4', '4', 'Migration', 'Migration : L''individu (ou groupe d''individus) est en migration active', 'SINP', 'Validé', 0, '122.004', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '5', '5', 'Construction de toile', 'Construction de toile : l''individu construit sa toile', 'SINP', 'Validé', 0, '122.005', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '6', '6', 'Halte migratoire', 'Halte migratoire : Indique que l''individu procède à une halte au cours de sa migration, et a été découvert sur sa zone de halte.', 'SINP', 'Validé', 0, '122.006', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '7', '7', 'Swarming', 'Swarming : Indique que l''individu a un comportement de swarming : il se regroupe avec d''autres individus de taille similaire, sur une zone spécifique, ou en mouvement.', 'SINP', 'Validé', 0, '122.007', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '8', 'ChassAlim', 'Chasse/alimentation', 'Chasse / alimentation : Indique que l''individu est sur une zone qui lui permet de chasser ou de s''alimenter.', 'SINP', 'Validé', 0, '122.008', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '9', 'Hivernage', 'Hivernage', 'Hivernage : l''individu hiverne (modification de son comportement liée à l''hiver pouvant par exemple comporter un changement de lieu, d''alimentation, de production de sève ou de graisse...)', 'SINP', 'Validé', 0, '122.009', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '10', '10', 'Passage en vol', 'Passage en vol : Indique que l''individu est de passage et en vol.', 'SINP', 'Validé', 0, '122.010', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '11', '11', 'Erratique', 'Erratique : Individu d''une ou de populations d''un taxon qui ne se trouve, actuellement, que de manière occasionnelle dans les limites d’une région. Il a été retenu comme seuil, une absence de 80% d''un laps de temps donné (année, saisons...).', 'SINP', 'Validé', 0, '122.011', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '12', '12', 'Sédentaire', 'Sédentaire : Individu demeurant à un seul emplacement, ou restant toute l''année dans sa région d''origine, même s''il effectue des déplacements locaux.', 'SINP', 'Validé', 0, '122.012', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '13', '13', 'Estivage', 'Estivage : l''individu estive (modification de son comportement liée à l''été pouvant par exemple comporter un changement de lieu, d''alimentation, de production de sève ou de graisse...)', 'SINP', 'Validé', 0, '122.013', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '14', '14', 'Nourrissage des jeunes', 'Nourrissage des jeunes', 'SINP', 'Validé', 0, '122.014', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '15', '15', 'Posé', 'Posé : Individu(s) posé(s)', 'SINP', 'Validé', 0, '122.015', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '16', '16', 'Déplacement', 'Déplacement : Individu(s) en déplacement', 'SINP', 'Validé', 0, '122.016', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '17', '17', 'Repos', 'Repos', 'SINP', 'Validé', 0, '122.017', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '18', '18', 'Chant', 'Chant', 'SINP', 'Validé', 0, '122.018', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '19', '19', 'Accouplement', 'Accouplement', 'SINP', 'Validé', 0, '122.019', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '20', '20', 'Cœur copulatoire', 'Cœur copulatoire', 'SINP', 'Validé', 0, '122.020', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '21', '21', 'Tandem',  'Tandem', 'SINP', 'Validé', 0, '122.021', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '22', '22', 'Territorial', 'Territorial', 'SINP', 'Validé', 0, '122.022', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
,(get_id_nomenclature_type('OCC_COMPORTEMENT'), '23', '23', 'Pond', 'Pond', 'SINP', 'Validé', 0, '122.023', '2020-08-31 00:00:00', '2020-08-31 00:00:00', true)
;



--SELECT pg_catalog.setval('t_nomenclatures_id_nomenclature_seq', 501, true);

UPDATE t_nomenclatures SET label_default = label_fr;
UPDATE t_nomenclatures SET definition_default = definition_fr;
ALTER TABLE t_nomenclatures ALTER COLUMN label_default SET NOT NULL;
ALTER TABLE t_nomenclatures ALTER COLUMN label_fr SET NOT NULL;

-- inserting organism représenting all organisms with 0 as id_organisme
DO
$$
BEGIN
INSERT INTO utilisateurs.bib_organismes (nom_organisme, adresse_organisme, cp_organisme, ville_organisme, tel_organisme, fax_organisme, email_organisme) VALUES ('ALL', 'Représente tous les organismes', NULL, NULL, NULL, NULL, NULL);
EXCEPTION WHEN unique_violation  THEN
        RAISE NOTICE 'Tentative d''insertion de valeur existante. L''instruction a été ignorée.';
END
$$;

INSERT INTO defaults_nomenclatures_value (mnemonique_type, id_organism, id_nomenclature) VALUES
('DATA_TYP',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('DATA_TYP', '1'))
,('DS_PUBLIQUE',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('DS_PUBLIQUE', 'Pu'))
,('JDD_OBJECTIFS',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('JDD_OBJECTIFS', '1.1'))
,('METH_DETERMIN',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('METH_DETERMIN', '1'))
,('METHO_RECUEIL',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('METHO_RECUEIL', '1'))
,('NIVEAU_TERRITORIAL',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('NIVEAU_TERRITORIAL', '3'))
,('RESOURCE_TYP',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('RESOURCE_TYP', '1'))
,('STATUT_SOURCE',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('STATUT_SOURCE', 'Te'))
,('STATUT_VALID',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('STATUT_VALID', '0'))
,('TYPE_FINANCEMENT',(SELECT id_organisme FROM utilisateurs.bib_organismes WHERE nom_organisme = 'ALL'),get_id_nomenclature('TYPE_FINANCEMENT', '1'))
;


