"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cleanup = void 0;
const path = require("path");
const fs = require("fs-extra");
const glob = require("glob");
const common_1 = require("./common");
const logging = require("./logging");
function cleanup(dir, exclude) {
    try {
        for (const f of findGeneratedFiles(dir, exclude)) {
            fs.removeSync(f);
        }
    }
    catch (e) {
        logging.warn(`warning: failed to clean up generated files: ${e.stack}`);
    }
}
exports.cleanup = cleanup;
function findGeneratedFiles(dir, exclude) {
    const ignore = [...readGitIgnore(dir), 'node_modules/**', ...exclude, '.git/**'];
    const files = glob.sync('**', {
        ignore,
        cwd: dir,
        dot: true,
        nodir: true,
        absolute: true,
    });
    const generated = new Array();
    for (const file of files) {
        const contents = fs.readFileSync(file, 'utf-8');
        if (contents.includes(common_1.PROJEN_MARKER)) {
            generated.push(file);
        }
    }
    return generated;
}
function readGitIgnore(dir) {
    const filepath = path.join(dir, '.gitignore');
    if (!fs.pathExistsSync(filepath)) {
        return [];
    }
    return fs.readFileSync(filepath, 'utf-8')
        .split('\n')
        .filter(x => (x === null || x === void 0 ? void 0 : x.trim()) !== '')
        .filter(x => !x.startsWith('#') && !x.startsWith('!'))
        .map(x => x.replace(/^\//, '')) // remove "/" prefix
        .map(x => `${x}\n${x}/**`)
        .join('\n')
        .split('\n');
}
//# sourceMappingURL=data:application/json;base64,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