"""Schlage devices."""

from enum import Enum


class DeviceType(str, Enum):
    """Known device types."""

    BRIDGE = "br400"
    DENALI = "be489"
    DENALI_BLE = "be489ble"
    DENALI_MCKINLEY = "be489wb2"
    DENALI_MCKINLEY_BLE = "be489ble2"
    DENALI_MCKINLEY_WIFI = "be489wifi2"
    DENALI_WIFI = "be489wifi"
    ENCODE_LEVER = "fe789"
    ENCODE_LEVER_BLE = "fe789ble"
    ENCODE_LEVER_MCKINLEY = "fe789wb2"
    ENCODE_LEVER_MCKINLEY_BLE = "fe789ble2"
    ENCODE_LEVER_MCKINLEY_WIFI = "fe789wifi2"
    ENCODE_LEVER_WIFI = "fe789wifi"
    JACKALOPE = "be499"
    JACKALOPE_BLE = "be499ble"
    JACKALOPE_MCKINLEY = "be499wb2"
    JACKALOPE_MCKINLEY_BLE = "be499ble2"
    JACKALOPE_MCKINLEY_WIFI = "be499wifi2"
    JACKALOPE_WIFI = "be499wifi"
    SENSE = "be479"
