"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnAuthorizationRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A client VPN authorization rule
 */
class ClientVpnAuthorizationRule extends core_1.Resource {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnAuthorizationRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ClientVpnAuthorizationRule);
            }
            throw error;
        }
        if (!props.clientVpnEndoint && !props.clientVpnEndpoint) {
            throw new Error('ClientVpnAuthorizationRule: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified');
        }
        if (props.clientVpnEndoint && props.clientVpnEndpoint) {
            throw new Error('ClientVpnAuthorizationRule: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified' +
                ', but not both');
        }
        const clientVpnEndpoint = props.clientVpnEndoint || props.clientVpnEndpoint;
        super(scope, id);
        new ec2_generated_1.CfnClientVpnAuthorizationRule(this, 'Resource', {
            clientVpnEndpointId: clientVpnEndpoint.endpointId,
            targetNetworkCidr: props.cidr,
            accessGroupId: props.groupId,
            authorizeAllGroups: !props.groupId,
            description: props.description,
        });
    }
}
exports.ClientVpnAuthorizationRule = ClientVpnAuthorizationRule;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnAuthorizationRule[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnAuthorizationRule", version: "1.194.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xpZW50LXZwbi1hdXRob3JpemF0aW9uLXJ1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbGllbnQtdnBuLWF1dGhvcml6YXRpb24tcnVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBeUM7QUFHekMsbURBQWdFO0FBOENoRTs7R0FFRztBQUNILE1BQWEsMEJBQTJCLFNBQVEsZUFBUTtJQUN0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXNDOzs7Ozs7K0NBRHJFLDBCQUEwQjs7OztRQUVuQyxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFO1lBQ3ZELE1BQU0sSUFBSSxLQUFLLENBQ2IseUdBQXlHLENBQzFHLENBQUM7U0FDSDtRQUNELElBQUksS0FBSyxDQUFDLGdCQUFnQixJQUFJLEtBQUssQ0FBQyxpQkFBaUIsRUFBRTtZQUNyRCxNQUFNLElBQUksS0FBSyxDQUNiLHlHQUF5RztnQkFDdkcsZ0JBQWdCLENBQ25CLENBQUM7U0FDSDtRQUNELE1BQU0saUJBQWlCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixJQUFJLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUM1RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksNkNBQTZCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNsRCxtQkFBbUIsRUFBRSxpQkFBa0IsQ0FBQyxVQUFVO1lBQ2xELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQzdCLGFBQWEsRUFBRSxLQUFLLENBQUMsT0FBTztZQUM1QixrQkFBa0IsRUFBRSxDQUFDLEtBQUssQ0FBQyxPQUFPO1lBQ2xDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztTQUMvQixDQUFDLENBQUM7S0FDSjs7QUF0QkgsZ0VBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUNsaWVudFZwbkVuZHBvaW50IH0gZnJvbSAnLi9jbGllbnQtdnBuLWVuZHBvaW50LXR5cGVzJztcbmltcG9ydCB7IENmbkNsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlIH0gZnJvbSAnLi9lYzIuZ2VuZXJhdGVkJztcblxuLyoqXG4gKiBPcHRpb25zIGZvciBhIENsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2xpZW50VnBuQXV0aG9yaXphdGlvblJ1bGVPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBJUHY0IGFkZHJlc3MgcmFuZ2UsIGluIENJRFIgbm90YXRpb24sIG9mIHRoZSBuZXR3b3JrIGZvciB3aGljaCBhY2Nlc3NcbiAgICogaXMgYmVpbmcgYXV0aG9yaXplZC5cbiAgICovXG4gIHJlYWRvbmx5IGNpZHI6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIElEIG9mIHRoZSBncm91cCB0byBncmFudCBhY2Nlc3MgdG8sIGZvciBleGFtcGxlLCB0aGUgQWN0aXZlIERpcmVjdG9yeVxuICAgKiBncm91cCBvciBpZGVudGl0eSBwcm92aWRlciAoSWRQKSBncm91cC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBhdXRob3JpemUgYWxsIGdyb3Vwc1xuICAgKi9cbiAgcmVhZG9ubHkgZ3JvdXBJZD86IHN0cmluZztcblxuICAvKipcbiAgICogQSBicmllZiBkZXNjcmlwdGlvbiBvZiB0aGUgYXV0aG9yaXphdGlvbiBydWxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGRlc2NyaXB0aW9uXG4gICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIENsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2xpZW50VnBuQXV0aG9yaXphdGlvblJ1bGVQcm9wcyBleHRlbmRzIENsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgY2xpZW50IFZQTiBlbmRwb2ludCB0byB3aGljaCB0byBhZGQgdGhlIHJ1bGUuXG4gICAqIEBkZWZhdWx0IGNsaWVudFZwbkVuZHBvaW50IGlzIHJlcXVpcmVkXG4gICAqL1xuICByZWFkb25seSBjbGllbnRWcG5FbmRwb2ludD86IElDbGllbnRWcG5FbmRwb2ludDtcblxuICAvKipcbiAgICogVGhlIGNsaWVudCBWUE4gZW5kcG9pbnQgdG8gd2hpY2ggdG8gYWRkIHRoZSBydWxlLlxuICAgKiBAZGVwcmVjYXRlZCBVc2UgYGNsaWVudFZwbkVuZHBvaW50YCBpbnN0ZWFkXG4gICAqIEBkZWZhdWx0IGNsaWVudFZwbkVuZHBvaW50IGlzIHJlcXVpcmVkXG4gICAqL1xuICByZWFkb25seSBjbGllbnRWcG5FbmRvaW50PzogSUNsaWVudFZwbkVuZHBvaW50O1xufVxuXG4vKipcbiAqIEEgY2xpZW50IFZQTiBhdXRob3JpemF0aW9uIHJ1bGVcbiAqL1xuZXhwb3J0IGNsYXNzIENsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlIGV4dGVuZHMgUmVzb3VyY2Uge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2xpZW50VnBuQXV0aG9yaXphdGlvblJ1bGVQcm9wcykge1xuICAgIGlmICghcHJvcHMuY2xpZW50VnBuRW5kb2ludCAmJiAhcHJvcHMuY2xpZW50VnBuRW5kcG9pbnQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgJ0NsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlOiBlaXRoZXIgY2xpZW50VnBuRW5kcG9pbnQgb3IgY2xpZW50VnBuRW5kb2ludCAoZGVwcmVjYXRlZCkgbXVzdCBiZSBzcGVjaWZpZWQnLFxuICAgICAgKTtcbiAgICB9XG4gICAgaWYgKHByb3BzLmNsaWVudFZwbkVuZG9pbnQgJiYgcHJvcHMuY2xpZW50VnBuRW5kcG9pbnQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgJ0NsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlOiBlaXRoZXIgY2xpZW50VnBuRW5kcG9pbnQgb3IgY2xpZW50VnBuRW5kb2ludCAoZGVwcmVjYXRlZCkgbXVzdCBiZSBzcGVjaWZpZWQnICtcbiAgICAgICAgICAnLCBidXQgbm90IGJvdGgnLFxuICAgICAgKTtcbiAgICB9XG4gICAgY29uc3QgY2xpZW50VnBuRW5kcG9pbnQgPSBwcm9wcy5jbGllbnRWcG5FbmRvaW50IHx8IHByb3BzLmNsaWVudFZwbkVuZHBvaW50O1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgbmV3IENmbkNsaWVudFZwbkF1dGhvcml6YXRpb25SdWxlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGNsaWVudFZwbkVuZHBvaW50SWQ6IGNsaWVudFZwbkVuZHBvaW50IS5lbmRwb2ludElkLFxuICAgICAgdGFyZ2V0TmV0d29ya0NpZHI6IHByb3BzLmNpZHIsXG4gICAgICBhY2Nlc3NHcm91cElkOiBwcm9wcy5ncm91cElkLFxuICAgICAgYXV0aG9yaXplQWxsR3JvdXBzOiAhcHJvcHMuZ3JvdXBJZCxcbiAgICAgIGRlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbixcbiAgICB9KTtcbiAgfVxufVxuIl19