/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.mllib.GraphWiseConvLayerConfig;

public abstract class GraphWiseBaseModelConfig {
    public static final EnumSet<PropertyType> SUPPORTED_INPUT_TYPES = EnumSet.of(PropertyType.INTEGER, PropertyType.LONG, PropertyType.FLOAT, PropertyType.DOUBLE, PropertyType.BOOLEAN);
    public static final int DEFAULT_BATCH_SIZE = 128;
    public static final int DEFAULT_NUM_EPOCHS = 3;
    public static final double DEFAULT_LEARNING_RATE = 0.01;
    public static final double DEFAULT_WEIGHT_DECAY = 0.0;
    public static final int DEFAULT_EMBEDDING_DIM = 128;
    public static final Integer DEFAULT_SEED = null;
    public static final Backend DEFAULT_BACKEND = Backend.TORCH;
    public static final GraphWiseConvLayerConfig[] DEFAULT_CONV_LAYER_CONFIGS = new GraphWiseConvLayerConfig[]{new GraphWiseConvLayerConfig(), new GraphWiseConvLayerConfig()};
    public static final boolean DEFAULT_STANDARDIZE = false;
    public static final boolean DEFAULT_SHUFFLE = true;
    private int batchSize = 128;
    private int numEpochs = 3;
    private double learningRate = 0.01;
    private double weightDecay = 0.0;
    private int embeddingDim = 128;
    private Integer seed = DEFAULT_SEED;
    private GraphWiseConvLayerConfig[] convLayerConfigs = DEFAULT_CONV_LAYER_CONFIGS;
    private boolean standardize = false;
    private boolean shuffle = true;
    private Backend backend = DEFAULT_BACKEND;
    private List<String> vertexInputPropertyNames;
    private List<String> edgeInputPropertyNames;
    private boolean fitted = false;
    private double trainingLoss;
    private int vertexInputFeatureDim;
    private int edgeInputFeatureDim;

    protected GraphWiseBaseModelConfig() {
    }

    public GraphWiseBaseModelConfig(int batchSize, int numEpochs, double learningRate, double weightDecay, int embeddingDim, Integer seed, GraphWiseConvLayerConfig[] convLayerConfigs, boolean standardize, boolean shuffle, List<String> vertexInputPropertyNames, List<String> edgeInputPropertyNames, boolean fitted, double trainingLoss, int vertexInputFeatureDim, int edgeInputFeatureDim, Backend backend) {
        this.batchSize = batchSize;
        this.numEpochs = numEpochs;
        this.learningRate = learningRate;
        this.weightDecay = weightDecay;
        this.embeddingDim = embeddingDim;
        this.seed = seed;
        this.convLayerConfigs = convLayerConfigs;
        this.standardize = standardize;
        this.shuffle = shuffle;
        this.vertexInputPropertyNames = vertexInputPropertyNames;
        this.edgeInputPropertyNames = edgeInputPropertyNames;
        this.fitted = fitted;
        this.trainingLoss = trainingLoss;
        this.vertexInputFeatureDim = vertexInputFeatureDim;
        this.edgeInputFeatureDim = edgeInputFeatureDim;
        this.backend = backend;
    }

    protected GraphWiseBaseModelConfig(GraphWiseBaseModelConfig source) {
        this.setBatchSize(source.getBatchSize());
        this.setNumEpochs(source.getNumEpochs());
        this.setLearningRate(source.getLearningRate());
        this.setEmbeddingDim(source.getEmbeddingDim());
        this.seed = source.getSeed();
        this.setFitted(source.isFitted());
        this.setShuffle(source.isShuffle());
        this.setTrainingLoss(source.getTrainingLoss());
        this.setInputFeatureDim(source.getInputFeatureDim());
        this.setEdgeInputFeatureDim(source.getEdgeInputFeatureDim());
        this.setStandardize(source.isStandardize());
        GraphWiseConvLayerConfig[] targetLayerConfigs = source.getConvLayerConfigs();
        GraphWiseConvLayerConfig[] layerConfigs = new GraphWiseConvLayerConfig[targetLayerConfigs.length];
        for (int i = 0; i < targetLayerConfigs.length; ++i) {
            layerConfigs[i] = new GraphWiseConvLayerConfig();
            layerConfigs[i].setNumSampledNeighbors(targetLayerConfigs[i].getNumSampledNeighbors());
            layerConfigs[i].setWeightedAggregationProperty(targetLayerConfigs[i].getNeighborWeightPropertyName());
            layerConfigs[i].setActivationFunction(targetLayerConfigs[i].getActivationFunction());
            layerConfigs[i].setWeightInitScheme(targetLayerConfigs[i].getWeightInitScheme());
            GraphWiseBaseModelConfig.updateOptionalConfigValue(targetLayerConfigs[i]::getVertexToVertexConnection, layerConfigs[i]::useVertexToVertexConnection);
            GraphWiseBaseModelConfig.updateOptionalConfigValue(targetLayerConfigs[i]::getVertexToEdgeConnection, layerConfigs[i]::useVertexToEdgeConnection);
            GraphWiseBaseModelConfig.updateOptionalConfigValue(targetLayerConfigs[i]::getEdgeToVertexConnection, layerConfigs[i]::useEdgeToVertexConnection);
            GraphWiseBaseModelConfig.updateOptionalConfigValue(targetLayerConfigs[i]::getEdgeToEdgeConnection, layerConfigs[i]::useEdgeToEdgeConnection);
        }
        this.setConvLayerConfigs(layerConfigs);
        if (source.getVertexInputPropertyNames() != null) {
            this.vertexInputPropertyNames = new ArrayList<String>(source.getVertexInputPropertyNames());
        }
        if (source.getEdgeInputPropertyNames() != null) {
            this.edgeInputPropertyNames = new ArrayList<String>(source.getEdgeInputPropertyNames());
        }
    }

    private static <T> void updateOptionalConfigValue(Supplier<T> configSupplier, Consumer<T> configSetter) {
        T value = configSupplier.get();
        if (value != null) {
            configSetter.accept(value);
        }
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public final void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public int getInputFeatureDim() {
        return this.vertexInputFeatureDim;
    }

    public final void setInputFeatureDim(int vertexInputFeatureDim) {
        this.vertexInputFeatureDim = vertexInputFeatureDim;
    }

    public int getEdgeInputFeatureDim() {
        return this.edgeInputFeatureDim;
    }

    public final void setEdgeInputFeatureDim(int edgeInputFeatureDim) {
        this.edgeInputFeatureDim = edgeInputFeatureDim;
    }

    public boolean isFitted() {
        return this.fitted;
    }

    public final void setFitted(boolean fitted) {
        this.fitted = fitted;
    }

    public double getTrainingLoss() {
        return this.trainingLoss;
    }

    public final void setTrainingLoss(double trainingLoss) {
        this.trainingLoss = trainingLoss;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public final void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public final void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getWeightDecay() {
        return this.weightDecay;
    }

    public final void setWeightDecay(double weightDecay) {
        this.weightDecay = weightDecay;
    }

    public int getEmbeddingDim() {
        return this.embeddingDim;
    }

    public final void setEmbeddingDim(int embeddingDim) {
        this.embeddingDim = embeddingDim;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public final void setSeed(int seed) {
        this.seed = seed;
    }

    public GraphWiseConvLayerConfig[] getConvLayerConfigs() {
        return this.convLayerConfigs;
    }

    public final void setConvLayerConfigs(GraphWiseConvLayerConfig ... convLayerConfigs) {
        this.convLayerConfigs = convLayerConfigs;
    }

    public List<String> getVertexInputPropertyNames() {
        return this.vertexInputPropertyNames;
    }

    public final void setVertexInputPropertyNames(List<String> vertexInputPropertyNames) {
        this.vertexInputPropertyNames = vertexInputPropertyNames;
    }

    public List<String> getEdgeInputPropertyNames() {
        return this.edgeInputPropertyNames;
    }

    public final void setEdgeInputPropertyNames(List<String> edgeInputPropertyNames) {
        this.edgeInputPropertyNames = edgeInputPropertyNames;
    }

    public boolean isStandardize() {
        return this.standardize;
    }

    public final void setStandardize(boolean standardize) {
        this.standardize = standardize;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public static enum Backend {
        TORCH;

    }
}

