/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.mllib.edgecombination.ConcatEdgeCombinationMethod;
import oracle.pgx.config.mllib.edgecombination.EdgeCombinationMethod;

public class EdgeCombinationMethodDeserializer
extends JsonDeserializer<EdgeCombinationMethod> {
    private static EdgeCombinationMethod getEdgeCombinationMethod(JsonNode jsonNode) throws IOException {
        JsonNode aggregationTypeNode = jsonNode.get("aggregationType");
        EdgeCombinationMethod.AggregationType aggregationType = ConfigJsonUtil.fromJsonNode(aggregationTypeNode, EdgeCombinationMethod.AggregationType.class);
        switch (aggregationType) {
            case CONCATENATION: {
                return ConfigJsonUtil.fromJsonNode(jsonNode, ConcatEdgeCombinationMethod.class);
            }
        }
        throw new IllegalEnumConstantException((Enum)aggregationType);
    }

    public EdgeCombinationMethod deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
        return EdgeCombinationMethodDeserializer.getEdgeCombinationMethod(jsonNode);
    }
}

