/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.BasicSchedulerConfig;
import oracle.pgx.config.BasicSchedulerConfigBuilder;
import oracle.pgx.config.Compiler;
import oracle.pgx.config.DataMemoryLimitsConfig;
import oracle.pgx.config.DataMemoryLimitsConfigBuilder;
import oracle.pgx.config.EnterpriseSchedulerConfig;
import oracle.pgx.config.EnterpriseSchedulerConfigBuilder;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfig;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfigBuilder;
import oracle.pgx.config.FrontierTypeStrategy;
import oracle.pgx.config.GraphValidationLevel;
import oracle.pgx.config.MemoryAllocationStrategy;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.RandomGeneratorStrategy;
import oracle.pgx.config.ReachabilityIndexCreationMode;
import oracle.pgx.config.RealmConfig;
import oracle.pgx.config.RealmConfigBuilder;
import oracle.pgx.config.SchedulerStrategy;
import oracle.pgx.config.StringPoolingStrategy;
import oracle.pgx.config.UpdateConsistencyModel;

public final class PgxConfigBuilder {
    private final Map<PgxConfig.Field, Object> values = new HashMap<PgxConfig.Field, Object>();

    public static PgxConfig buildPgxConfig(Consumer<PgxConfigBuilder> builderSetup) {
        PgxConfigBuilder builder = new PgxConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PgxConfigBuilder() {
    }

    public PgxConfigBuilder(Map<PgxConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PgxConfigBuilder(PgxConfig config) {
        this.putAll(config);
    }

    public PgxConfigBuilder(PgxConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PgxConfigBuilder putAll(Map<PgxConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PgxConfigBuilder putAll(PgxConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PgxConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PgxConfig build(String parentPath) {
        try {
            return PgxConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PgxConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PgxConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PgxConfigBuilder" + this.values;
    }

    public PgxConfigBuilder setEnableGraphLoadingCache(boolean enableGraphLoadingCache) {
        this.values.put(PgxConfig.Field.ENABLE_GRAPH_LOADING_CACHE, enableGraphLoadingCache);
        return this;
    }

    public PgxConfigBuilder setUNSAFEUseGraphCacheAcrossSessions(boolean uNSAFEUseGraphCacheAcrossSessions) {
        this.values.put(PgxConfig.Field.UNSAFE_USE_GRAPH_CACHE_ACROSS_SESSIONS, uNSAFEUseGraphCacheAcrossSessions);
        return this;
    }

    public PgxConfigBuilder setBasicSchedulerConfig(BasicSchedulerConfig basicSchedulerConfig) {
        this.values.put(PgxConfig.Field.BASIC_SCHEDULER_CONFIG, basicSchedulerConfig);
        return this;
    }

    public PgxConfigBuilder setBasicSchedulerConfig(Consumer<BasicSchedulerConfigBuilder> basicSchedulerConfigBuilderSetup) {
        BasicSchedulerConfigBuilder builder = new BasicSchedulerConfigBuilder();
        basicSchedulerConfigBuilderSetup.accept(builder);
        this.setBasicSchedulerConfig(builder.build());
        return this;
    }

    public PgxConfigBuilder setEnterpriseSchedulerConfig(EnterpriseSchedulerConfig enterpriseSchedulerConfig) {
        this.values.put(PgxConfig.Field.ENTERPRISE_SCHEDULER_CONFIG, enterpriseSchedulerConfig);
        return this;
    }

    public PgxConfigBuilder setEnterpriseSchedulerConfig(Consumer<EnterpriseSchedulerConfigBuilder> enterpriseSchedulerConfigBuilderSetup) {
        EnterpriseSchedulerConfigBuilder builder = new EnterpriseSchedulerConfigBuilder();
        enterpriseSchedulerConfigBuilderSetup.accept(builder);
        this.setEnterpriseSchedulerConfig(builder.build());
        return this;
    }

    public PgxConfigBuilder setMinFetchIntervalSec(int minFetchIntervalSec) {
        this.values.put(PgxConfig.Field.MIN_FETCH_INTERVAL_SEC, minFetchIntervalSec);
        return this;
    }

    public PgxConfigBuilder setMinUpdateIntervalSec(int minUpdateIntervalSec) {
        this.values.put(PgxConfig.Field.MIN_UPDATE_INTERVAL_SEC, minUpdateIntervalSec);
        return this;
    }

    public PgxConfigBuilder setInPlaceUpdateConsistencyModel(UpdateConsistencyModel inPlaceUpdateConsistencyModel) {
        this.values.put(PgxConfig.Field.IN_PLACE_UPDATE_CONSISTENCY_MODEL, (Object)inPlaceUpdateConsistencyModel);
        return this;
    }

    public PgxConfigBuilder setMinArrayCompactionThreshold(double minArrayCompactionThreshold) {
        this.values.put(PgxConfig.Field.MIN_ARRAY_COMPACTION_THRESHOLD, minArrayCompactionThreshold);
        return this;
    }

    public PgxConfigBuilder setMaxSnapshotCount(int maxSnapshotCount) {
        this.values.put(PgxConfig.Field.MAX_SNAPSHOT_COUNT, maxSnapshotCount);
        return this;
    }

    public PgxConfigBuilder setJavaHomeDir(String javaHomeDir) {
        this.values.put(PgxConfig.Field.JAVA_HOME_DIR, javaHomeDir);
        return this;
    }

    public PgxConfigBuilder setEnableGmCompiler(boolean enableGmCompiler) {
        this.values.put(PgxConfig.Field.ENABLE_GM_COMPILER, enableGmCompiler);
        return this;
    }

    public PgxConfigBuilder setGraphAlgorithmLanguage(Compiler graphAlgorithmLanguage) {
        this.values.put(PgxConfig.Field.GRAPH_ALGORITHM_LANGUAGE, (Object)graphAlgorithmLanguage);
        return this;
    }

    public PgxConfigBuilder setUNSAFEAllowForeignSyntax(boolean uNSAFEAllowForeignSyntax) {
        this.values.put(PgxConfig.Field.UNSAFE_ALLOW_FOREIGN_SYNTAX, uNSAFEAllowForeignSyntax);
        return this;
    }

    public PgxConfigBuilder setAllowUserAutoRefresh(boolean allowUserAutoRefresh) {
        this.values.put(PgxConfig.Field.ALLOW_USER_AUTO_REFRESH, allowUserAutoRefresh);
        return this;
    }

    public PgxConfigBuilder setIgnoreIncompatibleBackendOperations(boolean ignoreIncompatibleBackendOperations) {
        this.values.put(PgxConfig.Field.IGNORE_INCOMPATIBLE_BACKEND_OPERATIONS, ignoreIncompatibleBackendOperations);
        return this;
    }

    public PgxConfigBuilder setAllowOverrideSchedulingInformation(boolean allowOverrideSchedulingInformation) {
        this.values.put(PgxConfig.Field.ALLOW_OVERRIDE_SCHEDULING_INFORMATION, allowOverrideSchedulingInformation);
        return this;
    }

    public PgxConfigBuilder setUdfConfigDirectory(String udfConfigDirectory) {
        this.values.put(PgxConfig.Field.UDF_CONFIG_DIRECTORY, udfConfigDirectory);
        return this;
    }

    public PgxConfigBuilder setHostnames(String ... hostnames) {
        this.values.put(PgxConfig.Field.HOSTNAMES, hostnames);
        return this;
    }

    public PgxConfigBuilder setExistingHostnames(String ... existingHostnames) {
        this.values.put(PgxConfig.Field.EXISTING_HOSTNAMES, existingHostnames);
        return this;
    }

    public PgxConfigBuilder setExecutablePath(String executablePath) {
        this.values.put(PgxConfig.Field.EXECUTABLE_PATH, executablePath);
        return this;
    }

    public PgxConfigBuilder setBuiltinsPath(String builtinsPath) {
        this.values.put(PgxConfig.Field.BUILTINS_PATH, builtinsPath);
        return this;
    }

    public PgxConfigBuilder setLogConfigure(String logConfigure) {
        this.values.put(PgxConfig.Field.LOG_CONFIGURE, logConfigure);
        return this;
    }

    public PgxConfigBuilder setCommonLogConfigure(String commonLogConfigure) {
        this.values.put(PgxConfig.Field.COMMON_LOG_CONFIGURE, commonLogConfigure);
        return this;
    }

    public PgxConfigBuilder setLogStdRedirect(String logStdRedirect) {
        this.values.put(PgxConfig.Field.LOG_STD_REDIRECT, logStdRedirect);
        return this;
    }

    public PgxConfigBuilder setJavaClassPath(String javaClassPath) {
        this.values.put(PgxConfig.Field.JAVA_CLASS_PATH, javaClassPath);
        return this;
    }

    public PgxConfigBuilder setUseInfiniband(boolean useInfiniband) {
        this.values.put(PgxConfig.Field.USE_INFINIBAND, useInfiniband);
        return this;
    }

    public PgxConfigBuilder setIfInfiniband(String ifInfiniband) {
        this.values.put(PgxConfig.Field.IF_INFINIBAND, ifInfiniband);
        return this;
    }

    public PgxConfigBuilder setIfEthernet(String ifEthernet) {
        this.values.put(PgxConfig.Field.IF_ETHERNET, ifEthernet);
        return this;
    }

    public PgxConfigBuilder setLargeBufCount(int largeBufCount) {
        this.values.put(PgxConfig.Field.LARGE_BUF_COUNT, largeBufCount);
        return this;
    }

    public PgxConfigBuilder setLargeBufSizeKb(int largeBufSizeKb) {
        this.values.put(PgxConfig.Field.LARGE_BUF_SIZE_KB, largeBufSizeKb);
        return this;
    }

    public PgxConfigBuilder setPartitioningShuffleVertices(boolean partitioningShuffleVertices) {
        this.values.put(PgxConfig.Field.PARTITIONING_SHUFFLE_VERTICES, partitioningShuffleVertices);
        return this;
    }

    public PgxConfigBuilder setPartitioningStrategy(String partitioningStrategy) {
        this.values.put(PgxConfig.Field.PARTITIONING_STRATEGY, partitioningStrategy);
        return this;
    }

    public PgxConfigBuilder setProcId(int procId) {
        this.values.put(PgxConfig.Field.PROC_ID, procId);
        return this;
    }

    public PgxConfigBuilder setResourceMonitor(int resourceMonitor) {
        this.values.put(PgxConfig.Field.RESOURCE_MONITOR, resourceMonitor);
        return this;
    }

    public PgxConfigBuilder setDebugServer(String debugServer) {
        this.values.put(PgxConfig.Field.DEBUG_SERVER, debugServer);
        return this;
    }

    public PgxConfigBuilder setInstanceName(String instanceName) {
        this.values.put(PgxConfig.Field.INSTANCE_NAME, instanceName);
        return this;
    }

    public PgxConfigBuilder setEnableSecureHandshake(boolean enableSecureHandshake) {
        this.values.put(PgxConfig.Field.ENABLE_SECURE_HANDSHAKE, enableSecureHandshake);
        return this;
    }

    public PgxConfigBuilder setSecureHandshakeSecretFile(String secureHandshakeSecretFile) {
        this.values.put(PgxConfig.Field.SECURE_HANDSHAKE_SECRET_FILE, secureHandshakeSecretFile);
        return this;
    }

    public PgxConfigBuilder setBackendWrapper(String backendWrapper) {
        this.values.put(PgxConfig.Field.BACKEND_WRAPPER, backendWrapper);
        return this;
    }

    public PgxConfigBuilder setHandshakePort(int handshakePort) {
        this.values.put(PgxConfig.Field.HANDSHAKE_PORT, handshakePort);
        return this;
    }

    public PgxConfigBuilder setNumSpinLocks(int numSpinLocks) {
        this.values.put(PgxConfig.Field.NUM_SPIN_LOCKS, numSpinLocks);
        return this;
    }

    public PgxConfigBuilder setExplicitSpinLocks(boolean explicitSpinLocks) {
        this.values.put(PgxConfig.Field.EXPLICIT_SPIN_LOCKS, explicitSpinLocks);
        return this;
    }

    public PgxConfigBuilder setScheduler(SchedulerStrategy scheduler) {
        this.values.put(PgxConfig.Field.SCHEDULER, scheduler);
        return this;
    }

    public PgxConfigBuilder setTaskLength(int taskLength) {
        this.values.put(PgxConfig.Field.TASK_LENGTH, taskLength);
        return this;
    }

    public PgxConfigBuilder setSmallTaskLength(int smallTaskLength) {
        this.values.put(PgxConfig.Field.SMALL_TASK_LENGTH, smallTaskLength);
        return this;
    }

    public PgxConfigBuilder setMsBfsFrontierTypeStrategy(FrontierTypeStrategy msBfsFrontierTypeStrategy) {
        this.values.put(PgxConfig.Field.MS_BFS_FRONTIER_TYPE_STRATEGY, (Object)msBfsFrontierTypeStrategy);
        return this;
    }

    public PgxConfigBuilder setBfsThresholdSingleThreaded(int bfsThresholdSingleThreaded) {
        this.values.put(PgxConfig.Field.BFS_THRESHOLD_SINGLE_THREADED, bfsThresholdSingleThreaded);
        return this;
    }

    public PgxConfigBuilder setBfsThresholdReadBased(int bfsThresholdReadBased) {
        this.values.put(PgxConfig.Field.BFS_THRESHOLD_READ_BASED, bfsThresholdReadBased);
        return this;
    }

    public PgxConfigBuilder setBfsIterateQueTaskSize(int bfsIterateQueTaskSize) {
        this.values.put(PgxConfig.Field.BFS_ITERATE_QUE_TASK_SIZE, bfsIterateQueTaskSize);
        return this;
    }

    public PgxConfigBuilder setBfsThresholdParentReadBased(double bfsThresholdParentReadBased) {
        this.values.put(PgxConfig.Field.BFS_THRESHOLD_PARENT_READ_BASED, bfsThresholdParentReadBased);
        return this;
    }

    public PgxConfigBuilder setDfsThresholdLarge(int dfsThresholdLarge) {
        this.values.put(PgxConfig.Field.DFS_THRESHOLD_LARGE, dfsThresholdLarge);
        return this;
    }

    public PgxConfigBuilder setCniStopRecursionDefault(int cniStopRecursionDefault) {
        this.values.put(PgxConfig.Field.CNI_STOP_RECURSION_DEFAULT, cniStopRecursionDefault);
        return this;
    }

    public PgxConfigBuilder setCniSmallDefault(int cniSmallDefault) {
        this.values.put(PgxConfig.Field.CNI_SMALL_DEFAULT, cniSmallDefault);
        return this;
    }

    public PgxConfigBuilder setCniDiffFactorDefault(int cniDiffFactorDefault) {
        this.values.put(PgxConfig.Field.CNI_DIFF_FACTOR_DEFAULT, cniDiffFactorDefault);
        return this;
    }

    public PgxConfigBuilder setLargeArrayThreshold(int largeArrayThreshold) {
        this.values.put(PgxConfig.Field.LARGE_ARRAY_THRESHOLD, largeArrayThreshold);
        return this;
    }

    public PgxConfigBuilder setMaxOffHeapSize(int maxOffHeapSize) {
        this.values.put(PgxConfig.Field.MAX_OFF_HEAP_SIZE, maxOffHeapSize);
        return this;
    }

    public PgxConfigBuilder setCharacterSet(String characterSet) {
        this.values.put(PgxConfig.Field.CHARACTER_SET, characterSet);
        return this;
    }

    public PgxConfigBuilder setParallelism(int parallelism) {
        this.values.put(PgxConfig.Field.PARALLELISM, parallelism);
        return this;
    }

    public PgxConfigBuilder setRandomGeneratorStrategy(RandomGeneratorStrategy randomGeneratorStrategy) {
        this.values.put(PgxConfig.Field.RANDOM_GENERATOR_STRATEGY, (Object)randomGeneratorStrategy);
        return this;
    }

    public PgxConfigBuilder setRandomSeed(long randomSeed) {
        this.values.put(PgxConfig.Field.RANDOM_SEED, randomSeed);
        return this;
    }

    public PgxConfigBuilder setPatternMatchingSupernodeCacheThreshold(int patternMatchingSupernodeCacheThreshold) {
        this.values.put(PgxConfig.Field.PATTERN_MATCHING_SUPERNODE_CACHE_THRESHOLD, patternMatchingSupernodeCacheThreshold);
        return this;
    }

    public PgxConfigBuilder setUseIndexForReachabilityQueries(ReachabilityIndexCreationMode useIndexForReachabilityQueries) {
        this.values.put(PgxConfig.Field.USE_INDEX_FOR_REACHABILITY_QUERIES, (Object)useIndexForReachabilityQueries);
        return this;
    }

    public PgxConfigBuilder setRevisitThreshold(int revisitThreshold) {
        this.values.put(PgxConfig.Field.REVISIT_THRESHOLD, revisitThreshold);
        return this;
    }

    public PgxConfigBuilder setEnterpriseSchedulerFlags(EnterpriseSchedulerFlagsConfig enterpriseSchedulerFlags) {
        this.values.put(PgxConfig.Field.ENTERPRISE_SCHEDULER_FLAGS, enterpriseSchedulerFlags);
        return this;
    }

    public PgxConfigBuilder setEnterpriseSchedulerFlags(Consumer<EnterpriseSchedulerFlagsConfigBuilder> enterpriseSchedulerFlagsBuilderSetup) {
        EnterpriseSchedulerFlagsConfigBuilder builder = new EnterpriseSchedulerFlagsConfigBuilder();
        enterpriseSchedulerFlagsBuilderSetup.accept(builder);
        this.setEnterpriseSchedulerFlags(builder.build());
        return this;
    }

    public PgxConfigBuilder setMemoryAllocator(MemoryAllocationStrategy memoryAllocator) {
        this.values.put(PgxConfig.Field.MEMORY_ALLOCATOR, (Object)memoryAllocator);
        return this;
    }

    public PgxConfigBuilder setMaxDistinctStringsPerPool(int maxDistinctStringsPerPool) {
        this.values.put(PgxConfig.Field.MAX_DISTINCT_STRINGS_PER_POOL, maxDistinctStringsPerPool);
        return this;
    }

    public PgxConfigBuilder setStringPoolingStrategy(StringPoolingStrategy stringPoolingStrategy) {
        this.values.put(PgxConfig.Field.STRING_POOLING_STRATEGY, (Object)stringPoolingStrategy);
        return this;
    }

    public PgxConfigBuilder setUseMemoryMapperForStoringPgb(boolean useMemoryMapperForStoringPgb) {
        this.values.put(PgxConfig.Field.USE_MEMORY_MAPPER_FOR_STORING_PGB, useMemoryMapperForStoringPgb);
        return this;
    }

    public PgxConfigBuilder setUseMemoryMapperForReadingPgb(boolean useMemoryMapperForReadingPgb) {
        this.values.put(PgxConfig.Field.USE_MEMORY_MAPPER_FOR_READING_PGB, useMemoryMapperForReadingPgb);
        return this;
    }

    public PgxConfigBuilder setPoolingFactor(double poolingFactor) {
        this.values.put(PgxConfig.Field.POOLING_FACTOR, poolingFactor);
        return this;
    }

    public PgxConfigBuilder setGraphValidationLevel(GraphValidationLevel graphValidationLevel) {
        this.values.put(PgxConfig.Field.GRAPH_VALIDATION_LEVEL, (Object)graphValidationLevel);
        return this;
    }

    public PgxConfigBuilder setEnableCsrfTokenChecks(boolean enableCsrfTokenChecks) {
        this.values.put(PgxConfig.Field.ENABLE_CSRF_TOKEN_CHECKS, enableCsrfTokenChecks);
        return this;
    }

    public PgxConfigBuilder setTmpDir(String tmpDir) {
        this.values.put(PgxConfig.Field.TMP_DIR, tmpDir);
        return this;
    }

    public PgxConfigBuilder setAllowedRemoteLoadingLocations(String ... allowedRemoteLoadingLocations) {
        this.values.put(PgxConfig.Field.ALLOWED_REMOTE_LOADING_LOCATIONS, allowedRemoteLoadingLocations);
        return this;
    }

    public PgxConfigBuilder setInitPgqlOnStartup(boolean initPgqlOnStartup) {
        this.values.put(PgxConfig.Field.INIT_PGQL_ON_STARTUP, initPgqlOnStartup);
        return this;
    }

    public PgxConfigBuilder setMaxHttpClientRequestSize(long maxHttpClientRequestSize) {
        this.values.put(PgxConfig.Field.MAX_HTTP_CLIENT_REQUEST_SIZE, maxHttpClientRequestSize);
        return this;
    }

    public PgxConfigBuilder setPgxRealm(RealmConfig pgxRealm) {
        this.values.put(PgxConfig.Field.PGX_REALM, pgxRealm);
        return this;
    }

    public PgxConfigBuilder setPgxRealm(Consumer<RealmConfigBuilder> pgxRealmBuilderSetup) {
        RealmConfigBuilder builder = new RealmConfigBuilder();
        pgxRealmBuilderSetup.accept(builder);
        this.setPgxRealm(builder.build());
        return this;
    }

    public PgxConfigBuilder setFileLocations(Object ... fileLocations) {
        this.values.put(PgxConfig.Field.FILE_LOCATIONS, fileLocations);
        return this;
    }

    public PgxConfigBuilder setAuthorizationSessionCreateAllowAll(boolean authorizationSessionCreateAllowAll) {
        this.values.put(PgxConfig.Field.AUTHORIZATION_SESSION_CREATE_ALLOW_ALL, authorizationSessionCreateAllowAll);
        return this;
    }

    public PgxConfigBuilder setAuthorization(Object ... authorization) {
        this.values.put(PgxConfig.Field.AUTHORIZATION, authorization);
        return this;
    }

    public PgxConfigBuilder setEnableMemoryLimitsChecks(boolean enableMemoryLimitsChecks) {
        this.values.put(PgxConfig.Field.ENABLE_MEMORY_LIMITS_CHECKS, enableMemoryLimitsChecks);
        return this;
    }

    public PgxConfigBuilder setDataMemoryLimits(DataMemoryLimitsConfig dataMemoryLimits) {
        this.values.put(PgxConfig.Field.DATA_MEMORY_LIMITS, dataMemoryLimits);
        return this;
    }

    public PgxConfigBuilder setDataMemoryLimits(Consumer<DataMemoryLimitsConfigBuilder> dataMemoryLimitsBuilderSetup) {
        DataMemoryLimitsConfigBuilder builder = new DataMemoryLimitsConfigBuilder();
        dataMemoryLimitsBuilderSetup.accept(builder);
        this.setDataMemoryLimits(builder.build());
        return this;
    }

    public PgxConfigBuilder setEnableShutdownCleanupHook(boolean enableShutdownCleanupHook) {
        this.values.put(PgxConfig.Field.ENABLE_SHUTDOWN_CLEANUP_HOOK, enableShutdownCleanupHook);
        return this;
    }

    public PgxConfigBuilder setSessionIdleTimeoutSecs(int sessionIdleTimeoutSecs) {
        this.values.put(PgxConfig.Field.SESSION_IDLE_TIMEOUT_SECS, sessionIdleTimeoutSecs);
        return this;
    }

    public PgxConfigBuilder setSessionTaskTimeoutSecs(int sessionTaskTimeoutSecs) {
        this.values.put(PgxConfig.Field.SESSION_TASK_TIMEOUT_SECS, sessionTaskTimeoutSecs);
        return this;
    }

    public PgxConfigBuilder setAllowIdleTimeoutOverwrite(boolean allowIdleTimeoutOverwrite) {
        this.values.put(PgxConfig.Field.ALLOW_IDLE_TIMEOUT_OVERWRITE, allowIdleTimeoutOverwrite);
        return this;
    }

    public PgxConfigBuilder setAllowTaskTimeoutOverwrite(boolean allowTaskTimeoutOverwrite) {
        this.values.put(PgxConfig.Field.ALLOW_TASK_TIMEOUT_OVERWRITE, allowTaskTimeoutOverwrite);
        return this;
    }

    public PgxConfigBuilder setMaxActiveSessions(int maxActiveSessions) {
        this.values.put(PgxConfig.Field.MAX_ACTIVE_SESSIONS, maxActiveSessions);
        return this;
    }

    public PgxConfigBuilder setMaxQueueSizePerSession(int maxQueueSizePerSession) {
        this.values.put(PgxConfig.Field.MAX_QUEUE_SIZE_PER_SESSION, maxQueueSizePerSession);
        return this;
    }

    public PgxConfigBuilder setIntervalToPollMax(int intervalToPollMax) {
        this.values.put(PgxConfig.Field.INTERVAL_TO_POLL_MAX, intervalToPollMax);
        return this;
    }

    public PgxConfigBuilder setAdminRequestCacheTimeout(int adminRequestCacheTimeout) {
        this.values.put(PgxConfig.Field.ADMIN_REQUEST_CACHE_TIMEOUT, adminRequestCacheTimeout);
        return this;
    }

    public PgxConfigBuilder setLaunchWatchdogs(boolean launchWatchdogs) {
        this.values.put(PgxConfig.Field.LAUNCH_WATCHDOGS, launchWatchdogs);
        return this;
    }

    public PgxConfigBuilder setStrictMode(boolean strictMode) {
        this.values.put(PgxConfig.Field.STRICT_MODE, strictMode);
        return this;
    }

    public PgxConfigBuilder setPreloadGraphs(Object ... preloadGraphs) {
        this.values.put(PgxConfig.Field.PRELOAD_GRAPHS, preloadGraphs);
        return this;
    }

    public PgxConfigBuilder setMemoryCleanupInterval(int memoryCleanupInterval) {
        this.values.put(PgxConfig.Field.MEMORY_CLEANUP_INTERVAL, memoryCleanupInterval);
        return this;
    }

    public PgxConfigBuilder setReleaseMemoryThreshold(double releaseMemoryThreshold) {
        this.values.put(PgxConfig.Field.RELEASE_MEMORY_THRESHOLD, releaseMemoryThreshold);
        return this;
    }

    public PgxConfigBuilder setReadinessMemoryUsageRatio(double readinessMemoryUsageRatio) {
        this.values.put(PgxConfig.Field.READINESS_MEMORY_USAGE_RATIO, readinessMemoryUsageRatio);
        return this;
    }

    public PgxConfigBuilder setRunningMemoryUsageRatio(double runningMemoryUsageRatio) {
        this.values.put(PgxConfig.Field.RUNNING_MEMORY_USAGE_RATIO, runningMemoryUsageRatio);
        return this;
    }

    public PgxConfigBuilder setPgxServerBaseUrl(String pgxServerBaseUrl) {
        this.values.put(PgxConfig.Field.PGX_SERVER_BASE_URL, pgxServerBaseUrl);
        return this;
    }

    public PgxConfigBuilder setEnableGraphSharing(boolean enableGraphSharing) {
        this.values.put(PgxConfig.Field.ENABLE_GRAPH_SHARING, enableGraphSharing);
        return this;
    }

    public PgxConfigBuilder setFileLocations(List<?> fileLocations) {
        this.values.put(PgxConfig.Field.FILE_LOCATIONS, fileLocations);
        return this;
    }

    public PgxConfigBuilder setAuthorization(List<?> authorization) {
        this.values.put(PgxConfig.Field.AUTHORIZATION, authorization);
        return this;
    }

    public PgxConfigBuilder setPreloadGraphs(List<?> preloadGraphs) {
        this.values.put(PgxConfig.Field.PRELOAD_GRAPHS, preloadGraphs);
        return this;
    }
}

