/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Objects;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.NameValidator;
import oracle.pgx.config.DbConnectionConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.TwoTablesGraphConfig;
import oracle.pgx.config.TwoTablesRdbmsGraphConfig;
import oracle.pgx.config.TwoTablesRdbmsGraphConfigBuilder;

public abstract class AbstractTwoTablesRdbmsGraphConfig
extends GraphConfig
implements TwoTablesGraphConfig,
DbConnectionConfig {
    @Override
    public TwoTablesRdbmsGraphConfigBuilder toGraphConfigBuilder() {
        return new TwoTablesRdbmsGraphConfigBuilder().copyFrom((TwoTablesRdbmsGraphConfig)this);
    }

    @Override
    public boolean supportsVectorProperties() {
        return false;
    }

    private void validateEmptyGraph() {
        if (!this.hasNodesTable() && !this.hasEdgesTable()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"TABLE_NAMES_NOT_SET", (Object[])new Object[0]));
        }
        if (!this.hasNodesTable() && this.skipEdgeLoading()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SKIP_BOTH_EDGES_VERTICES", (Object[])new Object[0]));
        }
        if (!this.hasEdgesTable() && this.skipVertexLoading()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SKIP_BOTH_EDGES_VERTICES", (Object[])new Object[0]));
        }
    }

    private String getPassword() {
        Object pwd = ((TwoTablesRdbmsGraphConfig)this).getValues().get(TwoTablesRdbmsGraphConfig.Field.PASSWORD);
        return (String)pwd;
    }

    private void validateJdbcUrl() {
        if (this.getJdbcUrl() == null) {
            return;
        }
        if (this.getDataSourceId() != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DATA_SOURCE_ID_CANNOT_BE_COMBINED_WITH_JDBC", (Object[])new Object[0]));
        }
        if (this.getPassword() == null && this.getKeystoreAlias() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEYSTORE_OR_PWD_REQUIRED", (Object[])new Object[0]));
        }
        if (!this.getJdbcUrl().toLowerCase().startsWith("jdbc:oracle:thin:")) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_JDBC_URI", (Object[])new Object[]{this.getJdbcUrl()}));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTwoTablesRdbmsGraphConfig that = (AbstractTwoTablesRdbmsGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getJdbcUrl(), that.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), that.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getKeystoreAlias(), that.getKeystoreAlias())) {
            return false;
        }
        if (!Objects.equals(this.hasNodesTable(), that.hasNodesTable())) {
            return false;
        }
        if (!Objects.equals(this.getNodesKeyColumn(), that.getNodesKeyColumn())) {
            return false;
        }
        if (!Objects.equals(this.hasEdgesTable(), that.hasEdgesTable())) {
            return false;
        }
        if (!Objects.equals(this.hasEdgeKeys(), that.hasEdgeKeys())) {
            return false;
        }
        if (!Objects.equals(this.getToNidColumn(), that.getToNidColumn())) {
            return false;
        }
        return Objects.equals(this.getFromNidColumn(), that.getFromNidColumn());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.getJdbcUrl() != null) {
            hash += this.getJdbcUrl().hashCode();
        }
        if (this.getUsername() != null) {
            hash += this.getUsername().hashCode();
        }
        if (this.getKeystoreAlias() != null) {
            hash += this.getKeystoreAlias().hashCode();
        }
        if (this.hasNodesTable()) {
            hash += this.getNodesTableName().hashCode();
        }
        if (this.getNodesKeyColumn() != null) {
            hash += this.getNodesKeyColumn().hashCode();
        }
        if (this.hasEdgesTable()) {
            hash += this.getEdgesTableName().hashCode();
        }
        if (this.hasEdgeKeys()) {
            hash += this.getEdgesKeyColumn().hashCode();
        }
        if (this.getToNidColumn() != null) {
            hash += this.getToNidColumn().hashCode();
        }
        if (this.getFromNidColumn() != null) {
            hash += this.getFromNidColumn().hashCode();
        }
        return hash;
    }

    @Override
    protected void validate() {
        super.validate();
        this.validateJdbcUrl();
        this.validateEmptyGraph();
        NameValidator.validate((String[])new String[]{this.getNodesTableName(), this.getEdgesTableName()});
        NameValidator.validate((String[])new String[]{this.getNodesKeyColumn(), this.getEdgesKeyColumn(), this.getFromNidColumn(), this.getToNidColumn()});
        NameValidator.validate((String[])new String[]{this.getNodesLabelColumn(), this.getEdgesLabelColumn()});
        for (GraphPropertyConfig prop : this.getEdgeProps()) {
            NameValidator.validate((String[])new String[]{prop.getName()});
        }
        for (GraphPropertyConfig prop : this.getVertexProps()) {
            NameValidator.validate((String[])new String[]{prop.getName()});
        }
    }

    @Override
    public String getName() {
        return this.getNodesTableName() + "_" + this.getEdgesTableName();
    }

    public abstract String getNodesTableName();

    public abstract String getEdgesTableName();

    public String getLabelValueDelimiter() {
        return this.getLoading().getPropertyValueDelimiter();
    }

    public boolean hasNodesTable() {
        return this.getNodesTableName() != null;
    }

    public boolean hasEdgesTable() {
        return this.getEdgesTableName() != null;
    }

    @Override
    public boolean hasEdgeKeys() {
        return this.getEdgesKeyColumn() != null;
    }

    @Override
    public boolean skipVertexLoading() {
        return super.skipVertexLoading() || !this.hasNodesTable();
    }

    @Override
    public boolean skipEdgeLoading() {
        return super.skipEdgeLoading() || !this.hasEdgesTable();
    }
}

