/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.MemoryAllocationStrategy;
import oracle.pgx.config.RuntimeConfig;
import oracle.pgx.config.SchedulerStrategy;
import oracle.pgx.config.StringPoolingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRuntimeConfig.class);

    public static RuntimeConfig getInstance() {
        LOG.info("initializing runtime with system properties (if any)");
        Map<RuntimeConfig.Field, Object> map = AbstractRuntimeConfig.extractSystemProperties();
        return AbstractRuntimeConfig.getInstance(map);
    }

    private static Map<RuntimeConfig.Field, Object> extractSystemProperties() {
        return AbstractRuntimeConfig.readConfigFromEnvironment(null, null, (ConfigField[])RuntimeConfig.getConfigFields()).entrySet().stream().collect(Collectors.toMap(e -> RuntimeConfig.Field.valueOf(((String)e.getKey()).toUpperCase()), Map.Entry::getValue));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RuntimeConfig getInstance(Map<RuntimeConfig.Field, Object> values) {
        try (InputStream is = ConfigJsonUtil.toJsonInputStream(values);){
            RuntimeConfig runtimeConfig = AbstractRuntimeConfig.getInstance(is);
            return runtimeConfig;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static RuntimeConfig getInstance(InputStream is) throws IOException {
        return RuntimeConfig.parse(is, true, null);
    }

    public boolean areWeEnterprise() {
        return this.getScheduler() == SchedulerStrategy.ENTERPRISE_SCHEDULER || this.getMemoryAllocator() == MemoryAllocationStrategy.ENTERPRISE_ALLOCATOR;
    }

    public static void reset() {
    }

    public abstract Map<RuntimeConfig.Field, Object> getValues();

    @JsonValue
    public abstract Map<RuntimeConfig.Field, Object> getValuesWithoutDefaults();

    public abstract MemoryAllocationStrategy getMemoryAllocator();

    public abstract SchedulerStrategy getScheduler();

    public abstract StringPoolingStrategy getStringPoolingStrategy();

    public boolean isStringPoolEnabled() {
        return this.getStringPoolingStrategy() != StringPoolingStrategy.NONE;
    }
}

