/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.AnyDirectedEdgeExtender;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.LabelTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.ModifyTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TableTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TranslationInfo;
import oracle.pg.rdbms.pgql.pgview.translation.expression.EmptyProjection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Projection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableReference;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Union;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class QueryTranslator {
    private static final String WITH_CLAUSE = QueryTranslator.getWithClause(false);
    private static final String WITH_CLAUSE_12C = QueryTranslator.getWithClause(true);
    private static final int INCOMPATIBLE_COLS = -1;

    public static TableExpression translateQuery(GraphQuery graphQuery, MetadataConnector metadataConnector, QueryContext ctx) {
        return QueryTranslator.translateQuery(graphQuery, metadataConnector, ctx, new SubqueryInfo(new HashMap<String, Pair<Boolean, QueryVariable>>(), null, new HashSet<VertexPairConnection>(), false, null, false));
    }

    static TableExpression translateQuery(GraphQuery graphQuery, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
        boolean isDistinct;
        List<ExpAsVar> selectElements;
        if (graphQuery.getQueryType() == QueryType.SELECT) {
            SelectQuery selectQuery = (SelectQuery)graphQuery;
            selectElements = selectQuery.getProjection().getElements();
            isDistinct = selectQuery.getProjection().isDistinct();
        } else if (graphQuery.getQueryType() == QueryType.MODIFY) {
            selectElements = ModifyTranslator.generateSelectElements((ModifyQuery)graphQuery, metadataConnector);
            isDistinct = false;
        } else {
            throw new UnsupportedOperationException("Query type not supported:" + graphQuery.getQueryType());
        }
        GraphPattern graphPattern = graphQuery.getGraphPattern();
        HashMap<QueryVariable, QueryPath> pathVariables = new HashMap<QueryVariable, QueryPath>();
        graphPattern.getConnections().stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).forEach(conn -> {
            QueryPath path = (QueryPath)conn;
            path.getVertices().forEach(vertex -> pathVariables.put((QueryVariable)vertex, path));
            path.getConnections().forEach(connection -> pathVariables.put((QueryVariable)connection, path));
        });
        HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations = new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>();
        ArrayList<ExpAsVar> subSelectElems = new ArrayList<ExpAsVar>();
        HashSet<String> subSelectVars = new HashSet<String>();
        subqueryInfo.connections.addAll(graphPattern.getConnections());
        graphPattern.getConnections().forEach(e -> subqueryInfo.variables.put(e.getName(), new Pair<Boolean, VertexPairConnection>(true, (VertexPairConnection)e)));
        graphPattern.getVertices().forEach(v -> subqueryInfo.variables.put(v.getName(), new Pair<Boolean, QueryVertex>(true, (QueryVertex)v)));
        List<ExpAsVar> groupByElements = new ArrayList();
        if (graphQuery.getGroupBy() != null) {
            groupByElements = graphQuery.getGroupBy().getElements();
            if (groupByElements.size() > 0) {
                subqueryInfo.gbVariables = new HashMap<String, Pair<Boolean, QueryVariable>>();
            }
            for (ExpAsVar groupByElem : groupByElements) {
                QueryVariable var;
                QueryVariable.VariableType variableType;
                if (groupByElem.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || (variableType = (var = ((QueryExpression.VarRef)groupByElem.getExp()).getVariable()).getVariableType()) != QueryVariable.VariableType.VERTEX && variableType != QueryVariable.VariableType.EDGE) continue;
                subqueryInfo.variables.put(groupByElem.getName(), new Pair<Boolean, ExpAsVar>(true, groupByElem));
                subqueryInfo.gbVariables.put(var.getName(), new Pair<Boolean, ExpAsVar>(true, groupByElem));
                subqueryInfo.gbVariables.put(groupByElem.getName(), new Pair<Boolean, ExpAsVar>(true, groupByElem));
            }
        }
        HashSet<QueryVertex> commonVertices = new HashSet<QueryVertex>();
        HashSet<QueryVertex> commonJoinVertices = new HashSet<QueryVertex>();
        for (ExpAsVar expAsVar : selectElements) {
            QueryVariable queryVariable;
            QueryVariable.VariableType type;
            QueryTranslator.addSubSelectElements(expAsVar.getExp(), subSelectElems, subSelectVars, pathAggregations, pathVariables, true, subqueryInfo.variables, commonJoinVertices, commonVertices);
            if (expAsVar.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || (type = (queryVariable = ((QueryExpression.VarRef)expAsVar.getExp()).getVariable()).getVariableType()) != QueryVariable.VariableType.VERTEX && type != QueryVariable.VariableType.EDGE) continue;
            subqueryInfo.selectAliases.put(expAsVar.getName(), new Pair<Boolean, ExpAsVar>(true, expAsVar));
        }
        HashMap<String, Pair<Boolean, QueryVariable>> varsAndAliases = new HashMap<String, Pair<Boolean, QueryVariable>>(subqueryInfo.variables);
        varsAndAliases.putAll(subqueryInfo.selectAliases);
        for (ExpAsVar expAsVar : groupByElements) {
            QueryTranslator.addSubSelectElements(expAsVar.getExp(), subSelectElems, subSelectVars, pathAggregations, pathVariables, true, varsAndAliases, commonJoinVertices, commonVertices);
        }
        List list = graphQuery.getOrderBy().getElements();
        for (Object orderByElem : list) {
            QueryTranslator.addSubSelectElements(orderByElem.getExp(), subSelectElems, subSelectVars, pathAggregations, pathVariables, true, varsAndAliases, commonJoinVertices, commonVertices);
        }
        QueryExpression queryExpression = graphQuery.getHaving();
        if (queryExpression != null) {
            QueryTranslator.addSubSelectElements(queryExpression, subSelectElems, subSelectVars, pathAggregations, pathVariables, true, varsAndAliases, commonJoinVertices, commonVertices);
        }
        for (QueryExpression queryExpression2 : graphPattern.getConstraints()) {
            QueryTranslator.addSubSelectElements(queryExpression2, subSelectElems, subSelectVars, pathAggregations, pathVariables, false, varsAndAliases, commonJoinVertices, commonVertices);
        }
        for (QueryVertex queryVertex : commonJoinVertices) {
            int numKeyColumns = QueryTranslator.getCompatibleKeyColumns(queryVertex, graphPattern, metadataConnector);
            if (numKeyColumns != -1) {
                QueryTranslator.addSubSelectExpression((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", Collections.singletonList(new QueryExpression.VarRef((QueryVariable)queryVertex))), subSelectVars, subSelectElems);
                if (!subqueryInfo.isGbVariable(queryVertex.getName())) continue;
                groupByElements.add(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", Collections.singletonList(new QueryExpression.VarRef((QueryVariable)queryVertex))), "_ora_comp_key_" + queryVertex.getName() + "_" + numKeyColumns, true));
                continue;
            }
            QueryTranslator.addSubSelectExpression((QueryExpression)new QueryExpression.VarRef((QueryVariable)queryVertex), subSelectVars, subSelectElems);
            subqueryInfo.variables.put(queryVertex.getName(), new Pair<Boolean, QueryVertex>(false, queryVertex));
            if (!subqueryInfo.isGbVariable(queryVertex.getName())) continue;
            subqueryInfo.gbVariables.put(queryVertex.getName(), new Pair<Boolean, QueryVertex>(false, queryVertex));
        }
        if (commonVertices.size() > 0 && subqueryInfo.gbVariables != null && subqueryInfo.gbVariables.size() > 0) {
            final HashSet extraGroupByElements = new HashSet();
            for (QueryVertex commonVertex : commonVertices) {
                final String vertexName = commonVertex.getName();
                if (!subqueryInfo.isGbVariable(vertexName)) continue;
                QueryVariable gbVariable = (QueryVariable)subqueryInfo.gbVariables.get((Object)vertexName).second;
                final String alias = gbVariable.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR && ((ExpAsVar)gbVariable).getExp().getExpType() == QueryExpression.ExpressionType.VARREF ? ((QueryExpression.VarRef)((ExpAsVar)gbVariable).getExp()).getVariable().getName() : vertexName;
                for (ExpAsVar select : subSelectElems) {
                    select.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

                        private boolean isSameVariable(String varName) {
                            return varName.equals(vertexName) || varName.equals(alias);
                        }

                        private void addGroupByElement(QueryExpression exp) {
                            extraGroupByElements.add(new ExpAsVar(exp, exp.toString(), true));
                        }

                        public void visit(QueryExpression.VarRef varRef) {
                            if (this.isSameVariable(varRef.getVariable().getName())) {
                                this.addGroupByElement((QueryExpression)varRef);
                            }
                        }

                        public void visit(QueryExpression.PropertyAccess propAccess) {
                            if (this.isSameVariable(propAccess.getVariable().getName())) {
                                extraGroupByElements.add(new ExpAsVar((QueryExpression)propAccess, propAccess.toString(), true));
                            }
                        }

                        public void visit(QueryExpression.FunctionCall functionCall) {
                            if ((functionCall.getFunctionName().equalsIgnoreCase("id") || functionCall.getFunctionName().equalsIgnoreCase("label")) && ((QueryExpression)functionCall.getArgs().get(0)).getExpType() == QueryExpression.ExpressionType.VARREF) {
                                QueryVariable var = ExpressionTranslator.getQueryVariable((QueryExpression.VarRef)functionCall.getArgs().get(0));
                                if (this.isSameVariable(var.getName())) {
                                    extraGroupByElements.add(new ExpAsVar((QueryExpression)functionCall, functionCall.toString(), true));
                                }
                            } else if (functionCall.getFunctionName().equalsIgnoreCase("has_label")) {
                                QueryVariable var = ExpressionTranslator.getQueryVariable((QueryExpression.VarRef)functionCall.getArgs().get(0));
                                if (this.isSameVariable(var.getName())) {
                                    extraGroupByElements.add(new ExpAsVar((QueryExpression)functionCall, functionCall.toString(), true));
                                }
                            } else {
                                functionCall.getArgs().forEach(arg -> arg.accept((QueryExpressionVisitor)this));
                            }
                        }
                    });
                }
            }
            groupByElements.addAll(extraGroupByElements);
        }
        AnyDirectedEdgeExtender edgeExtender = new AnyDirectedEdgeExtender(graphPattern, subSelectElems);
        TableExpression tableExpression2 = IntStream.range(0, edgeExtender.getExtendedConnectionsSize()).mapToObj(extension -> {
            edgeExtender.replaceExtendedEdges(extension);
            TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(graphPattern, metadataConnector);
            List<Map<QueryVariable, String>> patternInstantiation = TableTranslator.generateAllPatternInstantiations(graphPattern, variableTableBinding, metadataConnector);
            if (subqueryInfo.parentConf != null) {
                int size = patternInstantiation.size();
                for (int idx = size - 1; idx >= 0; --idx) {
                    Map<QueryVariable, String> conf = patternInstantiation.get(idx);
                    boolean removed = false;
                    for (QueryVariable v : subqueryInfo.parentConf.keySet()) {
                        if (conf.containsKey(v)) {
                            if (removed || conf.get(v).equals(subqueryInfo.parentConf.get(v))) continue;
                            patternInstantiation.remove(idx);
                            removed = true;
                            continue;
                        }
                        conf.put(v, subqueryInfo.parentConf.get(v));
                    }
                }
            }
            return QueryTranslator.generateTranslation(patternInstantiation, graphPattern, subSelectElems, metadataConnector, pathAggregations, ctx, subqueryInfo);
        }).filter(tableExpression -> !tableExpression.getClass().equals(EmptyProjection.class)).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
        edgeExtender.compressExtendedEdges();
        return QueryTranslator.wrapForModificators(tableExpression2, QueryTranslator.needsWithClause(graphQuery), selectElements, isDistinct, groupByElements, list, queryExpression, graphQuery.getOffset(), graphQuery.getLimit(), pathAggregations, metadataConnector, ctx, subqueryInfo);
    }

    private static boolean needsWithClause(GraphQuery graphQuery) {
        final boolean[] needsWithClause = new boolean[]{false};
        graphQuery.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryPath path) {
                if (PathTranslator.useWithClause(path)) {
                    needsWithClause[0] = true;
                }
            }
        });
        return needsWithClause[0];
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, GraphPattern graphPattern, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, QueryContext ctx, SubqueryInfo subqueryInfo) {
        return QueryTranslator.generateTranslation(patternInstantiations, graphPattern.getVertices(), graphPattern.getConnections(), graphPattern.getConstraints(), subSelectElems, metadataConnector, pathAggregations, ctx, subqueryInfo);
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Set<QueryExpression> constraints, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggr, QueryContext ctx, SubqueryInfo subqueryInfo) {
        TranslationInfo translationInfo = new TranslationInfo(subSelectElems, connections, constraints, pathAggr, ctx, subqueryInfo);
        ArrayList<Projection> allProjections = new ArrayList<Projection>();
        Map<QueryVariable, String> parentConf = subqueryInfo.parentConf;
        Set<QueryExpression> extraConstraints = subqueryInfo.extraConstraints;
        for (Map<QueryVariable, String> instantiation : patternInstantiations) {
            List<TableExpression> tables = QueryTranslator.getTables(vertices, connections, instantiation, translationInfo, metadataConnector, ctx);
            translationInfo.subqueryInfo.extraConstraints = new HashSet<QueryExpression>();
            translationInfo.subqueryInfo.parentConf = null;
            QueryExpression filterWhere = QueryTranslator.translateWhere(constraints, instantiation, metadataConnector, translationInfo);
            QueryExpression joinWhere = QueryTranslator.getJoinFilter(vertices, translationInfo, instantiation, metadataConnector, ctx);
            QueryExpression where = QueryTranslator.normalize((QueryExpression)new QueryExpression.LogicalExpression.And(joinWhere, filterWhere));
            List<Pair<String, String>> solutionBlockSpecificSelectElements = QueryTranslator.generateSpecificSelectElements(subSelectElems, instantiation, metadataConnector, translationInfo);
            Projection projection2 = new Projection(false, "", solutionBlockSpecificSelectElements, tables, QueryTranslator.getWhereString(where, pathAggr, metadataConnector, ctx, subqueryInfo), Collections.emptyList(), null, Collections.emptyList(), "", "");
            allProjections.add(projection2);
        }
        subqueryInfo.parentConf = parentConf;
        subqueryInfo.extraConstraints = extraConstraints;
        return allProjections.stream().map(projection -> projection).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
    }

    private static List<Pair<String, String>> generateSpecificSelectElements(List<ExpAsVar> selectElements, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        ArrayList<Pair<String, String>> translatedExpressions = new ArrayList<Pair<String, String>>();
        for (ExpAsVar expAsVar : selectElements) {
            QueryExpression translatedExpression = ExpressionTranslator.translateForSubSelect(expAsVar.getExp(), new ExpressionTranslator.SubSelectTransOptions(conf, metadataConnector, false, translationInfo));
            QueryExpression exp = expAsVar.getExp();
            if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)exp).getFunctionName().equals("_ora_comp_key_f_") && translatedExpression.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)translatedExpression).getFunctionName().equals("_ora_comp_key_f_")) {
                String varName = ((QueryExpression)((QueryExpression.FunctionCall)exp).getArgs().get(0)).toString();
                QueryExpression.FunctionCall function = (QueryExpression.FunctionCall)translatedExpression;
                for (int j = 0; j < function.getArgs().size(); ++j) {
                    QueryExpression prop = (QueryExpression)function.getArgs().get(j);
                    translatedExpressions.add(new Pair<String, String>(prop.toString(), varName + "_" + j));
                }
                continue;
            }
            if (PathTranslator.isPathVertex(expAsVar)) {
                QueryExpression tableExp = ((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)translatedExpression).getExp1()).getExp1()).getExp1();
                QueryExpression keyExp = ((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)translatedExpression).getExp1()).getExp2();
                keyExp = QueryTranslator.escapeforPath(keyExp, false);
                String alias = expAsVar.getName().substring(2);
                translatedExpressions.add(new Pair<String, String>(QueryTranslator.unescapeTableName(tableExp.toString()), alias + "_table"));
                translatedExpressions.add(new Pair<String, String>(keyExp.toString(), alias + "_key"));
                continue;
            }
            if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)exp).getFunctionName().equalsIgnoreCase("id") && translatedExpression.getExpType() == QueryExpression.ExpressionType.VARREF) {
                translatedExpressions.add(new Pair<String, String>(PgqlUtils.escapeAndEnquoteIdentifier(exp.toString()), expAsVar.getName()));
                continue;
            }
            String alias = null;
            if (!QueryExpression.ExpressionType.STAR.equals((Object)translatedExpression.getExpType())) {
                alias = expAsVar.getName();
            }
            translatedExpressions.add(new Pair<String, String>(QueryTranslator.escapePropertyAccess(translatedExpression, translationInfo), alias));
        }
        return translatedExpressions;
    }

    static String escapePropertyAccess(QueryExpression exp, TranslationInfo info) {
        QueryExpression.VarRef varRef;
        if (exp.getExpType() == QueryExpression.ExpressionType.PROP_ACCESS) {
            QueryExpression.PropertyAccess propertyAccess = (QueryExpression.PropertyAccess)exp;
            if (info.isParentVariable(propertyAccess.getVariable().getName()) && !info.isForParentWhere()) {
                return PgqlUtils.escapeAndEnquoteIdentifier(propertyAccess.toString());
            }
            return ExpressionTranslator.escapePropertyAccess(propertyAccess);
        }
        if (exp.getExpType() == QueryExpression.ExpressionType.VARREF && info.isParentVariable((varRef = (QueryExpression.VarRef)exp).getVariable().getName()) && !info.isForParentWhere()) {
            return PgqlUtils.escapeAndEnquoteIdentifier(varRef.toString());
        }
        return exp.toString();
    }

    private static String unescapeTableName(String tableName) {
        if (tableName.startsWith("'\"") && tableName.endsWith("\"'")) {
            return "'" + tableName.substring(2, tableName.length() - 2).replaceAll("\"\"", "\"") + "'";
        }
        return tableName;
    }

    private static QueryExpression escapeforPath(QueryExpression keyExp, boolean escapeCommas) {
        if (keyExp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)keyExp).getFunctionName().equalsIgnoreCase("DECODE")) {
            QueryExpression.FunctionCall fc1 = (QueryExpression.FunctionCall)keyExp;
            QueryExpression.FunctionCall fc2 = (QueryExpression.FunctionCall)fc1.getArgs().get(0);
            keyExp = (QueryExpression)fc2.getArgs().get(0);
            if (escapeCommas) {
                keyExp = ExpressionTranslator.escapeCommas(keyExp);
            }
        } else if (keyExp.getExpType() == QueryExpression.ExpressionType.CONCAT) {
            QueryExpression.ConcatExpression ce = (QueryExpression.ConcatExpression)keyExp;
            QueryExpression.ConcatExpression exp1 = (QueryExpression.ConcatExpression)ce.getExp1();
            exp1.setExp1(QueryTranslator.escapeforPath(exp1.getExp1(), true));
            ce.setExp2(QueryTranslator.escapeforPath(ce.getExp2(), true));
        }
        return keyExp;
    }

    private static QueryExpression normalize(QueryExpression queryExpression) {
        if (queryExpression.getExpType() == QueryExpression.ExpressionType.AND) {
            QueryExpression.Constant.ConstBoolean constantExpression;
            QueryExpression.LogicalExpression.And andExpression = (QueryExpression.LogicalExpression.And)queryExpression;
            QueryExpression expr1 = QueryTranslator.normalize(andExpression.getExp1());
            QueryExpression expr2 = QueryTranslator.normalize(andExpression.getExp2());
            if (expr1.getExpType() == QueryExpression.ExpressionType.BOOLEAN && ((Boolean)(constantExpression = (QueryExpression.Constant.ConstBoolean)expr1).getValue()).booleanValue()) {
                return expr2;
            }
            if (expr2.getExpType() == QueryExpression.ExpressionType.BOOLEAN && ((Boolean)(constantExpression = (QueryExpression.Constant.ConstBoolean)expr2).getValue()).booleanValue()) {
                return expr1;
            }
            return new QueryExpression.LogicalExpression.And(expr1, expr2);
        }
        return queryExpression;
    }

    private static String getWhereString(QueryExpression whereExpression, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
        if (whereExpression.getExpType() == QueryExpression.ExpressionType.BOOLEAN) {
            QueryExpression.Constant.ConstBoolean boolExpr = (QueryExpression.Constant.ConstBoolean)whereExpression;
            if (((Boolean)boolExpr.getValue()).booleanValue()) {
                return "";
            }
            return "1 <> 1";
        }
        return ExpressionTranslator.translateQueryExpression(whereExpression, new ExpressionTranslator.QueryExpTransOptions(false, false, true, false, pathAggregations, metadataConnector, ctx, subqueryInfo.extraConstraints, subqueryInfo.parentConf, subqueryInfo));
    }

    private static QueryExpression getJoinFilter(Set<QueryVertex> vertices, TranslationInfo translationInfo, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, QueryContext ctx) {
        QueryExpression.Constant.ConstBoolean joinFilter = new QueryExpression.Constant.ConstBoolean(true);
        for (QueryVertex v : vertices) {
            if (!translationInfo.needParentLabelJoin((QueryVariable)v)) continue;
            QueryExpression.FunctionCall labelExp = new QueryExpression.FunctionCall("label", Collections.singletonList(new QueryExpression.VarRef((QueryVariable)v)));
            joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.Constant.ConstString(metadataConnector.getLabelForVertexTable(conf.get(v))), (QueryExpression)labelExp));
        }
        Map<QueryVariable, List<Pair<VertexPairConnection, TranslationInfo.Position>>> vertexConnections = translationInfo.getVertexConnections();
        for (QueryVariable v : vertexConnections.keySet()) {
            List<Pair<VertexPairConnection, TranslationInfo.Position>> parentConnections;
            List<Pair<VertexPairConnection, TranslationInfo.Position>> connections = vertexConnections.get(v);
            if (translationInfo.isParentVariable(v.getName()) && (parentConnections = translationInfo.getCommonVertexConnections(v)).size() > 0) {
                if (translationInfo.isForParentWhere()) {
                    if (((VertexPairConnection)parentConnections.get((int)0).first).getVariableType() == QueryVariable.VariableType.PATH && connections.size() > 0 && ((VertexPairConnection)connections.get((int)0).first).getVariableType() == QueryVariable.VariableType.EDGE && !ctx.sbqJoinWorks()) {
                        throw new UnsupportedOperationException("Pattern not supported for 21c and older DB versions");
                    }
                    connections.addAll(parentConnections);
                } else if (connections.size() > 0) {
                    Pair<VertexPairConnection, TranslationInfo.Position> child = connections.get(0);
                    Pair<VertexPairConnection, TranslationInfo.Position> parent = parentConnections.get(0);
                    joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getChildParentConnectionsJoin(child, parent, conf, metadataConnector));
                }
            }
            if (connections.size() > 1) {
                Pair<VertexPairConnection, TranslationInfo.Position> pos1 = connections.get(0);
                for (int i = 1; i < connections.size(); ++i) {
                    Pair<VertexPairConnection, TranslationInfo.Position> pos2 = connections.get(i);
                    joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getConnectionsJoin(pos1, pos2, conf, metadataConnector));
                    pos1 = pos2;
                }
            }
            if (translationInfo.needVertexConnectionJoin(v)) {
                joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getVertexConnectionJoin(connections.get(0), (QueryVertex)v, conf, metadataConnector, translationInfo));
                continue;
            }
            Pair<VertexPairConnection, TranslationInfo.Position> edge = translationInfo.getEdgeConnection(v);
            if (edge == null) continue;
            joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, QueryTranslator.getEdgeKeyNotNull(edge, conf, metadataConnector));
        }
        return joinFilter;
    }

    private static QueryExpression getConnectionsJoin(Pair<VertexPairConnection, TranslationInfo.Position> pos1, Pair<VertexPairConnection, TranslationInfo.Position> pos2, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        VertexPairConnection conn1 = (VertexPairConnection)pos1.first;
        VertexPairConnection conn2 = (VertexPairConnection)pos2.first;
        if (conn1.getVariableType() == QueryVariable.VariableType.EDGE && conn2.getVariableType() == QueryVariable.VariableType.EDGE) {
            List<String> key1 = QueryTranslator.getEdgeSrcOrDstKey(pos1, conf, metadataConnector);
            List<String> key2 = QueryTranslator.getEdgeSrcOrDstKey(pos2, conf, metadataConnector);
            for (int i = 0; i < key1.size(); ++i) {
                QueryExpression.PropertyAccess key1Access = new QueryExpression.PropertyAccess((QueryVariable)conn1, key1.get(i));
                QueryExpression.PropertyAccess key2Access = new QueryExpression.PropertyAccess((QueryVariable)conn2, key2.get(i));
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)key1Access, (QueryExpression)key2Access));
            }
        } else {
            Pair<QueryExpression, QueryExpression> exp1 = QueryTranslator.getSrcOrDstTableAndKeyExp(pos1, conf, metadataConnector);
            Pair<QueryExpression, QueryExpression> exp2 = QueryTranslator.getSrcOrDstTableAndKeyExp(pos2, conf, metadataConnector);
            join = new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.first, (QueryExpression)exp2.first), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.second, (QueryExpression)exp2.second));
        }
        return join;
    }

    private static QueryExpression getChildParentConnectionsJoin(Pair<VertexPairConnection, TranslationInfo.Position> child, Pair<VertexPairConnection, TranslationInfo.Position> parent, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryVertex commonVertex;
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        VertexPairConnection conn1 = (VertexPairConnection)child.first;
        VertexPairConnection conn2 = (VertexPairConnection)parent.first;
        QueryVertex queryVertex = commonVertex = parent.second == TranslationInfo.Position.SRC ? conn2.getSrc() : conn2.getDst();
        if (conn1.getVariableType() == QueryVariable.VariableType.EDGE && conn2.getVariableType() == QueryVariable.VariableType.EDGE) {
            List<String> key1 = QueryTranslator.getEdgeSrcOrDstKey(child, conf, metadataConnector);
            for (int i = 0; i < key1.size(); ++i) {
                QueryExpression.PropertyAccess key1Access = new QueryExpression.PropertyAccess((QueryVariable)conn1, key1.get(i));
                QueryExpression key2Access = QueryTranslator.buildKeyColumnReference((QueryVariable)commonVertex, i + 1);
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)key1Access, key2Access));
            }
        } else {
            Pair<QueryExpression, QueryExpression> exp1 = QueryTranslator.getSrcOrDstTableAndKeyExp(child, conf, metadataConnector);
            QueryExpression parentTable = QueryTranslator.buildKeyColumnReference((QueryVariable)commonVertex, 0);
            QueryExpression parentKey = QueryTranslator.getKeyExpForParentPath(commonVertex, conf, metadataConnector);
            join = new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.first, parentTable), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.second, parentKey));
        }
        return join;
    }

    private static List<String> getEdgeSrcOrDstKey(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        return QueryTranslator.getEdgeSrcOrDstKeyPair(connection, conf, metadataConnector).stream().map(pair -> (String)pair.first).collect(Collectors.toList());
    }

    private static List<Pair<String, String>> getEdgeSrcOrDstKeyPair(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        String edge = conf.get(connection.first);
        List<Pair<String, String>> key = connection.second == TranslationInfo.Position.SRC ? metadataConnector.getEdgeTableSrcKey(edge) : metadataConnector.getEdgeTableDstKey(edge);
        return key;
    }

    private static Pair<QueryExpression, QueryExpression> getSrcOrDstTableAndKeyExp(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression keyExp;
        QueryExpression tableExp;
        if (((VertexPairConnection)connection.first).getVariableType() == QueryVariable.VariableType.PATH) {
            tableExp = new QueryExpression.PropertyAccess((QueryVariable)connection.first, connection.second + "_TABLE");
            keyExp = new QueryExpression.PropertyAccess((QueryVariable)connection.first, connection.second + "_KEY");
        } else {
            tableExp = QueryTranslator.getSrcOrDstTable(connection, conf);
            keyExp = QueryTranslator.getKeyExpForPath(QueryTranslator.getEdgeSrcOrDstKey(connection, conf, metadataConnector), (QueryVariable)connection.first, conf.get(connection.first), metadataConnector);
        }
        return new Pair<QueryExpression, QueryExpression>(tableExp, keyExp);
    }

    private static QueryExpression getSrcOrDstTable(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf) {
        QueryVertex vertex = connection.second == TranslationInfo.Position.SRC ? ((VertexPairConnection)connection.first).getSrc() : ((VertexPairConnection)connection.first).getDst();
        return new QueryExpression.Constant.ConstString(conf.get(vertex));
    }

    private static QueryExpression getKeyExpForPath(List<String> keyColumns, QueryVariable variable, String tableName, MetadataConnector metadataConnector) {
        QueryExpression keyExp = null;
        boolean escapeKeyCol = keyColumns.size() > 1;
        for (String keyCol : keyColumns) {
            Object colAccess = escapeKeyCol ? ExpressionTranslator.escapeKeyColumnForPath(variable, keyCol, tableName, metadataConnector) : new QueryExpression.PropertyAccess(variable, keyCol);
            if (keyExp == null) {
                keyExp = colAccess;
                continue;
            }
            keyExp = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(keyExp, (QueryExpression)new QueryExpression.Constant.ConstString(",")), colAccess);
        }
        return keyExp;
    }

    private static QueryExpression getKeyExpForParentPath(QueryVertex commonVertex, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        Object keyExp = null;
        int numKeyCols = metadataConnector.getVertexTableKey(conf.get(commonVertex)).size();
        for (int i = 1; i <= numKeyCols; ++i) {
            QueryExpression colAccess = QueryTranslator.buildKeyColumnReference((QueryVariable)commonVertex, i);
            keyExp = keyExp == null ? colAccess : new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(keyExp, (QueryExpression)new QueryExpression.Constant.ConstString(",")), colAccess);
        }
        return keyExp;
    }

    private static QueryExpression getVertexConnectionJoin(Pair<VertexPairConnection, TranslationInfo.Position> connection, QueryVertex vertex, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        boolean isParentVariable = translationInfo.isParentVertex(vertex.getName());
        boolean canSplitKey = translationInfo.canSplitId(vertex.getName());
        String vertexTable = conf.get(vertex);
        if (((VertexPairConnection)connection.first).getVariableType() == QueryVariable.VariableType.EDGE) {
            List<Pair<String, String>> edgeTableKey = QueryTranslator.getEdgeSrcOrDstKeyPair(connection, conf, metadataConnector);
            return QueryTranslator.getVertexEdgeJoin(edgeTableKey, (QueryEdge)connection.first, vertex, isParentVariable, canSplitKey, vertexTable, translationInfo.isForParentWhere());
        }
        return QueryTranslator.getVertexPathJoin((QueryPath)connection.first, vertex, (TranslationInfo.Position)((Object)connection.second), conf, metadataConnector, isParentVariable, canSplitKey, translationInfo.isForParentWhere());
    }

    private static QueryExpression getVertexEdgeJoin(List<Pair<String, String>> edgeTableKey, QueryEdge edge, QueryVertex vertex, boolean isParentVariable, boolean canSplitKey, String vertexTableName, boolean forParentWhere) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        if (isParentVariable && !forParentWhere) {
            if (canSplitKey) {
                QueryExpression tableName = QueryTranslator.buildKeyColumnReference((QueryVariable)vertex, 0);
                QueryExpression.RelationalExpression.Equal tableFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.Constant.ConstString(vertexTableName), tableName);
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)tableFilter);
                for (int i = 0; i < edgeTableKey.size(); ++i) {
                    Pair<String, String> keyColumn = edgeTableKey.get(i);
                    QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)keyColumn.first);
                    QueryExpression vertexKey = QueryTranslator.buildKeyColumnReference((QueryVariable)vertex, i + 1);
                    QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey);
                    join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)vertexFilter);
                }
            } else {
                QueryExpression.PropertyAccess concat = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)edgeTableKey.get((int)0).first);
                for (int i = 1; i < edgeTableKey.size(); ++i) {
                    concat = new QueryExpression.ConcatExpression((QueryExpression)concat, (QueryExpression)new QueryExpression.Constant.ConstString(","));
                    concat = new QueryExpression.ConcatExpression((QueryExpression)concat, (QueryExpression)new QueryExpression.PropertyAccess((QueryVariable)edge, (String)edgeTableKey.get((int)i).first));
                }
                QueryExpression.ConcatExpression edgeKey = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString(vertexTableName), (QueryExpression)new QueryExpression.Constant.ConstString("(")), (QueryExpression)concat), (QueryExpression)new QueryExpression.Constant.ConstString(")"));
                join = new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.VarRef((QueryVariable)vertex), (QueryExpression)edgeKey);
            }
        } else {
            for (Pair<String, String> keyColumn : edgeTableKey) {
                QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)keyColumn.first);
                QueryExpression.PropertyAccess vertexKey = new QueryExpression.PropertyAccess((QueryVariable)vertex, (String)keyColumn.second);
                QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, (QueryExpression)vertexKey);
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)vertexFilter);
            }
        }
        return join;
    }

    private static QueryExpression buildKeyColumnReference(QueryVariable var, int idx) {
        return new QueryExpression.VarRef((QueryVariable)new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)new ExpAsVar((QueryExpression)new QueryExpression.VarRef(var), var.getName() + "_" + idx, false)), var.getName(), false));
    }

    private static QueryExpression getVertexPathJoin(QueryPath path, QueryVertex vertex, TranslationInfo.Position variableName, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, boolean isParentVariable, boolean canSplitKey, boolean isForParentWhere) {
        QueryExpression.PropertyAccess tableAccess = new QueryExpression.PropertyAccess((QueryVariable)path, (Object)((Object)variableName) + "_TABLE");
        QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)path, (Object)((Object)variableName) + "_KEY");
        String tab = conf.get(vertex);
        if (isParentVariable && !isForParentWhere) {
            if (canSplitKey) {
                QueryExpression tableName = QueryTranslator.buildKeyColumnReference((QueryVariable)vertex, 0);
                QueryExpression.RelationalExpression.Equal tableFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.Constant.ConstString(tab), tableName);
                List<String> vertexTableKey = metadataConnector.getVertexTableKey(tab);
                QueryExpression vertexKey = QueryTranslator.buildKeyColumnReference((QueryVariable)vertex, 1);
                for (int i = 1; i < vertexTableKey.size(); ++i) {
                    vertexKey = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(vertexKey, (QueryExpression)new QueryExpression.Constant.ConstString(",")), QueryTranslator.buildKeyColumnReference((QueryVariable)vertex, i + 1));
                }
                QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey);
                return new QueryExpression.LogicalExpression.And((QueryExpression)tableFilter, (QueryExpression)vertexFilter);
            }
            QueryExpression.VarRef vertexKey = new QueryExpression.VarRef((QueryVariable)vertex);
            QueryExpression.ConcatExpression compositeKey = new QueryExpression.ConcatExpression((QueryExpression)tableAccess, (QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString("("), (QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)keyAccess, (QueryExpression)new QueryExpression.Constant.ConstString(")"))));
            return new QueryExpression.RelationalExpression.Equal((QueryExpression)compositeKey, (QueryExpression)vertexKey);
        }
        List<String> keyColumns = metadataConnector.getVertexTableKey(tab);
        QueryExpression vertexKey = QueryTranslator.getKeyExpForPath(keyColumns, (QueryVariable)vertex, tab, metadataConnector);
        return new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)tableAccess, (QueryExpression)new QueryExpression.Constant.ConstString(tab)), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey));
    }

    private static QueryExpression getEdgeKeyNotNull(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        List<String> edgeKey = QueryTranslator.getEdgeSrcOrDstKey(connection, conf, metadataConnector);
        for (String keyColumn : edgeKey) {
            QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)connection.first, keyColumn);
            QueryExpression.LogicalExpression.Not edgeFilter = new QueryExpression.LogicalExpression.Not((QueryExpression)new QueryExpression.IsNull((QueryExpression)keyAccess));
            join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)edgeFilter);
        }
        return join;
    }

    private static QueryExpression translateWhere(Set<QueryExpression> constraints, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        return constraints.stream().filter(queryExpression -> !LabelTranslator.isLabelExpression(queryExpression)).map(queryExpression -> ExpressionTranslator.translateForSubSelect(queryExpression, new ExpressionTranslator.SubSelectTransOptions(conf, metadataConnector, true, translationInfo))).reduce((QueryExpression)new QueryExpression.Constant.ConstBoolean(true), QueryExpression.LogicalExpression.And::new);
    }

    private static List<TableExpression> getTables(Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Map<QueryVariable, String> variableTableMap, TranslationInfo translationInfo, MetadataConnector metadataConnector, QueryContext ctx) {
        List<TableExpression> allTables = vertices.stream().filter(translationInfo::needVertexConnectionJoin).filter(v -> translationInfo.isNotCommonVariableInSubquery(v.getName())).map(queryVertex -> new TableReference(metadataConnector.getSchemaQualifiedVertexTableName((String)variableTableMap.get(queryVertex)), (QueryVariable)queryVertex)).collect(Collectors.toList());
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.EDGE).map(conn -> (QueryEdge)conn).forEach(queryEdge -> allTables.add(new TableReference(metadataConnector.getSchemaQualifiedEdgeTableName((String)variableTableMap.get(queryEdge)), (QueryVariable)queryEdge)));
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).map(conn -> (QueryPath)conn).forEach(queryPath -> allTables.add(PathTranslator.translatePath(queryPath, variableTableMap, metadataConnector, translationInfo, ctx)));
        return allTables;
    }

    private static TableExpression wrapForModificators(TableExpression translation, boolean addWithClause, List<ExpAsVar> selectElements, boolean isDistinct, List<ExpAsVar> groupByElems, List<OrderByElem> orderByElems, QueryExpression havingExp, QueryExpression offsetExp, QueryExpression limitExp, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
        String withClause = addWithClause ? (ctx.isShortestPathCursorSupported() ? WITH_CLAUSE : WITH_CLAUSE_12C) : "";
        ArrayList<Pair<String, String>> newSelectElements = new ArrayList<Pair<String, String>>();
        boolean addAggregate = groupByElems.size() > 0;
        HashMap selectAliases = new HashMap();
        selectElements.forEach(x -> {
            if (x.getExp().getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && x.getName().startsWith("_ora_comp_key_")) {
                List<String> keyColumns = QueryTranslator.splitCompositeKey(x);
                for (String keyColumn : keyColumns) {
                    newSelectElements.add(new Pair<String, String>(ExpressionTranslator.aggregateIfRequired(keyColumn, addAggregate), keyColumn));
                }
            } else {
                String select = ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(addAggregate, false, false, true, pathAggregations, metadataConnector, ctx, subqueryInfo));
                newSelectElements.add(new Pair<String, String>(select, x.getName()));
                selectAliases.put(x.getName(), select);
            }
        });
        List<TableExpression> tabs = Collections.singletonList(translation);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupByElems.forEach(x -> {
            if (x.getExp().getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && x.getName().startsWith("_ora_comp_key_")) {
                groupBy.addAll(QueryTranslator.splitCompositeKey(x));
            } else {
                String gb = ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(false, true, false, false, pathAggregations, metadataConnector, ctx, subqueryInfo));
                if (selectAliases.containsKey(x.getName()) && ((String)selectAliases.get(x.getName())).equals(gb)) {
                    gb = PgqlUtils.escapeAndEnquoteIdentifier(x.getName());
                }
                groupBy.add(gb);
            }
        });
        String having = havingExp == null ? null : ExpressionTranslator.translateQueryExpression(havingExp, new ExpressionTranslator.QueryExpTransOptions(true, false, false, false, pathAggregations, metadataConnector, ctx, subqueryInfo));
        List<String> orderBy = orderByElems.stream().map(x -> ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(groupByElems.size() > 0, true, false, false, pathAggregations, metadataConnector, ctx, subqueryInfo)) + (x.isAscending() ? "" : " DESC")).collect(Collectors.toList());
        String offset = "";
        if (offsetExp != null) {
            if (offsetExp.getExpType() == QueryExpression.ExpressionType.INTEGER || offsetExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                offset = ExpressionTranslator.translateQueryExpression(offsetExp, new ExpressionTranslator.QueryExpTransOptions(false, false, false, false, pathAggregations, metadataConnector, ctx, subqueryInfo));
            } else {
                throw new IllegalArgumentException("Unexpected expression type for OFFSET");
            }
        }
        String limit = "";
        if (limitExp != null) {
            if (limitExp.getExpType() == QueryExpression.ExpressionType.INTEGER || limitExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                limit = ExpressionTranslator.translateQueryExpression(limitExp, new ExpressionTranslator.QueryExpTransOptions(false, false, false, false, pathAggregations, metadataConnector, ctx, subqueryInfo));
            } else {
                throw new IllegalArgumentException("Unexpected expression type for LIMIT");
            }
        }
        return new Projection(isDistinct, withClause, newSelectElements, tabs, "", groupBy, having, orderBy, offset, limit);
    }

    private static List<String> splitCompositeKey(ExpAsVar x) {
        ArrayList<String> keyColumns = new ArrayList<String>();
        int numKeyColumns = Integer.parseInt(x.getName().substring(x.getName().lastIndexOf("_") + 1));
        String var = ((QueryExpression)((QueryExpression.FunctionCall)x.getExp()).getArgs().get(0)).toString();
        for (int i = 0; i <= numKeyColumns; ++i) {
            keyColumns.add(PgqlUtils.escapeAndEnquoteIdentifier(var + "_" + i));
        }
        return keyColumns;
    }

    private static String getWithClause(boolean for12c) {
        String fileName = for12c ? "with_clause_12c.sql" : "with_clause.sql";
        try (Scanner in = new Scanner(QueryTranslator.class.getClassLoader().getResourceAsStream(fileName)).useDelimiter("\\A");){
            String string = in.next();
            return string;
        }
    }

    static List<QueryExpression> getSubSelectElements(QueryExpression exp, final Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, final Map<QueryVariable, QueryPath> pathVariables, final Map<String, Pair<Boolean, QueryVariable>> variables, final Set<QueryVertex> commonJoinVertices, final Set<QueryVertex> commonVertices) {
        final ArrayList<QueryExpression> subSelectElements = new ArrayList<QueryExpression>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.VarRef varRef) {
                QueryVariable variable = varRef.getVariable();
                if (!variable.isAnonymous() && variables.containsKey(variable.getName())) {
                    switch (variable.getVariableType()) {
                        case VERTEX: 
                        case EDGE: {
                            subSelectElements.add(varRef);
                        }
                    }
                }
            }

            public void visit(QueryExpression.PropertyAccess prop) {
                if (variables.containsKey(prop.getVariable().getName())) {
                    if (!((QueryVariable)((Pair)variables.get((Object)prop.getVariable().getName())).second).equals((Object)prop.getVariable())) {
                        prop.setVariable((QueryVariable)((Pair)variables.get((Object)prop.getVariable().getName())).second);
                    }
                    subSelectElements.add(prop);
                }
            }

            public void visit(QueryExpression.FunctionCall functionCall) {
                if (functionCall.getFunctionName().equalsIgnoreCase("id") || functionCall.getFunctionName().equalsIgnoreCase("label") || functionCall.getFunctionName().equalsIgnoreCase("_ora_comp_key_f_") || functionCall.getFunctionName().equalsIgnoreCase("is_source_of") || functionCall.getFunctionName().equalsIgnoreCase("is_destination_of")) {
                    if (functionCall.getArgs().stream().allMatch(arg -> variables.containsKey(((QueryExpression.VarRef)arg).getVariable().getName()))) {
                        subSelectElements.add(functionCall);
                    }
                } else if (functionCall.getFunctionName().equalsIgnoreCase("has_label")) {
                    if (variables.containsKey(((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName())) {
                        subSelectElements.add(new QueryExpression.FunctionCall("label", Collections.singletonList(functionCall.getArgs().get(0))));
                        subSelectElements.addAll(QueryTranslator.getSubSelectElements((QueryExpression)functionCall.getArgs().get(1), pathAggregations, pathVariables, variables, commonJoinVertices, commonVertices));
                    }
                } else {
                    functionCall.getArgs().forEach(arg -> subSelectElements.addAll(QueryTranslator.getSubSelectElements(arg, pathAggregations, pathVariables, variables, commonJoinVertices, commonVertices)));
                }
            }

            public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrCount);
            }

            public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrListagg);
            }

            public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrMin);
            }

            public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrMax);
            }

            public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrSum);
            }

            public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrAvg);
            }

            public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayagg) {
                this.visit((QueryExpression.Aggregation.AbstractAggregation)aggrArrayagg);
            }

            public void visit(QueryExpression.Aggregation.AbstractAggregation agg) {
                QueryPath queryPath = QueryTranslator.isPathAggregation((QueryExpression.Aggregation)agg, pathVariables);
                if (queryPath != null) {
                    pathAggregations.put(agg, new PathTranslator.PathAggregateInfo(queryPath, pathAggregations.size() + 1, null));
                    subSelectElements.add(agg);
                } else {
                    subSelectElements.addAll(QueryTranslator.getSubSelectElements(agg.getExp(), pathAggregations, pathVariables, variables, commonJoinVertices, commonVertices));
                }
            }

            public void visit(QueryExpression.ScalarSubquery scalarSubquery) {
                this.visitSubquery((QueryExpression.Subquery)scalarSubquery);
            }

            public void visit(QueryExpression.Function.Exists exists) {
                this.visitSubquery((QueryExpression.Subquery)exists);
            }

            public void visitSubquery(QueryExpression.Subquery subquery) {
                this.visit(subquery.getQuery());
                GraphPattern graphPattern = subquery.getQuery().getGraphPattern();
                graphPattern.getConnections().forEach(e -> {
                    if (variables.containsKey(e.getSrc().getName())) {
                        commonJoinVertices.add(e.getSrc());
                    }
                    if (variables.containsKey(e.getDst().getName())) {
                        commonJoinVertices.add(e.getDst());
                    }
                });
                graphPattern.getVertices().forEach(v -> {
                    if (variables.containsKey(v.getName())) {
                        commonVertices.add(v);
                        subSelectElements.add(new QueryExpression.FunctionCall("label", Collections.singletonList(new QueryExpression.VarRef((QueryVariable)((Pair)variables2.get((Object)v.getName())).second))));
                    }
                });
            }
        });
        return subSelectElements;
    }

    private static List<QueryExpression> getAggregates(QueryExpression exp) {
        final ArrayList<QueryExpression> aggregates = new ArrayList<QueryExpression>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
                aggregates.add(aggrCount);
            }

            public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
                aggregates.add(aggrListagg);
            }

            public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
                aggregates.add(aggrMin);
            }

            public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
                aggregates.add(aggrMax);
            }

            public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
                aggregates.add(aggrSum);
            }

            public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
                aggregates.add(aggrAvg);
            }

            public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayagg) {
                aggregates.add(aggrArrayagg);
            }
        });
        return aggregates;
    }

    private static QueryPath isPathAggregation(QueryExpression.Aggregation aggregation, Map<QueryVariable, QueryPath> pathVariables) {
        boolean hasAggregates = QueryTranslator.getAggregates(((QueryExpression.Aggregation.AbstractAggregation)aggregation).getExp()).size() > 0;
        for (QueryVariable variable : oracle.pgql.lang.ir.PgqlUtils.getVariables((QueryExpression)aggregation)) {
            if (!pathVariables.containsKey(variable) || hasAggregates) continue;
            return pathVariables.get(variable);
        }
        return null;
    }

    private static void addSubSelectElements(QueryExpression queryExpression, List<ExpAsVar> subSelectProj, Set<String> subSelectVars, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, Map<QueryVariable, QueryPath> pathVariables, boolean addProjection, Map<String, Pair<Boolean, QueryVariable>> variables, Set<QueryVertex> commonJoinVertices, Set<QueryVertex> commonVertices) {
        List<QueryExpression> queryExpressions = QueryTranslator.getSubSelectElements(queryExpression, pathAggregations, pathVariables, variables, commonJoinVertices, commonVertices);
        for (QueryExpression exp : queryExpressions) {
            if (!addProjection) continue;
            QueryTranslator.addSubSelectExpression(exp, subSelectVars, subSelectProj);
        }
    }

    private static void addSubSelectExpression(QueryExpression exp, Set<String> subSelectVars, List<ExpAsVar> subSelectProj) {
        String subSelectVar = exp.toString();
        String escapedVar = PgqlUtils.escapeAndEnquoteIdentifier(subSelectVar);
        if (!subSelectVars.contains(escapedVar)) {
            subSelectProj.add(new ExpAsVar(exp, subSelectVar, false));
            subSelectVars.add(escapedVar);
        }
    }

    private static int getCompatibleKeyColumns(QueryVertex vertex, GraphPattern graphPattern, MetadataConnector metadataConnector) {
        TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(graphPattern, metadataConnector);
        int numKeyColumns = -1;
        List<String> keyTypes = null;
        for (String table : variableTableBinding.vertexTableMap.get(vertex)) {
            List<String> currentKeyTypes = metadataConnector.getVertexTableKeyTypes(table);
            if (keyTypes == null) {
                keyTypes = currentKeyTypes;
                numKeyColumns = currentKeyTypes.size();
                continue;
            }
            if (currentKeyTypes.size() != numKeyColumns) {
                return -1;
            }
            for (int i = 0; i < numKeyColumns; ++i) {
                if (QueryTranslator.areCompatibleTypes(currentKeyTypes.get(i), keyTypes.get(i))) continue;
                return -1;
            }
        }
        return numKeyColumns;
    }

    private static boolean areCompatibleTypes(String type1, String type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (type1.equals(type2)) {
            return true;
        }
        return QueryTranslator.getTypeFamily(type1).equals(QueryTranslator.getTypeFamily(type2));
    }

    private static String getTypeFamily(String type) {
        switch (type) {
            case "CHAR": 
            case "VARCHAR2": 
            case "CHARACTER": 
            case "VARCHAR": {
                return "CHAR";
            }
            case "NCHAR": 
            case "NVARCHAR2": 
            case "NATIONAL CHARACTER": 
            case "NATIONAL CHAR": {
                return "NCHAR";
            }
            case "NUMBER": 
            case "FLOAT": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": 
            case "NUMERIC": 
            case "DECIMAL": 
            case "DEC": 
            case "INTEGER": 
            case "INT": 
            case "DOUBLE PRECISION": 
            case "REAL": {
                return "NUMBER";
            }
            case "DATE": 
            case "TIMESTAMP": {
                return "DATE";
            }
        }
        return type;
    }

    public static class SubqueryInfo {
        public Map<String, Pair<Boolean, QueryVariable>> parentVariables;
        public Map<String, Pair<Boolean, QueryVariable>> variables;
        public Map<String, Pair<Boolean, QueryVariable>> selectAliases;
        public Map<String, Pair<Boolean, QueryVariable>> parentGbVariables;
        public Map<String, Pair<Boolean, QueryVariable>> gbVariables;
        public Set<VertexPairConnection> parentConnections;
        public Set<VertexPairConnection> connections;
        public boolean forParentWhere;
        public Map<QueryVariable, String> parentConf;
        public Set<QueryExpression> extraConstraints;
        public boolean insideAggregate;

        public SubqueryInfo(Map<String, Pair<Boolean, QueryVariable>> parentVariables, Map<String, Pair<Boolean, QueryVariable>> parentGbVariables, Set<VertexPairConnection> parentConnections, boolean forParentWhere, Map<QueryVariable, String> parentConf, boolean insideAggregate) {
            this.parentVariables = parentVariables;
            this.parentGbVariables = parentGbVariables;
            this.parentConnections = parentConnections;
            this.forParentWhere = forParentWhere;
            this.parentConf = parentConf;
            this.extraConstraints = new HashSet<QueryExpression>();
            this.insideAggregate = insideAggregate;
            this.variables = new HashMap<String, Pair<Boolean, QueryVariable>>();
            this.selectAliases = new HashMap<String, Pair<Boolean, QueryVariable>>();
            this.gbVariables = null;
            this.connections = new HashSet<VertexPairConnection>();
        }

        public boolean isGbVariable(String variable) {
            if (this.gbVariables == null) {
                return false;
            }
            return this.gbVariables.containsKey(variable);
        }
    }
}

