/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.AnyDirectedEdgeExtender;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TableTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TranslationInfo;
import oracle.pg.rdbms.pgql.pgview.translation.expression.EmptyProjection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.RecursiveWith;
import oracle.pg.rdbms.pgql.pgview.translation.expression.ShortestPath;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Union;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.PathFindingGoal;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.unnest.RowsPerMatchType;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTranslator {
    private static final Logger ms_log = LoggerFactory.getLogger(PathTranslator.class);
    public static final String PATH_VERTEX_PREFIX = "$_";
    public static final String SRC_PATH_VERTEX = "$_src";
    public static final String DST_PATH_VERTEX = "$_dst";

    static TableExpression translatePath(QueryPath queryPath, Map<QueryVariable, String> variableTableMap, MetadataConnector metadataConnector, TranslationInfo translationInfo, QueryContext ctx) {
        if (queryPath.getPathFindingGoal() == PathFindingGoal.CHEAPEST) {
            throw new UnsupportedOperationException("CHEAPEST finding goal is not supported");
        }
        if (queryPath.getPathFindingGoal() == PathFindingGoal.SHORTEST && queryPath.getWithTies()) {
            throw new UnsupportedOperationException("ALL SHORTEST finding goal is not supported");
        }
        if (queryPath.getRowsPerMatch().getRowsPerMatchType() != RowsPerMatchType.ONE_ROW_PER_MATCH) {
            throw new UnsupportedOperationException("Only ONE ROW PER MATCH is supported");
        }
        ArrayList<ExpAsVar> subSelectElems = new ArrayList<ExpAsVar>();
        List vertices = queryPath.getVertices();
        if (vertices.size() < 2) {
            throw new UnsupportedOperationException("Need at least one connection in path pattern");
        }
        subSelectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)vertices.get(0)), SRC_PATH_VERTEX, true));
        subSelectElems.add(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)vertices.get(vertices.size() - 1)), DST_PATH_VERTEX, true));
        Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations = translationInfo.getPathAggregations();
        QueryExpression expressions = pathAggregations.keySet().stream().filter(agg -> ((PathAggregateInfo)pathAggregations.get((Object)agg)).queryPath.equals((Object)queryPath)).map(agg -> (QueryExpression.Aggregation.AbstractAggregation)agg).map(agg -> {
            PathTranslator.checkBindVariables(agg.getExp(), true);
            String expTag = "EXP" + ((PathAggregateInfo)pathAggregations.get((Object)agg)).expNumber;
            return new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString("<" + expTag + ">"), agg.getExp()), (QueryExpression)new QueryExpression.Constant.ConstString("</" + expTag + ">"));
        }).reduce(QueryExpression.ConcatExpression::new).orElse((QueryExpression)new QueryExpression.Constant.ConstString(""));
        QueryExpression.ConcatExpression pathExpressions = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString("<EXPRESSIONS>"), expressions), (QueryExpression)new QueryExpression.Constant.ConstString("</EXPRESSIONS>"));
        subSelectElems.add(new ExpAsVar((QueryExpression)pathExpressions, "exp", true));
        AnyDirectedEdgeExtender edgeExtender = new AnyDirectedEdgeExtender(queryPath, subSelectElems);
        TableExpression tab = IntStream.range(0, edgeExtender.getExtendedConnectionsSize()).mapToObj(extension -> {
            edgeExtender.replaceExtendedEdges(extension);
            TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(queryPath, metadataConnector);
            List<Map<QueryVariable, String>> patternInstantiation = TableTranslator.generateAllPatternInstantiations(queryPath, variableTableBinding, metadataConnector);
            pathAggregations.keySet().stream().filter(agg -> ((PathAggregateInfo)pathAggregations.get((Object)agg)).queryPath.equals((Object)queryPath)).map(agg -> (QueryExpression.Aggregation.AbstractAggregation)agg).forEach(agg -> {
                if ((agg.getExpType() == QueryExpression.ExpressionType.AGGR_MAX || agg.getExpType() == QueryExpression.ExpressionType.AGGR_MIN) && agg.getExp().getExpType().equals((Object)QueryExpression.ExpressionType.PROP_ACCESS)) {
                    QueryExpression.PropertyAccess pa = (QueryExpression.PropertyAccess)agg.getExp();
                    String dataType = null;
                    block4: for (int i = 0; i < patternInstantiation.size() && dataType == null; ++i) {
                        String tableName = (String)((Map)patternInstantiation.get(i)).get(pa.getVariable());
                        switch (pa.getVariable().getVariableType()) {
                            case VERTEX: {
                                dataType = metadataConnector.getColumnTypeForVertexProperty(tableName, pa.getPropertyName());
                                continue block4;
                            }
                            case EDGE: {
                                dataType = metadataConnector.getColumnTypeForEdgeProperty(tableName, pa.getPropertyName());
                            }
                        }
                    }
                    if (dataType == null) {
                        dataType = "varchar2(4000)";
                    }
                    ((PathAggregateInfo)pathAggregations.get((Object)agg)).dataType = dataType;
                }
            });
            return PathTranslator.generateTranslation(patternInstantiation, queryPath, subSelectElems, metadataConnector, Collections.emptyMap(), ctx, translationInfo.subqueryInfo);
        }).filter(tableExpression -> !tableExpression.getClass().equals(EmptyProjection.class)).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
        edgeExtender.compressExtendedEdges();
        String patternTranslation = tab.prettyPrint();
        TranslationInfo.PathFilters filters = translationInfo.getPathFilters(queryPath);
        String srcTranslation = PathTranslator.generateTranslation(variableTableMap, queryPath.getSrc(), SRC_PATH_VERTEX, filters.srcFilter, metadataConnector, Collections.emptyMap(), ctx, translationInfo.subqueryInfo).prettyPrint();
        if (queryPath.getPathFindingGoal() == PathFindingGoal.ALL) {
            return new RecursiveWith((QueryVariable)queryPath, srcTranslation, "", patternTranslation, queryPath.getKValue(), queryPath.getMinHops(), queryPath.getMaxHops());
        }
        patternTranslation = DbmsUtils.splitClobInChunks(patternTranslation);
        srcTranslation = ctx.isShortestPathCursorSupported() ? "cursor(" + srcTranslation + ")" : DbmsUtils.splitClobInChunks(srcTranslation);
        String dstTranslation = DbmsUtils.splitClobInChunks(PathTranslator.generateTranslation(variableTableMap, queryPath.getDst(), DST_PATH_VERTEX, filters.dstFilter, metadataConnector, Collections.emptyMap(), ctx, translationInfo.subqueryInfo).prettyPrint());
        return new ShortestPath((QueryVariable)queryPath, srcTranslation, dstTranslation, patternTranslation, queryPath.getKValue(), queryPath.getMinHops(), queryPath.getMaxHops());
    }

    private static QueryTranslator.SubqueryInfo getSubQueryInfo(QueryTranslator.SubqueryInfo subqueryInfo) {
        return new QueryTranslator.SubqueryInfo(new HashMap<String, Pair<Boolean, QueryVariable>>(), null, new HashSet<VertexPairConnection>(), subqueryInfo.forParentWhere, new HashMap<QueryVariable, String>(), subqueryInfo.insideAggregate);
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, QueryPath queryPath, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations, QueryContext ctx, QueryTranslator.SubqueryInfo subqueryInfo) {
        return QueryTranslator.generateTranslation(patternInstantiations, new HashSet<QueryVertex>(queryPath.getVertices()), new HashSet<VertexPairConnection>(queryPath.getConnections()), queryPath.getConstraints(), subSelectElems, metadataConnector, pathAggregations, ctx, PathTranslator.getSubQueryInfo(subqueryInfo));
    }

    static TableExpression generateTranslation(Map<QueryVariable, String> patternInstantiation, QueryVertex queryVertex, String variableName, TranslationInfo.PathFilters.Filter filter, MetadataConnector metadataConnector, Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations, QueryContext ctx, QueryTranslator.SubqueryInfo subqueryInfo) {
        List<ExpAsVar> subSelectElems = Collections.singletonList(new ExpAsVar((QueryExpression)new QueryExpression.VarRef((QueryVariable)queryVertex), variableName, true));
        return QueryTranslator.generateTranslation(Collections.singletonList(patternInstantiation), filter.vertices, filter.connections, filter.constraints, subSelectElems, metadataConnector, pathAggregations, ctx, PathTranslator.getSubQueryInfo(subqueryInfo));
    }

    static void pushFilters(QueryPath queryPath, TranslationInfo.PathFilters pathFilters, Map<QueryVariable, List<Pair<VertexPairConnection, TranslationInfo.Position>>> vertexConnections, Map<QueryVariable, List<QueryExpression>> vertexConstraints, Map<QueryExpression.Aggregation, PathAggregateInfo> pathAggregations, QueryContext ctx) {
        PathTranslator.pushFilters(queryPath.getSrc(), (VertexPairConnection)queryPath, vertexConnections, vertexConstraints, pathFilters.srcFilter, ctx);
        PathTranslator.pushFilters(queryPath.getDst(), (VertexPairConnection)queryPath, vertexConnections, vertexConstraints, pathFilters.dstFilter, ctx);
        if (ctx.reversePath && pathFilters.dstFilter.filterWeight() > pathFilters.srcFilter.filterWeight()) {
            PathTranslator.reversePath(queryPath);
            pathFilters.reverseFilter();
            pathAggregations.values().forEach(info -> {
                info.isReversed = true;
            });
        }
        if (!ctx.pushSrcHops) {
            pathFilters.srcFilter.removeConnections(vertexConstraints);
        }
        if (!ctx.pushDstHops) {
            pathFilters.dstFilter.removeConnections(vertexConstraints);
        }
        if (PathTranslator.useWithClause(queryPath)) {
            if (!ctx.isShortestPathCursorSupported()) {
                PathTranslator.checkBindVariables(pathFilters.srcFilter.constraints, true);
            }
            if (PathTranslator.checkBindVariables(pathFilters.dstFilter.constraints, false)) {
                pathFilters.dstFilter.removeConstraints();
            }
            PathTranslator.checkBindVariables(queryPath.getConstraints(), true);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Query path:" + queryPath);
            ms_log.debug("SRC Vertices:" + pathFilters.srcFilter.vertices);
            ms_log.debug("SRC Constraints:" + pathFilters.srcFilter.constraints);
            ms_log.debug("SRC Connections:" + pathFilters.srcFilter.connections.stream().map(x -> x.getSrc().toString() + x + x.getDst()).collect(Collectors.joining("\n")));
            ms_log.debug("DST Vertices:" + pathFilters.dstFilter.vertices);
            ms_log.debug("DST Constraints:" + pathFilters.dstFilter.constraints);
            ms_log.debug("DST Connections:" + pathFilters.dstFilter.connections.stream().map(x -> x.getSrc().toString() + x + x.getDst()).collect(Collectors.joining("\n")));
        }
    }

    private static void pushFilters(QueryVertex vertex, VertexPairConnection edge, Map<QueryVariable, List<Pair<VertexPairConnection, TranslationInfo.Position>>> vertexConnections, Map<QueryVariable, List<QueryExpression>> vertexConstraints, TranslationInfo.PathFilters.Filter finalFilter, QueryContext ctx) {
        ArrayDeque<TranslationInfo.PathFilters.Filter> queue = new ArrayDeque<TranslationInfo.PathFilters.Filter>();
        TranslationInfo.PathFilters.Filter filter = new TranslationInfo.PathFilters.Filter(vertex, edge);
        filter.constraints.addAll((Collection<QueryExpression>)vertexConstraints.get(vertex));
        queue.add(filter);
        HashSet<QueryVertex> visitedVertices = new HashSet<QueryVertex>();
        while (!queue.isEmpty()) {
            List<Pair<VertexPairConnection, TranslationInfo.Position>> newConnections;
            TranslationInfo.PathFilters.Filter currentFilter = (TranslationInfo.PathFilters.Filter)queue.poll();
            if (visitedVertices.contains(currentFilter.vertex)) continue;
            visitedVertices.add(currentFilter.vertex);
            if (PathTranslator.isPushableFilter(currentFilter.constraints, ctx)) {
                finalFilter.pushFilter(currentFilter);
                currentFilter.emptyFilter();
            }
            if ((newConnections = vertexConnections.get(currentFilter.vertex)).size() <= 1) continue;
            for (Pair<VertexPairConnection, TranslationInfo.Position> connectionPair : newConnections) {
                VertexPairConnection newConnection = (VertexPairConnection)connectionPair.first;
                if (newConnection.equals(currentFilter.connection.first) || newConnection.getVariableType() == QueryVariable.VariableType.PATH) continue;
                QueryVertex newVertex = connectionPair.second == TranslationInfo.Position.SRC ? newConnection.getDst() : newConnection.getSrc();
                TranslationInfo.PathFilters.Filter newFilter = new TranslationInfo.PathFilters.Filter(newVertex, newConnection);
                newFilter.vertices.addAll(currentFilter.vertices);
                newFilter.constraints.addAll(currentFilter.constraints);
                newFilter.constraints.addAll((Collection<QueryExpression>)vertexConstraints.get(newVertex));
                newFilter.connections.addAll(currentFilter.connections);
                newFilter.connections.add(newConnection);
                queue.add(newFilter);
            }
        }
    }

    private static boolean isPushableFilter(Set<QueryExpression> constraints, QueryContext ctx) {
        return constraints.stream().anyMatch(filter -> PathTranslator.isConstantFilter(filter, ctx));
    }

    private static boolean isConstantFilter(QueryExpression exp, QueryContext ctx) {
        if (exp.getExpType() == QueryExpression.ExpressionType.EQUAL) {
            QueryExpression.RelationalExpression.Equal equal = (QueryExpression.RelationalExpression.Equal)exp;
            QueryExpression exp1 = equal.getExp1();
            QueryExpression exp2 = equal.getExp2();
            return PathTranslator.isConstant(exp1.getExpType(), ctx) && PathTranslator.isIdOrProperty(exp2) || PathTranslator.isConstant(exp2.getExpType(), ctx) && PathTranslator.isIdOrProperty(exp1);
        }
        return false;
    }

    private static boolean isIdOrProperty(QueryExpression exp) {
        QueryExpression.ExpressionType type = exp.getExpType();
        return type == QueryExpression.ExpressionType.PROP_ACCESS || type == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)exp).getFunctionName().equalsIgnoreCase("id");
    }

    private static boolean isConstant(QueryExpression.ExpressionType exp, QueryContext ctx) {
        switch (exp) {
            case INTEGER: 
            case DECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return true;
            }
            case BIND_VARIABLE: {
                return ctx.isShortestPathCursorSupported();
            }
        }
        return false;
    }

    static boolean isPathVertex(ExpAsVar expAsVar) {
        return expAsVar.getName().startsWith(PATH_VERTEX_PREFIX);
    }

    static boolean useWithClause(QueryPath path) {
        return path.getPathFindingGoal() != PathFindingGoal.ALL;
    }

    static boolean checkBindVariables(Set<QueryExpression> queryExpressions, boolean throwError) {
        return queryExpressions.stream().anyMatch(q -> PathTranslator.checkBindVariables(q, throwError));
    }

    static boolean checkBindVariables(QueryExpression queryExpression, final boolean throwError) {
        final MutableBoolean hasBindVariable = new MutableBoolean(false);
        queryExpression.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.BindVariable bv) {
                if (throwError) {
                    throw new UnsupportedOperationException("Use of bind variables for path queries is not supported");
                }
                hasBindVariable.setTrue();
            }
        });
        return hasBindVariable.booleanValue();
    }

    private static void reversePath(QueryPath queryPath) {
        Collections.reverse(queryPath.getConnections());
        Collections.reverse(queryPath.getVertices());
        QueryVertex aux = queryPath.getDst();
        queryPath.setDst(queryPath.getSrc());
        queryPath.setSrc(aux);
    }

    static class PathAggregateInfo {
        QueryPath queryPath;
        boolean isReversed;
        int expNumber;
        String dataType;

        public PathAggregateInfo(QueryPath queryPath, int expNumber, String dataType) {
            this.queryPath = queryPath;
            this.expNumber = expNumber;
            this.dataType = dataType;
            this.isReversed = false;
        }
    }
}

