/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.QueryExpression;

public class PgqlCreatePgVerifier {
    public static void verify(CreatePropertyGraph cpg) {
        HashMap<String, Pair<String, Set<String>>> labelProperties = new HashMap<String, Pair<String, Set<String>>>();
        for (VertexTable vt : cpg.getVertexTables()) {
            PgqlCreatePgVerifier.verifyElementTable((ElementTable)vt, labelProperties);
        }
        for (EdgeTable et : cpg.getEdgeTables()) {
            PgqlCreatePgVerifier.verifyElementTable((ElementTable)et, labelProperties);
        }
    }

    public static void verifyElementTable(ElementTable et, Map<String, Pair<String, Set<String>>> labelProperties) {
        for (Label l : et.getLabels()) {
            PgqlCreatePgVerifier.verifyLabel(et.getTableAlias(), l, labelProperties);
        }
    }

    private static void verifyLabel(String tableName, Label l, Map<String, Pair<String, Set<String>>> labelProperties) {
        HashSet<String> properties = new HashSet<String>();
        for (Property property : l.getProperties()) {
            QueryExpression qe = property.getValueExpression();
            String columnName = ((QueryExpression.VarRef)qe).getVariable().getName();
            properties.add(columnName);
        }
        String labelName = l.getName();
        if (labelProperties.containsKey(labelName)) {
            if (!((Set)labelProperties.get((Object)labelName).second).equals(properties)) {
                String provider2;
                String provider1;
                HashSet difference;
                Set checkProperties = (Set)labelProperties.get((Object)labelName).second;
                if (properties.size() < checkProperties.size()) {
                    difference = new HashSet(checkProperties);
                    difference.removeAll(properties);
                    provider1 = tableName;
                    provider2 = (String)labelProperties.get((Object)labelName).first;
                } else {
                    difference = new HashSet(properties);
                    difference.removeAll(checkProperties);
                    provider1 = (String)labelProperties.get((Object)labelName).first;
                    provider2 = tableName;
                }
                throw new PgqlToSqlException("Property " + (String)difference.iterator().next() + " is not in label " + labelName + " of provider " + provider1 + ", but it is in label " + labelName + " of provider " + provider2);
            }
        } else {
            labelProperties.put(labelName, new Pair(tableName, properties));
        }
    }
}

