/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.jdbc.OracleDriver;
import oracle.spatial.geometry.JGeometry;

public class CoordRefSys {
    private static final HashMap<Long, Srid> SRIDS = new HashMap();
    private static final double[] TO_WGS84_ID = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    private static void loadSRIDs() {
        CoordRefSys.loadGeodeticSRIDs();
        CoordRefSys.loadTransverseMercatorSRIDs();
        CoordRefSys.loadLambertConformalConicSRIDs();
    }

    /*
     * Opcode count of 18537 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void loadGeodeticSRIDs() {
        SRIDS.put(3819L, new GeodeticSrid(3819L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(3821L, new GeodeticSrid(3821L, 6378160.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(3824L, new GeodeticSrid(3824L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(3889L, new GeodeticSrid(3889L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(3906L, new GeodeticSrid(3906L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4001L, new GeodeticSrid(4001L, 6377563.396, 299.3249646, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4002L, new GeodeticSrid(4002L, 6377340.189, 299.3249646, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4003L, new GeodeticSrid(4003L, 6378160.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4004L, new GeodeticSrid(4004L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4005L, new GeodeticSrid(4005L, 6377492.018, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4006L, new GeodeticSrid(4006L, 6377483.865280418, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4007L, new GeodeticSrid(4007L, 6378293.63683822, 294.26067636926103, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4008L, new GeodeticSrid(4008L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4009L, new GeodeticSrid(4009L, 6378450.047548895, 294.9786971646772, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4010L, new GeodeticSrid(4010L, 6378300.789, 293.466315538985, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4011L, new GeodeticSrid(4011L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4012L, new GeodeticSrid(4012L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4013L, new GeodeticSrid(4013L, 6378249.145, 293.4663077, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4014L, new GeodeticSrid(4014L, 6378249.2, 293.46598, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4015L, new GeodeticSrid(4015L, 6377276.345, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4016L, new GeodeticSrid(4016L, 6377298.556, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4018L, new GeodeticSrid(4018L, 6377304.063, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4019L, new GeodeticSrid(4019L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4020L, new GeodeticSrid(4020L, 6378200.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4021L, new GeodeticSrid(4021L, 6378160.0, 298.247, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4022L, new GeodeticSrid(4022L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4023L, new GeodeticSrid(4023L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4024L, new GeodeticSrid(4024L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4025L, new GeodeticSrid(4025L, 6378145.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4027L, new GeodeticSrid(4027L, 6376523.0, 308.64, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4028L, new GeodeticSrid(4028L, 6378298.3, 294.73, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4029L, new GeodeticSrid(4029L, 6378300.0, 296.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4030L, new GeodeticSrid(4030L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4031L, new GeodeticSrid(4031L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4032L, new GeodeticSrid(4032L, 6378136.2, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4033L, new GeodeticSrid(4033L, 6378136.3, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4034L, new GeodeticSrid(4034L, 6378249.13643753, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4036L, new GeodeticSrid(4036L, 6378160.0, 298.247167427, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4041L, new GeodeticSrid(4041L, 6378135.0, 298.257, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4042L, new GeodeticSrid(4042L, 6377299.365595379, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4043L, new GeodeticSrid(4043L, 6378135.0, 298.26, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4044L, new GeodeticSrid(4044L, 6377301.243, 300.8017255, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4045L, new GeodeticSrid(4045L, 6377299.151, 300.8017255, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4046L, new GeodeticSrid(4046L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4054L, new GeodeticSrid(4054L, 6378273.0, 298.2794111230637, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4055L, new GeodeticSrid(4055L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4075L, new GeodeticSrid(4075L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4081L, new GeodeticSrid(4081L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4120L, new GeodeticSrid(4120L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4121L, new GeodeticSrid(4121L, 6378137.0, 298.257222101, new double[]{-199.87, 74.79, 246.62, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4122L, new GeodeticSrid(4122L, 6378135.0, 298.257, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4123L, new GeodeticSrid(4123L, 6378388.0, 297.0, new double[]{-90.7, -106.1, -119.2, 4.09, 0.218, -1.05, 1.37}, 57.29577951308238, 0.0));
        SRIDS.put(4124L, new GeodeticSrid(4124L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4125L, new GeodeticSrid(4125L, 6377397.155, 299.1528128, new double[]{-404.78, 685.68, 45.47, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4126L, new GeodeticSrid(4126L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4127L, new GeodeticSrid(4127L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4128L, new GeodeticSrid(4128L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4129L, new GeodeticSrid(4129L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4130L, new GeodeticSrid(4130L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4131L, new GeodeticSrid(4131L, 6377276.345, 300.8017, new double[]{198.0, 881.0, 317.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4132L, new GeodeticSrid(4132L, 6378249.145, 293.465, new double[]{-241.54, -163.64, 396.06, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4133L, new GeodeticSrid(4133L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4134L, new GeodeticSrid(4134L, 6378249.145, 293.465, new double[]{-180.624, -225.516, 173.919, -0.81, -1.898, 8.336, 16.71006}, 57.29577951308238, 0.0));
        SRIDS.put(4135L, new GeodeticSrid(4135L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4136L, new GeodeticSrid(4136L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4137L, new GeodeticSrid(4137L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4138L, new GeodeticSrid(4138L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4139L, new GeodeticSrid(4139L, 6378206.4, 294.97869821390583, new double[]{11.0, 72.0, -101.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4140L, new GeodeticSrid(4140L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4141L, new GeodeticSrid(4141L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4142L, new GeodeticSrid(4142L, 6378249.145, 293.465, new double[]{-125.0, 53.0, 467.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4143L, new GeodeticSrid(4143L, 6378249.145, 293.465, new double[]{-124.76, 53.0, 466.79, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4144L, new GeodeticSrid(4144L, 6377276.345, 300.8017, new double[]{282.0, 726.0, 254.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4145L, new GeodeticSrid(4145L, 6377301.243, 300.8017255, new double[]{283.0, 682.0, 231.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4146L, new GeodeticSrid(4146L, 6377299.151, 300.8017255, new double[]{295.0, 736.0, 257.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4147L, new GeodeticSrid(4147L, 6378245.0, 298.3, new double[]{-17.51, -108.32, -62.39, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4148L, new GeodeticSrid(4148L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4149L, new GeodeticSrid(4149L, 6377397.155, 299.1528128, new double[]{674.374, 15.056, 405.346, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4150L, new GeodeticSrid(4150L, 6377397.155, 299.1528128, new double[]{674.374, 15.056, 405.346, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4151L, new GeodeticSrid(4151L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4152L, new GeodeticSrid(4152L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4153L, new GeodeticSrid(4153L, 6378388.0, 297.0, new double[]{-133.63, -157.5, -158.62, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4154L, new GeodeticSrid(4154L, 6378388.0, 297.0, new double[]{-110.33, -97.73, -119.85, 0.3423, 1.1634, 0.2715, 0.063}, 57.29577951308238, 0.0));
        SRIDS.put(4155L, new GeodeticSrid(4155L, 6378249.2, 293.4660212936294, new double[]{-83.0, 37.0, 124.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4156L, new GeodeticSrid(4156L, 6377397.155, 299.1528128, new double[]{570.8, 85.7, 462.8, 4.998, 1.587, 5.261, 3.56}, 57.29577951308238, 0.0));
        SRIDS.put(4157L, new GeodeticSrid(4157L, 6378293.63683822, 294.26067636926103, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4158L, new GeodeticSrid(4158L, 6378388.0, 297.0, new double[]{-0.465, 372.095, 171.736, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4159L, new GeodeticSrid(4159L, 6378388.0, 297.0, new double[]{-194.513, -63.978, -25.759, -3.4027, 3.756, -3.352, -0.9175}, 57.29577951308238, 0.0));
        SRIDS.put(4160L, new GeodeticSrid(4160L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4161L, new GeodeticSrid(4161L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4162L, new GeodeticSrid(4162L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4163L, new GeodeticSrid(4163L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4164L, new GeodeticSrid(4164L, 6378245.0, 298.3, new double[]{-76.0, -138.0, 67.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4165L, new GeodeticSrid(4165L, 6378388.0, 297.0, new double[]{-173.0, 253.0, 27.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4166L, new GeodeticSrid(4166L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4167L, new GeodeticSrid(4167L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4168L, new GeodeticSrid(4168L, 6378300.0, 296.0, new double[]{-199.0, 32.0, 322.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4169L, new GeodeticSrid(4169L, 6378206.4, 294.97869821390583, new double[]{-115.0, 118.0, 426.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4170L, new GeodeticSrid(4170L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4171L, new GeodeticSrid(4171L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4172L, new GeodeticSrid(4172L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4173L, new GeodeticSrid(4173L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4174L, new GeodeticSrid(4174L, 6378300.0, 296.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4175L, new GeodeticSrid(4175L, 6378249.145, 293.465, new double[]{-88.0, 4.0, 101.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4176L, new GeodeticSrid(4176L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4178L, new GeodeticSrid(4178L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4179L, new GeodeticSrid(4179L, 6378245.0, 298.3, new double[]{33.4, -146.6, -76.3, -0.359, -0.053, 0.844, -0.84}, 57.29577951308238, 0.0));
        SRIDS.put(4180L, new GeodeticSrid(4180L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4181L, new GeodeticSrid(4181L, 6378388.0, 297.0, new double[]{-193.0, 13.7, -39.3, -0.41, -2.933, 2.688, 0.43}, 57.29577951308238, 0.0));
        SRIDS.put(4182L, new GeodeticSrid(4182L, 6378388.0, 297.0, new double[]{-425.0, -169.0, 81.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4183L, new GeodeticSrid(4183L, 6378388.0, 297.0, new double[]{-104.0, 167.0, -38.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4184L, new GeodeticSrid(4184L, 6378388.0, 297.0, new double[]{-203.0, 141.0, 53.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4185L, new GeodeticSrid(4185L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4188L, new GeodeticSrid(4188L, 6377563.396, 299.3249646, new double[]{482.5, -130.6, 564.6, -1.042, -0.214, -0.631, 8.15}, 57.29577951308238, 0.0));
        SRIDS.put(4189L, new GeodeticSrid(4189L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4190L, new GeodeticSrid(4190L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4191L, new GeodeticSrid(4191L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4192L, new GeodeticSrid(4192L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4193L, new GeodeticSrid(4193L, 6378249.2, 293.4660212936294, new double[]{-70.9, -151.8, -41.4, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4194L, new GeodeticSrid(4194L, 6378388.0, 297.0, new double[]{163.511, 127.533, -159.789, 0.0, 0.0, 0.814, -0.6}, 57.29577951308238, 0.0));
        SRIDS.put(4195L, new GeodeticSrid(4195L, 6378388.0, 297.0, new double[]{105.0, 326.0, -102.5, 0.0, 0.0, 0.814, -0.6}, 57.29577951308238, 0.0));
        SRIDS.put(4196L, new GeodeticSrid(4196L, 6378388.0, 297.0, new double[]{-45.0, 417.0, -3.5, 0.0, 0.0, 0.814, -0.6}, 57.29577951308238, 0.0));
        SRIDS.put(4197L, new GeodeticSrid(4197L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4198L, new GeodeticSrid(4198L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4199L, new GeodeticSrid(4199L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4200L, new GeodeticSrid(4200L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4201L, new GeodeticSrid(4201L, 6378249.145, 293.465, new double[]{-166.0, -15.0, 204.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4202L, new GeodeticSrid(4202L, 6378160.0, 298.25, new double[]{-133.0, -48.0, 148.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4203L, new GeodeticSrid(4203L, 6378160.0, 298.25, new double[]{-134.0, -48.0, 149.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4204L, new GeodeticSrid(4204L, 6378388.0, 297.0, new double[]{-150.0, -250.0, -1.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4205L, new GeodeticSrid(4205L, 6378245.0, 298.3, new double[]{-43.0, -163.0, 45.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4206L, new GeodeticSrid(4206L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4207L, new GeodeticSrid(4207L, 6378388.0, 297.0, new double[]{-282.1, -72.2, 120.0, -1.592, 0.145, -0.89, -4.46}, 57.29577951308238, 0.0));
        SRIDS.put(4208L, new GeodeticSrid(4208L, 6378388.0, 297.0, new double[]{-158.0, 315.0, -148.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4209L, new GeodeticSrid(4209L, 6378249.145, 293.4663077, new double[]{-143.0, -90.0, -294.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4210L, new GeodeticSrid(4210L, 6378249.145, 293.465, new double[]{-160.0, -6.0, -302.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4211L, new GeodeticSrid(4211L, 6377397.155, 299.1528128, new double[]{-377.0, 681.0, -50.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4212L, new GeodeticSrid(4212L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4213L, new GeodeticSrid(4213L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4214L, new GeodeticSrid(4214L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4215L, new GeodeticSrid(4215L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4216L, new GeodeticSrid(4216L, 6378206.4, 294.97869821390583, new double[]{-73.0, 213.0, 296.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4218L, new GeodeticSrid(4218L, 6378388.0, 297.0, new double[]{307.0, 304.0, -318.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4219L, new GeodeticSrid(4219L, 6377397.155, 299.1528128, new double[]{-384.0, 664.0, -48.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4220L, new GeodeticSrid(4220L, 6378249.145, 293.465, new double[]{-37.2, -370.6, -224.0, 0.0, 0.0, 0.554, 0.219}, 57.29577951308238, 0.0));
        SRIDS.put(4221L, new GeodeticSrid(4221L, 6378388.0, 297.0, new double[]{-148.0, 136.0, 90.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4222L, new GeodeticSrid(4222L, 6378249.145, 293.4663077, new double[]{-136.0, -108.0, -292.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4223L, new GeodeticSrid(4223L, 6378249.2, 293.4660212936294, new double[]{-263.0, 6.0, 431.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4224L, new GeodeticSrid(4224L, 6378388.0, 297.0, new double[]{-134.0, 229.0, -29.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4225L, new GeodeticSrid(4225L, 6378388.0, 297.0, new double[]{-206.0, 172.0, -6.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4226L, new GeodeticSrid(4226L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4227L, new GeodeticSrid(4227L, 6378249.2, 293.4660212936294, new double[]{-175.09, 1.218, 238.831, -0.047, 0.019, 0.808, 0.1698}, 57.29577951308238, 0.0));
        SRIDS.put(4228L, new GeodeticSrid(4228L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4229L, new GeodeticSrid(4229L, 6378200.0, 298.3, new double[]{-130.0, 110.0, -13.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4230L, new GeodeticSrid(4230L, 6378388.0, 297.0, new double[]{-89.5, -93.8, -123.1, 0.0, 0.0, -0.156, 1.2}, 57.29577951308238, 0.0));
        SRIDS.put(4231L, new GeodeticSrid(4231L, 6378388.0, 297.0, new double[]{-82.981, -99.719, -110.709, -0.104700015651, 0.031001600379, 0.080402021475, -0.3143}, 57.29577951308238, 0.0));
        SRIDS.put(4232L, new GeodeticSrid(4232L, 6378249.145, 293.465, new double[]{-333.102, -11.02, 230.69, 0.0, 0.0, 0.554, 0.219}, 57.29577951308238, 0.0));
        SRIDS.put(4233L, new GeodeticSrid(4233L, 6378388.0, 297.0, new double[]{-133.0, -321.0, 50.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4234L, new GeodeticSrid(4234L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4235L, new GeodeticSrid(4235L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4236L, new GeodeticSrid(4236L, 6378388.0, 297.0, new double[]{-637.0, -549.0, -203.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4237L, new GeodeticSrid(4237L, 6378160.0, 298.247167427, new double[]{57.01, -69.97, -9.29, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4238L, new GeodeticSrid(4238L, 6378160.0, 298.247, new double[]{2.691, -14.757, 4.724, 0.0, 0.0, 0.774, -0.6}, 57.29577951308238, 0.0));
        SRIDS.put(4239L, new GeodeticSrid(4239L, 6377276.345, 300.8017, new double[]{217.0, 823.0, 299.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4240L, new GeodeticSrid(4240L, 6377276.345, 300.8017, new double[]{293.0, 836.0, 318.0, 0.5, 1.6, -2.8, 2.1}, 57.29577951308238, 0.0));
        SRIDS.put(4241L, new GeodeticSrid(4241L, 6378249.13643753, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4242L, new GeodeticSrid(4242L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4243L, new GeodeticSrid(4243L, 6377299.365595379, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4244L, new GeodeticSrid(4244L, 6377276.345, 300.8017, new double[]{-97.0, 787.0, 86.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4245L, new GeodeticSrid(4245L, 6377304.063, 300.8017, new double[]{-11.0, 851.0, 5.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4246L, new GeodeticSrid(4246L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4247L, new GeodeticSrid(4247L, 6378388.0, 297.0, new double[]{-273.5, 110.6, -357.9, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4248L, new GeodeticSrid(4248L, 6378388.0, 297.0, new double[]{-288.0, 175.0, -376.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4249L, new GeodeticSrid(4249L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4250L, new GeodeticSrid(4250L, 6378249.145, 293.465, new double[]{-130.0, 29.0, 364.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4251L, new GeodeticSrid(4251L, 6378249.145, 293.465, new double[]{-90.0, 40.0, 88.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4252L, new GeodeticSrid(4252L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4253L, new GeodeticSrid(4253L, 6378206.4, 294.97869821390583, new double[]{-133.0, -77.0, -51.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4254L, new GeodeticSrid(4254L, 6378388.0, 297.0, new double[]{18.38, 192.45, 96.82, 0.056, -0.142, -0.2, -0.0013}, 57.29577951308238, 0.0));
        SRIDS.put(4255L, new GeodeticSrid(4255L, 6378388.0, 297.0, new double[]{-333.0, -222.0, 114.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4256L, new GeodeticSrid(4256L, 6378249.145, 293.465, new double[]{41.0, -220.0, -134.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4257L, new GeodeticSrid(4257L, 6377397.155, 299.1528128, new double[]{-587.8, 519.75, 145.76, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4258L, new GeodeticSrid(4258L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4259L, new GeodeticSrid(4259L, 6378388.0, 297.0, new double[]{-252.95, -4.11, -96.38, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4260L, new GeodeticSrid(4260L, 6378249.145, 293.465, new double[]{-70.9, -151.8, -41.4, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4261L, new GeodeticSrid(4261L, 6378249.2, 293.4660212936294, new double[]{31.0, 146.0, 47.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4262L, new GeodeticSrid(4262L, 6377397.155, 299.1528128, new double[]{639.0, 405.0, 60.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4263L, new GeodeticSrid(4263L, 6378249.145, 293.465, new double[]{-111.92, -87.85, 114.5, 1.875, 0.202, 0.219, 32000.0}, 57.29577951308238, 0.0));
        SRIDS.put(4264L, new GeodeticSrid(4264L, 6378388.0, 297.0, new double[]{-252.95, -4.11, -96.38, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4265L, new GeodeticSrid(4265L, 6378388.0, 297.0, new double[]{-168.6, -34.0, 38.6, -0.374, -0.679, -1.379, -9.48}, 57.29577951308238, 0.0));
        SRIDS.put(4266L, new GeodeticSrid(4266L, 6378249.2, 293.4660212936294, new double[]{-74.0, -130.0, 42.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4267L, new GeodeticSrid(4267L, 6378206.4, 294.97869821390583, new double[]{-8.0, 160.0, 176.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4268L, new GeodeticSrid(4268L, 6378450.047548895, 294.9786971646772, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4269L, new GeodeticSrid(4269L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4270L, new GeodeticSrid(4270L, 6378249.145, 293.465, new double[]{-247.0, -148.0, 369.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4271L, new GeodeticSrid(4271L, 6378388.0, 297.0, new double[]{-10.0, 375.0, 165.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4272L, new GeodeticSrid(4272L, 6378388.0, 297.0, new double[]{84.0, -22.0, 209.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4273L, new GeodeticSrid(4273L, 6377492.018, 299.1528128, new double[]{278.3, 93.0, 474.5, 7.889, 0.05, -6.61, 6.21}, 57.29577951308238, 0.0));
        SRIDS.put(4274L, new GeodeticSrid(4274L, 6378388.0, 297.0, new double[]{-231.0, 102.6, 29.8, 0.615, -0.198, 0.881, 1.79}, 57.29577951308238, 0.0));
        SRIDS.put(4275L, new GeodeticSrid(4275L, 6378249.2, 293.4660212936294, new double[]{-168.0, -60.0, 320.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4276L, new GeodeticSrid(4276L, 6378145.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4277L, new GeodeticSrid(4277L, 6377563.396, 299.3249646, new double[]{446.448, -125.157, 542.06, 0.15, 0.247, 0.842, -20.489}, 57.29577951308238, 0.0));
        SRIDS.put(4278L, new GeodeticSrid(4278L, 6377563.396, 299.3249646, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4279L, new GeodeticSrid(4279L, 6377563.396, 299.3249646, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4280L, new GeodeticSrid(4280L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4281L, new GeodeticSrid(4281L, 6378300.789, 293.466315538985, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4282L, new GeodeticSrid(4282L, 6378249.2, 293.4660212936294, new double[]{-178.3, -316.7, -131.5, 5.278, 6.077, 10.979, 19.166}, 57.29577951308238, 0.0));
        SRIDS.put(4283L, new GeodeticSrid(4283L, 6378137.0, 298.257222101, new double[]{0.06155, -0.01087, -0.04019, 0.0394924, 0.0327221, 0.0328979, -0.009994}, 57.29577951308238, 0.0));
        SRIDS.put(4284L, new GeodeticSrid(4284L, 6378245.0, 298.3, new double[]{43.822, -108.842, -119.585, 1.455, -0.761, 0.737, 0.549}, 57.29577951308238, 0.0));
        SRIDS.put(4285L, new GeodeticSrid(4285L, 6378388.0, 297.0, new double[]{-128.0, -283.0, 22.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4286L, new GeodeticSrid(4286L, 6378200.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4287L, new GeodeticSrid(4287L, 6378388.0, 297.0, new double[]{164.0, 138.0, -189.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4288L, new GeodeticSrid(4288L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4289L, new GeodeticSrid(4289L, 6377397.155, 299.1528128, new double[]{593.16, 26.15, 478.54, -1.304398008226, -0.103297414969, -1.144501530423, 4.0775}, 57.29577951308238, 0.0));
        SRIDS.put(4291L, new GeodeticSrid(4291L, 6378160.0, 298.247167427, new double[]{-57.0, 1.0, -41.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4292L, new GeodeticSrid(4292L, 6378388.0, 297.0, new double[]{-355.0, 21.0, 72.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4293L, new GeodeticSrid(4293L, 6377483.865280418, 299.1528128, new double[]{616.0, 97.0, -251.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4294L, new GeodeticSrid(4294L, 6377397.155, 299.1528128, new double[]{-403.0, 684.0, 41.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4295L, new GeodeticSrid(4295L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4296L, new GeodeticSrid(4296L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4297L, new GeodeticSrid(4297L, 6378388.0, 297.0, new double[]{-189.0, -242.0, -91.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4298L, new GeodeticSrid(4298L, 6377298.556, 300.8017, new double[]{-533.4, 669.2, -52.5, 0.0, 0.0, 4.28, 9.4}, 57.29577951308238, 0.0));
        SRIDS.put(4299L, new GeodeticSrid(4299L, 6377340.189, 299.3249646, new double[]{482.5, -130.6, 564.6, -1.042, -0.214, -0.631, 8.15}, 57.29577951308238, 0.0));
        SRIDS.put(4300L, new GeodeticSrid(4300L, 6377340.189, 299.3249646, new double[]{482.5, -130.6, 564.6, -1.042, -0.214, -0.631, 8.15}, 57.29577951308238, 0.0));
        SRIDS.put(4301L, new GeodeticSrid(4301L, 6377397.155, 299.1528128, new double[]{-148.0, 507.0, 685.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4302L, new GeodeticSrid(4302L, 6378293.63683822, 294.26067636926103, new double[]{-61.702, 284.488, 472.052, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4303L, new GeodeticSrid(4303L, 6378200.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4304L, new GeodeticSrid(4304L, 6378249.2, 293.4660212936294, new double[]{-73.0, -247.0, 227.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4306L, new GeodeticSrid(4306L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4307L, new GeodeticSrid(4307L, 6378249.145, 293.465, new double[]{-152.9, 43.8, 358.3, 2.714, 1.386, -2.788, -6.743}, 57.29577951308238, 0.0));
        SRIDS.put(4308L, new GeodeticSrid(4308L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4309L, new GeodeticSrid(4309L, 6378388.0, 297.0, new double[]{-155.0, 171.0, 37.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4310L, new GeodeticSrid(4310L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4311L, new GeodeticSrid(4311L, 6378388.0, 297.0, new double[]{-265.0, 120.0, -358.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4312L, new GeodeticSrid(4312L, 6377397.155, 299.1528128, new double[]{577.326, 90.129, 463.919, 5.137, 1.474, 5.297, 2.4232}, 57.29577951308238, 0.0));
        SRIDS.put(4313L, new GeodeticSrid(4313L, 6378388.0, 297.0, new double[]{-125.8, 79.9, -100.5, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4314L, new GeodeticSrid(4314L, 6377397.155, 299.1528128, new double[]{598.1, 73.7, 418.2, 0.202, 0.045, -2.455, 6.7}, 57.29577951308238, 0.0));
        SRIDS.put(4315L, new GeodeticSrid(4315L, 6378249.2, 293.4660212936294, new double[]{-23.0, 259.0, -9.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4316L, new GeodeticSrid(4316L, 6378388.0, 297.0, new double[]{103.25, -100.4, -307.19, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4317L, new GeodeticSrid(4317L, 6378245.0, 298.3, new double[]{28.0, -121.0, -77.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4318L, new GeodeticSrid(4318L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4319L, new GeodeticSrid(4319L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4322L, new GeodeticSrid(4322L, 6378135.0, 298.26, new double[]{0.0, 0.0, 4.5, 0.0, 0.0, 0.554, 0.219}, 57.29577951308238, 0.0));
        SRIDS.put(4324L, new GeodeticSrid(4324L, 6378135.0, 298.26, new double[]{0.0, 0.0, 1.9, 0.0, 0.0, 0.814, -0.38}, 57.29577951308238, 0.0));
        SRIDS.put(4326L, new GeodeticSrid(4326L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4463L, new GeodeticSrid(4463L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4470L, new GeodeticSrid(4470L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4475L, new GeodeticSrid(4475L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4483L, new GeodeticSrid(4483L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4490L, new GeodeticSrid(4490L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4555L, new GeodeticSrid(4555L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4558L, new GeodeticSrid(4558L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4600L, new GeodeticSrid(4600L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4601L, new GeodeticSrid(4601L, 6378249.145, 293.465, new double[]{-255.0, -15.0, 71.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4602L, new GeodeticSrid(4602L, 6378249.145, 293.465, new double[]{725.0, 685.0, 536.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4603L, new GeodeticSrid(4603L, 6378249.145, 293.465, new double[]{72.0, 213.7, 93.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4604L, new GeodeticSrid(4604L, 6378249.145, 293.465, new double[]{174.0, 359.0, 365.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4605L, new GeodeticSrid(4605L, 6378249.145, 293.465, new double[]{9.0, 183.0, 236.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4606L, new GeodeticSrid(4606L, 6378249.145, 293.465, new double[]{-149.0, 128.0, 296.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4607L, new GeodeticSrid(4607L, 6378249.145, 293.465, new double[]{195.671, 332.517, 274.607, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4608L, new GeodeticSrid(4608L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4609L, new GeodeticSrid(4609L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4610L, new GeodeticSrid(4610L, 6378140.0, 298.257, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4611L, new GeodeticSrid(4611L, 6378388.0, 297.0, new double[]{-162.619, -276.959, -161.764, 0.067753, -2.243649, -1.158827, -1.094246}, 57.29577951308238, 0.0));
        SRIDS.put(4612L, new GeodeticSrid(4612L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4613L, new GeodeticSrid(4613L, 6377397.155, 299.1528128, new double[]{-404.78, 685.68, 45.47, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4614L, new GeodeticSrid(4614L, 6378388.0, 297.0, new double[]{-119.4248, -303.65872, -11.00061, 1.164298, 0.174458, 1.096259, 3.657065}, 57.29577951308238, 0.0));
        SRIDS.put(4615L, new GeodeticSrid(4615L, 6378388.0, 297.0, new double[]{-499.0, -249.0, 314.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4616L, new GeodeticSrid(4616L, 6378388.0, 297.0, new double[]{-289.0, -124.0, 60.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4617L, new GeodeticSrid(4617L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4618L, new GeodeticSrid(4618L, 6378160.0, 298.25, new double[]{-57.0, 1.0, -41.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4619L, new GeodeticSrid(4619L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4620L, new GeodeticSrid(4620L, 6378249.145, 293.465, new double[]{-106.0, -129.0, 165.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4621L, new GeodeticSrid(4621L, 6378388.0, 297.0, new double[]{137.0, 248.0, -430.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4622L, new GeodeticSrid(4622L, 6378388.0, 297.0, new double[]{-472.29, -5.63, -304.12, 0.4362, -0.8374, 0.2563, 1.8984}, 57.29577951308238, 0.0));
        SRIDS.put(4623L, new GeodeticSrid(4623L, 6378388.0, 297.0, new double[]{-186.0, 230.0, 110.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4624L, new GeodeticSrid(4624L, 6378137.0, 298.257222101, new double[]{2.0, 2.0, -2.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4625L, new GeodeticSrid(4625L, 6378388.0, 297.0, new double[]{126.93, 547.94, 130.41, -2.7867, 5.1612, -0.8584, 13.8227}, 57.29577951308238, 0.0));
        SRIDS.put(4626L, new GeodeticSrid(4626L, 6378388.0, 297.0, new double[]{94.0, -948.0, -1292.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4627L, new GeodeticSrid(4627L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4628L, new GeodeticSrid(4628L, 6378388.0, 297.0, new double[]{162.0, 117.0, 154.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4629L, new GeodeticSrid(4629L, 6378388.0, 297.0, new double[]{65.0, 342.0, 77.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4630L, new GeodeticSrid(4630L, 6378388.0, 297.0, new double[]{84.0, 274.0, 65.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4631L, new GeodeticSrid(4631L, 6378388.0, 297.0, new double[]{145.0, -187.0, 103.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4632L, new GeodeticSrid(4632L, 6378388.0, 297.0, new double[]{-382.0, -59.0, -262.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4633L, new GeodeticSrid(4633L, 6378388.0, 297.0, new double[]{137.092, 131.66, 91.475, -1.9436, -11.5993, -4.3321, -7.4824}, 57.29577951308238, 0.0));
        SRIDS.put(4634L, new GeodeticSrid(4634L, 6378388.0, 297.0, new double[]{97.295, -263.247, 310.882, -1.5999, 0.8386, 3.1409, 13.3259}, 57.29577951308238, 0.0));
        SRIDS.put(4635L, new GeodeticSrid(4635L, 6378388.0, 297.0, new double[]{-122.383, -188.696, 103.344, 3.5107, -4.9668, -5.7047, 4.4798}, 57.29577951308238, 0.0));
        SRIDS.put(4636L, new GeodeticSrid(4636L, 6378388.0, 297.0, new double[]{365.0, 194.0, 166.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4637L, new GeodeticSrid(4637L, 6378388.0, 297.0, new double[]{325.0, 154.0, 172.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4638L, new GeodeticSrid(4638L, 6378206.4, 294.97869821390583, new double[]{30.0, 430.0, 368.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4639L, new GeodeticSrid(4639L, 6378388.0, 297.0, new double[]{252.0, -132.0, -125.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4640L, new GeodeticSrid(4640L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4641L, new GeodeticSrid(4641L, 6378388.0, 297.0, new double[]{-408.809, 366.856, -412.987, 1.8842, -0.5308, 2.1655, -121.0993}, 57.29577951308238, 0.0));
        SRIDS.put(4642L, new GeodeticSrid(4642L, 6378388.0, 297.0, new double[]{244.416, 85.339, 168.114, -8.9353, 7.7523, 12.5953, 14.268}, 57.29577951308238, 0.0));
        SRIDS.put(4643L, new GeodeticSrid(4643L, 6378388.0, 297.0, new double[]{-480.26, -438.32, -643.429, 16.3119, 20.1721, -4.0349, -111.7002}, 57.29577951308238, 0.0));
        SRIDS.put(4644L, new GeodeticSrid(4644L, 6378388.0, 297.0, new double[]{-166.207, -154.777, 254.831, -37.5444, 7.7011, -10.2025, -30.8598}, 57.29577951308238, 0.0));
        SRIDS.put(4645L, new GeodeticSrid(4645L, 6378388.0, 297.0, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4646L, new GeodeticSrid(4646L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4657L, new GeodeticSrid(4657L, 6377019.27, 300.0, new double[]{-28.0, 199.0, 5.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4658L, new GeodeticSrid(4658L, 6378388.0, 297.0, new double[]{-73.0, 46.0, -86.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4659L, new GeodeticSrid(4659L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4660L, new GeodeticSrid(4660L, 6378388.0, 297.0, new double[]{982.6087, 552.753, -540.873, 6.681626625277, -31.611492408642, -19.848161004817, 16.805}, 57.29577951308238, 0.0));
        SRIDS.put(4661L, new GeodeticSrid(4661L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4662L, new GeodeticSrid(4662L, 6378388.0, 297.0, new double[]{97.295, -263.247, 310.882, -1.5999, 0.8386, 3.1409, 13.3259}, 57.29577951308238, 0.0));
        SRIDS.put(4663L, new GeodeticSrid(4663L, 6378388.0, 297.0, new double[]{-502.862, -247.438, 312.724, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4664L, new GeodeticSrid(4664L, 6378388.0, 297.0, new double[]{-204.633, 140.216, 55.199, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4665L, new GeodeticSrid(4665L, 6378388.0, 297.0, new double[]{-106.301, 166.27, -37.916, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4666L, new GeodeticSrid(4666L, 6377397.155, 299.1528128, new double[]{508.088, -191.042, 565.223, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4667L, new GeodeticSrid(4667L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4668L, new GeodeticSrid(4668L, 6378388.0, 297.0, new double[]{-82.981, -99.719, -110.709, -0.104700015651, 0.031001600379, 0.080402021475, -0.3143}, 57.29577951308238, 0.0));
        SRIDS.put(4669L, new GeodeticSrid(4669L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4670L, new GeodeticSrid(4670L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(4671L, new GeodeticSrid(4671L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4672L, new GeodeticSrid(4672L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4673L, new GeodeticSrid(4673L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4674L, new GeodeticSrid(4674L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4675L, new GeodeticSrid(4675L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4676L, new GeodeticSrid(4676L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4677L, new GeodeticSrid(4677L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4678L, new GeodeticSrid(4678L, 6378245.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4679L, new GeodeticSrid(4679L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4680L, new GeodeticSrid(4680L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4681L, new GeodeticSrid(4681L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4682L, new GeodeticSrid(4682L, 6377276.345, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4683L, new GeodeticSrid(4683L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4684L, new GeodeticSrid(4684L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4685L, new GeodeticSrid(4685L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4686L, new GeodeticSrid(4686L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4687L, new GeodeticSrid(4687L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4688L, new GeodeticSrid(4688L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4689L, new GeodeticSrid(4689L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4690L, new GeodeticSrid(4690L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4691L, new GeodeticSrid(4691L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4692L, new GeodeticSrid(4692L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4693L, new GeodeticSrid(4693L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4694L, new GeodeticSrid(4694L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4695L, new GeodeticSrid(4695L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4696L, new GeodeticSrid(4696L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4697L, new GeodeticSrid(4697L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4698L, new GeodeticSrid(4698L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4699L, new GeodeticSrid(4699L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4700L, new GeodeticSrid(4700L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4701L, new GeodeticSrid(4701L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4702L, new GeodeticSrid(4702L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4703L, new GeodeticSrid(4703L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4704L, new GeodeticSrid(4704L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4705L, new GeodeticSrid(4705L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4706L, new GeodeticSrid(4706L, 6378200.0, 298.3, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4707L, new GeodeticSrid(4707L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4708L, new GeodeticSrid(4708L, 6378160.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4709L, new GeodeticSrid(4709L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4710L, new GeodeticSrid(4710L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4711L, new GeodeticSrid(4711L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4712L, new GeodeticSrid(4712L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4713L, new GeodeticSrid(4713L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4714L, new GeodeticSrid(4714L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4715L, new GeodeticSrid(4715L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4716L, new GeodeticSrid(4716L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4717L, new GeodeticSrid(4717L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4718L, new GeodeticSrid(4718L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4719L, new GeodeticSrid(4719L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4720L, new GeodeticSrid(4720L, 6378135.0, 298.26, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4721L, new GeodeticSrid(4721L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4722L, new GeodeticSrid(4722L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4723L, new GeodeticSrid(4723L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4724L, new GeodeticSrid(4724L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4725L, new GeodeticSrid(4725L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4726L, new GeodeticSrid(4726L, 6378206.4, 294.97869821390583, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4727L, new GeodeticSrid(4727L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4728L, new GeodeticSrid(4728L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4729L, new GeodeticSrid(4729L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4730L, new GeodeticSrid(4730L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4731L, new GeodeticSrid(4731L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4732L, new GeodeticSrid(4732L, 6378270.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4733L, new GeodeticSrid(4733L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4734L, new GeodeticSrid(4734L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4735L, new GeodeticSrid(4735L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4736L, new GeodeticSrid(4736L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4737L, new GeodeticSrid(4737L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4738L, new GeodeticSrid(4738L, 6378293.63683822, 294.26067636926103, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4739L, new GeodeticSrid(4739L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4740L, new GeodeticSrid(4740L, 6378136.0, 298.257839303, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4741L, new GeodeticSrid(4741L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4742L, new GeodeticSrid(4742L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4743L, new GeodeticSrid(4743L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4744L, new GeodeticSrid(4744L, 6378249.145, 293.465, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4745L, new GeodeticSrid(4745L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4746L, new GeodeticSrid(4746L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4747L, new GeodeticSrid(4747L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4748L, new GeodeticSrid(4748L, 6378306.3696, 293.46630765562986, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4749L, new GeodeticSrid(4749L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4750L, new GeodeticSrid(4750L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4751L, new GeodeticSrid(4751L, 6377295.664, 300.8017, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4752L, new GeodeticSrid(4752L, 6378306.3696, 293.46630765562986, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4753L, new GeodeticSrid(4753L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4754L, new GeodeticSrid(4754L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4755L, new GeodeticSrid(4755L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4756L, new GeodeticSrid(4756L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4757L, new GeodeticSrid(4757L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4758L, new GeodeticSrid(4758L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4759L, new GeodeticSrid(4759L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4760L, new GeodeticSrid(4760L, 6378145.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4761L, new GeodeticSrid(4761L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4762L, new GeodeticSrid(4762L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4763L, new GeodeticSrid(4763L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4764L, new GeodeticSrid(4764L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4765L, new GeodeticSrid(4765L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4801L, new GeodeticSrid(4801L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.12984522414316135));
        SRIDS.put(4802L, new GeodeticSrid(4802L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, -1.2929559087288747));
        SRIDS.put(4803L, new GeodeticSrid(4803L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, -0.15938182862187986));
        SRIDS.put(4804L, new GeodeticSrid(4804L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 1.8641463708519224));
        SRIDS.put(4805L, new GeodeticSrid(4805L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, -0.30834150118566456));
        SRIDS.put(4806L, new GeodeticSrid(4806L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.217334216222507));
        SRIDS.put(4807L, new GeodeticSrid(4807L, 6378249.2, 293.4660212936294, new double[]{-168.0, -60.0, 320.0, 0.0, 0.0, 0.0, 0.0}, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4808L, new GeodeticSrid(4808L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 1.8641463708519224));
        SRIDS.put(4809L, new GeodeticSrid(4809L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.07623554539479924));
        SRIDS.put(4810L, new GeodeticSrid(4810L, 6378388.0, 297.0, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4811L, new GeodeticSrid(4811L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4813L, new GeodeticSrid(4813L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 1.8641463708519224));
        SRIDS.put(4814L, new GeodeticSrid(4814L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.3151764044619468));
        SRIDS.put(4815L, new GeodeticSrid(4815L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.4139281758892003));
        SRIDS.put(4816L, new GeodeticSrid(4816L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4817L, new GeodeticSrid(4817L, 6377492.018, 299.1528128, TO_WGS84_ID, 57.29577951308238, 0.18715020125030843));
        SRIDS.put(4818L, new GeodeticSrid(4818L, 6377397.155, 299.1528128, new double[]{570.8, 85.7, 462.8, 4.998, 1.587, 5.261, 3.56}, 57.29577951308238, -0.30834150118566456));
        SRIDS.put(4819L, new GeodeticSrid(4819L, 6378249.145, 293.465, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4820L, new GeodeticSrid(4820L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, 1.8641463708519224));
        SRIDS.put(4821L, new GeodeticSrid(4821L, 6378249.2, 293.4660212936294, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4823L, new GeodeticSrid(4823L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4824L, new GeodeticSrid(4824L, 6378388.0, 297.0, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(4901L, new GeodeticSrid(4901L, 6376523.0, 308.64, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4902L, new GeodeticSrid(4902L, 6376523.0, 308.64, TO_WGS84_ID, 63.6619772367582, 0.040792344390154237));
        SRIDS.put(4903L, new GeodeticSrid(4903L, 6378298.3, 294.73, TO_WGS84_ID, 57.29577951308238, -0.06436667622345237));
        SRIDS.put(4904L, new GeodeticSrid(4904L, 6377397.155, 299.1528128, TO_WGS84_ID, 57.29577951308238, -0.15938182862187986));
        SRIDS.put(5013L, new GeodeticSrid(5013L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(5252L, new GeodeticSrid(5252L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(5527L, new GeodeticSrid(5527L, 6378160.0, 298.25, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(7844L, new GeodeticSrid(7844L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(8192L, new GeodeticSrid(8192L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8193L, new GeodeticSrid(8193L, 6378160.0, 298.25, new double[]{-133.0, -48.0, 148.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8194L, new GeodeticSrid(8194L, 6378160.0, 298.25, new double[]{-134.0, -48.0, 149.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8195L, new GeodeticSrid(8195L, 6378249.145, 293.465, new double[]{-162.0, -12.0, 206.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8196L, new GeodeticSrid(8196L, 6378245.0, 298.3, new double[]{-43.0, -163.0, 45.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8197L, new GeodeticSrid(8197L, 6378388.0, 297.0, new double[]{-150.0, -251.0, -2.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8198L, new GeodeticSrid(8198L, 6378160.0, 298.25, new double[]{-491.0, -22.0, 435.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8199L, new GeodeticSrid(8199L, 6378249.145326, 293.4663076, new double[]{-143.0, -90.0, -294.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8200L, new GeodeticSrid(8200L, 6378249.145, 293.465, new double[]{-160.0, -8.0, -300.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8201L, new GeodeticSrid(8201L, 6378388.0, 297.0, new double[]{-207.0, 107.0, 52.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8202L, new GeodeticSrid(8202L, 6378388.0, 297.0, new double[]{114.0, -116.0, -333.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8203L, new GeodeticSrid(8203L, 6378388.0, 297.0, new double[]{145.0, 75.0, -272.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8204L, new GeodeticSrid(8204L, 6378388.0, 297.0, new double[]{-320.0, 550.0, -494.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8205L, new GeodeticSrid(8205L, 6378388.0, 297.0, new double[]{124.0, -234.0, -25.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8206L, new GeodeticSrid(8206L, 6378388.0, 297.0, new double[]{81.0, 120.0, 129.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8207L, new GeodeticSrid(8207L, 6378388.0, 297.0, new double[]{-127.0, -769.0, 472.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8208L, new GeodeticSrid(8208L, 6378206.4, 294.9786982, new double[]{-73.0, 213.0, 296.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8209L, new GeodeticSrid(8209L, 6378388.0, 297.0, new double[]{307.0, 304.0, -318.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8210L, new GeodeticSrid(8210L, 6377397.155, 299.1528128, new double[]{660.077, 13.551, 369.344, 0.804816, 0.577692, 0.952236, 5.66}, 57.29577951308238, 0.0));
        SRIDS.put(8211L, new GeodeticSrid(8211L, 6378388.0, 297.0, new double[]{-148.0, 136.0, 90.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8212L, new GeodeticSrid(8212L, 6378388.0, 297.0, new double[]{298.0, -304.0, -375.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8213L, new GeodeticSrid(8213L, 6378206.4, 294.9786982, new double[]{-2.0, 150.0, 181.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8214L, new GeodeticSrid(8214L, 6378249.145, 293.465, new double[]{-136.0, -108.0, -292.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8215L, new GeodeticSrid(8215L, 6378249.145, 293.465, new double[]{-263.0, 6.0, 431.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8216L, new GeodeticSrid(8216L, 6378388.0, 297.0, new double[]{175.0, -38.0, 113.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8217L, new GeodeticSrid(8217L, 6378388.0, 297.0, new double[]{-134.0, 229.0, -29.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8218L, new GeodeticSrid(8218L, 6378388.0, 297.0, new double[]{-206.0, 172.0, -6.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8219L, new GeodeticSrid(8219L, 6378388.0, 297.0, new double[]{-223.0, 110.0, 37.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8221L, new GeodeticSrid(8221L, 6378388.0, 297.0, new double[]{-303.0, -62.0, 105.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8222L, new GeodeticSrid(8222L, 6378388.0, 297.0, new double[]{230.0, -199.0, -752.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8223L, new GeodeticSrid(8223L, 6378388.0, 297.0, new double[]{-87.0, -98.0, -121.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8224L, new GeodeticSrid(8224L, 6378388.0, 297.0, new double[]{-86.0, -98.0, -119.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8225L, new GeodeticSrid(8225L, 6378388.0, 297.0, new double[]{-83.0, -96.0, -113.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8226L, new GeodeticSrid(8226L, 6378388.0, 297.0, new double[]{211.0, 147.0, 111.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8227L, new GeodeticSrid(8227L, 6378388.0, 297.0, new double[]{252.0, -209.0, -751.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8228L, new GeodeticSrid(8228L, 6378388.0, 297.0, new double[]{-133.0, -321.0, 50.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8229L, new GeodeticSrid(8229L, 6378388.0, 297.0, new double[]{84.0, -22.0, 209.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8230L, new GeodeticSrid(8230L, 6378206.4, 294.9786982, new double[]{-100.0, -248.0, 259.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8231L, new GeodeticSrid(8231L, 6378388.0, 297.0, new double[]{16.0, 196.0, 93.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8232L, new GeodeticSrid(8232L, 6378388.0, 297.0, new double[]{-156.0, -271.0, -189.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8233L, new GeodeticSrid(8233L, 6378388.0, 297.0, new double[]{-634.0, -549.0, -201.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8234L, new GeodeticSrid(8234L, 6378388.0, 297.0, new double[]{208.0, -435.0, -229.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8235L, new GeodeticSrid(8235L, 6377276.345, 300.8017, new double[]{289.0, 734.0, 257.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8236L, new GeodeticSrid(8236L, 6377276.345, 300.8017, new double[]{214.0, 836.0, 303.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8237L, new GeodeticSrid(8237L, 6377340.189, 299.3249646, new double[]{506.0, -122.0, 611.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8238L, new GeodeticSrid(8238L, 6378388.0, 297.0, new double[]{191.0, -77.0, -204.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8239L, new GeodeticSrid(8239L, 6377276.345, 300.8017, new double[]{-97.0, 787.0, 86.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8240L, new GeodeticSrid(8240L, 6378388.0, 297.0, new double[]{145.0, -187.0, 103.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8241L, new GeodeticSrid(8241L, 6377304.063, 300.8017, new double[]{-11.0, 851.0, 5.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8242L, new GeodeticSrid(8242L, 6378206.4, 294.9786982, new double[]{42.0, 124.0, 147.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8243L, new GeodeticSrid(8243L, 6378249.145, 293.465, new double[]{-90.0, 40.0, 88.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8244L, new GeodeticSrid(8244L, 6378388.0, 297.0, new double[]{-303.0, -62.0, 105.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8245L, new GeodeticSrid(8245L, 6378206.4, 294.9786982, new double[]{-133.0, -79.0, -72.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8246L, new GeodeticSrid(8246L, 6378206.4, 294.9786982, new double[]{-133.0, -77.0, -51.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8247L, new GeodeticSrid(8247L, 6378249.145, 293.465, new double[]{41.0, -220.0, -134.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8248L, new GeodeticSrid(8248L, 6378388.0, 297.0, new double[]{-289.0, -124.0, 60.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8249L, new GeodeticSrid(8249L, 6377397.155, 299.1528128, new double[]{639.0, 405.0, 60.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8250L, new GeodeticSrid(8250L, 6378388.0, 297.0, new double[]{-223.0, 110.0, 37.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8251L, new GeodeticSrid(8251L, 6378249.2, 293.46598, new double[]{31.0, 146.0, 47.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8252L, new GeodeticSrid(8252L, 6378388.0, 297.0, new double[]{912.0, -58.0, 1227.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8253L, new GeodeticSrid(8253L, 6378249.145, 293.465, new double[]{-92.0, -93.0, 122.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8254L, new GeodeticSrid(8254L, 6378206.4, 294.9786982, new double[]{-5.0, 135.0, 172.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8255L, new GeodeticSrid(8255L, 6378206.4, 294.9786982, new double[]{-4.0, 154.0, 178.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8256L, new GeodeticSrid(8256L, 6378206.4, 294.9786982, new double[]{-10.0, 158.0, 187.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8257L, new GeodeticSrid(8257L, 6378206.4, 294.9786982, new double[]{0.0, 125.0, 201.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8258L, new GeodeticSrid(8258L, 6378206.4, 294.9786982, new double[]{-7.0, 152.0, 178.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8259L, new GeodeticSrid(8259L, 6378206.4, 294.9786982, new double[]{0.0, 125.0, 194.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8260L, new GeodeticSrid(8260L, 6378206.4, 294.9786982, new double[]{-8.0, 160.0, 176.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8261L, new GeodeticSrid(8261L, 6378206.4, 294.9786982, new double[]{-9.0, 152.0, 178.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8262L, new GeodeticSrid(8262L, 6378206.4, 294.9786982, new double[]{11.0, 114.0, 195.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8263L, new GeodeticSrid(8263L, 6378206.4, 294.9786982, new double[]{0.0, 125.0, 194.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8264L, new GeodeticSrid(8264L, 6378206.4, 294.9786982, new double[]{1.0, 140.0, 165.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8265L, new GeodeticSrid(8265L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8266L, new GeodeticSrid(8266L, 6378249.2, 293.4660213, new double[]{-168.0, -60.0, 320.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8267L, new GeodeticSrid(8267L, 6378249.2, 293.4660213, new double[]{-168.0, -60.0, 320.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.040792344390154237));
        SRIDS.put(8268L, new GeodeticSrid(8268L, 6378135.0, 298.26, new double[]{-1.0, 15.0, 1.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8269L, new GeodeticSrid(8269L, 6378249.145, 293.465, new double[]{-247.0, -148.0, 369.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8270L, new GeodeticSrid(8270L, 6378249.145, 293.465, new double[]{-231.0, -196.0, 482.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8271L, new GeodeticSrid(8271L, 6378249.145, 293.465, new double[]{-249.0, -156.0, 381.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8272L, new GeodeticSrid(8272L, 6378388.0, 297.0, new double[]{-2.0, 374.0, 172.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8273L, new GeodeticSrid(8273L, 6377397.155, 299.1528128, new double[]{593.0, 26.0, 478.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8274L, new GeodeticSrid(8274L, 6377563.396, 299.3249646, new double[]{375.0, -111.0, 431.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8275L, new GeodeticSrid(8275L, 6378388.0, 297.0, new double[]{-425.0, -169.0, 81.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8276L, new GeodeticSrid(8276L, 6378200.0, 298.3, new double[]{-130.0, 110.0, -13.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8277L, new GeodeticSrid(8277L, 6378206.4, 294.9786982, new double[]{61.0, -285.0, -181.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8278L, new GeodeticSrid(8278L, 6378249.145, 293.465, new double[]{-346.0, -1.0, 224.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8279L, new GeodeticSrid(8279L, 6378388.0, 297.0, new double[]{-307.0, -92.0, 127.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8280L, new GeodeticSrid(8280L, 6378388.0, 297.0, new double[]{185.0, 165.0, 42.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8282L, new GeodeticSrid(8282L, 6378388.0, 297.0, new double[]{-288.0, 175.0, -376.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8283L, new GeodeticSrid(8283L, 6378388.0, 297.0, new double[]{16.0, 196.0, 93.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8284L, new GeodeticSrid(8284L, 6378206.4, 294.9786982, new double[]{11.0, 72.0, -101.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8285L, new GeodeticSrid(8285L, 6378245.0, 298.3, new double[]{24.0, -123.0, -94.0, -0.02, 0.25, 0.13, 1.1}, 57.29577951308238, 0.0));
        SRIDS.put(8286L, new GeodeticSrid(8286L, 6378388.0, 297.0, new double[]{-128.0, -283.0, 22.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8287L, new GeodeticSrid(8287L, 6378388.0, 297.0, new double[]{164.0, 138.0, -189.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8288L, new GeodeticSrid(8288L, 6377397.155, 299.1528128, new double[]{498.0, -36.0, 568.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8290L, new GeodeticSrid(8290L, 6378388.0, 297.0, new double[]{94.0, -948.0, -1262.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8291L, new GeodeticSrid(8291L, 6378388.0, 297.0, new double[]{-225.0, -65.0, 9.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8292L, new GeodeticSrid(8292L, 6378160.0, 298.25, new double[]{-57.0, 1.0, -41.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8293L, new GeodeticSrid(8293L, 6378388.0, 297.0, new double[]{170.0, 42.0, 84.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8294L, new GeodeticSrid(8294L, 6378388.0, 297.0, new double[]{-203.0, 141.0, 53.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8295L, new GeodeticSrid(8295L, 6378388.0, 297.0, new double[]{-355.0, 16.0, 74.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8296L, new GeodeticSrid(8296L, 6377483.865, 299.1528128, new double[]{616.0, 97.0, -251.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8297L, new GeodeticSrid(8297L, 6378155.0, 298.3, new double[]{7.0, -10.0, -26.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8298L, new GeodeticSrid(8298L, 6378388.0, 297.0, new double[]{-499.0, -249.0, 314.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8299L, new GeodeticSrid(8299L, 6378388.0, 297.0, new double[]{-104.0, 167.0, -38.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8300L, new GeodeticSrid(8300L, 6377276.345, 300.8017, new double[]{-689.0, 691.0, -46.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8301L, new GeodeticSrid(8301L, 6377397.155, 299.1528128, new double[]{-128.0, 481.0, 664.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8302L, new GeodeticSrid(8302L, 6378388.0, 297.0, new double[]{-632.0, 438.0, -609.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8303L, new GeodeticSrid(8303L, 6378249.145, 293.465, new double[]{51.0, 391.0, -36.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8304L, new GeodeticSrid(8304L, 6378165.0, 298.3, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8305L, new GeodeticSrid(8305L, 6378145.0, 298.25, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8306L, new GeodeticSrid(8306L, 6378135.0, 298.26, new double[]{0.0, 0.0, 4.5, 0.0, 0.0, 0.554, 0.2263}, 57.29577951308238, 0.0));
        SRIDS.put(8307L, new GeodeticSrid(8307L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8308L, new GeodeticSrid(8308L, 6378270.0, 297.0, new double[]{101.0, 52.0, -39.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8309L, new GeodeticSrid(8309L, 6378388.0, 297.0, new double[]{-155.0, 171.0, 37.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8310L, new GeodeticSrid(8310L, 6378388.0, 297.0, new double[]{-265.0, 120.0, -358.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(8311L, new GeodeticSrid(8311L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(8312L, new GeodeticSrid(8312L, 6378160.0, 298.25, new double[]{-129.19, -41.21, 130.73, -0.25, -0.37, -0.33, -2.96}, 57.29577951308238, 0.0));
        SRIDS.put(8313L, new GeodeticSrid(8313L, 6378160.0, 298.25, new double[]{-120.27, -64.54, 161.63, -0.22, -0.07, 0.13, 2.5}, 57.29577951308238, 0.0));
        SRIDS.put(8314L, new GeodeticSrid(8314L, 6378160.0, 298.25, new double[]{-119.35, -48.3, 139.48, -0.42, -0.26, -0.44, -0.61}, 57.29577951308238, 0.0));
        SRIDS.put(8315L, new GeodeticSrid(8315L, 6378160.0, 298.25, new double[]{-124.13, -42.0, 137.4, 0.01, -0.56, -0.18, -1.85}, 57.29577951308238, 0.0));
        SRIDS.put(8316L, new GeodeticSrid(8316L, 6378160.0, 298.25, new double[]{-117.76, -51.51, 139.06, -0.29, -0.44, -0.28, -0.19}, 57.29577951308238, 0.0));
        SRIDS.put(8320L, new GeodeticSrid(8320L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(8330L, new GeodeticSrid(8330L, 6378388.0, 297.0, new double[]{-81.0703, -89.3603, -115.7526, 0.48488, 0.02436, 0.41321, -0.540645}, 57.29577951308238, 0.0));
        SRIDS.put(524288L, new GeodeticSrid(524288L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(530040L, new GeodeticSrid(530040L, 6371000.0, 1.0E12, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(1000002L, new GeodeticSrid(1000002L, 6370040.0, 1.0E12, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2000001L, new GeodeticSrid(2000001L, 3390592.987983, 1.0E12, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2000002L, new GeodeticSrid(2000002L, 6378137.0, 298.257223563, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000003L, new GeodeticSrid(2000003L, 6377397.155, 299.1528128, new double[]{-128.0, 481.0, 664.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000004L, new GeodeticSrid(2000004L, 6378160.0, 298.25, new double[]{-57.0, 1.0, -41.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000005L, new GeodeticSrid(2000005L, 6378245.0, 298.3, new double[]{24.0, -123.0, -94.0, -0.02, 0.25, 0.13, 1.1}, 57.29577951308238, 0.0));
        SRIDS.put(2000006L, new GeodeticSrid(2000006L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2000007L, new GeodeticSrid(2000007L, 6378206.4, 294.9786982, new double[]{-8.0, 160.0, 176.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000008L, new GeodeticSrid(2000008L, 6378249.2, 293.4660213, new double[]{-168.0, -60.0, 320.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.040792344390154237));
        SRIDS.put(2000009L, new GeodeticSrid(2000009L, 6378450.047484481, 294.9786982, new double[]{-8.0, 160.0, 176.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000010L, new GeodeticSrid(2000010L, 6378206.4, 294.9786982, new double[]{-10.0, 158.0, 187.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000011L, new GeodeticSrid(2000011L, 6378206.4, 294.9786982, new double[]{-5.0, 135.0, 172.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000012L, new GeodeticSrid(2000012L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2000013L, new GeodeticSrid(2000013L, 6378388.0, 297.0, new double[]{84.0, -22.0, 209.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000014L, new GeodeticSrid(2000014L, 6378388.0, 297.0, new double[]{-87.0, -98.0, -121.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000015L, new GeodeticSrid(2000015L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2000016L, new GeodeticSrid(2000016L, 6378388.0, 297.0, new double[]{-206.0, 172.0, -6.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000017L, new GeodeticSrid(2000017L, 6378160.0, 298.25, new double[]{-134.0, -48.0, 149.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000018L, new GeodeticSrid(2000018L, 6378160.0, 298.25, new double[]{-133.0, -48.0, 148.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000019L, new GeodeticSrid(2000019L, 6378388.0, 297.0, new double[]{-225.0, -65.0, 9.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000020L, new GeodeticSrid(2000020L, 6377397.155, 299.1528128, new double[]{498.0, -36.0, 568.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000021L, new GeodeticSrid(2000021L, 6377563.396, 299.3249646, new double[]{375.0, -111.0, 431.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000022L, new GeodeticSrid(2000022L, 6377397.155, 299.1528128, new double[]{593.0, 26.0, 478.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000023L, new GeodeticSrid(2000023L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000024L, new GeodeticSrid(2000024L, 6378388.0, 297.0, new double[]{-223.0, 110.0, 37.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000025L, new GeodeticSrid(2000025L, 6378388.0, 297.0, new double[]{-303.0, -62.0, 105.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000027L, new GeodeticSrid(2000027L, 6378388.0, 297.0, new double[]{-81.0703, -89.3603, -115.7526, 0.48488, 0.02436, 0.41321, -0.540645}, 57.29577951308238, 0.0));
        SRIDS.put(2000028L, new GeodeticSrid(2000028L, 6378137.0, 298.257222101, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2000029L, new GeodeticSrid(2000029L, 6377397.155, 299.1528128, new double[]{660.077, 13.551, 369.344, 0.804816, 0.577692, 0.952236, 5.66}, 57.29577951308238, 0.0));
        SRIDS.put(2000030L, new GeodeticSrid(2000030L, 6378388.0, 297.0, new double[]{81.0, 120.0, 129.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000031L, new GeodeticSrid(2000031L, 6378388.0, 297.0, new double[]{-207.0, 107.0, 52.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000067L, new GeodeticSrid(2000067L, 6378160.0, 298.25, new double[]{-133.0, -48.0, 148.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(2000097L, new GeodeticSrid(2000097L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(2004326L, new GeodeticSrid(2004326L, 6378137.0, 298.257223563, TO_WGS84_ID, 57.29577951308238, 0.0));
        SRIDS.put(3000103L, new GeodeticSrid(3000103L, 6378137.0, 298.257222101, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 57.29577951308238, 0.0));
        SRIDS.put(3000113L, new GeodeticSrid(3000113L, 6378245.0, 298.3, new double[]{-40.595, -18.55, -69.339, 2.507974, 1.831879, -2.611436, -4.2991}, 57.29577951308238, 0.0));
        SRIDS.put(4100000L, new GeodeticSrid(4100000L, 6377397.155, 299.1528128, new double[]{-473.862, -124.587, -413.576, 4.730807, 2.380796, -11.786482, -10.645117}, 57.29577951308238, 0.0));
    }

    private static void loadTransverseMercatorSRIDs() {
        CoordRefSys.loadTransverseMercatorSRIDs1();
        CoordRefSys.loadTransverseMercatorSRIDs2();
        CoordRefSys.loadTransverseMercatorSRIDs3();
        CoordRefSys.loadTransverseMercatorSRIDs4();
    }

    private static void loadLambertConformalConicSRIDs() {
        LambertConformalConicSrid.registerLambertConformalConicSrid(2138L, 4609L, 1.0, 0.0, 0.0, 0.7679448708775042, -1.1955505376161146, 1.0471975511965967, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2154L, 4171L, 1.0, 700000.0, 6600000.0, 0.8115781021773624, 0.052359877559829834, 0.8552113334772206, 0.7679448708775042);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2204L, 4267L, 3.2808333333333333, 609601.2192024384, 30480.06096012192, 0.6050474740247003, -1.500983156715122, 0.6152285613280005, 0.635590735934601);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2205L, 4269L, 1.0, 500000.0, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2225L, 4269L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2226L, 4269L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2227L, 4269L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2228L, 4269L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2229L, 4269L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2230L, 4269L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2231L, 4269L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6864961724511023, -1.841322360854016, 0.71180344660502, 0.6931866012504139);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2232L, 4269L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2233L, 4269L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2234L, 4269L, 3.2808333333333333, 304800.6096012192, 152400.3048006096, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2238L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2246L, 4269L, 3.2808333333333333, 500000.0001016002, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2247L, 4269L, 3.2808333333333333, 500000.0001016002, 500000.0001016002, 0.6341362948912724, -1.4966198335851362, 0.6620615629231816, 0.6411176118992498);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2248L, 4269L, 3.2808333333333333, 399999.9998983998, 0.0, 0.6574073515845301, -1.3439035240356323, 0.6885323899117624, 0.6684611035138276);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2249L, 4269L, 3.2808333333333333, 200000.0001016002, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7449647023929122, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2250L, 4269L, 3.2808333333333333, 500000.0001016002, 0.0, 0.7155849933176743, -1.230457122656001, 0.7240207513689803, 0.7205300928649917);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2251L, 4269L, 3.2808398950131235, 7999999.999968, 0.0, 0.7816166166847931, -1.5184364492350653, 0.8217591894806626, 0.7938339214487534);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2252L, 4269L, 3.2808398950131235, 5999999.999976, 0.0, 0.7560184543222096, -1.4724761122658812, 0.7976154681614078, 0.7711446411728271);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2253L, 4269L, 3.2808398950131235, 3999999.999984, 0.0, 0.724311639577646, -1.4724761122658812, 0.7621271067041898, 0.734783615089612);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2256L, 4269L, 3.2808398950131235, 599999.9999976, 0.0, 0.7723081940074901, -1.911135530933789, 0.8552113334772206, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2263L, 4269L, 3.2808333333333333, 300000.0, 0.0, 0.7010405828843883, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2264L, 4269L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2265L, 4269L, 3.2808398950131235, 599999.9999976, 0.0, 0.820304748437334, -1.7540558982542993, 0.850557122138569, 0.8278678418626428);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2266L, 4269L, 3.2808398950131235, 599999.9999976, 0.0, 0.7970336917440763, -1.7540558982542993, 0.82874050648864, 0.8060512262127137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2267L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6416993883165811, 0.6207554372926493);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2268L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.5817764173314426, -1.7104226669544411, 0.6149376731193348, 0.5922483928434086);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2269L, 4269L, 3.2808398950131235, 2500000.0001424, 0.0, 0.7621271067041898, -2.103121748653165, 0.8028514559173908, 0.7737626350508187);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2270L, 4269L, 3.2808398950131235, 1500000.0001464, 0.0, 0.7272205216643033, -2.103121748653165, 0.7679448708775042, 0.7388560500109321);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2271L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7321656212116205, 0.7135487758570144);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2272L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2273L, 4269L, 3.2808398950131235, 609600.0, 0.0, 0.5555964785515277, -1.4137166941154056, 0.6079563561113575, 0.5672320068981566);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2274L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.5992297098513859, -1.500983156715122, 0.635590735934601, 0.6152285613280005);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2275L, 4269L, 3.2808333333333333, 200000.0001016002, 999999.9998983998, 0.5934119456780714, -1.7715091907742426, 0.6315183010132809, 0.6047565858160345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2276L, 4269L, 3.2808333333333333, 600000.0, 2000000.0001016003, 0.5526875964648704, -1.7191493132144129, 0.59283016926074, 0.5608324663075107);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2277L, 4269L, 3.2808333333333333, 699999.9998983998, 3000000.0, 0.5177810114249839, -1.7511470161676421, 0.5564691431775248, 0.5256349930589583);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2278L, 4269L, 3.2808333333333333, 600000.0, 3999999.9998983997, 0.48578330847175455, -1.7278759594743844, 0.5285438751456156, 0.4953826193577234);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2279L, 4269L, 3.2808333333333333, 300000.0, 5000000.0001016, 0.4479678413452108, -1.7191493132144129, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2280L, 4269L, 3.2808398950131235, 500000.0001504, 999999.999996, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2281L, 4269L, 3.2808398950131235, 500000.0001504, 1999999.999992, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2282L, 4269L, 3.2808398950131235, 500000.0001504, 2999999.999988, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2283L, 4269L, 3.2808333333333333, 3500000.0001016003, 2000000.0001016003, 0.6574073515845301, -1.3700834628155474, 0.6841690667817765, 0.663806892175176);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2284L, 4269L, 3.2808333333333333, 3500000.0001016003, 999999.9998983998, 0.6341362948912724, -1.3700834628155474, 0.6626433393405131, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2285L, 4269L, 3.2808333333333333, 500000.0001016002, 0.0, 0.820304748437334, -2.1089395128264794, 0.850557122138569, 0.8290313946973057);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2286L, 4269L, 3.2808333333333333, 500000.0001016002, 0.0, 0.791215927570762, -2.103121748653165, 0.8261225126106485, 0.7999425738307335);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2287L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.7883070454841047, -1.570796326794895, 0.816232313516014, 0.795288362492082);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2288L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.765035988790847, -1.570796326794895, 0.7941248096574192, 0.7723081940074901);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2289L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7691084237121671, 0.7458373670189095);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2317L, 4248L, 1.0, 1000000.0, 1000000.0, 0.10471975511965967, -1.1519173063162564, 0.1570796326794895, 0.052359877559829834);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2318L, 4204L, 1.0, 0.0, 0.0, 0.43789455721204207, 0.8377580409572774, 0.2967059728390357, 0.5759586531581282);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2764L, 4152L, 1.0, 400000.0, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2765L, 4152L, 1.0, 400000.0, 400000.0, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2766L, 4152L, 1.0, 2000000.0, 500000.0, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2767L, 4152L, 1.0, 2000000.0, 500000.0, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2768L, 4152L, 1.0, 2000000.0, 500000.0, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2769L, 4152L, 1.0, 2000000.0, 500000.0, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2770L, 4152L, 1.0, 2000000.0, 500000.0, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2771L, 4152L, 1.0, 2000000.0, 500000.0, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2772L, 4152L, 1.0, 914401.8289, 304800.6096, 0.6864961724511023, -1.841322360854016, 0.71180344660502, 0.6931866012504139);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2773L, 4152L, 1.0, 914401.8289, 304800.6096, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2774L, 4152L, 1.0, 914401.8289, 304800.6096, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2775L, 4152L, 1.0, 304800.6096, 152400.3048, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2779L, 4152L, 1.0, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2794L, 4152L, 1.0, 1500000.0, 1000000.0, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2795L, 4152L, 1.0, 500000.0, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2796L, 4152L, 1.0, 400000.0, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2797L, 4152L, 1.0, 400000.0, 400000.0, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2798L, 4152L, 1.0, 500000.0, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2799L, 4152L, 1.0, 500000.0, 500000.0, 0.6341362948912724, -1.4966198335851362, 0.6620615629231816, 0.6411176118992498);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2800L, 4152L, 1.0, 1000000.0, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5701408889848137, 0.5439609502048989);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2801L, 4152L, 1.0, 1000000.0, 0.0, 0.4974188368183834, -1.5940673834881527, 0.5358160803622586, 0.511381470834338);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2804L, 4152L, 1.0, 400000.0, 0.0, 0.6574073515845301, -1.3439035240356323, 0.6885323899117624, 0.6684611035138276);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2805L, 4152L, 1.0, 200000.0, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7449647023929122, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2806L, 4152L, 1.0, 500000.0, 0.0, 0.7155849933176743, -1.230457122656001, 0.7240207513689803, 0.7205300928649917);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2807L, 4152L, 1.0, 8000000.0, 0.0, 0.7816166166847931, -1.5184364492350653, 0.8217591894806626, 0.7938339214487534);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2808L, 4152L, 1.0, 6000000.0, 0.0, 0.7560184543222096, -1.4724761122658812, 0.7976154681614078, 0.7711446411728271);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2809L, 4152L, 1.0, 4000000.0, 0.0, 0.724311639577646, -1.4724761122658812, 0.7621271067041898, 0.734783615089612);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2810L, 4152L, 1.0, 800000.0, 100000.0, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2811L, 4152L, 1.0, 800000.0, 100000.0, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2812L, 4152L, 1.0, 800000.0, 100000.0, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2818L, 4152L, 1.0, 600000.0, 0.0, 0.7723081940074901, -1.911135530933789, 0.8552113334772206, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2819L, 4152L, 1.0, 500000.0, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2831L, 4152L, 1.0, 300000.0, 0.0, 0.7010405828843883, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2832L, 4152L, 1.0, 600000.0, 0.0, 0.820304748437334, -1.7540558982542993, 0.850557122138569, 0.8278678418626428);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2833L, 4152L, 1.0, 600000.0, 0.0, 0.7970336917440763, -1.7540558982542993, 0.82874050648864, 0.8060512262127137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2834L, 4152L, 1.0, 600000.0, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7278022980816347, 0.7056947942230398);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2835L, 4152L, 1.0, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6987134772150626, 0.6760241969391363);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2836L, 4152L, 1.0, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6416993883165811, 0.6207554372926493);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2837L, 4152L, 1.0, 600000.0, 0.0, 0.5817764173314426, -1.7104226669544411, 0.6149376731193348, 0.5922483928434086);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2838L, 4152L, 1.0, 2500000.0, 0.0, 0.7621271067041898, -2.103121748653165, 0.8028514559173908, 0.7737626350508187);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2839L, 4152L, 1.0, 1500000.0, 0.0, 0.7272205216643033, -2.103121748653165, 0.7679448708775042, 0.7388560500109321);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2841L, 4152L, 1.0, 600000.0, 0.0, 0.765035988790847, -1.7453292519943278, 0.7973245799527421, 0.7752170760941473);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2842L, 4152L, 1.0, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2843L, 4152L, 1.0, 600000.0, 0.0, 0.5992297098513859, -1.500983156715122, 0.635590735934601, 0.6152285613280005);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2844L, 4152L, 1.0, 200000.0, 1000000.0, 0.5934119456780714, -1.7715091907742426, 0.6315183010132809, 0.6047565858160345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2845L, 4152L, 1.0, 600000.0, 2000000.0, 0.5526875964648704, -1.7191493132144129, 0.59283016926074, 0.5608324663075107);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2846L, 4152L, 1.0, 700000.0, 3000000.0, 0.5177810114249839, -1.7511470161676421, 0.5564691431775248, 0.5256349930589583);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2847L, 4152L, 1.0, 600000.0, 4000000.0, 0.48578330847175455, -1.7278759594743844, 0.5285438751456156, 0.4953826193577234);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2848L, 4152L, 1.0, 300000.0, 5000000.0, 0.4479678413452108, -1.7191493132144129, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2849L, 4152L, 1.0, 500000.0, 1000000.0, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2850L, 4152L, 1.0, 500000.0, 2000000.0, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2851L, 4152L, 1.0, 500000.0, 3000000.0, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2853L, 4152L, 1.0, 3500000.0, 2000000.0, 0.6574073515845301, -1.3700834628155474, 0.6841690667817765, 0.663806892175176);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2854L, 4152L, 1.0, 3500000.0, 1000000.0, 0.6341362948912724, -1.3700834628155474, 0.6626433393405131, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2855L, 4152L, 1.0, 500000.0, 0.0, 0.820304748437334, -2.1089395128264794, 0.850557122138569, 0.8290313946973057);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2856L, 4152L, 1.0, 500000.0, 0.0, 0.791215927570762, -2.103121748653165, 0.8261225126106485, 0.7999425738307335);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2857L, 4152L, 1.0, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2858L, 4152L, 1.0, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2859L, 4152L, 1.0, 600000.0, 0.0, 0.7883070454841047, -1.570796326794895, 0.816232313516014, 0.795288362492082);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2860L, 4152L, 1.0, 600000.0, 0.0, 0.765035988790847, -1.570796326794895, 0.7941248096574192, 0.7723081940074901);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2861L, 4152L, 1.0, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7691084237121671, 0.7458373670189095);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2866L, 4152L, 1.0, 200000.0, 200000.0, 0.3112503832723218, -1.159480399741565, 0.32172235878428773, 0.31474104177631046);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2870L, 4152L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2871L, 4152L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2872L, 4152L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2873L, 4152L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2874L, 4152L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2875L, 4152L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2876L, 4152L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6864961724511023, -1.841322360854016, 0.71180344660502, 0.6931866012504139);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2877L, 4152L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2878L, 4152L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2879L, 4152L, 3.2808333333333333, 304800.6096012192, 152400.3048006096, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2883L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2891L, 4152L, 3.2808333333333333, 500000.0001016002, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2892L, 4152L, 3.2808333333333333, 500000.0001016002, 500000.0001016002, 0.6341362948912724, -1.4966198335851362, 0.6620615629231816, 0.6411176118992498);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2893L, 4152L, 3.2808333333333333, 399999.9998983998, 0.0, 0.6574073515845301, -1.3439035240356323, 0.6885323899117624, 0.6684611035138276);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2894L, 4152L, 3.2808333333333333, 200000.0001016002, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7449647023929122, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2895L, 4152L, 3.2808333333333333, 500000.0001016002, 0.0, 0.7155849933176743, -1.230457122656001, 0.7240207513689803, 0.7205300928649917);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2896L, 4152L, 3.2808398950131235, 7999999.999968, 0.0, 0.7816166166847931, -1.5184364492350653, 0.8217591894806626, 0.7938339214487534);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2897L, 4152L, 3.2808398950131235, 5999999.999976, 0.0, 0.7560184543222096, -1.4724761122658812, 0.7976154681614078, 0.7711446411728271);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2898L, 4152L, 3.2808398950131235, 3999999.999984, 0.0, 0.724311639577646, -1.4724761122658812, 0.7621271067041898, 0.734783615089612);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2901L, 4152L, 3.2808398950131235, 599999.9999976, 0.0, 0.7723081940074901, -1.911135530933789, 0.8552113334772206, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2908L, 4152L, 3.2808333333333333, 300000.0, 0.0, 0.7010405828843883, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2909L, 4152L, 3.2808398950131235, 599999.9999976, 0.0, 0.820304748437334, -1.7540558982542993, 0.850557122138569, 0.8278678418626428);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2910L, 4152L, 3.2808398950131235, 599999.9999976, 0.0, 0.7970336917440763, -1.7540558982542993, 0.82874050648864, 0.8060512262127137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2911L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6416993883165811, 0.6207554372926493);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2912L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.5817764173314426, -1.7104226669544411, 0.6149376731193348, 0.5922483928434086);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2913L, 4152L, 3.2808398950131235, 2500000.0001424, 0.0, 0.7621271067041898, -2.103121748653165, 0.8028514559173908, 0.7737626350508187);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2914L, 4152L, 3.2808398950131235, 1500000.0001464, 0.0, 0.7272205216643033, -2.103121748653165, 0.7679448708775042, 0.7388560500109321);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2915L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.5992297098513859, -1.500983156715122, 0.635590735934601, 0.6152285613280005);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2916L, 4152L, 3.2808333333333333, 200000.0001016002, 999999.9998983998, 0.5934119456780714, -1.7715091907742426, 0.6315183010132809, 0.6047565858160345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2917L, 4152L, 3.2808333333333333, 600000.0, 2000000.0001016003, 0.5526875964648704, -1.7191493132144129, 0.59283016926074, 0.5608324663075107);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2918L, 4152L, 3.2808333333333333, 699999.9998983998, 3000000.0, 0.5177810114249839, -1.7511470161676421, 0.5564691431775248, 0.5256349930589583);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2919L, 4152L, 3.2808333333333333, 600000.0, 3999999.9998983997, 0.48578330847175455, -1.7278759594743844, 0.5285438751456156, 0.4953826193577234);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2920L, 4152L, 3.2808333333333333, 300000.0, 5000000.0001016, 0.4479678413452108, -1.7191493132144129, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2921L, 4152L, 3.2808398950131235, 500000.0001504, 999999.999996, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2922L, 4152L, 3.2808398950131235, 500000.0001504, 1999999.999992, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2923L, 4152L, 3.2808398950131235, 500000.0001504, 2999999.999988, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2924L, 4152L, 3.2808333333333333, 3500000.0001016003, 2000000.0001016003, 0.6574073515845301, -1.3700834628155474, 0.6841690667817765, 0.663806892175176);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2925L, 4152L, 3.2808333333333333, 3500000.0001016003, 999999.9998983998, 0.6341362948912724, -1.3700834628155474, 0.6626433393405131, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2926L, 4152L, 3.2808333333333333, 500000.0001016002, 0.0, 0.820304748437334, -2.1089395128264794, 0.850557122138569, 0.8290313946973057);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2927L, 4152L, 3.2808333333333333, 500000.0001016002, 0.0, 0.791215927570762, -2.103121748653165, 0.8261225126106485, 0.7999425738307335);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2928L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.7883070454841047, -1.570796326794895, 0.816232313516014, 0.795288362492082);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2929L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.765035988790847, -1.570796326794895, 0.7941248096574192, 0.7723081940074901);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2930L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7691084237121671, 0.7458373670189095);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2984L, 4645L, 1.0, 400000.0, 300000.0, -0.3752457891787805, 2.897246558310584, -0.3607013787454944, -0.3897901996120665);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2991L, 4269L, 1.0, 400000.0, 0.0, 0.7286749627076319, -2.103121748653165, 0.750491578357561, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2992L, 4269L, 3.2808398950131235, 399999.9999984, 0.0, 0.7286749627076319, -2.103121748653165, 0.750491578357561, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2993L, 4152L, 1.0, 400000.0, 0.0, 0.7286749627076319, -2.103121748653165, 0.750491578357561, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(2994L, 4152L, 3.2808398950131235, 399999.9999984, 0.0, 0.7286749627076319, -2.103121748653165, 0.750491578357561, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3033L, 4326L, 1.0, 6000000.0, 6000000.0, -0.8726646259971639, 1.2217304763960295, -1.1955505376161146, -1.300270292735774);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3034L, 4258L, 1.0, 4000000.0, 2800000.0, 0.9075712110370504, 0.17453292519943278, 0.6108652381980147, 1.1344640137963131);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3057L, 4659L, 1.0, 500000.0, 500000.0, 1.1344640137963131, -0.3316125578789223, 1.1213740444063556, 1.1475539831862704);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3080L, 4267L, 3.2808398950131235, 914400.0, 914400.0, 0.5439609502048989, -1.7453292519943278, 0.47851110325511154, 0.6094107971546862);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3081L, 4269L, 1.0, 1000000.0, 1000000.0, 0.5439609502048989, -1.7453292519943278, 0.47851110325511154, 0.6094107971546862);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3082L, 4269L, 1.0, 1500000.0, 5000000.0, 0.314159265358979, -1.7453292519943278, 0.4799655442984401, 0.6108652381980147);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3084L, 4152L, 1.0, 1500000.0, 5000000.0, 0.314159265358979, -1.7453292519943278, 0.4799655442984401, 0.6108652381980147);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3088L, 4269L, 1.0, 1500000.0, 1000000.0, 0.6341362948912724, -1.4966198335851362, 0.6472262642812299, 0.6748606441044734);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3089L, 4269L, 3.2808333333333333, 1500000.0, 999999.9998983998, 0.6341362948912724, -1.4966198335851362, 0.6472262642812299, 0.6748606441044734);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3090L, 4152L, 1.0, 1500000.0, 1000000.0, 0.6341362948912724, -1.4966198335851362, 0.6472262642812299, 0.6748606441044734);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3091L, 4152L, 3.2808333333333333, 1500000.0, 999999.9998983998, 0.6341362948912724, -1.4966198335851362, 0.6472262642812299, 0.6748606441044734);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3107L, 4283L, 1.0, 1000000.0, 2000000.0, -0.5585053606381849, 2.3561944901923426, -0.4886921905584118, -0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3110L, 4202L, 1.0, 2500000.0, 4500000.0, -0.6457718232379013, 2.5307274153917754, -0.628318530717958, -0.6632251157578446);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3111L, 4283L, 1.0, 2500000.0, 2500000.0, -0.6457718232379013, 2.5307274153917754, -0.628318530717958, -0.6632251157578446);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3112L, 4283L, 1.0, 0.0, 0.0, 0.0, 2.338741197672399, -0.314159265358979, -0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3161L, 4269L, 1.0, 930000.0, 6430000.0, 0.0, -1.4835298641951786, 0.7766715171374758, 0.9337511498169654);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3162L, 4617L, 1.0, 930000.0, 6430000.0, 0.0, -1.4835298641951786, 0.7766715171374758, 0.9337511498169654);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3163L, 4749L, 1.0, 400000.0, 300000.0, -0.3752457891787805, 2.897246558310584, -0.3607013787454944, -0.3897901996120665);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3165L, 4644L, 1.0, 0.66, 1.02, -0.38867944444171754, 2.9049683443436893, -0.3882431121287189, -0.3891157767547161);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3166L, 4644L, 1.0, 8.313, -2.354, -0.3886799762823257, 2.904969640250659, -0.38824364396932715, -0.38911630859532426);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3204L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.1519173063162564, -1.0588330795432255, -1.1053751929297408);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3205L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.942477796076937, -1.0588330795432255, -1.1053751929297408);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3206L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.7330382858376177, -1.0588330795432255, -1.1053751929297408);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3207L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -3.0368728984701305, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3208L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.1519173063162564, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3209L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.942477796076937, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3210L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.7330382858376177, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3211L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.942477796076937, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3212L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.1519173063162564, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3213L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.3613568165555756, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3214L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.570796326794895, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3215L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.7802358370342144, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3216L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.9896753472735336, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3217L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.199114857512853, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3218L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.4085543677521724, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3219L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.6179938779914917, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3220L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.827433388230811, -1.1286462496229985, -1.1751883630095141);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3221L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.7802358370342144, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3222L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.570796326794895, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3223L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.3613568165555756, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3224L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.1519173063162564, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3225L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.314159265358979, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3226L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.10471975511965967, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3227L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.10471975511965967, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3228L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.314159265358979, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3229L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.5235987755982984, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3230L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.7330382858376177, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3231L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.942477796076937, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3232L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.1519173063162564, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3233L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.3613568165555756, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3234L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.570796326794895, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3235L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.7802358370342144, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3236L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.9896753472735336, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3237L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.199114857512853, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3238L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.4085543677521724, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3239L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.6179938779914917, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3240L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.827433388230811, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3241L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 3.0368728984701305, -1.1984594197027718, -1.2450015330892872);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3242L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -2.6703537555513215, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3243L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -2.3561944901923426, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3244L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -2.0420352248333633, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3245L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.7278759594743844, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3246L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.4137166941154056, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3247L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.0995574287564265, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3248L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.4712388980384685, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3249L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.1570796326794895, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3250L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.1570796326794895, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3251L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.4712388980384685, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3252L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.7853981633974475, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3253L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.0995574287564265, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3254L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.4137166941154056, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3255L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.7278759594743844, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3256L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.0420352248333633, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3257L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.3561944901923426, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3258L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.6703537555513215, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3259L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.9845130209103004, -1.2682725897825449, -1.3148147031690602);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3260L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -2.9321531433504706, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3261L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -2.513274122871832, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3262L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -2.0943951023931935, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3263L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.6755160819145547, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3264L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -1.256637061435916, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3265L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.8377580409572774, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3266L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, -0.4188790204786387, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3267L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.0, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3268L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.4188790204786387, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3269L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 0.8377580409572774, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3270L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.256637061435916, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3271L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 1.6755160819145547, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3272L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.0943951023931935, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3273L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.513274122871832, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3274L, 4326L, 1.0, 0.0, 0.0, -1.570796326794895, 2.9321531433504706, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3294L, 4326L, 1.0, 0.0, 0.0, -1.3613568165555756, 2.827433388230811, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3300L, 4133L, 1.0, 500000.0, 6375000.0, 1.0038706937815993, 0.4188790204786387, 1.0355620228499678, 1.01229096615671);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3301L, 4180L, 1.0, 500000.0, 6375000.0, 1.0038706937815993, 0.4188790204786387, 1.0355620228499678, 1.01229096615671);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3308L, 4283L, 1.0, 9300000.0, 4500000.0, -0.580321976288114, 2.565634000431662, -0.5366887449882558, -0.6239552075879722);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3314L, 4695L, 1.0, 0.0, 0.0, 0.0, 0.4537856055185252, -0.1134464013796313, -0.2007128639793477);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3347L, 4269L, 1.0, 6200000.0, 3000000.0, 1.1063759938116553, -1.6033758061654557, 0.8552113334772206, 1.3439035240356323);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3348L, 4617L, 1.0, 6200000.0, 3000000.0, 1.1063759938116553, -1.6033758061654557, 0.8552113334772206, 1.3439035240356323);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3358L, 4152L, 1.0, 609601.22, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3359L, 4152L, 3.2808398950131235, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3360L, 4152L, 1.0, 609600.0, 0.0, 0.5555964785515277, -1.4137166941154056, 0.6079563561113575, 0.5672320068981566);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3361L, 4152L, 3.2808398950131235, 609600.0, 0.0, 0.5555964785515277, -1.4137166941154056, 0.6079563561113575, 0.5672320068981566);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3362L, 4152L, 1.0, 600000.0, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7321656212116205, 0.7135487758570144);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3363L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7321656212116205, 0.7135487758570144);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3364L, 4152L, 1.0, 600000.0, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3365L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3404L, 4152L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3415L, 4324L, 1.0, 500000.0, 500000.0, 0.3665191429188088, 1.9896753472735336, 0.314159265358979, 0.4188790204786387);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3416L, 4258L, 1.0, 400000.0, 400000.0, 0.8290313946973057, 0.23271056693257702, 0.8552113334772206, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3417L, 4269L, 3.2808333333333333, 1500000.0, 999999.99998984, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3418L, 4269L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3419L, 4269L, 3.2808333333333333, 399999.99998983997, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3420L, 4269L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3425L, 4152L, 3.2808333333333333, 1500000.0, 999999.99998984, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3426L, 4152L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3427L, 4152L, 3.2808333333333333, 399999.99998983997, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3428L, 4152L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3433L, 4269L, 3.2808333333333333, 399999.99998983997, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3434L, 4269L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3441L, 4152L, 3.2808333333333333, 399999.99998983997, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3442L, 4152L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3447L, 4258L, 1.0, 150328.0, 166262.0, 0.8865891245689624, 0.07608266909673497, 0.8697557439105067, 0.8930268006037644);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3451L, 4269L, 3.2808333333333333, 999999.99998984, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5701408889848137, 0.5439609502048989);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3452L, 4269L, 3.2808333333333333, 999999.99998984, 0.0, 0.4974188368183834, -1.5940673834881527, 0.5358160803622586, 0.511381470834338);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3453L, 4269L, 3.2808333333333333, 999999.99998984, 0.0, 0.4450589592585536, -1.5940673834881527, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3454L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3455L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3456L, 4152L, 3.2808333333333333, 999999.99998984, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5701408889848137, 0.5439609502048989);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3457L, 4152L, 3.2808333333333333, 999999.99998984, 0.0, 0.4974188368183834, -1.5940673834881527, 0.5358160803622586, 0.511381470834338);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3458L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.765035988790847, -1.7453292519943278, 0.7973245799527421, 0.7752170760941473);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3459L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3477L, 4759L, 1.0, 1000000.0, 0.0, 0.8901179185171072, -3.0717794835100167, 0.9395689139902798, 0.9046623289503932);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3484L, 4759L, 1.0, 400000.0, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3485L, 4759L, 3.2808333333333333, 399999.99998983997, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3486L, 4759L, 1.0, 400000.0, 400000.0, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3487L, 4759L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3489L, 4759L, 1.0, 2000000.0, 500000.0, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3490L, 4759L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3491L, 4759L, 1.0, 2000000.0, 500000.0, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3492L, 4759L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3493L, 4759L, 1.0, 2000000.0, 500000.0, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3494L, 4759L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3495L, 4759L, 1.0, 2000000.0, 500000.0, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3496L, 4759L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3497L, 4759L, 1.0, 2000000.0, 500000.0, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3498L, 4759L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3499L, 4759L, 1.0, 2000000.0, 500000.0, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3500L, 4759L, 3.2808333333333333, 2000000.0001016003, 500000.0001016002, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3501L, 4759L, 1.0, 914401.8289, 304800.6096, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3502L, 4759L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3503L, 4759L, 1.0, 914401.8289, 304800.6096, 0.6864961724511023, -1.841322360854016, 0.71180344660502, 0.6931866012504139);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3504L, 4759L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6864961724511023, -1.841322360854016, 0.71180344660502, 0.6931866012504139);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3505L, 4759L, 1.0, 914401.8289, 304800.6096, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3506L, 4759L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3507L, 4759L, 1.0, 304800.6096, 152400.3048, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3508L, 4759L, 3.2808333333333333, 304800.6096012192, 152400.3048006096, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3514L, 4759L, 1.0, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3515L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3536L, 4759L, 1.0, 1500000.0, 1000000.0, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3537L, 4759L, 3.2808333333333333, 1500000.0, 999999.99998984, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3538L, 4759L, 1.0, 500000.0, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3539L, 4759L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3540L, 4759L, 1.0, 400000.0, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3541L, 4759L, 3.2808333333333333, 399999.99998983997, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3542L, 4759L, 1.0, 400000.0, 400000.0, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3543L, 4759L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3544L, 4759L, 1.0, 500000.0, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3545L, 4759L, 3.2808333333333333, 500000.0001016002, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3546L, 4759L, 1.0, 1500000.0, 1000000.0, 0.6341362948912724, -1.4966198335851362, 0.6472262642812299, 0.6748606441044734);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3547L, 4759L, 3.2808333333333333, 1500000.0, 999999.9998983998, 0.6341362948912724, -1.4966198335851362, 0.6472262642812299, 0.6748606441044734);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3548L, 4759L, 1.0, 500000.0, 500000.0, 0.6341362948912724, -1.4966198335851362, 0.6620615629231816, 0.6411176118992498);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3549L, 4759L, 3.2808333333333333, 500000.0001016002, 500000.0001016002, 0.6341362948912724, -1.4966198335851362, 0.6620615629231816, 0.6411176118992498);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3550L, 4759L, 1.0, 1000000.0, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5701408889848137, 0.5439609502048989);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3551L, 4759L, 3.2808333333333333, 999999.99998984, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5701408889848137, 0.5439609502048989);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3552L, 4759L, 1.0, 1000000.0, 0.0, 0.4974188368183834, -1.5940673834881527, 0.5358160803622586, 0.511381470834338);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3553L, 4759L, 3.2808333333333333, 999999.99998984, 0.0, 0.4974188368183834, -1.5940673834881527, 0.5358160803622586, 0.511381470834338);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3559L, 4759L, 1.0, 400000.0, 0.0, 0.6574073515845301, -1.3439035240356323, 0.6885323899117624, 0.6684611035138276);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3560L, 4269L, 3.2808333333333333, 500000.00001016003, 999999.99998984, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3566L, 4269L, 3.2808333333333333, 500000.00001016003, 2000000.00001016, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3567L, 4269L, 3.2808333333333333, 500000.00001016003, 3000000.0, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3568L, 4152L, 3.2808333333333333, 500000.00001016003, 999999.99998984, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3569L, 4152L, 3.2808333333333333, 500000.00001016003, 2000000.00001016, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3570L, 4152L, 3.2808333333333333, 500000.00001016003, 3000000.0, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3580L, 4269L, 1.0, 0.0, 0.0, 0.0, -1.9547687622336472, 1.0821041362364832, 1.2217304763960295);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3581L, 4617L, 1.0, 0.0, 0.0, 0.0, -1.9547687622336472, 1.0821041362364832, 1.2217304763960295);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3582L, 4759L, 3.2808333333333333, 399999.9998983998, 0.0, 0.6574073515845301, -1.3439035240356323, 0.6885323899117624, 0.6684611035138276);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3583L, 4759L, 1.0, 500000.0, 0.0, 0.7155849933176743, -1.230457122656001, 0.7240207513689803, 0.7205300928649917);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3584L, 4759L, 3.2808333333333333, 500000.0001016002, 0.0, 0.7155849933176743, -1.230457122656001, 0.7240207513689803, 0.7205300928649917);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3585L, 4759L, 1.0, 200000.0, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7449647023929122, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3586L, 4759L, 3.2808333333333333, 200000.0001016002, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7449647023929122, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3587L, 4759L, 1.0, 6000000.0, 0.0, 0.7560184543222096, -1.4724761122658812, 0.7976154681614078, 0.7711446411728271);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3588L, 4759L, 3.2808398950131235, 5999999.999976, 0.0, 0.7560184543222096, -1.4724761122658812, 0.7976154681614078, 0.7711446411728271);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3589L, 4759L, 1.0, 8000000.0, 0.0, 0.7816166166847931, -1.5184364492350653, 0.8217591894806626, 0.7938339214487534);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3590L, 4759L, 3.2808398950131235, 7999999.999968, 0.0, 0.7816166166847931, -1.5184364492350653, 0.8217591894806626, 0.7938339214487534);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3592L, 4759L, 1.0, 4000000.0, 0.0, 0.724311639577646, -1.4724761122658812, 0.7621271067041898, 0.734783615089612);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3593L, 4759L, 3.2808398950131235, 3999999.999984, 0.0, 0.724311639577646, -1.4724761122658812, 0.7621271067041898, 0.734783615089612);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3594L, 4759L, 1.0, 800000.0, 100000.0, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3595L, 4759L, 1.0, 800000.0, 100000.0, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3596L, 4759L, 1.0, 800000.0, 100000.0, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3604L, 4759L, 1.0, 600000.0, 0.0, 0.7723081940074901, -1.911135530933789, 0.8552113334772206, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3605L, 4759L, 3.2808398950131235, 599999.9999976, 0.0, 0.7723081940074901, -1.911135530933789, 0.8552113334772206, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3606L, 4759L, 1.0, 500000.0, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3627L, 4759L, 1.0, 300000.0, 0.0, 0.7010405828843883, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3628L, 4759L, 3.2808333333333333, 300000.0, 0.0, 0.7010405828843883, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3631L, 4759L, 1.0, 609601.22, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3632L, 4759L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3633L, 4759L, 1.0, 600000.0, 0.0, 0.820304748437334, -1.7540558982542993, 0.850557122138569, 0.8278678418626428);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3634L, 4759L, 3.2808398950131235, 599999.9999976, 0.0, 0.820304748437334, -1.7540558982542993, 0.850557122138569, 0.8278678418626428);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3635L, 4759L, 1.0, 600000.0, 0.0, 0.7970336917440763, -1.7540558982542993, 0.82874050648864, 0.8060512262127137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3636L, 4759L, 3.2808398950131235, 599999.9999976, 0.0, 0.7970336917440763, -1.7540558982542993, 0.82874050648864, 0.8060512262127137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3637L, 4759L, 1.0, 600000.0, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7278022980816347, 0.7056947942230398);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3638L, 4759L, 1.0, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6987134772150626, 0.6760241969391363);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3639L, 4759L, 1.0, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6416993883165811, 0.6207554372926493);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3640L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6416993883165811, 0.6207554372926493);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3641L, 4759L, 1.0, 600000.0, 0.0, 0.5817764173314426, -1.7104226669544411, 0.6149376731193348, 0.5922483928434086);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3642L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.5817764173314426, -1.7104226669544411, 0.6149376731193348, 0.5922483928434086);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3643L, 4759L, 1.0, 400000.0, 0.0, 0.7286749627076319, -2.103121748653165, 0.750491578357561, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3644L, 4759L, 3.2808398950131235, 399999.9999984, 0.0, 0.7286749627076319, -2.103121748653165, 0.750491578357561, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3645L, 4759L, 1.0, 2500000.0, 0.0, 0.7621271067041898, -2.103121748653165, 0.8028514559173908, 0.7737626350508187);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3646L, 4759L, 3.2808398950131235, 2500000.0001424, 0.0, 0.7621271067041898, -2.103121748653165, 0.8028514559173908, 0.7737626350508187);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3647L, 4759L, 1.0, 1500000.0, 0.0, 0.7272205216643033, -2.103121748653165, 0.7679448708775042, 0.7388560500109321);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3648L, 4759L, 3.2808398950131235, 1500000.0001464, 0.0, 0.7272205216643033, -2.103121748653165, 0.7679448708775042, 0.7388560500109321);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3649L, 4759L, 1.0, 600000.0, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7321656212116205, 0.7135487758570144);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3650L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7321656212116205, 0.7135487758570144);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3651L, 4759L, 1.0, 600000.0, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3652L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3655L, 4759L, 1.0, 609600.0, 0.0, 0.5555964785515277, -1.4137166941154056, 0.6079563561113575, 0.5672320068981566);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3656L, 4759L, 3.2808398950131235, 609600.0, 0.0, 0.5555964785515277, -1.4137166941154056, 0.6079563561113575, 0.5672320068981566);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3657L, 4759L, 1.0, 600000.0, 0.0, 0.765035988790847, -1.7453292519943278, 0.7973245799527421, 0.7752170760941473);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3658L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.765035988790847, -1.7453292519943278, 0.7973245799527421, 0.7752170760941473);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3659L, 4759L, 1.0, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3660L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3661L, 4759L, 1.0, 600000.0, 0.0, 0.5992297098513859, -1.500983156715122, 0.635590735934601, 0.6152285613280005);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3662L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.5992297098513859, -1.500983156715122, 0.635590735934601, 0.6152285613280005);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3663L, 4759L, 1.0, 700000.0, 3000000.0, 0.5177810114249839, -1.7511470161676421, 0.5564691431775248, 0.5256349930589583);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3664L, 4759L, 3.2808333333333333, 699999.9998983998, 3000000.0, 0.5177810114249839, -1.7511470161676421, 0.5564691431775248, 0.5256349930589583);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3666L, 4759L, 1.0, 1500000.0, 5000000.0, 0.314159265358979, -1.7453292519943278, 0.4799655442984401, 0.6108652381980147);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3667L, 4759L, 1.0, 200000.0, 1000000.0, 0.5934119456780714, -1.7715091907742426, 0.6315183010132809, 0.6047565858160345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3668L, 4759L, 3.2808333333333333, 200000.0001016002, 999999.9998983998, 0.5934119456780714, -1.7715091907742426, 0.6315183010132809, 0.6047565858160345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3669L, 4759L, 1.0, 600000.0, 2000000.0, 0.5526875964648704, -1.7191493132144129, 0.59283016926074, 0.5608324663075107);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3670L, 4759L, 3.2808333333333333, 600000.0, 2000000.0001016003, 0.5526875964648704, -1.7191493132144129, 0.59283016926074, 0.5608324663075107);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3671L, 4759L, 1.0, 300000.0, 5000000.0, 0.4479678413452108, -1.7191493132144129, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3672L, 4759L, 3.2808333333333333, 300000.0, 5000000.0001016, 0.4479678413452108, -1.7191493132144129, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3673L, 4759L, 1.0, 600000.0, 4000000.0, 0.48578330847175455, -1.7278759594743844, 0.5285438751456156, 0.4953826193577234);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3674L, 4759L, 3.2808333333333333, 600000.0, 3999999.9998983997, 0.48578330847175455, -1.7278759594743844, 0.5285438751456156, 0.4953826193577234);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3675L, 4759L, 1.0, 500000.0, 2000000.0, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3676L, 4759L, 3.2808398950131235, 500000.0001504, 1999999.999992, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3677L, 4759L, 3.2808333333333333, 500000.00001016003, 2000000.00001016, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3678L, 4759L, 1.0, 500000.0, 1000000.0, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3679L, 4759L, 3.2808398950131235, 500000.0001504, 999999.999996, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3680L, 4759L, 3.2808333333333333, 500000.00001016003, 999999.99998984, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3681L, 4759L, 1.0, 500000.0, 3000000.0, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3682L, 4759L, 3.2808398950131235, 500000.0001504, 2999999.999988, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3683L, 4759L, 3.2808333333333333, 500000.00001016003, 3000000.0, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3685L, 4759L, 1.0, 3500000.0, 2000000.0, 0.6574073515845301, -1.3700834628155474, 0.6841690667817765, 0.663806892175176);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3686L, 4759L, 3.2808333333333333, 3500000.0001016003, 2000000.0001016003, 0.6574073515845301, -1.3700834628155474, 0.6841690667817765, 0.663806892175176);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3687L, 4759L, 1.0, 3500000.0, 1000000.0, 0.6341362948912724, -1.3700834628155474, 0.6626433393405131, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3688L, 4759L, 3.2808333333333333, 3500000.0001016003, 999999.9998983998, 0.6341362948912724, -1.3700834628155474, 0.6626433393405131, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3689L, 4759L, 1.0, 500000.0, 0.0, 0.820304748437334, -2.1089395128264794, 0.850557122138569, 0.8290313946973057);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3690L, 4759L, 3.2808333333333333, 500000.0001016002, 0.0, 0.820304748437334, -2.1089395128264794, 0.850557122138569, 0.8290313946973057);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3691L, 4759L, 1.0, 500000.0, 0.0, 0.791215927570762, -2.103121748653165, 0.8261225126106485, 0.7999425738307335);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3692L, 4759L, 3.2808333333333333, 500000.0001016002, 0.0, 0.791215927570762, -2.103121748653165, 0.8261225126106485, 0.7999425738307335);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3693L, 4759L, 1.0, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3694L, 4759L, 1.0, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3695L, 4759L, 1.0, 600000.0, 0.0, 0.765035988790847, -1.570796326794895, 0.7941248096574192, 0.7723081940074901);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3696L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.765035988790847, -1.570796326794895, 0.7941248096574192, 0.7723081940074901);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3697L, 4759L, 1.0, 600000.0, 0.0, 0.7883070454841047, -1.570796326794895, 0.816232313516014, 0.795288362492082);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3698L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.7883070454841047, -1.570796326794895, 0.816232313516014, 0.795288362492082);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3699L, 4759L, 1.0, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7691084237121671, 0.7458373670189095);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3700L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7691084237121671, 0.7458373670189095);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3728L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7278022980816347, 0.7056947942230398);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3729L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6987134772150626, 0.6760241969391363);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3734L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7278022980816347, 0.7056947942230398);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3735L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6987134772150626, 0.6760241969391363);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3753L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7278022980816347, 0.7056947942230398);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3754L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6987134772150626, 0.6760241969391363);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3762L, 4326L, 1.0, 0.0, 0.0, -0.9599310885968803, -0.6457718232379013, -0.942477796076937, -0.9555677654668945);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3766L, 4761L, 1.0, 0.0, 0.0, 0.0, 0.2879793265790641, 0.8013970148740621, 0.7519460194008896);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3795L, 4267L, 1.0, 500000.0, 280296.016, 0.39008108782073225, -1.4137166941154056, 0.4014257279586954, 0.37873644768276915);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3796L, 4267L, 1.0, 500000.0, 229126.939, 0.36157404337149157, -1.340994641948975, 0.3717551306747918, 0.3513929560681913);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3797L, 4267L, 1.0, 800000.0, 0.0, 0.7679448708775042, -1.2217304763960295, 0.8726646259971639, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3798L, 4269L, 1.0, 800000.0, 0.0, 0.7679448708775042, -1.2217304763960295, 0.8726646259971639, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3799L, 4617L, 1.0, 800000.0, 0.0, 0.7679448708775042, -1.2217304763960295, 0.8726646259971639, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3812L, 4258L, 1.0, 649328.0, 665262.0, 0.8865891245689624, 0.07608266909673497, 0.8697557439105067, 0.8930268006037644);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3851L, 4167L, 1.0, 3000000.0, 7000000.0, -0.7155849933176743, 3.019419605950187, -0.6544984694978729, -0.7766715171374758);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3852L, 4764L, 1.0, 500000.0, 0.0, -1.570796326794895, 2.7401669256310948, -1.338085759862318, -1.3846278732488333);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3942L, 4171L, 1.0, 1700000.0, 1200000.0, 0.7330382858376177, 0.052359877559829834, 0.7199483164476602, 0.7461282552275751);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3943L, 4171L, 1.0, 1700000.0, 2200000.0, 0.750491578357561, 0.052359877559829834, 0.7374016089676035, 0.7635815477475184);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3944L, 4171L, 1.0, 1700000.0, 3200000.0, 0.7679448708775042, 0.052359877559829834, 0.7548549014875467, 0.7810348402674617);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3945L, 4171L, 1.0, 1700000.0, 4200000.0, 0.7853981633974475, 0.052359877559829834, 0.7723081940074901, 0.7984881327874049);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3946L, 4171L, 1.0, 1700000.0, 5200000.0, 0.8028514559173908, 0.052359877559829834, 0.7897614865274333, 0.8159414253073483);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3947L, 4171L, 1.0, 1700000.0, 6200000.0, 0.820304748437334, 0.052359877559829834, 0.8072147790473766, 0.8333947178272915);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3948L, 4171L, 1.0, 1700000.0, 7200000.0, 0.8377580409572774, 0.052359877559829834, 0.8246680715673199, 0.8508480103472348);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3949L, 4171L, 1.0, 1700000.0, 8200000.0, 0.8552113334772206, 0.052359877559829834, 0.8421213640872631, 0.8683013028671781);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3950L, 4171L, 1.0, 1700000.0, 9200000.0, 0.8726646259971639, 0.052359877559829834, 0.8595746566072064, 0.8857545953871213);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3968L, 4269L, 1.0, 0.0, 0.0, 0.628318530717958, -1.3875367553354905, 0.6457718232379013, 0.6894050545377595);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3969L, 4152L, 1.0, 0.0, 0.0, 0.628318530717958, -1.3875367553354905, 0.6457718232379013, 0.6894050545377595);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3970L, 4759L, 1.0, 0.0, 0.0, 0.628318530717958, -1.3875367553354905, 0.6457718232379013, 0.6894050545377595);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3978L, 4269L, 1.0, 0.0, 0.0, 0.8552113334772206, -1.6580627893946114, 0.8552113334772206, 1.3439035240356323);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3979L, 4617L, 1.0, 0.0, 0.0, 0.8552113334772206, -1.6580627893946114, 0.8552113334772206, 1.3439035240356323);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3985L, 4695L, 1.0, 500000.0, 500000.0, 0.1570796326794895, 0.4537856055185252, -0.1134464013796313, -0.2007128639793477);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3991L, 4139L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3112503832723218, -1.159480399741565, 0.32172235878428773, 0.31474104177631046);
        LambertConformalConicSrid.registerLambertConformalConicSrid(3992L, 4139L, 3.2808333333333333, 152400.3048006096, 30480.06096012192, 0.3112503832723218, -1.159480399741565, 0.32172235878428773, 0.31474104177631046);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4415L, 4695L, 1.0, 500000.0, 500000.0, -0.1570796326794895, 0.4537856055185252, -0.1134464013796313, -0.2007128639793477);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4437L, 4759L, 1.0, 200000.0, 200000.0, 0.3112503832723218, -1.159480399741565, 0.32172235878428773, 0.31474104177631046);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4455L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4456L, 4267L, 3.2808333333333333, 609601.2192024384, 30480.06096012192, 0.7068583470577028, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4457L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.765035988790847, -1.7453292519943278, 0.7973245799527421, 0.7752170760941473);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4462L, 4326L, 1.0, 0.0, 0.0, -0.4712388980384685, 2.303834612632513, -0.314159265358979, -0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4826L, 4326L, 1.0, 161587.83, 128511.202, 0.2763437982324352, -0.4188790204786387, 0.2617993877991492, 0.2908882086657213);
        LambertConformalConicSrid.registerLambertConformalConicSrid(4839L, 4258L, 1.0, 0.0, 0.0, 0.8901179185171072, 0.1832595714594044, 0.8493935693039062, 0.9366600319036226);
        LambertConformalConicSrid.registerLambertConformalConicSrid(21500L, 4809L, 1.0, 150000.0, 5400000.0, 1.570796326794895, 0.0, 0.8697557439105067, 0.8930268006037644);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26740L, 4267L, 3.2808333333333333, 914401.8288036576, 0.0, 0.8901179185171072, -3.0717794835100167, 0.9395689139902798, 0.9046623289503932);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26741L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26742L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26743L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26744L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26745L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26746L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26747L, 4267L, 3.2808333333333333, 1276106.4505969011, 127079.52451104902, 0.5957390513473972, -2.065306281526621, 0.6006841508947145, 0.5910848400087457);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26751L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26752L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26753L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724511023, -1.841322360854016, 0.6931866012504139, 0.71180344660502);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26754L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26755L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26756L, 4267L, 3.2808333333333333, 182880.3657607315, 0.0, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26760L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26775L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26776L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26777L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26778L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26779L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393405131, 0.6800966318604564);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26780L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6341362948912724, -1.4966198335851362, 0.6411176118992498, 0.6620615629231816);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26781L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5352343039449272, -1.6144295580947532, 0.5439609502048989, 0.5701408889848137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26782L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5003277189050406, -1.5940673834881527, 0.511381470834338, 0.5358160803622586);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26785L, 4267L, 3.2808333333333333, 243840.48768097535, 0.0, 0.6603162336711873, -1.3439035240356323, 0.6684611035138276, 0.6885323899117624);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26786L, 4267L, 3.2808333333333333, 182880.3657607315, 0.0, 0.7155849933176743, -1.2479104151759444, 0.7280931862903004, 0.7449647023929122);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26787L, 4267L, 3.2808333333333333, 60960.12192024384, 0.0, 0.7155849933176743, -1.230457122656001, 0.7205300928649917, 0.7240207513689803);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26791L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.8115781021773624, -1.6249015336067192, 0.8208865248546655, 0.8488117928865747);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26792L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7853981633974475, -1.6449728200046538, 0.7961610271180792, 0.8211774130633313);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26793L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.750491578357561, -1.640609496874668, 0.7641633241648499, 0.7891797101101019);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26799L, 4267L, 3.2808333333333333, 1276106.4505969011, 1268253.0068580138, 0.5957390513473972, -2.065306281526621, 0.6006841508947145, 0.5910848400087457);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26811L, 4268L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7816166166847931, -1.5184364492350653, 0.7938339214487534, 0.8217591894806626);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26812L, 4268L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7560184543222096, -1.4718943358485497, 0.7711446411728271, 0.7976154681614078);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26813L, 4268L, 3.2808333333333333, 609601.2192024384, 0.0, 0.724311639577646, -1.4718943358485497, 0.734783615089612, 0.7621271067041898);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26819L, 4269L, 1.0, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26820L, 4269L, 1.0, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26821L, 4269L, 1.0, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26822L, 4269L, 1.0, 500000.00001016003, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26823L, 4269L, 1.0, 1968500.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26824L, 4269L, 1.0, 1968500.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26830L, 4152L, 1.0, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26831L, 4152L, 1.0, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26832L, 4152L, 1.0, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26833L, 4152L, 1.0, 500000.00001016003, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26834L, 4152L, 1.0, 1968500.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26835L, 4152L, 1.0, 1968500.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26841L, 4759L, 1.0, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26842L, 4759L, 1.0, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26843L, 4759L, 1.0, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26844L, 4759L, 1.0, 500000.00001016003, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26845L, 4759L, 1.0, 1968500.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26846L, 4759L, 1.0, 1968500.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26849L, 4269L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26850L, 4269L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26851L, 4269L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26852L, 4269L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26853L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26854L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26857L, 4152L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26858L, 4152L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26859L, 4152L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26860L, 4152L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26861L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26862L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26865L, 4759L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26866L, 4759L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26867L, 4759L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26868L, 4759L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26869L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26870L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26940L, 4269L, 1.0, 1000000.0, 0.0, 0.8901179185171072, -3.0717794835100167, 0.9395689139902798, 0.9046623289503932);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26941L, 4269L, 1.0, 2000000.0, 500000.0, 0.6864961724511023, -2.1293016874330797, 0.7272205216643033, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26942L, 4269L, 1.0, 2000000.0, 500000.0, 0.6574073515845301, -2.1293016874330797, 0.6952228187110739, 0.669042879931159);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26943L, 4269L, 1.0, 2000000.0, 500000.0, 0.6370451769779296, -2.103121748653165, 0.6707882091831533, 0.6469353760725641);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26944L, 4269L, 1.0, 2000000.0, 500000.0, 0.6166830023713291, -2.07694180987325, 0.650135146367887, 0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26945L, 4269L, 1.0, 2000000.0, 500000.0, 0.5846852994180998, -2.059488517353307, 0.6190101080406549, 0.5939937220954029);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26946L, 4269L, 1.0, 2000000.0, 500000.0, 0.5614142427248421, -2.028945255443406, 0.5913757282174114, 0.5721771064454738);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26951L, 4269L, 1.0, 400000.0, 0.0, 0.5992297098513859, -1.6057029118347816, 0.6323909656392781, 0.6097016853633518);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26952L, 4269L, 1.0, 400000.0, 400000.0, 0.5701408889848137, -1.6057029118347816, 0.6067928032766946, 0.5811946409141111);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26953L, 4269L, 1.0, 914401.8289, 304800.6096, 0.6864961724511023, -1.841322360854016, 0.71180344660502, 0.6931866012504139);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26954L, 4269L, 1.0, 914401.8289, 304800.6096, 0.6603162336711873, -1.841322360854016, 0.6937683776677452, 0.671079097391819);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26955L, 4269L, 1.0, 914401.8289, 304800.6096, 0.6399540590645868, -1.841322360854016, 0.6707882091831533, 0.6498442581592214);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26956L, 4269L, 1.0, 304800.6096, 152400.3048, 0.7126761112310172, -1.2697270308258735, 0.730711180168292, 0.719075651821663);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26960L, 4269L, 1.0, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5366887449882558, 0.5163265703816553);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26975L, 4269L, 1.0, 1500000.0, 1000000.0, 0.724311639577646, -1.6318828506146965, 0.7551457896962125, 0.7342018386722805);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26976L, 4269L, 1.0, 500000.0, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7292567391249632, 0.7088945645183627);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26977L, 4269L, 1.0, 400000.0, 0.0, 0.669042879931159, -1.7104226669544411, 0.6943501540850767, 0.6757333087304705);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26978L, 4269L, 1.0, 400000.0, 400000.0, 0.6399540590645868, -1.7191493132144129, 0.6731153148524791, 0.6504260345765528);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26980L, 4269L, 1.0, 500000.0, 500000.0, 0.6341362948912724, -1.4966198335851362, 0.6620615629231816, 0.6411176118992498);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26981L, 4269L, 1.0, 1000000.0, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5701408889848137, 0.5439609502048989);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26982L, 4269L, 1.0, 1000000.0, 0.0, 0.4974188368183834, -1.5940673834881527, 0.5358160803622586, 0.511381470834338);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26985L, 4269L, 1.0, 400000.0, 0.0, 0.6574073515845301, -1.3439035240356323, 0.6885323899117624, 0.6684611035138276);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26986L, 4269L, 1.0, 200000.0, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7449647023929122, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26987L, 4269L, 1.0, 500000.0, 0.0, 0.7155849933176743, -1.230457122656001, 0.7240207513689803, 0.7205300928649917);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26988L, 4269L, 1.0, 8000000.0, 0.0, 0.7816166166847931, -1.5184364492350653, 0.8217591894806626, 0.7938339214487534);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26989L, 4269L, 1.0, 6000000.0, 0.0, 0.7560184543222096, -1.4724761122658812, 0.7976154681614078, 0.7711446411728271);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26990L, 4269L, 1.0, 4000000.0, 0.0, 0.724311639577646, -1.4724761122658812, 0.7621271067041898, 0.734783615089612);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26991L, 4269L, 1.0, 800000.0, 100000.0, 0.8115781021773624, -1.6249015336067192, 0.8488117928865747, 0.8208865248546655);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26992L, 4269L, 1.0, 800000.0, 100000.0, 0.7853981633974475, -1.6449728200046538, 0.8211774130633313, 0.7961610271180792);
        LambertConformalConicSrid.registerLambertConformalConicSrid(26993L, 4269L, 1.0, 800000.0, 100000.0, 0.750491578357561, -1.640609496874668, 0.7891797101101019, 0.7641633241648499);
        LambertConformalConicSrid.registerLambertConformalConicSrid(31287L, 4312L, 1.0, 400000.0, 400000.0, 0.8290313946973057, 0.23271056693257702, 0.8552113334772206, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(31297L, 4312L, 1.0, 400000.0, 400000.0, 0.8290313946973057, 0.23271056693257702, 0.8552113334772206, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(31370L, 4313L, 1.0, 150000.013, 5400088.438, 1.570796326794895, 0.07622702237028534, 0.8930268104939635, 0.8697557538007058);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32001L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.820304748437334, -1.911135530933789, 0.8502662339299033, 0.8351400470792858);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32002L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7999425738307335, -1.911135530933789, 0.8357218234966173, 0.8107054375513653);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32003L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7679448708775042, -1.911135530933789, 0.809832772925368, 0.7830710577281217);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32005L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7214027574909888, -1.7453292519943278, 0.7304202919596262, 0.747291808062238);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32006L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6923139366244166, -1.7366026057343562, 0.7030768003450484, 0.7280931862903004);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32018L, 4267L, 3.2808333333333333, 304800.6096012192, 0.0, 0.7068583470577028, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32019L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.5992297098513859, 0.6312274128046153);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32020L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.820304748437334, -1.7540558982542993, 0.8278678418626428, 0.850557122138569);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32021L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7970336917440763, -1.7540558982542993, 0.8060512262127137, 0.82874050648864);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32022L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7056947942230398, 0.7278022980816347);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32023L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6760241969391363, 0.6987134772150626);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32024L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6207554372926493, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32025L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5817764173314426, -1.7104226669544411, 0.5922483928434086, 0.6149376731193348);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32026L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7621271067041898, -2.103121748653165, 0.7737626350508187, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32027L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7272205216643033, -2.103121748653165, 0.7388560500109321, 0.7679448708775042);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32028L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7135487758570144, 0.7321656212116205);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32029L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724511023, -1.3569934934255898, 0.6969681479630683, 0.7120943348136858);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32031L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5759586531581282, -1.4137166941154056, 0.5893395107567514, 0.6102834617806833);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32033L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5555964785515277, -1.4137166941154056, 0.5643231248114993, 0.5875941815047571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32034L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.765035988790847, -1.7453292519943278, 0.7752170760941473, 0.7973245799527421);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32035L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7475826962709037, 0.7749261878854815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32036L, 4267L, 3.2808333333333333, 30480.06096012192, 0.0, 0.6050474740247003, -1.500983156715122, 0.6152285613280005, 0.635590735934601);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32037L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5934119456780714, -1.7715091907742426, 0.6047565858160345, 0.6315183010132809);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32038L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5526875964648704, -1.7016960206944696, 0.5608324663075107, 0.59283016926074);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32039L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5177810114249839, -1.7511470161676421, 0.5256349930589583, 0.5564691431775248);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32040L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.48578330847175455, -1.7278759594743844, 0.4953826193577234, 0.5285438751456156);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32041L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.4479678413452108, -1.7191493132144129, 0.45669448760518244, 0.48578330847175455);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32042L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7039494649710455, -1.9460421159736754, 0.7106398937703571, 0.7292567391249632);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32043L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.669042879931159, -1.9460421159736754, 0.6809692964864535, 0.7094763409356942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32044L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6399540590645868, -1.9460421159736754, 0.6495533699505557, 0.6693337681398247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32046L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6574073515845301, -1.3700834628155474, 0.663806892175176, 0.6841690667817765);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32047L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6341362948912724, -1.3700834628155474, 0.6416993883165811, 0.6626433393405131);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32048L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.820304748437334, -2.1089395128264794, 0.8290313946973057, 0.850557122138569);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32049L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.791215927570762, -2.103121748653165, 0.7999425738307335, 0.8261225126106485);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32050L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6719517620178161, -1.3875367553354905, 0.6806784082777878, 0.7024950239277169);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32051L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6542075812892072, 0.6786421908171277);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32052L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7883070454841047, -1.570796326794895, 0.795288362492082, 0.816232313516014);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32053L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.765035988790847, -1.570796326794895, 0.7723081940074901, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32054L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7330382858376177, -1.570796326794895, 0.7458373670189095, 0.7691084237121671);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32098L, 4267L, 1.0, 0.0, 0.0, 0.7679448708775042, -1.1955505376161146, 1.0471975511965967, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32099L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.4479678413452108, -1.5940673834881527, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32100L, 4269L, 1.0, 600000.0, 0.0, 0.7723081940074901, -1.911135530933789, 0.8552113334772206, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32104L, 4269L, 1.0, 500000.0, 0.0, 0.6952228187110739, -1.7453292519943278, 0.750491578357561, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32118L, 4269L, 1.0, 300000.0, 0.0, 0.7010405828843883, -1.2915436464758026, 0.7161667697350058, 0.70976722914436);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32119L, 4269L, 1.0, 609601.22, 0.0, 0.5890486225480857, -1.378810109075519, 0.6312274128046153, 0.5992297098513859);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32120L, 4269L, 1.0, 600000.0, 0.0, 0.820304748437334, -1.7540558982542993, 0.850557122138569, 0.8278678418626428);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32121L, 4269L, 1.0, 600000.0, 0.0, 0.7970336917440763, -1.7540558982542993, 0.82874050648864, 0.8060512262127137);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32122L, 4269L, 1.0, 600000.0, 0.0, 0.6923139366244166, -1.4398966328953204, 0.7278022980816347, 0.7056947942230398);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32123L, 4269L, 1.0, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6987134772150626, 0.6760241969391363);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32124L, 4269L, 1.0, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.6416993883165811, 0.6207554372926493);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32125L, 4269L, 1.0, 600000.0, 0.0, 0.5817764173314426, -1.7104226669544411, 0.6149376731193348, 0.5922483928434086);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32126L, 4269L, 1.0, 2500000.0, 0.0, 0.7621271067041898, -2.103121748653165, 0.8028514559173908, 0.7737626350508187);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32127L, 4269L, 1.0, 1500000.0, 0.0, 0.7272205216643033, -2.103121748653165, 0.7679448708775042, 0.7388560500109321);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32128L, 4269L, 1.0, 600000.0, 0.0, 0.7010405828843883, -1.3569934934255898, 0.7321656212116205, 0.7135487758570144);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32129L, 4269L, 1.0, 600000.0, 0.0, 0.6864961724511023, -1.3569934934255898, 0.715003216900343, 0.6969681479630683);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32133L, 4269L, 1.0, 609600.0, 0.0, 0.5555964785515277, -1.4137166941154056, 0.6079563561113575, 0.5672320068981566);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32134L, 4269L, 1.0, 600000.0, 0.0, 0.765035988790847, -1.7453292519943278, 0.7973245799527421, 0.7752170760941473);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32135L, 4269L, 1.0, 600000.0, 0.0, 0.7388560500109321, -1.7511470161676421, 0.7749261878854815, 0.7475826962709037);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32136L, 4269L, 1.0, 600000.0, 0.0, 0.5992297098513859, -1.500983156715122, 0.635590735934601, 0.6152285613280005);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32137L, 4269L, 1.0, 200000.0, 1000000.0, 0.5934119456780714, -1.7715091907742426, 0.6315183010132809, 0.6047565858160345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32138L, 4269L, 1.0, 600000.0, 2000000.0, 0.5526875964648704, -1.7191493132144129, 0.59283016926074, 0.5608324663075107);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32139L, 4269L, 1.0, 700000.0, 3000000.0, 0.5177810114249839, -1.7511470161676421, 0.5564691431775248, 0.5256349930589583);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32140L, 4269L, 1.0, 600000.0, 4000000.0, 0.48578330847175455, -1.7278759594743844, 0.5285438751456156, 0.4953826193577234);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32141L, 4269L, 1.0, 300000.0, 5000000.0, 0.4479678413452108, -1.7191493132144129, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32142L, 4269L, 1.0, 500000.0, 1000000.0, 0.7039494649710455, -1.9460421159736754, 0.7292567391249632, 0.7106398937703571);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32143L, 4269L, 1.0, 500000.0, 2000000.0, 0.669042879931159, -1.9460421159736754, 0.7094763409356942, 0.6809692964864535);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32144L, 4269L, 1.0, 500000.0, 3000000.0, 0.6399540590645868, -1.9460421159736754, 0.6693337681398247, 0.6495533699505557);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32146L, 4269L, 1.0, 3500000.0, 2000000.0, 0.6574073515845301, -1.3700834628155474, 0.6841690667817765, 0.663806892175176);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32147L, 4269L, 1.0, 3500000.0, 1000000.0, 0.6341362948912724, -1.3700834628155474, 0.6626433393405131, 0.6416993883165811);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32148L, 4269L, 1.0, 500000.0, 0.0, 0.820304748437334, -2.1089395128264794, 0.850557122138569, 0.8290313946973057);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32149L, 4269L, 1.0, 500000.0, 0.0, 0.791215927570762, -2.103121748653165, 0.8261225126106485, 0.7999425738307335);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32150L, 4269L, 1.0, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.7024950239277169, 0.6806784082777878);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32151L, 4269L, 1.0, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6786421908171277, 0.6542075812892072);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32152L, 4269L, 1.0, 600000.0, 0.0, 0.7883070454841047, -1.570796326794895, 0.816232313516014, 0.795288362492082);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32153L, 4269L, 1.0, 600000.0, 0.0, 0.765035988790847, -1.570796326794895, 0.7941248096574192, 0.7723081940074901);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32154L, 4269L, 1.0, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7691084237121671, 0.7458373670189095);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32161L, 4269L, 1.0, 200000.0, 200000.0, 0.3112503832723218, -1.159480399741565, 0.32172235878428773, 0.31474104177631046);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32198L, 4269L, 1.0, 0.0, 0.0, 0.7679448708775042, -1.1955505376161146, 1.0471975511965967, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32199L, 4269L, 1.0, 1000000.0, 0.0, 0.4450589592585536, -1.5940673834881527, 0.48578330847175455, 0.45669448760518244);
        LambertConformalConicSrid.registerLambertConformalConicSrid(32777L, 2000012L, 1.0, 0.0, 0.0, -0.17453292519943278, 2.338741197672399, -0.314159265358979, -0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40960L, 2000011L, 3.2808333333333333, 914401.8288036576, 0.0, 0.8901179185171072, -3.0717794835100167, 0.9046623289498115, 0.939568913989698);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40961L, 2000028L, 3.2808333333333333, 999999.99998984, 0.0, 0.8901179185171072, -3.0717794835100167, 0.9046623289498115, 0.939568913989698);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40962L, 2000028L, 1.0, 1000000.0, 0.0, 0.8901179185171072, -3.0717794835100167, 0.9046623289498115, 0.939568913989698);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40963L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5992297098508041, -1.6057029118347816, 0.60970168536277, 0.6323909656386963);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40964L, 2000006L, 3.2808333333333333, 399999.99998983997, 0.0, 0.5992297098508041, -1.6057029118347816, 0.60970168536277, 0.6323909656386963);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40965L, 2000006L, 1.0, 400000.0, 0.0, 0.5992297098508041, -1.6057029118347816, 0.60970168536277, 0.6323909656386963);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40966L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5701408889853955, -1.6057029118347816, 0.5811946409141111, 0.6067928032772764);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40967L, 2000006L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.5701408889853955, -1.6057029118347816, 0.5811946409141111, 0.6067928032772764);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40968L, 2000006L, 1.0, 400000.0, 400000.0, 0.5701408889853955, -1.6057029118347816, 0.5811946409141111, 0.6067928032772764);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40969L, 2000030L, 1.0, 150000.0, 5400000.0, 1.570796326794895, 0.07623554539479924, 0.8697557439099249, 0.8930268006043461);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40970L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724505205, -2.1293016874330797, 0.6981317007977311, 0.727220521664885);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40971L, 2000006L, 3.2808333333333333, 2000000.00001016, 500000.00001016003, 0.6864961724505205, -2.1293016874330797, 0.6981317007977311, 0.727220521664885);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40972L, 2000006L, 1.0, 2000000.0, 500000.0, 0.6864961724505205, -2.1293016874330797, 0.6981317007977311, 0.727220521664885);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40973L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6574073515851119, -2.1293016874330797, 0.6690428799305772, 0.6952228187104921);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40974L, 2000006L, 3.2808333333333333, 2000000.00001016, 500000.00001016003, 0.6574073515851119, -2.1293016874330797, 0.6690428799305772, 0.6952228187104921);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40975L, 2000006L, 1.0, 2000000.0, 500000.0, 0.6574073515851119, -2.1293016874330797, 0.6690428799305772, 0.6952228187104921);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40976L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6370451769779296, -2.103121748653165, 0.6469353760731459, 0.6707882091825715);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40977L, 2000006L, 3.2808333333333333, 2000000.00001016, 500000.00001016003, 0.6370451769779296, -2.103121748653165, 0.6469353760731459, 0.6707882091825715);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40978L, 2000006L, 1.0, 2000000.0, 500000.0, 0.6370451769779296, -2.103121748653165, 0.6469353760731459, 0.6707882091825715);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40979L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6166830023707474, -2.07694180987325, 0.628318530717958, 0.650135146367887);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40980L, 2000006L, 3.2808333333333333, 2000000.00001016, 500000.00001016003, 0.6166830023707474, -2.07694180987325, 0.628318530717958, 0.650135146367887);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40981L, 2000006L, 1.0, 2000000.0, 500000.0, 0.6166830023707474, -2.07694180987325, 0.628318530717958, 0.650135146367887);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40982L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5846852994180998, -2.059488517353307, 0.5939937220948212, 0.6190101080412367);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40983L, 2000006L, 3.2808333333333333, 2000000.00001016, 500000.00001016003, 0.5846852994180998, -2.059488517353307, 0.5939937220948212, 0.6190101080412367);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40984L, 2000006L, 1.0, 2000000.0, 500000.0, 0.5846852994180998, -2.059488517353307, 0.5939937220948212, 0.6190101080412367);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40985L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5614142427254238, -2.028945255443406, 0.5721771064448921, 0.5913757282168296);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40986L, 2000006L, 3.2808333333333333, 2000000.00001016, 500000.00001016003, 0.5614142427254238, -2.028945255443406, 0.5721771064448921, 0.5913757282168296);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40987L, 2000006L, 1.0, 2000000.0, 500000.0, 0.5614142427254238, -2.028945255443406, 0.5721771064448921, 0.5913757282168296);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40988L, 2000007L, 3.2808333333333333, 1276106.4103937007, 1268252.966898654, 0.5957390513468155, -2.0653062815260395, 0.5910848400093275, 0.6006841508952963);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40989L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724505205, -1.841322360854016, 0.6931866012509956, 0.7118034466044383);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40990L, 2000006L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6864961724505205, -1.841322360854016, 0.6931866012509956, 0.7118034466044383);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40991L, 2000006L, 1.0, 914401.8289, 304800.6096, 0.6864961724505205, -1.841322360854016, 0.6931866012509956, 0.7118034466044383);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40992L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6603162336706055, -1.841322360854016, 0.671079097391819, 0.6937683776677452);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40993L, 2000006L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6603162336706055, -1.841322360854016, 0.671079097391819, 0.6937683776677452);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40994L, 2000006L, 1.0, 914401.8289, 304800.6096, 0.6603162336706055, -1.841322360854016, 0.671079097391819, 0.6937683776677452);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40995L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6399540590651687, -1.841322360854016, 0.6498442581586396, 0.6707882091825715);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40996L, 2000006L, 3.2808333333333333, 914401.8288036576, 304800.6096012192, 0.6399540590651687, -1.841322360854016, 0.6498442581586396, 0.6707882091825715);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40997L, 2000006L, 1.0, 914401.8289, 304800.6096, 0.6399540590651687, -1.841322360854016, 0.6498442581586396, 0.6707882091825715);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40998L, 2000002L, 6.213711922373339E-4, 0.0, 0.0, 0.6981317007977311, 1.6580627893946114, 0.34906585039886556, 1.0471975511965967);
        LambertConformalConicSrid.registerLambertConformalConicSrid(40999L, 2000002L, 6.213711922373339E-4, 0.0, 0.0, -0.17453292519943278, 2.3125612588924844, -0.3752457891787805, -0.5846852994180998);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41000L, 2000002L, 6.213711922373339E-4, 0.0, 0.0, 0.17453292519943278, 1.9198621771937605, 0.43633231299858194, 0.6981317007977311);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41001L, 2000002L, 6.213711922373339E-4, 0.0, 0.0, 0.6108652381980147, 0.43633231299858194, 0.6981317007977311, 1.1344640137963131);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41002L, 2000002L, 6.213711922373339E-4, 0.0, 0.0, 0.43633231299858194, 0.8290313946973057, 0.2617993877991492, 0.6108652381980147);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41003L, 2000007L, 1.0, 0.0, 0.0, 0.4014257279586954, -1.6755160819145547, 0.34906585039886556, 1.0471975511965967);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41004L, 2000007L, 1.0, 0.0, 0.0, 0.4014257279586954, -1.6755160819145547, 0.5759586531581282, 0.7853981633974475);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41005L, 2000007L, 3.2808333333333333, 182880.3657607315, 0.0, 0.7126761112304354, -1.2697270308258735, 0.719075651821663, 0.7307111801688737);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41006L, 2000006L, 3.2808333333333333, 304800.6096012192, 152400.3048006096, 0.7126761112304354, -1.2697270308258735, 0.719075651821663, 0.7307111801688737);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41007L, 2000006L, 1.0, 304800.6096, 152400.3048, 0.7126761112304354, -1.2697270308258735, 0.719075651821663, 0.7307111801688737);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41008L, 2000006L, 3.2808333333333333, 699999.99998984, 3000000.0, 0.5177810114255657, -1.7511470161670604, 0.5256349930595402, 0.5564691431769431);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41009L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.506145483078355, -1.474803217935207, 0.5163265703810735, 0.5366887449882558);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41010L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5163265703810735, 0.5366887449882558);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41011L, 2000006L, 1.0, 600000.0, 0.0, 0.506145483078355, -1.474803217935207, 0.5163265703810735, 0.5366887449882558);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41012L, 2000008L, 1.0, 600000.0, 1200000.0, 0.8639379797371922, 0.0, 0.8482042379561914, 0.8795745939453197);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41013L, 2000008L, 1.0, 600000.0, 200000.0, 0.8639379797371922, 0.0, 0.8482042379561914, 0.8795745939453197);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41014L, 2000008L, 1.0, 600000.0, 2200000.0, 0.8168140899333454, 0.0, 0.8010872596561824, 0.8324525018306024);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41015L, 2000008L, 1.0, 600000.0, 200000.0, 0.8168140899333454, 0.0, 0.8010872596561824, 0.8324525018306024);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41016L, 2000008L, 1.0, 600000.0, 3200000.0, 0.7696902001294985, 0.0, 0.7539698624771529, 0.7853299908368646);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41017L, 2000008L, 1.0, 600000.0, 200000.0, 0.7696902001294985, 0.0, 0.7539698624771529, 0.7853299908368646);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41018L, 2000008L, 1.0, 234.358, 4185861.369, 0.7359180791034083, 0.0, 0.7253656090063404, 0.7464365327333549);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41019L, 2000008L, 1.0, 234.358, 185861.369, 0.7359180791034083, 0.0, 0.7253656090063404, 0.7464365327333549);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41020L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.724311639577646, -1.6318828506146965, 0.7342018386728624, 0.7551457896967942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41021L, 2000006L, 3.2808333333333333, 1500000.0, 999999.99998984, 0.724311639577646, -1.6318828506146965, 0.7342018386728624, 0.7551457896967942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41022L, 2000006L, 1.0, 1500000.0, 1000000.0, 0.724311639577646, -1.6318828506146965, 0.7342018386728624, 0.7551457896967942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41023L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7088945645189446, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41024L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7088945645189446, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41025L, 2000006L, 1.0, 500000.0, 0.0, 0.6981317007977311, -1.6318828506146965, 0.7088945645189446, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41026L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6690428799305772, -1.7104226669544411, 0.6757333087310523, 0.694350154084495);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41027L, 2000006L, 3.2808333333333333, 399999.99998983997, 0.0, 0.6690428799305772, -1.7104226669544411, 0.6757333087310523, 0.694350154084495);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41028L, 2000006L, 1.0, 400000.0, 0.0, 0.6690428799305772, -1.7104226669544411, 0.6757333087310523, 0.694350154084495);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41029L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6399540590651687, -1.7191493132144129, 0.6731153148530609, 0.6504260345771345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41030L, 2000006L, 3.2808333333333333, 399999.99998983997, 399999.99998983997, 0.6399540590651687, -1.7191493132144129, 0.6731153148530609, 0.6504260345771345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41031L, 2000006L, 1.0, 400000.0, 400000.0, 0.6399540590651687, -1.7191493132144129, 0.6731153148530609, 0.6504260345771345);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41032L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393410949, 0.6800966318610382);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41033L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393410949, 0.6800966318610382);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41034L, 2000006L, 1.0, 500000.0, 0.0, 0.6544984694978729, -1.470439894805221, 0.6626433393410949, 0.6800966318610382);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41035L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6341362948906907, -1.4966198335851362, 0.641117611898668, 0.6620615629225999);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41036L, 2000006L, 3.2808333333333333, 500000.00001016003, 500000.00001016003, 0.6341362948906907, -1.4966198335851362, 0.641117611898668, 0.6620615629225999);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41037L, 2000006L, 1.0, 500000.0, 500000.0, 0.6341362948906907, -1.4966198335851362, 0.641117611898668, 0.6620615629225999);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41038L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.535234303945509, -1.6144295580947532, 0.5439609502054806, 0.5701408889853955);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41039L, 2000006L, 3.2808333333333333, 999999.99998984, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5439609502054806, 0.5701408889853955);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41040L, 2000006L, 1.0, 1000000.0, 0.0, 0.5323254218582699, -1.6144295580947532, 0.5439609502054806, 0.5701408889853955);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41041L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5003277189056224, -1.594067383487571, 0.511381470834338, 0.5352924815866603);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41042L, 2000006L, 3.2808333333333333, 999999.99998984, 0.0, 0.4974188368183834, -1.594067383487571, 0.511381470834338, 0.5358160803622586);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41043L, 2000006L, 1.0, 1000000.0, 0.0, 0.4974188368183834, -1.594067383487571, 0.511381470834338, 0.5358160803622586);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41044L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.4479678413457926, -1.594067383487571, 0.4566944876057642, 0.4857833084711728);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41045L, 2000006L, 3.2808333333333333, 999999.99998984, 0.0, 0.4450589592585536, -1.594067383487571, 0.4566944876057642, 0.4857833084711728);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41046L, 2000006L, 1.0, 1000000.0, 0.0, 0.4450589592585536, -1.594067383487571, 0.4566944876057642, 0.4857833084711728);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41047L, 2000007L, 3.2808333333333333, 243840.48768097535, 0.0, 0.6603162336706055, -1.3439035240356323, 0.6684611035138276, 0.6885323899117624);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41048L, 2000006L, 3.2808333333333333, 399999.99998983997, 0.0, 0.6574073515851119, -1.3439035240356323, 0.6684611035138276, 0.6885323899117624);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41049L, 2000006L, 1.0, 400000.0, 0.0, 0.6574073515851119, -1.3439035240356323, 0.6684611035138276, 0.6885323899117624);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41050L, 2000007L, 3.2808333333333333, 182880.3657607315, 0.0, 0.7155849933176743, -1.2479104151759444, 0.7280931862908822, 0.7449647023923305);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41051L, 2000006L, 3.2808333333333333, 200000.00001016003, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7280931862908822, 0.7449647023923305);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41052L, 2000006L, 1.0, 200000.0, 750000.0, 0.7155849933176743, -1.2479104151759444, 0.7280931862908822, 0.7449647023923305);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41053L, 2000007L, 3.2808333333333333, 243840.48768097535, 0.0, 0.7155849933176743, -1.230457122656001, 0.7205300928644098, 0.7240207513683985);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41054L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.7155849933176743, -1.230457122656001, 0.7205300928644098, 0.7240207513683985);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41055L, 2000006L, 1.0, 500000.0, 0.0, 0.7155849933176743, -1.230457122656001, 0.7205300928644098, 0.7240207513683985);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41056L, 2000009L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7816166166842113, -1.5184364492350653, 0.7938339214481717, 0.8217591894800809);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41057L, 2000006L, 3.2808333333333333, 8000000.00001016, 0.0, 0.7816166166842113, -1.5184364492350653, 0.7938339214481717, 0.8217591894800809);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41058L, 2000006L, 3.2808398950131235, 7999999.99999848, 0.0, 0.7816166166842113, -1.5184364492350653, 0.7938339214481717, 0.8217591894800809);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41059L, 2000006L, 1.0, 8000000.0, 0.0, 0.7816166166842113, -1.5184364492350653, 0.7938339214481717, 0.8217591894800809);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41060L, 2000009L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7560184543227915, -1.471894335847968, 0.7711446411722453, 0.7976154681614078);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41061L, 2000006L, 3.2808333333333333, 6000000.0, 0.0, 0.7560184543227915, -1.472476112266463, 0.7711446411722453, 0.7976154681614078);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41062L, 2000006L, 3.2808398950131235, 6000000.00000648, 0.0, 0.7560184543227915, -1.472476112266463, 0.7711446411722453, 0.7976154681614078);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41063L, 2000006L, 1.0, 6000000.0, 0.0, 0.7560184543227915, -1.472476112266463, 0.7711446411722453, 0.7976154681614078);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41064L, 2000009L, 3.2808333333333333, 609601.2192024384, 0.0, 0.724311639577646, -1.471894335847968, 0.734783615089612, 0.7621271067047716);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41065L, 2000006L, 3.2808333333333333, 3999999.99998984, 0.0, 0.724311639577646, -1.472476112266463, 0.734783615089612, 0.7621271067047716);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41066L, 2000006L, 3.2808398950131235, 4000000.00001448, 0.0, 0.724311639577646, -1.472476112266463, 0.734783615089612, 0.7621271067047716);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41067L, 2000006L, 1.0, 4000000.0, 0.0, 0.724311639577646, -1.472476112266463, 0.734783615089612, 0.7621271067047716);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41068L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.8115781021773624, -1.6249015336067192, 0.8208865248540838, 0.848811792885993);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41069L, 2000006L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.8115781021773624, -1.6249015336067192, 0.8208865248540838, 0.848811792885993);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41070L, 2000006L, 1.0, 800000.0, 100000.0, 0.8115781021773624, -1.6249015336067192, 0.8208865248540838, 0.848811792885993);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41071L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7853981633974475, -1.6449728200046538, 0.796161027118661, 0.8211774130633313);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41072L, 2000006L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7853981633974475, -1.6449728200046538, 0.796161027118661, 0.8211774130633313);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41073L, 2000006L, 1.0, 800000.0, 100000.0, 0.7853981633974475, -1.6449728200046538, 0.796161027118661, 0.8211774130633313);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41074L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.750491578357561, -1.640609496874668, 0.764163324164268, 0.7891797101106837);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41075L, 2000006L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.750491578357561, -1.640609496874668, 0.764163324164268, 0.7891797101106837);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41076L, 2000006L, 1.0, 800000.0, 100000.0, 0.750491578357561, -1.640609496874668, 0.764163324164268, 0.7891797101106837);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41077L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7723081940074901, -1.911135530933789, 0.7853981633974475, 0.8552113334772206);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41078L, 2000006L, 3.2808398950131235, 599999.9999976, 0.0, 0.7723081940074901, -1.911135530933789, 0.7853981633974475, 0.8552113334772206);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41079L, 2000006L, 1.0, 600000.0, 0.0, 0.7723081940074901, -1.911135530933789, 0.7853981633974475, 0.8552113334772206);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41080L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.820304748437334, -1.911135530933789, 0.8351400470792858, 0.8502662339304852);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41081L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7999425738301518, -1.911135530933789, 0.8107054375513653, 0.8357218234960355);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41082L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7679448708775042, -1.911135530933789, 0.7830710577287036, 0.809832772925368);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41083L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.6952228187104921, -1.7453292519943278, 0.6981317007977311, 0.750491578357561);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41084L, 2000006L, 1.0, 500000.0, 0.0, 0.6952228187104921, -1.7453292519943278, 0.6981317007977311, 0.750491578357561);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41085L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.721402757490407, -1.7453292519943278, 0.7304202919596262, 0.7472918080628198);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41086L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6923139366249985, -1.7366026057343562, 0.7030768003444666, 0.7280931862908822);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41087L, 2000007L, 3.2808333333333333, 609601.2192024384, 30480.06096012192, 0.7068583470577028, -1.2915436464758026, 0.7097672291449417, 0.7161667697344241);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41088L, 2000006L, 3.2808333333333333, 300000.0, 0.0, 0.7010405828849701, -1.2915436464758026, 0.7097672291449417, 0.7161667697344241);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41089L, 2000006L, 1.0, 300000.0, 0.0, 0.7010405828849701, -1.2915436464758026, 0.7097672291449417, 0.7161667697344241);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41090L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.5992297098508041, 0.631227412805197);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41091L, 2000006L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5890486225480857, -1.378810109075519, 0.5992297098508041, 0.631227412805197);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41092L, 2000006L, 1.0, 609601.219202, 0.0, 0.5890486225480857, -1.378810109075519, 0.5992297098508041, 0.631227412805197);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41093L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.820304748437334, -1.7540558982542993, 0.8278678418620611, 0.8505571221379873);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41094L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.820304748437334, -1.7540558982542993, 0.8278678418620611, 0.8505571221379873);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41095L, 2000006L, 1.0, 600000.0, 0.0, 0.820304748437334, -1.7540558982542993, 0.8278678418620611, 0.8505571221379873);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41096L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7970336917446581, -1.7540558982542993, 0.806051226212132, 0.8287405064880582);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41097L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7970336917446581, -1.7540558982542993, 0.806051226212132, 0.8287405064880582);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41098L, 2000006L, 1.0, 600000.0, 0.0, 0.7970336917446581, -1.7540558982542993, 0.806051226212132, 0.8287405064880582);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41099L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6923139366249985, -1.4398966328953204, 0.7056947942224581, 0.7278022980816347);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41100L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.6923139366249985, -1.4398966328953204, 0.7056947942224581, 0.7278022980816347);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41101L, 2000006L, 1.0, 600000.0, 0.0, 0.6923139366249985, -1.4398966328953204, 0.7056947942224581, 0.7278022980816347);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41102L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6760241969385545, 0.6987134772144807);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41103L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6760241969385545, 0.6987134772144807);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41104L, 2000006L, 1.0, 600000.0, 0.0, 0.6632251157578446, -1.4398966328953204, 0.6760241969385545, 0.6987134772144807);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41105L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6108652381980147, -1.7104226669544411, 0.620755437293231, 0.641699388317163);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41106L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.620755437293231, 0.641699388317163);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41107L, 2000006L, 1.0, 600000.0, 0.0, 0.6108652381980147, -1.7104226669544411, 0.620755437293231, 0.641699388317163);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41108L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5817764173308608, -1.7104226669544411, 0.5922483928428268, 0.614937673118753);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41109L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.5817764173308608, -1.7104226669544411, 0.5922483928428268, 0.614937673118753);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41110L, 2000006L, 1.0, 600000.0, 0.0, 0.5817764173308608, -1.7104226669544411, 0.5922483928428268, 0.614937673118753);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41111L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7621271067047716, -2.103121748653165, 0.7737626350502369, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41112L, 2000006L, 3.2808333333333333, 2499999.99998984, 0.0, 0.7621271067047716, -2.103121748653165, 0.7737626350502369, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41113L, 2000006L, 3.2808398950131235, 2499999.99999, 0.0, 0.7621271067047716, -2.103121748653165, 0.7737626350502369, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41114L, 2000006L, 1.0, 2500000.0, 0.0, 0.7621271067047716, -2.103121748653165, 0.7737626350502369, 0.8028514559173908);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41115L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.727220521664885, -2.103121748653165, 0.7388560500103503, 0.7679448708775042);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41116L, 2000006L, 3.2808333333333333, 1500000.0, 0.0, 0.727220521664885, -2.103121748653165, 0.7388560500103503, 0.7679448708775042);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41117L, 2000006L, 3.2808398950131235, 1499999.999994, 0.0, 0.727220521664885, -2.103121748653165, 0.7388560500103503, 0.7679448708775042);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41118L, 2000006L, 1.0, 1500000.0, 0.0, 0.727220521664885, -2.103121748653165, 0.7388560500103503, 0.7679448708775042);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41119L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7010405828849701, -1.3569934934255898, 0.7135487758564326, 0.7321656212116205);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41120L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7010405828849701, -1.3569934934255898, 0.7135487758564326, 0.7321656212116205);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41121L, 2000006L, 1.0, 600000.0, 0.0, 0.7010405828849701, -1.3569934934255898, 0.7135487758564326, 0.7321656212116205);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41122L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6864961724505205, -1.3569934934255898, 0.6969681479624864, 0.7150032169009247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41123L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.6864961724505205, -1.3569934934255898, 0.6969681479624864, 0.7150032169009247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41124L, 2000006L, 1.0, 600000.0, 0.0, 0.6864961724505205, -1.3569934934255898, 0.6969681479624864, 0.7150032169009247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41125L, 2000006L, 3.2808333333333333, 200000.00001016003, 200000.00001016003, 0.31125038327174, -1.1594803997409833, 0.31474104177572865, 0.321722358783706);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41126L, 2000006L, 1.0, 200000.0, 200000.0, 0.31125038327174, -1.1594803997409833, 0.31474104177572865, 0.321722358783706);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41127L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.321722358783706, -1.1594803997409833, 0.31474104177572865, 0.321722358783706);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41128L, 2000007L, 3.2808333333333333, 152400.3048006096, 30480.06096012192, 0.321722358783706, -1.1594803997409833, 0.31474104177572865, 0.321722358783706);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41129L, 2000006L, 3.2808333333333333, 609600.0, 0.0, 0.5555964785509458, -1.4137166941154056, 0.5672320068981566, 0.6079563561107757);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41130L, 2000006L, 3.2808398950131235, 609600.0, 0.0, 0.5555964785509458, -1.4137166941154056, 0.5672320068981566, 0.6079563561107757);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41131L, 2000006L, 1.0, 609600.0, 0.0, 0.5555964785509458, -1.4137166941154056, 0.5672320068981566, 0.6079563561107757);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41132L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5759586531581282, -1.4137166941154056, 0.5893395107573332, 0.610283461781265);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41133L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5555964785509458, -1.4137166941154056, 0.5643231248109175, 0.5875941815053388);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41134L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7650359887902652, -1.7453292519943278, 0.775217076094729, 0.7973245799521603);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41135L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7650359887902652, -1.7453292519943278, 0.775217076094729, 0.7973245799521603);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41136L, 2000006L, 1.0, 600000.0, 0.0, 0.7650359887902652, -1.7453292519943278, 0.775217076094729, 0.7973245799521603);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41137L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7388560500103503, -1.7511470161670604, 0.7475826962703219, 0.7749261878854815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41138L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7388560500103503, -1.7511470161670604, 0.7475826962703219, 0.7749261878854815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41139L, 2000006L, 1.0, 600000.0, 0.0, 0.7388560500103503, -1.7511470161670604, 0.7475826962703219, 0.7749261878854815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41140L, 2000007L, 3.2808333333333333, 609601.2192024384, 30480.06096012192, 0.605047474025282, -1.500983156715122, 0.6152285613280005, 0.6355907359351828);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41141L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.5992297098508041, -1.500983156715122, 0.6152285613280005, 0.6355907359351828);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41142L, 2000006L, 1.0, 600000.0, 0.0, 0.5992297098508041, -1.500983156715122, 0.6152285613280005, 0.6355907359351828);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41143L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5934119456780714, -1.7715091907742426, 0.6047565858160345, 0.6315183010126991);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41144L, 2000006L, 3.2808333333333333, 200000.00001016003, 999999.99998984, 0.5934119456780714, -1.7715091907742426, 0.6047565858160345, 0.6315183010126991);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41145L, 2000006L, 1.0, 200000.0, 1000000.0, 0.5934119456780714, -1.7715091907742426, 0.6047565858160345, 0.6315183010126991);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41146L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5526875964654523, -1.7016960206944696, 0.5608324663069288, 0.5928301692613218);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41147L, 2000006L, 3.2808333333333333, 600000.0, 2000000.00001016, 0.5526875964654523, -1.7191493132144129, 0.5608324663069288, 0.5928301692613218);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41148L, 2000006L, 1.0, 600000.0, 2000000.0, 0.5526875964654523, -1.7191493132144129, 0.5608324663069288, 0.5928301692613218);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41149L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.5177810114255657, -1.7511470161670604, 0.5256349930595402, 0.5564691431769431);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41150L, 2000006L, 3.2808333333333333, 699999.99998984, 3000000.0, 0.5177810114255657, -1.7511470161670604, 0.5256349930595402, 0.5564691431769431);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41151L, 2000006L, 1.0, 700000.0, 3000000.0, 0.5177810114255657, -1.7511470161670604, 0.5256349930595402, 0.5564691431769431);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41152L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.4857833084711728, -1.7278759594743844, 0.4953826193571416, 0.5285438751450339);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41153L, 2000006L, 3.2808333333333333, 600000.0, 3999999.99998984, 0.4857833084711728, -1.7278759594743844, 0.4953826193571416, 0.5285438751450339);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41154L, 2000006L, 1.0, 600000.0, 4000000.0, 0.4857833084711728, -1.7278759594743844, 0.4953826193571416, 0.5285438751450339);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41155L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.4479678413457926, -1.7191493132144129, 0.4566944876057642, 0.4857833084711728);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41156L, 2000006L, 3.2808333333333333, 300000.0, 5000000.00001016, 0.4479678413457926, -1.7191493132144129, 0.4566944876057642, 0.4857833084711728);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41157L, 2000006L, 1.0, 300000.0, 5000000.0, 0.4479678413457926, -1.7191493132144129, 0.4566944876057642, 0.4857833084711728);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41158L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7039494649704637, -1.9460421159736754, 0.710639893770939, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41159L, 2000006L, 3.2808333333333333, 500000.00001016003, 999999.99998984, 0.7039494649704637, -1.9460421159736754, 0.710639893770939, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41160L, 2000006L, 3.2808398950131235, 499999.999998, 999999.999996, 0.7039494649704637, -1.9460421159736754, 0.710639893770939, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41161L, 2000006L, 1.0, 500000.0, 1000000.0, 0.7039494649704637, -1.9460421159736754, 0.710639893770939, 0.7292567391243815);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41162L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6690428799305772, -1.9460421159736754, 0.6809692964870353, 0.7094763409356942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41163L, 2000006L, 3.2808333333333333, 500000.00001016003, 2000000.00001016, 0.6690428799305772, -1.9460421159736754, 0.6809692964870353, 0.7094763409356942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41164L, 2000006L, 3.2808398950131235, 499999.999998, 1999999.999992, 0.6690428799305772, -1.9460421159736754, 0.6809692964870353, 0.7094763409356942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41165L, 2000006L, 1.0, 500000.0, 2000000.0, 0.6690428799305772, -1.9460421159736754, 0.6809692964870353, 0.7094763409356942);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41166L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6399540590651687, -1.9460421159736754, 0.6495533699511374, 0.6693337681398247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41167L, 2000006L, 3.2808333333333333, 500000.00001016003, 3000000.0, 0.6399540590651687, -1.9460421159736754, 0.6495533699511374, 0.6693337681398247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41168L, 2000006L, 3.2808398950131235, 499999.999998, 2999999.999988, 0.6399540590651687, -1.9460421159736754, 0.6495533699511374, 0.6693337681398247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41169L, 2000006L, 1.0, 500000.0, 3000000.0, 0.6399540590651687, -1.9460421159736754, 0.6495533699511374, 0.6693337681398247);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41170L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6574073515851119, -1.3700834628155474, 0.6638068921745942, 0.6841690667817765);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41171L, 2000006L, 3.2808333333333333, 3500000.00001016, 2000000.00001016, 0.6574073515851119, -1.3700834628155474, 0.6638068921745942, 0.6841690667817765);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41172L, 2000006L, 1.0, 3500000.0, 2000000.0, 0.6574073515851119, -1.3700834628155474, 0.6638068921745942, 0.6841690667817765);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41173L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6341362948906907, -1.3700834628155474, 0.641699388317163, 0.6626433393410949);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41174L, 2000006L, 3.2808333333333333, 3500000.00001016, 999999.99998984, 0.6341362948906907, -1.3700834628155474, 0.641699388317163, 0.6626433393410949);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41175L, 2000006L, 1.0, 3500000.0, 1000000.0, 0.6341362948906907, -1.3700834628155474, 0.641699388317163, 0.6626433393410949);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41176L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.820304748437334, -2.1089395128258976, 0.8290313946973057, 0.8505571221379873);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41177L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.820304748437334, -2.1089395128258976, 0.8290313946973057, 0.8505571221379873);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41178L, 2000006L, 1.0, 500000.0, 0.0, 0.820304748437334, -2.1089395128258976, 0.8290313946973057, 0.8505571221379873);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41179L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7912159275701801, -2.103121748653165, 0.7999425738301518, 0.8261225126100668);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41180L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.7912159275701801, -2.103121748653165, 0.7999425738301518, 0.8261225126100668);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41181L, 2000006L, 1.0, 500000.0, 0.0, 0.7912159275701801, -2.103121748653165, 0.7999425738301518, 0.8261225126100668);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41182L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6719517620178161, -1.3875367553354905, 0.6806784082777878, 0.7024950239277169);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41183L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.6806784082777878, 0.7024950239277169);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41184L, 2000006L, 1.0, 600000.0, 0.0, 0.6719517620178161, -1.3875367553354905, 0.6806784082777878, 0.7024950239277169);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41185L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6542075812886254, 0.678642190816546);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41186L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6542075812886254, 0.678642190816546);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41187L, 2000006L, 1.0, 600000.0, 0.0, 0.6457718232379013, -1.4137166941154056, 0.6542075812886254, 0.678642190816546);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41188L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7883070454846864, -1.570796326794895, 0.7952883624926638, 0.8162323135165958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41189L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7883070454846864, -1.570796326794895, 0.7952883624926638, 0.8162323135165958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41190L, 2000006L, 1.0, 600000.0, 0.0, 0.7883070454846864, -1.570796326794895, 0.7952883624926638, 0.8162323135165958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41191L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7650359887902652, -1.570796326794895, 0.7723081940074901, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41192L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7650359887902652, -1.570796326794895, 0.7723081940074901, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41193L, 2000006L, 1.0, 600000.0, 0.0, 0.7650359887902652, -1.570796326794895, 0.7723081940074901, 0.7941248096574192);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41194L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.7330382858376177, -1.570796326794895, 0.7458373670183276, 0.7691084237127489);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41195L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7458373670183276, 0.7691084237127489);
        LambertConformalConicSrid.registerLambertConformalConicSrid(41196L, 2000006L, 1.0, 600000.0, 0.0, 0.7330382858376177, -1.570796326794895, 0.7458373670183276, 0.7691084237127489);
        LambertConformalConicSrid.registerLambertConformalConicSrid(82472L, 8314L, 1.0, 2500000.0, 4500000.0, -0.6457718232379013, 2.5307274153917754, -0.628318530717958, -0.6632251157578446);
        LambertConformalConicSrid.registerLambertConformalConicSrid(82473L, 2000012L, 1.0, 2500000.0, 2500000.0, -0.6457718232379013, 2.5307274153917754, -0.628318530717958, -0.6632251157578446);
        LambertConformalConicSrid.registerLambertConformalConicSrid(82475L, 2000012L, 1.0, 1000000.0, 2000000.0, -0.5585053606381849, 2.3561944901923426, -0.4886921905584118, -0.628318530717958);
        LambertConformalConicSrid.registerLambertConformalConicSrid(557056L, 2000006L, 3.2808333333333333, 699999.99998984, 3000000.0, 0.5177810114255657, -1.7511470161670604, 0.5256349930595402, 0.5564691431769431);
    }

    private static void loadTransverseMercatorSRIDs1() {
        TransverseMercatorSrid.registerTransverseMercatorSrid(2000L, 4600L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2001L, 4601L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2002L, 4602L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2003L, 4603L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2004L, 4604L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2005L, 4605L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2006L, 4606L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2007L, 4607L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2008L, 4609L, 1.0, 304800.0, 0.0, 0.0, -0.9686577348568519, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2009L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2010L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2011L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2012L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2013L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.230457122656001, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2014L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2015L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2016L, 4609L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2017L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2018L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2019L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2020L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.4398966328953204, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2021L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.4137166941154056, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2022L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.4660765716752353, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2023L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.5184364492350653, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2024L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.570796326794895, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2025L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.6231562043547247, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2026L, 4608L, 1.0, 304800.0, 0.0, 0.0, -1.6755160819145547, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2027L, 4608L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2028L, 4608L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2029L, 4608L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2030L, 4608L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2031L, 4609L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032L, 4609L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2033L, 4609L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2034L, 4609L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2035L, 4609L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2037L, 4140L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2038L, 4140L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2039L, 4141L, 1.0, 219529.584, 626907.39, 0.5538696546377413, 0.6144347322546886, 1.0000067);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2040L, 4142L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2041L, 4143L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2042L, 4142L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2043L, 4143L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2044L, 4147L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2045L, 4147L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2058L, 4154L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2059L, 4154L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2060L, 4154L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2061L, 4154L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2063L, 4315L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2064L, 4315L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2067L, 4158L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2068L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.1570796326794895, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2069L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.19198621771937605, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2070L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.2268928027592626, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2071L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2072L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.2967059728390357, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2073L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.3316125578789223, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2074L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.3665191429188088, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2075L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.4014257279586954, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2076L, 4159L, 1.0, 200000.0, 0.0, 0.0, 0.43633231299858194, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2077L, 4159L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2078L, 4159L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2079L, 4159L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2080L, 4159L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2081L, 4160L, 1.0, 2500000.0, 0.0, -1.570796326794895, -1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2082L, 4161L, 1.0, 2500000.0, 0.0, -1.570796326794895, -1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2083L, 4254L, 1.0, 2500000.0, 0.0, -1.570796326794895, -1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2084L, 4254L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2087L, 4159L, 1.0, 500000.0, 0.0, 0.0, 0.20943951023931934, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2088L, 4223L, 1.0, 500000.0, 0.0, 0.0, 0.19198621771937605, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2089L, 4163L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2090L, 4163L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2091L, 4164L, 1.0, 8500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2092L, 4164L, 1.0, 9500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2093L, 4147L, 1.0, 500000.0, 0.0, 0.0, 1.8500490071139875, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2094L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.8500490071139875, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2095L, 4165L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2096L, 4162L, 1.0, 200000.0, 500000.0, 0.6632251157578446, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2097L, 4162L, 1.0, 200000.0, 500000.0, 0.6632251157578446, 2.216568150032796, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2098L, 4162L, 1.0, 200000.0, 500000.0, 0.6632251157578446, 2.18166156499291, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2100L, 4121L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2105L, 4167L, 1.0, 400000.0, 800000.0, -0.643672579998697, 3.050210122837454, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2106L, 4167L, 1.0, 400000.0, 800000.0, -0.6590557181003025, 3.079914657079035, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2107L, 4167L, 1.0, 400000.0, 800000.0, -0.6741237273091869, 3.1046886361837323, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2108L, 4167L, 1.0, 400000.0, 800000.0, -0.6920375928261843, 3.083536215276923, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2109L, 4167L, 1.0, 400000.0, 800000.0, -0.6830442990416024, 3.0408483706552287, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2110L, 4167L, 1.0, 400000.0, 800000.0, -0.6896183725574476, 3.065496298202837, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2111L, 4167L, 1.0, 400000.0, 800000.0, -0.7023544279601952, 3.0628443673671684, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2112L, 4167L, 1.0, 400000.0, 800000.0, -0.7142808445154898, 3.0656223497599258, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2113L, 4167L, 1.0, 400000.0, 800000.0, -0.7208403736209018, 3.050423440857142, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2114L, 4167L, 1.0, 400000.0, 800000.0, -0.7106059568126795, 3.0136939563762835, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2115L, 4167L, 1.0, 400000.0, 800000.0, -0.7203749524870366, 3.0246410492957367, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2116L, 4167L, 1.0, 400000.0, 800000.0, -0.7206416000116469, 3.003866783060193, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2117L, 4167L, 1.0, 400000.0, 800000.0, -0.7297318565324507, 2.994655323119112, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2118L, 4167L, 1.0, 400000.0, 800000.0, -0.7388608981477431, 2.9941074836594583, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2119L, 4167L, 1.0, 400000.0, 800000.0, -0.7450616651291342, 3.0195941388753864, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2120L, 4167L, 1.0, 400000.0, 800000.0, -0.7250873414674213, 3.0334161769238195, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2121L, 4167L, 1.0, 400000.0, 800000.0, -0.7485038422650119, 2.9841591069230904, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2122L, 4167L, 1.0, 400000.0, 800000.0, -0.7524114405347547, 2.9716121288559756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2123L, 4167L, 1.0, 400000.0, 800000.0, -0.7675570199326166, 2.9427317778722806, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2124L, 4167L, 1.0, 400000.0, 800000.0, -0.7607987172179497, 3.0146538874648803, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2125L, 4167L, 1.0, 400000.0, 800000.0, -0.7635573070634629, 2.9908059024911022, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2126L, 4167L, 1.0, 400000.0, 800000.0, -0.7749601248431592, 2.985511737093386, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2127L, 4167L, 1.0, 400000.0, 800000.0, -0.7807730408796625, 2.9577658501234874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2128L, 4167L, 1.0, 400000.0, 800000.0, -0.7877155727931511, 2.9391102196743923, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2129L, 4167L, 1.0, 400000.0, 800000.0, -0.79523503298716, 2.92759104661123, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2130L, 4167L, 1.0, 400000.0, 800000.0, -0.7996419893484457, 2.978026213857055, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2131L, 4167L, 1.0, 400000.0, 800000.0, -0.8004322356486542, 2.971990283527241, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2132L, 4167L, 1.0, 400000.0, 800000.0, -0.8133234314293567, 2.938135744175362, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2133L, 4167L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2134L, 4167L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2135L, 4167L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2136L, 4168L, 3.280843014596366, 274319.73916335794, 0.0, 0.08144869842640197, -0.017453292519943278, 0.99975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2137L, 4168L, 1.0, 500000.0, 0.0, 0.0, -0.017453292519943278, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2139L, 4140L, 1.0, 304800.0, 0.0, 0.0, -0.9686577348568519, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2140L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2141L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2142L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2143L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2144L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.230457122656001, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2145L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2146L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2147L, 4140L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2148L, 4140L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2149L, 4140L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2150L, 4140L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2151L, 4140L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2152L, 4140L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2153L, 4140L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2156L, 4152L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2157L, 4173L, 1.0, 600000.0, 750000.0, 0.9337511498169654, -0.13962634015954623, 0.99982);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2158L, 4173L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2159L, 4174L, 3.280843014596366, 152399.8550907544, 0.0, 0.11635528346628853, -0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2160L, 4174L, 3.280843014596366, 243839.76814520705, 182879.82610890528, 0.11635528346628853, -0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2161L, 4175L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2162L, 4175L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2164L, 4142L, 1.0, 500000.0, 0.0, 0.0, -0.08726646259971639, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2165L, 4143L, 1.0, 500000.0, 0.0, 0.0, -0.08726646259971639, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2166L, 4178L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2167L, 4178L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2168L, 4178L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2169L, 4181L, 1.0, 80000.0, 100000.0, 0.8697557439105067, 0.10762863720631688, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2170L, 4312L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2175L, 4179L, 1.0, 237000.0, -4700000.0, 0.0, 0.33088533735725795, 0.999983);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2176L, 4258L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 0.999923);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2177L, 4258L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 0.999923);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2178L, 4258L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 0.999923);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2179L, 4258L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 0.999923);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2180L, 4258L, 1.0, 500000.0, -5300000.0, 0.0, 0.3316125578789223, 0.9993);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2188L, 4182L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2189L, 4183L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2190L, 4184L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2191L, 4185L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2193L, 4167L, 1.0, 1600000.0, 1.0E7, 0.0, 3.019419605950187, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2195L, 4152L, 1.0, 500000.0, 1.0E7, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2196L, 4258L, 1.0, 200000.0, 0.0, 0.0, 0.16580627893946115, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2197L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.20943951023931934, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2198L, 4258L, 1.0, 900000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2199L, 4191L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2201L, 4189L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2202L, 4189L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2203L, 4189L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2206L, 4230L, 1.0, 9500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2207L, 4230L, 1.0, 1.05E7, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2208L, 4230L, 1.0, 1.15E7, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2209L, 4230L, 1.0, 1.25E7, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2210L, 4230L, 1.0, 1.35E7, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2211L, 4230L, 1.0, 1.45E7, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2212L, 4230L, 1.0, 1.55E7, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2213L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.5235987755982984, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2214L, 4192L, 1.0, 1000000.0, 1000000.0, 0.0, 0.1832595714594044, 0.999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2215L, 4193L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2216L, 4194L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2217L, 4194L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2219L, 4122L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2220L, 4122L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2222L, 4269L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2223L, 4269L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2224L, 4269L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2235L, 4269L, 3.2808333333333333, 200000.0001016002, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2236L, 4269L, 3.2808333333333333, 200000.0001016002, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2237L, 4269L, 3.2808333333333333, 200000.0001016002, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2239L, 4269L, 3.2808333333333333, 200000.0001016002, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2240L, 4269L, 3.2808333333333333, 699999.9998983998, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2241L, 4269L, 3.2808333333333333, 200000.0001016002, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2242L, 4269L, 3.2808333333333333, 500000.0001016002, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2243L, 4269L, 3.2808333333333333, 800000.0001016002, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2244L, 4269L, 3.2808333333333333, 99999.9998983998, 249364.99872999746, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2245L, 4269L, 3.2808333333333333, 900000.0, 249364.99872999746, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2254L, 4269L, 3.2808333333333333, 300000.0, 0.0, 0.5148721293383267, -1.5504341521882945, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2255L, 4269L, 3.2808333333333333, 699999.9998983998, 0.0, 0.5148721293383267, -1.5766140909682094, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2257L, 4269L, 3.2808333333333333, 165000.0, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2258L, 4269L, 3.2808333333333333, 500000.0001016002, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2259L, 4269L, 3.2808333333333333, 830000.0001016002, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2260L, 4269L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2261L, 4269L, 3.2808333333333333, 249999.9998983998, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2262L, 4269L, 3.2808333333333333, 350000.0001016002, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2294L, 4122L, 1.0, 4500000.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2295L, 4122L, 1.0, 5500000.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2308L, 4211L, 1.0, 500000.0, 1.0E7, 0.0, 1.9024088846738172, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2309L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.02458193231342, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2310L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.303834612632513, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2311L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.10471975511965967, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2312L, 4197L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2313L, 4198L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2315L, 4221L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2316L, 4221L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2319L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2320L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2321L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2322L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2323L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2324L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2325L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2326L, 4611L, 1.0, 836694.05, 819069.8, 0.38942018981064375, 1.9927917296157058, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2327L, 4610L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2328L, 4610L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2329L, 4610L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2330L, 4610L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2331L, 4610L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2332L, 4610L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2333L, 4610L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2334L, 4610L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2335L, 4610L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2336L, 4610L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2337L, 4610L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2338L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2339L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2340L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2341L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2342L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2343L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2344L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2345L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2346L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2347L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2348L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2349L, 4610L, 1.0, 2.55E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2350L, 4610L, 1.0, 2.65E7, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2351L, 4610L, 1.0, 2.75E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2352L, 4610L, 1.0, 2.85E7, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2353L, 4610L, 1.0, 2.95E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2354L, 4610L, 1.0, 3.05E7, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2355L, 4610L, 1.0, 3.15E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2356L, 4610L, 1.0, 3.25E7, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2357L, 4610L, 1.0, 3.35E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2358L, 4610L, 1.0, 3.45E7, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2359L, 4610L, 1.0, 3.55E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2360L, 4610L, 1.0, 3.65E7, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2361L, 4610L, 1.0, 3.75E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2362L, 4610L, 1.0, 3.85E7, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2363L, 4610L, 1.0, 3.95E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2364L, 4610L, 1.0, 4.05E7, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2365L, 4610L, 1.0, 4.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2366L, 4610L, 1.0, 4.25E7, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2367L, 4610L, 1.0, 4.35E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2368L, 4610L, 1.0, 4.45E7, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2369L, 4610L, 1.0, 4.55E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2370L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2371L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2372L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2373L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2374L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2375L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2376L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2377L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2378L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2379L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2380L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2381L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2382L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2383L, 4610L, 1.0, 500000.0, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2384L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2385L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2386L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2387L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2388L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2389L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2390L, 4610L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2391L, 4123L, 1.0, 1500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2392L, 4123L, 1.0, 2500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2393L, 4123L, 1.0, 3500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2394L, 4123L, 1.0, 4500000.0, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2395L, 4164L, 1.0, 8500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2396L, 4164L, 1.0, 9500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2397L, 4178L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2398L, 4178L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2399L, 4178L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2400L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.2759064962920744, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2401L, 4214L, 1.0, 2.55E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2402L, 4214L, 1.0, 2.65E7, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2403L, 4214L, 1.0, 2.75E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2404L, 4214L, 1.0, 2.85E7, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2405L, 4214L, 1.0, 2.95E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2406L, 4214L, 1.0, 3.05E7, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2407L, 4214L, 1.0, 3.15E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2408L, 4214L, 1.0, 3.25E7, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2409L, 4214L, 1.0, 3.35E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2410L, 4214L, 1.0, 3.45E7, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2411L, 4214L, 1.0, 3.55E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2412L, 4214L, 1.0, 3.65E7, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2413L, 4214L, 1.0, 3.75E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2414L, 4214L, 1.0, 3.85E7, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2415L, 4214L, 1.0, 3.95E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2416L, 4214L, 1.0, 4.05E7, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2417L, 4214L, 1.0, 4.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2418L, 4214L, 1.0, 4.25E7, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2419L, 4214L, 1.0, 4.35E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2420L, 4214L, 1.0, 4.45E7, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2421L, 4214L, 1.0, 4.55E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2422L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2423L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2424L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2425L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2426L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2427L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2428L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2429L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2430L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2431L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2432L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2433L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2434L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2435L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2436L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2437L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2438L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2439L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2440L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2441L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2442L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2443L, 4612L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.2602013813326547, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2444L, 4612L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.2863813201125693, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2445L, 4612L, 1.0, 0.0, 0.0, 0.628318530717958, 2.30674349471917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2446L, 4612L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.3300145514124275, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2447L, 4612L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3445589618457134, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2448L, 4612L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3736477827122857, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2449L, 4612L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3940099573188864, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2450L, 4612L, 1.0, 0.0, 0.0, 0.628318530717958, 2.417281014012144, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2451L, 4612L, 1.0, 0.0, 0.0, 0.628318530717958, 2.440552070705402, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2452L, 4612L, 1.0, 0.0, 0.0, 0.6981317007977311, 2.458005363225345, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2453L, 4612L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.4478242759220445, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2454L, 4612L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.482730860961931, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2455L, 4612L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.517637446001818, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2456L, 4612L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2457L, 4612L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.225294796292768, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2458L, 4612L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.1642082724729663, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2459L, 4612L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.2863813201125693, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2460L, 4612L, 1.0, 0.0, 0.0, 0.34906585039886556, 2.3736477827122857, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2461L, 4612L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2462L, 4191L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2463L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2464L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2465L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2466L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2467L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2468L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2469L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2470L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2471L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2472L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2473L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2474L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2475L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2476L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2477L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2478L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2479L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2480L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2481L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2482L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2483L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2484L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2485L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2486L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2487L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2488L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2489L, 4200L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2490L, 4200L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2491L, 4200L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2492L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2493L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2494L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2495L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2496L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2497L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2498L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2499L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2500L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2501L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2502L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2503L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2504L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2505L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2506L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2507L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2508L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2509L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2510L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2511L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2512L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2513L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2514L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2515L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2516L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2517L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2518L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2519L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2520L, 4284L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2521L, 4284L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2522L, 4284L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2523L, 4284L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2524L, 4284L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2525L, 4284L, 1.0, 9500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2526L, 4284L, 1.0, 1.05E7, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2527L, 4284L, 1.0, 1.15E7, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2528L, 4284L, 1.0, 1.25E7, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2529L, 4284L, 1.0, 1.35E7, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2530L, 4284L, 1.0, 1.45E7, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2531L, 4284L, 1.0, 1.55E7, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2532L, 4284L, 1.0, 1.65E7, 0.0, 0.0, 0.8377580409572774, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2533L, 4284L, 1.0, 1.75E7, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2534L, 4284L, 1.0, 1.85E7, 0.0, 0.0, 0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2535L, 4284L, 1.0, 1.95E7, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2536L, 4284L, 1.0, 2.05E7, 0.0, 0.0, 1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2537L, 4284L, 1.0, 2.15E7, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2538L, 4284L, 1.0, 2.25E7, 0.0, 0.0, 1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2539L, 4284L, 1.0, 2.35E7, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2540L, 4284L, 1.0, 2.45E7, 0.0, 0.0, 1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2541L, 4284L, 1.0, 2.55E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2542L, 4284L, 1.0, 2.65E7, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2543L, 4284L, 1.0, 2.75E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2544L, 4284L, 1.0, 2.85E7, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2545L, 4284L, 1.0, 2.95E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2546L, 4284L, 1.0, 3.05E7, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2547L, 4284L, 1.0, 3.15E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2548L, 4284L, 1.0, 3.25E7, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2549L, 4284L, 1.0, 3.35E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2550L, 4125L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2551L, 4284L, 1.0, 3.45E7, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2552L, 4284L, 1.0, 3.55E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2553L, 4284L, 1.0, 3.65E7, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2554L, 4284L, 1.0, 3.75E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2555L, 4284L, 1.0, 3.85E7, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2556L, 4284L, 1.0, 3.95E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2557L, 4284L, 1.0, 4.05E7, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2558L, 4284L, 1.0, 4.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2559L, 4284L, 1.0, 4.25E7, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2560L, 4284L, 1.0, 4.35E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2561L, 4284L, 1.0, 4.45E7, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2562L, 4284L, 1.0, 4.55E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2563L, 4284L, 1.0, 4.65E7, 0.0, 0.0, 2.4085543677521724, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2564L, 4284L, 1.0, 4.75E7, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2565L, 4284L, 1.0, 4.85E7, 0.0, 0.0, 2.513274122871832, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2566L, 4284L, 1.0, 4.95E7, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2567L, 4284L, 1.0, 5.05E7, 0.0, 0.0, 2.6179938779914917, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2568L, 4284L, 1.0, 5.15E7, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2569L, 4284L, 1.0, 5.25E7, 0.0, 0.0, 2.722713633111151, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2570L, 4284L, 1.0, 5.35E7, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2571L, 4284L, 1.0, 5.45E7, 0.0, 0.0, 2.827433388230811, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2572L, 4284L, 1.0, 5.55E7, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2573L, 4284L, 1.0, 5.65E7, 0.0, 0.0, 2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2574L, 4284L, 1.0, 5.75E7, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2575L, 4284L, 1.0, 5.85E7, 0.0, 0.0, 3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2576L, 4284L, 1.0, 5.95E7, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2577L, 4284L, 1.0, 6.0E7, 0.0, 0.0, 3.14159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2578L, 4284L, 1.0, 6.15E7, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2579L, 4284L, 1.0, 6.25E7, 0.0, 0.0, -3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2580L, 4284L, 1.0, 6.35E7, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2581L, 4284L, 1.0, 6.45E7, 0.0, 0.0, -2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2582L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2583L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2584L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2585L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2586L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2587L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2588L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2589L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2590L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2591L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.8377580409572774, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2592L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2593L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2594L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2595L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2596L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2597L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2598L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2599L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2600L, 4126L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2601L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2602L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2603L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2604L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2605L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2606L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2607L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2608L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2609L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2610L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2611L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2612L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2613L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2614L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2615L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2616L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2617L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2618L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2619L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2620L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2621L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2622L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.4085543677521724, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2623L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2624L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.513274122871832, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2625L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2626L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.6179938779914917, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2627L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2628L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.722713633111151, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2629L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2630L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.827433388230811, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2631L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2632L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2633L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2634L, 4284L, 1.0, 500000.0, 0.0, 0.0, 3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2635L, 4284L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2636L, 4284L, 1.0, 500000.0, 0.0, 0.0, 3.14159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2637L, 4284L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2638L, 4284L, 1.0, 500000.0, 0.0, 0.0, -3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2639L, 4284L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2640L, 4284L, 1.0, 500000.0, 0.0, 0.0, -2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2641L, 4200L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2642L, 4200L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2643L, 4200L, 1.0, 9500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2644L, 4200L, 1.0, 1.05E7, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2645L, 4200L, 1.0, 1.15E7, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2646L, 4200L, 1.0, 1.25E7, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2647L, 4200L, 1.0, 1.35E7, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2648L, 4200L, 1.0, 1.45E7, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2649L, 4200L, 1.0, 1.55E7, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2650L, 4200L, 1.0, 1.65E7, 0.0, 0.0, 0.8377580409572774, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2651L, 4200L, 1.0, 1.75E7, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2652L, 4200L, 1.0, 1.85E7, 0.0, 0.0, 0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2653L, 4200L, 1.0, 1.95E7, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2654L, 4200L, 1.0, 2.05E7, 0.0, 0.0, 1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2655L, 4200L, 1.0, 2.15E7, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2656L, 4200L, 1.0, 2.25E7, 0.0, 0.0, 1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2657L, 4200L, 1.0, 2.35E7, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2658L, 4200L, 1.0, 2.45E7, 0.0, 0.0, 1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2659L, 4200L, 1.0, 2.55E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2660L, 4200L, 1.0, 2.65E7, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2661L, 4200L, 1.0, 2.75E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2662L, 4200L, 1.0, 2.85E7, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2663L, 4200L, 1.0, 2.95E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2664L, 4200L, 1.0, 3.05E7, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2665L, 4200L, 1.0, 3.15E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2666L, 4200L, 1.0, 3.25E7, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2667L, 4200L, 1.0, 3.35E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2668L, 4200L, 1.0, 3.45E7, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2669L, 4200L, 1.0, 3.55E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2670L, 4200L, 1.0, 3.65E7, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2671L, 4200L, 1.0, 3.75E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2672L, 4200L, 1.0, 3.85E7, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2673L, 4200L, 1.0, 3.95E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2674L, 4200L, 1.0, 4.05E7, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2675L, 4200L, 1.0, 4.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2676L, 4200L, 1.0, 4.25E7, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2677L, 4200L, 1.0, 4.35E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2678L, 4200L, 1.0, 4.45E7, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2679L, 4200L, 1.0, 4.55E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2680L, 4200L, 1.0, 4.65E7, 0.0, 0.0, 2.4085543677521724, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2681L, 4200L, 1.0, 4.75E7, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2682L, 4200L, 1.0, 4.85E7, 0.0, 0.0, 2.513274122871832, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2683L, 4200L, 1.0, 4.95E7, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2684L, 4200L, 1.0, 5.05E7, 0.0, 0.0, 2.6179938779914917, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2685L, 4200L, 1.0, 5.15E7, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2686L, 4200L, 1.0, 5.25E7, 0.0, 0.0, 2.722713633111151, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2687L, 4200L, 1.0, 5.35E7, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2688L, 4200L, 1.0, 5.45E7, 0.0, 0.0, 2.827433388230811, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2689L, 4200L, 1.0, 5.55E7, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2690L, 4200L, 1.0, 5.65E7, 0.0, 0.0, 2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2691L, 4200L, 1.0, 5.75E7, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2692L, 4200L, 1.0, 5.85E7, 0.0, 0.0, 3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2693L, 4200L, 1.0, 5.95E7, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2694L, 4200L, 1.0, 6.0E7, 0.0, 0.0, 3.14159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2695L, 4200L, 1.0, 6.15E7, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2696L, 4200L, 1.0, 6.25E7, 0.0, 0.0, -3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2697L, 4200L, 1.0, 6.35E7, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2698L, 4200L, 1.0, 6.45E7, 0.0, 0.0, -2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2699L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2700L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2701L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2702L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2703L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2704L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2705L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2706L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2707L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2708L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.8377580409572774, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2709L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2710L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2711L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2712L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2713L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2714L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2715L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2716L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2717L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2718L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2719L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2720L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2721L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2722L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2723L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2724L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2725L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2726L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2727L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2728L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2729L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2730L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2731L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2732L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2733L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2734L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2735L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2736L, 4127L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2737L, 4127L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2738L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2739L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2740L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.4085543677521724, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2741L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2742L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.513274122871832, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2743L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2744L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.6179938779914917, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2745L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2746L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.722713633111151, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2747L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2748L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.827433388230811, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2749L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2750L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2751L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2752L, 4200L, 1.0, 500000.0, 0.0, 0.0, 3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2753L, 4200L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2754L, 4200L, 1.0, 500000.0, 0.0, 0.0, 3.14159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2755L, 4200L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2756L, 4200L, 1.0, 500000.0, 0.0, 0.0, -3.0368728984701305, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2757L, 4200L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2758L, 4200L, 1.0, 500000.0, 0.0, 0.0, -2.9321531433504706, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2759L, 4152L, 1.0, 200000.0, 0.0, 0.5323254218582699, -1.4980742746284648, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2760L, 4152L, 1.0, 600000.0, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2761L, 4152L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2762L, 4152L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2763L, 4152L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2776L, 4152L, 1.0, 200000.0, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2777L, 4152L, 1.0, 200000.0, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2778L, 4152L, 1.0, 200000.0, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2780L, 4152L, 1.0, 200000.0, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2781L, 4152L, 1.0, 700000.0, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2782L, 4152L, 1.0, 500000.0, 0.0, 0.32870367579226506, -2.7139869868511797, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2783L, 4152L, 1.0, 500000.0, 0.0, 0.35488361457218, -2.7343491614577804, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2784L, 4152L, 1.0, 500000.0, 0.0, 0.36942802500546607, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2785L, 4152L, 1.0, 500000.0, 0.0, 0.3810635533520949, -2.783800156930953, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2786L, 4152L, 1.0, 500000.0, 0.0, 0.37815467126543767, -2.7954356852775817, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2787L, 4152L, 1.0, 200000.0, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2788L, 4152L, 1.0, 500000.0, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2789L, 4152L, 1.0, 800000.0, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2790L, 4152L, 1.0, 300000.0, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2791L, 4152L, 1.0, 700000.0, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2792L, 4152L, 1.0, 100000.0, 250000.0, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2793L, 4152L, 1.0, 900000.0, 250000.0, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2802L, 4152L, 1.0, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2803L, 4152L, 1.0, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2813L, 4152L, 1.0, 300000.0, 0.0, 0.5148721293383267, -1.5504341521882945, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2814L, 4152L, 1.0, 700000.0, 0.0, 0.5148721293383267, -1.5766140909682094, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2815L, 4152L, 1.0, 250000.0, 0.0, 0.6254096486313008, -1.5795229730548666, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2816L, 4152L, 1.0, 500000.0, 0.0, 0.6254096486313008, -1.6144295580947532, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2817L, 4152L, 1.0, 850000.0, 0.0, 0.6312274128046153, -1.6493361431346398, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2820L, 4152L, 1.0, 200000.0, 8000000.0, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2821L, 4152L, 1.0, 500000.0, 6000000.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2822L, 4152L, 1.0, 800000.0, 4000000.0, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2823L, 4152L, 1.0, 300000.0, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2824L, 4152L, 1.0, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2825L, 4152L, 1.0, 165000.0, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2826L, 4152L, 1.0, 500000.0, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2827L, 4152L, 1.0, 830000.0, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2828L, 4152L, 1.0, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2829L, 4152L, 1.0, 250000.0, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2830L, 4152L, 1.0, 350000.0, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2840L, 4152L, 1.0, 100000.0, 0.0, 0.717039434361003, -1.2479104151759444, 0.99999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2852L, 4152L, 1.0, 500000.0, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964286);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2862L, 4152L, 1.0, 200000.0, 0.0, 0.7068583470577028, -1.8355045966807013, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2863L, 4152L, 1.0, 400000.0, 100000.0, 0.7068583470577028, -1.8733200638072451, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2864L, 4152L, 1.0, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2865L, 4152L, 1.0, 800000.0, 100000.0, 0.7068583470577028, -1.921316618237089, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2867L, 4152L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2868L, 4152L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2869L, 4152L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2880L, 4152L, 3.2808333333333333, 200000.0001016002, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2881L, 4152L, 3.2808333333333333, 200000.0001016002, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2882L, 4152L, 3.2808333333333333, 200000.0001016002, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2884L, 4152L, 3.2808333333333333, 200000.0001016002, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2885L, 4152L, 3.2808333333333333, 699999.9998983998, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2886L, 4152L, 3.2808333333333333, 200000.0001016002, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2887L, 4152L, 3.2808333333333333, 500000.0001016002, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2888L, 4152L, 3.2808333333333333, 800000.0001016002, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2889L, 4152L, 3.2808333333333333, 99999.9998983998, 249364.99872999746, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2890L, 4152L, 3.2808333333333333, 900000.0, 249364.99872999746, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2899L, 4152L, 3.2808333333333333, 300000.0, 0.0, 0.5148721293383267, -1.5504341521882945, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2900L, 4152L, 3.2808333333333333, 699999.9998983998, 0.0, 0.5148721293383267, -1.5766140909682094, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2902L, 4152L, 3.2808333333333333, 165000.0, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2903L, 4152L, 3.2808333333333333, 500000.0001016002, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2904L, 4152L, 3.2808333333333333, 830000.0001016002, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2905L, 4152L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2906L, 4152L, 3.2808333333333333, 249999.9998983998, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2907L, 4152L, 3.2808333333333333, 350000.0001016002, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2931L, 4213L, 1.0, 500000.0, 0.0, 0.0, 0.2268928027592626, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2932L, 4614L, 1.0, 200000.0, 300000.0, 0.42673300211261317, 0.8938994652297615, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2933L, 4613L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2935L, 4284L, 1.0, 1300000.0, 0.0, 0.0020362174606600495, 0.7248934159949775, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2936L, 4284L, 1.0, 2300000.0, 0.0, 0.0020362174606600495, 0.7772532935548073, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2937L, 4284L, 1.0, 3300000.0, 0.0, 0.0020362174606600495, 0.8296131711146372, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2938L, 4284L, 1.0, 4300000.0, 0.0, 0.0020362174606600495, 0.881973048674467, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2939L, 4284L, 1.0, 2300000.0, 0.0, 0.0023271056693257696, 0.886045483595787, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2940L, 4284L, 1.0, 3300000.0, 0.0, 0.0023271056693257696, 0.9384053611556169, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2941L, 4284L, 1.0, 4300000.0, 0.0, 0.0023271056693257696, 0.9907652387154467, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2942L, 4615L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2943L, 4616L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2944L, 4617L, 1.0, 304800.0, 0.0, 0.0, -0.9686577348568519, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2945L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2946L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2947L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2948L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2949L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.230457122656001, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2950L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2951L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2952L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2955L, 4617L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2956L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2957L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2958L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2959L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2960L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2961L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2962L, 4617L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2965L, 4269L, 3.2808333333333333, 99999.9998983998, 249999.9998983998, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2966L, 4269L, 3.2808333333333333, 900000.0, 249999.9998983998, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2967L, 4152L, 3.2808333333333333, 99999.9998983998, 249999.9998983998, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2968L, 4152L, 3.2808333333333333, 900000.0, 249999.9998983998, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2969L, 4621L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2970L, 4622L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2971L, 4623L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2972L, 4624L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2973L, 4625L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2975L, 4627L, 1.0, 500000.0, 1.0E7, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2976L, 4628L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2977L, 4629L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2978L, 4630L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2979L, 4631L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2980L, 4632L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2981L, 4633L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2982L, 4634L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2983L, 4635L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2987L, 4638L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2988L, 4639L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2989L, 4640L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2990L, 4626L, 1.0, 50000.0, 160000.0, -0.3685553603794689, 0.9692395112741834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2995L, 4641L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2996L, 4642L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2997L, 4643L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2998L, 4644L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2999L, 4646L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3003L, 4265L, 1.0, 1500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3004L, 4265L, 1.0, 2520000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3006L, 4619L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3007L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3008L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.23561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3009L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3010L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.2879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3011L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3012L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.2487094184091917, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3013L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.2748893571891066, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3014L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.30106929596902154, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3015L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.32724923474893647, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3016L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.3534291735288514, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3017L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.3796091123087663, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3018L, 4619L, 1.0, 150000.0, 0.0, 0.0, 0.4057890510886812, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3019L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.19736667995232968, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3020L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.23663658812220206, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3021L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.2759064962920744, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3022L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.3151764044619468, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3023L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.3544463126318192, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3024L, 4124L, 1.0, 1500000.0, 0.0, 0.0, 0.39371622080169155, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3025L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.19736667995232968, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3026L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.23663658812220206, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3027L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.2759064962920744, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3028L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.3151764044619468, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3029L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.3544463126318192, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3030L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.39371622080169155, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3036L, 4130L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3037L, 4130L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3038L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3039L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3040L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3041L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3042L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3043L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3044L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3045L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3046L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3047L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3048L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3049L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3050L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3051L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3054L, 4658L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3055L, 4658L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3056L, 4658L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3058L, 4660L, 1.0, 50000.0, -7800000.0, 0.0, -0.14835298641951786, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3059L, 4661L, 1.0, 500000.0, -6000000.0, 0.0, 0.4188790204786387, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3060L, 4662L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3061L, 4663L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3062L, 4664L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3063L, 4665L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3064L, 4670L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3065L, 4670L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3066L, 4230L, 1.0, 500000.0, -3000000.0, 0.0, 0.6457718232379013, 0.9998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3067L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3069L, 4267L, 1.0, 500000.0, -4500000.0, 0.0, -1.570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3070L, 4269L, 1.0, 520000.0, -4480000.0, 0.0, -1.570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3071L, 4152L, 1.0, 520000.0, -4480000.0, 0.0, -1.570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3072L, 4269L, 1.0, 700000.0, 0.0, 0.765035988790847, -1.18464222979115, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3073L, 4269L, 1.0, 500000.0, 0.0, 0.750491578357561, -1.2064588454410792, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3074L, 4269L, 1.0, 300000.0, 0.0, 0.7475826962709037, -1.2282754610910083, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3075L, 4152L, 1.0, 700000.0, 0.0, 0.765035988790847, -1.18464222979115, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3076L, 4152L, 1.0, 500000.0, 0.0, 0.750491578357561, -1.2064588454410792, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3077L, 4152L, 1.0, 300000.0, 0.0, 0.7475826962709037, -1.2282754610910083, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3092L, 4301L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3093L, 4301L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3094L, 4301L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3095L, 4301L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3096L, 4301L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3097L, 4612L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3098L, 4612L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3099L, 4612L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3100L, 4612L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3101L, 4612L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3103L, 4681L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3104L, 4681L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3105L, 4681L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3106L, 4682L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3108L, 4258L, 1.0, 47000.0, 50000.0, 0.8639379797371922, -0.04217879025652959, 0.999997);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3109L, 4258L, 1.0, 40000.0, 70000.0, 0.8591383242942079, -0.0372627795300789, 0.9999999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3113L, 4283L, 1.0, 50000.0, 100000.0, -0.4886921905584118, 2.6703537555513215, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3114L, 4686L, 1.0, 1000000.0, 1000000.0, 0.08021883035236851, -1.397616169937657, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3115L, 4686L, 1.0, 1000000.0, 1000000.0, 0.08021883035236851, -1.345256292377827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3116L, 4686L, 1.0, 1000000.0, 1000000.0, 0.08021883035236851, -1.2928964148179973, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3117L, 4686L, 1.0, 1000000.0, 1000000.0, 0.08021883035236851, -1.2405365372581674, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3118L, 4686L, 1.0, 1000000.0, 1000000.0, 0.08021883035236851, -1.1881766596983376, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3119L, 4192L, 1.0, 1000000.0, 1000000.0, 0.0, 0.1832595714594044, 0.999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3121L, 4683L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3122L, 4683L, 1.0, 500000.0, 0.0, 0.0, 2.07694180987325, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3123L, 4683L, 1.0, 500000.0, 0.0, 0.0, 2.1118483949131366, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3124L, 4683L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3125L, 4683L, 1.0, 500000.0, 0.0, 0.0, 2.18166156499291, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3126L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.3316125578789223, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3127L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.34906585039886556, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3128L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3129L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.3839724354387521, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3130L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4014257279586954, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3131L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3132L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.43633231299858194, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3133L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4537856055185252, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3134L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3135L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3136L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.506145483078355, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3137L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3138L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3141L, 4721L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3142L, 4721L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3143L, 4720L, 1.0, 2000000.0, 4000000.0, -0.2967059728390357, 3.119776037939861, 0.99985);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3146L, 4284L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3147L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3148L, 4131L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3149L, 4131L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3150L, 4200L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3151L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3152L, 4619L, 1.0, 100178.1808, -6500614.7836, 0.0, 0.3151678911337065, 0.99999425);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3154L, 4617L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3155L, 4617L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3156L, 4617L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3157L, 4617L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3158L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3159L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3160L, 4617L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3164L, 4750L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3169L, 4749L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3170L, 4749L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3171L, 4749L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3172L, 4641L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3176L, 4131L, 1.0, 500000.0, 0.0, 0.0, 1.8500490071139875, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3177L, 4754L, 1.0, 1000000.0, 0.0, 0.0, 0.2967059728390357, 0.9965);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3178L, 4747L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3179L, 4747L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3180L, 4747L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3181L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3182L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3183L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3184L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3185L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3186L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3187L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3188L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3189L, 4747L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3190L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.1570796326794895, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3191L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.19198621771937605, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3192L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.2268928027592626, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3193L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.2617993877991492, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3194L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.2967059728390357, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3195L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.3316125578789223, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3196L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.3665191429188088, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3197L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.4014257279586954, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3198L, 4754L, 1.0, 200000.0, 0.0, 0.0, 0.43633231299858194, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3199L, 4754L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3201L, 4754L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3202L, 4754L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3203L, 4754L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3296L, 4687L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3297L, 4687L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3298L, 4687L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3299L, 4687L, 1.0, 500000.0, 1.0E7, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3302L, 4689L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3303L, 4688L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3304L, 4690L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3305L, 4691L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3306L, 4692L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3307L, 4693L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3312L, 4623L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3313L, 4624L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3315L, 4695L, 1.0, 0.0, 0.0, -0.1570796326794895, 0.4537856055185252, 0.9998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3316L, 4696L, 1.0, 500000.0, 1.0E7, 0.0, 0.3839724354387521, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3317L, 4696L, 1.0, 500000.0, 1.0E7, 0.0, 0.4188790204786387, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3318L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.20943951023931934, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3319L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.2443460952792059, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3320L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.27925268031909245, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3321L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.314159265358979, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3322L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.34906585039886556, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3323L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.3839724354387521, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3324L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.4188790204786387, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3325L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.4537856055185252, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3326L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.4886921905584118, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3327L, 4697L, 1.0, 500000.0, 1.0E7, 0.0, 0.5235987755982984, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3329L, 4179L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3330L, 4179L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3331L, 4179L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3332L, 4179L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3333L, 4179L, 1.0, 3500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3334L, 4179L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3335L, 4179L, 1.0, 5500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3336L, 4698L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3339L, 4701L, 1.0, 500000.0, 1.0E7, 0.0, 0.20943951023931934, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3340L, 4701L, 1.0, 500000.0, 1.0E7, 0.0, 0.2443460952792059, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3341L, 4701L, 1.0, 500000.0, 1.0E7, 0.0, 0.27925268031909245, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3342L, 4701L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3343L, 4702L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3344L, 4702L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3345L, 4702L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3346L, 4669L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3350L, 4284L, 1.0, 250000.0, 0.0, 0.0017453292519943279, 0.3830997708127549, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3351L, 4284L, 1.0, 1250000.0, 0.0, 0.0017453292519943279, 0.4354596483725848, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3352L, 4284L, 1.0, 2250000.0, 0.0, 0.0017453292519943279, 0.4878195259324146, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3353L, 4704L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3354L, 4705L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3355L, 4706L, 1.0, 615000.0, 810000.0, 0.5235987755982984, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3356L, 4723L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3357L, 4726L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3367L, 4700L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3368L, 4700L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3369L, 4700L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3370L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3371L, 4267L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3372L, 4269L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3373L, 4269L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3374L, 4741L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3386L, 4123L, 1.0, 500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3387L, 4123L, 1.0, 5500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3389L, 4284L, 1.0, 6.05E7, 0.0, 0.0, 3.14159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3390L, 4200L, 1.0, 6.05E7, 0.0, 0.0, 3.14159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3391L, 4743L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3392L, 4743L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3393L, 4743L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3396L, 4746L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3397L, 4746L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3398L, 4745L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3399L, 4745L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3400L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.007128639793477, 0.9992);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3401L, 4269L, 1.0, 0.0, 0.0, 0.0, -2.007128639793477, 0.9992);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3402L, 4617L, 1.0, 500000.0, 0.0, 0.0, -2.007128639793477, 0.9992);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3403L, 4617L, 1.0, 0.0, 0.0, 0.0, -2.007128639793477, 0.9992);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3405L, 4756L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3406L, 4756L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
    }

    private static void loadTransverseMercatorSRIDs2() {
        TransverseMercatorSrid.registerTransverseMercatorSrid(3414L, 4757L, 1.0, 28001.642, 38744.572, 0.023852833110589146, 1.8122335399874436, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3421L, 4269L, 3.2808333333333333, 200000.00001016003, 8000000.00001016, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3422L, 4269L, 3.2808333333333333, 500000.00001016003, 6000000.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3423L, 4269L, 3.2808333333333333, 800000.00001016, 3999999.99998984, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3424L, 4269L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3429L, 4152L, 3.2808333333333333, 200000.00001016003, 8000000.00001016, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3430L, 4152L, 3.2808333333333333, 500000.00001016003, 6000000.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3431L, 4152L, 3.2808333333333333, 800000.00001016, 3999999.99998984, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3432L, 4152L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3435L, 4269L, 3.2808333333333333, 300000.0, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3436L, 4269L, 3.2808333333333333, 699999.99998984, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3437L, 4269L, 3.2808333333333333, 300000.0, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3438L, 4269L, 3.2808333333333333, 99999.99998983998, 0.0, 0.717039434361003, -1.2479104151759444, 0.99999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3439L, 4134L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3440L, 4134L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3443L, 4152L, 3.2808333333333333, 300000.0, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3444L, 4152L, 3.2808333333333333, 699999.99998984, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3445L, 4152L, 3.2808333333333333, 300000.0, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3446L, 4152L, 3.2808333333333333, 99999.99998983998, 0.0, 0.717039434361003, -1.2479104151759444, 0.99999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3449L, 4758L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3450L, 4758L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3460L, 4720L, 1.0, 2000000.0, 4000000.0, -0.2967059728390357, 3.119776037939861, 0.99985);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3461L, 4155L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3462L, 4155L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3463L, 4269L, 1.0, 500000.0, 0.0, 0.7592182246175326, -1.2064588454410792, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3464L, 4152L, 1.0, 500000.0, 0.0, 0.7592182246175326, -1.2064588454410792, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3465L, 4759L, 1.0, 200000.0, 0.0, 0.5323254218582699, -1.4980742746284648, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3466L, 4759L, 1.0, 600000.0, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3469L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3470L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.5481807079117185, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3471L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.6179938779914917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3472L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3473L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.757620218151038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3474L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.827433388230811, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3475L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.897246558310584, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3476L, 4759L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.9670597283903573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3478L, 4759L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3479L, 4759L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3480L, 4759L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3481L, 4759L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3482L, 4759L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3483L, 4759L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3509L, 4759L, 1.0, 200000.0, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3510L, 4759L, 3.2808333333333333, 200000.0001016002, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3511L, 4759L, 1.0, 200000.0, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3512L, 4759L, 3.2808333333333333, 200000.0001016002, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3516L, 4759L, 1.0, 200000.0, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3517L, 4759L, 3.2808333333333333, 200000.0001016002, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3518L, 4759L, 1.0, 200000.0, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3519L, 4759L, 3.2808333333333333, 200000.0001016002, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3520L, 4759L, 1.0, 700000.0, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3521L, 4759L, 3.2808333333333333, 699999.9998983998, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3522L, 4759L, 1.0, 500000.0, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3523L, 4759L, 3.2808333333333333, 500000.0001016002, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3524L, 4759L, 1.0, 200000.0, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3525L, 4759L, 3.2808333333333333, 200000.0001016002, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3526L, 4759L, 1.0, 800000.0, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3527L, 4759L, 3.2808333333333333, 800000.0001016002, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3528L, 4759L, 1.0, 300000.0, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3529L, 4759L, 3.2808333333333333, 300000.0, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3530L, 4759L, 1.0, 700000.0, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3531L, 4759L, 3.2808333333333333, 699999.99998984, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3532L, 4759L, 1.0, 100000.0, 250000.0, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3533L, 4759L, 3.2808333333333333, 99999.9998983998, 249999.9998983998, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3534L, 4759L, 1.0, 900000.0, 250000.0, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3535L, 4759L, 3.2808333333333333, 900000.0, 249999.9998983998, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3554L, 4759L, 1.0, 500000.0, 0.0, 0.7592182246175326, -1.2064588454410792, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3555L, 4759L, 1.0, 700000.0, 0.0, 0.765035988790847, -1.18464222979115, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3556L, 4759L, 1.0, 300000.0, 0.0, 0.7475826962709037, -1.2282754610910083, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3557L, 4759L, 1.0, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3558L, 4759L, 1.0, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3561L, 4135L, 3.2808333333333333, 152400.3048006096, 0.0, 0.32870367579226506, -2.7139869868511797, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3562L, 4135L, 3.2808333333333333, 152400.3048006096, 0.0, 0.35488361457218, -2.7343491614577804, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3563L, 4135L, 3.2808333333333333, 152400.3048006096, 0.0, 0.36942802500546607, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3564L, 4135L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3810635533520949, -2.783800156930953, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3565L, 4135L, 3.2808333333333333, 152400.3048006096, 0.0, 0.37815467126543767, -2.7954356852775817, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3597L, 4759L, 1.0, 300000.0, 0.0, 0.5148721293383267, -1.5504341521882945, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3598L, 4759L, 3.2808333333333333, 300000.0, 0.0, 0.5148721293383267, -1.5504341521882945, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3599L, 4759L, 1.0, 700000.0, 0.0, 0.5148721293383267, -1.5766140909682094, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3600L, 4759L, 3.2808333333333333, 699999.9998983998, 0.0, 0.5148721293383267, -1.5766140909682094, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3601L, 4759L, 1.0, 500000.0, 0.0, 0.6254096486313008, -1.6144295580947532, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3602L, 4759L, 1.0, 250000.0, 0.0, 0.6254096486313008, -1.5795229730548666, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3603L, 4759L, 1.0, 850000.0, 0.0, 0.6312274128046153, -1.6493361431346398, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3607L, 4759L, 1.0, 500000.0, 6000000.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3608L, 4759L, 3.2808333333333333, 500000.00001016003, 6000000.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3609L, 4759L, 1.0, 200000.0, 8000000.0, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3610L, 4759L, 3.2808333333333333, 200000.00001016003, 8000000.00001016, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3611L, 4759L, 1.0, 800000.0, 4000000.0, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3612L, 4759L, 3.2808333333333333, 800000.00001016, 3999999.99998984, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3613L, 4759L, 1.0, 300000.0, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3614L, 4759L, 3.2808333333333333, 300000.0, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3615L, 4759L, 1.0, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3616L, 4759L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3617L, 4759L, 1.0, 500000.0, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3618L, 4759L, 3.2808333333333333, 500000.0001016002, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3619L, 4759L, 1.0, 165000.0, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3620L, 4759L, 3.2808333333333333, 165000.0, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3621L, 4759L, 1.0, 830000.0, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3622L, 4759L, 3.2808333333333333, 830000.0001016002, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3623L, 4759L, 1.0, 250000.0, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3624L, 4759L, 3.2808333333333333, 249999.9998983998, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3625L, 4759L, 1.0, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3626L, 4759L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3629L, 4759L, 1.0, 350000.0, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3630L, 4759L, 3.2808333333333333, 350000.0001016002, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3653L, 4759L, 1.0, 100000.0, 0.0, 0.717039434361003, -1.2479104151759444, 0.99999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3654L, 4759L, 3.2808333333333333, 99999.99998983998, 0.0, 0.717039434361003, -1.2479104151759444, 0.99999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3684L, 4759L, 1.0, 500000.0, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964286);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3701L, 4759L, 1.0, 520000.0, -4480000.0, 0.0, -1.570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3702L, 4759L, 1.0, 200000.0, 0.0, 0.7068583470577028, -1.8355045966807013, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3703L, 4759L, 1.0, 400000.0, 100000.0, 0.7068583470577028, -1.8733200638072451, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3704L, 4759L, 1.0, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3705L, 4759L, 1.0, 800000.0, 100000.0, 0.7068583470577028, -1.921316618237089, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3706L, 4759L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3707L, 4759L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3708L, 4759L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3709L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3710L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3711L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3712L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3713L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3714L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3715L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3716L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3717L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3718L, 4759L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3719L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3720L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3721L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3722L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3723L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3724L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3725L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3726L, 4759L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3727L, 4626L, 1.0, 160000.0, 50000.0, -0.3685553603794689, 0.9692395112741834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3730L, 4759L, 3.2808333333333333, 200000.00001016003, 0.0, 0.7068583470577028, -1.8355045966807013, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3731L, 4759L, 3.2808333333333333, 399999.99998983997, 99999.99998983998, 0.7068583470577028, -1.8733200638072451, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3732L, 4759L, 3.2808333333333333, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3733L, 4759L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7068583470577028, -1.921316618237089, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3736L, 4269L, 3.2808333333333333, 200000.00001016003, 0.0, 0.7068583470577028, -1.8355045966807013, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3737L, 4269L, 3.2808333333333333, 399999.99998983997, 99999.99998983998, 0.7068583470577028, -1.8733200638072451, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3738L, 4269L, 3.2808333333333333, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3739L, 4269L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7068583470577028, -1.921316618237089, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3740L, 4152L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3741L, 4152L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3742L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3743L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3744L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3745L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3746L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3747L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3748L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3749L, 4152L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3750L, 4152L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3751L, 4152L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3755L, 4152L, 3.2808333333333333, 200000.00001016003, 0.0, 0.7068583470577028, -1.8355045966807013, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3756L, 4152L, 3.2808333333333333, 399999.99998983997, 99999.99998983998, 0.7068583470577028, -1.8733200638072451, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3757L, 4152L, 3.2808333333333333, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3758L, 4152L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7068583470577028, -1.921316618237089, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3759L, 4269L, 3.2808333333333333, 500000.00001016003, 0.0, 0.36942802500546607, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3760L, 4152L, 3.2808333333333333, 500000.00001016003, 0.0, 0.36942802500546607, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3761L, 4617L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3763L, 4258L, 1.0, 0.0, 0.0, 0.6923417164483443, -0.141949518838055, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3764L, 4167L, 1.0, 400000.0, 800000.0, -0.7679448708775042, -3.0805061297699887, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3765L, 4761L, 1.0, 500000.0, 0.0, 0.0, 0.2879793265790641, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3767L, 4761L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3768L, 4761L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3769L, 4216L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3770L, 4762L, 1.0, 550000.0, 100000.0, 0.5585053606381849, -1.1301006906663273, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3771L, 4267L, 1.0, 0.0, 0.0, 0.0, -1.9373154697137038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3772L, 4267L, 1.0, 0.0, 0.0, 0.0, -1.9896753472735336, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3773L, 4267L, 1.0, 0.0, 0.0, 0.0, -2.0420352248333633, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3774L, 4267L, 1.0, 0.0, 0.0, 0.0, -2.0943951023931935, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3775L, 4269L, 1.0, 0.0, 0.0, 0.0, -1.9373154697137038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3776L, 4269L, 1.0, 0.0, 0.0, 0.0, -1.9896753472735336, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3777L, 4269L, 1.0, 0.0, 0.0, 0.0, -2.0420352248333633, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3778L, 4269L, 1.0, 0.0, 0.0, 0.0, -2.0943951023931935, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3779L, 4617L, 1.0, 0.0, 0.0, 0.0, -1.9373154697137038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3780L, 4617L, 1.0, 0.0, 0.0, 0.0, -1.9896753472735336, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3781L, 4617L, 1.0, 0.0, 0.0, 0.0, -2.0420352248333633, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3782L, 4617L, 1.0, 0.0, 0.0, 0.0, -2.0943951023931935, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3783L, 4763L, 1.0, 14200.0, 15500.0, -0.43752878177331006, -2.270899675627981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3784L, 4729L, 1.0, 500000.0, 1.0E7, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3787L, 4312L, 1.0, 500000.0, -5000000.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3788L, 4167L, 1.0, 3500000.0, 1.0E7, 0.0, 2.897246558310584, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3789L, 4167L, 1.0, 3500000.0, 1.0E7, 0.0, 2.949606435870414, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3790L, 4167L, 1.0, 3500000.0, 1.0E7, 0.0, 3.124139361069847, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3791L, 4167L, 1.0, 3500000.0, 1.0E7, 0.0, -3.1066860685499034, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3793L, 4167L, 1.0, 3500000.0, 1.0E7, 0.0, -3.0805061297699887, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3794L, 4765L, 1.0, 500000.0, -5000000.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3800L, 4267L, 1.0, 0.0, 0.0, 0.0, -2.0943951023931935, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3801L, 4269L, 1.0, 0.0, 0.0, 0.0, -2.0943951023931935, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3802L, 4617L, 1.0, 0.0, 0.0, 0.0, -2.0943951023931935, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3814L, 4269L, 1.0, 500000.0, 1300000.0, 0.5672320068981566, -1.5664330036649092, 0.9998335);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3815L, 4152L, 1.0, 500000.0, 1300000.0, 0.5672320068981566, -1.5664330036649092, 0.9998335);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3816L, 4759L, 1.0, 500000.0, 1300000.0, 0.5672320068981566, -1.5664330036649092, 0.9998335);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3825L, 3824L, 1.0, 250000.0, 0.0, 0.0, 2.07694180987325, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3826L, 3824L, 1.0, 250000.0, 0.0, 0.0, 2.1118483949131366, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3827L, 3821L, 1.0, 250000.0, 0.0, 0.0, 2.07694180987325, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3828L, 3821L, 1.0, 250000.0, 0.0, 0.0, 2.1118483949131366, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3829L, 4236L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3833L, 4179L, 1.0, 2500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3834L, 4178L, 1.0, 2500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3835L, 4178L, 1.0, 3500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3836L, 4178L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3837L, 4179L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3838L, 4179L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3839L, 4179L, 1.0, 9500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3840L, 4179L, 1.0, 1.05E7, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3841L, 4178L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3842L, 4178L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3843L, 4178L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3845L, 4619L, 1.0, 1500025.141, -667.282, 0.0, 0.19733128855360868, 1.000006);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3846L, 4619L, 1.0, 1500044.695, -667.13, 0.0, 0.23660148761168973, 1.0000058);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3847L, 4619L, 1.0, 1500064.274, -667.711, 0.0, 0.2758717075458479, 1.00000561024);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3848L, 4619L, 1.0, 1500083.521, -668.844, 0.0, 0.3151418857278518, 1.0000054);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3849L, 4619L, 1.0, 1500102.765, -670.706, 0.0, 0.35441208478593283, 1.0000052);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3850L, 4619L, 1.0, 1500121.846, -672.557, 0.0, 0.3936822838440139, 1.0000049);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3854L, 4619L, 1.0, 100182.7406, -6500620.1207, 0.0, 0.31516928739710814, 0.99999506);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3873L, 4258L, 1.0, 1.95E7, 0.0, 0.0, 0.3316125578789223, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3874L, 4258L, 1.0, 2.05E7, 0.0, 0.0, 0.34906585039886556, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3875L, 4258L, 1.0, 2.15E7, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3876L, 4258L, 1.0, 2.25E7, 0.0, 0.0, 0.3839724354387521, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3877L, 4258L, 1.0, 2.35E7, 0.0, 0.0, 0.4014257279586954, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3878L, 4258L, 1.0, 2.45E7, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3879L, 4258L, 1.0, 2.55E7, 0.0, 0.0, 0.43633231299858194, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3880L, 4258L, 1.0, 2.65E7, 0.0, 0.0, 0.4537856055185252, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3881L, 4258L, 1.0, 2.75E7, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3882L, 4258L, 1.0, 2.85E7, 0.0, 0.0, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3883L, 4258L, 1.0, 2.95E7, 0.0, 0.0, 0.506145483078355, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3884L, 4258L, 1.0, 3.05E7, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3885L, 4258L, 1.0, 3.15E7, 0.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3890L, 3889L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3891L, 3889L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3892L, 3889L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3893L, 4230L, 1.0, 800000.0, 0.0, 0.5066039519840331, 0.8115781021773624, 0.9994);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3907L, 3906L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3908L, 3906L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3909L, 3906L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3910L, 3906L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3911L, 3906L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3912L, 3906L, 1.0, 500000.0, -5000000.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3920L, 4139L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3986L, 4695L, 1.0, 200000.0, 500000.0, -0.1570796326794895, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3987L, 4695L, 1.0, 200000.0, 500000.0, -0.1570796326794895, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3988L, 4695L, 1.0, 200000.0, 500000.0, -0.1570796326794895, 0.4537856055185252, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3989L, 4695L, 1.0, 200000.0, 500000.0, -0.1570796326794895, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3997L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.9657488527701947, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4026L, 4023L, 1.0, 200000.0, -5000000.0, 0.0, 0.4956735075663891, 0.99994);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4037L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4038L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4048L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.20943951023931934, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4049L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.2443460952792059, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4050L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.27925268031909245, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4051L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.314159265358979, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4056L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.34906585039886556, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4057L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.3839724354387521, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4058L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.4188790204786387, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4059L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.4537856055185252, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4060L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.4886921905584118, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4061L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4062L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4063L, 4046L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4071L, 4224L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4082L, 4081L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4083L, 4081L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4093L, 4258L, 1.0, 200000.0, -5000000.0, 0.0, 0.1570796326794895, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4094L, 4258L, 1.0, 400000.0, -5000000.0, 0.0, 0.17453292519943278, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4095L, 4258L, 1.0, 600000.0, -5000000.0, 0.0, 0.2050761871093335, 0.99998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4096L, 4258L, 1.0, 800000.0, -5000000.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4217L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4399L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4400L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4401L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4402L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4403L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4404L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4405L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4406L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4407L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4408L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4409L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4410L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4411L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4412L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4413L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4414L, 4152L, 1.0, 100000.0, 200000.0, 0.23561944901923426, 2.5263640922617894, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4417L, 4178L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4418L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4419L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4420L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4421L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4422L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4423L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4424L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4425L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4426L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4427L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4428L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4429L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4430L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4431L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4432L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4433L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4434L, 4178L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4438L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4439L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4467L, 4463L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4471L, 4470L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4474L, 4632L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4484L, 4483L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4485L, 4483L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4486L, 4483L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4487L, 4483L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4488L, 4483L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4489L, 4483L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4491L, 4490L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4492L, 4490L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4493L, 4490L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4494L, 4490L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4495L, 4490L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4496L, 4490L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4497L, 4490L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4498L, 4490L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4499L, 4490L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4500L, 4490L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4501L, 4490L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4502L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4503L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4504L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4505L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4506L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4507L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4508L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4509L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4510L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4511L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4512L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4513L, 4490L, 1.0, 2.55E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4514L, 4490L, 1.0, 2.65E7, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4515L, 4490L, 1.0, 2.75E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4516L, 4490L, 1.0, 2.85E7, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4517L, 4490L, 1.0, 2.95E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4518L, 4490L, 1.0, 3.05E7, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4519L, 4490L, 1.0, 3.15E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4520L, 4490L, 1.0, 3.25E7, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4521L, 4490L, 1.0, 3.35E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4522L, 4490L, 1.0, 3.45E7, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4523L, 4490L, 1.0, 3.55E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4524L, 4490L, 1.0, 3.65E7, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4525L, 4490L, 1.0, 3.75E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4526L, 4490L, 1.0, 3.85E7, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4527L, 4490L, 1.0, 3.95E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4528L, 4490L, 1.0, 4.05E7, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4529L, 4490L, 1.0, 4.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4530L, 4490L, 1.0, 4.25E7, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4531L, 4490L, 1.0, 4.35E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4532L, 4490L, 1.0, 4.45E7, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4533L, 4490L, 1.0, 4.55E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4534L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4535L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4536L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4537L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4538L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4539L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4540L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4541L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4542L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4543L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4544L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4545L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4546L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4547L, 4490L, 1.0, 500000.0, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4548L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4549L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4550L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4551L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4552L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4553L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4554L, 4490L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4559L, 4558L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4568L, 4555L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4569L, 4555L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4570L, 4555L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4571L, 4555L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4572L, 4555L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4573L, 4555L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4574L, 4555L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4575L, 4555L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4576L, 4555L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4577L, 4555L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4578L, 4555L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4579L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4580L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4581L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4582L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4583L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4584L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4585L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4586L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4587L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4588L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4589L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4647L, 4258L, 1.0, 3.25E7, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4652L, 4555L, 1.0, 2.55E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4653L, 4555L, 1.0, 2.65E7, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4654L, 4555L, 1.0, 2.75E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4655L, 4555L, 1.0, 2.85E7, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4656L, 4555L, 1.0, 2.95E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4766L, 4555L, 1.0, 3.05E7, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4767L, 4555L, 1.0, 3.15E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4768L, 4555L, 1.0, 3.25E7, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4769L, 4555L, 1.0, 3.35E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4770L, 4555L, 1.0, 3.45E7, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4771L, 4555L, 1.0, 3.55E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4772L, 4555L, 1.0, 3.65E7, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4773L, 4555L, 1.0, 3.75E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4774L, 4555L, 1.0, 3.85E7, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4775L, 4555L, 1.0, 3.95E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4776L, 4555L, 1.0, 4.05E7, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4777L, 4555L, 1.0, 4.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4778L, 4555L, 1.0, 4.25E7, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4779L, 4555L, 1.0, 4.35E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4780L, 4555L, 1.0, 4.45E7, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4781L, 4555L, 1.0, 4.55E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4782L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4783L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4784L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4785L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.4660765716752353, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4786L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4787L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4788L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4789L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.6755160819145547, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4790L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4791L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.7802358370342144, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4792L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4793L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.884955592153874, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4794L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4795L, 4555L, 1.0, 500000.0, 0.0, 0.0, 1.9896753472735336, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4796L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4797L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.0943951023931935, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4798L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4799L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.199114857512853, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4800L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4812L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.303834612632513, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4822L, 4555L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4855L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.09599310885968802, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4856L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.1134464013796313, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4857L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.1308996938995746, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4858L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.14835298641951786, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4859L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.16580627893946115, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4860L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.1832595714594044, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4861L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.2007128639793477, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4862L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.21816615649929097, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4863L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.23561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4864L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.2530727415391775, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4865L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.2705260340591208, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4866L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.2879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4867L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.3054326190990074, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4868L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.32288591161895064, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4869L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.3403392041388939, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4870L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.35779249665883717, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4871L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.3752457891787805, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4872L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.39269908169872375, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4873L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.410152374218667, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4874L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.4276056667386103, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4875L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.4450589592585536, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4876L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.46251225177849686, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4877L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.4799655442984401, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4878L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.4974188368183834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4879L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.5148721293383267, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4880L, 4258L, 1.0, 100000.0, 1000000.0, 0.0, 0.5323254218582699, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5014L, 5013L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5015L, 5013L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5016L, 5013L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5018L, 4207L, 1.0, 0.0, 0.0, 0.6923139366244166, -0.1419285361019366, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5253L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5254L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5255L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5256L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5257L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5258L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5259L, 5252L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5269L, 5252L, 1.0, 9500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5270L, 5252L, 1.0, 1.05E7, 0.0, 0.0, 0.5235987755982984, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5271L, 5252L, 1.0, 1.15E7, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5272L, 5252L, 1.0, 1.25E7, 0.0, 0.0, 0.628318530717958, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5273L, 5252L, 1.0, 1.35E7, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5274L, 5252L, 1.0, 1.45E7, 0.0, 0.0, 0.7330382858376177, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5275L, 5252L, 1.0, 1.55E7, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5531L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5533L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5534L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5535L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5858L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5875L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5876L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(5877L, 5527L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(6210L, 4674L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(7852L, 7844L, 1.0, 500000.0, 1.0E7, 0.0, 2.251474735072685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(7853L, 7844L, 1.0, 500000.0, 1.0E7, 0.0, 2.356194490192345, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20004L, 4200L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20005L, 4200L, 1.0, 5500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20006L, 4200L, 1.0, 6500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20007L, 4200L, 1.0, 7500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20008L, 4200L, 1.0, 8500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20009L, 4200L, 1.0, 9500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20010L, 4200L, 1.0, 1.05E7, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20011L, 4200L, 1.0, 1.15E7, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20012L, 4200L, 1.0, 1.25E7, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20013L, 4200L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20014L, 4200L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20015L, 4200L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20016L, 4200L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20017L, 4200L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20018L, 4200L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20019L, 4200L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20020L, 4200L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20021L, 4200L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20022L, 4200L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20023L, 4200L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20024L, 4200L, 1.0, 2.45E7, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20025L, 4200L, 1.0, 2.55E7, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20026L, 4200L, 1.0, 2.65E7, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20027L, 4200L, 1.0, 2.75E7, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20028L, 4200L, 1.0, 2.85E7, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20029L, 4200L, 1.0, 2.95E7, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20030L, 4200L, 1.0, 3.05E7, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20031L, 4200L, 1.0, 3.15E7, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20032L, 4200L, 1.0, 3.25E7, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20064L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20065L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20066L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20067L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20068L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20069L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20070L, 4200L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20071L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20072L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20073L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20074L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20075L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20076L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20077L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20078L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20079L, 4200L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20080L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20081L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20082L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20083L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20084L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20085L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20086L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20087L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20088L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20089L, 4200L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20090L, 4200L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20091L, 4200L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20092L, 4200L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20135L, 4201L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20136L, 4201L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20137L, 4201L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20138L, 4201L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20248L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20249L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20250L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20251L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20252L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20253L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20254L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20255L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20256L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20257L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20258L, 4202L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20348L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20349L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20350L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20351L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20352L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20353L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20354L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20355L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20356L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20357L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20358L, 4203L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20436L, 4204L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20437L, 4204L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20438L, 4204L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20439L, 4204L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20440L, 4204L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20499L, 4204L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20538L, 4205L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20539L, 4205L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20790L, 4803L, 1.0, 200000.0, 300000.0, 0.6923139366244166, 0.017453292519943278, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20791L, 4803L, 1.0, 0.0, 0.0, 0.6923139366244166, 0.017453292519943278, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20822L, 4208L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20823L, 4208L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20824L, 4208L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20934L, 4209L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20935L, 4209L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20936L, 4209L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21035L, 4210L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21036L, 4210L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21037L, 4210L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21095L, 4210L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21096L, 4210L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21097L, 4210L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21148L, 4211L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21149L, 4211L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21150L, 4211L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21291L, 4212L, 1.0, 400000.0, 0.0, 0.0, -1.0821041362364832, 0.9995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21292L, 4212L, 1.0, 30000.0, 75000.0, 0.22997136963430817, -1.0395132543510106, 0.9999986);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21413L, 4214L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21414L, 4214L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21415L, 4214L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21416L, 4214L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21417L, 4214L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21418L, 4214L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21419L, 4214L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21420L, 4214L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21421L, 4214L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21422L, 4214L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21423L, 4214L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21453L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21454L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21455L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21456L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21457L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21458L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21459L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21460L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21461L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21462L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21463L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21473L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21474L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21475L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21476L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21477L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21478L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21479L, 4214L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21480L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21481L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21482L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21483L, 4214L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21817L, 4218L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21818L, 4218L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21891L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.3453157862887044, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21892L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.2929559087288747, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21893L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.2405960311690447, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21894L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.188236153609215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21896L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.3453157862887044, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21897L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.2929559087288747, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21898L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.2405960311690447, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(21899L, 4218L, 1.0, 1000000.0, 1000000.0, 0.08026851648247701, -1.188236153609215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22032L, 4220L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22033L, 4220L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22091L, 4220L, 1.0, 500000.0, 1.0E7, 0.0, 0.2007128639793477, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22092L, 4220L, 1.0, 500000.0, 1.0E7, 0.0, 0.20943951023931934, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22171L, 4190L, 1.0, 1500000.0, 0.0, -1.570796326794895, -1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22172L, 4190L, 1.0, 2500000.0, 0.0, -1.570796326794895, -1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22173L, 4190L, 1.0, 3500000.0, 0.0, -1.570796326794895, -1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22174L, 4190L, 1.0, 4500000.0, 0.0, -1.570796326794895, -1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22175L, 4190L, 1.0, 5500000.0, 0.0, -1.570796326794895, -1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22176L, 4190L, 1.0, 6500000.0, 0.0, -1.570796326794895, -0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22177L, 4190L, 1.0, 7500000.0, 0.0, -1.570796326794895, -0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22181L, 4694L, 1.0, 1500000.0, 0.0, -1.570796326794895, -1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22182L, 4694L, 1.0, 2500000.0, 0.0, -1.570796326794895, -1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22183L, 4694L, 1.0, 3500000.0, 0.0, -1.570796326794895, -1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22184L, 4694L, 1.0, 4500000.0, 0.0, -1.570796326794895, -1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22185L, 4694L, 1.0, 5500000.0, 0.0, -1.570796326794895, -1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22186L, 4694L, 1.0, 6500000.0, 0.0, -1.570796326794895, -0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22187L, 4694L, 1.0, 7500000.0, 0.0, -1.570796326794895, -0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22191L, 4221L, 1.0, 1500000.0, 0.0, -1.570796326794895, -1.256637061435916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22192L, 4221L, 1.0, 2500000.0, 0.0, -1.570796326794895, -1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22193L, 4221L, 1.0, 3500000.0, 0.0, -1.570796326794895, -1.1519173063162564, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22194L, 4221L, 1.0, 4500000.0, 0.0, -1.570796326794895, -1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22195L, 4221L, 1.0, 5500000.0, 0.0, -1.570796326794895, -1.0471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22196L, 4221L, 1.0, 6500000.0, 0.0, -1.570796326794895, -0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22197L, 4221L, 1.0, 7500000.0, 0.0, -1.570796326794895, -0.942477796076937, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22234L, 4222L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22235L, 4222L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22236L, 4222L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22332L, 4223L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22521L, 4225L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22522L, 4225L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22523L, 4225L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22524L, 4225L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22525L, 4225L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22832L, 4228L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22991L, 4229L, 1.0, 300000.0, 1100000.0, 0.5235987755982984, 0.6108652381980147, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22992L, 4229L, 1.0, 615000.0, 810000.0, 0.5235987755982984, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22993L, 4229L, 1.0, 700000.0, 200000.0, 0.5235987755982984, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(22994L, 4229L, 1.0, 700000.0, 1200000.0, 0.5235987755982984, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23028L, 4230L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23029L, 4230L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23030L, 4230L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23031L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23032L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23033L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23034L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23035L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23036L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23037L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23038L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23090L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.0, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23095L, 4230L, 1.0, 500000.0, 0.0, 0.0, 0.08726646259971639, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23239L, 4232L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23240L, 4232L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23433L, 4234L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23830L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.6493361431346398, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23831L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.7016960206944696, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23832L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.7540558982542993, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23833L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.8064157758141293, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23834L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.858775653373959, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23835L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.911135530933789, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23836L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 1.9634954084936187, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23837L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.0158552860534487, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23838L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.0682151636132784, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23839L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.120575041173108, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23840L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.172934918732938, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23841L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.225294796292768, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23842L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.277654673852598, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23843L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.3300145514124275, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23844L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.3823744289722573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23845L, 4755L, 1.0, 200000.0, 1500000.0, 0.0, 2.4347343065320874, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23846L, 4238L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23847L, 4238L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23848L, 4238L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23849L, 4238L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23850L, 4238L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23851L, 4238L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23852L, 4238L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23853L, 4238L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23866L, 4755L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23867L, 4755L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23868L, 4755L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23869L, 4755L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23870L, 4755L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23871L, 4755L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23872L, 4755L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23877L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23878L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23879L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23880L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23881L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23882L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23883L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23884L, 4755L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23886L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23887L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23888L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23889L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23890L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23891L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23892L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23893L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23894L, 4238L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23946L, 4239L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23947L, 4239L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(23948L, 4239L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24047L, 4240L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24048L, 4240L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24305L, 4144L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24306L, 4144L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24311L, 4145L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24312L, 4145L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24313L, 4145L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24342L, 4146L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24343L, 4146L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24344L, 4146L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24345L, 4146L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24346L, 4146L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24347L, 4146L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24547L, 4245L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24548L, 4245L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24718L, 4247L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24719L, 4247L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24720L, 4247L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24817L, 4248L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24818L, 4248L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24819L, 4248L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24820L, 4248L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24821L, 4248L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24877L, 4248L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24878L, 4248L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24879L, 4248L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24880L, 4248L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24881L, 4248L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24882L, 4248L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24891L, 4248L, 1.0, 222000.0, 1426834.743, -0.10471975511965967, -1.4049900478554338, 0.99983008);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24892L, 4248L, 1.0, 720000.0, 1039979.159, -0.16580627893946115, -1.3264502315156892, 0.99932994);
        TransverseMercatorSrid.registerTransverseMercatorSrid(24893L, 4248L, 1.0, 1324000.0, 1040084.558, -0.16580627893946115, -1.230457122656001, 0.99952992);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25000L, 4250L, 1.0, 274319.51, 0.0, 0.08144869842640197, -0.017453292519943278, 0.99975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25231L, 4252L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25391L, 4253L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25392L, 4253L, 1.0, 500000.0, 0.0, 0.0, 2.07694180987325, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25393L, 4253L, 1.0, 500000.0, 0.0, 0.0, 2.1118483949131366, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25394L, 4253L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25395L, 4253L, 1.0, 500000.0, 0.0, 0.0, 2.18166156499291, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25828L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25829L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25830L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25831L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25832L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25833L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25834L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25835L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25836L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25837L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25838L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25884L, 4258L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(25932L, 4259L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26237L, 4262L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26331L, 4263L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26332L, 4263L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26391L, 4263L, 1.0, 230738.26, 0.0, 0.06981317007977311, 0.07853981633974474, 0.99975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26392L, 4263L, 1.0, 670553.98, 0.0, 0.06981317007977311, 0.14835298641951786, 0.99975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26393L, 4263L, 1.0, 1110369.7, 0.0, 0.06981317007977311, 0.21816615649929097, 0.99975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26432L, 4264L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26591L, 4806L, 1.0, 1500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26592L, 4806L, 1.0, 2520000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26632L, 4266L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26692L, 4266L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26701L, 4267L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26702L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26703L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26704L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26705L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26706L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26707L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26708L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26709L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26710L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26711L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26712L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26713L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26714L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26715L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26716L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26717L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26718L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26719L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26720L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26721L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26722L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26729L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5323254218582699, -1.4980742746284648, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26730L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26732L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26733L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.5481807079117185, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26734L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.6179938779914917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26735L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26736L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.757620218151038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26737L, 4267L, 3.2808333333333333, 213360.42672085343, 0.0, 0.942477796076937, -2.827433388230811, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26738L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.897246558310584, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26739L, 4267L, 3.2808333333333333, 182880.3657607315, 0.0, 0.942477796076937, -2.9670597283903573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26748L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26749L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26750L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26757L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26758L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26759L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26766L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26767L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26768L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26769L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26770L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26771L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26772L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26773L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26774L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26783L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.765035988790847, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26784L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26794L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5177810114249839, -1.5504341521882945, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26795L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5323254218582699, -1.5766140909682094, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26796L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6254096486313008, -1.5795229730548666, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26797L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6254096486313008, -1.6144295580947532, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26798L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6312274128046153, -1.6493361431346398, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26801L, 4268L, 3.2808333333333333, 152400.3048006096, 0.0, 0.724311639577646, -1.460258807501921, 0.999942857);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26802L, 4268L, 3.2808333333333333, 152400.3048006096, 0.0, 0.724311639577646, -1.4966198335851362, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26803L, 4268L, 3.2808333333333333, 152400.3048006096, 0.0, 0.724311639577646, -1.548979711144966, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26814L, 4269L, 1.0, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26815L, 4269L, 1.0, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26825L, 4152L, 1.0, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26826L, 4152L, 1.0, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26836L, 4759L, 1.0, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26837L, 4759L, 1.0, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26847L, 4269L, 3.2808333333333333, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26848L, 4269L, 3.2808333333333333, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26855L, 4152L, 3.2808333333333333, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26856L, 4152L, 3.2808333333333333, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26863L, 4759L, 3.2808333333333333, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26864L, 4759L, 3.2808333333333333, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26891L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.4398966328953204, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26892L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.4137166941154056, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26893L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.4660765716752353, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26894L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.5184364492350653, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26895L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.570796326794895, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26896L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.6231562043547247, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26897L, 4617L, 1.0, 304800.0, 0.0, 0.0, -1.6755160819145547, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26898L, 4617L, 1.0, 304800.0, 0.0, 0.0, -0.9250245035569937, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26899L, 4617L, 1.0, 304800.0, 0.0, 0.0, -0.9773843811168236, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26901L, 4269L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26902L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26903L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26904L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26905L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26906L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26907L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26908L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26909L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26910L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26911L, 4269L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26912L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26913L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26914L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26915L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26916L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26917L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26918L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26919L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26920L, 4269L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26921L, 4269L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26922L, 4269L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26923L, 4269L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26929L, 4269L, 1.0, 200000.0, 0.0, 0.5323254218582699, -1.4980742746284648, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26930L, 4269L, 1.0, 600000.0, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26932L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26933L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.5481807079117185, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26934L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.6179938779914917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26935L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26936L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.757620218151038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26937L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.827433388230811, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26938L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.897246558310584, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26939L, 4269L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.9670597283903573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26948L, 4269L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9227710592804177, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26949L, 4269L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9533143211903186, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26950L, 4269L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26957L, 4269L, 1.0, 200000.0, 0.0, 0.6632251157578446, -1.3162691442123888, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26958L, 4269L, 1.0, 200000.0, 0.0, 0.4246967846519531, -1.4137166941154056, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26959L, 4269L, 1.0, 200000.0, 0.0, 0.4246967846519531, -1.4311699866353487, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26961L, 4269L, 1.0, 500000.0, 0.0, 0.32870367579226506, -2.7139869868511797, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26962L, 4269L, 1.0, 500000.0, 0.0, 0.35488361457218, -2.7343491614577804, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26963L, 4269L, 1.0, 500000.0, 0.0, 0.36942802500546607, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26964L, 4269L, 1.0, 500000.0, 0.0, 0.3810635533520949, -2.783800156930953, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26965L, 4269L, 1.0, 500000.0, 0.0, 0.37815467126543767, -2.7954356852775817, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26966L, 4269L, 1.0, 200000.0, 0.0, 0.5235987755982984, -1.434078868722006, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26967L, 4269L, 1.0, 700000.0, 0.0, 0.5235987755982984, -1.4689854537618925, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26968L, 4269L, 1.0, 200000.0, 0.0, 0.7272205216643033, -1.9576776443203043, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26969L, 4269L, 1.0, 500000.0, 0.0, 0.7272205216643033, -1.9896753472735336, 0.999947368);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26970L, 4269L, 1.0, 800000.0, 0.0, 0.7272205216643033, -2.020218609183434, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26971L, 4269L, 1.0, 300000.0, 0.0, 0.6399540590645868, -1.541707505928323, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26972L, 4269L, 1.0, 700000.0, 0.0, 0.6399540590645868, -1.5737052088815522, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26973L, 4269L, 1.0, 100000.0, 250000.0, 0.6544984694978729, -1.4951653925418074, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26974L, 4269L, 1.0, 900000.0, 250000.0, 0.6544984694978729, -1.5198908902783939, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26983L, 4269L, 1.0, 300000.0, 0.0, 0.7621271067041898, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26984L, 4269L, 1.0, 900000.0, 0.0, 0.7475826962709037, -1.2246393584826867, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26994L, 4269L, 1.0, 300000.0, 0.0, 0.5148721293383267, -1.5504341521882945, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26995L, 4269L, 1.0, 700000.0, 0.0, 0.5148721293383267, -1.5766140909682094, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26996L, 4269L, 1.0, 250000.0, 0.0, 0.6254096486313008, -1.5795229730548666, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26997L, 4269L, 1.0, 500000.0, 0.0, 0.6254096486313008, -1.6144295580947532, 0.999933333);
        TransverseMercatorSrid.registerTransverseMercatorSrid(26998L, 4269L, 1.0, 850000.0, 0.0, 0.6312274128046153, -1.6493361431346398, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27037L, 4270L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27038L, 4270L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27039L, 4270L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27040L, 4270L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27120L, 4271L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27205L, 4272L, 1.0, 300000.0, 700000.0, -0.6436750767891547, 3.0502131369241092, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27206L, 4272L, 1.0, 300000.0, 700000.0, -0.6590581387750123, 3.07991616048626, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27207L, 4272L, 1.0, 300000.0, 700000.0, -0.6741282360764213, 3.1046900450522896, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27208L, 4272L, 1.0, 300000.0, 700000.0, -0.6920392678574525, 3.0835374268263123, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27209L, 4272L, 1.0, 300000.0, 700000.0, -0.6830478376966608, 3.0408524542408646, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27210L, 4272L, 1.0, 300000.0, 700000.0, -0.6896227038828747, 3.0654969405809647, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27211L, 4272L, 1.0, 300000.0, 700000.0, -0.7023544749871222, 3.062845136281666, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27212L, 4272L, 1.0, 300000.0, 700000.0, -0.7142852926810139, 3.0656245740850947, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27213L, 4272L, 1.0, 300000.0, 700000.0, -0.7208440131172058, 3.050427528806101, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27214L, 4272L, 1.0, 300000.0, 700000.0, -0.7106065996756206, 3.013695737581748, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27215L, 4272L, 1.0, 300000.0, 700000.0, -0.7203767026644254, 3.0246436697136834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27216L, 4272L, 1.0, 300000.0, 700000.0, -0.7206449040168836, 3.003869214400804, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27217L, 4272L, 1.0, 300000.0, 700000.0, -0.7297361728286536, 2.9946579226900703, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27218L, 4272L, 1.0, 300000.0, 700000.0, -0.7388623496799044, 2.9941083403252327, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27219L, 4272L, 1.0, 300000.0, 700000.0, -0.7450656391468782, 3.019596466950683, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27220L, 4272L, 1.0, 300000.0, 700000.0, -0.7250880783842165, 3.0334184400340827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27221L, 4272L, 1.0, 300000.0, 700000.0, -0.7485075292730566, 2.9841638416135003, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27222L, 4272L, 1.0, 300000.0, 700000.0, -0.7524136769802656, 2.971613743285534, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27223L, 4272L, 1.0, 300000.0, 700000.0, -0.7675574582041843, 2.9427344986466593, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27224L, 4272L, 1.0, 300000.0, 700000.0, -0.7608001488727499, 3.014658235758786, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27225L, 4272L, 1.0, 300000.0, 700000.0, -0.7635590601497338, 2.9908092695221176, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27226L, 4272L, 1.0, 300000.0, 700000.0, -0.7749649404974537, 2.985512236451478, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27227L, 4272L, 1.0, 300000.0, 700000.0, -0.7807777178772441, 2.9577703021675212, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27228L, 4272L, 1.0, 300000.0, 700000.0, -0.7877177510610203, 2.9391107447276092, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27229L, 4272L, 1.0, 300000.0, 700000.0, -0.7952370410854271, 2.927595421569888, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27230L, 4272L, 1.0, 300000.0, 700000.0, -0.7996434816049561, 2.978030783710813, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27231L, 4272L, 1.0, 300000.0, 700000.0, -0.8004344080987592, 2.9719918388095303, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27232L, 4272L, 1.0, 300002.66, 699999.58, -0.8133235991748904, 2.938137388663369, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27258L, 4272L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27259L, 4272L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27260L, 4272L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27291L, 4272L, 1.0936151944444445, 274319.5243848086, 365759.3658464115, -0.6806784082777878, 3.063052837250045, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27292L, 4272L, 1.0936151944444445, 457199.2073080144, 457199.2073080144, -0.7679448708775042, 2.9932396671702723, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27391L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, -0.08144869842640197, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27392L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, -0.04072434921320098, 1.0);
    }

    private static void loadTransverseMercatorSRIDs3() {
        TransverseMercatorSrid.registerTransverseMercatorSrid(27393L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, 0.0, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27394L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, 0.043633231299858195, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27395L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, 0.10762863720631688, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27396L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, 0.17744180728609, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27397L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, 0.2472549773658631, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27398L, 4817L, 1.0, 0.0, 0.0, 1.01229096615671, 0.3199770295322934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27429L, 4274L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27492L, 4274L, 1.0, 180.598, -86.99, 0.6923139366244166, -0.1419285361019366, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27493L, 4274L, 1.0, 180.598, -86.99, 0.6923139366244166, -0.1419285361019366, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(27700L, 4277L, 1.0, 400000.0, -100000.0, 0.8552113334772206, -0.034906585039886556, 0.9996012717);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28192L, 4281L, 1.0, 170251.555, 1126867.909, 0.5538644768276271, 0.6145667421719179, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28232L, 4282L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28348L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28349L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28350L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28351L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28352L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28353L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28354L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28355L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28356L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28357L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28358L, 4283L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28402L, 4284L, 1.0, 2500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28403L, 4284L, 1.0, 3500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28404L, 4284L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28405L, 4284L, 1.0, 5500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28406L, 4284L, 1.0, 6500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28407L, 4284L, 1.0, 7500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28408L, 4284L, 1.0, 8500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28409L, 4284L, 1.0, 9500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28410L, 4284L, 1.0, 1.05E7, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28411L, 4284L, 1.0, 1.15E7, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28412L, 4284L, 1.0, 1.25E7, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28413L, 4284L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28414L, 4284L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28415L, 4284L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28416L, 4284L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28417L, 4284L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28418L, 4284L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28419L, 4284L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28420L, 4284L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28421L, 4284L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28422L, 4284L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28423L, 4284L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28424L, 4284L, 1.0, 2.45E7, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28425L, 4284L, 1.0, 2.55E7, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28426L, 4284L, 1.0, 2.65E7, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28427L, 4284L, 1.0, 2.75E7, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28428L, 4284L, 1.0, 2.85E7, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28429L, 4284L, 1.0, 2.95E7, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28430L, 4284L, 1.0, 3.05E7, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28431L, 4284L, 1.0, 3.15E7, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28432L, 4284L, 1.0, 3.25E7, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28462L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28463L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28464L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28465L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28466L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28467L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28468L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28469L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28470L, 4284L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28471L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28472L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28473L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28474L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28475L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28476L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28477L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28478L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28479L, 4284L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28480L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28481L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28482L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28483L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28484L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28485L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28486L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28487L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28488L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28489L, 4284L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28490L, 4284L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28491L, 4284L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28492L, 4284L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(28600L, 4285L, 1.0, 200000.0, 300000.0, 0.42673300211261317, 0.8938994652297615, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29118L, 4291L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29119L, 4291L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29120L, 4291L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29121L, 4291L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29122L, 4291L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29168L, 4618L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29169L, 4618L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29170L, 4618L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29171L, 4618L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29172L, 4618L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29177L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29178L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29179L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29180L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29181L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29182L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29183L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29184L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29185L, 4291L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29187L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29188L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29189L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29190L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29191L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29192L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29193L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29194L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29195L, 4618L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29220L, 4292L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29221L, 4292L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29333L, 4293L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29635L, 4296L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29636L, 4296L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29738L, 4297L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29739L, 4297L, 1.0, 500000.0, 1.0E7, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29849L, 4298L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29850L, 4298L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29900L, 4299L, 1.0, 200000.0, 250000.0, 0.9337511498169654, -0.13962634015954623, 1.000035);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29901L, 4188L, 1.0, 200000.0, 250000.0, 0.9337511498169654, -0.13962634015954623, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29902L, 4299L, 1.0, 200000.0, 250000.0, 0.9337511498169654, -0.13962634015954623, 1.000035);
        TransverseMercatorSrid.registerTransverseMercatorSrid(29903L, 4300L, 1.0, 200000.0, 250000.0, 0.9337511498169654, -0.13962634015954623, 1.000035);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30161L, 4301L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.2602013813326547, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30162L, 4301L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.2863813201125693, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30163L, 4301L, 1.0, 0.0, 0.0, 0.628318530717958, 2.30674349471917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30164L, 4301L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.3300145514124275, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30165L, 4301L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3445589618457134, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30166L, 4301L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3736477827122857, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30167L, 4301L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3940099573188864, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30168L, 4301L, 1.0, 0.0, 0.0, 0.628318530717958, 2.417281014012144, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30169L, 4301L, 1.0, 0.0, 0.0, 0.628318530717958, 2.440552070705402, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30170L, 4301L, 1.0, 0.0, 0.0, 0.6981317007977311, 2.458005363225345, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30171L, 4301L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.4478242759220445, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30172L, 4301L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.482730860961931, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30173L, 4301L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.517637446001818, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30174L, 4301L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30175L, 4301L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.225294796292768, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30176L, 4301L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.1642082724729663, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30177L, 4301L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.2863813201125693, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30178L, 4301L, 1.0, 0.0, 0.0, 0.34906585039886556, 2.3736477827122857, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30179L, 4301L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30339L, 4303L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30340L, 4303L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30729L, 4307L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30730L, 4307L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30731L, 4307L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30732L, 4307L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(30800L, 4308L, 1.0, 1500000.0, 0.0, 0.0, 0.2759064962920744, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31028L, 4310L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31121L, 4311L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31154L, 4311L, 1.0, 500000.0, 0.0, 0.0, -0.942477796076937, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31170L, 4311L, 1.0, 500000.0, 0.0, 0.0, -0.9718575051521748, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31171L, 4311L, 1.0, 500000.0, 0.0, 0.0, -0.9718575051521748, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31251L, 4805L, 1.0, 0.0, -5000000.0, 0.0, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31252L, 4805L, 1.0, 0.0, -5000000.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31253L, 4805L, 1.0, 0.0, -5000000.0, 0.0, 0.5934119456780714, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31254L, 4312L, 1.0, 0.0, -5000000.0, 0.0, 0.1803506893727472, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31255L, 4312L, 1.0, 0.0, -5000000.0, 0.0, 0.23271056693257702, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31256L, 4312L, 1.0, 0.0, -5000000.0, 0.0, 0.28507044449240687, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31257L, 4312L, 1.0, 150000.0, -5000000.0, 0.0, 0.1803506893727472, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31258L, 4312L, 1.0, 450000.0, -5000000.0, 0.0, 0.23271056693257702, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31259L, 4312L, 1.0, 750000.0, -5000000.0, 0.0, 0.28507044449240687, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31265L, 4312L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31266L, 4312L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31267L, 4312L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31268L, 4312L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31275L, 4312L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31276L, 4312L, 1.0, 6500000.0, 0.0, 0.0, 0.314159265358979, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31277L, 4312L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31278L, 4312L, 1.0, 7500000.0, 0.0, 0.0, 0.3665191429188088, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31279L, 4312L, 1.0, 8500000.0, 0.0, 0.0, 0.4188790204786387, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31281L, 4805L, 1.0, 0.0, 0.0, 0.0, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31282L, 4805L, 1.0, 0.0, 0.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31283L, 4805L, 1.0, 0.0, 0.0, 0.0, 0.5934119456780714, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31284L, 4312L, 1.0, 150000.0, 0.0, 0.0, 0.1803506893727472, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31285L, 4312L, 1.0, 450000.0, 0.0, 0.0, 0.23271056693257702, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31286L, 4312L, 1.0, 750000.0, 0.0, 0.0, 0.28507044449240687, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31288L, 4805L, 1.0, 150000.0, 0.0, 0.0, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31289L, 4805L, 1.0, 450000.0, 0.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31290L, 4805L, 1.0, 750000.0, 0.0, 0.0, 0.5934119456780714, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31291L, 4805L, 1.0, 0.0, 0.0, 0.0, 0.4886921905584118, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31292L, 4805L, 1.0, 0.0, 0.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31293L, 4805L, 1.0, 0.0, 0.0, 0.0, 0.5934119456780714, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31294L, 4312L, 1.0, 150000.0, 0.0, 0.0, 0.1803506893727472, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31295L, 4312L, 1.0, 450000.0, 0.0, 0.0, 0.23271056693257702, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31296L, 4312L, 1.0, 750000.0, 0.0, 0.0, 0.28507044449240687, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31461L, 4314L, 1.0, 1500000.0, 0.0, 0.0, 0.052359877559829834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31462L, 4314L, 1.0, 2500000.0, 0.0, 0.0, 0.10471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31463L, 4314L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31464L, 4314L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31465L, 4314L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31466L, 4314L, 1.0, 2500000.0, 0.0, 0.0, 0.10471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31467L, 4314L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31468L, 4314L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31469L, 4314L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31528L, 4315L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31529L, 4315L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31838L, 4318L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31839L, 4318L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31900L, 4319L, 1.0, 500000.0, 0.0, 0.0, 0.8377580409572774, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31901L, 4319L, 1.0, 500000.0, 0.0, 0.0, 0.8377580409572774, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31965L, 4674L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31966L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31967L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31968L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31969L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31970L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31971L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31972L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31973L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31974L, 4674L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31975L, 4674L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31976L, 4674L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31977L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31978L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31979L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31980L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31981L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31982L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31983L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31984L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31985L, 4674L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31986L, 4170L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31987L, 4170L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31988L, 4170L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31989L, 4170L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31990L, 4170L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31991L, 4170L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31992L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31993L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31994L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31995L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31996L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31997L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31998L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(31999L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32000L, 4170L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32007L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32008L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32009L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32010L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32011L, 4267L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6777695261911306, -1.3031791748224315, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32012L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32013L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32014L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32015L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6981317007977311, -1.297361410649117, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32016L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32017L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32030L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.717039434361003, -1.2479104151759444, 0.9999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32045L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964286);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32055L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.70976722914436, -1.8355045966807013, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32056L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.70976722914436, -1.8733200638072451, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32057L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.70976722914436, -1.8980455615438314, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32058L, 4267L, 3.2808333333333333, 152400.3048006096, 0.0, 0.70976722914436, -1.921316618237089, 0.999941177);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32064L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32065L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32066L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32067L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32074L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32075L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32076L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32077L, 4267L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32081L, 4267L, 1.0, 304800.0, 0.0, 0.0, -0.9250245035569937, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32082L, 4267L, 1.0, 304800.0, 0.0, 0.0, -0.9773843811168236, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32083L, 4267L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32084L, 4267L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32085L, 4267L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32086L, 4267L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32107L, 4269L, 1.0, 200000.0, 8000000.0, 0.6065019150680289, -2.017309727096777, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32108L, 4269L, 1.0, 500000.0, 6000000.0, 0.6065019150680289, -2.036217460660049, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32109L, 4269L, 1.0, 800000.0, 4000000.0, 0.6065019150680289, -2.069669604656607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32110L, 4269L, 1.0, 300000.0, 0.0, 0.7417649320975893, -1.2508192972626015, 0.999966667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32111L, 4269L, 1.0, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32112L, 4269L, 1.0, 165000.0, 0.0, 0.5410520681182416, -1.8209601862474154, 0.999909091);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32113L, 4269L, 1.0, 500000.0, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32114L, 4269L, 1.0, 830000.0, 0.0, 0.5410520681182416, -1.8820467100672167, 0.999916667);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32115L, 4269L, 1.0, 150000.0, 0.0, 0.6777695261911306, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32116L, 4269L, 1.0, 250000.0, 0.0, 0.6981317007977311, -1.3366313188189893, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32117L, 4269L, 1.0, 350000.0, 0.0, 0.6981317007977311, -1.371537903858876, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32130L, 4269L, 1.0, 100000.0, 0.0, 0.717039434361003, -1.2479104151759444, 0.99999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32145L, 4269L, 1.0, 500000.0, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964286);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32155L, 4269L, 1.0, 200000.0, 0.0, 0.7068583470577028, -1.8355045966807013, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32156L, 4269L, 1.0, 400000.0, 100000.0, 0.7068583470577028, -1.8733200638072451, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32157L, 4269L, 1.0, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32158L, 4269L, 1.0, 800000.0, 100000.0, 0.7068583470577028, -1.921316618237089, 0.9999375);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32164L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32165L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32166L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32167L, 4269L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32180L, 4269L, 1.0, 304800.0, 0.0, 0.0, -0.9686577348568519, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32181L, 4269L, 1.0, 304800.0, 0.0, 0.0, -0.9250245035569937, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32182L, 4269L, 1.0, 304800.0, 0.0, 0.0, -0.9773843811168236, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32183L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32184L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32185L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32186L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32187L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.230457122656001, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32188L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32189L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32190L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32191L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.4398966328953204, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32192L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.4137166941154056, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32193L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.4660765716752353, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32194L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.5184364492350653, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32195L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.570796326794895, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32196L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.6231562043547247, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32197L, 4269L, 1.0, 304800.0, 0.0, 0.0, -1.6755160819145547, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32201L, 4322L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32202L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32203L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32204L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32205L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32206L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32207L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32208L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32209L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32210L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32211L, 4322L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32212L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32213L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32214L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32215L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32216L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32217L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32218L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32219L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32220L, 4322L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32221L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32222L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32223L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32224L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32225L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32226L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32227L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32228L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32229L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32230L, 4322L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32231L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32232L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32233L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32234L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32235L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32236L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32237L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32238L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32239L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32240L, 4322L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32241L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32242L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32243L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32244L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32245L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32246L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32247L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32248L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32249L, 4322L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32250L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32251L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32252L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32253L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32254L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32255L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32256L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32257L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32258L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32259L, 4322L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32260L, 4322L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32301L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32302L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32303L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32304L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32305L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32306L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32307L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32308L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32309L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32310L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32311L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32312L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32313L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32314L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32315L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32316L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32317L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32318L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32319L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32320L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32321L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32322L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32323L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32324L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32325L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32326L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32327L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32328L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32329L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32330L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32331L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32332L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32333L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32334L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32335L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32336L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32337L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32338L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32339L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32340L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32341L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32342L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32343L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32344L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32345L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32346L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32347L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32348L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32349L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32350L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32351L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32352L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32353L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32354L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32355L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32356L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32357L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32358L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32359L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32360L, 4322L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32401L, 4324L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32402L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32403L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32404L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32405L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32406L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32407L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32408L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32409L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32410L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32411L, 4324L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32412L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32413L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32414L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32415L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32416L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32417L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32418L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32419L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32420L, 4324L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32421L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32422L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32423L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32424L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32425L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32426L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32427L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32428L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32429L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32430L, 4324L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32431L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32432L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32433L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32434L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32435L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32436L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32437L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32438L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32439L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32440L, 4324L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32441L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32442L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32443L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32444L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32445L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32446L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32447L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32448L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32449L, 4324L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32450L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32451L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32452L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32453L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32454L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32455L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32456L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32457L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32458L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32459L, 4324L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32460L, 4324L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32501L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32502L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32503L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32504L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32505L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32506L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32507L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32508L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32509L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32510L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32511L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32512L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32513L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32514L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32515L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32516L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32517L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32518L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32519L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32520L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32521L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32522L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32523L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32524L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32525L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32526L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32527L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32528L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32529L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32530L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32531L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32532L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32533L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32534L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32535L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32536L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32537L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32538L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32539L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32540L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32541L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32542L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32543L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32544L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32545L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32546L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32547L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32548L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32549L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32550L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32551L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32552L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32553L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32554L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32555L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32556L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32557L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32558L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32559L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32560L, 4324L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32601L, 4326L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32602L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32603L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32604L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32605L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32606L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32607L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32608L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32609L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32610L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32611L, 4326L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32612L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32613L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32614L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32615L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32616L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32617L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32618L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32619L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32620L, 4326L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32621L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32622L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32623L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32624L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32625L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32626L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32627L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32628L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32629L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32630L, 4326L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32631L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32632L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32633L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32634L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32635L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32636L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32637L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32638L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32639L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32640L, 4326L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32641L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32642L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32643L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32644L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32645L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32646L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32647L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32648L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32649L, 4326L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32650L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32651L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32652L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32653L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32654L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32655L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32656L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32657L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32658L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32659L, 4326L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32660L, 4326L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32664L, 4326L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32665L, 4326L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32666L, 4326L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32667L, 4326L, 3.2808333333333333, 500000.00101600203, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32701L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32702L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32703L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32704L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32705L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32706L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32707L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32708L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32709L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32710L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32711L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32712L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32713L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32714L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32715L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32716L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32717L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32718L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32719L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32720L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32721L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32722L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32723L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32724L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32725L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32726L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32727L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32728L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32729L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32730L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32731L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32732L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32733L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32734L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32735L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32736L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32737L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32738L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32739L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32740L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32741L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32742L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32743L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32744L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32745L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32746L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32747L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32748L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32749L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32750L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32751L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32752L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32753L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32754L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32755L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32756L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32757L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32758L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32759L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32760L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(32766L, 4326L, 1.0, 500000.0, 1.0E7, 0.0, 0.628318530717958, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81920L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81921L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81922L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81923L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81924L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81925L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81926L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81927L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81928L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81929L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81930L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81931L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81932L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81933L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81934L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81935L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81936L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81937L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81938L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81939L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81940L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81941L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81942L, 2000018L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81943L, 2000017L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81944L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5323254218582699, -1.498074274627883, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81945L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.5323254218582699, -1.498074274627883, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81946L, 2000006L, 1.0, 200000.0, 0.0, 0.5323254218582699, -1.498074274627883, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81947L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81948L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81949L, 2000006L, 1.0, 600000.0, 0.0, 0.5235987755982984, -1.5271630954950368, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81950L, 2000011L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81951L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81952L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.4783675378319456, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81953L, 2000011L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.5481807079117185, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81954L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.5481807079117185, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81955L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.5481807079117185, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81956L, 2000011L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.6179938779914917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81957L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.6179938779914917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81958L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.6179938779914917, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81959L, 2000011L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81960L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81961L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.6878070480712646, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81962L, 2000011L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.757620218151038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81963L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.757620218151038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81964L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.757620218151038, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81965L, 2000011L, 3.2808333333333333, 213360.42672085343, 0.0, 0.942477796076937, -2.827433388230811, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81966L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.827433388230811, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81967L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.827433388230811, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81968L, 2000011L, 3.2808333333333333, 152400.3048006096, 0.0, 0.942477796076937, -2.897246558310584, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81969L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.897246558310584, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81970L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.897246558310584, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81971L, 2000011L, 3.2808333333333333, 182880.3657607315, 0.0, 0.942477796076937, -2.9670597283903573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81972L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.942477796076937, -2.9670597283903573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81973L, 2000006L, 1.0, 500000.0, 0.0, 0.942477796076937, -2.9670597283903573, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81974L, 2000013L, 1.0, 300000.0, 700000.0, -0.7450656464190835, 3.019596460163292, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81975L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.9227710592809995, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81976L, 2000006L, 3.2808333333333333, 213360.42672085343, 0.0, 0.5410520681182416, -1.9227710592809995, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81977L, 2000006L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9227710592809995, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81978L, 2000006L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9227710592809995, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81979L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.9533143211909003, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81980L, 2000006L, 3.2808333333333333, 213360.42672085343, 0.0, 0.5410520681182416, -1.9533143211909003, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81981L, 2000006L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9533143211909003, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81982L, 2000006L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9533143211909003, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81983L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81984L, 2000006L, 3.2808333333333333, 213360.42672085343, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81985L, 2000006L, 3.2808398950131235, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81986L, 2000006L, 1.0, 213360.0, 0.0, 0.5410520681182416, -1.9853120241435478, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81987L, 2000013L, 1.0, 300000.0, 700000.0, -0.6590581421687081, 3.0799161561229367, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81988L, 2000013L, 1.0, 300002.66, 699999.58, -0.8133236059622819, 2.938137388663369, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81989L, 2000021L, 1.0, 400000.0, -100000.0, 0.8552113334772206, -0.034906585039886556, 0.9996012717);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81990L, 2000006L, 1.0, 400000.0, -100000.0, 0.8552113334772206, -0.034906585039886556, 0.999601);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81991L, 2000013L, 1.0, 300000.0, 700000.0, -0.7297361752527219, 2.9946579217204428, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81992L, 2000013L, 1.0, 300000.0, 700000.0, -0.7106065987059933, 3.0136957288551014, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81993L, 2000002L, 6.213711922373339E-4, 0.0, 0.0, 0.0, 1.3613568165555756, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81994L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6632251157578446, -1.3162691442129706, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81995L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.6632251157578446, -1.3162691442129706, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81996L, 2000006L, 1.0, 200000.0, 0.0, 0.6632251157578446, -1.3162691442129706, 0.999995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81997L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.42469678465137134, -1.4137166941154056, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81998L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.42469678465137134, -1.4137166941154056, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(81999L, 2000006L, 1.0, 200000.0, 0.0, 0.42469678465137134, -1.4137166941154056, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82000L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.42469678465137134, -1.4311699866353487, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82001L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.42469678465137134, -1.4311699866353487, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82002L, 2000006L, 1.0, 200000.0, 0.0, 0.42469678465137134, -1.4311699866353487, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82003L, 8220L, 1.0, 1500000.0, 0.0, 0.0, 0.052359877559829834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82004L, 2000005L, 1.0, 1500000.0, 0.0, 0.0, 0.052359877559829834, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82005L, 2000005L, 1.0, 1.05E7, 0.0, 0.0, 0.9948376736367668, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82006L, 2000005L, 1.0, 1.15E7, 0.0, 0.0, 1.0995574287564265, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82007L, 2000005L, 1.0, 1.25E7, 0.0, 0.0, 1.2042771838760862, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82008L, 2000005L, 1.0, 1.35E7, 0.0, 0.0, 1.3089969389957459, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82009L, 2000005L, 1.0, 1.45E7, 0.0, 0.0, 1.4137166941154056, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82010L, 2000005L, 1.0, 1.55E7, 0.0, 0.0, 1.5184364492350653, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82011L, 2000005L, 1.0, 1.65E7, 0.0, 0.0, 1.6231562043547247, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82012L, 2000005L, 1.0, 1.75E7, 0.0, 0.0, 1.7278759594743844, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82013L, 2000005L, 1.0, 1.85E7, 0.0, 0.0, 1.8325957145940441, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82014L, 2000005L, 1.0, 1.95E7, 0.0, 0.0, 1.9373154697137038, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82015L, 8220L, 1.0, 2500000.0, 0.0, 0.0, 0.10471975511965967, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82016L, 2000005L, 1.0, 2500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82017L, 2000005L, 1.0, 2.05E7, 0.0, 0.0, 2.0420352248333633, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82018L, 2000005L, 1.0, 2.15E7, 0.0, 0.0, 2.1467549799530232, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82019L, 2000005L, 1.0, 2.25E7, 0.0, 0.0, 2.2514747350726827, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82020L, 2000005L, 1.0, 2.35E7, 0.0, 0.0, 2.3561944901923426, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82021L, 2000005L, 1.0, 2.45E7, 0.0, 0.0, 2.460914245312002, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82022L, 2000005L, 1.0, 2.55E7, 0.0, 0.0, 2.565634000431662, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82023L, 2000005L, 1.0, 2.65E7, 0.0, 0.0, 2.6703537555513215, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82024L, 2000005L, 1.0, 2.75E7, 0.0, 0.0, 2.775073510670981, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82025L, 2000005L, 1.0, 2.85E7, 0.0, 0.0, 2.879793265790641, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82026L, 2000005L, 1.0, 2.95E7, 0.0, 0.0, 2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82027L, 8220L, 1.0, 3500000.0, 0.0, 0.0, 0.1570796326794895, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82028L, 2000005L, 1.0, 3500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82029L, 2000005L, 1.0, 3.05E7, 0.0, 0.0, 3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82030L, 2000005L, 1.0, 3.15E7, 0.0, 0.0, -3.0892327760299603, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82031L, 2000005L, 1.0, 3.25E7, 0.0, 0.0, -2.9845130209103004, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82032L, 8220L, 1.0, 4500000.0, 0.0, 0.0, 0.20943951023931934, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82033L, 2000005L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82034L, 8220L, 1.0, 5500000.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82035L, 2000005L, 1.0, 5500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82036L, 2000005L, 1.0, 6500000.0, 0.0, 0.0, 0.5759586531581282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82037L, 2000005L, 1.0, 7500000.0, 0.0, 0.0, 0.6806784082777878, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82038L, 2000005L, 1.0, 8500000.0, 0.0, 0.0, 0.7853981633974475, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82039L, 2000005L, 1.0, 9500000.0, 0.0, 0.0, 0.8901179185171072, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82040L, 2000013L, 1.0, 300000.0, 700000.0, -0.7635590679067528, 2.990809261280285, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82041L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5235987755982984, -1.4340788687225878, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82042L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.5235987755982984, -1.4340788687225878, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82043L, 2000006L, 1.0, 200000.0, 0.0, 0.5235987755982984, -1.4340788687225878, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82044L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5235987755982984, -1.4689854537624742, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82045L, 2000006L, 3.2808333333333333, 699999.99998984, 0.0, 0.5235987755982984, -1.4689854537624742, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82046L, 2000006L, 1.0, 700000.0, 0.0, 0.5235987755982984, -1.4689854537624742, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82047L, 2000013L, 1.0, 300000.0, 700000.0, -0.7388623448317676, 2.994108334992282, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82048L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3287036757916833, -2.7139869868511797, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82049L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.3287036757916833, -2.7139869868511797, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82050L, 2000006L, 1.0, 500000.0, 0.0, 0.3287036757916833, -2.7139869868511797, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82051L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3548836145715982, -2.734349161458362, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82052L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.3548836145715982, -2.734349161458362, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82053L, 2000006L, 1.0, 500000.0, 0.0, 0.3548836145715982, -2.734349161458362, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82054L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3694280250060478, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82055L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.3694280250060478, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82056L, 2000006L, 1.0, 500000.0, 0.0, 0.3694280308232302, -2.757620218151038, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82057L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3810635533515131, -2.783800156930953, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82058L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.3810635533515131, -2.783800156930953, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82059L, 2000006L, 1.0, 500000.0, 0.0, 0.3810635533515131, -2.783800156930953, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82060L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.3781546712660195, -2.7954356852781634, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82061L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.3781546712660195, -2.7954356852781634, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82062L, 2000006L, 1.0, 500000.0, 0.0, 0.3781546712660195, -2.7954356852781634, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82063L, 2000013L, 1.0, 300000.0, 700000.0, -0.692039262524502, 3.083537435068145, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82064L, 2000013L, 1.0, 300000.0, 700000.0, -0.7485075229704788, 2.984163832886854, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82065L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.727220521664885, -1.957677644320886, 0.999947);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82066L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.727220521664885, -1.957677644320886, 0.999947);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82067L, 2000006L, 1.0, 200000.0, 0.0, 0.727220521664885, -1.957677644320886, 0.999947);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82068L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.727220521664885, -1.9896753472735336, 0.999947);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82069L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.727220521664885, -1.9896753472735336, 0.999947);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82070L, 2000006L, 1.0, 500000.0, 0.0, 0.727220521664885, -1.9896753472735336, 0.999947);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82071L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.727220521664885, -2.020218609183434, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82072L, 2000006L, 3.2808333333333333, 800000.00001016, 0.0, 0.727220521664885, -2.020218609183434, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82073L, 2000006L, 1.0, 800000.0, 0.0, 0.727220521664885, -2.020218609183434, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82074L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6399540590651687, -1.5417075059277412, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82075L, 2000006L, 3.2808333333333333, 300000.0, 0.0, 0.6399540590651687, -1.5417075059277412, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82076L, 2000006L, 1.0, 300000.0, 0.0, 0.6399540590651687, -1.5417075059277412, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82077L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6399540590651687, -1.573705208882134, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82078L, 2000006L, 3.2808333333333333, 699999.99998984, 0.0, 0.6399540590651687, -1.573705208882134, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82079L, 2000006L, 1.0, 700000.0, 0.0, 0.6399540590651687, -1.573705208882134, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82080L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6544984694978729, -1.4951653925423893, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82081L, 2000006L, 3.2808333333333333, 99999.99998983998, 249999.99998983997, 0.6544984694978729, -1.4951653925423893, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82082L, 2000006L, 1.0, 100000.0, 250000.0, 0.6544984694978729, -1.4951653925423893, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82083L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6544984694978729, -1.519890890277812, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82084L, 2000006L, 3.2808333333333333, 900000.0, 249999.99212598425, 0.6544984694978729, -1.519890890277812, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82085L, 2000006L, 1.0, 900000.0, 250000.0, 0.6544984694978729, -1.519890890277812, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82086L, 2000026L, 1.0, 200000.0, 250000.0, 0.9337511498169654, -0.13962634015954623, 1.000035);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82087L, 2000019L, 1.0, 1500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82088L, 2000019L, 1.0, 2520000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82089L, 2000013L, 1.0, 300000.0, 700000.0, -0.7675574601434391, 2.9427344986466593, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82090L, 2000003L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.2602013813326547, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82091L, 2000003L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.2863813201125693, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82092L, 2000003L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3067434830836415, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82093L, 2000003L, 1.0, 0.0, 0.0, 0.5759586531581282, 2.3300145514124275, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82094L, 2000003L, 1.0, 0.0, 0.0, 0.628318530717958, 2.44055207070482, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82095L, 2000003L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3445589618451317, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82096L, 2000003L, 1.0, 0.0, 0.0, 0.628318530717958, 2.3736477827122857, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82097L, 2000003L, 1.0, 0.0, 0.0, 0.628318530717958, 2.394009945683358, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82098L, 2000003L, 1.0, 0.0, 0.0, 0.628318530717958, 2.417281014012144, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82099L, 2000003L, 1.0, 0.0, 0.0, 0.6981317007977311, 2.458005363224763, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82100L, 2000003L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.4478242759220445, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82101L, 2000003L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.482730860961931, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82102L, 2000003L, 1.0, 0.0, 0.0, 0.7679448708775042, 2.517637446001818, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82103L, 2000003L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.4783675378319456, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82104L, 2000003L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.6878070480712646, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82105L, 2000003L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.225294796292768, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82106L, 2000003L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.1642082724729663, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82107L, 2000003L, 1.0, 0.0, 0.0, 0.4537856055185252, 2.2863813201125693, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82108L, 2000003L, 1.0, 0.0, 0.0, 0.34906585039886556, 2.3736477827122857, 0.99999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82109L, 2000013L, 1.0, 300000.0, 700000.0, -0.7206449122587162, 3.003869211007108, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82110L, 2000013L, 1.0, 300000.0, 700000.0, -0.7807777183620579, 2.9577703007130802, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82111L, 2000006L, 3.2808333333333333, 900000.0, 0.0, 0.7475826962703219, -1.2246393584832684, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82112L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7650359887902652, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82113L, 2000006L, 3.2808333333333333, 300000.0, 0.0, 0.7621271067047716, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82114L, 2000006L, 1.0, 300000.0, 0.0, 0.7621271067047716, -1.1955505376161146, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82115L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7475826962703219, -1.2246393584832684, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82116L, 2000006L, 1.0, 900000.0, 0.0, 0.7475826962703219, -1.2246393584832684, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82117L, 2000013L, 1.0, 300000.0, 700000.0, -0.7250880842019808, 3.033418438094828, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82118L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5177810114255657, -1.5504341521877127, 0.999996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82119L, 2000006L, 3.2808333333333333, 300000.0, 0.0, 0.5148721293383267, -1.5504341521877127, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82120L, 2000006L, 1.0, 300000.0, 0.0, 0.5148721293383267, -1.5504341521877127, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82121L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5323254218582699, -1.5766140909676276, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82122L, 2000006L, 3.2808333333333333, 699999.99998984, 0.0, 0.5148721293383267, -1.5766140909676276, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82123L, 2000006L, 1.0, 700000.0, 0.0, 0.5148721293383267, -1.5766140909676276, 0.99995);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82124L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.625409648630719, -1.5795229730548666, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82125L, 2000006L, 3.2808333333333333, 249999.99998983997, 0.0, 0.625409648630719, -1.5795229730548666, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82126L, 2000006L, 1.0, 250000.0, 0.0, 0.625409648630719, -1.5795229730548666, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82127L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.625409648630719, -1.6144295580947532, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82128L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.625409648630719, -1.6144295580947532, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82129L, 2000006L, 1.0, 500000.0, 0.0, 0.625409648630719, -1.6144295580947532, 0.999933);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82130L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.631227412805197, -1.6493361431346398, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82131L, 2000006L, 3.2808333333333333, 849999.99998984, 0.0, 0.631227412805197, -1.6493361431346398, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82132L, 2000006L, 1.0, 850000.0, 0.0, 0.631227412805197, -1.6493361431346398, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82133L, 2000013L, 1.0, 300000.0, 700000.0, -0.6436750719410179, 3.050213130621531, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82134L, 2000013L, 1.0, 300000.0, 700000.0, -0.7877177583332255, 2.9391107413339133, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82135L, 2000013L, 1.0, 300000.0, 700000.0, -0.7608001561449552, 3.0146582430309916, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82136L, 2000013L, 1.0, 300000.0, 700000.0, -0.795237038176545, 2.9275954254483976, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82137L, 2000013L, 1.0936132983377078, 274320.0, 365760.0, -0.6806784082777878, 3.063052837250045, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82138L, 2000013L, 1.0936132983377078, 457200.0, 457200.0, -0.7679448708775042, 2.9932396671702723, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82139L, 2000013L, 1.0, 300000.0, 700000.0, -0.7203767075125622, 3.024643673107379, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82140L, 2000006L, 1.0, 200000.0, 8000000.0, 0.6065019150680289, -2.0173097270961953, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82141L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6065019150680289, -2.0173097270961953, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82142L, 2000006L, 3.2808333333333333, 200000.00001016003, 8000000.00001016, 0.6065019150680289, -2.0173097270961953, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82143L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6065019150680289, -2.0362174606606307, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82144L, 2000006L, 3.2808333333333333, 500000.00001016003, 6000000.0, 0.6065019150680289, -2.0362174606606307, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82145L, 2000006L, 1.0, 500000.0, 6000000.0, 0.6065019150680289, -2.0362174606606307, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82146L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6065019150680289, -2.0696696046560255, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82147L, 2000006L, 3.2808333333333333, 800000.00001016, 3999999.99998984, 0.6065019150680289, -2.0696696046560255, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82148L, 2000006L, 1.0, 800000.0, 4000000.0, 0.6065019150680289, -2.0696696046560255, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82149L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7417649320975893, -1.2508192972631833, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82150L, 2000006L, 3.2808333333333333, 300000.0, 0.0, 0.7417649320975893, -1.2508192972631833, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82151L, 2000006L, 1.0, 300000.0, 0.0, 0.7417649320975893, -1.2508192972631833, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82152L, 2000007L, 3.2808333333333333, 609601.2192024384, 0.0, 0.6777695261905489, -1.3031791748230133, 0.999975);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82153L, 2000006L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261905489, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82154L, 2000006L, 1.0, 150000.0, 0.0, 0.6777695261905489, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82155L, 2000006L, 3.2808333333333333, 165000.0, 0.0, 0.5410520681182416, -1.8209601862468336, 0.999909);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82156L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.8209601862468336, 0.999909);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82157L, 2000006L, 1.0, 165000.0, 0.0, 0.5410520681182416, -1.8209601862468336, 0.999909);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82158L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82159L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82160L, 2000006L, 1.0, 500000.0, 0.0, 0.5410520681182416, -1.8544123302439732, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82161L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.5410520681182416, -1.882046710066635, 0.999917);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82162L, 2000006L, 3.2808333333333333, 830000.00001016, 0.0, 0.5410520681182416, -1.882046710066635, 0.999917);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82163L, 2000006L, 1.0, 830000.0, 0.0, 0.5410520681182416, -1.882046710066635, 0.999917);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82164L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6981317007977311, -1.2973614106485352, 0.999967);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82165L, 2000006L, 3.2808333333333333, 150000.0, 0.0, 0.6777695261905489, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82166L, 2000006L, 1.0, 150000.0, 0.0, 0.6777695261905489, -1.300270292735774, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82167L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6981317007977311, -1.3366313188184076, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82168L, 2000006L, 3.2808333333333333, 249999.99998983997, 0.0, 0.6981317007977311, -1.3366313188184076, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82169L, 2000006L, 1.0, 250000.0, 0.0, 0.6981317007977311, -1.3366313188184076, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82170L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.6981317007977311, -1.3715379038582942, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82171L, 2000006L, 3.2808333333333333, 350000.00001016003, 0.0, 0.6981317007977311, -1.3715379038582942, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82172L, 2000006L, 1.0, 350000.0, 0.0, 0.6981317007977311, -1.3715379038582942, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82173L, 2000013L, 1.0, 300000.0, 700000.0, -0.8004344017961814, 2.9719918368702753, 0.99996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82174L, 2000013L, 1.0, 300000.0, 700000.0, -0.7996434883923477, 2.978030780801931, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82175L, 2000013L, 1.0, 300000.0, 700000.0, -0.7524136745561972, 2.971613746194416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82176L, 2000024L, 1.0, 180.598, -86.99, 0.6923139366249985, -0.14192853416268186, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82177L, 2000025L, 1.0, 0.0, 0.0, 0.6923139366249985, -0.14192853416268186, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82178L, 2000002L, 1.0, 0.0, 0.0, 0.6923139366249985, -0.14192853416268186, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82179L, 2000013L, 1.0, 300000.0, 700000.0, -0.6741282399549307, 3.1046900402041526, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82180L, 2000031L, 3.2808333333333333, 304800.6096012192, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82181L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82182L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.3875367553354905, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82183L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -0.9686577348568519, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82184L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -0.9686577348568519, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82185L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82186L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.0210176124166817, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82187L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82188L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.0733774899765116, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82189L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82190L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.1257373675363413, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82191L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82192L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.1780972450961713, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82193L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.230457122656001, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82194L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.230457122656001, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82195L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82196L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.282817000215831, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82197L, 2000010L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82198L, 2000006L, 1.0, 304800.0, 0.0, 0.0, -1.3351768777756607, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82199L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7170394343604212, -1.2479104151759444, 0.999994);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82200L, 2000006L, 3.2808333333333333, 99999.99998983998, 0.0, 0.7170394343604212, -1.2479104151759444, 0.999994);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82201L, 2000006L, 1.0, 100000.0, 0.0, 0.7170394343604212, -1.2479104151759444, 0.999994);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82202L, 2000020L, 1.0, 1500000.0, 0.0, 0.0, 0.2759065001705839, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82203L, 2000013L, 1.0, 300000.0, 700000.0, -0.6830478323637103, 3.0408524586041876, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82204L, 2000013L, 1.0, 300000.0, 700000.0, -0.7749649341948758, 2.98551223936036, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82205L, 2000013L, 1.0, 300000.0, 700000.0, -0.6896226970954832, 3.0654969439746607, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82206L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82207L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82208L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82209L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82210L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82211L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82212L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82213L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82214L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82215L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82216L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82217L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82218L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82219L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82220L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82221L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82222L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82223L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82224L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82225L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82226L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82227L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82228L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82229L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82230L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82231L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82232L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82233L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82234L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82235L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82236L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82237L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82238L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82239L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82240L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82241L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82242L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
    }

    private static void loadTransverseMercatorSRIDs4() {
        TransverseMercatorSrid.registerTransverseMercatorSrid(82243L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82244L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82245L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82246L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82247L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82248L, 2000004L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82249L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82250L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82251L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82252L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82253L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82254L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82255L, 2000004L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82256L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82257L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82258L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82259L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82260L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82261L, 2000007L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82262L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82263L, 2000016L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82264L, 2000004L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82265L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82266L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82267L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82268L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82269L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82270L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82271L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82272L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82273L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82274L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82275L, 2000016L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82276L, 2000004L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82277L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82278L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82279L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82280L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82281L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82282L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82283L, 2000016L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82284L, 2000004L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82285L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82286L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82287L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82288L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82289L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82290L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82291L, 2000016L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82292L, 2000004L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82293L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82294L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82295L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82296L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82297L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82298L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82299L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82300L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82301L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82302L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82303L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82304L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82305L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82306L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82307L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82308L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82309L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82310L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82311L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82312L, 2000016L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82313L, 2000004L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82314L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82315L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82316L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82317L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82318L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82319L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82320L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82321L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82322L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82323L, 2000014L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82324L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82325L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82326L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82327L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82328L, 2000014L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82329L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82330L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82331L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82332L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82333L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82334L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82335L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82336L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82337L, 2000014L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82338L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82339L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82340L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82341L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82342L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82343L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82344L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82345L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82346L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82347L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82348L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82349L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82350L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82351L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82352L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82353L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82354L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82355L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82356L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82357L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82358L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82359L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82360L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82361L, 2000014L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82362L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82363L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82364L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82365L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82366L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82367L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82368L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82369L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82370L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82371L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82372L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82373L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82374L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82375L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82376L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82377L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82378L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82379L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82380L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82381L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82382L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82383L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82384L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82385L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82386L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82387L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82388L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82389L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82390L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82391L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82392L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82393L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82394L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82395L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82396L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82397L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82398L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82399L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82400L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82401L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82402L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82403L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82404L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82405L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82406L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82407L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82408L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82409L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82410L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82411L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82412L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82413L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82414L, 2000003L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82415L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82416L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82417L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82418L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82419L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82420L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82421L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82422L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82423L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82424L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82425L, 2000002L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82426L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82427L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82428L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82429L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82430L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82431L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82432L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82433L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82434L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82435L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82436L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82437L, 2000011L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82438L, 2000010L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82439L, 2000006L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82440L, 2000002L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82441L, 2000002L, 1.0, 500000.0, 1.0E7, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82442L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82443L, 2000006L, 3.2808333333333333, 500000.00001016003, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82444L, 2000006L, 1.0, 500000.0, 0.0, 0.7417649320975893, -1.2653637076958877, 0.999964);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82445L, 2000013L, 1.0, 300000.0, 700000.0, -0.7142852989835917, 3.0656245799028587, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82446L, 2000013L, 1.0, 300000.0, 700000.0, -0.7023544725630538, 3.0628451430690578, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82447L, 2000013L, 1.0, 300000.0, 700000.0, -0.7208440194197837, 3.050427526866846, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82448L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7097672291449417, -1.835504596681283, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82449L, 2000006L, 3.2808333333333333, 200000.00001016003, 0.0, 0.7068583470577028, -1.835504596681283, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82450L, 2000006L, 1.0, 200000.0, 0.0, 0.7068583470577028, -1.835504596681283, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82451L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7097672291449417, -1.8733200638066634, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82452L, 2000006L, 3.2808333333333333, 399999.99998983997, 99999.99998983998, 0.7068583470577028, -1.8733200638066634, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82453L, 2000006L, 1.0, 400000.0, 100000.0, 0.7068583470577028, -1.8733200638066634, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82454L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7097672291449417, -1.8980455615438314, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82455L, 2000006L, 3.2808333333333333, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82456L, 2000006L, 1.0, 600000.0, 0.0, 0.7068583470577028, -1.8980455615438314, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82457L, 2000007L, 3.2808333333333333, 152400.3048006096, 0.0, 0.7097672291449417, -1.9213166182365073, 0.999941);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82458L, 2000006L, 3.2808333333333333, 800000.00001016, 99999.99998983998, 0.7068583470577028, -1.9213166182365073, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82459L, 2000006L, 1.0, 800000.0, 100000.0, 0.7068583470577028, -1.9213166182365073, 0.999938);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82460L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82461L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82462L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82463L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82464L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82465L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82466L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82467L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82468L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82469L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82470L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82471L, 2000012L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(82474L, 8312L, 1.0, 200000.0, 4510193.4939, 0.0, 2.6007028109160575, 1.000086);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83027L, 2000015L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83028L, 2000015L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83029L, 2000015L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83030L, 2000015L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83031L, 2000015L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83032L, 2000015L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83033L, 2000015L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83034L, 2000015L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83035L, 2000015L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(83036L, 2000015L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(84032L, 8330L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(376301L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(376302L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(376303L, 4258L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(999989L, 4140L, 1.0, 0.0, 0.0, 0.0, -1.9896753472735336, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026904L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026905L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026910L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026911L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026912L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026913L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026914L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026915L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026916L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026917L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1026918L, 4269L, 3.2808333333333333, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032601L, 4267L, 1.0, 500000.0, 0.0, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032602L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032603L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032604L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032605L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032606L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032607L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032608L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032609L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032610L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032611L, 4267L, 1.0, 500000.0, 0.0, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032612L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032613L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032614L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032615L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032616L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032617L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032618L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032619L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032620L, 4267L, 1.0, 500000.0, 0.0, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032621L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032622L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032623L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032624L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032625L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032626L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032627L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032628L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032629L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032630L, 4267L, 1.0, 500000.0, 0.0, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032631L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032632L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032633L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032634L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032635L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032636L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032637L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032638L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032639L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032640L, 4267L, 1.0, 500000.0, 0.0, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032641L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032642L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032643L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032644L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032645L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032646L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032647L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032648L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032649L, 4267L, 1.0, 500000.0, 0.0, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032650L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032651L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032652L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032653L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032654L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032655L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032656L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032657L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032658L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032659L, 4267L, 1.0, 500000.0, 0.0, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032660L, 4267L, 1.0, 500000.0, 0.0, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032701L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032702L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032703L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032704L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032705L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032706L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032707L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032708L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032709L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032710L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032711L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032712L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032713L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032714L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032715L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032716L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032717L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032718L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032719L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032720L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032721L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032722L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032723L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032724L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032725L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032726L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032727L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032728L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032729L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032730L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, -0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032731L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.052359877559829834, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032732L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.1570796326794895, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032733L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.2617993877991492, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032734L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.3665191429188088, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032735L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.4712388980384685, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032736L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.5759586531581282, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032737L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.6806784082777878, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032738L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.7853981633974475, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032739L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.8901179185171072, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032740L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 0.9948376736367668, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032741L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.0995574287564265, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032742L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.2042771838760862, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032743L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.3089969389957459, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032744L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.4137166941154056, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032745L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.5184364492350653, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032746L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.6231562043547247, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032747L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.7278759594743844, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032748L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.8325957145940441, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032749L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 1.9373154697137038, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032750L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.0420352248333633, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032751L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.1467549799530232, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032752L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.2514747350726827, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032753L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.3561944901923426, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032754L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.460914245312002, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032755L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.565634000431662, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032756L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.6703537555513215, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032757L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.775073510670981, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032758L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.879793265790641, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032759L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 2.9845130209103004, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(2032760L, 4267L, 1.0, 500000.0, 1.0E7, 0.0, 3.0892327760299603, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000101L, 3000103L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9998);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000102L, 3000103L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000104L, 3000113L, 1.0, 0.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000105L, 3000113L, 1.0, 4500000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000106L, 3000113L, 1.0, 5500000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000107L, 3000113L, 1.0, 7250000.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000108L, 3000113L, 1.0, 8250000.0, 0.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000109L, 3000113L, 1.0, 9250000.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000110L, 3000113L, 1.0, 250000.0, -11057.63, 0.0, 0.3830997708127549, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000111L, 3000113L, 1.0, 1250000.0, -11057.63, 0.0, 0.4354596483725848, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000112L, 3000113L, 1.0, 2250000.0, -11057.63, 0.0, 0.4878195259324146, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000114L, 3000113L, 1.0, -53799.7, -6040600.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000115L, 3000113L, 1.0, 17981.7, -6073803.0, 0.0, 0.4188790204786387, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(3000116L, 3000103L, 1.0, 500000.0, 0.0, 0.0, 0.4188790204786387, 0.9996);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4200000L, 4100000L, 1.0, 500000.0, -5000000.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(4300000L, 4258L, 1.0, 500000.0, -5000000.0, 0.0, 0.2617993877991492, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20000671L, 2000067L, 1.0, 250000.0, 0.0, 0.0, 2.1118483949131366, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(20000971L, 2000097L, 1.0, 250000.0, 0.0, 0.0, 2.1118483949131366, 0.9999);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002046L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.2617993877991492, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002047L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.2967059728390357, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002048L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.3316125578789223, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002049L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.3665191429188088, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002050L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.4014257279586954, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002051L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.43633231299858194, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002052L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.4712388980384685, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002053L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.506145483078355, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002054L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.5410520681182416, 1.0);
        TransverseMercatorSrid.registerTransverseMercatorSrid(1000002055L, 4148L, 1.0, 0.0, 0.0, 0.0, 0.5759586531581282, 1.0);
    }

    public static void printDiscrepancies(Connection connection) throws SQLException {
        Long l;
        Object object;
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        GeodeticSrid geodeticSrid = (GeodeticSrid)SRIDS.get(4326L);
        Vector<Srid> vector = new Vector<Srid>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select\n  srid,\n  coord_ref_sys_kind\nfrom\n  sdo_coord_ref_sys\norder by\n  srid");
        System.out.println("Testing for discrepancies between Java and DB CRS:");
        while (resultSet.next()) {
            long l2 = resultSet.getLong(1);
            Srid srid = SRIDS.get(l2);
            object = resultSet.getString(2);
            if (srid == null) {
                l = (Long)hashMap.get(object);
                l = l == null ? Long.valueOf(1L) : Long.valueOf(l + 1L);
                hashMap.put((String)object, l);
                continue;
            }
            vector.add(srid);
        }
        System.out.println("SRIDs missing: " + hashMap);
        resultSet.close();
        statement.close();
        Iterator iterator = vector.iterator();
        PreparedStatement preparedStatement = connection.prepareStatement("select sdo_cs.transform(:geom, 4326) from dual");
        int n = 0;
        while (iterator.hasNext()) {
            JGeometry jGeometry;
            object = (Srid)iterator.next();
            l = null;
            preparedStatement.setObject(1, JGeometry.store((JGeometry)((Srid)object).getSampleTruthPoint(), (Connection)connection));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l = JGeometry.loadJS((Struct)((Struct)resultSet.getObject(1)));
            }
            resultSet.close();
            JGeometry jGeometry2 = ((Srid)object).getSampleTruthPoint();
            JGeometry jGeometry3 = ((Srid)object).transform(jGeometry2, geodeticSrid);
            JGeometry jGeometry4 = jGeometry = object instanceof GeodeticSrid ? geodeticSrid.transform(jGeometry3, (GeodeticSrid)object) : geodeticSrid.transform(jGeometry3, (ProjectedSrid)object);
            if (!(Math.abs(jGeometry3.getPoint()[0] - l.getPoint()[0]) > 1.0E-9) && !(Math.abs(jGeometry3.getPoint()[1] - l.getPoint()[1]) > 1.0E-9)) continue;
            if (n == 0) {
                System.out.println("Transformation Discrepancies:");
            }
            ++n;
            System.out.println("  - SRID " + object + " -> 4326:\n      Java Tfm: " + jGeometry3.toStringFull() + " != \n        DB Tfm: " + l.toStringFull() + " (" + Math.sqrt((jGeometry3.getPoint()[0] - l.getPoint()[0]) * (jGeometry3.getPoint()[0] - l.getPoint()[0]) + (jGeometry3.getPoint()[1] - l.getPoint()[1]) * (jGeometry3.getPoint()[1] - l.getPoint()[1])) * 100000.0 + ")\n");
        }
        preparedStatement.close();
        if (n == 0) {
            System.out.println("No Transformation Discrepancies:");
        } else {
            System.out.println(n + " Transformation Discrepancies, out of " + SRIDS.size() + ":");
        }
    }

    public static void main(String[] stringArray) throws SQLException {
        int n;
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        DriverManager.registerDriver((Driver)new OracleDriver());
        System.out.println();
        CoordRefSys.printDiscrepancies(DriverManager.getConnection("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(HOST=" + string + ")(PROTOCOL=tcp)(PORT=" + string2 + ")))(CONNECT_DATA=(SERVICE_NAME=" + string3 + ")))", string4, string5));
        double[] dArray = new double[]{0.0, 30.0, 0.0, 0.0, 30.0, 0.0, 0.0, 30.0, 0.0, 0.0, 30.0, 0.0};
        ((GeodeticSrid)SRIDS.get(4178L)).transform(dArray, 3, (GeodeticSrid)SRIDS.get(4326L));
        for (n = 0; n < dArray.length; ++n) {
            System.out.print(", " + dArray[n]);
        }
        System.out.println();
        dArray = new double[]{0.0, 30.0, 0.0, 30.0, 0.0, 30.0, 0.0, 30.0};
        ((GeodeticSrid)SRIDS.get(4178L)).transform(dArray, 2, (GeodeticSrid)SRIDS.get(4326L));
        for (n = 0; n < dArray.length; ++n) {
            System.out.print(", " + dArray[n]);
        }
        System.out.println();
    }

    static {
        CoordRefSys.loadSRIDs();
    }

    public static class TransverseMercatorSrid
    extends ProjectedSrid {
        private final double m_latitudeOfOriginInRadian;
        private final double m_centralMeridianInRadian;
        private final double m_scaleFactor;

        public static void registerTransverseMercatorSrid(long l, long l2, double d, double d2, double d3, double d4, double d5, double d6) {
            GeodeticSrid geodeticSrid = (GeodeticSrid)SRIDS.get(l2);
            if (geodeticSrid != null) {
                SRIDS.put(l, new TransverseMercatorSrid(l, (GeodeticSrid)SRIDS.get(l2), d, d2, d3, d4, d5, d6));
            } else {
                System.out.println("Projected TM SRID " + l + " based on non-existent geodetic SRID " + l2);
            }
        }

        protected TransverseMercatorSrid(long l, GeodeticSrid geodeticSrid, double d, double d2, double d3, double d4, double d5, double d6) {
            super(l, geodeticSrid, d, d2, d3);
            this.m_latitudeOfOriginInRadian = d4;
            this.m_centralMeridianInRadian = d5;
            this.m_scaleFactor = d6;
        }

        @Override
        public void project(double[] dArray, int n) {
            double d = this.getFalseEastingInMeters();
            double d2 = this.getFalseNorthingInMeters();
            double d3 = this.m_scaleFactor;
            double d4 = this.m_centralMeridianInRadian;
            double d5 = this.m_latitudeOfOriginInRadian;
            double d6 = this.getGeodeticSrid().getSemiMajorAxisInMeters();
            double d7 = 1.0 / this.getGeodeticSrid().getInverseFlattening();
            double d8 = Math.sqrt(2.0 * d7 - d7 * d7);
            for (int i = 0; i < dArray.length / n; ++i) {
                double d9 = dArray[i * n + 0] / this.getGeodeticSrid().getAngleUnitsPerRadian();
                double d10 = dArray[i * n + 1] / this.getGeodeticSrid().getAngleUnitsPerRadian();
                double d11 = Math.sin(d10);
                double d12 = Math.cos(d10);
                double d13 = Math.tan(d10);
                double d14 = d13 * d13;
                double d15 = d9 - d4;
                if (d15 < Math.PI) {
                    d15 += Math.PI * 2;
                }
                if (d15 > Math.PI) {
                    d15 -= Math.PI * 2;
                }
                double d16 = (d15 *= d12) * d15;
                double d17 = d15 * d16;
                double d18 = d16 * d16;
                double d19 = d16 * d17;
                double d20 = d16 * d18;
                double d21 = d14 * d14;
                double d22 = d8 * d8;
                double d23 = d22 * d12 * d12 / (1.0 - d22);
                double d24 = d23 * d23;
                double d25 = d8 / Math.sqrt(1.0 - d22);
                double d26 = d25 * d25;
                double d27 = d22 * d22;
                double d28 = d22 * d27;
                double d29 = d6 / Math.sqrt(1.0 - d22 * d11 * d11);
                double d30 = d6 * ((1.0 - d22 / 4.0 - 3.0 * d27 / 64.0 - 5.0 * d28 / 256.0) * d10 - (3.0 * d22 / 8.0 + 3.0 * d27 / 32.0 + 45.0 * d28 / 1024.0) * Math.sin(2.0 * d10) + (15.0 * d27 / 256.0 + 45.0 * d28 / 1024.0) * Math.sin(4.0 * d10) - 35.0 * d28 / 3072.0 * Math.sin(6.0 * d10));
                double d31 = d6 * ((1.0 - d22 / 4.0 - 3.0 * d27 / 64.0 - 5.0 * d28 / 256.0) * d5 - (3.0 * d22 / 8.0 + 3.0 * d27 / 32.0 + 45.0 * d28 / 1024.0) * Math.sin(2.0 * d5) + (15.0 * d27 / 256.0 + 45.0 * d28 / 1024.0) * Math.sin(4.0 * d5) - 35.0 * d28 / 3072.0 * Math.sin(6.0 * d5));
                double d32 = d + d3 * d29 * (d15 + (1.0 - d14 + d23) * d17 / 6.0 + (5.0 - 18.0 * d14 + d21 + 72.0 * d23 - 58.0 * d26) * d19 / 120.0);
                double d33 = d2 + d3 * (d30 - d31 + d29 * d13 * (d16 / 2.0 + (5.0 - d14 + 9.0 * d23 + 4.0 * d24) * d18 / 24.0 + (61.0 - 58.0 * d14 + d21 + 600.0 * d23 - 330.0 * d26) * d20 / 720.0));
                dArray[i * n + 0] = d32 * this.getDistUnitsPerMeter();
                dArray[i * n + 1] = d33 * this.getDistUnitsPerMeter();
            }
        }

        @Override
        public void reverseProject(double[] dArray, int n) {
            double d = this.getFalseEastingInMeters();
            double d2 = this.getFalseNorthingInMeters();
            double d3 = this.m_scaleFactor;
            double d4 = this.m_centralMeridianInRadian;
            double d5 = this.m_latitudeOfOriginInRadian;
            double d6 = this.getGeodeticSrid().getSemiMajorAxisInMeters();
            double d7 = 1.0 / this.getGeodeticSrid().getInverseFlattening();
            double d8 = Math.sqrt(2.0 * d7 - d7 * d7);
            double d9 = d8 * d8;
            double d10 = d9 * d9;
            double d11 = d9 * d10;
            double d12 = (1.0 - Math.sqrt(1.0 - d9)) / (1.0 + Math.sqrt(1.0 - d9));
            double d13 = d12 * d12;
            double d14 = d12 * d13;
            double d15 = d13 * d13;
            for (int i = 0; i < dArray.length / n; ++i) {
                double d16;
                double d17 = dArray[i * n + 0] / this.getDistUnitsPerMeter();
                double d18 = d16 = dArray[i * n + 1] / this.getDistUnitsPerMeter();
                double d19 = d17;
                double d20 = d6 * ((1.0 - d9 / 4.0 - 3.0 * d10 / 64.0 - 5.0 * d11 / 256.0) * d5 - (3.0 * d9 / 8.0 + 3.0 * d10 / 32.0 + 45.0 * d11 / 1024.0) * Math.sin(2.0 * d5) + (15.0 * d10 / 256.0 + 45.0 * d11 / 1024.0) * Math.sin(4.0 * d5) - 35.0 * d11 / 3072.0 * Math.sin(6.0 * d5));
                double d21 = d20 + (d18 - d2) / d3;
                double d22 = d21 / (d6 * (1.0 - d9 / 4.0 - 3.0 * d10 / 64.0 - 5.0 * d11 / 256.0));
                double d23 = d22 + (3.0 * d12 / 2.0 - 27.0 * d14 / 32.0) * Math.sin(2.0 * d22) + (21.0 * d13 / 16.0 - 55.0 * d15 / 32.0) * Math.sin(4.0 * d22) + 151.0 * d14 / 96.0 * Math.sin(6.0 * d22) + 1097.0 * d15 / 512.0 * Math.sin(8.0 * d22);
                double d24 = Math.sin(d23);
                double d25 = Math.cos(d23);
                double d26 = Math.tan(d23);
                double d27 = d6 / Math.sqrt(1.0 - d9 * d24 * d24);
                double d28 = d6 * (1.0 - d9) / Math.pow(1.0 - d9 * d24 * d24, 1.5);
                double d29 = d26 * d26;
                double d30 = d8 / Math.sqrt(1.0 - d9);
                double d31 = d30 * d30;
                double d32 = d31 * d25 * d25;
                double d33 = d32 * d32;
                double d34 = d29 * d29;
                double d35 = (d19 - d) / (d27 * d3);
                double d36 = d35 * d35;
                double d37 = d35 * d36;
                double d38 = d36 * d36;
                double d39 = d36 * d37;
                double d40 = d37 * d37;
                double d41 = d23 - d27 * d26 / d28 * (d36 / 2.0 - (5.0 + 3.0 * d29 + 10.0 * d32 - 4.0 * d33 - 9.0 * d31) * d38 / 24.0 + (61.0 + 90.0 * d29 + 298.0 * d32 + 45.0 * d34 - 252.0 * d31 - 3.0 * d33) * d40 / 720.0);
                double d42 = d4 + (d35 - (1.0 + 2.0 * d29 + d32) * d37 / 6.0 + (5.0 - 2.0 * d32 + 28.0 * d29 - 3.0 * d33 + 8.0 * d31 + 24.0 * d34) * d39 / 120.0) / d25;
                dArray[i * n + 0] = d42 * this.getGeodeticSrid().getAngleUnitsPerRadian();
                dArray[i * n + 1] = d41 * this.getGeodeticSrid().getAngleUnitsPerRadian();
            }
        }
    }

    public static class LambertConformalConicSrid
    extends ProjectedSrid {
        private final double m_latitudeOfOriginInRadian;
        private final double m_centralMeridianInRadian;
        private final double m_standardParallel1InRadian;
        private final double m_standardParallel2InRadian;

        public static void registerLambertConformalConicSrid(long l, long l2, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            GeodeticSrid geodeticSrid = (GeodeticSrid)SRIDS.get(l2);
            if (geodeticSrid != null) {
                SRIDS.put(l, new LambertConformalConicSrid(l, (GeodeticSrid)SRIDS.get(l2), d, d2, d3, d4, d5, d6, d7));
            } else {
                System.out.println("Projected Lambert Conformal Conic SRID " + l + " based on non-existent geodetic SRID " + l2);
            }
        }

        protected LambertConformalConicSrid(long l, GeodeticSrid geodeticSrid, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            super(l, geodeticSrid, d, d2, d3);
            this.m_latitudeOfOriginInRadian = d4;
            this.m_centralMeridianInRadian = d5;
            this.m_standardParallel1InRadian = d6;
            this.m_standardParallel2InRadian = d7;
        }

        @Override
        public void project(double[] dArray, int n) {
            double d = this.getFalseEastingInMeters();
            double d2 = this.getFalseNorthingInMeters();
            double d3 = this.m_standardParallel1InRadian;
            double d4 = this.m_standardParallel2InRadian;
            double d5 = this.m_latitudeOfOriginInRadian;
            double d6 = this.m_centralMeridianInRadian;
            double d7 = this.getGeodeticSrid().getSemiMajorAxisInMeters();
            double d8 = 1.0 / this.getGeodeticSrid().getInverseFlattening();
            double d9 = Math.sqrt(2.0 * d8 - d8 * d8);
            double d10 = d9 * d9;
            for (int i = 0; i < dArray.length / n; ++i) {
                double d11 = dArray[i * n + 0] / this.getGeodeticSrid().getAngleUnitsPerRadian();
                double d12 = dArray[i * n + 1] / this.getGeodeticSrid().getAngleUnitsPerRadian();
                double d13 = Math.sin(d12);
                double d14 = Math.cos(d12);
                double d15 = Math.sin(d3);
                double d16 = Math.cos(d3);
                double d17 = Math.sin(d4);
                double d18 = Math.cos(d4);
                double d19 = Math.sin(d5);
                double d20 = Math.log(d9);
                double d21 = d14 / Math.sqrt(1.0 - d10 * d13 * d13);
                double d22 = d16 / Math.sqrt(1.0 - d10 * d15 * d15);
                double d23 = d18 / Math.sqrt(1.0 - d10 * d17 * d17);
                double d24 = Math.tan(0.7853981633974483 - d12 / 2.0) / Math.pow((1.0 - d9 * d13) / (1.0 + d9 * d13), d9 / 2.0);
                double d25 = Math.tan(0.7853981633974483 - d3 / 2.0) / Math.pow((1.0 - d9 * d15) / (1.0 + d9 * d15), d9 / 2.0);
                double d26 = Math.tan(0.7853981633974483 - d4 / 2.0) / Math.pow((1.0 - d9 * d17) / (1.0 + d9 * d17), d9 / 2.0);
                double d27 = Math.tan(0.7853981633974483 - d5 / 2.0) / Math.pow((1.0 - d9 * d19) / (1.0 + d9 * d19), d9 / 2.0);
                double d28 = (Math.log(d22) / d20 - Math.log(d23) / d20) / (Math.log(d25) / d20 - Math.log(d26) / d20);
                double d29 = d22 / (d28 * Math.pow(d25, d28));
                double d30 = d7 * d29 * Math.pow(d24, d28);
                double d31 = d7 * d29 * Math.pow(d27, d28);
                double d32 = d28 * (d11 - d6);
                double d33 = d + d30 * Math.sin(d32);
                double d34 = d2 + d31 - d30 * Math.cos(d32);
                dArray[i * n + 0] = d33 * this.getDistUnitsPerMeter();
                dArray[i * n + 0] = d34 * this.getDistUnitsPerMeter();
            }
        }

        @Override
        public void reverseProject(double[] dArray, int n) {
            double d = this.getFalseEastingInMeters();
            double d2 = this.getFalseNorthingInMeters();
            double d3 = this.m_standardParallel1InRadian;
            double d4 = this.m_standardParallel2InRadian;
            double d5 = this.m_latitudeOfOriginInRadian;
            double d6 = this.m_centralMeridianInRadian;
            double d7 = this.getGeodeticSrid().getSemiMajorAxisInMeters();
            double d8 = 1.0 / this.getGeodeticSrid().getInverseFlattening();
            double d9 = Math.sqrt(2.0 * d8 - d8 * d8);
            double d10 = d9 * d9;
            double d11 = Math.sin(d3);
            double d12 = Math.cos(d3);
            double d13 = Math.sin(d4);
            double d14 = Math.cos(d4);
            double d15 = Math.sin(d5);
            double d16 = Math.log(d9);
            double d17 = d12 / Math.sqrt(1.0 - d10 * d11 * d11);
            double d18 = d14 / Math.sqrt(1.0 - d10 * d13 * d13);
            double d19 = Math.tan(0.7853981633974483 - d3 / 2.0) / Math.pow((1.0 - d9 * d11) / (1.0 + d9 * d11), d9 / 2.0);
            double d20 = Math.tan(0.7853981633974483 - d4 / 2.0) / Math.pow((1.0 - d9 * d13) / (1.0 + d9 * d13), d9 / 2.0);
            double d21 = Math.tan(0.7853981633974483 - d5 / 2.0) / Math.pow((1.0 - d9 * d15) / (1.0 + d9 * d15), d9 / 2.0);
            double d22 = (Math.log(d17) / d16 - Math.log(d18) / d16) / (Math.log(d19) / d16 - Math.log(d20) / d16);
            double d23 = d17 / (d22 * Math.pow(d19, d22));
            double d24 = d7 * d23 * Math.pow(d21, d22);
            for (int i = 0; i < dArray.length / n; ++i) {
                double d25 = dArray[i * n + 0] / this.getDistUnitsPerMeter();
                double d26 = dArray[i * n + 1] / this.getDistUnitsPerMeter();
                double d27 = (double)(d22 >= 0.0 ? 1 : -1) * Math.pow(Math.pow(d25 - d, 2.0) + Math.pow(d24 - (d26 - d2), 2.0), 0.5);
                double d28 = Math.pow(d27 / (d7 * d23), 1.0 / d22);
                double d29 = Math.atan2(d25 - d, d24 - (d26 - d2));
                if (d29 > 1.5707963267948966) {
                    d29 -= Math.PI;
                }
                if (d29 < -1.5707963267948966) {
                    d29 += Math.PI;
                }
                double d30 = 1.5707963267948966 - 2.0 * Math.atan2(d28, 1.0);
                double d31 = d30 + 1.0;
                while (d31 != d30) {
                    d31 = d30;
                    d30 = 1.5707963267948966 - 2.0 * Math.atan2(d28 * Math.pow((1.0 - d9 * Math.sin(d30)) / (1.0 + d9 * Math.sin(d30)), d9 / 2.0), 1.0);
                }
                double d32 = d29 / d22 + d6;
                dArray[i * n + 0] = d32 * this.getGeodeticSrid().getAngleUnitsPerRadian();
                dArray[i * n + 1] = d30 * this.getGeodeticSrid().getAngleUnitsPerRadian();
            }
        }
    }

    public static abstract class ProjectedSrid
    extends Srid {
        private final GeodeticSrid m_geodeticSrid;
        private final double m_distUnitsPerMeter;
        private final double m_falseEastingInMeters;
        private final double m_falseNorthingInMeters;
        private final double m_heightDistUnitsPerMeter;

        protected ProjectedSrid(long l, GeodeticSrid geodeticSrid, double d, double d2, double d3) {
            super(l, new JGeometry(d2, d3, (int)l));
            this.m_geodeticSrid = geodeticSrid;
            this.m_distUnitsPerMeter = d;
            this.m_falseEastingInMeters = d2;
            this.m_falseNorthingInMeters = d3;
            this.m_heightDistUnitsPerMeter = 1.0;
        }

        public GeodeticSrid getGeodeticSrid() {
            return this.m_geodeticSrid;
        }

        public double getDistUnitsPerMeter() {
            return this.m_distUnitsPerMeter;
        }

        public double getFalseEastingInMeters() {
            return this.m_falseEastingInMeters;
        }

        public double getFalseNorthingInMeters() {
            return this.m_falseNorthingInMeters;
        }

        @Override
        public String toString() {
            return "Projected SRID " + this.getSrid();
        }

        public abstract void project(double[] var1, int var2);

        public abstract void reverseProject(double[] var1, int var2);

        @Override
        public void transform(double[] dArray, int n, GeodeticSrid geodeticSrid) {
            this.reverseProject(dArray, n);
            this.getGeodeticSrid().transform(dArray, n, geodeticSrid);
        }

        @Override
        public void transform(double[] dArray, int n, ProjectedSrid projectedSrid) {
            this.reverseProject(dArray, n);
            this.getGeodeticSrid().transform(dArray, n, projectedSrid);
        }
    }

    public static class GeodeticSrid
    extends Srid {
        private final double m_semiMajorAxisInMeters;
        private final double m_inverseFlattening;
        private final double[] m_toWgs84Params;
        private final double m_angleUnitsPerRadian;
        private final double m_heightDistUnitsPerMeter;
        private final double m_primeMeridianRelativeToGreenichInRadian;

        protected GeodeticSrid(long l, double d, double d2, double[] dArray, double d3, double d4) {
            super(l, new JGeometry(0.0, 30.0, (int)l));
            this.m_semiMajorAxisInMeters = d;
            this.m_inverseFlattening = d2;
            this.m_toWgs84Params = dArray;
            this.m_angleUnitsPerRadian = d3;
            this.m_heightDistUnitsPerMeter = 1.0;
            this.m_primeMeridianRelativeToGreenichInRadian = d4;
        }

        protected GeodeticSrid(long l, double d, double d2, double[] dArray) {
            this(l, d, d2, dArray, 57.29577951308232, 0.0);
        }

        public double getSemiMajorAxisInMeters() {
            return this.m_semiMajorAxisInMeters;
        }

        public double getInverseFlattening() {
            return this.m_inverseFlattening;
        }

        public double[] getToWgs84Params() {
            return this.m_toWgs84Params;
        }

        public double getAngleUnitsPerRadian() {
            return this.m_angleUnitsPerRadian;
        }

        public double getPrimeMeridianInRadian() {
            return this.m_primeMeridianRelativeToGreenichInRadian;
        }

        @Override
        public String toString() {
            return "Geodetic SRID " + this.getSrid();
        }

        @Override
        public void transform(double[] dArray, int n, GeodeticSrid geodeticSrid) {
            double d = (this.getToWgs84Params()[6] - geodeticSrid.getToWgs84Params()[6]) / 1000000.0;
            double d2 = (this.getToWgs84Params()[3] - geodeticSrid.getToWgs84Params()[3]) * Math.PI / 180.0 / 3600.0;
            double d3 = (this.getToWgs84Params()[4] - geodeticSrid.getToWgs84Params()[4]) * Math.PI / 180.0 / 3600.0;
            double d4 = (this.getToWgs84Params()[5] - geodeticSrid.getToWgs84Params()[5]) * Math.PI / 180.0 / 3600.0;
            double d5 = this.getToWgs84Params()[0] - geodeticSrid.getToWgs84Params()[0];
            double d6 = this.getToWgs84Params()[1] - geodeticSrid.getToWgs84Params()[1];
            double d7 = this.getToWgs84Params()[2] - geodeticSrid.getToWgs84Params()[2];
            double d8 = 1.0 + d;
            double d9 = this.getSemiMajorAxisInMeters();
            double d10 = 1.0 / this.getInverseFlattening();
            double d11 = Math.sqrt(2.0 * d10 - d10 * d10);
            for (int i = 0; i < dArray.length / n; ++i) {
                double d12 = dArray[i * n + 0] / this.getAngleUnitsPerRadian() + this.getPrimeMeridianInRadian();
                double d13 = dArray[i * n + 1] / this.getAngleUnitsPerRadian();
                double d14 = (n == 3 ? dArray[i * n + 2] : 0.0) * this.m_heightDistUnitsPerMeter;
                double d15 = d9 / Math.sqrt(1.0 - d11 * d11 * Math.sin(d13) * Math.sin(d13));
                double d16 = geodeticSrid.getSemiMajorAxisInMeters();
                double d17 = 1.0 / geodeticSrid.getInverseFlattening();
                double d18 = Math.sqrt(2.0 * d17 - d17 * d17);
                double d19 = (1.0 - d17) * d16;
                double d20 = (d15 + d14) * Math.cos(d13) * Math.cos(d12);
                double d21 = (d15 + d14) * Math.cos(d13) * Math.sin(d12);
                double d22 = ((1.0 - d11 * d11) * d15 + d14) * Math.sin(d13);
                double d23 = d8 * (1.0 * d20 - d4 * d21 + d3 * d22) + d5;
                double d24 = d8 * (d4 * d20 + 1.0 * d21 - d2 * d22) + d6;
                double d25 = d8 * (-d3 * d20 + d2 * d21 + 1.0 * d22) + d7;
                double d26 = Math.sqrt(d23 * d23 + d24 * d24);
                double d27 = Math.atan2(d25 * d16, d26 * d19);
                double d28 = d18 * d18 / (1.0 - d18 * d18);
                double d29 = Math.atan2(d24, d23);
                double d30 = Math.atan2(d25 + d28 * d19 * Math.sin(d27) * Math.sin(d27) * Math.sin(d27), d26 - d18 * d18 * d16 * Math.cos(d27) * Math.cos(d27) * Math.cos(d27));
                double d31 = d16 / Math.sqrt(1.0 - d18 * d18 * Math.sin(d30) * Math.sin(d30));
                double d32 = Math.sqrt(d23 * d23 + d24 * d24) * (1.0 / Math.cos(d30)) - d31;
                dArray[i * n + 0] = (d29 - geodeticSrid.getPrimeMeridianInRadian()) * geodeticSrid.getAngleUnitsPerRadian();
                dArray[i * n + 1] = d30 * geodeticSrid.getAngleUnitsPerRadian();
                if (n != 3) continue;
                dArray[i * n + 2] = d32 / geodeticSrid.m_heightDistUnitsPerMeter;
            }
        }

        @Override
        public void transform(double[] dArray, int n, ProjectedSrid projectedSrid) {
            this.transform(dArray, n, projectedSrid.getGeodeticSrid());
            projectedSrid.project(dArray, n);
        }
    }

    public static abstract class Srid {
        private final long m_srid;
        private final JGeometry m_truthPoint;

        protected Srid(long l, JGeometry jGeometry) {
            this.m_srid = l;
            this.m_truthPoint = jGeometry;
        }

        public long getSrid() {
            return this.m_srid;
        }

        public String toString() {
            return "SRID " + this.m_srid;
        }

        public JGeometry getSampleTruthPoint() {
            return this.m_truthPoint;
        }

        public abstract void transform(double[] var1, int var2, GeodeticSrid var3);

        public abstract void transform(double[] var1, int var2, ProjectedSrid var3);

        public JGeometry transform(JGeometry jGeometry, GeodeticSrid geodeticSrid) {
            double[] dArray = new double[]{jGeometry.getPoint()[0], jGeometry.getPoint()[1]};
            this.transform(dArray, jGeometry.getDimensions(), geodeticSrid);
            return new JGeometry(dArray[0], dArray[1], (int)geodeticSrid.getSrid());
        }

        public JGeometry transform(JGeometry jGeometry, ProjectedSrid projectedSrid) {
            double[] dArray;
            int n = jGeometry.getDimensions();
            if (n == 2) {
                double[] dArray2 = new double[2];
                dArray2[0] = jGeometry.getPoint()[0];
                dArray = dArray2;
                dArray2[1] = jGeometry.getPoint()[1];
            } else {
                double[] dArray3 = new double[3];
                dArray3[0] = jGeometry.getPoint()[0];
                dArray3[1] = jGeometry.getPoint()[1];
                dArray = dArray3;
                dArray3[2] = jGeometry.getPoint()[2];
            }
            double[] dArray4 = dArray;
            this.transform(dArray4, n, projectedSrid);
            if (n == 2) {
                return new JGeometry(dArray4[0], dArray4[1], (int)projectedSrid.getSrid());
            }
            return new JGeometry(dArray4[0], dArray4[1], dArray4[2], (int)projectedSrid.getSrid());
        }
    }
}

