/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelAll;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJob;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobAbortedException;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobExecutor;
import org.strategoxt.lang.parallel.stratego_parallel.PureOperatorSet;

public class ParallelContext
extends Context {
    private final Context innerContext;
    private final ParallelJob job;
    private final AtomicBoolean isAborted;
    private final boolean allowUnordered;
    private AtomicReference<String> lastSynchronousOperation;

    public ParallelContext(Context context, ParallelJob job, AtomicBoolean aborted, boolean allowUnordered) {
        super(context.getFactory(), new HashMap<String, IOperatorRegistry>(context.getOperatorRegistries()), true);
        this.innerContext = context;
        this.job = job;
        this.isAborted = aborted;
        this.allowUnordered = allowUnordered;
        SSLLibrary lib = new SSLLibrary();
        lib.setIOAgent(context.getIOAgent());
        this.addOperatorRegistry(lib);
    }

    void setLastSynchronousOperation(AtomicReference<String> value) {
        this.lastSynchronousOperation = value;
    }

    public Context getInnerContext() {
        return this.innerContext;
    }

    protected void finalize() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoTerm invokePrimitive(AbstractPrimitive primitive, IStrategoTerm term, Strategy[] args, IStrategoTerm[] targs) {
        if (this.isAborted.get() && !this.job.isFocusJob()) {
            throw new ParallelJobAbortedException();
        }
        String name2 = primitive.getName();
        if (this.job.isFocusJob()) {
            return super.invokePrimitive(primitive, term, args, targs);
        }
        if (PureOperatorSet.isWhiteListed(name2)) {
            return super.invokePrimitive(primitive, term, args, targs);
        }
        if (this.allowUnordered) {
            Class<ParallelContext> clazz = ParallelContext.class;
            synchronized (ParallelContext.class) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return super.invokePrimitive(primitive, term, args, targs);
            }
        }
        this.waitForFocus();
        ParallelJobExecutor parallelJobExecutor = ParallelAll.instance.getExecutor();
        synchronized (parallelJobExecutor) {
            return super.invokePrimitive(primitive, term, args, targs);
        }
    }

    public final ParallelJob getJob() {
        return this.job;
    }

    public void waitForFocus() {
        if (this.allowUnordered || this.job.isFocusJob()) {
            return;
        }
        ParallelJobExecutor executor = ParallelAll.instance.getExecutor();
        executor.asyncBeginSleep();
        try {
            try {
                this.job.waitForFocus();
                if (this.isAborted.get() && !this.job.isFocusJob()) {
                    throw new ParallelJobAbortedException();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            executor.asyncEndSleep();
        }
    }
}

