/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.gradual;

import io.usethesource.capsule.BinaryRelation;
import io.usethesource.capsule.Set;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.strategoxt.lang.gradual.ConstructorArity;
import org.strategoxt.lang.gradual.DynT;
import org.strategoxt.lang.gradual.IllFormedTermT;
import org.strategoxt.lang.gradual.IllFormedTerms;
import org.strategoxt.lang.gradual.IntT;
import org.strategoxt.lang.gradual.RealT;
import org.strategoxt.lang.gradual.Sort;
import org.strategoxt.lang.gradual.StringT;
import org.strategoxt.lang.gradual.Type;
import org.strategoxt.lang.gradual.TypedConstructor;

public class TypeInfo {
    private BinaryRelation.Transient<Type, Type> injections = BinaryRelation.Transient.of();
    private BinaryRelation.Transient<ConstructorArity, TypedConstructor> consSorts = BinaryRelation.Transient.of();

    public boolean typeIsA(Type currentType, Type type) {
        if (type == DynT.INSTANCE) {
            return true;
        }
        if (this.injections.containsEntry((Object)currentType, (Object)type)) {
            return true;
        }
        if (currentType instanceof Sort && type instanceof Sort) {
            Sort currentSort = (Sort)currentType;
            Sort sort = (Sort)type;
            if (currentSort.sort.equals(sort.sort)) {
                return this.typeIsA(currentSort.types, sort.types);
            }
        }
        return (currentType instanceof IntT || currentType instanceof RealT || currentType instanceof StringT) && currentType.equals(type);
    }

    public boolean typeIsA(Collection<Type> currentTypes, Collection<Type> types) {
        if (currentTypes.size() == types.size()) {
            Iterator<Type> ctIter = currentTypes.iterator();
            Iterator<Type> tIter = types.iterator();
            while (ctIter.hasNext()) {
                if (this.typeIsA(ctIter.next(), tIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Type leastUpperBound(List<Type> subTermTypes) {
        if (subTermTypes.isEmpty()) {
            throw new IllegalArgumentException("least upper bound of empty list is undefined");
        }
        Iterator<Type> it = subTermTypes.iterator();
        Type lub = it.next();
        while (it.hasNext()) {
            Type next = it.next();
            if (this.typeIsA(lub, next)) {
                lub = next;
                continue;
            }
            if (this.typeIsA(next, lub)) continue;
            HashSet<Type> upperBounds = new HashSet<Type>();
            upperBounds.addAll((Collection<Type>)this.injections.get((Object)lub));
            upperBounds.retainAll((Collection<?>)this.injections.get((Object)next));
            lub = upperBounds.isEmpty() ? IllFormedTerms.INSTANCE : this.lowestType(upperBounds);
        }
        return lub;
    }

    private Type lowestType(Collection<Type> relatedTypes) {
        assert (relatedTypes.size() > 1);
        Iterator<Type> it = relatedTypes.iterator();
        Type lowestType = it.next();
        while (it.hasNext()) {
            Type next = it.next();
            if (this.typeIsA(lowestType, next)) continue;
            lowestType = next;
        }
        return lowestType;
    }

    public Type typeOf(String constructorName, List<Type> subTermTypes) {
        Set.Immutable typedConstructors = this.consSorts.get((Object)new ConstructorArity(constructorName, subTermTypes.size()));
        Type type = null;
        for (TypedConstructor tc : typedConstructors) {
            if (!this.typeIsA(subTermTypes, tc.subTermTypes)) continue;
            type = tc.sort;
        }
        if (type != null) {
            return type;
        }
        return new IllFormedTermT(constructorName, subTermTypes);
    }

    public void registerConstructor(Type sort, String name2, List<Type> subTermTypes) {
        this.consSorts.__insert((Object)new ConstructorArity(name2, subTermTypes.size()), (Object)new TypedConstructor(name2, subTermTypes, sort));
    }

    public void registerInjection(Type from, Type to2) {
        this.injections.__insert((Object)from, (Object)to2);
    }

    public void finishRegistration() {
        this.injections = TypeInfo.reflexiveTransitiveClosure((BinaryRelation.Immutable<Type, Type>)this.injections.freeze());
    }

    private static BinaryRelation.Transient<Type, Type> reflexiveTransitiveClosure(BinaryRelation.Immutable<Type, Type> rel) {
        LinkedList<AbstractMap.SimpleImmutableEntry<Type, Type>> worklist = new LinkedList<AbstractMap.SimpleImmutableEntry<Type, Type>>(rel.entrySet());
        BinaryRelation.Transient result = rel.asTransient();
        while (!worklist.isEmpty()) {
            Map.Entry e = (Map.Entry)worklist.pop();
            for (Type post : rel.get(e.getValue())) {
                if (result.containsEntry(e.getKey(), (Object)post)) continue;
                result.__insert((Object)((Type)e.getKey()), (Object)post);
                worklist.add(new AbstractMap.SimpleImmutableEntry<Type, Type>((Type)e.getKey(), post));
            }
        }
        for (Map.Entry e : rel.entrySet()) {
            Type key = (Type)e.getKey();
            Type value = (Type)e.getValue();
            result.__insert((Object)key, (Object)key);
            result.__insert((Object)value, (Object)value);
        }
        return result;
    }

    public void clear() {
        this.injections = BinaryRelation.Transient.of();
        this.consSorts = BinaryRelation.Transient.of();
    }
}

