/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.gradual;

import java.util.ArrayList;
import java.util.Collections;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.AbstractTermAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;
import org.spoofax.terms.attachments.VolatileTermAttachmentType;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.lang.gradual.IllFormedTerms;
import org.strategoxt.lang.gradual.IntT;
import org.strategoxt.lang.gradual.RealT;
import org.strategoxt.lang.gradual.Sort;
import org.strategoxt.lang.gradual.StrategoTypeException;
import org.strategoxt.lang.gradual.StringT;
import org.strategoxt.lang.gradual.Type;
import org.strategoxt.lang.gradual.TypeInfo;

public class TypeAttachment
extends AbstractTermAttachment {
    public final Type type;

    public TypeAttachment(Type type) {
        this.type = type;
    }

    @Override
    public TermAttachmentType<?> getAttachmentType() {
        return TypeAttachmentType.INSTANCE;
    }

    public static Type getType(IStrategoTerm current) {
        TypeAttachment attachment = current.getAttachment(TypeAttachmentType.INSTANCE);
        return attachment == null ? null : attachment.type;
    }

    public static Type getOrComputeType(TypeInfo typeInfo, IStrategoTerm current) {
        Type type = TypeAttachment.getType(current);
        if (type != null) {
            return type;
        }
        type = TypeAttachment.computeType(typeInfo, current);
        current.putAttachment(new TypeAttachment(type));
        return type;
    }

    private static Type computeType(TypeInfo typeInfo, IStrategoTerm current) {
        ArrayList<Type> subTermTypes = new ArrayList<Type>(current.getSubtermCount());
        for (IStrategoTerm subTerm : current) {
            Type subTermType = TypeAttachment.getOrComputeType(typeInfo, subTerm);
            subTermTypes.add(subTermType);
        }
        switch (current.getTermType()) {
            case 3: {
                return IntT.INSTANCE;
            }
            case 4: {
                return RealT.INSTANCE;
            }
            case 5: {
                return StringT.INSTANCE;
            }
            case 1: {
                IStrategoAppl appl = TermUtils.toAppl(current);
                return typeInfo.typeOf(appl.getName(), subTermTypes);
            }
            case 2: {
                if (subTermTypes.isEmpty()) {
                    return new Sort("List", Collections.singletonList(IllFormedTerms.INSTANCE));
                }
                Type leastUpperBound = typeInfo.leastUpperBound(subTermTypes);
                return new Sort("List", Collections.singletonList(leastUpperBound));
            }
            case 7: {
                return new Sort("Tuple", subTermTypes);
            }
        }
        throw new StrategoTypeException(current);
    }

    public static class TypeAttachmentType
    extends VolatileTermAttachmentType<TypeAttachment> {
        public static final TypeAttachmentType INSTANCE = new TypeAttachmentType();

        private TypeAttachmentType() {
            super(TypeAttachment.class);
        }
    }
}

