/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.HybridInterpreter;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.InteropStrategy;
import org.strategoxt.lang.MissingStrategyException;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;

public class InteropSDefT
extends SDefT {
    private static final SDefT.SVar[] NO_SVARS = new SDefT.SVar[0];
    private static final String[] NO_STRINGS = new String[0];
    private final String strategyClassName;
    private final ClassLoader classLoader;
    private Strategy strategy;

    public InteropSDefT(Strategy strategy, IContext context) {
        super(context.getVarScope());
        this.strategyClassName = null;
        this.classLoader = null;
        this.strategy = strategy;
    }

    @Deprecated
    public InteropSDefT(Strategy strategy, IContext context, Context compiledContext) {
        this(strategy, context);
    }

    public InteropSDefT(ClassLoader classLoader, String strategyClassName, IContext context) {
        super(context.getVarScope());
        this.classLoader = classLoader;
        this.strategyClassName = strategyClassName;
    }

    @Deprecated
    public InteropSDefT(ClassLoader classLoader, String strategyClassName, IContext context, Context compiledContext) {
        this(classLoader, strategyClassName, context);
    }

    public static SDefT[] toInteropSDefTs(Strategy[] strategies, IContext context) {
        SDefT[] results = new SDefT[strategies.length];
        int i = 0;
        while (i < strategies.length) {
            Strategy strategy = strategies[i];
            results[i] = strategy instanceof InteropStrategy ? ((InteropStrategy)strategy).getDefinition() : new InteropSDefT(strategy, context);
            ++i;
        }
        return results;
    }

    @Override
    public String getName() {
        return this.getStrategy().getName();
    }

    @Override
    protected void setName(String name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompiledStrategy() {
        return true;
    }

    @Override
    public SDefT.SVar[] getStrategyParams() {
        int countEnd;
        SDefT.SVar[] results = super.getStrategyParams();
        if (results != null) {
            return results;
        }
        String name2 = this.getName();
        int countStart = name2.lastIndexOf(95, (countEnd = name2.lastIndexOf(95)) - 1);
        if (countStart == -1 || countEnd == -1 || name2.lastIndexOf("_lifted") == countEnd) {
            return NO_SVARS;
        }
        int count = Integer.parseInt(name2.substring(countStart + 1, countEnd));
        if (count == 0) {
            return NO_SVARS;
        }
        results = new SDefT.SVar[count];
        int i = 0;
        while (i < results.length) {
            results[i] = new SDefT.SVar("s" + i, SDefT.ConstType.INSTANCE);
            ++i;
        }
        return results;
    }

    @Override
    public String[] getTermParams() {
        int count;
        String[] results = super.getTermParams();
        if (results != null) {
            return results;
        }
        String name2 = this.getName();
        int countStart = name2.lastIndexOf(95);
        try {
            count = Integer.parseInt(name2.substring(countStart + 1));
        }
        catch (NumberFormatException e) {
            return NO_STRINGS;
        }
        if (count == 0) {
            return NO_STRINGS;
        }
        results = new String[count];
        int i = 0;
        while (i < results.length) {
            results[i] = "t" + i;
            ++i;
        }
        return results;
    }

    @Override
    public org.spoofax.interpreter.stratego.Strategy getBody() {
        org.spoofax.interpreter.stratego.Strategy result = super.getBody();
        if (result == null) {
            result = new StrategyBody();
            this.setBody(result);
        }
        return result;
    }

    @Override
    public org.spoofax.interpreter.stratego.Strategy getParametrizedBody(final org.spoofax.interpreter.stratego.Strategy[] sargs, final IStrategoTerm[] targs) {
        return new StrategyBody(this){

            @Override
            public boolean evaluate(IContext env) throws InterpreterException {
                SDefT[] sargDefs = new SDefT[sargs.length];
                int i = 0;
                while (i < sargs.length) {
                    sargDefs[i] = new SDefT("s" + i, NO_SVARS, NO_STRINGS, sargs[i], env.getVarScope());
                    ++i;
                }
                return this.evaluate(env, InteropStrategy.toInteropStrategies(sargDefs), targs);
            }
        };
    }

    @Override
    public boolean evaluate(IContext env) throws InterpreterErrorExit, InterpreterExit, InterpreterException {
        VarScope scope = env.getVarScope();
        SDefT.SVar[] svars = this.getStrategyParams();
        String[] tvars = this.getTermParams();
        SDefT[] sargs = new SDefT[svars.length];
        IStrategoTerm[] targs = new IStrategoTerm[tvars.length];
        int i = 0;
        while (i < svars.length) {
            SDefT sarg = scope.lookupSVar(svars[i].name);
            if (sarg == null) {
                throw new InterpreterException("Missing strategy argument: " + svars[i].name);
            }
            sargs[i] = sarg;
            ++i;
        }
        i = 0;
        while (i < tvars.length) {
            IStrategoTerm targ = scope.lookup(tvars[i]);
            if (targ == null) {
                throw new InterpreterException("Missing term argument: " + tvars[i]);
            }
            targs[i] = targ;
            ++i;
        }
        return this.evaluate(env, InteropStrategy.toInteropStrategies(sargs), targs);
    }

    private boolean evaluate(IContext env, Strategy[] sargs, IStrategoTerm[] targs) throws InterpreterErrorExit, InterpreterExit, InterpreterException {
        IStrategoTerm result;
        try {
            Context context = HybridInterpreter.getCompiledContext(env);
            result = this.getStrategy().invokeDynamic(context, env.current(), sargs, targs);
        }
        catch (StrategoErrorExit e) {
            throw new InterpreterErrorExit(e.getMessage(), e.getTerm(), e.getTrace(), e.getCause());
        }
        catch (StrategoExit e) {
            throw new InterpreterExit(e.getValue(), (Throwable)e);
        }
        catch (MissingStrategyException e) {
            throw new InterpreterException(e);
        }
        if (result != null) {
            env.setCurrent(result);
            return true;
        }
        return false;
    }

    public Strategy getStrategy() {
        if (this.strategy == null) {
            try {
                Class<?> strategyClass = this.classLoader.loadClass(this.strategyClassName);
                this.strategy = (Strategy)strategyClass.getField("instance").get(null);
            }
            catch (ClassNotFoundException e) {
                throw new StrategoException("Unable to instantiate compiled strategy", e);
            }
            catch (IllegalAccessException e) {
                throw new StrategoException("Unable to instantiate compiled strategy", e);
            }
            catch (IllegalArgumentException e) {
                throw new StrategoException("Unable to instantiate compiled strategy", e);
            }
            catch (SecurityException e) {
                throw new StrategoException("Unable to instantiate compiled strategy", e);
            }
            catch (NoSuchFieldException e) {
                throw new StrategoException("Unable to instantiate compiled strategy", e);
            }
        }
        return this.strategy;
    }

    private class StrategyBody
    extends org.spoofax.interpreter.stratego.Strategy {
        private StrategyBody() {
        }

        @Override
        public IConstruct eval(IContext env) throws InterpreterException {
            return this.evaluate(env) ? this.getHook().pop().onSuccess(env) : this.getHook().pop().onFailure(env);
        }

        @Override
        public boolean evaluate(IContext env) throws InterpreterException {
            return InteropSDefT.this.evaluate(env);
        }

        @Override
        public void prettyPrint(StupidFormatter fmt) {
            InteropSDefT.this.prettyPrint(fmt);
        }

        @Override
        protected String getTraceName() {
            return InteropSDefT.this.getName();
        }

        /* synthetic */ StrategyBody(StrategyBody strategyBody, StrategyBody strategyBody2) {
            this();
        }
    }
}

