/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.LazyTerm;
import org.spoofax.terms.io.binary.TermReader;
import org.strategoxt.lang.StrategoException;

public class ImportTerm
extends LazyTerm {
    private final transient ITermFactory factory;
    private final transient String path;
    private final transient String name;
    private final transient Class<?> container;
    private transient ZipFile lastZipFile;

    public ImportTerm(ITermFactory factory, Class<?> container, String path, String name2) {
        assert (path.endsWith("/"));
        this.factory = factory;
        this.container = container;
        this.path = path;
        this.name = name2;
    }

    @Override
    protected IStrategoTerm init() {
        InputStream stream = this.openStream();
        try {
            IStrategoTerm result;
            IStrategoTerm iStrategoTerm = result = new TermReader(this.factory).parseFromStream(stream);
            return iStrategoTerm;
        }
        catch (IOException e) {
            throw new StrategoException(String.valueOf(this.container.getSimpleName()) + ": Could not read imported term file " + this.name, e);
        }
        catch (RuntimeException e) {
            throw new StrategoException(String.valueOf(this.container.getSimpleName()) + ": Could not read imported term file " + this.name, e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (this.lastZipFile != null) {
                    this.lastZipFile.close();
                }
                this.lastZipFile = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private InputStream openStream() {
        InputStream result = this.tryOpenStreamFromJar();
        if (result == null) {
            result = this.container.getResourceAsStream(String.valueOf(ImportTerm.removePrecedingSlash(this.path)) + this.name);
        }
        if (result == null) {
            result = this.container.getResourceAsStream(String.valueOf(this.path) + this.name);
        }
        if (result == null) {
            result = this.container.getResourceAsStream("/" + this.name);
        }
        if (result == null) {
            throw new StrategoException(String.valueOf(this.container.getSimpleName()) + ": Could not find imported term file " + this.name);
        }
        return result;
    }

    private InputStream tryOpenStreamFromJar() {
        block5: {
            ZipEntry entry;
            ZipFile jar;
            block6: {
                try {
                    URL location = this.container.getProtectionDomain().getCodeSource().getLocation();
                    if (!location.getFile().endsWith(".jar")) break block5;
                    File jarFile = new File(location.toURI());
                    this.lastZipFile = new ZipFile(jarFile);
                    jar = this.lastZipFile;
                    entry = jar.getEntry(String.valueOf(ImportTerm.removePrecedingSlash(this.path)) + this.name);
                    if (entry == null) {
                        entry = jar.getEntry(String.valueOf(this.path) + this.name);
                    }
                    if (entry == null) {
                        entry = jar.getEntry(this.name);
                    }
                    if (entry != null) break block6;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return jar.getInputStream(entry);
        }
        return null;
    }

    private static String removePrecedingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getWrapped();
        out.defaultWriteObject();
    }
}

