/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.util.Assert;

public class M {
    public static IStrategoAppl appl(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoAppl.class);
        return (IStrategoAppl)term;
    }

    public static IStrategoAppl appl(IStrategoTerm term, int arity2) {
        IStrategoAppl appl = M.appl(term);
        Assert.assertEquals(arity2, appl.getSubtermCount());
        return appl;
    }

    public static IStrategoAppl appl(IStrategoTerm term, String cons, int arity2) {
        IStrategoAppl appl = M.appl(term, arity2);
        Assert.assertEquals(cons, appl.getName());
        return appl;
    }

    public static IStrategoTuple tuple(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoTuple.class);
        return (IStrategoTuple)term;
    }

    public static IStrategoTuple tuple(IStrategoTerm term, int arity2) {
        IStrategoTuple tuple2 = M.tuple(term);
        Assert.assertEquals(arity2, tuple2.getSubtermCount());
        return tuple2;
    }

    public static IStrategoList list(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoList.class);
        return (IStrategoList)term;
    }

    public static String string(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoString.class);
        return ((IStrategoString)term).stringValue();
    }

    public static int integer(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoInt.class);
        return ((IStrategoInt)term).intValue();
    }

    public static IStrategoTerm at(IStrategoAppl appl, int n) {
        return appl.getSubterm(n);
    }

    public static IStrategoTerm at(IStrategoTuple tuple2, int n) {
        return tuple2.getSubterm(n);
    }

    public static IStrategoTerm at(IStrategoList list2, int n) {
        return list2.getSubterm(n);
    }

    public static <R> Optional<R> maybe(Supplier<R> matcher) {
        R result;
        try {
            result = matcher.get();
        }
        catch (AssertionError | ClassCastException e) {
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

