/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io.binary;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.TAFTermReader;
import org.spoofax.terms.io.binary.BAFReader;
import org.spoofax.terms.io.binary.SAFReader;

public class TermReader
extends TAFTermReader {
    public TermReader(ITermFactory factory) {
        super(factory);
    }

    @Override
    public IStrategoTerm parseFromStream(InputStream inputStream) throws IOException, ParseError {
        try (BufferedInputStream bis = null;){
            bis = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            if (BAFReader.isBinaryATerm(bis)) {
                IStrategoTerm iStrategoTerm = new BAFReader(this.factory, bis).readFromBinaryFile(true);
                return iStrategoTerm;
            }
            if (SAFReader.isStreamingATerm(bis)) {
                IStrategoTerm iStrategoTerm = SAFReader.readTermFromSAFStream(this.factory, bis);
                return iStrategoTerm;
            }
            IStrategoTerm iStrategoTerm = super.parseFromStream(bis);
            return iStrategoTerm;
        }
    }
}

