/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io.binary;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.io.TermWriter;
import org.spoofax.terms.io.binary.ATermConstants;
import org.spoofax.terms.util.TermUtils;

public final class SAFWriter
implements TermWriter {
    @Deprecated
    public static void writeTermToSAFFile(IStrategoTerm term, File file) throws IOException {
        SAFWriter writer = new SAFWriter();
        writer.writeToFile(term, file);
    }

    @Deprecated
    public static byte[] writeTermToSAFString(IStrategoTerm term) {
        SAFWriter writer = new SAFWriter();
        return writer.writeToBytes(term);
    }

    @Deprecated
    public static void writeTermToSAFStream(IStrategoTerm term, OutputStream outputStream) throws IOException {
        SAFWriter writer = new SAFWriter();
        writer.write(term, outputStream);
    }

    @Override
    public void write(IStrategoTerm term, OutputStream outputStream) throws IOException {
        SAFWriterInternal binaryWriter = new SAFWriterInternal(term);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        WritableByteChannel channel = Channels.newChannel(outputStream);
        outputStream.write(63);
        do {
            byteBuffer.clear();
            binaryWriter.serialize(byteBuffer);
            int blockSize = byteBuffer.limit();
            outputStream.write((byte)(blockSize & 0xFF));
            outputStream.write((byte)(blockSize >>> 8 & 0xFF));
            channel.write(byteBuffer);
        } while (!binaryWriter.isFinished());
    }

    private static final class SAFWriterInternal {
        private static final int ISSHAREDFLAG = 128;
        private static final int ANNOSFLAG = 16;
        private static final int ISFUNSHARED = 64;
        private static final int APPLQUOTED = 32;
        private static final int STACKSIZE = 256;
        private static final int MINIMUMFREESPACE = 10;
        private final Map<IStrategoTerm, Integer> sharedTerms = new HashMap<IStrategoTerm, Integer>();
        private int currentKey = 0;
        private final Map<Object, Integer> applSignatures = new HashMap<Object, Integer>();
        private int sigKey = 0;
        private ATermMapping[] stack = new ATermMapping[256];
        private int stackPosition = 0;
        private IStrategoTerm currentTerm;
        private int indexInTerm;
        private byte[] tempNameWriteBuffer;
        private ByteBuffer currentBuffer;
        private static final int SEVENBITS = 127;
        private static final int SIGNBIT = 128;
        private static final int LONGBITS = 8;

        private SAFWriterInternal(IStrategoTerm root) {
            ATermMapping tm = new ATermMapping();
            tm.term = root;
            this.stack[this.stackPosition] = tm;
            this.currentTerm = root;
            this.indexInTerm = 0;
            this.tempNameWriteBuffer = null;
        }

        public void serialize(ByteBuffer buffer) {
            this.currentBuffer = buffer;
            while (this.currentTerm != null) {
                if (buffer.remaining() < 10) break;
                Integer id = this.sharedTerms.get(this.currentTerm);
                if (id != null) {
                    buffer.put((byte)-128);
                    this.writeInt(id);
                    --this.stackPosition;
                } else {
                    this.visit(this.currentTerm);
                    if (TermUtils.isList(this.currentTerm)) {
                        this.stack[this.stackPosition].nextPartOfList = (IStrategoList)this.currentTerm;
                    }
                    if (this.indexInTerm != 0) break;
                    this.sharedTerms.put(this.currentTerm, new Integer(this.currentKey++));
                }
                this.currentTerm = this.getNextTerm();
            }
            buffer.flip();
        }

        protected void visit(IStrategoTerm term) {
            switch (term.getType()) {
                case APPL: {
                    this.voidVisitAppl((IStrategoAppl)term);
                    break;
                }
                case INT: {
                    this.voidVisitInt((IStrategoInt)term);
                    break;
                }
                case LIST: {
                    this.voidVisitList((IStrategoList)term);
                    break;
                }
                case REAL: {
                    this.voidVisitReal((IStrategoReal)term);
                    break;
                }
                case STRING: {
                    this.voidVisitString((IStrategoString)term);
                    break;
                }
                case TUPLE: {
                    this.voidVisitTuple((IStrategoTuple)term);
                    break;
                }
                default: {
                    throw new RuntimeException("Could not serialize term of type " + term.getClass().getName() + " to SAF format.");
                }
            }
        }

        private void voidVisitTuple(IStrategoTuple term) {
            this.writeAppl(term, term.getSubtermCount(), "", false);
        }

        private void voidVisitString(IStrategoString term) {
            this.writeAppl(term, term.stringValue(), term.stringValue(), true);
        }

        public boolean isFinished() {
            return this.currentTerm == null;
        }

        private IStrategoTerm getNextTerm() {
            IStrategoTerm next = null;
            this.ensureStackCapacity();
            while (next == null && this.stackPosition > -1) {
                boolean hasRemainigSubterms;
                ATermMapping current = this.stack[this.stackPosition];
                IStrategoTerm term = current.term;
                boolean bl = hasRemainigSubterms = current.subTermsAfter > 0 || term.getSubtermCount() > current.subTermIndex + 1;
                if (hasRemainigSubterms) {
                    if (!TermUtils.isList(term)) {
                        next = term.getSubterm(++current.subTermIndex);
                    } else {
                        IStrategoList nextList = current.nextPartOfList;
                        next = nextList.head();
                        current.nextPartOfList = nextList.tail();
                        ++current.subTermIndex;
                        --current.subTermsAfter;
                    }
                    ATermMapping child = new ATermMapping();
                    child.term = next;
                    if (TermUtils.isList(next)) {
                        child.subTermsAfter = next.getSubtermCount();
                    }
                    this.stack[++this.stackPosition] = child;
                    continue;
                }
                if (!current.annosDone && !term.getAnnotations().isEmpty()) {
                    next = term.getAnnotations();
                    ATermMapping annos = new ATermMapping();
                    annos.term = next;
                    this.stack[++this.stackPosition] = annos;
                    current.annosDone = true;
                    continue;
                }
                --this.stackPosition;
            }
            return next;
        }

        private void ensureStackCapacity() {
            int stackSize = this.stack.length;
            if (this.stackPosition + 1 == stackSize) {
                ATermMapping[] newStack = new ATermMapping[stackSize << 1];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
            }
        }

        private byte getHeader(IStrategoTerm term) {
            byte header = (byte)ATermConstants.ATermTypeForTerm(term);
            if (!term.getAnnotations().isEmpty()) {
                header = (byte)(header | 0x10);
            }
            return header;
        }

        protected void writeAppl(IStrategoTerm term, Object fun, String name2, boolean isString) {
            if (this.indexInTerm == 0) {
                byte header = this.getHeader(term);
                Integer key = this.applSignatures.get(fun);
                if (key == null) {
                    if (isString) {
                        header = (byte)(header | 0x20);
                    }
                    this.currentBuffer.put(header);
                    this.writeInt(term.getSubtermCount());
                    byte[] nameBytes = name2.getBytes(StandardCharsets.UTF_8);
                    int length = nameBytes.length;
                    this.writeInt(length);
                    int endIndex = length;
                    int remaining = this.currentBuffer.remaining();
                    if (remaining < endIndex) {
                        endIndex = remaining;
                    }
                    this.currentBuffer.put(nameBytes, 0, endIndex);
                    if (endIndex != length) {
                        this.indexInTerm = endIndex;
                        this.tempNameWriteBuffer = nameBytes;
                    }
                    this.applSignatures.put(fun, new Integer(this.sigKey++));
                } else {
                    header = (byte)(header | 0x40);
                    this.currentBuffer.put(header);
                    this.writeInt(key);
                }
            } else {
                int length;
                int endIndex = length = this.tempNameWriteBuffer.length;
                int remaining = this.currentBuffer.remaining();
                if (this.indexInTerm + remaining < endIndex) {
                    endIndex = this.indexInTerm + remaining;
                }
                this.currentBuffer.put(this.tempNameWriteBuffer, this.indexInTerm, endIndex - this.indexInTerm);
                this.indexInTerm = endIndex;
                if (this.indexInTerm == length) {
                    this.indexInTerm = 0;
                    this.tempNameWriteBuffer = null;
                }
            }
        }

        public void voidVisitAppl(IStrategoAppl arg) {
            this.writeAppl(arg, arg.getConstructor(), arg.getConstructor().getName(), false);
        }

        public void voidVisitInt(IStrategoInt arg) {
            this.currentBuffer.put(this.getHeader(arg));
            this.writeInt(arg.intValue());
        }

        public void voidVisitList(IStrategoList arg) {
            byte header = this.getHeader(arg);
            this.currentBuffer.put(header);
            this.writeInt(arg.size());
        }

        public void voidVisitReal(IStrategoReal arg) {
            this.currentBuffer.put(this.getHeader(arg));
            this.writeDouble(arg.realValue());
        }

        private void writeInt(int value) {
            int intValue = value;
            if ((intValue & 0xFFFFFF80) == 0) {
                this.currentBuffer.put((byte)(intValue & 0x7F));
                return;
            }
            this.currentBuffer.put((byte)(intValue & 0x7F | 0x80));
            if ((intValue & 0xFFFFC000) == 0) {
                this.currentBuffer.put((byte)(intValue >>> 7 & 0x7F));
                return;
            }
            this.currentBuffer.put((byte)(intValue >>> 7 & 0x7F | 0x80));
            if ((intValue & 0xFFE00000) == 0) {
                this.currentBuffer.put((byte)(intValue >>> 14 & 0x7F));
                return;
            }
            this.currentBuffer.put((byte)(intValue >>> 14 & 0x7F | 0x80));
            if ((intValue & 0xF0000000) == 0) {
                this.currentBuffer.put((byte)(intValue >>> 21 & 0x7F));
                return;
            }
            this.currentBuffer.put((byte)(intValue >>> 21 & 0x7F | 0x80));
            this.currentBuffer.put((byte)(intValue >>> 28 & 0x7F));
        }

        private void writeDouble(double value) {
            long longValue = Double.doubleToLongBits(value);
            this.writeLong(longValue);
        }

        private void writeLong(long value) {
            int i = 0;
            while (i < 8) {
                this.currentBuffer.put((byte)(value >>> i * 8));
                ++i;
            }
        }

        protected static class ATermMapping {
            public IStrategoTerm term;
            public int subTermIndex = -1;
            public int subTermsAfter = -1;
            public boolean annosDone = false;
            public IStrategoList nextPartOfList = null;

            protected ATermMapping() {
            }
        }
    }
}

