/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.io.TermWriter;

public interface TextTermWriter
extends TermWriter {
    @Override
    default public byte[] writeToBytes(IStrategoTerm term) {
        return this.writeToBytes(term, StandardCharsets.UTF_8);
    }

    default public byte[] writeToBytes(IStrategoTerm term, Charset characterSet) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                this.write(term, stream, characterSet);
                return stream.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage(), e);
        }
    }

    default public String writeToString(IStrategoTerm term) {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(term, sb);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage(), e);
        }
        return sb.toString();
    }

    @Override
    default public void writeToFile(IStrategoTerm term, File file) throws IOException, SecurityException {
        this.writeToFile(term, file, StandardCharsets.UTF_8);
    }

    default public void writeToFile(IStrategoTerm term, File file, Charset characterSet) throws IOException, SecurityException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fileStream = new FileOutputStream(file);){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(fileStream);){
                this.write(term, outputStream, characterSet);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    default public void writeToPath(IStrategoTerm term, Path path) throws IOException, SecurityException {
        this.writeToPath(term, path, StandardCharsets.UTF_8);
    }

    default public void writeToPath(IStrategoTerm term, Path path, Charset characterSet) throws IOException, SecurityException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(path, characterSet, new OpenOption[0]);){
            this.write(term, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public void write(IStrategoTerm term, OutputStream outputStream) throws IOException {
        this.write(term, outputStream, StandardCharsets.UTF_8);
    }

    default public void write(IStrategoTerm term, OutputStream outputStream, Charset characterSet) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, characterSet);){
            this.write(term, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(IStrategoTerm var1, Appendable var2) throws IOException;
}

