/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.util.NotImplementedException;

public class TAFTermReader {
    protected final StringBuilder sharedBuilder = new StringBuilder();
    protected final ITermFactory factory;

    public TAFTermReader(ITermFactory factory) {
        this.factory = factory;
    }

    public IStrategoTerm parseFromFile(String path) throws IOException, ParseError {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(path);){
            return this.parseFromStream(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IStrategoTerm parseFromString(String s) throws ParseError {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PushbackReader reader = new PushbackReader(new StringReader(s));){
                return this.parseFromStream(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IStrategoTerm parseFromStream(InputStream inputStream) throws IOException, ParseError {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            PushbackReader bis = new PushbackReader(new InputStreamReader(inputStream));
            IStrategoTerm iStrategoTerm = this.parseFromStream(bis);
            return iStrategoTerm;
        }
        finally {
            inputStream.close();
        }
    }

    protected IStrategoTerm parseFromStream(PushbackReader bis) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        switch (ch) {
            case 91: {
                return this.parseAnno(bis, this.parseList(bis));
            }
            case 40: {
                return this.parseAnno(bis, this.parseTuple(bis));
            }
            case 34: {
                return this.parseAnno(bis, this.parseString(bis));
            }
            case 60: {
                return this.parsePlaceholder(bis);
            }
            case 33: {
                throw new ParseError("Unsupported ATerm format: TAF");
            }
        }
        bis.unread(ch);
        if (TAFTermReader.isLetter(ch)) {
            return this.parseAnno(bis, this.parseAppl(bis));
        }
        if (TAFTermReader.isDigit(ch) || ch == 45) {
            return this.parseAnno(bis, this.parseNumber(bis));
        }
        throw new ParseError("Invalid start of term: 0x" + String.format("%04x", ch) + " '" + (char)ch + "'");
    }

    private IStrategoTerm parseAnno(PushbackReader bis, IStrategoTerm term) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == 123) {
            List<IStrategoTerm> annos = this.parseTermSequence(bis, '}');
            return this.factory.annotateTerm(term, this.factory.makeList(annos));
        }
        bis.unread(ch);
        return term;
    }

    private IStrategoTerm parseString(PushbackReader bis) throws IOException, ParseError {
        boolean escaped;
        int ch = bis.read();
        if (ch == 34) {
            return this.factory.makeString("");
        }
        StringBuilder sb = this.getSharedBuilder();
        do {
            escaped = false;
            if (ch == 92) {
                escaped = true;
                ch = bis.read();
            }
            if (escaped) {
                switch (ch) {
                    case 110: {
                        sb.append('\n');
                        break;
                    }
                    case 116: {
                        sb.append('\t');
                        break;
                    }
                    case 98: {
                        sb.append('\b');
                        break;
                    }
                    case 102: {
                        sb.append('\f');
                        break;
                    }
                    case 114: {
                        sb.append('\r');
                        break;
                    }
                    case 92: {
                        sb.append('\\');
                        break;
                    }
                    case 39: {
                        sb.append('\'');
                        break;
                    }
                    case 34: {
                        sb.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        throw new NotImplementedException();
                    }
                    default: {
                        sb.append('\\').append((char)ch);
                    }
                }
                ch = bis.read();
                continue;
            }
            if (ch == 34) continue;
            if (ch == -1) {
                throw new ParseError("Unterminated string: " + sb);
            }
            sb.append((char)ch);
            ch = bis.read();
        } while (escaped || ch != 34);
        return this.factory.makeString(sb.toString());
    }

    private IStrategoTerm parseAppl(PushbackReader bis) throws IOException, ParseError {
        StringBuilder sb = this.getSharedBuilder();
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (TAFTermReader.isConstructorChar(ch = bis.read()));
        bis.unread(ch);
        this.parseSkip(bis);
        ch = bis.read();
        String constructor = sb.toString();
        if (ch == 40) {
            List<IStrategoTerm> l = this.parseTermSequence(bis, ')');
            IStrategoConstructor c = this.factory.makeConstructor(constructor, l.size());
            return this.factory.makeAppl(c, l.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY));
        }
        bis.unread(ch);
        IStrategoConstructor c = this.factory.makeConstructor(constructor, 0);
        return this.factory.makeAppl(c, AbstractTermFactory.EMPTY_TERM_ARRAY);
    }

    private IStrategoTerm parsePlaceholder(PushbackReader bis) throws IOException, ParseError {
        IStrategoTerm template = this.parseFromStream(bis);
        this.parseSkip(bis);
        if (bis.read() != 62) {
            throw new ParseError("Expected: '>'");
        }
        return this.factory.makePlaceholder(template);
    }

    private IStrategoTerm parseTuple(PushbackReader bis) throws IOException, ParseError {
        return this.factory.makeTuple(this.parseTermSequence(bis, ')').toArray(AbstractTermFactory.EMPTY_TERM_ARRAY));
    }

    private List<IStrategoTerm> parseTermSequence(PushbackReader bis, char endChar) throws IOException, ParseError {
        List<IStrategoTerm> els = Collections.emptyList();
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == endChar) {
            return els;
        }
        els = new ArrayList<IStrategoTerm>();
        bis.unread(ch);
        do {
            els.add(this.parseFromStream(bis));
            this.parseSkip(bis);
        } while ((ch = bis.read()) == 44);
        if (ch != endChar) {
            bis.unread(ch);
            this.parseSkip(bis);
            ch = bis.read();
        }
        if (ch != endChar) {
            throw new ParseError("Sequence must end with '" + endChar + "', saw '" + (char)ch + "' '" + (char)bis.read() + "' after items " + els);
        }
        return els;
    }

    private IStrategoTerm parseList(PushbackReader bis) throws IOException, ParseError {
        return this.factory.makeList(this.parseTermSequence(bis, ']'));
    }

    private IStrategoTerm parseNumber(PushbackReader bis) throws IOException {
        String whole = this.parseDigitSequence(bis);
        int ch = bis.read();
        if (ch == 46) {
            String frac = this.parseDigitSequence(bis);
            ch = bis.read();
            if (ch == 101 || ch == 69) {
                String exp = this.parseDigitSequence(bis);
                double d = Double.parseDouble(String.valueOf(whole) + "." + frac + "e" + exp);
                return this.factory.makeReal(d);
            }
            bis.unread(ch);
            double d = Double.parseDouble(String.valueOf(whole) + "." + frac);
            return this.factory.makeReal(d);
        }
        bis.unread(ch);
        return this.factory.makeInt(Integer.parseInt(whole));
    }

    private String parseDigitSequence(PushbackReader bis) throws IOException {
        StringBuilder sb = this.getSharedBuilder();
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (TAFTermReader.isDigit(ch = bis.read()));
        bis.unread(ch);
        return sb.toString();
    }

    private void parseSkip(PushbackReader input) throws IOException {
        int b;
        block3: while (true) {
            b = input.read();
            switch (b) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        input.unread(b);
    }

    private static boolean isDigit(int ch) {
        return 48 <= ch && ch <= 57;
    }

    private static boolean isLetter(int ch) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122;
    }

    private static boolean isLetterOrDigit(int ch) {
        return TAFTermReader.isLetter(ch) || TAFTermReader.isDigit(ch);
    }

    private static boolean isConstructorChar(int ch) {
        if (TAFTermReader.isLetterOrDigit(ch)) {
            return true;
        }
        switch (ch) {
            case 36: 
            case 42: 
            case 43: 
            case 45: 
            case 95: {
                return true;
            }
        }
        return false;
    }

    private StringBuilder getSharedBuilder() {
        this.sharedBuilder.setLength(0);
        return this.sharedBuilder;
    }

    public void unparseToFile(IStrategoTerm t, OutputStream ous) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(ous));
        this.unparseToFile(t, out);
        ((Writer)out).flush();
    }

    public void unparseToFile(IStrategoTerm t, Writer out) throws IOException {
        t.writeAsString(out, Integer.MAX_VALUE);
    }
}

