/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.ObjectStreamException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.AbstractStrategoList;
import org.spoofax.terms.StrategoListIterator;

public class StrategoList
extends AbstractStrategoList {
    static final int EMPTY_LIST_HASH = 5041;
    private static final long serialVersionUID = 624120573663698628L;
    private final int size;
    private IStrategoTerm head;
    private IStrategoList tail;

    public StrategoList(IStrategoTerm head, IStrategoList tail, IStrategoList annotations) {
        super(annotations);
        if (head == null != (tail == null)) {
            throw new IllegalArgumentException("Both the head and tail must be non-null or both null.");
        }
        this.head = head;
        this.tail = tail;
        this.size = (head == null ? 0 : 1) + (tail == null ? 0 : tail.size());
    }

    public StrategoList(IStrategoList annotations) {
        this(null, null, annotations);
    }

    @Override
    public IStrategoTerm head() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public IStrategoList tail() {
        if (this.tail == null) {
            throw new IllegalStateException();
        }
        return this.tail;
    }

    @Override
    @Deprecated
    public IStrategoList prepend(IStrategoTerm prefix) {
        return new StrategoList(prefix, this, null);
    }

    @Override
    public final IStrategoTerm get(int index) {
        return this.getSubterm(index);
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        int size = this.size();
        IStrategoTerm[] clone = new IStrategoTerm[size];
        IStrategoList list2 = this;
        int i = 0;
        while (i < size) {
            clone[i] = list2.head();
            list2 = list2.tail();
            ++i;
        }
        return clone;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        IStrategoList list2 = this;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        int i = 0;
        while (i < index) {
            if (list2.isEmpty()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            list2 = list2.tail();
            ++i;
        }
        return list2.head();
    }

    @Override
    public int getSubtermCount() {
        return this.size;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        if (second.getType() != TermType.LIST) {
            return false;
        }
        IStrategoList snd = (IStrategoList)second;
        if (this.size() != snd.size()) {
            return false;
        }
        if (!this.isEmpty()) {
            IStrategoTerm head2;
            IStrategoTerm head = this.head();
            if (head != (head2 = snd.head()) && !head.match(head2)) {
                return false;
            }
            IStrategoList tail = this.tail();
            IStrategoList tail2 = snd.tail();
            IStrategoList cons = tail;
            IStrategoList cons2 = tail2;
            while (!cons.isEmpty()) {
                IStrategoTerm cons2Head;
                IStrategoTerm consHead = cons.head();
                if (consHead != (cons2Head = cons2.head()) && !consHead.match(cons2Head)) {
                    return false;
                }
                cons = cons.tail();
                cons2 = cons2.tail();
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new StrategoListIterator(this);
    }

    private Object readResolve() throws ObjectStreamException {
        return this;
    }
}

