/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.EmptyIterator;

public final class StrategoConstructor
extends StrategoTerm
implements IStrategoConstructor {
    private static final long serialVersionUID = -4477361122406081825L;
    private final String name;
    private final int arity;

    public StrategoConstructor(String name2, int arity2) {
        super(null);
        this.name = name2;
        this.arity = arity2;
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return Collections.emptyList();
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY_TERM_ARRAY;
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public TermType getType() {
        return TermType.CTOR;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        if (second == this) {
            return true;
        }
        if (second == null || second.getType() != TermType.CTOR) {
            return false;
        }
        IStrategoConstructor other = (IStrategoConstructor)second;
        return this.name.equals(other.getName()) && this.arity == other.getArity();
    }

    @Override
    public void prettyPrint(ITermPrinter pp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + "`" + this.arity;
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.name);
        output.append('`');
        output.append(Integer.toString(this.arity));
    }

    public IStrategoConstructor getConstructor() {
        return this;
    }

    @Override
    public int hashFunction() {
        return this.name.hashCode() + 5407 * this.arity;
    }

    @Override
    @Deprecated
    public IStrategoAppl instantiate(ITermFactory factory, IStrategoTerm ... kids) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IStrategoAppl instantiate(ITermFactory factory, IStrategoList kids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EmptyIterator<IStrategoTerm>();
    }

    private Object readResolve() {
        StrategoConstructor cachedConstructor = AbstractTermFactory.createCachedConstructor(this.name, this.arity);
        return cachedConstructor;
    }
}

