/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.inputstack.incremental;

import java.util.List;
import org.metaborg.util.functions.Function4;
import org.spoofax.jsglr2.incremental.EditorUpdate;
import org.spoofax.jsglr2.incremental.diff.IStringDiff;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalSkippedNode;
import org.spoofax.jsglr2.inputstack.incremental.AbstractPreprocessingIncrementalInputStack;
import org.spoofax.jsglr2.inputstack.incremental.IIncrementalInputStack;
import org.spoofax.jsglr2.inputstack.incremental.IncrementalInputStackFactory;
import org.spoofax.jsglr2.inputstack.incremental.StringIncrementalInputStack;

public abstract class AbstractIncrementalInputStack
extends AbstractPreprocessingIncrementalInputStack
implements IIncrementalInputStack {
    private final String previousInput;
    private final List<EditorUpdate> editorUpdates;
    private int currentUpdateIndex = 0;
    private EditorUpdate currentUpdate = null;
    private boolean updateIsExposed = false;
    private int currentOffsetInPrevious = 0;

    AbstractIncrementalInputStack(AbstractIncrementalInputStack original) {
        super(original);
        this.previousInput = original.previousInput;
        this.editorUpdates = original.editorUpdates;
        this.currentUpdateIndex = original.currentUpdateIndex;
        this.currentUpdate = original.currentUpdate;
        this.updateIsExposed = original.updateIsExposed;
        this.currentOffsetInPrevious = original.currentOffsetInPrevious;
    }

    public AbstractIncrementalInputStack(String input, String previousInput, IncrementalParseForest previousResult, List<EditorUpdate> editorUpdates) {
        super(previousResult, input);
        this.previousInput = previousInput;
        this.editorUpdates = editorUpdates;
        if (editorUpdates.isEmpty()) {
            return;
        }
        this.currentUpdate = editorUpdates.get(0);
        this.checkUpdate();
    }

    static IncrementalInputStackFactory<IIncrementalInputStack> factoryBuilder(IStringDiff diff, Function4<String, String, IncrementalParseForest, List<EditorUpdate>, IIncrementalInputStack> constructor) {
        return (inputString, previousInput, previousResult) -> {
            if (previousInput != null && previousResult != null) {
                List<EditorUpdate> editorUpdates = diff.diff(previousInput, inputString);
                if (editorUpdates.size() == 1 && editorUpdates.get((int)0).deletedStart == 0 && editorUpdates.get((int)0).deletedEnd == previousResult.width()) {
                    return new StringIncrementalInputStack(inputString);
                }
                return (IIncrementalInputStack)constructor.apply(inputString, previousInput, previousResult, editorUpdates);
            }
            return new StringIncrementalInputStack(inputString);
        };
    }

    @Override
    public void breakDown() {
        do {
            if (this.stack.isEmpty()) {
                return;
            }
            IncrementalParseForest current = (IncrementalParseForest)this.stack.peek();
            if (current.isTerminal()) {
                return;
            }
            this.stack.pop();
            if (current instanceof IncrementalSkippedNode) {
                this.pushCharactersToStack(this.previousInput.substring(this.currentOffsetInPrevious, this.currentOffsetInPrevious + current.width()));
            } else {
                IncrementalParseForest[] children = ((IncrementalParseNode)current).getFirstDerivation().parseForests();
                int i = children.length - 1;
                while (i >= 0) {
                    this.stack.push(children[i]);
                    --i;
                }
            }
            if (!this.updateIsAtStartOfNextNode()) continue;
            this.updateIsExposed = true;
        } while (this.currentNodeHasChange());
    }

    @Override
    public void next() {
        IncrementalParseForest popped = (IncrementalParseForest)this.stack.pop();
        int increase = popped.width();
        assert (this.isCorrectYield(popped, increase)) : "Yield of popped node must be equal to the substring in the input";
        this.currentOffset += increase;
        this.currentOffsetInPrevious += increase;
        this.checkUpdate();
    }

    private boolean isCorrectYield(IncrementalParseForest popped, int increase) {
        try {
            return popped.getYield().equals(this.inputString.substring(Integer.min(this.currentOffset, this.inputLength), Integer.min(this.currentOffset + increase, this.inputLength)));
        }
        catch (UnsupportedOperationException e) {
            if (e.getMessage().equals("Cannot get yield of skipped parse node")) {
                return true;
            }
            throw e;
        }
    }

    private void checkUpdate() {
        if (this.currentUpdate != null && this.currentOffsetInPrevious == this.currentUpdate.deletedStart) {
            while (this.currentOffsetInPrevious < this.currentUpdate.deletedEnd) {
                if (this.currentOffsetInPrevious + ((IncrementalParseForest)this.stack.peek()).width() > this.currentUpdate.deletedEnd) {
                    this.breakDown();
                    continue;
                }
                this.currentOffsetInPrevious += ((IncrementalParseForest)this.stack.pop()).width();
            }
            while (((IncrementalParseForest)this.stack.peek()).width() == 0) {
                this.stack.pop();
            }
            this.currentOffsetInPrevious -= this.currentUpdate.insertedLength();
            this.pushCharactersToStack(this.currentUpdate.inserted);
            this.currentUpdate = ++this.currentUpdateIndex >= this.editorUpdates.size() ? null : this.editorUpdates.get(this.currentUpdateIndex);
            this.updateIsExposed = false;
        }
        if (this.currentNodeHasChange()) {
            this.breakDown();
        }
    }

    private boolean currentNodeHasChange() {
        IncrementalParseForest node = this.getNode();
        if (node == null || this.currentUpdate == null) {
            return false;
        }
        return this.currentUpdate.deletedStart < this.currentOffsetInPrevious + node.width() + 1;
    }

    private boolean updateIsAtStartOfNextNode() {
        IncrementalParseForest node = this.getNode();
        if (node == null || this.currentUpdate == null) {
            return false;
        }
        return this.currentUpdate.deletedStart == this.currentOffsetInPrevious + node.width();
    }

    @Override
    public boolean lookaheadIsUnchanged() {
        return !this.updateIsExposed;
    }
}

