/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.actions.Accept;
import org.metaborg.parsetable.actions.ActionType;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.actions.IShift;
import org.metaborg.parsetable.query.IActionQuery;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.incremental.IIncrementalParseState;
import org.spoofax.jsglr2.incremental.actions.GotoShift;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalDerivation;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalSkippedNode;
import org.spoofax.jsglr2.inputstack.incremental.IIncrementalInputStack;
import org.spoofax.jsglr2.inputstack.incremental.IncrementalInputStackFactory;
import org.spoofax.jsglr2.parseforest.Disambiguator;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseForestManagerFactory;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.ForShifterElement;
import org.spoofax.jsglr2.parser.ParseException;
import org.spoofax.jsglr2.parser.ParseReporterFactory;
import org.spoofax.jsglr2.parser.ParseStateFactory;
import org.spoofax.jsglr2.parser.Parser;
import org.spoofax.jsglr2.parser.failure.ParseFailureHandlerFactory;
import org.spoofax.jsglr2.parser.observing.IParserObserver;
import org.spoofax.jsglr2.reducing.ReduceManager;
import org.spoofax.jsglr2.reducing.ReduceManagerFactory;
import org.spoofax.jsglr2.stack.AbstractStackManager;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.StackManagerFactory;

public class IncrementalParser<StackNode extends IStackNode, ParseState extends AbstractParseState<IIncrementalInputStack, StackNode>, StackManager extends AbstractStackManager<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, ParseState>, ReduceManager extends ReduceManager<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, IIncrementalInputStack, ParseState>>
extends Parser<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, IIncrementalInputStack, ParseState, StackManager, ReduceManager> {
    private final IncrementalInputStackFactory<IIncrementalInputStack> incrementalInputStackFactory;

    public IncrementalParser(IncrementalInputStackFactory<IIncrementalInputStack> incrementalInputStackFactory, ParseStateFactory<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, IIncrementalInputStack, StackNode, ParseState> parseStateFactory, IParseTable parseTable, StackManagerFactory<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, ParseState, StackManager> stackManagerFactory, ParseForestManagerFactory<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, ParseState> parseForestManagerFactory, Disambiguator<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, ParseState> disambiguator, ReduceManagerFactory<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, IIncrementalInputStack, ParseState, StackManager, ReduceManager> reduceManagerFactory, ParseFailureHandlerFactory<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, ParseState> failureHandlerFactory, ParseReporterFactory<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, IIncrementalInputStack, ParseState> reporterFactory) {
        super(null, parseStateFactory, parseTable, stackManagerFactory, parseForestManagerFactory, disambiguator, reduceManagerFactory, failureHandlerFactory, reporterFactory);
        this.incrementalInputStackFactory = incrementalInputStackFactory;
    }

    @Override
    protected ParseState getParseState(JSGLR2Request request, String previousInput, IncrementalParseForest previousResult) {
        return this.parseStateFactory.get(request, this.incrementalInputStackFactory.get(request.input, previousInput, previousResult), this.observing);
    }

    @Override
    protected void parseLoop(ParseState parseState) throws ParseException {
        if (!this.attemptToFullyReuse(parseState)) {
            super.parseLoop(parseState);
        }
    }

    private boolean attemptToFullyReuse(ParseState parseState) {
        if (((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).offset() != 0 || ((AbstractParseState)parseState).activeStacks.getSingle().state().id() != this.parseTable.getStartState().id()) {
            return false;
        }
        IncrementalParseForest node = ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode();
        if (node.isTerminal()) {
            return false;
        }
        IncrementalParseNode rootNode = (IncrementalParseNode)node;
        if (rootNode.production() == null) {
            return false;
        }
        if (!rootNode.production().lhs().descriptor().equals("<START>")) {
            return false;
        }
        Object stack = ((AbstractParseState)parseState).activeStacks.getSingle();
        this.addForShifter(parseState, stack, this.parseTable.getState(stack.state().getGotoId(rootNode.production().id())));
        this.shifter(parseState);
        ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).next();
        this.actor(((AbstractParseState)parseState).activeStacks.getSingle(), parseState, Accept.SINGLETON);
        return true;
    }

    @Override
    protected void actor(StackNode stack, ParseState parseState) {
        IncrementalParseForest originalLookahead = ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode();
        Iterable<IAction> actions = this.breakDownUntilValidActions(stack, parseState);
        if (!((AbstractParseState)parseState).forShifter.isEmpty() && ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode() != originalLookahead) {
            this.updateForShifterStates(parseState);
        }
        if (IncrementalParser.hasMoreThanOne(actions)) {
            ((IIncrementalParseState)parseState).setMultipleStates(true);
        }
        this.observing.notify(observer -> observer.actor(stack, parseState, actions));
        for (IAction action : actions) {
            this.actor(stack, parseState, action);
        }
    }

    public static boolean hasMoreThanOne(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size() > 1;
        }
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        iterator.next();
        return iterator.hasNext();
    }

    private Iterable<IAction> breakDownUntilValidActions(StackNode stack, ParseState parseState) {
        Iterable<IAction> originalActions = stack.state().getApplicableActions((IActionQuery)((AbstractParseState)parseState).inputStack, ((AbstractParseState)parseState).mode);
        IncrementalParseForest lookahead = ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode();
        if (lookahead.isTerminal()) {
            return originalActions;
        }
        boolean hasShiftActions = false;
        for (IAction action : originalActions) {
            if (action.actionType() != ActionType.SHIFT) continue;
            hasShiftActions = true;
            break;
        }
        do {
            IncrementalParseNode lookaheadNode;
            if ((lookaheadNode = (IncrementalParseNode)lookahead).isReusable(stack.state())) {
                return this.reduceActionsAndGotoShift(stack, parseState, lookaheadNode, originalActions);
            }
            if (lookaheadNode.isReusable() && !hasShiftActions) {
                return originalActions;
            }
            if (!((AbstractParseState)parseState).forShifter.isEmpty() && ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).lookaheadIsUnchanged()) {
                return Collections.emptyList();
            }
            this.observing.notify(observer -> observer.breakDown((IIncrementalInputStack)abstractParseState.inputStack, lookaheadNode.production() == null ? IParserObserver.BreakdownReason.TEMPORARY : (lookaheadNode.isReusable() ? (lookaheadNode.isReusable(stack.state()) ? IParserObserver.BreakdownReason.NO_ACTIONS : IParserObserver.BreakdownReason.WRONG_STATE) : IParserObserver.BreakdownReason.IRREUSABLE)));
            ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).breakDown();
            this.observing.notify(observer -> observer.parseRound(parseState, abstractParseState.activeStacks));
            if (((AbstractParseState)parseState).forShifter.isEmpty() || !(lookaheadNode instanceof IncrementalSkippedNode ? lookaheadNode.width() == 0 : lookaheadNode.getFirstDerivation().parseForests.length == 0)) continue;
            ((AbstractParseState)parseState).forShifter.clear();
        } while (!(lookahead = ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode()).isTerminal());
        return originalActions;
    }

    private void updateForShifterStates(ParseState parseState) {
        ArrayList oldForShifter = new ArrayList(((AbstractParseState)parseState).forShifter);
        ((AbstractParseState)parseState).forShifter.clear();
        IncrementalParseForest newLookaheadNode = ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode();
        if (newLookaheadNode instanceof IParseNode) {
            int n = ((IParseNode)((Object)newLookaheadNode)).production().id();
            for (ForShifterElement forShifterElement : oldForShifter) {
                Object forShifterStack = forShifterElement.stack;
                this.addForShifter(parseState, forShifterStack, this.parseTable.getState(forShifterStack.state().getGotoId(n)));
            }
        } else {
            for (ForShifterElement forShifterElement : oldForShifter) {
                Object forShifterStack = forShifterElement.stack;
                for (IAction action : forShifterStack.state().getApplicableActions((IActionQuery)((AbstractParseState)parseState).inputStack, ((AbstractParseState)parseState).mode)) {
                    if (action.actionType() != ActionType.SHIFT) continue;
                    this.addForShifter(parseState, forShifterStack, this.parseTable.getState(((IShift)action).shiftStateId()));
                }
            }
        }
    }

    private List<IAction> reduceActionsAndGotoShift(StackNode stack, ParseState parseState, IncrementalParseNode lookaheadNode, Iterable<IAction> originalActions) {
        GotoShift gotoShift = new GotoShift(stack.state().getGotoId(lookaheadNode.production().id()));
        ArrayList<IAction> filteredActions = new ArrayList<IAction>();
        Iterables.addAll(filteredActions, (Iterable)Iterables.filter(originalActions, a -> a.actionType() != ActionType.SHIFT));
        if (((IIncrementalParseState)parseState).newParseNodesAreReusable() && this.nullReduceMatchesLookahead(stack, filteredActions, lookaheadNode)) {
            return Collections.singletonList(gotoShift);
        }
        filteredActions.add(gotoShift);
        return filteredActions;
    }

    private boolean nullReduceMatchesLookahead(StackNode stack, List<IAction> reduceActions, IncrementalParseNode lookaheadNode) {
        if (reduceActions.isEmpty() || lookaheadNode instanceof IncrementalSkippedNode) {
            return false;
        }
        int[] reduceActionProductions = new int[reduceActions.size()];
        int i = 0;
        for (IAction action : reduceActions) {
            IReduce reduceAction = (IReduce)action;
            if (reduceAction.arity() != 0) {
                return false;
            }
            reduceActionProductions[i++] = reduceAction.production().id();
        }
        while (true) {
            IncrementalParseForest[] children;
            if ((children = lookaheadNode.getFirstDerivation().parseForests).length == 0 && lookaheadNode.width() == 0) {
                IState state = stack.state();
                int lookaheadNodeGotoId = state.getGotoId(lookaheadNode.production().id());
                int[] nArray = reduceActionProductions;
                int n = reduceActionProductions.length;
                int n2 = 0;
                while (n2 < n) {
                    int reduceActionProduction = nArray[n2];
                    if (state.getGotoId(reduceActionProduction) == lookaheadNodeGotoId) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            IncrementalParseForest child = children[0];
            if (child.isTerminal() || child instanceof IncrementalSkippedNode) {
                return false;
            }
            lookaheadNode = (IncrementalParseNode)child;
        }
    }

    @Override
    protected IncrementalParseForest getNodeToShift(ParseState parseState) {
        return ((IIncrementalInputStack)((AbstractParseState)parseState).inputStack).getNode();
    }
}

